/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static String createIndentString(int indent) {
        String str = CodeFormatterUtil.format(1, "x", indent, null, "", (Map)null);
        return str.substring(0, str.indexOf(120));
    }

    public static int getTabWidth() {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        return preferences.getInt("org.eclipse.jdt.core.formatter.tabulation.size");
    }

    public static String format(int kind, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        return CodeFormatterUtil.format(kind, string, 0, string.length(), indentationLevel, positions, lineSeparator, options);
    }

    public static String format(int kind, String string, int indentationLevel, int[] positions, String lineSeparator, IJavaProject project) {
        Map options = project != null ? project.getOptions(true) : null;
        return CodeFormatterUtil.format(kind, string, 0, string.length(), indentationLevel, positions, lineSeparator, options);
    }

    public static String format(int kind, String string, int offset, int length, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(kind, string, offset, length, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return string.substring(offset, offset + length);
        }
        String formatted = CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
        return formatted.substring(offset, formatted.length() - (string.length() - (offset + length)));
    }

    public static String format(ASTNode node, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(node, string, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return string;
        }
        return CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
    }

    private static String getOldAPICompatibleResult(String string, TextEdit edit, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            for (int i = 0; i < positions.length; ++i) {
                p[i] = new Position(positions[i], 0);
            }
        }
        String res = CodeFormatterUtil.evaluateFormatterEdit(string, edit, p);
        if (positions != null) {
            for (int i = 0; i < positions.length; ++i) {
                Position curr = p[i];
                positions[i] = curr.getOffset();
            }
        }
        return res;
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                for (int i = 0; i < positions.length; ++i) {
                    Assert.isTrue(!positions[i].isDeleted, "Position got deleted");
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            Assert.isTrue(false, "Fromatter created edits with wrong positions: " + e.getMessage());
            return null;
        }
    }

    public static TextEdit format2(int kind, String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter((Map)options).format(kind, string, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit format2(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.format2(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    /*
     * WARNING - void declaration
     */
    public static TextEdit format2(ASTNode node, String str, int indentationLevel, String lineSeparator, Map options) {
        void var5_7;
        int code;
        String prefix = "";
        String suffix = "";
        if (node instanceof Statement) {
            code = 2;
            if (node.getNodeType() == 49) {
                prefix = "switch(1) {";
                suffix = "}";
                code = 2;
            }
        } else if (node instanceof Expression && node.getNodeType() != 58) {
            code = 1;
        } else {
            switch (node.getNodeType()) {
                case 23: 
                case 28: 
                case 31: 
                case 55: {
                    code = 4;
                    break;
                }
                case 5: 
                case 39: 
                case 43: {
                    suffix = " x;";
                    code = 1;
                    break;
                }
                case 15: {
                    code = 8;
                    break;
                }
                case 44: 
                case 58: {
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 59: {
                    prefix = "A ";
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 26: 
                case 35: {
                    suffix = "\nclass A {}";
                    code = 8;
                    break;
                }
                case 29: {
                    suffix = "void foo();";
                    code = 4;
                    break;
                }
                case 12: {
                    prefix = "try {}";
                    code = 2;
                    break;
                }
                case 1: {
                    prefix = "new A()";
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: {
                    return null;
                }
                default: {
                    Assert.isTrue(false, "Node type not covered: " + node.getClass().getName());
                    return null;
                }
            }
        }
        String concatStr = prefix + str + suffix;
        TextEdit edit = CodeFormatterUtil.format2((int)var5_7, concatStr, prefix.length(), str.length(), indentationLevel, lineSeparator, options);
        if (prefix.length() > 0) {
            edit = CodeFormatterUtil.shifEdit(edit, prefix.length());
        }
        return edit;
    }

    /*
     * WARNING - void declaration
     */
    private static TextEdit shifEdit(TextEdit oldEdit, int diff) {
        void var2_3;
        MultiTextEdit newEdit;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            newEdit = new ReplaceEdit(edit.getOffset() - diff, edit.getLength(), edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            newEdit = new InsertEdit(edit.getOffset() - diff, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            newEdit = new DeleteEdit(edit.getOffset() - diff, edit.getLength());
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        for (int i = 0; i < children.length; ++i) {
            TextEdit shifted = CodeFormatterUtil.shifEdit(children[i], diff);
            if (shifted == null) continue;
            var2_3.addChild(shifted);
        }
        return var2_3;
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc = new Document(string);
        try {
            if (positions != null) {
                String POS_CATEGORY = "myCategory";
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                for (int i = 0; i < positions.length; ++i) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                        continue;
                    }
                    catch (BadLocationException e) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                }
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        return doc;
    }
}

