/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.eclipse.team.internal.ccvs.ssh.Policy;

class Misc {
    private static MessageDigest md5 = null;
    private static SecureRandom random = null;
    private static long[] crc32_tab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    Misc() {
    }

    public static long crc32(byte[] b, int off, int len) {
        return Misc.crc32(b, off, len, 0L);
    }

    public static long crc32(byte[] b, int off, int len, long crc32val) {
        for (int i = 0; i < len; ++i) {
            crc32val = crc32_tab[(int)((crc32val ^ (long)b[off + i]) & 0xFFL)] ^ crc32val >> 8;
        }
        return crc32val;
    }

    public static byte[] lengthEncode(byte[] b, int off, int len) throws IOException {
        byte[] result = new byte[len + 4];
        Misc.writeInt(len, result, 0);
        System.arraycopy(b, off, result, 4, len);
        return result;
    }

    public static byte[] readMpInt(InputStream is) throws IOException {
        int a = is.read();
        int b = is.read();
        if (a == -1 || b == -1) {
            throw new IOException(Policy.bind("stream"));
        }
        int bits = ((a & 0xFF) << 8) + (b & 0xFF);
        int bytes = (bits + 7) / 8;
        byte[] result = new byte[bytes];
        Misc.readFully(is, result);
        return result;
    }

    public static byte[] md5(byte[] b) throws IOException {
        if (md5 == null) {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(Policy.bind("Misc.missingMD5", e.getMessage()));
            }
        }
        return md5.digest(b);
    }

    public static byte[] md5(String s) throws IOException {
        return Misc.md5(s.getBytes());
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        Misc.readFully(is, b, 0, b.length);
    }

    public static void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        int bytesRead = 0;
        for (int totalBytesRead = 0; totalBytesRead < len; totalBytesRead += bytesRead) {
            bytesRead = is.read(b, totalBytesRead + off, len - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new IOException(Policy.bind("stream"));
        }
    }

    public static int readInt(byte[] arr, int off) throws IOException {
        int a = arr[off] & 0xFF;
        int b = arr[off + 1] & 0xFF;
        int c = arr[off + 2] & 0xFF;
        int d = arr[off + 3] & 0xFF;
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static int readInt(InputStream is) throws IOException {
        int a = is.read();
        int b = is.read();
        int c = is.read();
        int d = is.read();
        if (a == -1 || b == -1 || c == -1 || d == -1) {
            throw new IOException(Policy.bind("stream"));
        }
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static String readString(InputStream is) throws IOException {
        int size = Misc.readInt(is);
        byte[] buffer = new byte[size];
        for (int i = 0; i < buffer.length; ++i) {
            int next = is.read();
            if (next == -1) {
                throw new IOException(Policy.bind("stream"));
            }
            buffer[i] = (byte)next;
        }
        return new String(buffer);
    }

    public static void skipFully(InputStream is, long n) throws IOException {
        while (n != 0L) {
            int b = is.read();
            if (b == -1) {
                if (n > 0L) {
                    throw new IOException(Policy.bind("stream"));
                }
                return;
            }
            --n;
        }
    }

    public static void writeInt(int i, byte[] b, int off) {
        b[off] = (byte)(i >> 24 & 0xFF);
        b[off + 1] = (byte)(i >> 16 & 0xFF);
        b[off + 2] = (byte)(i >> 8 & 0xFF);
        b[off + 3] = (byte)(i & 0xFF);
    }

    public static void xor(byte[] src_a, int off_a, byte[] src_b, int off_b, byte[] dst, int dst_off, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + dst_off] = (byte)(src_a[i + off_a] ^ src_b[i + off_b]);
        }
    }

    public static void random(byte[] b, int off, int len, boolean allowZeroBytes) {
        if (random == null) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                random = new SecureRandom();
            }
        }
        for (int i = off; i < off + len; ++i) {
            do {
                b[i] = (byte)random.nextInt();
            } while (!allowZeroBytes && b[i] == 0);
        }
    }

    public static byte[] encryptRSAPkcs1(byte[] data, byte[] public_key_exponent, byte[] public_key_modulus) {
        int offset = 0;
        byte[] block = new byte[public_key_modulus.length];
        block[offset++] = 0;
        block[offset++] = 2;
        Misc.random(block, offset, block.length - data.length - 3, false);
        offset += block.length - data.length - 3;
        block[offset++] = 0;
        for (int i = 0; i < data.length; ++i) {
            block[offset++] = data[i];
        }
        BigInteger m = new BigInteger(1, public_key_modulus);
        BigInteger e = new BigInteger(1, public_key_exponent);
        BigInteger message = new BigInteger(1, block);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[public_key_modulus.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        for (int i = messageByte.length - messageByteTemp.length + tempOffset; i < messageByte.length; ++i) {
            messageByte[i] = messageByteTemp[tempOffset++];
        }
        return messageByte;
    }
}

