/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.memory;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingInfo;

public class MemoryRenderingInfo
implements IMemoryRenderingInfo {
    private String fRenderingId;
    private String fName;
    private Hashtable fProperties;
    private IConfigurationElement fElement;
    private static final String VALUE = "value";

    public MemoryRenderingInfo(String renderingId, String name, IConfigurationElement element) {
        this.fRenderingId = renderingId;
        this.fName = name;
        this.fElement = element;
    }

    public String getRenderingId() {
        return this.fRenderingId;
    }

    public String getName() {
        return this.fName;
    }

    public void addProperty(String propertyId, IConfigurationElement element) {
        if (this.fProperties == null) {
            this.fProperties = new Hashtable();
        }
        if (propertyId != null && element != null) {
            this.fProperties.put(propertyId, element);
        }
    }

    public String getProperty(String propertyId) {
        if (this.fProperties != null) {
            IConfigurationElement element = (IConfigurationElement)this.fProperties.get(propertyId);
            if (element != null) {
                String ret = element.getAttribute(VALUE);
                return ret;
            }
            return null;
        }
        return null;
    }

    public IConfigurationElement getConfigElement() {
        return this.fElement;
    }

    public IConfigurationElement getPropertyConfigElement(String propertyId) {
        if (this.fProperties != null) {
            IConfigurationElement element = (IConfigurationElement)this.fProperties.get(propertyId);
            return element;
        }
        return null;
    }

    public IConfigurationElement[] getAllProperties() {
        Enumeration enumeration = this.fProperties.elements();
        IConfigurationElement[] elements = new IConfigurationElement[this.fProperties.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            elements[i] = (IConfigurationElement)enumeration.nextElement();
            ++i;
        }
        return elements;
    }
}

