/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformRegistryLoader;

public class ExternalModelManager {
    private List fModels;
    private List fFragmentModels;
    private Vector fListeners = new Vector();
    private PDEState fState = null;
    private boolean fInitialized = false;

    public ExternalModelManager() {
        this.fModels = Collections.synchronizedList(new ArrayList());
        this.fFragmentModels = Collections.synchronizedList(new ArrayList());
    }

    public static String computeDefaultPlatformPath() {
        URL installURL = Platform.getInstallLocation().getURL();
        IPath ppath = new Path(installURL.getFile()).removeTrailingSeparator();
        return ExternalModelManager.getCorrectPath(ppath.toOSString());
    }

    public static boolean isTargetEqualToHost(String platformPath) {
        return ExternalModelManager.arePathsEqual((IPath)new Path(platformPath), (IPath)new Path(ExternalModelManager.computeDefaultPlatformPath()));
    }

    private static String getCorrectPath(String path) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (Platform.getOS().equals("win32") && i == 0 && c == '/') continue;
            if (c == '%' && i + 2 < path.length()) {
                char c1 = path.charAt(i + 1);
                char c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                    buf.append(" ");
                    continue;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static IPath getEclipseHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return new Path(preferences.getString("platform_path"));
    }

    public static boolean arePathsEqual(IPath path1, IPath path2) {
        String device = path1.getDevice();
        if (device != null) {
            path1 = path1.setDevice(device.toUpperCase());
        }
        if ((device = path2.getDevice()) != null) {
            path2 = path2.setDevice(device.toUpperCase());
        }
        return path1.equals(path2);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    private Vector createSavedList(String saved) {
        Vector<String> result = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(saved);
        while (stok.hasMoreTokens()) {
            result.add(stok.nextToken());
        }
        return result;
    }

    private void enableAll() {
        int i;
        for (i = 0; i < this.fModels.size(); ++i) {
            ((IPluginModel)this.fModels.get(i)).setEnabled(true);
        }
        for (i = 0; i < this.fFragmentModels.size(); ++i) {
            ((IFragmentModel)this.fFragmentModels.get(i)).setEnabled(true);
        }
    }

    public void fireModelProviderEvent(IModelProviderEvent e) {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IModelProviderListener listener = (IModelProviderListener)iter.next();
            listener.modelsChanged(e);
        }
    }

    public IPluginModelBase[] getAllModels() {
        this.loadModels((IProgressMonitor)new NullProgressMonitor());
        IPluginModelBase[] allModels = new IPluginModelBase[this.fModels.size() + this.fFragmentModels.size()];
        System.arraycopy(this.fModels.toArray(), 0, allModels, 0, this.fModels.size());
        System.arraycopy(this.fFragmentModels.toArray(), 0, allModels, this.fModels.size(), this.fFragmentModels.size());
        return allModels;
    }

    private void initializeAllModels() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String saved = pref.getString("checkedPlugins");
        if (saved.equals("[savedAll]")) {
            this.enableAll();
        } else if (!saved.equals("[savedNone]")) {
            int i;
            Vector list = this.createSavedList(saved);
            for (i = 0; i < this.fModels.size(); ++i) {
                IPluginModel model;
                model.setEnabled(!list.contains((model = (IPluginModel)this.fModels.get(i)).getPlugin().getId()));
            }
            for (i = 0; i < this.fFragmentModels.size(); ++i) {
                IFragmentModel fmodel;
                fmodel.setEnabled(!list.contains((fmodel = (IFragmentModel)this.fFragmentModels.get(i)).getFragment().getId()));
            }
        }
    }

    private synchronized void loadModels(IProgressMonitor monitor) {
        if (this.fInitialized) {
            return;
        }
        this.fState = new PDEState();
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        URL[] pluginPaths = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        IPluginModelBase[] resolved = TargetPlatformRegistryLoader.loadModels(pluginPaths, true, this.fState, monitor);
        for (int i = 0; i < resolved.length; ++i) {
            if (resolved[i] instanceof IPluginModel) {
                this.fModels.add(resolved[i]);
                continue;
            }
            this.fFragmentModels.add(resolved[i]);
        }
        this.initializeAllModels();
        this.fInitialized = true;
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public void reset(PDEState state, IPluginModelBase[] newModels) {
        this.fState = state;
        PDECore.getDefault().getModelManager().addWorkspaceBundlesToState();
        this.fModels.clear();
        this.fFragmentModels.clear();
        for (int i = 0; i < newModels.length; ++i) {
            if (newModels[i] instanceof IPluginModel) {
                this.fModels.add(newModels[i]);
                continue;
            }
            this.fFragmentModels.add(newModels[i]);
        }
    }

    public void shutdown() {
        int i;
        int disabled = 0;
        StringBuffer saved = new StringBuffer();
        for (i = 0; i < this.fModels.size(); ++i) {
            IPluginModel model = (IPluginModel)this.fModels.get(i);
            if (model.isEnabled()) continue;
            ++disabled;
            if (saved.length() > 0) {
                saved.append(" ");
            }
            saved.append(model.getPlugin().getId());
        }
        for (i = 0; i < this.fFragmentModels.size(); ++i) {
            IFragmentModel fmodel = (IFragmentModel)this.fFragmentModels.get(i);
            if (fmodel.isEnabled()) continue;
            ++disabled;
            if (saved.length() > 0) {
                saved.append(" ");
            }
            saved.append(fmodel.getFragment().getId());
        }
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        if (disabled == 0) {
            pref.setValue("checkedPlugins", "[savedAll]");
        } else if (disabled == this.fModels.size() + this.fFragmentModels.size()) {
            pref.setValue("checkedPlugins", "[savedNone]");
        } else {
            pref.setValue("checkedPlugins", saved.toString());
        }
        PDECore.getDefault().savePluginPreferences();
    }

    public PDEState getState() {
        this.loadModels((IProgressMonitor)new NullProgressMonitor());
        return this.fState;
    }
}

