/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.r21;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class R21Colors {
    private static boolean init = false;
    private static HashMap colorMap;
    private static HashMap systemColorMap;
    private static Color[] workbenchColors;
    private static Color[] activeViewGradient;
    private static Color[] deactivatedViewGradient;
    private static Color[] activeEditorGradient;
    private static Color[] activeNoFocusEditorGradient;
    private static Color[] deactivatedEditorGradient;
    private static int[] activeViewPercentages;
    private static int[] deactivatedViewPercentages;
    private static int[] activeEditorPercentages;
    private static int[] activeNoFocusEditorPercentages;
    private static int[] deactivatedEditorPercentages;
    private static final String CLR_VIEW_GRAD_START = "clrViewGradStart";
    private static final String CLR_VIEW_GRAD_END = "clrViewGradEnd";
    private static final String CLR_EDITOR_GRAD_START = "clrEditorGradStart";
    private static final String CLR_EDITOR_GRAD_END = "clrEditorGradEnd";

    private static void disposeWorkbenchColors() {
        for (int i = 0; i < workbenchColors.length; ++i) {
            workbenchColors[i].dispose();
        }
    }

    public static Color[] getActiveEditorGradient() {
        return activeEditorGradient;
    }

    public static Color getActiveEditorGradientEnd() {
        Color clr = (Color)systemColorMap.get(CLR_EDITOR_GRAD_END);
        Assert.isNotNull((Object)clr);
        return clr;
    }

    public static int[] getActiveEditorGradientPercents() {
        return activeEditorPercentages;
    }

    public static Color getActiveEditorGradientStart() {
        Color clr = (Color)systemColorMap.get(CLR_EDITOR_GRAD_START);
        Assert.isNotNull((Object)clr);
        return clr;
    }

    public static Color[] getActiveNoFocusEditorGradient() {
        return activeNoFocusEditorGradient;
    }

    public static int[] getActiveNoFocusEditorGradientPercents() {
        return activeNoFocusEditorPercentages;
    }

    public static Color[] getActiveViewGradient() {
        return activeViewGradient;
    }

    public static Color getActiveViewGradientEnd() {
        Color clr = (Color)systemColorMap.get(CLR_VIEW_GRAD_END);
        Assert.isNotNull((Object)clr);
        return clr;
    }

    public static int[] getActiveViewGradientPercents() {
        return activeViewPercentages;
    }

    public static Color getActiveViewGradientStart() {
        Color clr = (Color)systemColorMap.get(CLR_VIEW_GRAD_START);
        Assert.isNotNull((Object)clr);
        return clr;
    }

    public static Color[] getDeactivatedEditorGradient() {
        return deactivatedEditorGradient;
    }

    public static int[] getDeactivatedEditorGradientPercents() {
        return deactivatedEditorPercentages;
    }

    public static Color[] getDeactivatedViewGradient() {
        return deactivatedViewGradient;
    }

    public static int[] getDeactivatedViewGradientPercents() {
        return deactivatedViewPercentages;
    }

    public static Color getColor(RGB rgbValue) {
        Color clr = (Color)colorMap.get(rgbValue);
        if (clr == null) {
            Display disp = Display.getDefault();
            clr = new Color((Device)disp, rgbValue);
            colorMap.put(rgbValue, clr);
        }
        return clr;
    }

    public static Color getSystemColor(int swtId) {
        Integer bigInt = new Integer(swtId);
        Color clr = (Color)systemColorMap.get(bigInt);
        if (clr == null) {
            Display disp = Display.getDefault();
            clr = disp.getSystemColor(swtId);
            systemColorMap.put(bigInt, clr);
        }
        return clr;
    }

    private static void initWorkbenchColors(Display d) {
        if (workbenchColors != null) {
            return;
        }
        workbenchColors = new Color[]{new Color((Device)d, 255, 255, 255), new Color((Device)d, 255, 251, 240), new Color((Device)d, 223, 223, 191), new Color((Device)d, 223, 191, 191), new Color((Device)d, 192, 220, 192), new Color((Device)d, 192, 192, 192), new Color((Device)d, 191, 191, 191), new Color((Device)d, 191, 191, 159), new Color((Device)d, 191, 159, 191), new Color((Device)d, 160, 160, 164), new Color((Device)d, 159, 159, 191), new Color((Device)d, 159, 159, 159), new Color((Device)d, 159, 159, 127), new Color((Device)d, 159, 127, 159), new Color((Device)d, 159, 127, 127), new Color((Device)d, 128, 128, 128), new Color((Device)d, 127, 159, 159), new Color((Device)d, 127, 159, 127), new Color((Device)d, 127, 127, 159), new Color((Device)d, 127, 127, 127), new Color((Device)d, 127, 127, 95), new Color((Device)d, 127, 95, 127), new Color((Device)d, 127, 95, 95), new Color((Device)d, 95, 127, 127), new Color((Device)d, 95, 127, 95), new Color((Device)d, 95, 95, 127), new Color((Device)d, 95, 95, 95), new Color((Device)d, 95, 95, 63), new Color((Device)d, 95, 63, 95), new Color((Device)d, 95, 63, 63), new Color((Device)d, 63, 95, 95), new Color((Device)d, 63, 95, 63), new Color((Device)d, 63, 63, 95), new Color((Device)d, 0, 0, 0), new Color((Device)d, 195, 204, 224), new Color((Device)d, 214, 221, 235), new Color((Device)d, 149, 168, 199), new Color((Device)d, 128, 148, 178), new Color((Device)d, 106, 128, 158), new Color((Device)d, 255, 255, 255), new Color((Device)d, 0, 0, 0), new Color((Device)d, 0, 0, 0), new Color((Device)d, 132, 130, 132), new Color((Device)d, 143, 141, 138), new Color((Device)d, 171, 168, 165), new Color((Device)d, 230, 226, 221)};
    }

    public static void shutdown() {
        if (!init) {
            return;
        }
        R21Colors.disposeWorkbenchColors();
        Iterator iter = colorMap.values().iterator();
        while (iter.hasNext()) {
            Color clr = (Color)iter.next();
            if (clr == null) continue;
            clr.dispose();
        }
        colorMap.clear();
        systemColorMap.clear();
        init = false;
    }

    public static void startup() {
        if (init) {
            return;
        }
        init = true;
        colorMap = new HashMap(10);
        systemColorMap = new HashMap(10);
        R21Colors.initWorkbenchColors(Display.getDefault());
        Color clr1 = R21Colors.getSystemColor(31);
        Color clr2 = R21Colors.getSystemColor(32);
        Color clr3 = R21Colors.getSystemColor(22);
        systemColorMap.put(CLR_VIEW_GRAD_START, clr1);
        systemColorMap.put(CLR_VIEW_GRAD_END, clr3);
        activeViewGradient = new Color[]{clr1, clr2, clr3};
        activeViewPercentages = new int[]{50, 100};
        systemColorMap.put(CLR_EDITOR_GRAD_START, clr1);
        systemColorMap.put(CLR_EDITOR_GRAD_END, null);
        activeEditorGradient = new Color[]{clr1, clr2, null, null};
        activeEditorPercentages = new int[]{50, 90, 100};
        activeNoFocusEditorGradient = new Color[]{R21Colors.getSystemColor(25)};
        activeNoFocusEditorPercentages = new int[0];
        clr1 = R21Colors.getSystemColor(34);
        clr2 = R21Colors.getSystemColor(35);
        clr3 = R21Colors.getSystemColor(22);
        deactivatedViewGradient = new Color[]{clr1, clr2, clr3};
        deactivatedViewPercentages = new int[]{70, 100};
        deactivatedEditorGradient = new Color[]{clr1, clr2, null, null};
        deactivatedEditorPercentages = new int[]{70, 95, 100};
        R21Colors.getSystemColor(21);
        R21Colors.getSystemColor(2);
    }
}

