/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveAllBreakpointsAction
extends AbstractRemoveAllActionDelegate
implements IBreakpointsListener {
    protected void doAction() {
        block2: {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
            try {
                breakpointManager.removeBreakpoints(breakpoints, true);
            }
            catch (CoreException e) {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window == null) break block2;
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("RemoveAllBreakpointsAction.Removing_all_breakpoints_4"), ActionMessages.getString("RemoveAllBreakpointsAction.Exceptions_occurred_removing_breakpoints._5"), e);
            }
        }
    }

    protected void update() {
        this.getAction().setEnabled(DebugPlugin.getDefault().getBreakpointManager().hasBreakpoints());
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        if (this.getAction() != null && !this.getAction().isEnabled()) {
            this.update();
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.getAction() != null) {
            this.update();
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }
}

