/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.build.BuildSiteJob;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressConstants;

public class BuildSiteAction
implements IObjectActionDelegate,
IPreferenceConstants {
    private ISiteBuildModel fBuildModel;
    private IFile fSiteXML;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fBuildModel == null) {
            return;
        }
        ISiteBuildFeature[] sbFeatures = this.fBuildModel.getSiteBuild().getFeatures();
        IFeatureModel[] models = this.getFeatureModels(sbFeatures);
        if (models.length > 0) {
            BuildSiteJob job = new BuildSiteJob(models, this.fSiteXML.getProject(), this.fBuildModel);
            job.setUser(true);
            job.schedule();
            job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_SITE_OBJ);
        }
    }

    private IFeatureModel[] getFeatureModels(ISiteBuildFeature[] sbFeatures) {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        for (int i = 0; i < sbFeatures.length; ++i) {
            IFeatureModel model;
            IFeature feature = sbFeatures[i].getReferencedFeature();
            if (feature == null || (model = feature.getModel()) == null || model.getUnderlyingResource() == null) continue;
            list.add(model);
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.fBuildModel = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            this.fSiteXML = (IFile)obj;
            IProject project = this.fSiteXML.getProject();
            WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IResource buildFile = project.findMember(new Path(".sitebuild").append("sitebuild.xml"));
            if (buildFile != null && buildFile instanceof IFile) {
                this.fBuildModel = (ISiteBuildModel)manager.getModel((IFile)buildFile);
                try {
                    this.fBuildModel.load();
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
        }
    }
}

