/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginElementNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginObjectNode;

public class PluginLibraryNode
extends PluginObjectNode
implements IPluginLibrary {
    public String[] getContentFilters() {
        IDocumentNode[] children = this.getChildNodes();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < children.length; ++i) {
            String name;
            PluginObjectNode node = (PluginObjectNode)children[i];
            if (!node.getName().equals("export") || (name = children[i].getXMLAttributeValue("name")) == null || name.equals("*")) continue;
            int index = name.indexOf(".*");
            if (index != -1) {
                name = name.substring(0, index);
            }
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getPackages() {
        return new String[0];
    }

    public boolean isExported() {
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            PluginObjectNode node = (PluginObjectNode)children[i];
            if (!node.getName().equals("export")) continue;
            return true;
        }
        return false;
    }

    public boolean isFullyExported() {
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            String name;
            PluginObjectNode node = (PluginObjectNode)children[i];
            if (!node.getName().equals("export") || (name = children[i].getXMLAttributeValue("name")) == null || !name.equals("*")) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        String type = this.getXMLAttributeValue("type");
        return type != null && type.equals("resource") ? "resource" : "code";
    }

    public void setContentFilters(String[] filters) throws CoreException {
    }

    public void addContentFilter(String filter) throws CoreException {
        PluginElementNode node = new PluginElementNode();
        node.setXMLTagName("export");
        node.setParentNode(this);
        node.setModel(this.getModel());
        node.setXMLAttribute("name", "*".equals(filter) || filter.endsWith(".*") ? filter : filter + ".*");
        this.addContentFilter(node);
    }

    public void addContentFilter(PluginElementNode node) throws CoreException {
        this.addChildNode(node);
        if (this.isInTheModel()) {
            node.setInTheModel(true);
            this.fireStructureChanged(node, 1);
        }
    }

    public void removeContentFilter(String filter) throws CoreException {
        if (!filter.endsWith(".*")) {
            filter = filter + ".*";
        }
        IDocumentNode[] children = this.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getXMLTagName().equals("export") || !filter.equals(children[i].getXMLAttributeValue("name"))) continue;
            this.removeContentFilter((PluginElementNode)children[i]);
        }
    }

    public void removeContentFilter(PluginElementNode node) {
        this.removeChildNode(node);
        if (this.isInTheModel()) {
            node.setInTheModel(false);
            this.fireStructureChanged(node, 2);
        }
    }

    public void setPackages(String[] packages) throws CoreException {
    }

    public void setExported(boolean exported) throws CoreException {
        IDocumentNode[] children = this.getChildNodes();
        boolean alreadyExported = false;
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getXMLTagName().equals("export")) continue;
            if (!"*".equals(children[i].getXMLAttributeValue("name"))) {
                this.removeContentFilter((PluginElementNode)children[i]);
                continue;
            }
            alreadyExported = true;
            if (exported) continue;
            this.removeContentFilter((PluginElementNode)children[i]);
        }
        if (exported && !alreadyExported) {
            this.addContentFilter("*");
        }
    }

    public void setType(String type) throws CoreException {
    }

    public String getName() {
        return this.getXMLAttributeValue("name");
    }

    public void setName(String name) throws CoreException {
        this.setXMLAttribute("name", name);
    }

    public String write(boolean indent) {
        IDocumentNode[] children;
        String sep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (indent) {
            buffer.append(this.getIndent());
        }
        if ((children = this.getChildNodes()).length > 0) {
            buffer.append(this.writeShallow(false) + sep);
            for (int i = 0; i < children.length; ++i) {
                children[i].setLineIndent(this.getLineIndent() + 3);
                buffer.append(children[i].write(true) + sep);
            }
            buffer.append(this.getIndent() + "</" + this.getXMLTagName() + ">");
        } else {
            buffer.append(this.writeShallow(true));
        }
        return buffer.toString();
    }

    public String writeShallow(boolean terminate) {
        StringBuffer buffer = new StringBuffer("<" + this.getXMLTagName());
        IDocumentAttribute[] attrs = this.getNodeAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            this.appendAttribute(buffer, attrs[i].getAttributeName());
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

