/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;

public class PluginJavaSearchUtil {
    public static void collectAllPrerequisites(IPlugin plugin, HashSet set) {
        int i;
        if (!set.add(plugin)) {
            return;
        }
        if (plugin.getModel() instanceof WorkspacePluginModelBase) {
            IFragment[] fragments = PDECore.getDefault().getWorkspaceModelManager().getFragmentsFor(plugin.getId(), plugin.getVersion());
            for (i = 0; i < fragments.length; ++i) {
                set.add(fragments[i]);
            }
        }
        IPluginImport[] imports = plugin.getImports();
        for (i = 0; i < imports.length; ++i) {
            IPlugin child;
            if (!imports[i].isReexported() || (child = PDECore.getDefault().findPlugin(imports[i].getId())) == null) continue;
            PluginJavaSearchUtil.collectAllPrerequisites(child, set);
        }
    }

    public static IPackageFragment[] collectPackageFragments(IPluginBase[] models, IProject parentProject) throws JavaModelException {
        ArrayList result = new ArrayList();
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)parentProject).getAllPackageFragmentRoots();
        for (int i = 0; i < models.length; ++i) {
            int j;
            IPluginBase preReq = models[i];
            IResource resource = preReq.getModel().getUnderlyingResource();
            if (resource == null) {
                ArrayList libraryPaths = PluginJavaSearchUtil.getLibraryPaths(preReq);
                for (j = 0; j < roots.length; ++j) {
                    if (!libraryPaths.contains(roots[j].getPath())) continue;
                    PluginJavaSearchUtil.extractFragments(roots[j], result);
                }
                continue;
            }
            IProject project = resource.getProject();
            for (j = 0; j < roots.length; ++j) {
                IJavaProject jProject = (IJavaProject)roots[j].getParent();
                if (!jProject.getProject().equals(project)) continue;
                PluginJavaSearchUtil.extractFragments(roots[j], result);
            }
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private static void extractFragments(IPackageFragmentRoot root, ArrayList result) {
        try {
            IJavaElement[] children = root.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IPackageFragment fragment = (IPackageFragment)children[i];
                if (fragment.getChildren().length <= 0) continue;
                result.add(fragment);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private static ArrayList getLibraryPaths(IPluginBase plugin) {
        ArrayList<Path> libraryPaths = new ArrayList<Path>();
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(plugin.getId(), plugin.getVersion());
        IPluginLibrary[] libraries = plugin.getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            String libraryName = ClasspathUtilCore.expandLibraryName((String)libraries[i].getName());
            String path = plugin.getModel().getInstallLocation() + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
                continue;
            }
            PluginJavaSearchUtil.findLibraryInFragments(fragments, libraryName, libraryPaths);
        }
        return libraryPaths;
    }

    private static void findLibraryInFragments(IFragment[] fragments, String libraryName, ArrayList libraryPaths) {
        for (int i = 0; i < fragments.length; ++i) {
            String path = fragments[i].getModel().getInstallLocation() + '/' + libraryName;
            if (!new File(path).exists()) continue;
            libraryPaths.add(new Path(path));
            break;
        }
    }
}

