/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeBuilder;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class ContentTypeManager
implements IContentTypeManager {
    public static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String OPTION_DEBUG_CONTENT_TYPES = "org.eclipse.core.runtime/contenttypes/debug";
    static final boolean DEBUGGING = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/contenttypes/debug"));
    private static ContentTypeManager instance;
    public static final int MARK_LIMIT = 1024;
    private ContentTypeBuilder builder;
    private Map catalog = new HashMap();
    protected ListenerList contentTypeListeners = new ListenerList();
    private Comparator conflictComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            ContentType type1 = (ContentType)o1;
            ContentType type2 = (ContentType)o2;
            int depthCriteria = type1.getDepth() - type2.getDepth();
            if (depthCriteria != 0) {
                return depthCriteria;
            }
            int priorityCriteria = type1.getPriority() - type2.getPriority();
            if (priorityCriteria != 0) {
                return -priorityCriteria;
            }
            return type1.getId().compareTo(type2.getId());
        }
    };
    private Comparator depthComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ContentType)o2).getDepth() - ((ContentType)o1).getDepth();
        }
    };
    private Map fileExtensions = new HashMap();
    private Map fileNames = new HashMap();

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? null : fileName.substring(dotPosition + 1);
    }

    public static synchronized ContentTypeManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ContentTypeManager();
        instance.startup();
        return instance;
    }

    protected static LazyInputStream readBuffer(InputStream contents) {
        return new LazyInputStream(contents, 1024);
    }

    protected static LazyReader readBuffer(Reader contents) {
        return new LazyReader(contents, 1024);
    }

    protected ContentTypeManager() {
    }

    protected void addContentType(IContentType contentType) {
        this.catalog.put(contentType.getId(), contentType);
    }

    private void addFileSpecContributor(IContentType contentType, int fileSpecType, Map fileSpecsMap) {
        String[] fileSpecs = contentType.getFileSpecs(fileSpecType);
        for (int i = 0; i < fileSpecs.length; ++i) {
            String mappingKey = FileSpec.getMappingKeyFor(fileSpecs[i]);
            TreeSet<IContentType> existing = (TreeSet<IContentType>)fileSpecsMap.get(mappingKey);
            if (existing == null) {
                existing = new TreeSet<IContentType>(this.conflictComparator);
                fileSpecsMap.put(mappingKey, existing);
            }
            existing.add(contentType);
        }
    }

    protected ContentTypeBuilder createBuilder() {
        return new ContentTypeBuilder(this);
    }

    private boolean ensureValid(ContentType type) {
        if (type.getValidation() != 3) {
            return type.isValid();
        }
        if (type.getBaseTypeId() == null) {
            type.setValidation((byte)1);
            return true;
        }
        ContentType baseType = (ContentType)this.catalog.get(type.getBaseTypeId());
        if (baseType == null) {
            type.setValidation((byte)2);
            return false;
        }
        type.setValidation((byte)2);
        this.ensureValid(baseType);
        type.setValidation(baseType.getValidation());
        return type.isValid();
    }

    public IContentType findContentTypeFor(InputStream contents, String fileName) throws IOException {
        IContentType[] all = this.findContentTypesFor(contents, fileName);
        return all.length > 0 ? all[0] : null;
    }

    public IContentType findContentTypeFor(String fileName) {
        IContentType[] associated = this.findContentTypesFor(fileName);
        return associated.length == 0 ? null : associated[0];
    }

    public IContentType[] findContentTypesFor(InputStream contents, String fileName) throws IOException {
        IContentType[] subset = fileName != null ? this.findContentTypesFor(fileName) : this.getAllContentTypes();
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        return this.internalFindContentTypesFor(buffer, subset);
    }

    public IContentType[] findContentTypesFor(String fileName) {
        ContentType main;
        SortedSet allByFileExtension;
        String fileExtension;
        ArrayList<IContentType> result = new ArrayList<IContentType>(5);
        int count = 0;
        SortedSet allByFileName = (SortedSet)this.fileNames.get(FileSpec.getMappingKeyFor(fileName));
        if (allByFileName != null && !allByFileName.isEmpty()) {
            ContentType main2 = ((ContentType)allByFileName.first()).getTarget();
            result.add(count++, main2);
            IContentType[] children = main2.getChildren();
            for (int i = 0; i < children.length; ++i) {
                ContentType child = (ContentType)children[i];
                if (result.contains(child) || child.internalIsAssociatedWith(fileName) != 1) continue;
                result.add(count++, child);
            }
        }
        if ((fileExtension = ContentTypeManager.getFileExtension(fileName)) != null && (allByFileExtension = (SortedSet)this.fileExtensions.get(FileSpec.getMappingKeyFor(fileExtension))) != null && !allByFileExtension.isEmpty() && !result.contains(main = ((ContentType)allByFileExtension.first()).getTarget())) {
            result.add(count++, main);
            IContentType[] children = main.getChildren();
            for (int i = 0; i < children.length; ++i) {
                ContentType child = (ContentType)children[i];
                if (result.contains(children[i]) || child.internalIsAssociatedWith(fileName) != 2) continue;
                result.add(count++, children[i]);
            }
        }
        return result.toArray(new IContentType[result.size()]);
    }

    public IContentType[] getAllContentTypes() {
        ArrayList<ContentType> result = new ArrayList<ContentType>(this.catalog.size());
        Iterator i = this.catalog.values().iterator();
        while (i.hasNext()) {
            ContentType type = (ContentType)i.next();
            if (!type.isValid() || type.isAlias()) continue;
            result.add(type);
        }
        return result.toArray(new IContentType[result.size()]);
    }

    public IContentType[] getChildren(IContentType parent) {
        ArrayList<IContentType> result = new ArrayList<IContentType>(5);
        Iterator i = this.catalog.values().iterator();
        while (i.hasNext()) {
            IContentType next = (IContentType)i.next();
            if (next == parent || !next.isKindOf(parent)) continue;
            result.add(next);
        }
        return result.toArray(new IContentType[result.size()]);
    }

    public IContentType getContentType(String contentTypeIdentifier) {
        ContentType type = this.internalGetContentType(contentTypeIdentifier);
        return type != null && type.isValid() && !type.isAlias() ? type : null;
    }

    public IContentDescription getDescriptionFor(InputStream contents, String fileName, QualifiedName[] options) throws IOException {
        IContentType[] subset;
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        IContentType[] selected = this.internalFindContentTypesFor(buffer, subset = fileName != null ? this.findContentTypesFor(fileName) : this.getAllContentTypes());
        if (selected.length == 0) {
            return null;
        }
        return ((ContentType)selected[0]).internalGetDescriptionFor(buffer, options);
    }

    public IContentDescription getDescriptionFor(Reader contents, String fileName, QualifiedName[] options) throws IOException {
        IContentType[] subset;
        LazyReader buffer = ContentTypeManager.readBuffer(contents);
        IContentType[] selected = this.internalFindContentTypesFor(buffer, subset = fileName != null ? this.findContentTypesFor(fileName) : this.getAllContentTypes());
        if (selected.length == 0) {
            return null;
        }
        return ((ContentType)selected[0]).internalGetDescriptionFor(buffer, options);
    }

    Preferences getPreferences() {
        return new InstanceScope().getNode(CONTENT_TYPE_PREF_NODE);
    }

    protected IContentType[] internalFindContentTypesFor(InputStream buffer, IContentType[] subset) {
        if (buffer == null) {
            Arrays.sort(subset, this.depthComparator);
            return subset;
        }
        ArrayList<ContentType> appropriate = new ArrayList<ContentType>();
        int valid = 0;
        for (int i = 0; i < subset.length; ++i) {
            ContentType current = (ContentType)subset[i];
            IContentDescriber describer = current.getDescriber();
            int status = 1;
            if (describer != null && (status = current.describe(describer, buffer, null)) == 0) continue;
            if (status == 2) {
                appropriate.add(valid++, current);
                continue;
            }
            appropriate.add(current);
        }
        IContentType[] result = appropriate.toArray(new IContentType[appropriate.size()]);
        if (valid > 1) {
            Arrays.sort(result, 0, valid, this.depthComparator);
        }
        if (result.length - valid > 1) {
            Arrays.sort(result, valid, result.length, this.depthComparator);
        }
        return result;
    }

    private IContentType[] internalFindContentTypesFor(Reader buffer, IContentType[] subset) {
        if (buffer == null) {
            Arrays.sort(subset, this.depthComparator);
            return subset;
        }
        ArrayList<ContentType> appropriate = new ArrayList<ContentType>();
        int valid = 0;
        for (int i = 0; i < subset.length; ++i) {
            ContentType current = (ContentType)subset[i];
            IContentDescriber describer = current.getDescriber();
            int status = 1;
            if (describer instanceof ITextContentDescriber && (status = current.describe((ITextContentDescriber)describer, buffer, null)) == 0) continue;
            if (status == 2) {
                appropriate.add(valid++, current);
                continue;
            }
            appropriate.add(current);
        }
        IContentType[] result = appropriate.toArray(new IContentType[appropriate.size()]);
        if (valid > 1) {
            Arrays.sort(result, 0, valid, this.depthComparator);
        }
        if (result.length - valid > 1) {
            Arrays.sort(result, valid, result.length, this.depthComparator);
        }
        return result;
    }

    ContentType internalGetContentType(String contentTypeIdentifier) {
        return (ContentType)this.catalog.get(contentTypeIdentifier);
    }

    private void makeAliases(Map fileSpecs) {
        Iterator i = fileSpecs.values().iterator();
        while (i.hasNext()) {
            Set associated = (Set)i.next();
            if (associated.size() < 2) continue;
            Iterator j = associated.iterator();
            ContentType ellected = (ContentType)j.next();
            while (j.hasNext()) {
                ((ContentType)j.next()).setAliasTarget(ellected);
            }
        }
    }

    protected void reorganize() {
        ContentType type;
        this.fileExtensions.clear();
        this.fileNames.clear();
        Iterator i = this.catalog.values().iterator();
        while (i.hasNext()) {
            type = (ContentType)i.next();
            type.setValidation((byte)3);
            type.setAliasTarget(null);
        }
        i = this.catalog.values().iterator();
        while (i.hasNext()) {
            type = (ContentType)i.next();
            if (!this.ensureValid(type)) continue;
            this.addFileSpecContributor(type, 8, this.fileExtensions);
            this.addFileSpecContributor(type, 4, this.fileNames);
        }
        this.makeAliases(this.fileNames);
        this.makeAliases(this.fileExtensions);
    }

    protected void startup() {
        this.builder = this.createBuilder();
        this.catalog = new HashMap();
        this.builder.startup();
        this.builder.buildContentTypes();
    }

    public void addContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.add(listener);
    }

    public void removeContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.remove(listener);
    }

    public void fireContentTypeChangeEvent(ContentType type) {
        Object[] listeners = this.contentTypeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final IContentTypeManager.ContentTypeChangeEvent event = new IContentTypeManager.ContentTypeChangeEvent(type);
            final IContentTypeManager.IContentTypeChangeListener listener = (IContentTypeManager.IContentTypeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.contentTypeChanged(event);
                }
            };
            Platform.run(job);
        }
    }
}

