/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class KeyedHashSet {
    protected static final int MINIMUM_SIZE = 7;
    private int capacity;
    protected int elementCount = 0;
    protected KeyedElement[] elements;
    protected boolean replace;

    public KeyedHashSet() {
        this(7, true);
    }

    public KeyedHashSet(boolean replace) {
        this(7, replace);
    }

    public KeyedHashSet(int capacity) {
        this(capacity, true);
    }

    public KeyedHashSet(int capacity, boolean replace) {
        this.elements = new KeyedElement[Math.max(7, capacity * 2)];
        this.replace = replace;
        this.capacity = capacity;
    }

    public KeyedHashSet(KeyedHashSet original) {
        this.elements = new KeyedElement[original.elements.length];
        System.arraycopy(original.elements, 0, this.elements, 0, original.elements.length);
        this.elementCount = original.elementCount;
        this.replace = original.replace;
        this.capacity = original.capacity;
    }

    public boolean add(KeyedElement element) {
        int hash;
        int i;
        for (i = hash = this.hash(element); i < this.elements.length; ++i) {
            if (this.elements[i] == null) {
                this.elements[i] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (!this.elements[i].compare(element)) continue;
            if (this.replace) {
                this.elements[i] = element;
                return true;
            }
            return false;
        }
        for (i = 0; i < hash - 1; ++i) {
            if (this.elements[i] == null) {
                this.elements[i] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (!this.elements[i].compare(element)) continue;
            if (this.replace) {
                this.elements[i] = element;
                return true;
            }
            return false;
        }
        this.expand();
        return this.add(element);
    }

    public void addAll(KeyedElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
    }

    public void clear() {
        this.elements = new KeyedElement[Math.max(7, this.capacity * 2)];
        this.elementCount = 0;
    }

    public boolean contains(KeyedElement element) {
        return this.get(element) != null;
    }

    public boolean containsKey(Object key) {
        return this.getByKey(key) != null;
    }

    public int countCollisions() {
        int result = 0;
        int lastHash = 0;
        boolean found = false;
        for (int i = 0; i < this.elements.length; ++i) {
            KeyedElement element = this.elements[i];
            if (element == null) {
                found = false;
                continue;
            }
            int hash = this.hash(element);
            if (found) {
                if (lastHash == hash) {
                    ++result;
                    continue;
                }
                found = false;
                continue;
            }
            lastHash = hash;
            found = true;
        }
        return result;
    }

    public KeyedElement[] elements() {
        return (KeyedElement[])this.elements(new KeyedElement[this.elementCount]);
    }

    public Object[] elements(Object[] result) {
        int j = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            KeyedElement element = this.elements[i];
            if (element == null) continue;
            result[j++] = element;
        }
        return result;
    }

    protected void expand() {
        KeyedElement[] oldElements = this.elements;
        this.elements = new KeyedElement[this.elements.length * 2];
        int maxArrayIndex = this.elements.length - 1;
        for (int i = 0; i < oldElements.length; ++i) {
            KeyedElement element = oldElements[i];
            if (element == null) continue;
            int hash = this.hash(element);
            while (this.elements[hash] != null) {
                if (++hash <= maxArrayIndex) continue;
                hash = 0;
            }
            this.elements[hash] = element;
        }
    }

    public KeyedElement get(KeyedElement key) {
        KeyedElement element;
        int hash;
        int i;
        if (this.elementCount == 0) {
            return null;
        }
        for (i = hash = this.hash(key); i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (!element.compare(key)) continue;
            return element;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (!element.compare(key)) continue;
            return element;
        }
        return null;
    }

    public KeyedElement getByKey(Object key) {
        KeyedElement element;
        int hash;
        int i;
        if (this.elementCount == 0) {
            return null;
        }
        for (i = hash = this.keyHash(key); i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (!element.getKey().equals(key)) continue;
            return element;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (!element.getKey().equals(key)) continue;
            return element;
        }
        return null;
    }

    private int hash(KeyedElement key) {
        return Math.abs(key.getKeyHashCode()) % this.elements.length;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new KeyedHashSetIterator();
    }

    private int keyHash(Object key) {
        return Math.abs(key.hashCode()) % this.elements.length;
    }

    protected void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        KeyedElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hash(element);
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public boolean remove(KeyedElement toRemove) {
        KeyedElement element;
        int hash;
        int i;
        if (this.elementCount == 0) {
            return false;
        }
        for (i = hash = this.hash(toRemove); i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return false;
            }
            if (!element.compare(toRemove)) continue;
            this.rehashTo(i);
            --this.elementCount;
            return true;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return false;
            }
            if (!element.compare(toRemove)) continue;
            this.rehashTo(i);
            --this.elementCount;
            return true;
        }
        return false;
    }

    public void removeAll(KeyedElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.remove(elements[i]);
        }
    }

    public boolean removeByKey(Object key) {
        KeyedElement element;
        int hash;
        int i;
        if (this.elementCount == 0) {
            return false;
        }
        for (i = hash = this.keyHash(key); i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return false;
            }
            if (!element.getKey().equals(key)) continue;
            this.rehashTo(i);
            --this.elementCount;
            return true;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return false;
            }
            if (!element.getKey().equals(key)) continue;
            this.rehashTo(i);
            --this.elementCount;
            return true;
        }
        return true;
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        result.append('{');
        boolean first = true;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(this.elements[i]);
        }
        result.append('}');
        return result.toString();
    }

    class KeyedHashSetIterator
    implements Iterator {
        private int currentIndex = -1;
        private int found;

        KeyedHashSetIterator() {
        }

        public boolean hasNext() {
            return this.found < KeyedHashSet.this.elementCount;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (++this.currentIndex < KeyedHashSet.this.elements.length) {
                if (KeyedHashSet.this.elements[this.currentIndex] == null) continue;
                ++this.found;
                return KeyedHashSet.this.elements[this.currentIndex];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface KeyedElement {
        public boolean compare(KeyedElement var1);

        public Object getKey();

        public int getKeyHashCode();
    }
}

