/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractListViewer
extends StructuredViewer {
    private List listMap = new ArrayList();

    protected abstract void listAdd(String var1, int var2);

    protected abstract void listSetItem(int var1, String var2);

    protected abstract int[] listGetSelectionIndices();

    protected abstract int listGetItemCount();

    protected abstract void listSetItems(String[] var1);

    protected abstract void listRemoveAll();

    protected abstract void listRemove(int var1);

    protected abstract void listSetSelection(int[] var1);

    protected abstract void listShowSelection();

    protected abstract void listDeselectAll();

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        for (int i = 0; i < filtered.length; ++i) {
            Object element = filtered[i];
            int ix = this.indexForElement(element);
            this.listAdd(labelProvider.getText(element), ix);
            this.listMap.add(ix, element);
            this.mapElement(element, (Widget)this.getControl());
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element != null && this.listMap.contains(element)) {
            return this.getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget data, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.listMap.indexOf(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            this.listSetItem(ix, labelProvider.getText(element));
        }
    }

    public abstract Control getControl();

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.listMap.size()) {
            return this.listMap.get(index);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        int[] ixs = this.listGetSelectionIndices();
        ArrayList<Object> list = new ArrayList<Object>(ixs.length);
        for (int i = 0; i < ixs.length; ++i) {
            Object e = this.getElementAt(ixs[i]);
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.listGetItemCount();
        }
        int count = this.listGetItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.listMap.get(mid);
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                while (compare == 0 && ++mid < count) {
                    data = this.listMap.get(mid);
                    compare = sorter.compare(this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.listMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        this.listRemoveAll();
        String[] labels = new String[size];
        for (int i = 0; i < size; ++i) {
            Object el = children[i];
            labels[i] = ((ILabelProvider)this.getLabelProvider()).getText(el);
            this.listMap.add(el);
            this.mapElement(el, (Widget)this.getControl());
        }
        this.listSetItems(labels);
    }

    protected void internalRefresh(Object element) {
        Control list = this.getControl();
        if (element == null || this.equals(element, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List selection = this.getSelectionFromWidget();
            list.setRedraw(false);
            this.listRemoveAll();
            Object[] children = this.getSortedChildren(this.getRoot());
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            for (int i = 0; i < children.length; ++i) {
                Object el = children[i];
                this.listAdd(labelProvider.getText(el), i);
                this.listMap.add(el);
                this.mapElement(el, (Widget)list);
            }
            list.setRedraw(true);
            this.setSelectionToWidget(selection, false);
        } else {
            this.doUpdateItem((Widget)list, element, true);
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        for (int i = 0; i < elements.length; ++i) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            int ix = this.listMap.indexOf(elements[i]);
            if (ix < 0) continue;
            this.listRemove(ix);
            this.listMap.remove(ix);
            this.unmapElement(elements[i], (Widget)this.getControl());
        }
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        this.preservingSelection(new Runnable(){

            public void run() {
                AbstractListViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        if (in == null || in.size() == 0) {
            this.listDeselectAll();
        } else {
            int n = in.size();
            int[] ixs = new int[n];
            int count = 0;
            for (int i = 0; i < n; ++i) {
                Object el = in.get(i);
                int ix = this.listMap.indexOf(el);
                if (ix < 0) continue;
                ixs[count++] = ix;
            }
            if (count < n) {
                int[] nArray = ixs;
                ixs = new int[count];
                System.arraycopy(nArray, 0, ixs, 0, count);
            }
            this.listSetSelection(ixs);
            if (reveal) {
                this.listShowSelection();
            }
        }
    }

    int getElementIndex(Object element) {
        return this.listMap.indexOf(element);
    }
}

