/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.technology.PrimitiveNode;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PrimitiveNodeId
implements NodeProtoId,
Serializable {
    public final TechId techId;
    public final String name;
    public final String fullName;
    public final int chronIndex;
    final ArrayList<PrimitivePortId> primitivePortIds = new ArrayList();
    private final HashMap<String, PrimitivePortId> primitivePortIdsByName = new HashMap();

    PrimitiveNodeId(TechId techId, String name, int chronIndex) {
        assert (techId != null);
        if (name.length() == 0 || !TechId.jelibSafeName(name, true)) {
            throw new IllegalArgumentException("PrimtiveNodeId.name");
        }
        this.techId = techId;
        this.name = name;
        this.fullName = techId.techName + ":" + name;
        this.chronIndex = chronIndex;
    }

    private Object writeReplace() {
        return new PrimitiveNodeIdKey(this);
    }

    synchronized int numPrimitivePortIds() {
        return this.primitivePortIds.size();
    }

    @Override
    public synchronized PrimitivePortId getPortId(int chronIndex) {
        return this.primitivePortIds.get(chronIndex);
    }

    @Override
    public synchronized PrimitivePortId newPortId(String externalId) {
        PrimitivePortId primitivePortId = this.primitivePortIdsByName.get(externalId);
        if (primitivePortId != null) {
            return primitivePortId;
        }
        assert (!this.techId.idManager.readOnly);
        return this.newPrimitivePortIdInternal(externalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimitivePortId newPrimitivePortIdInternal(String primitivePortName) {
        PrimitivePortId primitivePortId = new PrimitivePortId(this, primitivePortName, this.primitivePortIds.size());
        this.primitivePortIds.add(primitivePortId);
        this.primitivePortIdsByName.put(primitivePortId.externalId, primitivePortId);
        assert (this.primitivePortIds.size() == this.primitivePortIdsByName.size());
        TechId techId = this.techId;
        synchronized (techId) {
            ++this.techId.modCount;
        }
        return primitivePortId;
    }

    @Override
    public boolean isIcon() {
        return false;
    }

    @Override
    public boolean isSchematic() {
        return false;
    }

    @Override
    public PrimitiveNode inDatabase(EDatabase database) {
        return database.getTechPool().getPrimitiveNode(this);
    }

    public String toString() {
        return this.fullName;
    }

    void check() {
        assert (this == this.techId.getPrimitiveNodeId(this.chronIndex));
        assert (this.name.length() > 0 && TechId.jelibSafeName(this.name, true));
        for (PrimitivePortId primitivePortId : this.primitivePortIds) {
            primitivePortId.check();
        }
        for (Map.Entry entry : this.primitivePortIdsByName.entrySet()) {
            PrimitivePortId primitivePortId = (PrimitivePortId)entry.getValue();
            assert (primitivePortId.parentId == this);
            assert (primitivePortId.externalId == entry.getKey());
            primitivePortId.check();
        }
        for (int portChronIndex = 0; portChronIndex < this.primitivePortIds.size(); ++portChronIndex) {
            PrimitivePortId primitivePortId = this.primitivePortIds.get(portChronIndex);
            primitivePortId.check();
            assert (this.primitivePortIdsByName.get(primitivePortId.externalId) == primitivePortId);
        }
    }

    private static class PrimitiveNodeIdKey
    extends EObjectInputStream.Key<PrimitiveNodeId> {
        public PrimitiveNodeIdKey() {
        }

        private PrimitiveNodeIdKey(PrimitiveNodeId primitiveNodeId) {
            super(primitiveNodeId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PrimitiveNodeId primitiveNodeId) throws IOException {
            TechId techId = primitiveNodeId.techId;
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(primitiveNodeId + " from other IdManager");
            }
            out.writeInt(techId.techIndex);
            out.writeInt(primitiveNodeId.chronIndex);
        }

        @Override
        public PrimitiveNodeId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            int chronIndex = in.readInt();
            return in.getIdManager().getTechId(techIndex).getPrimitiveNodeId(chronIndex);
        }
    }
}

