/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.User;
import java.awt.geom.RectangularShape;

public class SilComp
extends Tool {
    private static SilComp tool = new SilComp();
    public static final String SCLIBNAME = "sclib";
    private static final String PREF_NODE = "tool/sc";

    private SilComp() {
        super("sc");
    }

    @Override
    public void init() {
    }

    public static SilComp getSilCompTool() {
        return tool;
    }

    static double leafCellXSize(Cell cell) {
        ERectangle bounds = cell.getBounds();
        return ((RectangularShape)bounds).getWidth();
    }

    static double leafCellYSize(Cell cell) {
        ERectangle bounds = cell.getBounds();
        return ((RectangularShape)bounds).getHeight();
    }

    static double leafPortXPos(Export port) {
        if (port == null) {
            return 0.0;
        }
        Poly poly = port.getPoly();
        ERectangle bounds = port.getParent().getBounds();
        return poly.getCenterX() - ((RectangularShape)bounds).getMinX();
    }

    static double leafPortYPos(Export port) {
        if (port == null) {
            return 0.0;
        }
        Poly poly = port.getPoly();
        ERectangle bounds = port.getParent().getBounds();
        return poly.getCenterY() - ((RectangularShape)bounds).getMinY();
    }

    public static class SilCompPrefs
    extends PrefPackage {
        public String schematicTechnology;
        @PrefPackage.IntegerPref(node="tool/sc", key="NumberOfRows", factory=4)
        public int numRows;
        @PrefPackage.StringPref(node="tool/sc", key="HorizRoutingArc", factory="Metal-1")
        public String horizRoutingArc;
        @PrefPackage.DoublePref(node="tool/sc", key="HorizArcWidth", factory=4.0)
        public double horizArcWidth;
        @PrefPackage.StringPref(node="tool/sc", key="VertRoutingArc", factory="Metal-2")
        public String vertRoutingArc;
        @PrefPackage.DoublePref(node="tool/sc", key="VertArcWidth", factory=4.0)
        public double vertArcWidth;
        @PrefPackage.DoublePref(node="tool/sc", key="PowerWireWidth", factory=5.0)
        public double powerWireWidth;
        @PrefPackage.DoublePref(node="tool/sc", key="MainPowerWireWidth", factory=8.0)
        public double mainPowerWireWidth;
        @PrefPackage.StringPref(node="tool/sc", key="MainPowerArc", factory="Horizontal Arc")
        public String mainPowerArc;
        @PrefPackage.DoublePref(node="tool/sc", key="PWellHeight", factory=41.0)
        public double pWellHeight;
        @PrefPackage.DoublePref(node="tool/sc", key="PWellOffset", factory=0.0)
        public double pWellOffset;
        @PrefPackage.DoublePref(node="tool/sc", key="NWellHeight", factory=51.0)
        public double nWellHeight;
        @PrefPackage.DoublePref(node="tool/sc", key="NWellOffset", factory=0.0)
        public double nWellOffset;
        @PrefPackage.DoublePref(node="tool/sc", key="ViaSize", factory=4.0)
        public double viaSize;
        @PrefPackage.DoublePref(node="tool/sc", key="MinMetalSpacing", factory=6.0)
        public double minMetalSpacing;
        @PrefPackage.DoublePref(node="tool/sc", key="FeedThruSize", factory=16.0)
        public double feedThruSize;
        @PrefPackage.DoublePref(node="tool/sc", key="MinPortDistance", factory=8.0)
        public double minPortDistance;
        @PrefPackage.DoublePref(node="tool/sc", key="MinActiveDistance", factory=8.0)
        public double minActiveDistance;

        public SilCompPrefs(boolean factory, String techName) {
            super(factory);
            this.schematicTechnology = techName;
        }

        public SilCompPrefs(boolean factory) {
            super(factory);
            this.schematicTechnology = User.getSchematicTechnology().getTechName();
        }
    }
}

