/* Define error_t.
   Copyright (C) 1991-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include <bits/errno.h>

/* User-visible type of error codes.  It is ok to use 'int' or
   'kern_return_t' for these, but with 'error_t' the debugger prints
   symbolic values.  */
#ifndef __error_t_defined
# define __error_t_defined 1

#ifdef __cplusplus
/* Unfortunately, in C++ int and enum __error_t_codes are not
   interoperable...  */
typedef int error_t;
#else
typedef enum __error_t_codes error_t;
#endif

#endif
