#include "Octree.h"
#include "string.h"

/**
 * Main program for repairing meshes
 *
 * @author Tao Ju
 */


void main ( int args, char* argv[] )
{
	if ( args != 5 && args != 6 )
	{
		printf ("\n") ;
		printf ("PolyMender program for robustly closing a polygonal model.\n");
#ifdef USE_HERMIT
		printf ("(Using Dual Contouring for reproducing sharp features)\n");
#endif
		printf ("Author: Tao Ju (taoju@cs.wustl.edu)\n") ;
		printf ("Version: 1.7 (Updated: Sept 5th, 2007)\n") ;

#ifdef USE_HERMIT
#ifdef FLOOD_FILL
		printf ("\nUsage:   PolyMender-dc-clean <input_file> <octree_depth> <scale> <output_file> <thresh>\n" );
		printf ("Example: PolyMender-dc-dlean bunny.ply 6 0.9 closedbunny.ply 0.9\n" );
#else
		printf ("\nUsage:   PolyMender-dc <input_file> <octree_depth> <scale> <output_file>\n" );
		printf ("Example: PolyMender-dc bunny.ply 6 0.9 closedbunny.ply\n" );
#endif
#else
#ifdef FLOOD_FILL
		printf ("\nUsage:   PolyMender-clean <input_file> <octree_depth> <scale> <output_file> <thresh>\n" );
		printf ("Example: PolyMender-clean bunny.ply 6 0.9 closedbunny.ply 0.9\n" );
#else
		printf ("\nUsage:   PolyMender <input_file> <octree_depth> <scale> <output_file>\n" );
		printf ("Example: PolyMender bunny.ply 6 0.9 closedbunny.ply\n" );
#endif
#endif
		printf ("Description:\n");
		printf ("<input_file>	Polygonal file of format STL (binary only), ASC, or PLY.\n") ;
		printf ("<octree_depth>	Integer depth of octree. The dimension of the volumetric\n");
		printf ("		grid is 2^<octree_depth> on each side.\n");
		printf ("<scale>		Floating point number between 0 and 1 denoting the ratio of\n") ;
		printf ("		the largest dimension of the model over the size of the grid.\n") ;
#ifdef USE_HERMIT
		printf ("<output_file>	Output in PLY, OFF, SOF, SOG or DCF.\n");
#else
		printf ("<output_file>	Output in PLY, OFF or SOF.\n");
#endif
#ifdef FLOOD_FILL
		printf ("<thresh>	Minimum size of components to preserve, as a ratio of\n");
		printf ("		the number of polygons in the largest component.\n");
#endif
		exit(0);
	}

	char* fin = argv[1];
	char* fout = argv[4];
	float scaler, thresh = 1.0;
	int depth;
	int mode = 0 ;
	sscanf(argv[2], "%d", &depth);
	sscanf(argv[3], "%f", &scaler);
	if ( args == 6 )
	{
		sscanf(argv[5], "%f", &thresh);
	}

#ifdef USE_HERMIT
	if ( strstr( fout, ".ply" ) == NULL && 
		strstr( fout, ".off" ) == NULL && 
		strstr( fout, ".sof" ) == NULL && 
		strstr( fout, ".dcf" ) == NULL &&
		strstr( fout, ".sog" ) == NULL ) 
	{
		printf("Unknown output format. Quiting.\n") ;
		exit(1) ;
	}
#else
	if ( strstr( fout, ".ply" ) == NULL && 
		strstr( fout, ".off" ) == NULL && 
		strstr( fout, ".sof" ) == NULL )
	{
		printf("Unknown output format. Quiting.\n") ;
		exit(1) ;
	}
#endif

	
	// Initialize model reader
	ModelReader* mr = NULL ;
	printf("\n") ;
	if ( strstr( fin, ".asc" ) != NULL )
	{
		printf("3D Studio MAX asc file format.\n") ;
		mr = new MaxReader( fin, scaler );
	} else if ( strstr( fin, ".stl" ) != NULL )
	{
		printf("Stereo lithography file format.\n") ;
		mr = new STLReader( fin, scaler );
	} else if ( strstr( fin, ".ply" ) != NULL )
	{
		printf("PLY file format.\n") ;
		mr = new PLYReader( fin, scaler );
	} else
	{
		printf("Unknown file format. Quiting.\n");
		exit(1) ;
	}

	mr->printInfo() ;

	// Scan
	Octree* mytree = new Octree( mr, depth, thresh ) ;
	mytree->scanConvert( fout ) ;
	// char c = getchar( ) ;
}
