/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.websocket;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class WebSocketClient
implements AutoCloseable {
    private static final Map<URI, WebSocketClient> clients = new HashMap<URI, WebSocketClient>();
    private final Socket socket;
    private final URI uri;
    private boolean connected = false;

    private WebSocketClient(URI uri) throws IOException, URISyntaxException {
        this.uri = uri;
        this.socket = new Socket(uri.getHost(), uri.getPort() > 0 ? uri.getPort() : 80);
        this.connect();
    }

    public static byte[] sendMessage(URI uri, byte[] message) throws Exception {
        WebSocketClient client = clients.computeIfAbsent(uri, WebSocketClient::createClient);
        if (!client.connected) {
            throw new IllegalStateException("WebSocket is not connected");
        }
        client.sendByteArray(message);
        return client.receiveByteArray();
    }

    private static WebSocketClient createClient(URI uri) {
        try {
            return new WebSocketClient(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void connect() throws IOException {
        String webSocketKey = this.generateWebSocketKey();
        String request = String.format("GET %s HTTP/1.1\r\nHost: %s\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: %s\r\nSec-WebSocket-Version: 13\r\n\r\n", this.uri.getPath(), this.uri.getHost(), webSocketKey);
        this.socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
        this.socket.getOutputStream().flush();
        byte[] responseBuffer = new byte[1024];
        int bytesRead = this.socket.getInputStream().read(responseBuffer);
        String response = new String(Arrays.copyOf(responseBuffer, bytesRead), StandardCharsets.UTF_8);
        if (!response.contains("101 Switching Protocols")) {
            throw new IllegalStateException("Failed to upgrade to WebSocket");
        }
        this.connected = true;
    }

    private void sendByteArray(byte[] message) throws IOException {
        byte[] mask = new byte[4];
        new Random().nextBytes(mask);
        byte[] frame = new byte[6 + message.length];
        frame[0] = -126;
        frame[1] = (byte)(0x80 | message.length);
        System.arraycopy(mask, 0, frame, 2, mask.length);
        for (int i = 0; i < message.length; ++i) {
            frame[6 + i] = (byte)(message[i] ^ mask[i % 4]);
        }
        this.socket.getOutputStream().write(frame);
        this.socket.getOutputStream().flush();
    }

    private byte[] receiveByteArray() throws IOException {
        byte[] extendedPayloadLength;
        byte[] header = new byte[2];
        int bytesRead = this.socket.getInputStream().read(header);
        if (bytesRead != 2) {
            throw new IOException("Failed to read WebSocket frame header");
        }
        boolean isMasked = (header[1] & 0x80) != 0;
        int payloadLength = header[1] & 0x7F;
        if (payloadLength == 126) {
            extendedPayloadLength = new byte[2];
            bytesRead = this.socket.getInputStream().read(extendedPayloadLength);
            if (bytesRead != 2) {
                throw new IOException("Failed to read extended payload length");
            }
            payloadLength = (extendedPayloadLength[0] & 0xFF) << 8 | extendedPayloadLength[1] & 0xFF;
        } else if (payloadLength == 127) {
            extendedPayloadLength = new byte[8];
            bytesRead = this.socket.getInputStream().read(extendedPayloadLength);
            if (bytesRead != 8) {
                throw new IOException("Failed to read extended payload length");
            }
            payloadLength = 0;
            for (int i = 0; i < 8; ++i) {
                payloadLength = payloadLength << 8 | extendedPayloadLength[i] & 0xFF;
            }
        }
        byte[] mask = new byte[4];
        if (isMasked && (bytesRead = this.socket.getInputStream().read(mask)) != 4) {
            throw new IOException("Failed to read mask");
        }
        byte[] payload = new byte[payloadLength];
        bytesRead = this.socket.getInputStream().read(payload);
        if (bytesRead != payloadLength) {
            throw new IOException("Failed to read payload");
        }
        if (isMasked) {
            for (int i = 0; i < payloadLength; ++i) {
                int n = i;
                payload[n] = (byte)(payload[n] ^ mask[i % 4]);
            }
        }
        return payload;
    }

    private String generateWebSocketKey() {
        byte[] key = new byte[16];
        new Random().nextBytes(key);
        return Base64.getEncoder().encodeToString(key);
    }

    @Override
    public void close() throws IOException {
        if (this.connected) {
            this.socket.getOutputStream().write(new byte[]{-120, 0});
            this.socket.getOutputStream().flush();
            this.connected = false;
        }
        this.socket.close();
    }
}

