/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InterfaceAnalyzer {
    public static LinkedList<Class<?>> returnClassesFromJar(String jarPath) {
        File f = new File(jarPath);
        LinkedList classQueue = new LinkedList();
        if (f.exists()) {
            try {
                JarFile jarFile = new JarFile(jarPath);
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + jarPath + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || je.getName().contains("$")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    className = className.replace('/', '.');
                    Class<?> c = cl.loadClass(className);
                    classQueue.add(c);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
            return classQueue;
        }
        throw new RuntimeException("Jar does not exists: " + jarPath);
    }
}

