/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import javax.measure.UnitConverter;
import org.apache.sis.math.DecimalFunctions;

abstract class AbstractConverter
implements UnitConverter,
Serializable {
    private static final long serialVersionUID = -8480235641759297444L;

    AbstractConverter() {
    }

    Number[] coefficients() {
        return this.isIdentity() ? new Number[]{} : null;
    }

    public abstract double derivative(double var1);

    static double derivative(UnitConverter unitConverter, double d) {
        if (unitConverter != null) {
            if (unitConverter instanceof AbstractConverter) {
                return ((AbstractConverter)unitConverter).derivative(d);
            }
            if (unitConverter.isLinear()) {
                return unitConverter.convert(1.0) - unitConverter.convert(0.0);
            }
        }
        return Double.NaN;
    }

    static double doubleValue(Number number) {
        return number instanceof Float ? DecimalFunctions.floatToDouble(number.floatValue()) : number.doubleValue();
    }
}

