/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{

}

Component.prototype.createOperations = function()
{
    component.createOperations();
}

// "Helper" functions
originalHostOS = function()
{
    var targetOSName = installer.value("qt_target_name-PatchString").toLowerCase();

    if (targetOSName.startsWith("macos")) {
        return "macOS";
    }
    else if (targetOSName.startsWith("windows")) {
        return "Windows";
    }
    else if (targetOSName.startsWith("linux")) {
        return "Linux";
    }
    else {
        console.log("qt_target_name-PatchString not defined!");
        return "";
    }
}

originalQtHostPath = function()
{
    if (originalHostOS() == "Linux") {
        return "/home/qt/work/install";
   }
    else {
        return "/Users/qt/work/install";
    }
}

pkgBuildHostPatchingOperation_65x = function(qt_target_name)
{
    installer.setValue("qt_target_name-PatchString", qt_target_name);
    console.log("we have set qt_target_name!!!");
    return "";
}

// Functions that return a generic value

qtPathPatchingOperation_65x = function(TARGET_INSTALL_DIR)
{
    var targetDir = installer.toNativeSeparators(installer.value("TargetDir"));
    var qtPath = installer.toNativeSeparators(targetDir + TARGET_INSTALL_DIR);

    return qtPath;
}

targetQtConfDocumentationPatchingOperation_65x = function(qt_version)
{
    return "Documentation=../../Docs/Qt-" + qt_version;
}

targetQtConfExamplesPatchingOperation_65x = function(qt_version)
{
    return "Examples=../../Examples/Qt-" + qt_version;
}

originalHostPrefixPatchingOperation_65x = function()
{
    return "HostPrefix=../../";
}

originalHostDataPatchingOperation_65x = function()
{
    return "HostData=target";
}

qdeviceFilePatchingOperation_65x = function()
{
    return "/mkspecs/qdevice.pri";
}

qconfigFilePatchingOperation_65x = function()
{
    return "/mkspecs/qconfig.pri";
}

// Qnx specific functions

originalSysrootPatchingOperation_65x = function()
{
    return "Sysroot=.*";
}

originalInitialToolchainPatchingOperation_65x = function(qnx_toolchain)
{
    return "/opt/qnx710/" + qnx_toolchain;
}

newSysrootPatchingOperation_65x = function()
{
    return "Sysroot=" + installer.value("QNX710_SDP_PATH") + "/target/qnx7";
}

newInitialToolchainPatchingOperation_65x = function(qnx_toolchain)
{
    return "/" + qnx_toolchain;
}

// Functions that return a value based on what the original packages are build on

originalSetCmakePathPatchingOperation_65x = function()
{
    if (originalHostOS() == "macOS") {
        return "/Applications/CMake.app/Contents/bin/cmake";
    }
    else if (originalHostOS() == "Windows") {
        return "C:/CMake/bin/cmake.exe";
    }
    else {
        return "/opt/cmake-*.*.*/bin/cmake";
    }
}

originalHostSpecPatchingOperation_65x = function()
{
    if (originalHostOS() == "macOS") {
        return "macx-clang";
    }
    else if (originalHostOS() == "Windows") {
        return "win32-g++";
    }
    else {
        return "linux-g++";
    }
}

originalLicheckPatchingOperation_65x = function()
{
    if (originalHostOS() == "macOS") {
        return "QT_LICHECK = licheck_mac";
    }
    else if (originalHostOS() == "Windows") {
        return "QT_LICHECK = licheck.exe";
    }
    else {
        return "QT_LICHECK = licheck64";
    }
}

originalBIPrefixPatchingOperation_65x = function(qt_version)
{
    if (originalHostOS() == "macOS") {
        return "/usr/local/Qt-" + qt_version;
    }
    else if (originalHostOS() == "Windows") {
        return "C:/Qt/Qt-" + qt_version;
    }
    else {
        return "/usr/local/Qt-" + qt_version;
    }
}

originalHostBinPathPatchingOperation_65x = function(qt_pkg_version_minor)
{
    if (originalHostOS() == "Windows") {
         // Packages from windows has unix path separator until Qt 6.5.0 release.
        // After that it will have windows style one
        if (!(typeof(qt_pkg_version_minor) == 'number' && qt_pkg_version_minor < 65)) {
            return "\\Users\\qt\\work\\install\\bin";
        }
    }
    else {
        return  originalQtHostPath() + "/bin";
    }
}

// Functions that require helperpath in front of them

newQtHostPathPatchingOperation_65x = function(qt_version, QT_PKG_BUILD_HOST)
{
    var msvc2019Target = QT_PKG_BUILD_HOST.toLowerCase();

    if (installer.value("os") == "x11") {
        return installer.value("TargetDir") + "/" + qt_version + "/gcc_64";
    }
    else if (installer.value("os") == "win") {
        if (msvc2019Target.includes("msvc2019")) {
            return installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64";
        }
        else {
            return installer.value("TargetDir") + "/" + qt_version + "/minqw_64";
        }
    }
    else {
        return installer.value("TargetDir") + "/" + qt_version + "/macos";
    }
}

originalHostTargetPathPatchingOperation_65x = function()
{
    return originalQtHostPath() + "/target";
}

qMakeScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qmake";
    }
    else {
        return "/bin/qmake";
    }
}

qmake6ScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qmake6.bat";
    }
    else {
        return "/bin/qmake6";
    }
}

qtCMakeScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qt-cmake.bat";
    }
    else {
        return "/bin/qt-cmake";
    }
}

qtCMakePrivateScriptPatchingOperation_65x = function(QT_CMAKE_HELPER_SCRIPT_FOLDER_LINUX, QT_CMAKE_HELPER_SCRIPT_FOLDER_MAC, QT_CMAKE_HELPER_SCRIPT_FOLDER_WINDOWS)
{
    if (installer.value("os") == "x11") {
        return "/" + QT_CMAKE_HELPER_SCRIPT_FOLDER_LINUX + "/qt-cmake-private";
    }
    else if (installer.value("os") == "mac") {
        return "/" + QT_CMAKE_HELPER_SCRIPT_FOLDER_MAC + "/qt-cmake-private";
    }
    else {
        return "\\" + QT_CMAKE_HELPER_SCRIPT_FOLDER_WINDOWS + "\\qt-cmake-private";
    }
}

qtCMakeStandaloneTestScriptPatchingOperation_65x = function(QT_CMAKE_HELPER_SCRIPT_FOLDER_LINUX, QT_CMAKE_HELPER_SCRIPT_FOLDER_MAC, QT_CMAKE_HELPER_SCRIPT_FOLDER_WINDOWS)
{
    if (installer.value("os") == "x11") {
        return "/" + QT_CMAKE_HELPER_SCRIPT_FOLDER_LINUX + "/qt-cmake-standalone-test";
    }
    else if (installer.value("os") == "mac") {
        return "/" + QT_CMAKE_HELPER_SCRIPT_FOLDER_MAC + "/qt-cmake-standalone-test";
    }
    else {
        return "/" + QT_CMAKE_HELPER_SCRIPT_FOLDER_WINDOWS + "/qt-cmake-standalone-test";
    }
}

qtConfigureModuleScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qt-configure-module";
    }
    else {
        return "/bin/qt-configure-module";
    }
}

targetQtConfPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\target_qt.conf";
    }
    else {
        return "/bin/target_qt.conf";
    }
}

qtToolchainCmakePatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\lib\\cmake\\Qt6\\qt.toolchain.cmake";
    }
    else {
        return "/lib/cmake/Qt6/qt.toolchain.cmake";
    }
}

qtBuildInternalsExtraCmakePatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\lib\\cmake\\Qt6BuildInternals\\QtBuildInternalsExtra.cmake";
    }
    else {
        return "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";
    }
}

qtPathsScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qtpaths.bat";
    }
    else {
        return "/bin/qtpaths";
    }
}

qtPaths6ScriptPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\bin\\qtpaths6.bat";
    }
    else {
        return "/bin/qtpaths6";
    }
}

qt6DependenciesCMakePathPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "\\lib\\cmake\\Qt6\\Qt6Dependencies.cmake";
    }
    else {
        return "/lib/cmake/Qt6/Qt6Dependencies.cmake";
    }
}

// Return a value based on targer_arch

newHostDataPatchingOperation_65x = function(target_arch)
{
    if (target_arch == "singlethread" || target_arch == "multithread") {
        return "HostData=../wasm_" + target_arch;
    }
    else if (target_arch == "aarch64le" || target_arch == "armle_v7") {
        return "HostData=../qnx71_" + target_arch;
    }
    else {
        return "HostData=../android_" + target_arch;
    }
}

// Return variables used for patching

newSetCMakePathPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        var newSetCMakePath = installer.toNativeSeparators(installer.value("TargetDir")) + "\\Tools\\CMake_64\\bin\\cmake.exe";
        return newSetCMakePath;
    }
    else {
        var newSetCMakePath = installer.toNativeSeparators(installer.value("TargetDir")) + "/Tools/CMake/bin/cmake";
        return newSetCMakePath;
    }
}

newLicheckPatchingOperation_65x = function()
{
    if (installer.value("os") == "x11") {
        return "QT_LICHECK = licheck64";
    }
    else if (installer.value("os") == "mac") {
        return "QT_LICHECK = licheck_mac";
    }
    else {
        return "QT_LICHECK = licheck.exe";
    }
}

newQtPathsPathPatchingOperation_65x = function(qt_version, QT_PKG_BUILD_HOST)
{
    var msvc2019Target = QT_PKG_BUILD_HOST.toLowerCase();

    if (installer.value("os") == "x11") {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_64/bin/qtpaths");
    }
    else if (installer.value("os") == "win") {
        // Check if we are using msvc2019 component
        if (msvc2019Target.includes("msvc2019")) {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64/bin/qtpaths");
        }
        else {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/minqw_64/bin/qtpaths");
        }
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/macos/bin/qtpaths");
    }
}

newQmakePathPatchingOperation_65x = function(qt_version, QT_PKG_BUILD_HOST)
{
    var msvc2019Target = QT_PKG_BUILD_HOST.toLowerCase();

    if (installer.value("os") == "x11") {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/gcc_64/bin/qmake");
    }
    else if (installer.value("os") == "win") {
        if (msvc2019Target.includes("msvc2019")) {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64/bin/qmake");
        }
        else {
            return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/minqw_64/bin/qmake");
        }
    }
    else {
        return installer.toNativeSeparators(installer.value("TargetDir") + "/" + qt_version + "/macos/bin/qmake");
    }
}

newHostPrefixPatchingOperation_65x = function(QT_PKG_BUILD_HOST)
{
    var msvc2019Prefix = QT_PKG_BUILD_HOST.toLowerCase();

    if (installer.value("os") == "x11") {
        return "HostPrefix=../../gcc_64";
    }
    else if (installer.value("os") == "win") {
        if (msvc2019Prefix.includes("msvc2019")) {
            return "HostPrefix=../../msvc2019_64";
        }
        else {
            return "HostPrefix=../../mingw_64";
        }
    }
    else {
        return "HostPrefix=../../macos";
    }
}

platformIdentification = function()
{
    if (installer.value("os") == "x11") {
        return "linux";
    }
    else if (installer.value("os") == "mac") {
        return "mac";
    }
    else {
        return "win";
    }
}

fromWindowsToUnixFlag_65x = function()
{
    // we don't need to add additional execute rules in windows environment
    if (installer.value("os") == "win") {
        return false;
    }
    // Set a flag to indicate that host build is from a windows
    else if (originalHostOS() == "Windows") {
        return true;
    }
    else {
        return false;
    }
}

newHostSpecPatchingOperation_65x = function()
{
    if (installer.value("os") == "x11") {
        return "linux-g++";
    }
    else if (installer.value("os") == "mac") {
        return "macx-clang";
    }
    else {
        return "win32-g++";
    }
}

newNDKHostPatchingOperation_65x = function()
{
    if (installer.value("os") == "x11") {
        return "linux-x86_64";
    }
    else if (installer.value("os") == "mac") {
        return "darwin-x86_64";
    }
    else {
        return "windows-x86_64";
     }
}

newHostLibExecutablesPatchingOperation_65x = function()
{
    if (installer.value("os") == "win") {
        return "./bin";
    }
    else {
        return "./libexec";
    }
}

originalQmakePathPatchingOperation_65x = function(qt_pkg_version_minor)
{
    if (installer.value("os") == "win") {
        return originalHostBinPathPatchingOperation_65x(qt_pkg_version_minor) + "\\qmake";
    }
    else {
        return originalHostBinPathPatchingOperation_65x(qt_pkg_version_minor) + "/qmake";
    }
}

originalQtPathsPathPatchingOperation_65x = function(qt_pkg_version_minor)
{
    if (installer.value("os") == "win") {
        var originalQtPathsPath = originalHostBinPathPatchingOperation_65x(qt_pkg_version_minor) + "\\qtpaths";
        return originalQtPathsPath;
    }
    else {
        var originalQtPathsPath = originalHostBinPathPatchingOperation_65x(qt_pkg_version_minor) + "/qtpaths";
        return originalQtPathsPath;
    }
}

initializeGenericValues = function(component, qt_target_name, qt_pkg_version_minor, TARGET_INSTALL_DIR, qt_version, qnx_toolchain)
{
    // Set component name to a value so we can give each variable an unique value
    var unique_id = component + "-";

    // Set generic values
    installer.setValue("qt_target_name-PatchString", qt_target_name);
    installer.setValue(unique_id + "qt_pkg_version_minor-PatchString", qt_pkg_version_minor);
    installer.setValue(unique_id + "targetDir-PatchString", installer.toNativeSeparators(installer.value("TargetDir")));
    installer.setValue(unique_id + "qtPath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "targetDir-PatchString") + TARGET_INSTALL_DIR));

    installer.setValue(unique_id + "targetQtConf_documentation-PatchString", "Documentation=../../Docs/Qt-" + qt_version);
    installer.setValue(unique_id + "targetQtConf_examples-PatchString", "Examples=../../Examples/Qt-" + qt_version);

    installer.setValue(unique_id + "qconfigFile-PatchString", installer.value(unique_id + "qtPath-PatchPath") + "/mkspecs/qconfig.pri");
    installer.setValue(unique_id + "qdeviceFile-PatchString", installer.value(unique_id + "qtPath-PatchPath") + "/mkspecs/qdevice.pri");

    installer.setValue(unique_id + "originalHostBinPath-PatchPath", originalQtHostPath() + "/bin");
    installer.setValue(unique_id + "originalHostTargetPath-PatchString", originalQtHostPath() + "/target");
    installer.setValue(unique_id + "originalHostPrefix-PatchString", "HostPrefix=../../");
    installer.setValue(unique_id + "originalHostData-PatchString", "HostData=target");
    installer.setValue("fromWindowsToUnix-Boolean", false);

    // Set qnx values
    installer.setValue(unique_id + "sdpDirectoryPath-PatchPath", installer.value("QNX710_SDP_PATH"));
    installer.setValue(unique_id + "originalSysroot-PatchString", "Sysroot=.*");
    installer.setValue(unique_id + "originalInitialToolchain-PatchString", "/opt/qnx710/" + qnx_toolchain);
    installer.setValue(unique_id + "newSysroot-PatchPath", "Sysroot=" + installer.value(unique_id + "sdpDirectoryPath-PatchPath") + "/target/qnx7");
    installer.setValue(unique_id + "newInitialToolchain-PatchString", installer.value(unique_id + "qtPath-PatchPath") + "/" + qnx_toolchain);

}

setOriginalHostValues = function(component, qt_version)
{
    // Set component name to a value so we can give each variable an unique value
    var unique_id = component + "-";

    // Set original values
    // Packages are done in macOS
    if (originalHostOS() == "macOS") {
        console.log("Using packages built on macOS host");

        installer.setValue(unique_id + "originalSetCMakePath-PatchPath", "/Applications/CMake.app/Contents/bin/cmake");
        installer.setValue(unique_id + "originalHostSpec-PatchString", "macx-clang");
        installer.setValue(unique_id + "originalLicheck-PatchString", "QT_LICHECK = licheck_mac");
        installer.setValue(unique_id + "originalBIPrefix-PatchPath", "/usr/local/Qt-" + qt_version);
    }

    // Packages are done in windows
    else if (originalHostOS() == "Windows") {
        console.log("Using packages built on Windows host");

        // Set a flag to indicate that host build is from a windows
        installer.setValue("fromWindowsToUnix-Boolean", true);

        installer.setValue(unique_id + "originalSetCMakePath-PatchPath", "C:/CMake/bin/cmake.exe");
        installer.setValue(unique_id + "originalHostSpec-PatchString", "win32-g++");
        installer.setValue(unique_id + "originalLicheck-PatchString", "QT_LICHECK = licheck.exe");
        installer.setValue(unique_id + "originalBIPrefix-PatchPath", "C:/Qt/Qt-" + qt_version);

        // Packages from windows has unix path separator until Qt 6.5.0 release.
        // After that it will have windows style one
        if (!(typeof(installer.value(unique_id + "qt_pkg_version_minor-PatchString")) == 'number' && installer.value(unique_id + "qt_pkg_version_minor-PatchString") < 65)) {
            installer.setValue(unique_id + "originalHostBinPath-PatchPath", "\\Users\\qt\\work\\install\\bin");
        }
    }

    // Packages are done in linux
    else {
        console.log("Using packages built on Linux host");

        installer.setValue(unique_id + "originalSetCMakePath-PatchPath", "/opt/cmake-*.*.*/bin/cmake");
        installer.setValue(unique_id + "originalHostSpec-PatchString", "linux-g++");
        installer.setValue(unique_id + "originalLicheck-PatchString", "QT_LICHECK = licheck64");
        installer.setValue(unique_id + "originalBIPrefix-PatchPath", "/usr/local/Qt-" + qt_version);
    }
}

initializeValuesForLinux = function(component, qt_version, libexec, target_arch)
{
    // Set component name to a value so we can give each variable an unique value
    var unique_id = component + "-";

    // Initialize new values based on installation os
    installer.setValue(unique_id + "platform-PatchString", "linux");
    console.log("Installation OS is = " + installer.value(unique_id + "platform-PatchString"));

    // Initialize new hostpath and new hostbinpath based on installation OS
    installer.setValue(unique_id + "newQtHostPath-PatchPath", installer.value("TargetDir") + "/" + qt_version + "/gcc_64");
    installer.setValue(unique_id + "newHostBinPath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "newQtHostPath-PatchPath") + "/bin"));

    // Initialize variables used for patching
    installer.setValue(unique_id + "libexec-PatchString", libexec);
    installer.setValue(unique_id + "qmakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qmake");
    installer.setValue(unique_id + "qmake6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qmake6");
    installer.setValue(unique_id + "qtCMakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qt-cmake");
    installer.setValue(unique_id + "qtCMakePrivateScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/" + installer.value(unique_id + "libexec-PatchString") + "/qt-cmake-private");
    installer.setValue(unique_id + "qtCMakeStandaloneTestScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/" + installer.value(unique_id + "libexec-PatchString") + "/qt-cmake-standalone-test");
    installer.setValue(unique_id + "qtConfigureModuleScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qt-configure-module");
    installer.setValue(unique_id + "targetQtConf-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/target_qt.conf");
    installer.setValue(unique_id + "qtToolchainCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6/qt.toolchain.cmake");
    installer.setValue(unique_id + "qtBuildInternalsExtraCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake");
    installer.setValue(unique_id + "qtPathsScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qtpaths");
    installer.setValue(unique_id + "qtPaths6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qtpaths6");
    installer.setValue(unique_id + "qt6DependenciesCMakePath-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6/Qt6Dependencies.cmake");
    installer.setValue(unique_id + "newSetCMakePath-PatchPath", installer.value(unique_id + "targetDir-PatchString") + "/Tools/CMake/bin/cmake");
    installer.setValue(unique_id + "newHostPrefix-PatchString", "HostPrefix=../../gcc_64");

        // Initialize variable based on target arch
        if (target_arch == "aarch64le" || target_arch == "armle_v7") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../qnx71_" + target_arch);
        }
        else if (target_arch == "singlethread" || target_arch == "multithread") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../wasm_" + target_arch);
        }
        else {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../android_" + target_arch);
        }

    // Initialize variables used for patching
    installer.setValue(unique_id + "newLicheck-PatchString", "QT_LICHECK = licheck64");
    installer.setValue(unique_id + "newQtPathsPath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "/qtpaths");
    installer.setValue(unique_id + "newQmakePath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "/qmake");
    installer.setValue(unique_id + "newNDKHost-PatchString", "linux-x86_64");
    installer.setValue(unique_id + "newHostLibExecutables-PatchString", "./libexec");
    installer.setValue(unique_id + "newHostSpec-PatchString", "linux-g++");
    installer.setValue(unique_id + "originalQtPathsPath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "/qtpaths");
    installer.setValue(unique_id + "originalQmakePath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "/qmake");
}

initializeValuesForMacOs = function(component, qt_version, libexec, target_arch)
{
    // Set component name to a value so we can give each variable an unique value
    var unique_id = component + "-";

    // Initialize new values based on installation os
    installer.setValue(unique_id + "platform-PatchString", "mac");
    console.log("Installation OS is = " + installer.value(unique_id + "platform-PatchString"));

    // Initialize new hostpath and new hostbinpath based on installation OS
    installer.setValue(unique_id + "newQtHostPath-PatchPath", installer.value("TargetDir") + "/" + qt_version + "/macos");
    installer.setValue(unique_id + "newHostBinPath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "newQtHostPath-PatchPath") + "/bin"));

    // Initialize variables used for patching
    installer.setValue(unique_id + "libexec-PatchString", libexec);
    installer.setValue(unique_id + "qmakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qmake");
    installer.setValue(unique_id + "qmake6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qmake6");
    installer.setValue(unique_id + "qtCMakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qt-cmake");
    installer.setValue(unique_id + "qtCMakePrivateScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/" + installer.value(unique_id + "libexec-PatchString") + "/qt-cmake-private");
    installer.setValue(unique_id + "qtCMakeStandaloneTestScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/" + installer.value(unique_id + "libexec-PatchString") + "/qt-cmake-standalone-test");
    installer.setValue(unique_id + "qtConfigureModuleScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qt-configure-module");
    installer.setValue(unique_id + "targetQtConf-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/target_qt.conf");
    installer.setValue(unique_id + "qtToolchainCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6/qt.toolchain.cmake");
    installer.setValue(unique_id + "qtBuildInternalsExtraCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake");
    installer.setValue(unique_id + "qtPathsScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qtpaths");
    installer.setValue(unique_id + "qtPaths6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/bin/qtpaths6");
    installer.setValue(unique_id + "qt6DependenciesCMakePath-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "/lib/cmake/Qt6/Qt6Dependencies.cmake");
    installer.setValue(unique_id + "newSetCMakePath-PatchPath", installer.value(unique_id + "targetDir-PatchString") + "/Tools/CMake/bin/cmake");
    installer.setValue(unique_id + "newHostPrefix-PatchString", "HostPrefix=../../macos");

        // Initialize variable based on target arch
        if (target_arch == "singlethread" || target_arch == "multithread") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../wasm_" + target_arch);
        }
        else if (target_arch == "ios") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../ios");
        }
        else {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../android_" + target_arch);
        }

    // Initialize variables used for patching
    installer.setValue(unique_id + "newHostSpec-PatchString", "macx-clang");
    installer.setValue(unique_id + "newLicheck-PatchString", "QT_LICHECK = licheck_mac");
    installer.setValue(unique_id + "newQtPathsPath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "/qtpaths");
    installer.setValue(unique_id + "newQmakePath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "/qmake");
    installer.setValue(unique_id + "newNDKHost-PatchString", "darwin-x86_64");
    installer.setValue(unique_id + "newHostLibExecutables-PatchString", "./libexec");
    installer.setValue(unique_id + "originalQtPathsPath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "/qtpaths");
    installer.setValue(unique_id + "originalQmakePath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "/qmake");
}

initializeValuesForWindows = function(component, qt_version, bin, target_arch)
{
    // Set component name to a value so we can give each variable an unique value
    var unique_id = component + "-";

    // Initialize new values based on installation os
    installer.setValue(unique_id + "platform-PatchString", "windows");
    console.log("Installation OS is = " + installer.value(unique_id + "platform-PatchString"));

    // Initialize new hostpath and new hostbinpath based on installation OS
    installer.setValue(unique_id + "newQtHostPath-PatchPath", installer.value("TargetDir") + "/" + qt_version + "/mingw_64");
    installer.setValue(unique_id + "newHostBinPath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "newQtHostPath-PatchPath") + "/bin"));

    // Check if we are using msvc2019 component
    var msvc2019Target = installer.value("qt_target_name-PatchString").toLowerCase();

        if (msvc2019Target.includes("msvc2019")) {
            installer.setValue(unique_id + "newQtHostPath-PatchPath", installer.value("TargetDir") + "/" + qt_version + "/msvc2019_64");
            installer.setValue(unique_id + "newHostBinPath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "newQtHostPath-PatchPath") + "/bin"));
            installer.setValue(unique_id + "newHostPrefix-PatchString", "HostPrefix=../../msvc2019_64");
        }
        else {
            installer.setValue(unique_id + "newHostPrefix-PatchString", "HostPrefix=../../mingw_64");
        }

    // we don't need to add additional execute rules in windows environment
    installer.setValue("fromWindowsToUnix-Boolean", false);
    installer.setValue(unique_id + "bin-PatchString", bin);

    // Initialize variables used for patching
    installer.setValue(unique_id + "qmakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qmake.bat");
    installer.setValue(unique_id + "qmake6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qmake6.bat");
    installer.setValue(unique_id + "qtCMakeScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qt-cmake.bat");
    installer.setValue(unique_id + "qtCMakePrivateScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\" + installer.value(unique_id + "bin-PatchString") + "\\qt-cmake-private.bat");
    installer.setValue(unique_id + "qtCMakeStandaloneTestScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\" + installer.value(unique_id + "bin-PatchString") + "\\qt-cmake-standalone-test");
    installer.setValue(unique_id + "qtConfigureModuleScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qt-configure-module");
    installer.setValue(unique_id + "targetQtConf-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\target_qt.conf");
    installer.setValue(unique_id + "qtToolchainCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\lib\\cmake\\Qt6\\qt.toolchain.cmake");
    installer.setValue(unique_id + "qtBuildInternalsExtraCmake-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\lib\\cmake\\Qt6BuildInternals\\QtBuildInternalsExtra.cmake");
    installer.setValue(unique_id + "qtPathsScript-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qtpaths.bat");
    installer.setValue(unique_id + "qtPaths6Script-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\bin\\qtpaths6.bat");
    installer.setValue(unique_id + "qt6DependenciesCMakePath-PatchPath", installer.value(unique_id + "qtPath-PatchPath") + "\\lib\\cmake\\Qt6\\Qt6Dependencies.cmake");
    installer.setValue(unique_id + "newSetCMakePath-PatchPath", installer.toNativeSeparators(installer.value(unique_id + "targetDir-PatchString") + "/Tools/CMake_64/bin/cmake.exe"));

        // Initialize variable based on target arch
        if (target_arch == "singlethread" || target_arch == "multithread") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../wasm_" + target_arch);
        }
        else if (target_arch == "msvc2019_arm64") {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../" + target_arch);
        }
        else {
            installer.setValue(unique_id + "newHostData-PatchPath", "HostData=../android_" + target_arch);
        }

    // Initialize variables used for patching
    installer.setValue(unique_id + "newHostSpec-PatchString", "win32-g++");
    installer.setValue(unique_id + "newLicheck-PatchString", "QT_LICHECK = licheck.exe");
    installer.setValue(unique_id + "newQtPathsPath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "\\qtpaths");
    installer.setValue(unique_id + "newQmakePath-PatchPath", installer.value(unique_id + "newHostBinPath-PatchPath") + "\\qmake");
    installer.setValue(unique_id + "newNDKHost-PatchString", "windows-x86_64");
    installer.setValue(unique_id + "newHostLibExecutables-PatchString", "./bin");
    installer.setValue(unique_id + "originalQtPathsPath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "\\qtpaths");
    installer.setValue(unique_id + "originalQmakePath-PatchPath", installer.value(unique_id + "originalHostBinPath-PatchPath") + "\\qmake");
}

