/*
 * Decompiled with CFR 0.152.
 */
package netscape.palomar.util;

import java.util.Enumeration;
import java.util.Vector;
import netscape.palomar.util.CascadedException;
import netscape.palomar.util.Tree;

public class TreeImpl
implements Tree,
Cloneable {
    protected Tree _parent;
    private Vector _children = new Vector();

    public Tree getParent() {
        return this._parent;
    }

    public void setParent(Tree o) throws CascadedException {
        this._parent = o;
    }

    public void addChildQuiet(Tree oChild) throws CascadedException {
        if (oChild.getParent() != null) {
            CascadedException pex = new CascadedException(37);
            pex.addToken("child", oChild.toString());
            throw pex;
        }
        this._children.addElement(oChild);
        oChild.setParent(this);
    }

    public void insertChildQuiet(Tree oChild, int index) throws CascadedException {
        if (oChild.getParent() != null) {
            CascadedException pex = new CascadedException(37);
            pex.addToken("child", oChild.toString());
            throw pex;
        }
        this._children.insertElementAt(oChild, index);
        oChild.setParent(this);
    }

    public void removeChildQuiet(Tree oChild) throws CascadedException {
        if (oChild.getParent() != this) {
            CascadedException pex = new CascadedException(39);
            pex.addToken("child", oChild.toString());
            throw pex;
        }
        this._children.removeElement(oChild);
        oChild.setParent(null);
    }

    public int numChildren() {
        return this._children.size();
    }

    public Tree childAt(int index) {
        return (Tree)this._children.elementAt(index);
    }

    public int indexOf(Tree child) throws CascadedException {
        return this._children.indexOf(child);
    }

    public Enumeration getChildren() {
        return this._children.elements();
    }

    public Tree cloneTree() throws CascadedException {
        try {
            Tree newTree = (Tree)super.clone();
            newTree.beenCloned();
            return newTree;
        }
        catch (Exception ex) {
            CascadedException c = new CascadedException(40, ex);
            c.addToken("parent", this.toString());
            throw c;
        }
    }

    public void beenCloned() throws CascadedException {
        try {
            this._parent = null;
            if (this._children != null) {
                Vector oldChildren = this._children;
                this._children = new Vector();
                int last = oldChildren.size();
                int i = 0;
                while (i < last) {
                    Tree oChild = (Tree)oldChildren.elementAt(i);
                    this.addChildQuiet(oChild.cloneTree());
                    ++i;
                }
                return;
            }
        }
        catch (Exception ex) {
            CascadedException c = new CascadedException(41, ex);
            c.addToken("parent", this.toString());
            throw c;
        }
    }

    public Tree findCommonAncestor(Tree otherElement) throws CascadedException {
        Tree grandParent = this;
        while (grandParent != null) {
            Tree search2 = otherElement;
            while (search2 != null) {
                if (grandParent == search2) {
                    return grandParent;
                }
                search2 = search2.getParent();
            }
            grandParent = grandParent.getParent();
        }
        return null;
    }

    public void flush() throws CascadedException {
        Vector myChildren = this._children;
        this._children = null;
        this._parent = null;
        int last = myChildren.size();
        int i = 0;
        while (i < last) {
            ((TreeImpl)myChildren.elementAt(i)).flush();
            ++i;
        }
    }
}

