#include "stdsys.h"
#define UNICODE
#include <windows.h>
#include <lmerr.h>
#include <lmcons.h>
#include <lmserver.h>

using namespace std;

//
// query_server_comment()
//
// Call ::NetGetServerInfo() and return the comment string.
//

wstring query_server_comment(const string& _fn)
   {
      string::size_type p = _fn.rfind('\\');
      string name((p > 1) ? _fn.substr(0, p) : _fn);
      wstring wname(_fn.length() * 2, 0);
      MultiByteToWideChar(CP_ACP, 0, name.c_str(), name.length(), wname.begin(), name.length());
      LPBYTE info;
      NET_API_STATUS status = ::NetServerGetInfo(wname.begin(), 101, &info);
      if (status == NERR_Success) {
         return reinterpret_cast<SERVER_INFO_101*>(info)->sv101_comment;
      } else {
         return L"";
      }
   }

