#!/bin/sh
# Copyright (C) 1998 John H Terpstra, 2000 Klaus Singvogel
#
SPECDIR=${SPECDIR:-/usr/src/OpenLinux/SPECS}
SRCDIR=${SRCDIR:-/usr/src/OpenLinux/SOURCES}
USERID=`id -u`
GRPID=`id -g`

( cd ../../../.. ; chown -R ${USERID}.${GRPID} ${SRCDIR}/samba )
( cd ../../../.. ; tar czvf ${SRCDIR}/samba-2.2.0-20010417.tar.gz samba )
cp -a *.spec *.spec-lsb $SPECDIR
for src in *.patch; do
  trg=`echo $src | sed 's;xxxxxx;2.2.0;'`
  cp -a $src $SRCDIR/$trg
done
cd $SPECDIR
mv samba2.spec samba2.spec-nonlsb
ln samba2.spec-lsb samba2.spec
rpm -ba -v samba2.spec
