/* This file is autogenerated by pidl. DO NOT EDIT */
%module atsvc

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_atsvc_c.h"
#include "librpc/gen_ndr/atsvc.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}



%inline {
struct atsvc { struct dcerpc_pipe *pipe; };
}

%extend atsvc {
	atsvc (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct atsvc *ret = talloc(mem_ctx, struct atsvc);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_atsvc, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~atsvc() {
		talloc_free(self);
	}
	
	/* atsvc_JobAdd */
	NTSTATUS JobAdd(const char *servername, struct atsvc_JobInfo *job_info, uint32_t *job_id, TALLOC_CTX *mem_ctx = NULL)
	{
		struct atsvc_JobAdd r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.job_info = job_info;
		
		status = dcerpc_atsvc_JobAdd(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*job_id = *r.out.job_id;
		return r.out.result;
	}
	
	/* atsvc_JobDel */
	NTSTATUS JobDel(const char *servername, uint32_t min_job_id, uint32_t max_job_id, TALLOC_CTX *mem_ctx = NULL)
	{
		struct atsvc_JobDel r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.min_job_id = min_job_id;
		r.in.max_job_id = max_job_id;
		
		status = dcerpc_atsvc_JobDel(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* atsvc_JobEnum */
	NTSTATUS JobEnum(const char *servername, struct atsvc_enum_ctr *ctr, uint32_t preferred_max_len, uint32_t *total_entries, uint32_t *resume_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct atsvc_JobEnum r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.ctr = ctr;
		r.in.preferred_max_len = preferred_max_len;
		r.in.resume_handle = resume_handle;
		
		status = dcerpc_atsvc_JobEnum(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ctr = *r.out.ctr;
		*total_entries = *r.out.total_entries;
		*resume_handle = *r.out.resume_handle;
		return r.out.result;
	}
	
	/* atsvc_JobGetInfo */
	NTSTATUS JobGetInfo(const char *servername, uint32_t job_id, struct atsvc_JobInfo **job_info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct atsvc_JobGetInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.job_id = job_id;
		
		status = dcerpc_atsvc_JobGetInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*job_info = *r.out.job_info;
		return r.out.result;
	}
	
};

/* atsvc_DaysOfMonth */
/* atsvc_Flags */
/* atsvc_DaysOfWeek */
/* atsvc_JobInfo */
/* atsvc_JobEnumInfo */
/* atsvc_enum_ctr */

