/* This file is autogenerated by pidl. DO NOT EDIT */
%module dfs

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_dfs_c.h"
#include "librpc/gen_ndr/dfs.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(dfs_VolumeState);
%types(dfs_StorageState);
%types(dfs_PropertyFlags);


%inline {
struct netdfs { struct dcerpc_pipe *pipe; };
}

%extend netdfs {
	netdfs (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct netdfs *ret = talloc(mem_ctx, struct netdfs);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_netdfs, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~netdfs() {
		talloc_free(self);
	}
	
	/* dfs_GetManagerVersion */
	void GetManagerVersion(enum dfs_ManagerVersion *version, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_GetManagerVersion r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_GetManagerVersion(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		*version = *r.out.version;
	}
	
	/* dfs_Add */
	WERROR Add(const char *path, const char *server, const char *share, const char *comment, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Add r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.path = path;
		r.in.server = server;
		r.in.share = share;
		r.in.comment = comment;
		r.in.flags = flags;
		
		status = dcerpc_dfs_Add(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_Remove */
	WERROR Remove(const char *dfs_entry_path, const char *servername, const char *sharename, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Remove r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.dfs_entry_path = dfs_entry_path;
		r.in.servername = servername;
		r.in.sharename = sharename;
		
		status = dcerpc_dfs_Remove(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_SetInfo */
	WERROR SetInfo(const char *dfs_entry_path, const char *servername, const char *sharename, uint32_t level, union dfs_Info *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_SetInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.dfs_entry_path = dfs_entry_path;
		r.in.servername = servername;
		r.in.sharename = sharename;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_dfs_SetInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_GetInfo */
	WERROR GetInfo(const char *dfs_entry_path, const char *servername, const char *sharename, uint32_t level, union dfs_Info *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_GetInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.dfs_entry_path = dfs_entry_path;
		r.in.servername = servername;
		r.in.sharename = sharename;
		r.in.level = level;
		
		status = dcerpc_dfs_GetInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* dfs_Enum */
	WERROR Enum(uint32_t level, uint32_t bufsize, struct dfs_EnumStruct *info, uint32_t *total, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Enum r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.bufsize = bufsize;
		r.in.info = info;
		r.in.total = total;
		
		status = dcerpc_dfs_Enum(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		*total = *r.out.total;
		return r.out.result;
	}
	
	/* dfs_Rename */
	WERROR Rename(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Rename r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_Rename(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_Move */
	WERROR Move(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Move r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_Move(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_ManagerGetConfigInfo */
	WERROR ManagerGetConfigInfo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_ManagerGetConfigInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_ManagerGetConfigInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_ManagerSendSiteInfo */
	WERROR ManagerSendSiteInfo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_ManagerSendSiteInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_ManagerSendSiteInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_AddFtRoot */
	WERROR AddFtRoot(const char *servername, const char *dns_servername, const char *dfsname, const char *rootshare, const char *comment, const char *dfs_config_dn, uint8_t unknown1, uint32_t flags, struct dfs_UnknownStruct **unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_AddFtRoot r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.dns_servername = dns_servername;
		r.in.dfsname = dfsname;
		r.in.rootshare = rootshare;
		r.in.comment = comment;
		r.in.dfs_config_dn = dfs_config_dn;
		r.in.unknown1 = unknown1;
		r.in.flags = flags;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_dfs_AddFtRoot(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*unknown2 = *r.out.unknown2;
		return r.out.result;
	}
	
	/* dfs_RemoveFtRoot */
	WERROR RemoveFtRoot(const char *servername, const char *dns_servername, const char *dfsname, const char *rootshare, uint32_t flags, struct dfs_UnknownStruct **unknown, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_RemoveFtRoot r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.dns_servername = dns_servername;
		r.in.dfsname = dfsname;
		r.in.rootshare = rootshare;
		r.in.flags = flags;
		r.in.unknown = unknown;
		
		status = dcerpc_dfs_RemoveFtRoot(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*unknown = *r.out.unknown;
		return r.out.result;
	}
	
	/* dfs_AddStdRoot */
	WERROR AddStdRoot(const char *servername, const char *rootshare, const char *comment, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_AddStdRoot r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.rootshare = rootshare;
		r.in.comment = comment;
		r.in.flags = flags;
		
		status = dcerpc_dfs_AddStdRoot(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_RemoveStdRoot */
	WERROR RemoveStdRoot(const char *servername, const char *rootshare, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_RemoveStdRoot r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.rootshare = rootshare;
		r.in.flags = flags;
		
		status = dcerpc_dfs_RemoveStdRoot(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_ManagerInitialize */
	WERROR ManagerInitialize(const char *servername, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_ManagerInitialize r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.flags = flags;
		
		status = dcerpc_dfs_ManagerInitialize(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_AddStdRootForced */
	WERROR AddStdRootForced(const char *servername, const char *rootshare, const char *comment, const char *store, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_AddStdRootForced r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.rootshare = rootshare;
		r.in.comment = comment;
		r.in.store = store;
		
		status = dcerpc_dfs_AddStdRootForced(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_GetDcAddress */
	WERROR GetDcAddress(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_GetDcAddress r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_GetDcAddress(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_SetDcAddress */
	WERROR SetDcAddress(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_SetDcAddress r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_SetDcAddress(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_FlushFtTable */
	WERROR FlushFtTable(const char *servername, const char *rootshare, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_FlushFtTable r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.rootshare = rootshare;
		
		status = dcerpc_dfs_FlushFtTable(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_Add2 */
	WERROR Add2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Add2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_Add2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_Remove2 */
	WERROR Remove2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_Remove2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_Remove2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* dfs_EnumEx */
	WERROR EnumEx(const char *dfs_name, uint32_t level, uint32_t bufsize, struct dfs_EnumStruct *info, uint32_t *total, TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_EnumEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.dfs_name = dfs_name;
		r.in.level = level;
		r.in.bufsize = bufsize;
		r.in.info = info;
		r.in.total = total;
		
		status = dcerpc_dfs_EnumEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		*total = *r.out.total;
		return r.out.result;
	}
	
	/* dfs_SetInfo2 */
	WERROR SetInfo2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct dfs_SetInfo2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_dfs_SetInfo2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* dfs_ManagerVersion */
/* dfs_Info0 */
/* dfs_Info1 */
/* dfs_VolumeState */
/* dfs_Info2 */
/* dfs_StorageState */
/* dfs_StorageInfo */
/* dfs_Info3 */
/* dfs_Info4 */
/* dfs_PropertyFlags */
/* dfs_Info5 */
/* dfs_Target_PriorityClass */
/* dfs_Target_Priority */
/* dfs_StorageInfo2 */
/* dfs_Info6 */
/* dfs_Info7 */
/* dfs_Info100 */
/* dfs_Info101 */
/* dfs_Info102 */
/* dfs_Info103 */
/* dfs_Info104 */
/* dfs_Info105 */
/* dfs_Info106 */
/* dfs_Info200 */
/* dfs_VolumeFlavor */
/* dfs_Info300 */
/* dfs_Info */
/* dfs_EnumArray1 */
/* dfs_EnumArray2 */
/* dfs_EnumArray3 */
/* dfs_EnumArray4 */
/* dfs_EnumArray200 */
/* dfs_EnumArray300 */
/* dfs_EnumInfo */
/* dfs_EnumStruct */
/* dfs_UnknownStruct */

