/* This file is autogenerated by pidl. DO NOT EDIT */
%module lsa

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_lsa_c.h"
#include "librpc/gen_ndr/lsa.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(lsa_String);
%types(lsa_StringLarge);
%types(lsa_Strings);
%types(lsa_AsciiString);
%types(lsa_SidArray);


%inline {
struct lsarpc { struct dcerpc_pipe *pipe; };
}

%extend lsarpc {
	lsarpc (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct lsarpc *ret = talloc(mem_ctx, struct lsarpc);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_lsarpc, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~lsarpc() {
		talloc_free(self);
	}
	
	/* lsa_Close */
	NTSTATUS Close(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_Close r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_lsa_Close(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* lsa_Delete */
	NTSTATUS Delete(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_Delete r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_lsa_Delete(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_EnumPrivs */
	NTSTATUS EnumPrivs(struct policy_handle *handle, uint32_t *resume_handle, uint32_t max_count, struct lsa_PrivArray *privs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumPrivs r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.resume_handle = resume_handle;
		r.in.max_count = max_count;
		
		status = dcerpc_lsa_EnumPrivs(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*privs = *r.out.privs;
		return r.out.result;
	}
	
	/* lsa_QuerySecurity */
	NTSTATUS QuerySecurity(struct policy_handle *handle, uint32_t sec_info, struct sec_desc_buf *sdbuf, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QuerySecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sec_info = sec_info;
		
		status = dcerpc_lsa_QuerySecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sdbuf = *r.out.sdbuf;
		return r.out.result;
	}
	
	/* lsa_SetSecObj */
	NTSTATUS SetSecObj(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetSecObj r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetSecObj(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_ChangePassword */
	NTSTATUS ChangePassword(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_ChangePassword r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_ChangePassword(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_OpenPolicy */
	NTSTATUS OpenPolicy(uint16_t *system_name, struct lsa_ObjectAttribute *attr, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenPolicy r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.attr = attr;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenPolicy(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* lsa_QueryInfoPolicy */
	NTSTATUS QueryInfoPolicy(struct policy_handle *handle, uint16_t level, union lsa_PolicyInformation *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryInfoPolicy r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryInfoPolicy(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetInfoPolicy */
	NTSTATUS SetInfoPolicy(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetInfoPolicy r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetInfoPolicy(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_ClearAuditLog */
	NTSTATUS ClearAuditLog(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_ClearAuditLog r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_ClearAuditLog(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CreateAccount */
	NTSTATUS CreateAccount(struct policy_handle *handle, struct dom_sid2 *sid, uint32_t access_mask, struct policy_handle *acct_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CreateAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_CreateAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*acct_handle = *r.out.acct_handle;
		return r.out.result;
	}
	
	/* lsa_EnumAccounts */
	NTSTATUS EnumAccounts(struct policy_handle *handle, uint32_t *resume_handle, uint32_t num_entries, struct lsa_SidArray *sids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumAccounts r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.resume_handle = resume_handle;
		r.in.num_entries = num_entries;
		
		status = dcerpc_lsa_EnumAccounts(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*sids = *r.out.sids;
		return r.out.result;
	}
	
	/* lsa_CreateTrustedDomain */
	NTSTATUS CreateTrustedDomain(struct policy_handle *handle, struct lsa_DomainInfo *info, uint32_t access_mask, struct policy_handle *trustdom_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CreateTrustedDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info = info;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_CreateTrustedDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*trustdom_handle = *r.out.trustdom_handle;
		return r.out.result;
	}
	
	/* lsa_EnumTrustDom */
	NTSTATUS EnumTrustDom(struct policy_handle *handle, uint32_t *resume_handle, uint32_t max_size, struct lsa_DomainList *domains, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumTrustDom r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.resume_handle = resume_handle;
		r.in.max_size = max_size;
		
		status = dcerpc_lsa_EnumTrustDom(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*domains = *r.out.domains;
		return r.out.result;
	}
	
	/* lsa_LookupNames */
	NTSTATUS LookupNames(struct policy_handle *handle, uint32_t num_names, struct lsa_String *names, struct lsa_RefDomainList *domains, struct lsa_TransSidArray *sids, uint16_t level, uint32_t *count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupNames r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.num_names = num_names;
		r.in.names = names;
		r.in.sids = sids;
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc_lsa_LookupNames(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*sids = *r.out.sids;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_LookupSids */
	NTSTATUS LookupSids(struct policy_handle *handle, struct lsa_SidArray *sids, struct lsa_RefDomainList *domains, struct lsa_TransNameArray *names, uint16_t level, uint32_t *count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupSids r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sids = sids;
		r.in.names = names;
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc_lsa_LookupSids(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*names = *r.out.names;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_CreateSecret */
	NTSTATUS CreateSecret(struct policy_handle *handle, struct lsa_String name, uint32_t access_mask, struct policy_handle *sec_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CreateSecret r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_CreateSecret(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sec_handle = *r.out.sec_handle;
		return r.out.result;
	}
	
	/* lsa_OpenAccount */
	NTSTATUS OpenAccount(struct policy_handle *handle, struct dom_sid2 *sid, uint32_t access_mask, struct policy_handle *acct_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*acct_handle = *r.out.acct_handle;
		return r.out.result;
	}
	
	/* lsa_EnumPrivsAccount */
	NTSTATUS EnumPrivsAccount(struct policy_handle *handle, struct lsa_PrivilegeSet *privs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumPrivsAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_lsa_EnumPrivsAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*privs = *r.out.privs;
		return r.out.result;
	}
	
	/* lsa_AddPrivilegesToAccount */
	NTSTATUS AddPrivilegesToAccount(struct policy_handle *handle, struct lsa_PrivilegeSet *privs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_AddPrivilegesToAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.privs = privs;
		
		status = dcerpc_lsa_AddPrivilegesToAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_RemovePrivilegesFromAccount */
	NTSTATUS RemovePrivilegesFromAccount(struct policy_handle *handle, uint8_t remove_all, struct lsa_PrivilegeSet *privs, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_RemovePrivilegesFromAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.remove_all = remove_all;
		r.in.privs = privs;
		
		status = dcerpc_lsa_RemovePrivilegesFromAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_GetQuotasForAccount */
	NTSTATUS GetQuotasForAccount(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_GetQuotasForAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_GetQuotasForAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_SetQuotasForAccount */
	NTSTATUS SetQuotasForAccount(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetQuotasForAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetQuotasForAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_GetSystemAccessAccount */
	NTSTATUS GetSystemAccessAccount(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_GetSystemAccessAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_GetSystemAccessAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_SetSystemAccessAccount */
	NTSTATUS SetSystemAccessAccount(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetSystemAccessAccount r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetSystemAccessAccount(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_OpenTrustedDomain */
	NTSTATUS OpenTrustedDomain(struct policy_handle *handle, struct dom_sid2 *sid, uint32_t access_mask, struct policy_handle *trustdom_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenTrustedDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenTrustedDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*trustdom_handle = *r.out.trustdom_handle;
		return r.out.result;
	}
	
	/* lsa_QueryTrustedDomainInfo */
	NTSTATUS QueryTrustedDomainInfo(struct policy_handle *trustdom_handle, enum lsa_TrustDomInfoEnum level, union lsa_TrustedDomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryTrustedDomainInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.trustdom_handle = trustdom_handle;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryTrustedDomainInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetInformationTrustedDomain */
	NTSTATUS SetInformationTrustedDomain(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetInformationTrustedDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetInformationTrustedDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_OpenSecret */
	NTSTATUS OpenSecret(struct policy_handle *handle, struct lsa_String name, uint32_t access_mask, struct policy_handle *sec_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenSecret r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenSecret(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sec_handle = *r.out.sec_handle;
		return r.out.result;
	}
	
	/* lsa_SetSecret */
	NTSTATUS SetSecret(struct policy_handle *sec_handle, struct lsa_DATA_BUF *new_val, struct lsa_DATA_BUF *old_val, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetSecret r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.sec_handle = sec_handle;
		r.in.new_val = new_val;
		r.in.old_val = old_val;
		
		status = dcerpc_lsa_SetSecret(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_QuerySecret */
	NTSTATUS QuerySecret(struct policy_handle *sec_handle, struct lsa_DATA_BUF_PTR *new_val, NTTIME *new_mtime, struct lsa_DATA_BUF_PTR *old_val, NTTIME *old_mtime, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QuerySecret r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.sec_handle = sec_handle;
		r.in.new_val = new_val;
		r.in.new_mtime = new_mtime;
		r.in.old_val = old_val;
		r.in.old_mtime = old_mtime;
		
		status = dcerpc_lsa_QuerySecret(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*new_val = *r.out.new_val;
		*new_mtime = *r.out.new_mtime;
		*old_val = *r.out.old_val;
		*old_mtime = *r.out.old_mtime;
		return r.out.result;
	}
	
	/* lsa_LookupPrivValue */
	NTSTATUS LookupPrivValue(struct policy_handle *handle, struct lsa_String *name, struct lsa_LUID *luid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupPrivValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		
		status = dcerpc_lsa_LookupPrivValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*luid = *r.out.luid;
		return r.out.result;
	}
	
	/* lsa_LookupPrivName */
	NTSTATUS LookupPrivName(struct policy_handle *handle, struct lsa_LUID *luid, struct lsa_StringLarge *name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupPrivName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.luid = luid;
		
		status = dcerpc_lsa_LookupPrivName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*name = *r.out.name;
		return r.out.result;
	}
	
	/* lsa_LookupPrivDisplayName */
	NTSTATUS LookupPrivDisplayName(struct policy_handle *handle, struct lsa_String *name, struct lsa_StringLarge *disp_name, uint16_t *language_id, uint16_t unknown, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupPrivDisplayName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.language_id = language_id;
		r.in.unknown = unknown;
		
		status = dcerpc_lsa_LookupPrivDisplayName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*disp_name = *r.out.disp_name;
		*language_id = *r.out.language_id;
		return r.out.result;
	}
	
	/* lsa_DeleteObject */
	NTSTATUS DeleteObject(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_DeleteObject r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_DeleteObject(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_EnumAccountsWithUserRight */
	NTSTATUS EnumAccountsWithUserRight(struct policy_handle *handle, struct lsa_String *name, struct lsa_SidArray *sids, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumAccountsWithUserRight r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		
		status = dcerpc_lsa_EnumAccountsWithUserRight(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sids = *r.out.sids;
		return r.out.result;
	}
	
	/* lsa_EnumAccountRights */
	NTSTATUS EnumAccountRights(struct policy_handle *handle, struct dom_sid2 *sid, struct lsa_RightSet *rights, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumAccountRights r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		
		status = dcerpc_lsa_EnumAccountRights(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*rights = *r.out.rights;
		return r.out.result;
	}
	
	/* lsa_AddAccountRights */
	NTSTATUS AddAccountRights(struct policy_handle *handle, struct dom_sid2 *sid, struct lsa_RightSet *rights, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_AddAccountRights r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		r.in.rights = rights;
		
		status = dcerpc_lsa_AddAccountRights(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_RemoveAccountRights */
	NTSTATUS RemoveAccountRights(struct policy_handle *handle, struct dom_sid2 *sid, uint32_t unknown, struct lsa_RightSet *rights, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_RemoveAccountRights r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sid = sid;
		r.in.unknown = unknown;
		r.in.rights = rights;
		
		status = dcerpc_lsa_RemoveAccountRights(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_QueryTrustedDomainInfoBySid */
	NTSTATUS QueryTrustedDomainInfoBySid(struct policy_handle *handle, struct dom_sid2 *dom_sid, enum lsa_TrustDomInfoEnum level, union lsa_TrustedDomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryTrustedDomainInfoBySid r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.dom_sid = dom_sid;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryTrustedDomainInfoBySid(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetTrustedDomainInfo */
	NTSTATUS SetTrustedDomainInfo(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetTrustedDomainInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetTrustedDomainInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_DeleteTrustedDomain */
	NTSTATUS DeleteTrustedDomain(struct policy_handle *handle, struct dom_sid2 *dom_sid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_DeleteTrustedDomain r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.dom_sid = dom_sid;
		
		status = dcerpc_lsa_DeleteTrustedDomain(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_StorePrivateData */
	NTSTATUS StorePrivateData(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_StorePrivateData r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_StorePrivateData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_RetrievePrivateData */
	NTSTATUS RetrievePrivateData(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_RetrievePrivateData r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_RetrievePrivateData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_OpenPolicy2 */
	NTSTATUS OpenPolicy2(const char *system_name, struct lsa_ObjectAttribute *attr, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenPolicy2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.attr = attr;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenPolicy2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* lsa_GetUserName */
	NTSTATUS GetUserName(const char *system_name, struct lsa_String *account_name, struct lsa_StringPointer *authority_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_GetUserName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.account_name = account_name;
		r.in.authority_name = authority_name;
		
		status = dcerpc_lsa_GetUserName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*account_name = *r.out.account_name;
		*authority_name = *r.out.authority_name;
		return r.out.result;
	}
	
	/* lsa_QueryInfoPolicy2 */
	NTSTATUS QueryInfoPolicy2(struct policy_handle *handle, uint16_t level, union lsa_PolicyInformation *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryInfoPolicy2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryInfoPolicy2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetInfoPolicy2 */
	NTSTATUS SetInfoPolicy2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetInfoPolicy2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_SetInfoPolicy2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_QueryTrustedDomainInfoByName */
	NTSTATUS QueryTrustedDomainInfoByName(struct policy_handle *handle, struct lsa_String trusted_domain, enum lsa_TrustDomInfoEnum level, union lsa_TrustedDomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryTrustedDomainInfoByName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.trusted_domain = trusted_domain;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryTrustedDomainInfoByName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetTrustedDomainInfoByName */
	NTSTATUS SetTrustedDomainInfoByName(struct policy_handle *handle, struct lsa_String trusted_domain, enum lsa_TrustDomInfoEnum level, union lsa_TrustedDomainInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetTrustedDomainInfoByName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.trusted_domain = trusted_domain;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_lsa_SetTrustedDomainInfoByName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_EnumTrustedDomainsEx */
	NTSTATUS EnumTrustedDomainsEx(struct policy_handle *handle, uint32_t *resume_handle, struct lsa_DomainListEx *domains, uint32_t max_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_EnumTrustedDomainsEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.resume_handle = resume_handle;
		r.in.max_size = max_size;
		
		status = dcerpc_lsa_EnumTrustedDomainsEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*resume_handle = *r.out.resume_handle;
		*domains = *r.out.domains;
		return r.out.result;
	}
	
	/* lsa_CreateTrustedDomainEx */
	NTSTATUS CreateTrustedDomainEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CreateTrustedDomainEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CreateTrustedDomainEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CloseTrustedDomainEx */
	NTSTATUS CloseTrustedDomainEx(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CloseTrustedDomainEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_lsa_CloseTrustedDomainEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* lsa_QueryDomainInformationPolicy */
	NTSTATUS QueryDomainInformationPolicy(struct policy_handle *handle, uint16_t level, union lsa_DomainInformationPolicy *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_QueryDomainInformationPolicy r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		
		status = dcerpc_lsa_QueryDomainInformationPolicy(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* lsa_SetDomainInformationPolicy */
	NTSTATUS SetDomainInformationPolicy(struct policy_handle *handle, uint16_t level, union lsa_DomainInformationPolicy *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_SetDomainInformationPolicy r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_lsa_SetDomainInformationPolicy(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_OpenTrustedDomainByName */
	NTSTATUS OpenTrustedDomainByName(struct policy_handle *handle, struct lsa_String name, uint32_t access_mask, struct policy_handle *trustdom_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_OpenTrustedDomainByName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_lsa_OpenTrustedDomainByName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*trustdom_handle = *r.out.trustdom_handle;
		return r.out.result;
	}
	
	/* lsa_TestCall */
	NTSTATUS TestCall(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_TestCall r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_TestCall(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LookupSids2 */
	NTSTATUS LookupSids2(struct policy_handle *handle, struct lsa_SidArray *sids, struct lsa_RefDomainList *domains, struct lsa_TransNameArray2 *names, uint16_t level, uint32_t *count, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupSids2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sids = sids;
		r.in.names = names;
		r.in.level = level;
		r.in.count = count;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_lsa_LookupSids2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*names = *r.out.names;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_LookupNames2 */
	NTSTATUS LookupNames2(struct policy_handle *handle, uint32_t num_names, struct lsa_String *names, struct lsa_RefDomainList *domains, struct lsa_TransSidArray2 *sids, uint16_t level, uint32_t *count, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupNames2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.num_names = num_names;
		r.in.names = names;
		r.in.sids = sids;
		r.in.level = level;
		r.in.count = count;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_lsa_LookupNames2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*sids = *r.out.sids;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_CreateTrustedDomainEx2 */
	NTSTATUS CreateTrustedDomainEx2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CreateTrustedDomainEx2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CreateTrustedDomainEx2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRWRITE */
	NTSTATUS CREDRWRITE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRWRITE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRWRITE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRREAD */
	NTSTATUS CREDRREAD(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRREAD r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRREAD(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRENUMERATE */
	NTSTATUS CREDRENUMERATE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRENUMERATE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRENUMERATE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRWRITEDOMAINCREDENTIALS */
	NTSTATUS CREDRWRITEDOMAINCREDENTIALS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRWRITEDOMAINCREDENTIALS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRWRITEDOMAINCREDENTIALS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRREADDOMAINCREDENTIALS */
	NTSTATUS CREDRREADDOMAINCREDENTIALS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRREADDOMAINCREDENTIALS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRREADDOMAINCREDENTIALS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRDELETE */
	NTSTATUS CREDRDELETE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRDELETE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRDELETE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRGETTARGETINFO */
	NTSTATUS CREDRGETTARGETINFO(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRGETTARGETINFO r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRGETTARGETINFO(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRPROFILELOADED */
	NTSTATUS CREDRPROFILELOADED(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRPROFILELOADED r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRPROFILELOADED(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LookupNames3 */
	NTSTATUS LookupNames3(struct policy_handle *handle, uint32_t num_names, struct lsa_String *names, struct lsa_RefDomainList *domains, struct lsa_TransSidArray3 *sids, uint16_t level, uint32_t *count, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupNames3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.num_names = num_names;
		r.in.names = names;
		r.in.sids = sids;
		r.in.level = level;
		r.in.count = count;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_lsa_LookupNames3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*sids = *r.out.sids;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_CREDRGETSESSIONTYPES */
	NTSTATUS CREDRGETSESSIONTYPES(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRGETSESSIONTYPES r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRGETSESSIONTYPES(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARREGISTERAUDITEVENT */
	NTSTATUS LSARREGISTERAUDITEVENT(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARREGISTERAUDITEVENT r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARREGISTERAUDITEVENT(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARGENAUDITEVENT */
	NTSTATUS LSARGENAUDITEVENT(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARGENAUDITEVENT r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARGENAUDITEVENT(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARUNREGISTERAUDITEVENT */
	NTSTATUS LSARUNREGISTERAUDITEVENT(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARUNREGISTERAUDITEVENT r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARUNREGISTERAUDITEVENT(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARQUERYFORESTTRUSTINFORMATION */
	NTSTATUS LSARQUERYFORESTTRUSTINFORMATION(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARQUERYFORESTTRUSTINFORMATION r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARQUERYFORESTTRUSTINFORMATION(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARSETFORESTTRUSTINFORMATION */
	NTSTATUS LSARSETFORESTTRUSTINFORMATION(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARSETFORESTTRUSTINFORMATION r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARSETFORESTTRUSTINFORMATION(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_CREDRRENAME */
	NTSTATUS CREDRRENAME(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_CREDRRENAME r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_CREDRRENAME(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LookupSids3 */
	NTSTATUS LookupSids3(struct lsa_SidArray *sids, struct lsa_RefDomainList *domains, struct lsa_TransNameArray2 *names, uint16_t level, uint32_t *count, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupSids3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.sids = sids;
		r.in.names = names;
		r.in.level = level;
		r.in.count = count;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_lsa_LookupSids3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*names = *r.out.names;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_LookupNames4 */
	NTSTATUS LookupNames4(uint32_t num_names, struct lsa_String *names, struct lsa_RefDomainList *domains, struct lsa_TransSidArray3 *sids, uint16_t level, uint32_t *count, uint32_t unknown1, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LookupNames4 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.num_names = num_names;
		r.in.names = names;
		r.in.sids = sids;
		r.in.level = level;
		r.in.count = count;
		r.in.unknown1 = unknown1;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_lsa_LookupNames4(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*domains = *r.out.domains;
		*sids = *r.out.sids;
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* lsa_LSAROPENPOLICYSCE */
	NTSTATUS LSAROPENPOLICYSCE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSAROPENPOLICYSCE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSAROPENPOLICYSCE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARADTREGISTERSECURITYEVENTSOURCE */
	NTSTATUS LSARADTREGISTERSECURITYEVENTSOURCE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE */
	NTSTATUS LSARADTUNREGISTERSECURITYEVENTSOURCE(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* lsa_LSARADTREPORTSECURITYEVENT */
	NTSTATUS LSARADTREPORTSECURITYEVENT(TALLOC_CTX *mem_ctx = NULL)
	{
		struct lsa_LSARADTREPORTSECURITYEVENT r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_lsa_LSARADTREPORTSECURITYEVENT(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* lsa_String */
/* lsa_StringLarge */
/* lsa_Strings */
/* lsa_AsciiString */
/* lsa_LUID */
/* lsa_PrivEntry */
/* lsa_PrivArray */
/* lsa_QosInfo */
/* lsa_ObjectAttribute */
/* lsa_AuditLogInfo */
/* lsa_AuditEventsInfo */
/* lsa_DomainInfo */
/* lsa_PDAccountInfo */
/* lsa_ServerRole */
/* lsa_ReplicaSourceInfo */
/* lsa_DefaultQuotaInfo */
/* lsa_ModificationInfo */
/* lsa_AuditFullSetInfo */
/* lsa_AuditFullQueryInfo */
/* lsa_DnsDomainInfo */
/* lsaPolicyInfo */
/* lsa_PolicyInformation */
/* lsa_SidPtr */
/* lsa_SidArray */
/* lsa_DomainList */
/* lsa_SidType */
/* lsa_TranslatedSid */
/* lsa_TransSidArray */
/* lsa_RefDomainList */
/* lsa_TranslatedName */
/* lsa_TransNameArray */
/* lsa_LUIDAttribute */
/* lsa_PrivilegeSet */
/* lsa_DATA_BUF */
/* lsa_DATA_BUF2 */
/* lsa_TrustDomInfoEnum */
/* lsa_TrustDomainInfoName */
/* lsa_TrustDomainInfoPosixOffset */
/* lsa_TrustDomainInfoPassword */
/* lsa_TrustDomainInfoBasic */
/* lsa_TrustDomainInfoInfoEx */
/* lsa_TrustDomainInfoBuffer */
/* lsa_TrustDomainInfoAuthInfo */
/* lsa_TrustDomainInfoFullInfo */
/* lsa_TrustDomainInfo11 */
/* lsa_TrustDomainInfoInfoAll */
/* lsa_TrustedDomainInfo */
/* lsa_DATA_BUF_PTR */
/* lsa_RightAttribute */
/* lsa_RightSet */
/* lsa_StringPointer */
/* lsa_DomainListEx */
/* lsa_DomainInfoKerberos */
/* lsa_DomainInfoEfs */
/* lsa_DomainInfoEnum */
/* lsa_DomainInformationPolicy */
/* lsa_TranslatedName2 */
/* lsa_TransNameArray2 */
/* lsa_TranslatedSid2 */
/* lsa_TransSidArray2 */
/* lsa_TranslatedSid3 */
/* lsa_TransSidArray3 */

