
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_dfs.h"
#include "librpc/gen_ndr/ndr_dfs_ejs.h"


static NTSTATUS ejs_push_dfs_ManagerVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dfs_ManagerVersion *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dfs_VolumeState(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_dfs_VolumeState(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_dfs_Info2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_stores", &r->num_stores));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_stores", &r->num_stores));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dfs_StorageState(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_dfs_StorageState(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_dfs_StorageInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_StorageInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_StorageState(ejs, v, "state", &r->state));
	if (NULL == r->server) {
		NDR_CHECK(ejs_push_null(ejs, v, "server"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server", r->server));
	}
	if (NULL == r->share) {
		NDR_CHECK(ejs_push_null(ejs, v, "share"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "share", r->share));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_StorageInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_StorageInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_StorageState(ejs, v, "state", &r->state));
	if (ejs_pull_null(ejs, v, "server")) {
		r->server = NULL;
	} else {
		EJS_ALLOC(ejs, r->server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->server));
	}
	if (ejs_pull_null(ejs, v, "share")) {
		r->share = NULL;
	} else {
		EJS_ALLOC(ejs, r->share);
		NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->share));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_stores", &r->num_stores));
	if (NULL == r->stores) {
		NDR_CHECK(ejs_push_null(ejs, v, "stores"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_stores;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_push_dfs_StorageInfo(ejs, v, id, &r->stores[i]));
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_stores", &r->num_stores));
	if (ejs_pull_null(ejs, v, "stores")) {
		r->stores = NULL;
	} else {
		EJS_ALLOC(ejs, r->stores);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->stores, r->num_stores);
			for (i=0;i<r->num_stores;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_pull_dfs_StorageInfo(ejs, v, id, &r->stores[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_stores", &r->num_stores));
	if (NULL == r->stores) {
		NDR_CHECK(ejs_push_null(ejs, v, "stores"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_stores;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_push_dfs_StorageInfo(ejs, v, id, &r->stores[i]));
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_stores", &r->num_stores));
	if (ejs_pull_null(ejs, v, "stores")) {
		r->stores = NULL;
	} else {
		EJS_ALLOC(ejs, r->stores);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->stores, r->num_stores);
			for (i=0;i<r->num_stores;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_pull_dfs_StorageInfo(ejs, v, id, &r->stores[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dfs_PropertyFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_dfs_PropertyFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_dfs_Info5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pktsize", &r->pktsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_stores", &r->num_stores));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pktsize", &r->pktsize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_stores", &r->num_stores));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Target_PriorityClass(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dfs_Target_PriorityClass *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Target_PriorityClass(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dfs_Target_PriorityClass *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Target_Priority(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Target_Priority *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_Target_PriorityClass(ejs, v, "target_priority_class", &r->target_priority_class));
	NDR_CHECK(ejs_push_uint16(ejs, v, "target_priority_rank", &r->target_priority_rank));
	NDR_CHECK(ejs_push_uint16(ejs, v, "reserved", &r->reserved));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Target_Priority(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Target_Priority *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_Target_PriorityClass(ejs, v, "target_priority_class", &r->target_priority_class));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "target_priority_rank", &r->target_priority_rank));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reserved", &r->reserved));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_StorageInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_StorageInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_StorageInfo(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_push_dfs_Target_Priority(ejs, v, "target_priority", &r->target_priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_StorageInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_StorageInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_StorageInfo(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_pull_dfs_Target_Priority(ejs, v, "target_priority", &r->target_priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->entry_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "entry_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "entry_path", r->entry_path));
	}
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pktsize", &r->pktsize));
	NDR_CHECK(ejs_push_uint16(ejs, v, "num_stores", &r->num_stores));
	if (NULL == r->stores) {
		NDR_CHECK(ejs_push_null(ejs, v, "stores"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_stores;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_push_dfs_StorageInfo2(ejs, v, id, &r->stores[i]));
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "entry_path")) {
		r->entry_path = NULL;
	} else {
		EJS_ALLOC(ejs, r->entry_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "entry_path", &r->entry_path));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pktsize", &r->pktsize));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "num_stores", &r->num_stores));
	if (ejs_pull_null(ejs, v, "stores")) {
		r->stores = NULL;
	} else {
		EJS_ALLOC(ejs, r->stores);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->stores, r->num_stores);
			for (i=0;i<r->num_stores;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "stores", i);
				NDR_CHECK(ejs_pull_dfs_StorageInfo2(ejs, v, id, &r->stores[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "stores" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "generation_guid", &r->generation_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info7 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "generation_guid", &r->generation_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info100 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info100 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info101 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_StorageState(ejs, v, "state", &r->state));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info101 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_StorageState(ejs, v, "state", &r->state));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info102 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info102 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info103(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info103 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info103(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info103 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_PropertyFlags(ejs, v, "flags", &r->flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info104(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info104 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_Target_Priority(ejs, v, "priority", &r->priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info104(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info104 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_Target_Priority(ejs, v, "priority", &r->priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info105(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info105 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "property_flag_mask", &r->property_flag_mask));
	NDR_CHECK(ejs_push_uint32(ejs, v, "property_flags", &r->property_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info105(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info105 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_dfs_VolumeState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "property_flag_mask", &r->property_flag_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "property_flags", &r->property_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info106(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info106 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_StorageState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_push_dfs_Target_Priority(ejs, v, "priority", &r->priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info106(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info106 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_StorageState(ejs, v, "state", &r->state));
	NDR_CHECK(ejs_pull_dfs_Target_Priority(ejs, v, "priority", &r->priority));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info200(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info200 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->dom_root) {
		NDR_CHECK(ejs_push_null(ejs, v, "dom_root"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dom_root", r->dom_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info200(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info200 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "dom_root")) {
		r->dom_root = NULL;
	} else {
		EJS_ALLOC(ejs, r->dom_root);
		NDR_CHECK(ejs_pull_string(ejs, v, "dom_root", &r->dom_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_VolumeFlavor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dfs_VolumeFlavor *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_VolumeFlavor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dfs_VolumeFlavor *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info300(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_Info300 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dfs_VolumeFlavor(ejs, v, "flavor", &r->flavor));
	if (NULL == r->dom_root) {
		NDR_CHECK(ejs_push_null(ejs, v, "dom_root"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dom_root", r->dom_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_Info300(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_Info300 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dfs_VolumeFlavor(ejs, v, "flavor", &r->flavor));
	if (ejs_pull_null(ejs, v, "dom_root")) {
		r->dom_root = NULL;
	} else {
		EJS_ALLOC(ejs, r->dom_root);
		NDR_CHECK(ejs_pull_string(ejs, v, "dom_root", &r->dom_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_Info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dfs_Info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->info0) {
				NDR_CHECK(ejs_push_null(ejs, v, "info0"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (NULL == r->info2) {
				NDR_CHECK(ejs_push_null(ejs, v, "info2"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (NULL == r->info3) {
				NDR_CHECK(ejs_push_null(ejs, v, "info3"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info3(ejs, v, "info3", r->info3));
			}
			break;
		case 4:
			if (NULL == r->info4) {
				NDR_CHECK(ejs_push_null(ejs, v, "info4"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info4(ejs, v, "info4", r->info4));
			}
			break;
		case 5:
			if (NULL == r->info5) {
				NDR_CHECK(ejs_push_null(ejs, v, "info5"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info5(ejs, v, "info5", r->info5));
			}
			break;
		case 6:
			if (NULL == r->info6) {
				NDR_CHECK(ejs_push_null(ejs, v, "info6"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info6(ejs, v, "info6", r->info6));
			}
			break;
		case 7:
			if (NULL == r->info7) {
				NDR_CHECK(ejs_push_null(ejs, v, "info7"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info7(ejs, v, "info7", r->info7));
			}
			break;
		case 100:
			if (NULL == r->info100) {
				NDR_CHECK(ejs_push_null(ejs, v, "info100"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (NULL == r->info101) {
				NDR_CHECK(ejs_push_null(ejs, v, "info101"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (NULL == r->info102) {
				NDR_CHECK(ejs_push_null(ejs, v, "info102"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info102(ejs, v, "info102", r->info102));
			}
			break;
		case 103:
			if (NULL == r->info103) {
				NDR_CHECK(ejs_push_null(ejs, v, "info103"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info103(ejs, v, "info103", r->info103));
			}
			break;
		case 104:
			if (NULL == r->info104) {
				NDR_CHECK(ejs_push_null(ejs, v, "info104"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info104(ejs, v, "info104", r->info104));
			}
			break;
		case 105:
			if (NULL == r->info105) {
				NDR_CHECK(ejs_push_null(ejs, v, "info105"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info105(ejs, v, "info105", r->info105));
			}
			break;
		case 106:
			if (NULL == r->info106) {
				NDR_CHECK(ejs_push_null(ejs, v, "info106"));
			} else {
				NDR_CHECK(ejs_push_dfs_Info106(ejs, v, "info106", r->info106));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dfs_Info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dfs_Info *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "info0")) {
				r->info0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info0);
				NDR_CHECK(ejs_pull_dfs_Info0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_dfs_Info1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "info2")) {
				r->info2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info2);
				NDR_CHECK(ejs_pull_dfs_Info2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "info3")) {
				r->info3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info3);
				NDR_CHECK(ejs_pull_dfs_Info3(ejs, v, "info3", r->info3));
			}
			break;
		case 4:
			if (ejs_pull_null(ejs, v, "info4")) {
				r->info4 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info4);
				NDR_CHECK(ejs_pull_dfs_Info4(ejs, v, "info4", r->info4));
			}
			break;
		case 5:
			if (ejs_pull_null(ejs, v, "info5")) {
				r->info5 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info5);
				NDR_CHECK(ejs_pull_dfs_Info5(ejs, v, "info5", r->info5));
			}
			break;
		case 6:
			if (ejs_pull_null(ejs, v, "info6")) {
				r->info6 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info6);
				NDR_CHECK(ejs_pull_dfs_Info6(ejs, v, "info6", r->info6));
			}
			break;
		case 7:
			if (ejs_pull_null(ejs, v, "info7")) {
				r->info7 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info7);
				NDR_CHECK(ejs_pull_dfs_Info7(ejs, v, "info7", r->info7));
			}
			break;
		case 100:
			if (ejs_pull_null(ejs, v, "info100")) {
				r->info100 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info100);
				NDR_CHECK(ejs_pull_dfs_Info100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (ejs_pull_null(ejs, v, "info101")) {
				r->info101 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info101);
				NDR_CHECK(ejs_pull_dfs_Info101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (ejs_pull_null(ejs, v, "info102")) {
				r->info102 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info102);
				NDR_CHECK(ejs_pull_dfs_Info102(ejs, v, "info102", r->info102));
			}
			break;
		case 103:
			if (ejs_pull_null(ejs, v, "info103")) {
				r->info103 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info103);
				NDR_CHECK(ejs_pull_dfs_Info103(ejs, v, "info103", r->info103));
			}
			break;
		case 104:
			if (ejs_pull_null(ejs, v, "info104")) {
				r->info104 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info104);
				NDR_CHECK(ejs_pull_dfs_Info104(ejs, v, "info104", r->info104));
			}
			break;
		case 105:
			if (ejs_pull_null(ejs, v, "info105")) {
				r->info105 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info105);
				NDR_CHECK(ejs_pull_dfs_Info105(ejs, v, "info105", r->info105));
			}
			break;
		case 106:
			if (ejs_pull_null(ejs, v, "info106")) {
				r->info106 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info106);
				NDR_CHECK(ejs_pull_dfs_Info106(ejs, v, "info106", r->info106));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_dfs_EnumArray1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info1(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info1(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info2(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info2(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumArray3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info3(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info3(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumArray4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info4(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info4(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumArray200(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray200 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info200(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray200(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray200 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info200(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumArray300(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumArray300 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->s) {
		NDR_CHECK(ejs_push_null(ejs, v, "s"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_push_dfs_Info300(ejs, v, id, &r->s[i]));
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumArray300(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumArray300 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "s")) {
		r->s = NULL;
	} else {
		EJS_ALLOC(ejs, r->s);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->s, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "s", i);
				NDR_CHECK(ejs_pull_dfs_Info300(ejs, v, id, &r->s[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "s" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_EnumInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dfs_EnumInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (NULL == r->info2) {
				NDR_CHECK(ejs_push_null(ejs, v, "info2"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (NULL == r->info3) {
				NDR_CHECK(ejs_push_null(ejs, v, "info3"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray3(ejs, v, "info3", r->info3));
			}
			break;
		case 4:
			if (NULL == r->info4) {
				NDR_CHECK(ejs_push_null(ejs, v, "info4"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray4(ejs, v, "info4", r->info4));
			}
			break;
		case 200:
			if (NULL == r->info200) {
				NDR_CHECK(ejs_push_null(ejs, v, "info200"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray200(ejs, v, "info200", r->info200));
			}
			break;
		case 300:
			if (NULL == r->info300) {
				NDR_CHECK(ejs_push_null(ejs, v, "info300"));
			} else {
				NDR_CHECK(ejs_push_dfs_EnumArray300(ejs, v, "info300", r->info300));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dfs_EnumInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dfs_EnumInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_dfs_EnumArray1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "info2")) {
				r->info2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info2);
				NDR_CHECK(ejs_pull_dfs_EnumArray2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "info3")) {
				r->info3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info3);
				NDR_CHECK(ejs_pull_dfs_EnumArray3(ejs, v, "info3", r->info3));
			}
			break;
		case 4:
			if (ejs_pull_null(ejs, v, "info4")) {
				r->info4 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info4);
				NDR_CHECK(ejs_pull_dfs_EnumArray4(ejs, v, "info4", r->info4));
			}
			break;
		case 200:
			if (ejs_pull_null(ejs, v, "info200")) {
				r->info200 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info200);
				NDR_CHECK(ejs_pull_dfs_EnumArray200(ejs, v, "info200", r->info200));
			}
			break;
		case 300:
			if (ejs_pull_null(ejs, v, "info300")) {
				r->info300 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info300);
				NDR_CHECK(ejs_pull_dfs_EnumArray300(ejs, v, "info300", r->info300));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_dfs_EnumStruct(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_EnumStruct *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->level));
	ejs_set_switch(ejs, r->level);
	NDR_CHECK(ejs_push_dfs_EnumInfo(ejs, v, "e", &r->e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_EnumStruct(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_EnumStruct *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->level));
	ejs_set_switch(ejs, r->level);
	NDR_CHECK(ejs_pull_dfs_EnumInfo(ejs, v, "e", &r->e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dfs_UnknownStruct(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dfs_UnknownStruct *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	if (NULL == r->unknown2) {
		NDR_CHECK(ejs_push_null(ejs, v, "unknown2"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "unknown2", r->unknown2));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dfs_UnknownStruct(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dfs_UnknownStruct *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	if (ejs_pull_null(ejs, v, "unknown2")) {
		r->unknown2 = NULL;
	} else {
		EJS_ALLOC(ejs, r->unknown2);
		NDR_CHECK(ejs_pull_string(ejs, v, "unknown2", &r->unknown2));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_dfs_GetManagerVersion(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_GetManagerVersion *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_GetManagerVersion(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_GetManagerVersion *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.version) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_dfs_ManagerVersion(ejs, v, "version", r->out.version));
	}
	return NT_STATUS_OK;
}

static int ejs_dfs_GetManagerVersion(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_GETMANAGERVERSION, (ejs_pull_function_t)ejs_pull_dfs_GetManagerVersion, (ejs_push_function_t)ejs_push_dfs_GetManagerVersion);
}


static NTSTATUS ejs_pull_dfs_Add(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Add *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "path")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->in.path));
	}
	if (ejs_pull_null(ejs, v, "server")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->in.server));
	}
	if (ejs_pull_null(ejs, v, "share")) {
		r->in.share = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.share);
		NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->in.share));
	}
	if (ejs_pull_null(ejs, v, "comment")) {
		r->in.comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->in.comment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Add(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Add *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Add(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ADD, (ejs_pull_function_t)ejs_pull_dfs_Add, (ejs_push_function_t)ejs_push_dfs_Add);
}


static NTSTATUS ejs_pull_dfs_Remove(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Remove *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "dfs_entry_path")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.dfs_entry_path);
		NDR_CHECK(ejs_pull_string(ejs, v, "dfs_entry_path", &r->in.dfs_entry_path));
	}
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "sharename")) {
		r->in.sharename = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.sharename);
		NDR_CHECK(ejs_pull_string(ejs, v, "sharename", &r->in.sharename));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Remove(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Remove *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Remove(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_REMOVE, (ejs_pull_function_t)ejs_pull_dfs_Remove, (ejs_push_function_t)ejs_push_dfs_Remove);
}


static NTSTATUS ejs_pull_dfs_SetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_SetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfs_entry_path", &r->in.dfs_entry_path));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "sharename")) {
		r->in.sharename = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.sharename);
		NDR_CHECK(ejs_pull_string(ejs, v, "sharename", &r->in.sharename));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_dfs_Info(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_SetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_SetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_SetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_SETINFO, (ejs_pull_function_t)ejs_pull_dfs_SetInfo, (ejs_push_function_t)ejs_push_dfs_SetInfo);
}


static NTSTATUS ejs_pull_dfs_GetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_GetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfs_entry_path", &r->in.dfs_entry_path));
	if (ejs_pull_null(ejs, v, "servername")) {
		r->in.servername = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	if (ejs_pull_null(ejs, v, "sharename")) {
		r->in.sharename = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.sharename);
		NDR_CHECK(ejs_pull_string(ejs, v, "sharename", &r->in.sharename));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_GetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_GetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_dfs_Info(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_GetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_GETINFO, (ejs_pull_function_t)ejs_pull_dfs_GetInfo, (ejs_push_function_t)ejs_push_dfs_GetInfo);
}


static NTSTATUS ejs_pull_dfs_Enum(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Enum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bufsize", &r->in.bufsize));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		NDR_CHECK(ejs_pull_dfs_EnumStruct(ejs, v, "info", r->in.info));
	}
	if (ejs_pull_null(ejs, v, "total")) {
		r->in.total = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.total);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "total", r->in.total));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Enum(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Enum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_dfs_EnumStruct(ejs, v, "info", r->out.info));
	}
	if (NULL == r->out.total) {
		NDR_CHECK(ejs_push_null(ejs, v, "total"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "total", r->out.total));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Enum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ENUM, (ejs_pull_function_t)ejs_pull_dfs_Enum, (ejs_push_function_t)ejs_push_dfs_Enum);
}


static NTSTATUS ejs_pull_dfs_Rename(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Rename *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Rename(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Rename *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Rename(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_RENAME, (ejs_pull_function_t)ejs_pull_dfs_Rename, (ejs_push_function_t)ejs_push_dfs_Rename);
}


static NTSTATUS ejs_pull_dfs_Move(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Move *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Move(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Move *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Move(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_MOVE, (ejs_pull_function_t)ejs_pull_dfs_Move, (ejs_push_function_t)ejs_push_dfs_Move);
}


static NTSTATUS ejs_pull_dfs_ManagerGetConfigInfo(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_ManagerGetConfigInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_ManagerGetConfigInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_ManagerGetConfigInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_ManagerGetConfigInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_MANAGERGETCONFIGINFO, (ejs_pull_function_t)ejs_pull_dfs_ManagerGetConfigInfo, (ejs_push_function_t)ejs_push_dfs_ManagerGetConfigInfo);
}


static NTSTATUS ejs_pull_dfs_ManagerSendSiteInfo(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_ManagerSendSiteInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_ManagerSendSiteInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_ManagerSendSiteInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_ManagerSendSiteInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_MANAGERSENDSITEINFO, (ejs_pull_function_t)ejs_pull_dfs_ManagerSendSiteInfo, (ejs_push_function_t)ejs_push_dfs_ManagerSendSiteInfo);
}


static NTSTATUS ejs_pull_dfs_AddFtRoot(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_AddFtRoot *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "dns_servername", &r->in.dns_servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfsname", &r->in.dfsname));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->in.comment));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfs_config_dn", &r->in.dfs_config_dn));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	if (ejs_pull_null(ejs, v, "unknown2")) {
		r->in.unknown2 = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.unknown2);
		if (ejs_pull_null(ejs, v, "unknown2")) {
			*r->in.unknown2 = NULL;
		} else {
			EJS_ALLOC(ejs, *r->in.unknown2);
			NDR_CHECK(ejs_pull_dfs_UnknownStruct(ejs, v, "unknown2", *r->in.unknown2));
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_AddFtRoot(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_AddFtRoot *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.unknown2) {
		NDR_CHECK(ejs_push_null(ejs, v, "unknown2"));
	} else {
		if (NULL == *r->out.unknown2) {
			NDR_CHECK(ejs_push_null(ejs, v, "unknown2"));
		} else {
			NDR_CHECK(ejs_push_dfs_UnknownStruct(ejs, v, "unknown2", *r->out.unknown2));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_AddFtRoot(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ADDFTROOT, (ejs_pull_function_t)ejs_pull_dfs_AddFtRoot, (ejs_push_function_t)ejs_push_dfs_AddFtRoot);
}


static NTSTATUS ejs_pull_dfs_RemoveFtRoot(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_RemoveFtRoot *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "dns_servername", &r->in.dns_servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfsname", &r->in.dfsname));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	if (ejs_pull_null(ejs, v, "unknown")) {
		r->in.unknown = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.unknown);
		if (ejs_pull_null(ejs, v, "unknown")) {
			*r->in.unknown = NULL;
		} else {
			EJS_ALLOC(ejs, *r->in.unknown);
			NDR_CHECK(ejs_pull_dfs_UnknownStruct(ejs, v, "unknown", *r->in.unknown));
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_RemoveFtRoot(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_RemoveFtRoot *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.unknown) {
		NDR_CHECK(ejs_push_null(ejs, v, "unknown"));
	} else {
		if (NULL == *r->out.unknown) {
			NDR_CHECK(ejs_push_null(ejs, v, "unknown"));
		} else {
			NDR_CHECK(ejs_push_dfs_UnknownStruct(ejs, v, "unknown", *r->out.unknown));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_RemoveFtRoot(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_REMOVEFTROOT, (ejs_pull_function_t)ejs_pull_dfs_RemoveFtRoot, (ejs_push_function_t)ejs_push_dfs_RemoveFtRoot);
}


static NTSTATUS ejs_pull_dfs_AddStdRoot(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_AddStdRoot *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->in.comment));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_AddStdRoot(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_AddStdRoot *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_AddStdRoot(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ADDSTDROOT, (ejs_pull_function_t)ejs_pull_dfs_AddStdRoot, (ejs_push_function_t)ejs_push_dfs_AddStdRoot);
}


static NTSTATUS ejs_pull_dfs_RemoveStdRoot(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_RemoveStdRoot *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_RemoveStdRoot(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_RemoveStdRoot *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_RemoveStdRoot(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_REMOVESTDROOT, (ejs_pull_function_t)ejs_pull_dfs_RemoveStdRoot, (ejs_push_function_t)ejs_push_dfs_RemoveStdRoot);
}


static NTSTATUS ejs_pull_dfs_ManagerInitialize(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_ManagerInitialize *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "servername")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.servername);
		NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_ManagerInitialize(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_ManagerInitialize *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_ManagerInitialize(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_MANAGERINITIALIZE, (ejs_pull_function_t)ejs_pull_dfs_ManagerInitialize, (ejs_push_function_t)ejs_push_dfs_ManagerInitialize);
}


static NTSTATUS ejs_pull_dfs_AddStdRootForced(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_AddStdRootForced *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->in.comment));
	NDR_CHECK(ejs_pull_string(ejs, v, "store", &r->in.store));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_AddStdRootForced(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_AddStdRootForced *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_AddStdRootForced(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ADDSTDROOTFORCED, (ejs_pull_function_t)ejs_pull_dfs_AddStdRootForced, (ejs_push_function_t)ejs_push_dfs_AddStdRootForced);
}


static NTSTATUS ejs_pull_dfs_GetDcAddress(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_GetDcAddress *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_GetDcAddress(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_GetDcAddress *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_GetDcAddress(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_GETDCADDRESS, (ejs_pull_function_t)ejs_pull_dfs_GetDcAddress, (ejs_push_function_t)ejs_push_dfs_GetDcAddress);
}


static NTSTATUS ejs_pull_dfs_SetDcAddress(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_SetDcAddress *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_SetDcAddress(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_SetDcAddress *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_SetDcAddress(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_SETDCADDRESS, (ejs_pull_function_t)ejs_pull_dfs_SetDcAddress, (ejs_push_function_t)ejs_push_dfs_SetDcAddress);
}


static NTSTATUS ejs_pull_dfs_FlushFtTable(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_FlushFtTable *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_string(ejs, v, "rootshare", &r->in.rootshare));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_FlushFtTable(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_FlushFtTable *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_FlushFtTable(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_FLUSHFTTABLE, (ejs_pull_function_t)ejs_pull_dfs_FlushFtTable, (ejs_push_function_t)ejs_push_dfs_FlushFtTable);
}


static NTSTATUS ejs_pull_dfs_Add2(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Add2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Add2(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Add2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Add2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ADD2, (ejs_pull_function_t)ejs_pull_dfs_Add2, (ejs_push_function_t)ejs_push_dfs_Add2);
}


static NTSTATUS ejs_pull_dfs_Remove2(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_Remove2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_Remove2(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_Remove2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_Remove2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_REMOVE2, (ejs_pull_function_t)ejs_pull_dfs_Remove2, (ejs_push_function_t)ejs_push_dfs_Remove2);
}


static NTSTATUS ejs_pull_dfs_EnumEx(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_EnumEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "dfs_name", &r->in.dfs_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bufsize", &r->in.bufsize));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		NDR_CHECK(ejs_pull_dfs_EnumStruct(ejs, v, "info", r->in.info));
	}
	if (ejs_pull_null(ejs, v, "total")) {
		r->in.total = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.total);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "total", r->in.total));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_EnumEx(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_EnumEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_dfs_EnumStruct(ejs, v, "info", r->out.info));
	}
	if (NULL == r->out.total) {
		NDR_CHECK(ejs_push_null(ejs, v, "total"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "total", r->out.total));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_EnumEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_ENUMEX, (ejs_pull_function_t)ejs_pull_dfs_EnumEx, (ejs_push_function_t)ejs_push_dfs_EnumEx);
}


static NTSTATUS ejs_pull_dfs_SetInfo2(struct ejs_rpc *ejs, struct MprVar *v, struct dfs_SetInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dfs_SetInfo2(struct ejs_rpc *ejs, struct MprVar *v, const struct dfs_SetInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dfs_SetInfo2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netdfs, DCERPC_DFS_SETINFO2, (ejs_pull_function_t)ejs_pull_dfs_SetInfo2, (ejs_push_function_t)ejs_push_dfs_SetInfo2);
}

static int ejs_netdfs_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "netdfs", argc, argv);
	mprSetCFunction(obj, "dfs_GetManagerVersion", ejs_dfs_GetManagerVersion);
	mprSetCFunction(obj, "dfs_Add", ejs_dfs_Add);
	mprSetCFunction(obj, "dfs_Remove", ejs_dfs_Remove);
	mprSetCFunction(obj, "dfs_SetInfo", ejs_dfs_SetInfo);
	mprSetCFunction(obj, "dfs_GetInfo", ejs_dfs_GetInfo);
	mprSetCFunction(obj, "dfs_Enum", ejs_dfs_Enum);
	mprSetCFunction(obj, "dfs_Rename", ejs_dfs_Rename);
	mprSetCFunction(obj, "dfs_Move", ejs_dfs_Move);
	mprSetCFunction(obj, "dfs_ManagerGetConfigInfo", ejs_dfs_ManagerGetConfigInfo);
	mprSetCFunction(obj, "dfs_ManagerSendSiteInfo", ejs_dfs_ManagerSendSiteInfo);
	mprSetCFunction(obj, "dfs_AddFtRoot", ejs_dfs_AddFtRoot);
	mprSetCFunction(obj, "dfs_RemoveFtRoot", ejs_dfs_RemoveFtRoot);
	mprSetCFunction(obj, "dfs_AddStdRoot", ejs_dfs_AddStdRoot);
	mprSetCFunction(obj, "dfs_RemoveStdRoot", ejs_dfs_RemoveStdRoot);
	mprSetCFunction(obj, "dfs_ManagerInitialize", ejs_dfs_ManagerInitialize);
	mprSetCFunction(obj, "dfs_AddStdRootForced", ejs_dfs_AddStdRootForced);
	mprSetCFunction(obj, "dfs_GetDcAddress", ejs_dfs_GetDcAddress);
	mprSetCFunction(obj, "dfs_SetDcAddress", ejs_dfs_SetDcAddress);
	mprSetCFunction(obj, "dfs_FlushFtTable", ejs_dfs_FlushFtTable);
	mprSetCFunction(obj, "dfs_Add2", ejs_dfs_Add2);
	mprSetCFunction(obj, "dfs_Remove2", ejs_dfs_Remove2);
	mprSetCFunction(obj, "dfs_EnumEx", ejs_dfs_EnumEx);
	mprSetCFunction(obj, "dfs_SetInfo2", ejs_dfs_SetInfo2);
	mprSetVar(obj, "DFS_VOLUME_STATE_STANDALONE", mprCreateNumberVar(( DFS_VOLUME_FLAVOR_STANDALONE )));
	mprSetVar(obj, "DFS_MANAGER_VERSION_W2K3", mprCreateNumberVar(4));
	mprSetVar(obj, "DFS_PROPERTY_FLAG_ROOT_SCALABILITY", mprCreateNumberVar(( 0x02 )));
	mprSetVar(obj, "DFS_PROPERTY_FLAG_SITE_COSTING", mprCreateNumberVar(( 0x04 )));
	mprSetVar(obj, "DFS_VOLUME_FLAVOR_AD_BLOB", mprCreateNumberVar(0x200));
	mprSetVar(obj, "DFS_STORAGE_STATE_OFFLINE", mprCreateNumberVar(( 1 )));
	mprSetVar(obj, "DFS_VOLUME_STATE_OK", mprCreateNumberVar(( 0x1 )));
	mprSetVar(obj, "DFS_STORAGE_STATE_ACTIVE", mprCreateNumberVar(( 4 )));
	mprSetVar(obj, "DFS_SITE_COST_LOW_PRIORITY_CLASS", mprCreateNumberVar(3));
	mprSetVar(obj, "DFS_INVALID_PRIORITY_CLASS", mprCreateNumberVar(-1));
	mprSetVar(obj, "DFS_VOLUME_STATE_ONLINE", mprCreateNumberVar(( 0x8 )));
	mprSetVar(obj, "DFS_MANAGER_VERSION_W2K", mprCreateNumberVar(2));
	mprSetVar(obj, "DFS_GLOBAL_HIGH_PRIORITY_CLASS", mprCreateNumberVar(1));
	mprSetVar(obj, "DFS_VOLUME_STATE_INCONSISTENT", mprCreateNumberVar(( 0x2 )));
	mprSetVar(obj, "DFS_PROPERTY_FLAG_INSITE_REFERRALS", mprCreateNumberVar(( 0x01 )));
	mprSetVar(obj, "DFS_SITE_COST_NORMAL_PRIORITY_CLASS", mprCreateNumberVar(0));
	mprSetVar(obj, "DFS_VOLUME_STATE_OFFLINE", mprCreateNumberVar(( 0x4 )));
	mprSetVar(obj, "DFS_VOLUME_FLAVOR_STANDALONE", mprCreateNumberVar(0x100));
	mprSetVar(obj, "DFS_PROPERTY_FLAG_CLUSTER_ENABLED", mprCreateNumberVar(( 0x10 )));
	mprSetVar(obj, "DFS_MANAGER_VERSION_NT4", mprCreateNumberVar(1));
	mprSetVar(obj, "DFS_VOLUME_STATE_AD_BLOB", mprCreateNumberVar(( DFS_VOLUME_FLAVOR_AD_BLOB )));
	mprSetVar(obj, "DFS_STORAGE_STATES", mprCreateNumberVar(0xf));
	mprSetVar(obj, "DFS_PROPERTY_FLAG_TARGET_FAILBACK", mprCreateNumberVar(( 0x08 )));
	mprSetVar(obj, "DFS_GLOBAL_LOW_PRIORITY_CLASS", mprCreateNumberVar(4));
	mprSetVar(obj, "DFS_STORAGE_STATE_ONLINE", mprCreateNumberVar(( 2 )));
	mprSetVar(obj, "DFS_SITE_COST_HIGH_PRIORITY_CLASS", mprCreateNumberVar(2));
	return ejs_rpc_init(obj, "netdfs");
}

NTSTATUS ejs_init_netdfs(void)
{
	ejsDefineCFunction(-1, "netdfs_init", ejs_netdfs_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
