
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_drsblobs.h"
#include "librpc/gen_ndr/ndr_drsblobs_ejs.h"


static NTSTATUS ejs_push_replPropertyMetaData1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replPropertyMetaData1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "orginating_time", &r->orginating_time));
	NDR_CHECK(ejs_push_GUID(ejs, v, "orginating_invocation_id", &r->orginating_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "orginating_usn", &r->orginating_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "local_usn", &r->local_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_replPropertyMetaData1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replPropertyMetaData1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_NTTIME_1sec(ejs, v, "orginating_time", &r->orginating_time));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "orginating_invocation_id", &r->orginating_invocation_id));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "orginating_usn", &r->orginating_usn));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "local_usn", &r->local_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_replPropertyMetaDataCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replPropertyMetaDataCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_replPropertyMetaData1(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_replPropertyMetaDataCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replPropertyMetaDataCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->array, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_pull_replPropertyMetaData1(ejs, v, id, &r->array[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_replPropertyMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union replPropertyMetaDataCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_replPropertyMetaDataCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_replPropertyMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union replPropertyMetaDataCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_replPropertyMetaDataCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_replPropertyMetaDataBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replPropertyMetaDataBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_replPropertyMetaDataCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_replPropertyMetaDataBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replPropertyMetaDataBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_replPropertyMetaDataCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_replUpToDateVectorCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replUpToDateVectorCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor(ejs, v, id, &r->cursors[i]));
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_replUpToDateVectorCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replUpToDateVectorCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->cursors, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursor(ejs, v, id, &r->cursors[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_replUpToDateVectorCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replUpToDateVectorCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor2(ejs, v, id, &r->cursors[i]));
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_replUpToDateVectorCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replUpToDateVectorCtr2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->cursors, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursor2(ejs, v, id, &r->cursors[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_replUpToDateVectorCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union replUpToDateVectorCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_replUpToDateVectorCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		case 2:
			NDR_CHECK(ejs_push_replUpToDateVectorCtr2(ejs, v, "ctr2", &r->ctr2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_replUpToDateVectorCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union replUpToDateVectorCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_replUpToDateVectorCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_replUpToDateVectorCtr2(ejs, v, "ctr2", &r->ctr2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_replUpToDateVectorBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct replUpToDateVectorBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_replUpToDateVectorCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_replUpToDateVectorBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct replUpToDateVectorBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_replUpToDateVectorCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_repsFromTo1OtherInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct repsFromTo1OtherInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "dns_name", r->dns_name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_repsFromTo1OtherInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct repsFromTo1OtherInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "dns_name", &r->dns_name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_repsFromTo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct repsFromTo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "blobsize", &r->blobsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "consecutive_sync_failures", &r->consecutive_sync_failures));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "last_success", &r->last_success));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "last_attempt", &r->last_attempt));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result_last_attempt", &r->result_last_attempt));
	if (NULL == r->other_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "other_info"));
	} else {
		NDR_CHECK(ejs_push_repsFromTo1OtherInfo(ejs, v, "other_info", r->other_info));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "other_info_length", &r->other_info_length));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaNeighbourFlags(ejs, v, "replica_flags", &r->replica_flags));
	ejs_push_array_uint8(ejs, v, "schedule", r->schedule, 84);
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_obj_guid", &r->source_dsa_obj_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_push_GUID(ejs, v, "transport_guid", &r->transport_guid));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_repsFromTo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct repsFromTo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "consecutive_sync_failures", &r->consecutive_sync_failures));
	NDR_CHECK(ejs_pull_NTTIME_1sec(ejs, v, "last_success", &r->last_success));
	NDR_CHECK(ejs_pull_NTTIME_1sec(ejs, v, "last_attempt", &r->last_attempt));
	NDR_CHECK(ejs_pull_WERROR(ejs, v, "result_last_attempt", &r->result_last_attempt));
	if (ejs_pull_null(ejs, v, "other_info")) {
		r->other_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->other_info);
		NDR_CHECK(ejs_pull_repsFromTo1OtherInfo(ejs, v, "other_info", r->other_info));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaNeighbourFlags(ejs, v, "replica_flags", &r->replica_flags));
	ejs_pull_array_uint8(ejs, v, "schedule", r->schedule, 84);
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_obj_guid", &r->source_dsa_obj_guid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "transport_guid", &r->transport_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_repsFromTo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union repsFromTo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_repsFromTo1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_repsFromTo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union repsFromTo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_repsFromTo1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_repsFromToBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct repsFromToBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_repsFromTo(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_repsFromToBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct repsFromToBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_repsFromTo(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_partialAttributeSetCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct partialAttributeSetCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsAttributeId(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_partialAttributeSetCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct partialAttributeSetCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->array, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_pull_drsuapi_DsAttributeId(ejs, v, id, &r->array[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_partialAttributeSetCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union partialAttributeSetCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_partialAttributeSetCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_partialAttributeSetCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union partialAttributeSetCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_partialAttributeSetCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_partialAttributeSetBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct partialAttributeSetBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_partialAttributeSetCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_partialAttributeSetBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct partialAttributeSetBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_partialAttributeSetCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_prefixMapVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum prefixMapVersion *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_prefixMapVersion(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum prefixMapVersion *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_prefixMapCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union prefixMapCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case PREFIX_MAP_VERSION_DSDB:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "dsdb", &r->dsdb));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_prefixMapCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union prefixMapCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case PREFIX_MAP_VERSION_DSDB:
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "dsdb", &r->dsdb));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_prefixMapBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct prefixMapBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_prefixMapVersion(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_push_prefixMapCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_prefixMapBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct prefixMapBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_prefixMapVersion(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	ejs_set_switch(ejs, r->version);
	NDR_CHECK(ejs_pull_prefixMapCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_ldapControlDirSyncExtra(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union ldapControlDirSyncExtra *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			break;
		default:
			NDR_CHECK(ejs_push_replUpToDateVectorBlob(ejs, v, "uptodateness_vector", &r->uptodateness_vector));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_ldapControlDirSyncExtra(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union ldapControlDirSyncExtra *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			break;
		default:
			NDR_CHECK(ejs_pull_replUpToDateVectorBlob(ejs, v, "uptodateness_vector", &r->uptodateness_vector));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_ldapControlDirSyncBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ldapControlDirSyncBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u3", &r->u3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "extra_length", &r->extra_length));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid1", &r->guid1));
	ejs_set_switch(ejs, r->extra_length);
	NDR_CHECK(ejs_push_ldapControlDirSyncExtra(ejs, v, "extra", &r->extra));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_ldapControlDirSyncBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ldapControlDirSyncBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u3", &r->u3));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid1", &r->guid1));
	ejs_set_switch(ejs, r->extra_length);
	NDR_CHECK(ejs_pull_ldapControlDirSyncExtra(ejs, v, "extra", &r->extra));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_ldapControlDirSyncCookie(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ldapControlDirSyncCookie *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "msds", r->msds));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ldapControlDirSyncCookie(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ldapControlDirSyncCookie *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "msds", &r->msds));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_DsCompressedChunk(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct DsCompressedChunk *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "marker", &r->marker));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_DsCompressedChunk(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct DsCompressedChunk *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "marker", &r->marker));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_DsCompressedBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct DsCompressedBlob *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	{
		uint32_t i;
		for (i=0;i<5;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "chunks", i);
			NDR_CHECK(ejs_push_DsCompressedChunk(ejs, v, id, &r->chunks[i]));
		}
		ejs_push_uint32(ejs, v, "chunks" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_DsCompressedBlob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct DsCompressedBlob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	{
		uint32_t i;
		for (i=0;i<5;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "chunks", i);
			NDR_CHECK(ejs_pull_DsCompressedChunk(ejs, v, id, &r->chunks[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "chunks" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_decode_replPropertyMetaData(struct ejs_rpc *ejs, struct MprVar *v, struct decode_replPropertyMetaData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_replPropertyMetaDataBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_replPropertyMetaData(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_replPropertyMetaData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_replPropertyMetaData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_REPLPROPERTYMETADATA, (ejs_pull_function_t)ejs_pull_decode_replPropertyMetaData, (ejs_push_function_t)ejs_push_decode_replPropertyMetaData);
}


static NTSTATUS ejs_pull_decode_replUpToDateVector(struct ejs_rpc *ejs, struct MprVar *v, struct decode_replUpToDateVector *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_replUpToDateVectorBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_replUpToDateVector(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_replUpToDateVector *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_replUpToDateVector(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_REPLUPTODATEVECTOR, (ejs_pull_function_t)ejs_pull_decode_replUpToDateVector, (ejs_push_function_t)ejs_push_decode_replUpToDateVector);
}


static NTSTATUS ejs_pull_decode_repsFromTo(struct ejs_rpc *ejs, struct MprVar *v, struct decode_repsFromTo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_repsFromToBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_repsFromTo(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_repsFromTo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_repsFromTo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_REPSFROMTO, (ejs_pull_function_t)ejs_pull_decode_repsFromTo, (ejs_push_function_t)ejs_push_decode_repsFromTo);
}


static NTSTATUS ejs_pull_decode_partialAttributeSet(struct ejs_rpc *ejs, struct MprVar *v, struct decode_partialAttributeSet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_partialAttributeSetBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_partialAttributeSet(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_partialAttributeSet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_partialAttributeSet(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_PARTIALATTRIBUTESET, (ejs_pull_function_t)ejs_pull_decode_partialAttributeSet, (ejs_push_function_t)ejs_push_decode_partialAttributeSet);
}


static NTSTATUS ejs_pull_decode_prefixMap(struct ejs_rpc *ejs, struct MprVar *v, struct decode_prefixMap *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_prefixMapBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_prefixMap(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_prefixMap *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_prefixMap(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_PREFIXMAP, (ejs_pull_function_t)ejs_pull_decode_prefixMap, (ejs_push_function_t)ejs_push_decode_prefixMap);
}


static NTSTATUS ejs_pull_decode_ldapControlDirSync(struct ejs_rpc *ejs, struct MprVar *v, struct decode_ldapControlDirSync *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ldapControlDirSyncCookie(ejs, v, "cookie", &r->in.cookie));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_ldapControlDirSync(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_ldapControlDirSync *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_ldapControlDirSync(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_LDAPCONTROLDIRSYNC, (ejs_pull_function_t)ejs_pull_decode_ldapControlDirSync, (ejs_push_function_t)ejs_push_decode_ldapControlDirSync);
}


static NTSTATUS ejs_pull_decode_DsCompressed(struct ejs_rpc *ejs, struct MprVar *v, struct decode_DsCompressed *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_DsCompressedBlob(ejs, v, "blob", &r->in.blob));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_DsCompressed(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_DsCompressed *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_DsCompressed(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsblobs, DCERPC_DECODE_DSCOMPRESSED, (ejs_pull_function_t)ejs_pull_decode_DsCompressed, (ejs_push_function_t)ejs_push_decode_DsCompressed);
}

static int ejs_drsblobs_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "drsblobs", argc, argv);
	mprSetCFunction(obj, "decode_replPropertyMetaData", ejs_decode_replPropertyMetaData);
	mprSetCFunction(obj, "decode_replUpToDateVector", ejs_decode_replUpToDateVector);
	mprSetCFunction(obj, "decode_repsFromTo", ejs_decode_repsFromTo);
	mprSetCFunction(obj, "decode_partialAttributeSet", ejs_decode_partialAttributeSet);
	mprSetCFunction(obj, "decode_prefixMap", ejs_decode_prefixMap);
	mprSetCFunction(obj, "decode_ldapControlDirSync", ejs_decode_ldapControlDirSync);
	mprSetCFunction(obj, "decode_DsCompressed", ejs_decode_DsCompressed);
	mprSetVar(obj, "PREFIX_MAP_VERSION_DSDB", mprCreateNumberVar(0x44544442));
	return ejs_rpc_init(obj, "drsblobs");
}

NTSTATUS ejs_init_drsblobs(void)
{
	ejsDefineCFunction(-1, "drsblobs_init", ejs_drsblobs_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
