
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_drsuapi.h"
#include "librpc/gen_ndr/ndr_drsuapi_ejs.h"


static NTSTATUS ejs_push_drsuapi_DsBindInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsBindInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 24:
			return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
			break;
		case 28:
			return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
			break;
		default:
			return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsBindInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsBindInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 24:
			return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
			break;
		case 28:
			return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
			break;
		default:
			return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsBindInfoCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsBindInfoCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "length", &r->length));
	ejs_set_switch(ejs, r->length);
	NDR_CHECK(ejs_push_drsuapi_DsBindInfo(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsBindInfoCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsBindInfoCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	ejs_set_switch(ejs, r->length);
	NDR_CHECK(ejs_pull_drsuapi_DsBindInfo(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObjectIdentifier(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_sid", &r->__ndr_size_sid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_push_string(ejs, v, "dn", r->dn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObjectIdentifier(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObjectIdentifier *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_pull_string(ejs, v, "dn", &r->dn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaSyncOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaSyncOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_drsuapi_DsReplicaSyncRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaSyncRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		r->naming_context = NULL;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid1", &r->guid1));
	if (ejs_pull_null(ejs, v, "string1")) {
		r->string1 = NULL;
	} else {
		EJS_ALLOC(ejs, r->string1);
		NDR_CHECK(ejs_pull_string(ejs, v, "string1", &r->string1));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaSyncOptions(ejs, v, "options", &r->options));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaSyncRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsReplicaSyncRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaSyncRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaHighWaterMark(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "tmp_highest_usn", &r->tmp_highest_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "reserved_usn", &r->reserved_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "highest_usn", &r->highest_usn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaHighWaterMark(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaHighWaterMark *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "tmp_highest_usn", &r->tmp_highest_usn));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "reserved_usn", &r->reserved_usn));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "highest_usn", &r->highest_usn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaCursor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "highest_usn", &r->highest_usn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaCursor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaCursor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "highest_usn", &r->highest_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursorCtrEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursorCtrEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u3", &r->u3));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor(ejs, v, id, &r->cursors[i]));
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaCursorCtrEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaCursorCtrEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u3", &r->u3));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->cursors, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursor(ejs, v, id, &r->cursors[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaNeighbourFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaNeighbourFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_drsuapi_DsGetNCChangesRequest5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetNCChangesRequest5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "destination_dsa_guid", &r->destination_dsa_guid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	if (ejs_pull_null(ejs, v, "uptodateness_vector")) {
		r->uptodateness_vector = NULL;
	} else {
		EJS_ALLOC(ejs, r->uptodateness_vector);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursorCtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaNeighbourFlags(ejs, v, "replica_flags", &r->replica_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_object_count", &r->max_object_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_ndr_size", &r->max_ndr_size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "h1", &r->h1));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaOID(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaOID *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	if (NULL == r->oid) {
		NDR_CHECK(ejs_push_null(ejs, v, "oid"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "oid", r->oid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaOID(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaOID *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "oid")) {
		r->oid = NULL;
	} else {
		EJS_ALLOC(ejs, r->oid);
		NDR_CHECK(ejs_pull_string(ejs, v, "oid", &r->oid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaOIDMapping(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaOIDMapping *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "id_prefix", &r->id_prefix));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaOID(ejs, v, "oid", &r->oid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaOIDMapping(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaOIDMapping *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "id_prefix", &r->id_prefix));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaOID(ejs, v, "oid", &r->oid));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaOIDMapping_Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_mappings", &r->num_mappings));
	if (NULL == r->mappings) {
		NDR_CHECK(ejs_push_null(ejs, v, "mappings"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_mappings;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "mappings", i);
				NDR_CHECK(ejs_push_drsuapi_DsReplicaOIDMapping(ejs, v, id, &r->mappings[i]));
			}
			ejs_push_uint32(ejs, v, "mappings" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaOIDMapping_Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_mappings", &r->num_mappings));
	if (ejs_pull_null(ejs, v, "mappings")) {
		r->mappings = NULL;
	} else {
		EJS_ALLOC(ejs, r->mappings);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->mappings, r->num_mappings);
			for (i=0;i<r->num_mappings;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "mappings", i);
				NDR_CHECK(ejs_pull_drsuapi_DsReplicaOIDMapping(ejs, v, id, &r->mappings[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "mappings" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsAttributeId(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum drsuapi_DsAttributeId *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsAttributeId(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsAttributeId *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetNCChangesRequest8(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetNCChangesRequest8 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "destination_dsa_guid", &r->destination_dsa_guid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "highwatermark", &r->highwatermark));
	if (ejs_pull_null(ejs, v, "uptodateness_vector")) {
		r->uptodateness_vector = NULL;
	} else {
		EJS_ALLOC(ejs, r->uptodateness_vector);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursorCtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaNeighbourFlags(ejs, v, "replica_flags", &r->replica_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_object_count", &r->max_object_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_ndr_size", &r->max_ndr_size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "h1", &r->h1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unique_ptr1", &r->unique_ptr1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unique_ptr2", &r->unique_ptr2));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "mapping_ctr", &r->mapping_ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetNCChangesRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsGetNCChangesRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 5:
			NDR_CHECK(ejs_pull_drsuapi_DsGetNCChangesRequest5(ejs, v, "req5", &r->req5));
			break;
		case 8:
			NDR_CHECK(ejs_pull_drsuapi_DsGetNCChangesRequest8(ejs, v, "req8", &r->req8));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaCursor2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "highest_usn", &r->highest_usn));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_sync_success", &r->last_sync_success));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaCursor2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaCursor2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "highest_usn", &r->highest_usn));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_sync_success", &r->last_sync_success));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursor2CtrEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u3", &r->u3));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor2(ejs, v, id, &r->cursors[i]));
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaCursor2CtrEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "u3", &r->u3));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->cursors, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "cursors", i);
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursor2(ejs, v, id, &r->cursors[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "cursors" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAttributeValue(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAttributeValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	if (NULL == r->blob) {
		NDR_CHECK(ejs_push_null(ejs, v, "blob"));
	} else {
		NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "blob", r->blob));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsAttributeValue(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsAttributeValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "blob")) {
		r->blob = NULL;
	} else {
		EJS_ALLOC(ejs, r->blob);
		NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "blob", r->blob));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAttributeValueCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAttributeValueCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_values", &r->num_values));
	if (NULL == r->values) {
		NDR_CHECK(ejs_push_null(ejs, v, "values"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_values;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "values", i);
				NDR_CHECK(ejs_push_drsuapi_DsAttributeValue(ejs, v, id, &r->values[i]));
			}
			ejs_push_uint32(ejs, v, "values" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsAttributeValueCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsAttributeValueCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_values", &r->num_values));
	if (ejs_pull_null(ejs, v, "values")) {
		r->values = NULL;
	} else {
		EJS_ALLOC(ejs, r->values);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->values, r->num_values);
			for (i=0;i<r->num_values;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "values", i);
				NDR_CHECK(ejs_pull_drsuapi_DsAttributeValue(ejs, v, id, &r->values[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "values" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObjectIdentifier3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_sid", &r->__ndr_size_sid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_push_string(ejs, v, "dn", r->dn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObjectIdentifier3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_pull_string(ejs, v, "dn", &r->dn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObjectIdentifier3Binary(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_sid", &r->__ndr_size_sid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_push_string(ejs, v, "dn", r->dn));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_binary", &r->__ndr_size_binary));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "binary", &r->binary));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObjectIdentifier3Binary(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_pull_dom_sid28(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_pull_string(ejs, v, "dn", &r->dn));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "binary", &r->binary));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttribute *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_push_drsuapi_DsAttributeValueCtr(ejs, v, "value_ctr", &r->value_ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaAttribute *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_pull_drsuapi_DsAttributeValueCtr(ejs, v, "value_ctr", &r->value_ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaAttributeCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttributeCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_attributes", &r->num_attributes));
	if (NULL == r->attributes) {
		NDR_CHECK(ejs_push_null(ejs, v, "attributes"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_attributes;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "attributes", i);
				NDR_CHECK(ejs_push_drsuapi_DsReplicaAttribute(ejs, v, id, &r->attributes[i]));
			}
			ejs_push_uint32(ejs, v, "attributes" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaAttributeCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaAttributeCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_attributes", &r->num_attributes));
	if (ejs_pull_null(ejs, v, "attributes")) {
		r->attributes = NULL;
	} else {
		EJS_ALLOC(ejs, r->attributes);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->attributes, r->num_attributes);
			for (i=0;i<r->num_attributes;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "attributes", i);
				NDR_CHECK(ejs_pull_drsuapi_DsReplicaAttribute(ejs, v, id, &r->attributes[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "attributes" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObject(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->identifier) {
		NDR_CHECK(ejs_push_null(ejs, v, "identifier"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "identifier", r->identifier));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaAttributeCtr(ejs, v, "attribute_ctr", &r->attribute_ctr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObject(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "identifier")) {
		r->identifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->identifier);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "identifier", r->identifier));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaAttributeCtr(ejs, v, "attribute_ctr", &r->attribute_ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaMetaData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaMetaData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "orginating_time", &r->orginating_time));
	NDR_CHECK(ejs_push_GUID(ejs, v, "orginating_invocation_id", &r->orginating_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "orginating_usn", &r->orginating_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaMetaData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaMetaData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_NTTIME_1sec(ejs, v, "orginating_time", &r->orginating_time));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "orginating_invocation_id", &r->orginating_invocation_id));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "orginating_usn", &r->orginating_usn));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "meta_data", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaMetaData(ejs, v, id, &r->meta_data[i]));
		}
		ejs_push_uint32(ejs, v, "meta_data" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaMetaDataCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->meta_data, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "meta_data", i);
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaMetaData(ejs, v, id, &r->meta_data[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "meta_data" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObjectListItemEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectListItemEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->next_object) {
		NDR_CHECK(ejs_push_null(ejs, v, "next_object"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectListItemEx(ejs, v, "next_object", r->next_object));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaObject(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	if (NULL == r->parent_object_guid) {
		NDR_CHECK(ejs_push_null(ejs, v, "parent_object_guid"));
	} else {
		NDR_CHECK(ejs_push_GUID(ejs, v, "parent_object_guid", r->parent_object_guid));
	}
	if (NULL == r->meta_data_ctr) {
		NDR_CHECK(ejs_push_null(ejs, v, "meta_data_ctr"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaMetaDataCtr(ejs, v, "meta_data_ctr", r->meta_data_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObjectListItemEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObjectListItemEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "next_object")) {
		r->next_object = NULL;
	} else {
		EJS_ALLOC(ejs, r->next_object);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectListItemEx(ejs, v, "next_object", r->next_object));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaObject(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	if (ejs_pull_null(ejs, v, "parent_object_guid")) {
		r->parent_object_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->parent_object_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "parent_object_guid", r->parent_object_guid));
	}
	if (ejs_pull_null(ejs, v, "meta_data_ctr")) {
		r->meta_data_ctr = NULL;
	} else {
		EJS_ALLOC(ejs, r->meta_data_ctr);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaMetaDataCtr(ejs, v, "meta_data_ctr", r->meta_data_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsGetNCChangesCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_guid", &r->source_dsa_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (NULL == r->naming_context) {
		NDR_CHECK(ejs_push_null(ejs, v, "naming_context"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "old_highwatermark", &r->old_highwatermark));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "new_highwatermark", &r->new_highwatermark));
	if (NULL == r->uptodateness_vector) {
		NDR_CHECK(ejs_push_null(ejs, v, "uptodateness_vector"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaCursorCtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "mapping_ctr", &r->mapping_ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_object_count", &r->total_object_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "object_count", &r->object_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	if (NULL == r->first_object) {
		NDR_CHECK(ejs_push_null(ejs, v, "first_object"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectListItemEx(ejs, v, "first_object", r->first_object));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsGetNCChangesCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetNCChangesCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_guid", &r->source_dsa_guid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		r->naming_context = NULL;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "old_highwatermark", &r->old_highwatermark));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "new_highwatermark", &r->new_highwatermark));
	if (ejs_pull_null(ejs, v, "uptodateness_vector")) {
		r->uptodateness_vector = NULL;
	} else {
		EJS_ALLOC(ejs, r->uptodateness_vector);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursorCtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "mapping_ctr", &r->mapping_ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_object_count", &r->total_object_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "object_count", &r->object_count));
	if (ejs_pull_null(ejs, v, "first_object")) {
		r->first_object = NULL;
	} else {
		EJS_ALLOC(ejs, r->first_object);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectListItemEx(ejs, v, "first_object", r->first_object));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsLinkedAttributeFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsLinkedAttributeFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaLinkedAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->identifier) {
		NDR_CHECK(ejs_push_null(ejs, v, "identifier"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "identifier", r->identifier));
	}
	NDR_CHECK(ejs_push_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_push_drsuapi_DsAttributeValue(ejs, v, "value", &r->value));
	NDR_CHECK(ejs_push_drsuapi_DsLinkedAttributeFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "orginating_add_time", &r->orginating_add_time));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaMetaData(ejs, v, "meta_data", &r->meta_data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaLinkedAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaLinkedAttribute *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "identifier")) {
		r->identifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->identifier);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "identifier", r->identifier));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_pull_drsuapi_DsAttributeValue(ejs, v, "value", &r->value));
	NDR_CHECK(ejs_pull_drsuapi_DsLinkedAttributeFlags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_NTTIME_1sec(ejs, v, "orginating_add_time", &r->orginating_add_time));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaMetaData(ejs, v, "meta_data", &r->meta_data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsGetNCChangesCtr6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_guid", &r->source_dsa_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (NULL == r->naming_context) {
		NDR_CHECK(ejs_push_null(ejs, v, "naming_context"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "old_highwatermark", &r->old_highwatermark));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaHighWaterMark(ejs, v, "new_highwatermark", &r->new_highwatermark));
	if (NULL == r->uptodateness_vector) {
		NDR_CHECK(ejs_push_null(ejs, v, "uptodateness_vector"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor2CtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "mapping_ctr", &r->mapping_ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_object_count", &r->total_object_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "object_count", &r->object_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size", &r->__ndr_size));
	if (NULL == r->first_object) {
		NDR_CHECK(ejs_push_null(ejs, v, "first_object"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectListItemEx(ejs, v, "first_object", r->first_object));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "linked_attributes_count", &r->linked_attributes_count));
	if (NULL == r->linked_attributes) {
		NDR_CHECK(ejs_push_null(ejs, v, "linked_attributes"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->linked_attributes_count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "linked_attributes", i);
				NDR_CHECK(ejs_push_drsuapi_DsReplicaLinkedAttribute(ejs, v, id, &r->linked_attributes[i]));
			}
			ejs_push_uint32(ejs, v, "linked_attributes" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsGetNCChangesCtr6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetNCChangesCtr6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_guid", &r->source_dsa_guid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		r->naming_context = NULL;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "old_highwatermark", &r->old_highwatermark));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaHighWaterMark(ejs, v, "new_highwatermark", &r->new_highwatermark));
	if (ejs_pull_null(ejs, v, "uptodateness_vector")) {
		r->uptodateness_vector = NULL;
	} else {
		EJS_ALLOC(ejs, r->uptodateness_vector);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaCursor2CtrEx(ejs, v, "uptodateness_vector", r->uptodateness_vector));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaOIDMapping_Ctr(ejs, v, "mapping_ctr", &r->mapping_ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "total_object_count", &r->total_object_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "object_count", &r->object_count));
	if (ejs_pull_null(ejs, v, "first_object")) {
		r->first_object = NULL;
	} else {
		EJS_ALLOC(ejs, r->first_object);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectListItemEx(ejs, v, "first_object", r->first_object));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "linked_attributes_count", &r->linked_attributes_count));
	if (ejs_pull_null(ejs, v, "linked_attributes")) {
		r->linked_attributes = NULL;
	} else {
		EJS_ALLOC(ejs, r->linked_attributes);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->linked_attributes, r->linked_attributes_count);
			for (i=0;i<r->linked_attributes_count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "linked_attributes", i);
				NDR_CHECK(ejs_pull_drsuapi_DsReplicaLinkedAttribute(ejs, v, id, &r->linked_attributes[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "linked_attributes" ".length", &i);
		}
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown7", &r->unknown7));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesMSZIPCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "decompressed_length", &r->decompressed_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "compressed_length", &r->compressed_length));
	if (NULL == r->ctr1) {
		NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesMSZIPCtr6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "decompressed_length", &r->decompressed_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "compressed_length", &r->compressed_length));
	if (NULL == r->ctr6) {
		NDR_CHECK(ejs_push_null(ejs, v, "ctr6"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesXPRESSCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesXPRESSCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "decompressed_length", &r->decompressed_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "compressed_length", &r->compressed_length));
	if (NULL == r->decompressed) {
		NDR_CHECK(ejs_push_null(ejs, v, "decompressed"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesXPRESSCtr6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesXPRESSCtr6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "decompressed_length", &r->decompressed_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "compressed_length", &r->compressed_length));
	if (NULL == r->decompressed) {
		NDR_CHECK(ejs_push_null(ejs, v, "decompressed"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesCompressionType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum drsuapi_DsGetNCChangesCompressionType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesCompressedCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesMSZIPCtr1(ejs, v, "mszip1", &r->mszip1));
			break;
		case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesMSZIPCtr6(ejs, v, "mszip6", &r->mszip6));
			break;
		case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesXPRESSCtr1(ejs, v, "xpress1", &r->xpress1));
			break;
		case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesXPRESSCtr6(ejs, v, "xpress6", &r->xpress6));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsGetNCChangesCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_set_switch(ejs, 1 | (DRSUAPI_COMPRESSION_TYPE_MSZIP << 16));
	NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCompressedCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesCtr7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNCChangesCtr7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->level));
	NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCompressionType(ejs, v, "type", &r->type));
	ejs_set_switch(ejs, r->level | (r->type << 16));
	NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCompressedCtr(ejs, v, "ctr", &r->ctr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNCChangesCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetNCChangesCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		case 2:
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCtr2(ejs, v, "ctr2", &r->ctr2));
			break;
		case 6:
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCtr6(ejs, v, "ctr6", &r->ctr6));
			break;
		case 7:
			NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCtr7(ejs, v, "ctr7", &r->ctr7));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsReplicaUpdateRefsOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_drsuapi_DsReplicaUpdateRefsOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_drsuapi_DsReplicaUpdateRefsRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "naming_context")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->naming_context);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "naming_context", r->naming_context));
	}
	if (ejs_pull_null(ejs, v, "dest_dsa_dns_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->dest_dsa_dns_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "dest_dsa_dns_name", &r->dest_dsa_dns_name));
	}
	NDR_CHECK(ejs_pull_GUID(ejs, v, "dest_dsa_guid", &r->dest_dsa_guid));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaUpdateRefsOptions(ejs, v, "options", &r->options));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaUpdateRefsRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaUpdateRefsRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsReplicaAddOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_drsuapi_DsReplicaDeleteOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_drsuapi_DsReplicaModifyOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_drsuapi_DsMembershipType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsMembershipType *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetMembershipsCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetMembershipsCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_memberships", &r->num_memberships));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_sids", &r->num_sids));
	if (NULL == r->info_array) {
		NDR_CHECK(ejs_push_null(ejs, v, "info_array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_memberships;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "info_array", i);
				if (NULL == r->info_array[i]) {
					NDR_CHECK(ejs_push_null(ejs, v, id));
				} else {
					NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, id, r->info_array[i]));
				}
			}
			ejs_push_uint32(ejs, v, "info_array" ".length", &i);
		}
	}
	if (NULL == r->group_attrs) {
		NDR_CHECK(ejs_push_null(ejs, v, "group_attrs"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_memberships;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "group_attrs", i);
				NDR_CHECK(ejs_push_samr_GroupAttrs(ejs, v, id, &r->group_attrs[i]));
			}
			ejs_push_uint32(ejs, v, "group_attrs" ".length", &i);
		}
	}
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_sids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				if (NULL == r->sids[i]) {
					NDR_CHECK(ejs_push_null(ejs, v, id));
				} else {
					NDR_CHECK(ejs_push_dom_sid28(ejs, v, id, r->sids[i]));
				}
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetMembershipsCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetMembershipsCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsGetMembershipsCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsGetMembershipsRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetMembershipsRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "info_array")) {
		r->info_array = NULL;
	} else {
		EJS_ALLOC(ejs, r->info_array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->info_array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "info_array", i);
				if (ejs_pull_null(ejs, v, id)) {
					r->info_array[i] = NULL;
				} else {
					EJS_ALLOC(ejs, r->info_array[i]);
					NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, id, r->info_array[i]));
				}
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "info_array" ".length", &i);
		}
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_drsuapi_DsMembershipType(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectIdentifier(ejs, v, "domain", r->domain));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetMembershipsRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsGetMembershipsRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsGetMembershipsRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsGetNT4ChangeLogRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->length);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetNT4ChangeLogRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsGetNT4ChangeLogRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsGetNT4ChangeLogInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "length1", &r->length1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "length2", &r->length2));
	NDR_CHECK(ejs_push_hyper(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time2", &r->time2));
	NDR_CHECK(ejs_push_hyper(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time4", &r->time4));
	NDR_CHECK(ejs_push_hyper(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time6", &r->time6));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "status", &r->status));
	if (NULL == r->data1) {
		NDR_CHECK(ejs_push_null(ejs, v, "data1"));
	} else {
		ejs_push_array_uint8(ejs, v, "data1", r->data1, r->length1);
	}
	if (NULL == r->data2) {
		NDR_CHECK(ejs_push_null(ejs, v, "data2"));
	} else {
		ejs_push_array_uint8(ejs, v, "data2", r->data2, r->length2);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetNT4ChangeLogInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsGetNT4ChangeLogInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsNameStatus(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum drsuapi_DsNameStatus *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsNameFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsNameFlags *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsNameFormat(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsNameFormat *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsNameString(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsNameString *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "str")) {
		r->str = NULL;
	} else {
		EJS_ALLOC(ejs, r->str);
		NDR_CHECK(ejs_pull_string(ejs, v, "str", &r->str));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsNameRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsNameRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "codepage", &r->codepage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "language", &r->language));
	NDR_CHECK(ejs_pull_drsuapi_DsNameFlags(ejs, v, "format_flags", &r->format_flags));
	NDR_CHECK(ejs_pull_drsuapi_DsNameFormat(ejs, v, "format_offered", &r->format_offered));
	NDR_CHECK(ejs_pull_drsuapi_DsNameFormat(ejs, v, "format_desired", &r->format_desired));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "names")) {
		r->names = NULL;
	} else {
		EJS_ALLOC(ejs, r->names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_pull_drsuapi_DsNameString(ejs, v, id, &r->names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsNameRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsNameRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsNameRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsNameInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsNameInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_drsuapi_DsNameStatus(ejs, v, "status", &r->status));
	if (NULL == r->dns_domain_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dns_domain_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dns_domain_name", r->dns_domain_name));
	}
	if (NULL == r->result_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "result_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "result_name", r->result_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsNameCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsNameCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_drsuapi_DsNameInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsNameCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsNameCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsNameCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsSpnOperation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsSpnOperation *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsWriteAccountSpnRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsSpnOperation(ejs, v, "operation", &r->operation));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	if (ejs_pull_null(ejs, v, "object_dn")) {
		r->object_dn = NULL;
	} else {
		EJS_ALLOC(ejs, r->object_dn);
		NDR_CHECK(ejs_pull_string(ejs, v, "object_dn", &r->object_dn));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "spn_names")) {
		r->spn_names = NULL;
	} else {
		EJS_ALLOC(ejs, r->spn_names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->spn_names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "spn_names", i);
				NDR_CHECK(ejs_pull_drsuapi_DsNameString(ejs, v, id, &r->spn_names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "spn_names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsWriteAccountSpnRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsWriteAccountSpnRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsWriteAccountSpnRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsWriteAccountSpnResult1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsWriteAccountSpnResult(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsWriteAccountSpnResult *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsWriteAccountSpnResult1(ejs, v, "res1", &r->res1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsRemoveDSServerRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "server_dn")) {
		r->server_dn = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_dn);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_dn", &r->server_dn));
	}
	if (ejs_pull_null(ejs, v, "domain_dn")) {
		r->domain_dn = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_dn);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_dn", &r->domain_dn));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsRemoveDSServerRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsRemoveDSServerRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsRemoveDSServerRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsRemoveDSServerResult1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsRemoveDSServerResult1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsRemoveDSServerResult(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsRemoveDSServerResult *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsRemoveDSServerResult1(ejs, v, "res1", &r->res1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsGetDCInfoRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetDCInfoRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->level));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetDCInfoRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsGetDCInfoRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsGetDCInfoRequest1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsGetDCInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->netbios_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "netbios_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "netbios_name", r->netbios_name));
	}
	if (NULL == r->dns_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dns_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dns_name", r->dns_name));
	}
	if (NULL == r->site_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "site_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "site_name", r->site_name));
	}
	if (NULL == r->computer_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "computer_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "computer_dn", r->computer_dn));
	}
	if (NULL == r->server_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_dn", r->server_dn));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_pdc", &r->is_pdc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_enabled", &r->is_enabled));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCInfoCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCInfoCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_drsuapi_DsGetDCInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->netbios_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "netbios_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "netbios_name", r->netbios_name));
	}
	if (NULL == r->dns_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dns_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dns_name", r->dns_name));
	}
	if (NULL == r->site_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "site_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "site_name", r->site_name));
	}
	if (NULL == r->site_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "site_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "site_dn", r->site_dn));
	}
	if (NULL == r->computer_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "computer_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "computer_dn", r->computer_dn));
	}
	if (NULL == r->server_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_dn", r->server_dn));
	}
	if (NULL == r->ntds_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "ntds_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "ntds_dn", r->ntds_dn));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_pdc", &r->is_pdc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_enabled", &r->is_enabled));
	NDR_CHECK(ejs_push_uint32(ejs, v, "is_gc", &r->is_gc));
	NDR_CHECK(ejs_push_GUID(ejs, v, "site_guid", &r->site_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "computer_guid", &r->computer_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "server_guid", &r->server_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "ntds_guid", &r->ntds_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCInfoCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCInfoCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_drsuapi_DsGetDCInfo2(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCConnection01(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCConnection01 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "client_ip_address", r->client_ip_address));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "connection_time", &r->connection_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	if (NULL == r->client_account) {
		NDR_CHECK(ejs_push_null(ejs, v, "client_account"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client_account", r->client_account));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCConnectionCtr01(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_drsuapi_DsGetDCConnection01(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsGetDCInfoCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetDCInfoCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DRSUAPI_DC_INFO_CTR_1:
			NDR_CHECK(ejs_push_drsuapi_DsGetDCInfoCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		case DRSUAPI_DC_INFO_CTR_2:
			NDR_CHECK(ejs_push_drsuapi_DsGetDCInfoCtr2(ejs, v, "ctr2", &r->ctr2));
			break;
		case DRSUAPI_DC_CONNECTION_CTR_01:
			NDR_CHECK(ejs_push_drsuapi_DsGetDCConnectionCtr01(ejs, v, "ctr01", &r->ctr01));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_drsuapi_DsReplicaObjectListItem(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectListItem *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->next_object) {
		NDR_CHECK(ejs_push_null(ejs, v, "next_object"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectListItem(ejs, v, "next_object", r->next_object));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaObject(ejs, v, "object", &r->object));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_drsuapi_DsReplicaObjectListItem(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaObjectListItem *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "next_object")) {
		r->next_object = NULL;
	} else {
		EJS_ALLOC(ejs, r->next_object);
		NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectListItem(ejs, v, "next_object", r->next_object));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaObject(ejs, v, "object", &r->object));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsAddEntryRequest2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsAddEntryRequest2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaObjectListItem(ejs, v, "first_object", &r->first_object));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsAddEntryRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsAddEntryRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			NDR_CHECK(ejs_pull_drsuapi_DsAddEntryRequest2(ejs, v, "req2", &r->req2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsAddEntryErrorInfoX(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryErrorInfoX *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown3", &r->unknown3));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryExtraErrorBuffer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryExtraErrorBuffer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->data, r->size);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryExtraError1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryExtraError1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "error", &r->error));
	NDR_CHECK(ejs_push_drsuapi_DsAttributeId(ejs, v, "attid", &r->attid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryExtraErrorBuffer(ejs, v, "buffer", &r->buffer));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryErrorListItem1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryErrorListItem1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->next) {
		NDR_CHECK(ejs_push_null(ejs, v, "next"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorListItem1(ejs, v, "next", r->next));
	}
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryExtraError1(ejs, v, "error", &r->error));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryErrorInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryErrorInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->id) {
		NDR_CHECK(ejs_push_null(ejs, v, "id"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "id", r->id));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorListItem1(ejs, v, "first", &r->first));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryErrorInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsAddEntryErrorInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfo1(ejs, v, "error1", &r->error1));
			break;
		case 4:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "errorX", &r->errorX));
			break;
		case 5:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "errorX", &r->errorX));
			break;
		case 6:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "errorX", &r->errorX));
			break;
		case 7:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "errorX", &r->errorX));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsAddEntryError1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryError1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->level));
	if (NULL == r->info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->level);
		NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfo(ejs, v, "info", r->info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryError(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsAddEntryError *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryError1(ejs, v, "info1", &r->info1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsReplicaObjectIdentifier2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	NDR_CHECK(ejs_push_dom_sid28(ejs, v, "sid", &r->sid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->id) {
		NDR_CHECK(ejs_push_null(ejs, v, "id"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "id", r->id));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryErrorInfoX(ejs, v, "error", &r->error));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->objects) {
		NDR_CHECK(ejs_push_null(ejs, v, "objects"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "objects", i);
				NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier2(ejs, v, id, &r->objects[i]));
			}
			ejs_push_uint32(ejs, v, "objects" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryCtr3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsAddEntryCtr3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->id) {
		NDR_CHECK(ejs_push_null(ejs, v, "id"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier(ejs, v, "id", r->id));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->level));
	if (NULL == r->error) {
		NDR_CHECK(ejs_push_null(ejs, v, "error"));
	} else {
		ejs_set_switch(ejs, r->level);
		NDR_CHECK(ejs_push_drsuapi_DsAddEntryError(ejs, v, "error", r->error));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->objects) {
		NDR_CHECK(ejs_push_null(ejs, v, "objects"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "objects", i);
				NDR_CHECK(ejs_push_drsuapi_DsReplicaObjectIdentifier2(ejs, v, id, &r->objects[i]));
			}
			ejs_push_uint32(ejs, v, "objects" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsAddEntryCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsAddEntryCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryCtr2(ejs, v, "ctr2", &r->ctr2));
			break;
		case 3:
			NDR_CHECK(ejs_push_drsuapi_DsAddEntryCtr3(ejs, v, "ctr3", &r->ctr3));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsReplicaGetInfoLevel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsReplicaGetInfoLevel *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaInfoType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum drsuapi_DsReplicaInfoType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaInfoType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum drsuapi_DsReplicaInfoType *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaGetInfoRequest1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaInfoType(ejs, v, "info_type", &r->info_type));
	if (ejs_pull_null(ejs, v, "object_dn")) {
		r->object_dn = NULL;
	} else {
		EJS_ALLOC(ejs, r->object_dn);
		NDR_CHECK(ejs_pull_string(ejs, v, "object_dn", &r->object_dn));
	}
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid1", &r->guid1));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaGetInfoRequest2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaInfoType(ejs, v, "info_type", &r->info_type));
	if (ejs_pull_null(ejs, v, "object_dn")) {
		r->object_dn = NULL;
	} else {
		EJS_ALLOC(ejs, r->object_dn);
		NDR_CHECK(ejs_pull_string(ejs, v, "object_dn", &r->object_dn));
	}
	NDR_CHECK(ejs_pull_GUID(ejs, v, "guid1", &r->guid1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	if (ejs_pull_null(ejs, v, "string1")) {
		r->string1 = NULL;
	} else {
		EJS_ALLOC(ejs, r->string1);
		NDR_CHECK(ejs_pull_string(ejs, v, "string1", &r->string1));
	}
	if (ejs_pull_null(ejs, v, "string2")) {
		r->string2 = NULL;
	} else {
		EJS_ALLOC(ejs, r->string2);
		NDR_CHECK(ejs_pull_string(ejs, v, "string2", &r->string2));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsReplicaGetInfoRequest(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsReplicaGetInfoRequest *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DRSUAPI_DS_REPLICA_GET_INFO:
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaGetInfoRequest1(ejs, v, "req1", &r->req1));
			break;
		case DRSUAPI_DS_REPLICA_GET_INFO2:
			NDR_CHECK(ejs_pull_drsuapi_DsReplicaGetInfoRequest2(ejs, v, "req2", &r->req2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsReplicaNeighbour(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaNeighbour *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->naming_context_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "naming_context_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "naming_context_dn", r->naming_context_dn));
	}
	if (NULL == r->source_dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "source_dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "source_dsa_obj_dn", r->source_dsa_obj_dn));
	}
	if (NULL == r->source_dsa_address) {
		NDR_CHECK(ejs_push_null(ejs, v, "source_dsa_address"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "source_dsa_address", r->source_dsa_address));
	}
	if (NULL == r->transport_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "transport_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "transport_obj_dn", r->transport_obj_dn));
	}
	NDR_CHECK(ejs_push_drsuapi_DsReplicaNeighbourFlags(ejs, v, "replica_flags", &r->replica_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_GUID(ejs, v, "naming_context_obj_guid", &r->naming_context_obj_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_obj_guid", &r->source_dsa_obj_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_push_GUID(ejs, v, "transport_obj_guid", &r->transport_obj_guid));
	NDR_CHECK(ejs_push_hyper(ejs, v, "tmp_highest_usn", &r->tmp_highest_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "highest_usn", &r->highest_usn));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_success", &r->last_success));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_attempt", &r->last_attempt));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result_last_attempt", &r->result_last_attempt));
	NDR_CHECK(ejs_push_uint32(ejs, v, "consecutive_sync_failures", &r->consecutive_sync_failures));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaNeighbourCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaNeighbourCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaNeighbour(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursorCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursorCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaObjMetaData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjMetaData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->attribute_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "attribute_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "attribute_name", r->attribute_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "originating_last_changed", &r->originating_last_changed));
	NDR_CHECK(ejs_push_GUID(ejs, v, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "originating_usn", &r->originating_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "local_usn", &r->local_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaObjMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaObjMetaData(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaKccDsaFailure(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaKccDsaFailure *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dsa_obj_dn", r->dsa_obj_dn));
	}
	NDR_CHECK(ejs_push_GUID(ejs, v, "dsa_obj_guid", &r->dsa_obj_guid));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "first_failure", &r->first_failure));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_failures", &r->num_failures));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "last_result", &r->last_result));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaKccDsaFailuresCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaKccDsaFailure(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaOpType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum drsuapi_DsReplicaOpType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsRplicaOpOptions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsRplicaOpOptions *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaSyncOptions(ejs, v, "sync", &r->sync));
			break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaAddOptions(ejs, v, "add", &r->add));
			break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaDeleteOptions(ejs, v, "delete", &r->delete));
			break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaModifyOptions(ejs, v, "modify", &r->modify));
			break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
			NDR_CHECK(ejs_push_drsuapi_DsReplicaUpdateRefsOptions(ejs, v, "update_refs", &r->update_refs));
			break;
		default:
			NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsReplicaOp(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaOp *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "operation_start", &r->operation_start));
	NDR_CHECK(ejs_push_uint32(ejs, v, "serial_num", &r->serial_num));
	NDR_CHECK(ejs_push_uint32(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaOpType(ejs, v, "operation_type", &r->operation_type));
	ejs_set_switch(ejs, r->operation_type);
	NDR_CHECK(ejs_push_drsuapi_DsRplicaOpOptions(ejs, v, "options", &r->options));
	if (NULL == r->nc_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "nc_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "nc_dn", r->nc_dn));
	}
	if (NULL == r->remote_dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "remote_dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "remote_dsa_obj_dn", r->remote_dsa_obj_dn));
	}
	if (NULL == r->remote_dsa_address) {
		NDR_CHECK(ejs_push_null(ejs, v, "remote_dsa_address"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "remote_dsa_address", r->remote_dsa_address));
	}
	NDR_CHECK(ejs_push_GUID(ejs, v, "nc_obj_guid", &r->nc_obj_guid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "remote_dsa_obj_guid", &r->remote_dsa_obj_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaOpCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaOpCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaOp(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaAttrValMetaData(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttrValMetaData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->attribute_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "attribute_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "attribute_name", r->attribute_name));
	}
	if (NULL == r->object_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "object_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "object_dn", r->object_dn));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_binary", &r->__ndr_size_binary));
	if (NULL == r->binary) {
		NDR_CHECK(ejs_push_null(ejs, v, "binary"));
	} else {
		NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "binary", r->binary));
	}
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "deleted", &r->deleted));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "created", &r->created));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "originating_last_changed", &r->originating_last_changed));
	NDR_CHECK(ejs_push_GUID(ejs, v, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "originating_usn", &r->originating_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "local_usn", &r->local_usn));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaAttrValMetaDataCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_int32(ejs, v, "enumeration_context", &r->enumeration_context));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaAttrValMetaData(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursor2Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor2Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_int32(ejs, v, "enumeration_context", &r->enumeration_context));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor2(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursor3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "source_dsa_invocation_id", &r->source_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "highest_usn", &r->highest_usn));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_sync_success", &r->last_sync_success));
	if (NULL == r->source_dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "source_dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "source_dsa_obj_dn", r->source_dsa_obj_dn));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaCursor3Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaCursor3Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_int32(ejs, v, "enumeration_context", &r->enumeration_context));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor3(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaObjMetaData2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjMetaData2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->attribute_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "attribute_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "attribute_name", r->attribute_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "originating_last_changed", &r->originating_last_changed));
	NDR_CHECK(ejs_push_GUID(ejs, v, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "originating_usn", &r->originating_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "local_usn", &r->local_usn));
	if (NULL == r->originating_dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "originating_dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "originating_dsa_obj_dn", r->originating_dsa_obj_dn));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaObjMetaData2Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_int32(ejs, v, "enumeration_context", &r->enumeration_context));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaObjMetaData2(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaAttrValMetaData2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->attribute_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "attribute_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "attribute_name", r->attribute_name));
	}
	if (NULL == r->object_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "object_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "object_dn", r->object_dn));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "__ndr_size_binary", &r->__ndr_size_binary));
	if (NULL == r->binary) {
		NDR_CHECK(ejs_push_null(ejs, v, "binary"));
	} else {
		NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "binary", r->binary));
	}
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "deleted", &r->deleted));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "created", &r->created));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "originating_last_changed", &r->originating_last_changed));
	NDR_CHECK(ejs_push_GUID(ejs, v, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id));
	NDR_CHECK(ejs_push_hyper(ejs, v, "originating_usn", &r->originating_usn));
	NDR_CHECK(ejs_push_hyper(ejs, v, "local_usn", &r->local_usn));
	if (NULL == r->originating_dsa_obj_dn) {
		NDR_CHECK(ejs_push_null(ejs, v, "originating_dsa_obj_dn"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "originating_dsa_obj_dn", r->originating_dsa_obj_dn));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_int32(ejs, v, "enumeration_context", &r->enumeration_context));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaAttrValMetaData2(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaConnection04(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaConnection04 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u3", &r->u3));
	NDR_CHECK(ejs_push_GUID(ejs, v, "bind_guid", &r->bind_guid));
	NDR_CHECK(ejs_push_NTTIME_1sec(ejs, v, "bind_time", &r->bind_time));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "client_ip_address", r->client_ip_address));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u5", &r->u5));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaConnection04Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplicaConnection04Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplicaConnection04(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplica06(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplica06 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->str1) {
		NDR_CHECK(ejs_push_null(ejs, v, "str1"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "str1", r->str1));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "u1", &r->u1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u2", &r->u2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u3", &r->u3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u4", &r->u4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u5", &r->u5));
	NDR_CHECK(ejs_push_hyper(ejs, v, "u6", &r->u6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "u7", &r->u7));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplica06Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct drsuapi_DsReplica06Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
			NDR_CHECK(ejs_push_drsuapi_DsReplica06(ejs, v, id, &r->array[i]));
		}
		ejs_push_uint32(ejs, v, "array" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_drsuapi_DsReplicaInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsReplicaInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
			if (NULL == r->neighbours) {
				NDR_CHECK(ejs_push_null(ejs, v, "neighbours"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaNeighbourCtr(ejs, v, "neighbours", r->neighbours));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS:
			if (NULL == r->cursors) {
				NDR_CHECK(ejs_push_null(ejs, v, "cursors"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaCursorCtr(ejs, v, "cursors", r->cursors));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
			if (NULL == r->objmetadata) {
				NDR_CHECK(ejs_push_null(ejs, v, "objmetadata"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaObjMetaDataCtr(ejs, v, "objmetadata", r->objmetadata));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
			if (NULL == r->connectfailures) {
				NDR_CHECK(ejs_push_null(ejs, v, "connectfailures"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaKccDsaFailuresCtr(ejs, v, "connectfailures", r->connectfailures));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
			if (NULL == r->linkfailures) {
				NDR_CHECK(ejs_push_null(ejs, v, "linkfailures"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaKccDsaFailuresCtr(ejs, v, "linkfailures", r->linkfailures));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
			if (NULL == r->pendingops) {
				NDR_CHECK(ejs_push_null(ejs, v, "pendingops"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaOpCtr(ejs, v, "pendingops", r->pendingops));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
			if (NULL == r->attrvalmetadata) {
				NDR_CHECK(ejs_push_null(ejs, v, "attrvalmetadata"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaAttrValMetaDataCtr(ejs, v, "attrvalmetadata", r->attrvalmetadata));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
			if (NULL == r->cursors2) {
				NDR_CHECK(ejs_push_null(ejs, v, "cursors2"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor2Ctr(ejs, v, "cursors2", r->cursors2));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
			if (NULL == r->cursors3) {
				NDR_CHECK(ejs_push_null(ejs, v, "cursors3"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaCursor3Ctr(ejs, v, "cursors3", r->cursors3));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
			if (NULL == r->objmetadata2) {
				NDR_CHECK(ejs_push_null(ejs, v, "objmetadata2"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaObjMetaData2Ctr(ejs, v, "objmetadata2", r->objmetadata2));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
			if (NULL == r->attrvalmetadata2) {
				NDR_CHECK(ejs_push_null(ejs, v, "attrvalmetadata2"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaAttrValMetaData2Ctr(ejs, v, "attrvalmetadata2", r->attrvalmetadata2));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
			if (NULL == r->neighbours02) {
				NDR_CHECK(ejs_push_null(ejs, v, "neighbours02"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaNeighbourCtr(ejs, v, "neighbours02", r->neighbours02));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
			if (NULL == r->connections04) {
				NDR_CHECK(ejs_push_null(ejs, v, "connections04"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaConnection04Ctr(ejs, v, "connections04", r->connections04));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS05:
			if (NULL == r->cursors05) {
				NDR_CHECK(ejs_push_null(ejs, v, "cursors05"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplicaCursorCtrEx(ejs, v, "cursors05", r->cursors05));
			}
			break;
		case DRSUAPI_DS_REPLICA_INFO_06:
			if (NULL == r->i06) {
				NDR_CHECK(ejs_push_null(ejs, v, "i06"));
			} else {
				NDR_CHECK(ejs_push_drsuapi_DsReplica06Ctr(ejs, v, "i06", r->i06));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_drsuapi_DsGetMemberships2Ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union drsuapi_DsGetMemberships2Ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_drsuapi_DsGetMembershipsCtr1(ejs, v, "ctr1", &r->ctr1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_drsuapi_DsGetMemberships2Request1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct drsuapi_DsGetMemberships2Request1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_req", &r->num_req));
	if (ejs_pull_null(ejs, v, "req_array")) {
		r->req_array = NULL;
	} else {
		EJS_ALLOC(ejs, r->req_array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->req_array, r->num_req);
			for (i=0;i<r->num_req;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "req_array", i);
				if (ejs_pull_null(ejs, v, id)) {
					r->req_array[i] = NULL;
				} else {
					EJS_ALLOC(ejs, r->req_array[i]);
					NDR_CHECK(ejs_pull_drsuapi_DsGetMembershipsRequest1(ejs, v, id, r->req_array[i]));
				}
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "req_array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsGetMemberships2Request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union drsuapi_DsGetMemberships2Request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_drsuapi_DsGetMemberships2Request1(ejs, v, "req1", &r->req1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_drsuapi_DsBind(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsBind *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_guid")) {
		r->in.bind_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.bind_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "bind_guid", r->in.bind_guid));
	}
	if (ejs_pull_null(ejs, v, "bind_info")) {
		r->in.bind_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.bind_info);
		NDR_CHECK(ejs_pull_drsuapi_DsBindInfoCtr(ejs, v, "bind_info", r->in.bind_info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsBind(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsBind *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.bind_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "bind_info"));
	} else {
		NDR_CHECK(ejs_push_drsuapi_DsBindInfoCtr(ejs, v, "bind_info", r->out.bind_info));
	}
	if (NULL == r->out.bind_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "bind_handle", r->out.bind_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsBind(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSBIND, (ejs_pull_function_t)ejs_pull_drsuapi_DsBind, (ejs_push_function_t)ejs_push_drsuapi_DsBind);
}


static NTSTATUS ejs_pull_drsuapi_DsUnbind(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsUnbind *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsUnbind(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsUnbind *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.bind_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "bind_handle", r->out.bind_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsUnbind(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSUNBIND, (ejs_pull_function_t)ejs_pull_drsuapi_DsUnbind, (ejs_push_function_t)ejs_push_drsuapi_DsUnbind);
}


static NTSTATUS ejs_pull_drsuapi_DsReplicaSync(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsReplicaSync *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaSyncRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsReplicaSync(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsReplicaSync *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsReplicaSync(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSREPLICASYNC, (ejs_pull_function_t)ejs_pull_drsuapi_DsReplicaSync, (ejs_push_function_t)ejs_push_drsuapi_DsReplicaSync);
}


static NTSTATUS ejs_pull_drsuapi_DsGetNCChanges(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsGetNCChanges *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	if (ejs_pull_null(ejs, v, "level")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.level);
		NDR_CHECK(ejs_pull_int32(ejs, v, "level", r->in.level));
	}
	ejs_set_switch(ejs, *r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsGetNCChangesRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsGetNCChanges(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsGetNCChanges *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.level) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_int32(ejs, v, "level", r->out.level));
	}
	ejs_set_switch(ejs, *r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsGetNCChangesCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsGetNCChanges(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSGETNCCHANGES, (ejs_pull_function_t)ejs_pull_drsuapi_DsGetNCChanges, (ejs_push_function_t)ejs_push_drsuapi_DsGetNCChanges);
}


static NTSTATUS ejs_pull_drsuapi_DsReplicaUpdateRefs(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsReplicaUpdateRefs *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaUpdateRefsRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsReplicaUpdateRefs(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsReplicaUpdateRefs *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsReplicaUpdateRefs(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSREPLICAUPDATEREFS, (ejs_pull_function_t)ejs_pull_drsuapi_DsReplicaUpdateRefs, (ejs_push_function_t)ejs_push_drsuapi_DsReplicaUpdateRefs);
}


static NTSTATUS ejs_pull_DRSUAPI_REPLICA_ADD(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_REPLICA_ADD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_REPLICA_ADD(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_REPLICA_ADD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_REPLICA_ADD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_REPLICA_ADD, (ejs_pull_function_t)ejs_pull_DRSUAPI_REPLICA_ADD, (ejs_push_function_t)ejs_push_DRSUAPI_REPLICA_ADD);
}


static NTSTATUS ejs_pull_DRSUAPI_REPLICA_DEL(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_REPLICA_DEL *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_REPLICA_DEL(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_REPLICA_DEL *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_REPLICA_DEL(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_REPLICA_DEL, (ejs_pull_function_t)ejs_pull_DRSUAPI_REPLICA_DEL, (ejs_push_function_t)ejs_push_DRSUAPI_REPLICA_DEL);
}


static NTSTATUS ejs_pull_DRSUAPI_REPLICA_MODIFY(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_REPLICA_MODIFY *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_REPLICA_MODIFY(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_REPLICA_MODIFY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_REPLICA_MODIFY(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_REPLICA_MODIFY, (ejs_pull_function_t)ejs_pull_DRSUAPI_REPLICA_MODIFY, (ejs_push_function_t)ejs_push_DRSUAPI_REPLICA_MODIFY);
}


static NTSTATUS ejs_pull_DRSUAPI_VERIFY_NAMES(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_VERIFY_NAMES *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_VERIFY_NAMES(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_VERIFY_NAMES *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_VERIFY_NAMES(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_VERIFY_NAMES, (ejs_pull_function_t)ejs_pull_DRSUAPI_VERIFY_NAMES, (ejs_push_function_t)ejs_push_DRSUAPI_VERIFY_NAMES);
}


static NTSTATUS ejs_pull_drsuapi_DsGetMemberships(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsGetMemberships *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsGetMembershipsRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsGetMemberships(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsGetMemberships *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsGetMembershipsCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsGetMemberships(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSGETMEMBERSHIPS, (ejs_pull_function_t)ejs_pull_drsuapi_DsGetMemberships, (ejs_push_function_t)ejs_push_drsuapi_DsGetMemberships);
}


static NTSTATUS ejs_pull_DRSUAPI_INTER_DOMAIN_MOVE(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_INTER_DOMAIN_MOVE(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_INTER_DOMAIN_MOVE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_INTER_DOMAIN_MOVE, (ejs_pull_function_t)ejs_pull_DRSUAPI_INTER_DOMAIN_MOVE, (ejs_push_function_t)ejs_push_DRSUAPI_INTER_DOMAIN_MOVE);
}


static NTSTATUS ejs_pull_drsuapi_DsGetNT4ChangeLog(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsGetNT4ChangeLog *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsGetNT4ChangeLogRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsGetNT4ChangeLog(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsGetNT4ChangeLog *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsGetNT4ChangeLogInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsGetNT4ChangeLog(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSGETNT4CHANGELOG, (ejs_pull_function_t)ejs_pull_drsuapi_DsGetNT4ChangeLog, (ejs_push_function_t)ejs_push_drsuapi_DsGetNT4ChangeLog);
}


static NTSTATUS ejs_pull_drsuapi_DsCrackNames(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsCrackNames *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsNameRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsCrackNames(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsCrackNames *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsNameCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsCrackNames(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSCRACKNAMES, (ejs_pull_function_t)ejs_pull_drsuapi_DsCrackNames, (ejs_push_function_t)ejs_push_drsuapi_DsCrackNames);
}


static NTSTATUS ejs_pull_drsuapi_DsWriteAccountSpn(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsWriteAccountSpn *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsWriteAccountSpnRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsWriteAccountSpn(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsWriteAccountSpn *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsWriteAccountSpnResult(ejs, v, "res", &r->out.res));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsWriteAccountSpn(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSWRITEACCOUNTSPN, (ejs_pull_function_t)ejs_pull_drsuapi_DsWriteAccountSpn, (ejs_push_function_t)ejs_push_drsuapi_DsWriteAccountSpn);
}


static NTSTATUS ejs_pull_drsuapi_DsRemoveDSServer(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsRemoveDSServer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsRemoveDSServerRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsRemoveDSServer(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsRemoveDSServer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsRemoveDSServerResult(ejs, v, "res", &r->out.res));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsRemoveDSServer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSREMOVEDSSERVER, (ejs_pull_function_t)ejs_pull_drsuapi_DsRemoveDSServer, (ejs_push_function_t)ejs_push_drsuapi_DsRemoveDSServer);
}


static NTSTATUS ejs_pull_DRSUAPI_REMOVE_DS_DOMAIN(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_REMOVE_DS_DOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_REMOVE_DS_DOMAIN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_REMOVE_DS_DOMAIN, (ejs_pull_function_t)ejs_pull_DRSUAPI_REMOVE_DS_DOMAIN, (ejs_push_function_t)ejs_push_DRSUAPI_REMOVE_DS_DOMAIN);
}


static NTSTATUS ejs_pull_drsuapi_DsGetDomainControllerInfo(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsGetDomainControllerInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsGetDCInfoRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsGetDomainControllerInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsGetDomainControllerInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level_out", &r->out.level_out));
	ejs_set_switch(ejs, r->out.level_out);
	NDR_CHECK(ejs_push_drsuapi_DsGetDCInfoCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsGetDomainControllerInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSGETDOMAINCONTROLLERINFO, (ejs_pull_function_t)ejs_pull_drsuapi_DsGetDomainControllerInfo, (ejs_push_function_t)ejs_push_drsuapi_DsGetDomainControllerInfo);
}


static NTSTATUS ejs_pull_drsuapi_DsAddEntry(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsAddEntry *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsAddEntryRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsAddEntry(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsAddEntry *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsAddEntryCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsAddEntry(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSADDENTRY, (ejs_pull_function_t)ejs_pull_drsuapi_DsAddEntry, (ejs_push_function_t)ejs_push_drsuapi_DsAddEntry);
}


static NTSTATUS ejs_pull_DRSUAPI_EXECUTE_KCC(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_EXECUTE_KCC *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_EXECUTE_KCC(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_EXECUTE_KCC *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_EXECUTE_KCC(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_EXECUTE_KCC, (ejs_pull_function_t)ejs_pull_DRSUAPI_EXECUTE_KCC, (ejs_push_function_t)ejs_push_DRSUAPI_EXECUTE_KCC);
}


static NTSTATUS ejs_pull_drsuapi_DsReplicaGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsReplicaGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaGetInfoLevel(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsReplicaGetInfoRequest(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsReplicaGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsReplicaGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_drsuapi_DsReplicaInfoType(ejs, v, "info_type", &r->out.info_type));
	ejs_set_switch(ejs, r->out.info_type);
	NDR_CHECK(ejs_push_drsuapi_DsReplicaInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsReplicaGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSREPLICAGETINFO, (ejs_pull_function_t)ejs_pull_drsuapi_DsReplicaGetInfo, (ejs_push_function_t)ejs_push_drsuapi_DsReplicaGetInfo);
}


static NTSTATUS ejs_pull_DRSUAPI_ADD_SID_HISTORY(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_ADD_SID_HISTORY *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_ADD_SID_HISTORY(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_ADD_SID_HISTORY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_ADD_SID_HISTORY(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_ADD_SID_HISTORY, (ejs_pull_function_t)ejs_pull_DRSUAPI_ADD_SID_HISTORY, (ejs_push_function_t)ejs_push_DRSUAPI_ADD_SID_HISTORY);
}


static NTSTATUS ejs_pull_drsuapi_DsGetMemberships2(struct ejs_rpc *ejs, struct MprVar *v, struct drsuapi_DsGetMemberships2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "bind_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.bind_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "bind_handle", r->in.bind_handle));
	}
	NDR_CHECK(ejs_pull_int32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_drsuapi_DsGetMemberships2Request(ejs, v, "req", &r->in.req));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_drsuapi_DsGetMemberships2(struct ejs_rpc *ejs, struct MprVar *v, const struct drsuapi_DsGetMemberships2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_int32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_drsuapi_DsGetMemberships2Ctr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_drsuapi_DsGetMemberships2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_DSGETMEMBERSHIPS2, (ejs_pull_function_t)ejs_pull_drsuapi_DsGetMemberships2, (ejs_push_function_t)ejs_push_drsuapi_DsGetMemberships2);
}


static NTSTATUS ejs_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_REPLICA_VERIFY_OBJECTS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_REPLICA_VERIFY_OBJECTS, (ejs_pull_function_t)ejs_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS, (ejs_push_function_t)ejs_push_DRSUAPI_REPLICA_VERIFY_OBJECTS);
}


static NTSTATUS ejs_pull_DRSUAPI_GET_OBJECT_EXISTENCE(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_GET_OBJECT_EXISTENCE(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_GET_OBJECT_EXISTENCE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_GET_OBJECT_EXISTENCE, (ejs_pull_function_t)ejs_pull_DRSUAPI_GET_OBJECT_EXISTENCE, (ejs_push_function_t)ejs_push_DRSUAPI_GET_OBJECT_EXISTENCE);
}


static NTSTATUS ejs_pull_DRSUAPI_QUERY_SITES_BY_COST(struct ejs_rpc *ejs, struct MprVar *v, struct DRSUAPI_QUERY_SITES_BY_COST *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_DRSUAPI_QUERY_SITES_BY_COST(struct ejs_rpc *ejs, struct MprVar *v, const struct DRSUAPI_QUERY_SITES_BY_COST *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_DRSUAPI_QUERY_SITES_BY_COST(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_drsuapi, DCERPC_DRSUAPI_QUERY_SITES_BY_COST, (ejs_pull_function_t)ejs_pull_DRSUAPI_QUERY_SITES_BY_COST, (ejs_push_function_t)ejs_push_DRSUAPI_QUERY_SITES_BY_COST);
}

static int ejs_drsuapi_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "drsuapi", argc, argv);
	mprSetCFunction(obj, "drsuapi_DsBind", ejs_drsuapi_DsBind);
	mprSetCFunction(obj, "drsuapi_DsUnbind", ejs_drsuapi_DsUnbind);
	mprSetCFunction(obj, "drsuapi_DsReplicaSync", ejs_drsuapi_DsReplicaSync);
	mprSetCFunction(obj, "drsuapi_DsGetNCChanges", ejs_drsuapi_DsGetNCChanges);
	mprSetCFunction(obj, "drsuapi_DsReplicaUpdateRefs", ejs_drsuapi_DsReplicaUpdateRefs);
	mprSetCFunction(obj, "DRSUAPI_REPLICA_ADD", ejs_DRSUAPI_REPLICA_ADD);
	mprSetCFunction(obj, "DRSUAPI_REPLICA_DEL", ejs_DRSUAPI_REPLICA_DEL);
	mprSetCFunction(obj, "DRSUAPI_REPLICA_MODIFY", ejs_DRSUAPI_REPLICA_MODIFY);
	mprSetCFunction(obj, "DRSUAPI_VERIFY_NAMES", ejs_DRSUAPI_VERIFY_NAMES);
	mprSetCFunction(obj, "drsuapi_DsGetMemberships", ejs_drsuapi_DsGetMemberships);
	mprSetCFunction(obj, "DRSUAPI_INTER_DOMAIN_MOVE", ejs_DRSUAPI_INTER_DOMAIN_MOVE);
	mprSetCFunction(obj, "drsuapi_DsGetNT4ChangeLog", ejs_drsuapi_DsGetNT4ChangeLog);
	mprSetCFunction(obj, "drsuapi_DsCrackNames", ejs_drsuapi_DsCrackNames);
	mprSetCFunction(obj, "drsuapi_DsWriteAccountSpn", ejs_drsuapi_DsWriteAccountSpn);
	mprSetCFunction(obj, "drsuapi_DsRemoveDSServer", ejs_drsuapi_DsRemoveDSServer);
	mprSetCFunction(obj, "DRSUAPI_REMOVE_DS_DOMAIN", ejs_DRSUAPI_REMOVE_DS_DOMAIN);
	mprSetCFunction(obj, "drsuapi_DsGetDomainControllerInfo", ejs_drsuapi_DsGetDomainControllerInfo);
	mprSetCFunction(obj, "drsuapi_DsAddEntry", ejs_drsuapi_DsAddEntry);
	mprSetCFunction(obj, "DRSUAPI_EXECUTE_KCC", ejs_DRSUAPI_EXECUTE_KCC);
	mprSetCFunction(obj, "drsuapi_DsReplicaGetInfo", ejs_drsuapi_DsReplicaGetInfo);
	mprSetCFunction(obj, "DRSUAPI_ADD_SID_HISTORY", ejs_DRSUAPI_ADD_SID_HISTORY);
	mprSetCFunction(obj, "drsuapi_DsGetMemberships2", ejs_drsuapi_DsGetMemberships2);
	mprSetCFunction(obj, "DRSUAPI_REPLICA_VERIFY_OBJECTS", ejs_DRSUAPI_REPLICA_VERIFY_OBJECTS);
	mprSetCFunction(obj, "DRSUAPI_GET_OBJECT_EXISTENCE", ejs_DRSUAPI_GET_OBJECT_EXISTENCE);
	mprSetCFunction(obj, "DRSUAPI_QUERY_SITES_BY_COST", ejs_DRSUAPI_QUERY_SITES_BY_COST);
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_gPLink", mprCreateNumberVar(0x0009037b));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_PARTIAL_ATTRIBUTE_SET", mprCreateNumberVar(( 0x40000000 )));
	mprSetVar(obj, "DRSUAPI_DS_SPN_OPERATION_DELETE", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_ABANDONED", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_CANONICAL", mprCreateNumberVar(7));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_priorValue", mprCreateNumberVar(0x00090064));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE", mprCreateNumberVar(3));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_schemaIDGUID", mprCreateNumberVar(0x00090094));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_GET_INFO2", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_instanceType", mprCreateNumberVar(0x00020001));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_DO_SCHEDULED_SYNCS", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_FQDN_1779", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_objectClass", mprCreateNumberVar(0x00000000));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_member", mprCreateNumberVar(0x0000001f));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02", mprCreateNumberVar(-2));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_wellKnownObjects", mprCreateNumberVar(0x0009026a));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_OP_TYPE_DELETE", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL", mprCreateNumberVar(7));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS", mprCreateNumberVar(6));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_msDS_hasMasterNCs", mprCreateNumberVar(0x0009072c));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_lDAPDisplayName", mprCreateNumberVar(0x000201cc));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_unicodePwd", mprCreateNumberVar(0x0009005a));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_GET_INFO", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_UKNOWN", mprCreateNumberVar(0));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_DELETE_WRITEABLE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_initialAuthOutgoing", mprCreateNumberVar(0x0009021c));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_DISABLE_SCHEDULED_SYNC", mprCreateNumberVar(( 0x08000000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_hasMasterNCs", mprCreateNumberVar(0x0002000e));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_FORCE", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_SYNC_ON_STARTUP", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN", mprCreateNumberVar(12));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_UPDATE_0x00000010", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_OP_TYPE_ADD", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_PENDING_OPS", mprCreateNumberVar(5));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_fSMORoleOwner", mprCreateNumberVar(0x00090171));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_showInAdvancedViewOnly", mprCreateNumberVar(0x000200a9));
	mprSetVar(obj, "DRSUAPI_DS_BIND_GUID_W2K", mprString("6abec3d1-3054-41c8-a362-5a0c5b7d5d71"));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_adminDisplayName", mprCreateNumberVar(0x000200c2));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_trustAuthIncoming", mprCreateNumberVar(0x00090081));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_NEXT_PACKET", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_NOT_FOUND", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_GUID", mprCreateNumberVar(6));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_PREEMPTED", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA", mprCreateNumberVar(6));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_isSingleValued", mprCreateNumberVar(0x00020021));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY", mprCreateNumberVar(0x1));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_serverReference", mprCreateNumberVar(0x00090203));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_PERIODIC", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS", mprCreateNumberVar(4));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_attributeID", mprCreateNumberVar(0x0002001e));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_URGENT", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY", mprCreateNumberVar(3));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_IGNORE_CHANGE_NOTIFICATIONS", mprCreateNumberVar(( 0x04000000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_systemFlags", mprCreateNumberVar(0x00090177));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_adminDescription", mprCreateNumberVar(0x000200e2));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_governsID", mprCreateNumberVar(0x00020016));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_supplementalCredentials", mprCreateNumberVar(0x0009007d));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_objectVersion", mprCreateNumberVar(0x0002004c));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_OP_TYPE_SYNC", mprCreateNumberVar(0));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2", mprCreateNumberVar(9));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC", mprCreateNumberVar(0x2));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_NO_CHANGE_NOTIFICATIONS", mprCreateNumberVar(( 0x20000000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_ntPwdHistory", mprCreateNumberVar(0x0009005e));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY", mprCreateNumberVar(5));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_dBCSPwd", mprCreateNumberVar(0x00090037));
	mprSetVar(obj, "DRSUAPI_COMPRESSION_TYPE_MSZIP", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS", mprCreateNumberVar(5));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_COMPRESS_CHANGES", mprCreateNumberVar(( 0x10000000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS", mprCreateNumberVar(0));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_ADD_WRITEABLE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES", mprCreateNumberVar(4));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_CURSORS2", mprCreateNumberVar(7));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2", mprCreateNumberVar(10));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES", mprCreateNumberVar(3));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL", mprCreateNumberVar(8));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_NO_MAPPING", mprCreateNumberVar(4));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_FLAG_GROUP_ATTR", mprCreateNumberVar(0x1));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_currentValue", mprCreateNumberVar(0x0009001b));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_initialAuthIncoming", mprCreateNumberVar(0x0009021b));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FLAG_GCVERIFY", mprCreateNumberVar(0x4));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL", mprCreateNumberVar(10));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_rangeUpper", mprCreateNumberVar(0x00020023));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_FULL", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FLAG_NO_FLAGS", mprCreateNumberVar(0x0));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_rangeLower", mprCreateNumberVar(0x00020022));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_isMemberOfPartialAttributeSet", mprCreateNumberVar(0x0009027f));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_IN_PROGRESS", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_TWO_WAY_SYNC", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "DRSUAPI_DS_BIND_GUID", mprString("e24d201a-4fd6-11d1-a3da-0000f875ae0d"));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_dMDLocation", mprCreateNumberVar(0x00020024));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_searchFlags", mprCreateNumberVar(0x0002014e));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_INITIAL", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_lmPwdHistory", mprCreateNumberVar(0x000900a0));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_objectSid", mprCreateNumberVar(0x00090092));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_description", mprCreateNumberVar(0x0000000d));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_objectCategory", mprCreateNumberVar(0x0009030e));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_msDS_HasDomainNCs", mprCreateNumberVar(0x0009071c));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2", mprCreateNumberVar(7));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_CRITICAL", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_WRITEABLE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_trustAuthOutgoing", mprCreateNumberVar(0x00090087));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_msDS_Behavior_Version", mprCreateNumberVar(0x000905b3));
	mprSetVar(obj, "DRSUAPI_COMPRESSION_TYPE_XPRESS", mprCreateNumberVar(3));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_06", mprCreateNumberVar(-6));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_CURSORS05", mprCreateNumberVar(-5));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_invocationId", mprCreateNumberVar(0x00020073));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY", mprCreateNumberVar(11));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_name", mprCreateNumberVar(0x00090001));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS", mprCreateNumberVar(2));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL", mprCreateNumberVar(0x8));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_RETURN_OBJECT_PARENTS", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_CURSORS3", mprCreateNumberVar(8));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_serverReferenceBL", mprCreateNumberVar(0x00090204));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_OK", mprCreateNumberVar(0));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_whenCreated", mprCreateNumberVar(0x00020002));
	mprSetVar(obj, "DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING", mprCreateNumberVar(6));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_CURSORS", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_DS_BIND_GUID_W2K3", mprString("6afab99c-6e26-464a-975f-f58f105218bc"));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_ntSecurityDescriptor", mprCreateNumberVar(0x00020119));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_sAMAccountName", mprCreateNumberVar(0x000900dd));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX", mprCreateNumberVar(9));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS", mprCreateNumberVar(3));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04", mprCreateNumberVar(-4));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_oMSyntax", mprCreateNumberVar(0x000200e7));
	mprSetVar(obj, "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2", mprCreateNumberVar(4));
	mprSetVar(obj, "DRSUAPI_DS_SPN_OPERATION_REPLACE", mprCreateNumberVar(1));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_USE_ASYNC_INTERSIDE_TRANSPORT", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_REQUEUE", mprCreateNumberVar(( 0x00040000 )));
	mprSetVar(obj, "DRSUAPI_DS_SPN_OPERATION_ADD", mprCreateNumberVar(0));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_NEVER_SYNCED", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_PREEMPTED", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_attributeSyntax", mprCreateNumberVar(0x00020020));
	mprSetVar(obj, "DRSUAPI_ATTRIBUTE_msDS_KeyVersionNumber", mprCreateNumberVar(0x000906f6));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_NEIGHBOUR_WRITEABLE", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "DRSUAPI_DS_REPLICA_SYNC_TWO_WAY", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "DRSUAPI_DS_NAME_FORMAT_DISPLAY", mprCreateNumberVar(3));
	return ejs_rpc_init(obj, "drsuapi");
}

NTSTATUS ejs_init_drsuapi(void)
{
	ejsDefineCFunction(-1, "drsuapi_init", ejs_drsuapi_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
