
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_dssetup.h"
#include "librpc/gen_ndr/ndr_dssetup_ejs.h"


static NTSTATUS ejs_push_dssetup_DsRole(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dssetup_DsRole *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsRoleFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_dssetup_DsRolePrimaryDomInfoBasic(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dssetup_DsRolePrimaryDomInfoBasic *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dssetup_DsRole(ejs, v, "role", &r->role));
	NDR_CHECK(ejs_push_dssetup_DsRoleFlags(ejs, v, "flags", &r->flags));
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	if (NULL == r->dns_domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "dns_domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dns_domain", r->dns_domain));
	}
	if (NULL == r->forest) {
		NDR_CHECK(ejs_push_null(ejs, v, "forest"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "forest", r->forest));
	}
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_guid", &r->domain_guid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsUpgrade(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dssetup_DsUpgrade *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsPrevious(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dssetup_DsPrevious *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsRoleUpgradeStatus(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dssetup_DsRoleUpgradeStatus *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dssetup_DsUpgrade(ejs, v, "upgrading", &r->upgrading));
	NDR_CHECK(ejs_push_dssetup_DsPrevious(ejs, v, "previous_role", &r->previous_role));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsRoleOp(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dssetup_DsRoleOp *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsRoleOpStatus(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dssetup_DsRoleOpStatus *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dssetup_DsRoleOp(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dssetup_DsRoleInfoLevel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dssetup_DsRoleInfoLevel *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dssetup_DsRoleInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dssetup_DsRoleInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DS_ROLE_BASIC_INFORMATION:
			NDR_CHECK(ejs_push_dssetup_DsRolePrimaryDomInfoBasic(ejs, v, "basic", &r->basic));
			break;
		case DS_ROLE_UPGRADE_STATUS:
			NDR_CHECK(ejs_push_dssetup_DsRoleUpgradeStatus(ejs, v, "upgrade", &r->upgrade));
			break;
		case DS_ROLE_OP_STATUS:
			NDR_CHECK(ejs_push_dssetup_DsRoleOpStatus(ejs, v, "opstatus", &r->opstatus));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dssetup_DsRoleGetPrimaryDomainInformation(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleGetPrimaryDomainInformation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_dssetup_DsRoleInfoLevel(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleGetPrimaryDomainInformation(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleGetPrimaryDomainInformation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_dssetup_DsRoleInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleGetPrimaryDomainInformation(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEGETPRIMARYDOMAININFORMATION, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleGetPrimaryDomainInformation, (ejs_push_function_t)ejs_push_dssetup_DsRoleGetPrimaryDomainInformation);
}


static NTSTATUS ejs_pull_dssetup_DsRoleDnsNameToFlatName(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleDnsNameToFlatName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleDnsNameToFlatName(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleDnsNameToFlatName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleDnsNameToFlatName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEDNSNAMETOFLATNAME, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleDnsNameToFlatName, (ejs_push_function_t)ejs_push_dssetup_DsRoleDnsNameToFlatName);
}


static NTSTATUS ejs_pull_dssetup_DsRoleDcAsDc(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleDcAsDc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleDcAsDc(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleDcAsDc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleDcAsDc(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEDCASDC, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleDcAsDc, (ejs_push_function_t)ejs_push_dssetup_DsRoleDcAsDc);
}


static NTSTATUS ejs_pull_dssetup_DsRoleDcAsReplica(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleDcAsReplica *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleDcAsReplica(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleDcAsReplica *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleDcAsReplica(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEDCASREPLICA, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleDcAsReplica, (ejs_push_function_t)ejs_push_dssetup_DsRoleDcAsReplica);
}


static NTSTATUS ejs_pull_dssetup_DsRoleDemoteDc(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleDemoteDc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleDemoteDc(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleDemoteDc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleDemoteDc(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEDEMOTEDC, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleDemoteDc, (ejs_push_function_t)ejs_push_dssetup_DsRoleDemoteDc);
}


static NTSTATUS ejs_pull_dssetup_DsRoleGetDcOperationProgress(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleGetDcOperationProgress *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleGetDcOperationProgress(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleGetDcOperationProgress *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleGetDcOperationProgress(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEGETDCOPERATIONPROGRESS, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleGetDcOperationProgress, (ejs_push_function_t)ejs_push_dssetup_DsRoleGetDcOperationProgress);
}


static NTSTATUS ejs_pull_dssetup_DsRoleGetDcOperationResults(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleGetDcOperationResults *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleGetDcOperationResults(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleGetDcOperationResults *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleGetDcOperationResults(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEGETDCOPERATIONRESULTS, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleGetDcOperationResults, (ejs_push_function_t)ejs_push_dssetup_DsRoleGetDcOperationResults);
}


static NTSTATUS ejs_pull_dssetup_DsRoleCancel(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleCancel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleCancel(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleCancel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleCancel(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLECANCEL, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleCancel, (ejs_push_function_t)ejs_push_dssetup_DsRoleCancel);
}


static NTSTATUS ejs_pull_dssetup_DsRoleServerSaveStateForUpgrade(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleServerSaveStateForUpgrade *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleServerSaveStateForUpgrade(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleServerSaveStateForUpgrade *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleServerSaveStateForUpgrade(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLESERVERSAVESTATEFORUPGRADE, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleServerSaveStateForUpgrade, (ejs_push_function_t)ejs_push_dssetup_DsRoleServerSaveStateForUpgrade);
}


static NTSTATUS ejs_pull_dssetup_DsRoleUpgradeDownlevelServer(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleUpgradeDownlevelServer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleUpgradeDownlevelServer(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleUpgradeDownlevelServer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleUpgradeDownlevelServer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEUPGRADEDOWNLEVELSERVER, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleUpgradeDownlevelServer, (ejs_push_function_t)ejs_push_dssetup_DsRoleUpgradeDownlevelServer);
}


static NTSTATUS ejs_pull_dssetup_DsRoleAbortDownlevelServerUpgrade(struct ejs_rpc *ejs, struct MprVar *v, struct dssetup_DsRoleAbortDownlevelServerUpgrade *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_dssetup_DsRoleAbortDownlevelServerUpgrade(struct ejs_rpc *ejs, struct MprVar *v, const struct dssetup_DsRoleAbortDownlevelServerUpgrade *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_dssetup_DsRoleAbortDownlevelServerUpgrade(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_dssetup, DCERPC_DSSETUP_DSROLEABORTDOWNLEVELSERVERUPGRADE, (ejs_pull_function_t)ejs_pull_dssetup_DsRoleAbortDownlevelServerUpgrade, (ejs_push_function_t)ejs_push_dssetup_DsRoleAbortDownlevelServerUpgrade);
}

static int ejs_dssetup_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "dssetup", argc, argv);
	mprSetCFunction(obj, "dssetup_DsRoleGetPrimaryDomainInformation", ejs_dssetup_DsRoleGetPrimaryDomainInformation);
	mprSetCFunction(obj, "dssetup_DsRoleDnsNameToFlatName", ejs_dssetup_DsRoleDnsNameToFlatName);
	mprSetCFunction(obj, "dssetup_DsRoleDcAsDc", ejs_dssetup_DsRoleDcAsDc);
	mprSetCFunction(obj, "dssetup_DsRoleDcAsReplica", ejs_dssetup_DsRoleDcAsReplica);
	mprSetCFunction(obj, "dssetup_DsRoleDemoteDc", ejs_dssetup_DsRoleDemoteDc);
	mprSetCFunction(obj, "dssetup_DsRoleGetDcOperationProgress", ejs_dssetup_DsRoleGetDcOperationProgress);
	mprSetCFunction(obj, "dssetup_DsRoleGetDcOperationResults", ejs_dssetup_DsRoleGetDcOperationResults);
	mprSetCFunction(obj, "dssetup_DsRoleCancel", ejs_dssetup_DsRoleCancel);
	mprSetCFunction(obj, "dssetup_DsRoleServerSaveStateForUpgrade", ejs_dssetup_DsRoleServerSaveStateForUpgrade);
	mprSetCFunction(obj, "dssetup_DsRoleUpgradeDownlevelServer", ejs_dssetup_DsRoleUpgradeDownlevelServer);
	mprSetCFunction(obj, "dssetup_DsRoleAbortDownlevelServerUpgrade", ejs_dssetup_DsRoleAbortDownlevelServerUpgrade);
	mprSetVar(obj, "DS_ROLE_PRIMARY_DS_MIXED_MODE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "DS_ROLE_PREVIOUS_UNKNOWN", mprCreateNumberVar(0));
	mprSetVar(obj, "DS_ROLE_MEMBER_SERVER", mprCreateNumberVar(3));
	mprSetVar(obj, "DS_ROLE_UPGRADING", mprCreateNumberVar(1));
	mprSetVar(obj, "DS_ROLE_PRIMARY_DOMAIN_GUID_PRESENT", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "DS_ROLE_PREVIOUS_PRIMARY", mprCreateNumberVar(1));
	mprSetVar(obj, "DS_ROLE_UPGRADE_IN_PROGRESS", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "DS_ROLE_BASIC_INFORMATION", mprCreateNumberVar(1));
	mprSetVar(obj, "DS_ROLE_PRIMARY_DS_RUNNING", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DS_ROLE_NOT_UPGRADING", mprCreateNumberVar(0));
	mprSetVar(obj, "DS_ROLE_STANDALONE_WORKSTATION", mprCreateNumberVar(0));
	mprSetVar(obj, "DS_ROLE_PRIMARY_DC", mprCreateNumberVar(5));
	mprSetVar(obj, "DS_ROLE_UPGRADE_STATUS", mprCreateNumberVar(2));
	mprSetVar(obj, "DS_ROLE_STANDALONE_SERVER", mprCreateNumberVar(2));
	mprSetVar(obj, "DS_ROLE_OP_STATUS", mprCreateNumberVar(3));
	mprSetVar(obj, "DS_ROLE_OP_NEEDS_REBOOT", mprCreateNumberVar(2));
	mprSetVar(obj, "DS_ROLE_OP_IDLE", mprCreateNumberVar(0));
	mprSetVar(obj, "DS_ROLE_BACKUP_DC", mprCreateNumberVar(4));
	mprSetVar(obj, "DS_ROLE_MEMBER_WORKSTATION", mprCreateNumberVar(1));
	mprSetVar(obj, "DS_ROLE_PREVIOUS_BACKUP", mprCreateNumberVar(2));
	mprSetVar(obj, "DS_ROLE_OP_ACTIVE", mprCreateNumberVar(1));
	return ejs_rpc_init(obj, "dssetup");
}

NTSTATUS ejs_init_dssetup(void)
{
	ejsDefineCFunction(-1, "dssetup_init", ejs_dssetup_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
