
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_eventlog.h"
#include "librpc/gen_ndr/ndr_eventlog_ejs.h"


static NTSTATUS ejs_pull_eventlog_OpenUnknown0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct eventlog_OpenUnknown0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown0", &r->unknown0));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown1", &r->unknown1));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_eventlog_Record(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct eventlog_Record *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_uint32(ejs, v, "record_number", &r->record_number));
	NDR_CHECK(ejs_push_uint32(ejs, v, "time_generated", &r->time_generated));
	NDR_CHECK(ejs_push_uint32(ejs, v, "time_written", &r->time_written));
	NDR_CHECK(ejs_push_uint32(ejs, v, "event_id", &r->event_id));
	NDR_CHECK(ejs_push_uint16(ejs, v, "event_type", &r->event_type));
	NDR_CHECK(ejs_push_uint16(ejs, v, "num_of_strings", &r->num_of_strings));
	NDR_CHECK(ejs_push_uint16(ejs, v, "event_category", &r->event_category));
	NDR_CHECK(ejs_push_uint16(ejs, v, "reserved_flags", &r->reserved_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "closing_record_number", &r->closing_record_number));
	NDR_CHECK(ejs_push_uint32(ejs, v, "stringoffset", &r->stringoffset));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_length", &r->sid_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_offset", &r->sid_offset));
	NDR_CHECK(ejs_push_uint32(ejs, v, "data_length", &r->data_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "data_offset", &r->data_offset));
	NDR_CHECK(ejs_push_string(ejs, v, "source_name", r->source_name));
	NDR_CHECK(ejs_push_string(ejs, v, "computer_name", r->computer_name));
	{
		uint32_t i;
		for (i=0;i<r->num_of_strings;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "strings", i);
			NDR_CHECK(ejs_push_string(ejs, v, id, r->strings[i]));
		}
		ejs_push_uint32(ejs, v, "strings" ".length", &i);
	}
	NDR_CHECK(ejs_push_string(ejs, v, "raw_data", r->raw_data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_eventlog_Record(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct eventlog_Record *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "record_number", &r->record_number));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time_generated", &r->time_generated));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time_written", &r->time_written));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "event_id", &r->event_id));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "event_type", &r->event_type));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "num_of_strings", &r->num_of_strings));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "event_category", &r->event_category));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reserved_flags", &r->reserved_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "closing_record_number", &r->closing_record_number));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "stringoffset", &r->stringoffset));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_length", &r->sid_length));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_offset", &r->sid_offset));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "data_length", &r->data_length));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "data_offset", &r->data_offset));
	NDR_CHECK(ejs_pull_string(ejs, v, "source_name", &r->source_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->computer_name));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->strings, r->num_of_strings);
		for (i=0;i<r->num_of_strings;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "strings", i);
			NDR_CHECK(ejs_pull_string(ejs, v, id, &r->strings[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "strings" ".length", &i);
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "raw_data", &r->raw_data));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_eventlog_ClearEventLogW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ClearEventLogW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "unknown")) {
		r->in.unknown = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.unknown);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown", r->in.unknown));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ClearEventLogW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ClearEventLogW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ClearEventLogW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_CLEAREVENTLOGW, (ejs_pull_function_t)ejs_pull_eventlog_ClearEventLogW, (ejs_push_function_t)ejs_push_eventlog_ClearEventLogW);
}


static NTSTATUS ejs_pull_eventlog_BackupEventLogW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_BackupEventLogW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_BackupEventLogW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_BackupEventLogW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_BackupEventLogW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_BACKUPEVENTLOGW, (ejs_pull_function_t)ejs_pull_eventlog_BackupEventLogW, (ejs_push_function_t)ejs_push_eventlog_BackupEventLogW);
}


static NTSTATUS ejs_pull_eventlog_CloseEventLog(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_CloseEventLog *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_CloseEventLog(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_CloseEventLog *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_CloseEventLog(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_CLOSEEVENTLOG, (ejs_pull_function_t)ejs_pull_eventlog_CloseEventLog, (ejs_push_function_t)ejs_push_eventlog_CloseEventLog);
}


static NTSTATUS ejs_pull_eventlog_DeregisterEventSource(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_DeregisterEventSource *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_DeregisterEventSource(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_DeregisterEventSource *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_DeregisterEventSource(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_DEREGISTEREVENTSOURCE, (ejs_pull_function_t)ejs_pull_eventlog_DeregisterEventSource, (ejs_push_function_t)ejs_push_eventlog_DeregisterEventSource);
}


static NTSTATUS ejs_pull_eventlog_GetNumRecords(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_GetNumRecords *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_GetNumRecords(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_GetNumRecords *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.number) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "number", r->out.number));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_GetNumRecords(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_GETNUMRECORDS, (ejs_pull_function_t)ejs_pull_eventlog_GetNumRecords, (ejs_push_function_t)ejs_push_eventlog_GetNumRecords);
}


static NTSTATUS ejs_pull_eventlog_GetOldestRecord(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_GetOldestRecord *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_GetOldestRecord(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_GetOldestRecord *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_GetOldestRecord(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_GETOLDESTRECORD, (ejs_pull_function_t)ejs_pull_eventlog_GetOldestRecord, (ejs_push_function_t)ejs_push_eventlog_GetOldestRecord);
}


static NTSTATUS ejs_pull_eventlog_ChangeNotify(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ChangeNotify *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ChangeNotify(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ChangeNotify *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ChangeNotify(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_CHANGENOTIFY, (ejs_pull_function_t)ejs_pull_eventlog_ChangeNotify, (ejs_push_function_t)ejs_push_eventlog_ChangeNotify);
}


static NTSTATUS ejs_pull_eventlog_OpenEventLogW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_OpenEventLogW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "unknown0")) {
		r->in.unknown0 = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.unknown0);
		NDR_CHECK(ejs_pull_eventlog_OpenUnknown0(ejs, v, "unknown0", r->in.unknown0));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logname", &r->in.logname));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "servername", &r->in.servername));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown3", &r->in.unknown3));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_OpenEventLogW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_OpenEventLogW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_OpenEventLogW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_OPENEVENTLOGW, (ejs_pull_function_t)ejs_pull_eventlog_OpenEventLogW, (ejs_push_function_t)ejs_push_eventlog_OpenEventLogW);
}


static NTSTATUS ejs_pull_eventlog_RegisterEventSourceW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_RegisterEventSourceW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_RegisterEventSourceW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_RegisterEventSourceW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_RegisterEventSourceW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_REGISTEREVENTSOURCEW, (ejs_pull_function_t)ejs_pull_eventlog_RegisterEventSourceW, (ejs_push_function_t)ejs_push_eventlog_RegisterEventSourceW);
}


static NTSTATUS ejs_pull_eventlog_OpenBackupEventLogW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_OpenBackupEventLogW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_OpenBackupEventLogW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_OpenBackupEventLogW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_OpenBackupEventLogW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_OPENBACKUPEVENTLOGW, (ejs_pull_function_t)ejs_pull_eventlog_OpenBackupEventLogW, (ejs_push_function_t)ejs_push_eventlog_OpenBackupEventLogW);
}


static NTSTATUS ejs_pull_eventlog_ReadEventLogW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ReadEventLogW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "offset", &r->in.offset));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "number_of_bytes", &r->in.number_of_bytes));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ReadEventLogW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ReadEventLogW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->out.data, r->in.number_of_bytes);
	}
	if (NULL == r->out.sent_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "sent_size", r->out.sent_size));
	}
	if (NULL == r->out.real_size) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "real_size", r->out.real_size));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ReadEventLogW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_READEVENTLOGW, (ejs_pull_function_t)ejs_pull_eventlog_ReadEventLogW, (ejs_push_function_t)ejs_push_eventlog_ReadEventLogW);
}


static NTSTATUS ejs_pull_eventlog_ReportEventW(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ReportEventW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ReportEventW(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ReportEventW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ReportEventW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_REPORTEVENTW, (ejs_pull_function_t)ejs_pull_eventlog_ReportEventW, (ejs_push_function_t)ejs_push_eventlog_ReportEventW);
}


static NTSTATUS ejs_pull_eventlog_ClearEventLogA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ClearEventLogA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ClearEventLogA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ClearEventLogA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ClearEventLogA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_CLEAREVENTLOGA, (ejs_pull_function_t)ejs_pull_eventlog_ClearEventLogA, (ejs_push_function_t)ejs_push_eventlog_ClearEventLogA);
}


static NTSTATUS ejs_pull_eventlog_BackupEventLogA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_BackupEventLogA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_BackupEventLogA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_BackupEventLogA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_BackupEventLogA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_BACKUPEVENTLOGA, (ejs_pull_function_t)ejs_pull_eventlog_BackupEventLogA, (ejs_push_function_t)ejs_push_eventlog_BackupEventLogA);
}


static NTSTATUS ejs_pull_eventlog_OpenEventLogA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_OpenEventLogA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_OpenEventLogA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_OpenEventLogA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_OpenEventLogA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_OPENEVENTLOGA, (ejs_pull_function_t)ejs_pull_eventlog_OpenEventLogA, (ejs_push_function_t)ejs_push_eventlog_OpenEventLogA);
}


static NTSTATUS ejs_pull_eventlog_RegisterEventSourceA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_RegisterEventSourceA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_RegisterEventSourceA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_RegisterEventSourceA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_RegisterEventSourceA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_REGISTEREVENTSOURCEA, (ejs_pull_function_t)ejs_pull_eventlog_RegisterEventSourceA, (ejs_push_function_t)ejs_push_eventlog_RegisterEventSourceA);
}


static NTSTATUS ejs_pull_eventlog_OpenBackupEventLogA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_OpenBackupEventLogA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_OpenBackupEventLogA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_OpenBackupEventLogA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_OpenBackupEventLogA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_OPENBACKUPEVENTLOGA, (ejs_pull_function_t)ejs_pull_eventlog_OpenBackupEventLogA, (ejs_push_function_t)ejs_push_eventlog_OpenBackupEventLogA);
}


static NTSTATUS ejs_pull_eventlog_ReadEventLogA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ReadEventLogA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ReadEventLogA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ReadEventLogA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ReadEventLogA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_READEVENTLOGA, (ejs_pull_function_t)ejs_pull_eventlog_ReadEventLogA, (ejs_push_function_t)ejs_push_eventlog_ReadEventLogA);
}


static NTSTATUS ejs_pull_eventlog_ReportEventA(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_ReportEventA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_ReportEventA(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_ReportEventA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_ReportEventA(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_REPORTEVENTA, (ejs_pull_function_t)ejs_pull_eventlog_ReportEventA, (ejs_push_function_t)ejs_push_eventlog_ReportEventA);
}


static NTSTATUS ejs_pull_eventlog_RegisterClusterSvc(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_RegisterClusterSvc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_RegisterClusterSvc(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_RegisterClusterSvc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_RegisterClusterSvc(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_REGISTERCLUSTERSVC, (ejs_pull_function_t)ejs_pull_eventlog_RegisterClusterSvc, (ejs_push_function_t)ejs_push_eventlog_RegisterClusterSvc);
}


static NTSTATUS ejs_pull_eventlog_DeregisterClusterSvc(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_DeregisterClusterSvc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_DeregisterClusterSvc(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_DeregisterClusterSvc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_DeregisterClusterSvc(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_DEREGISTERCLUSTERSVC, (ejs_pull_function_t)ejs_pull_eventlog_DeregisterClusterSvc, (ejs_push_function_t)ejs_push_eventlog_DeregisterClusterSvc);
}


static NTSTATUS ejs_pull_eventlog_WriteClusterEvents(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_WriteClusterEvents *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_WriteClusterEvents(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_WriteClusterEvents *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_WriteClusterEvents(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_WRITECLUSTEREVENTS, (ejs_pull_function_t)ejs_pull_eventlog_WriteClusterEvents, (ejs_push_function_t)ejs_push_eventlog_WriteClusterEvents);
}


static NTSTATUS ejs_pull_eventlog_GetLogIntormation(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_GetLogIntormation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_GetLogIntormation(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_GetLogIntormation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_GetLogIntormation(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_GETLOGINTORMATION, (ejs_pull_function_t)ejs_pull_eventlog_GetLogIntormation, (ejs_push_function_t)ejs_push_eventlog_GetLogIntormation);
}


static NTSTATUS ejs_pull_eventlog_FlushEventLog(struct ejs_rpc *ejs, struct MprVar *v, struct eventlog_FlushEventLog *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_eventlog_FlushEventLog(struct ejs_rpc *ejs, struct MprVar *v, const struct eventlog_FlushEventLog *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_eventlog_FlushEventLog(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_eventlog, DCERPC_EVENTLOG_FLUSHEVENTLOG, (ejs_pull_function_t)ejs_pull_eventlog_FlushEventLog, (ejs_push_function_t)ejs_push_eventlog_FlushEventLog);
}

static int ejs_eventlog_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "eventlog", argc, argv);
	mprSetCFunction(obj, "eventlog_ClearEventLogW", ejs_eventlog_ClearEventLogW);
	mprSetCFunction(obj, "eventlog_BackupEventLogW", ejs_eventlog_BackupEventLogW);
	mprSetCFunction(obj, "eventlog_CloseEventLog", ejs_eventlog_CloseEventLog);
	mprSetCFunction(obj, "eventlog_DeregisterEventSource", ejs_eventlog_DeregisterEventSource);
	mprSetCFunction(obj, "eventlog_GetNumRecords", ejs_eventlog_GetNumRecords);
	mprSetCFunction(obj, "eventlog_GetOldestRecord", ejs_eventlog_GetOldestRecord);
	mprSetCFunction(obj, "eventlog_ChangeNotify", ejs_eventlog_ChangeNotify);
	mprSetCFunction(obj, "eventlog_OpenEventLogW", ejs_eventlog_OpenEventLogW);
	mprSetCFunction(obj, "eventlog_RegisterEventSourceW", ejs_eventlog_RegisterEventSourceW);
	mprSetCFunction(obj, "eventlog_OpenBackupEventLogW", ejs_eventlog_OpenBackupEventLogW);
	mprSetCFunction(obj, "eventlog_ReadEventLogW", ejs_eventlog_ReadEventLogW);
	mprSetCFunction(obj, "eventlog_ReportEventW", ejs_eventlog_ReportEventW);
	mprSetCFunction(obj, "eventlog_ClearEventLogA", ejs_eventlog_ClearEventLogA);
	mprSetCFunction(obj, "eventlog_BackupEventLogA", ejs_eventlog_BackupEventLogA);
	mprSetCFunction(obj, "eventlog_OpenEventLogA", ejs_eventlog_OpenEventLogA);
	mprSetCFunction(obj, "eventlog_RegisterEventSourceA", ejs_eventlog_RegisterEventSourceA);
	mprSetCFunction(obj, "eventlog_OpenBackupEventLogA", ejs_eventlog_OpenBackupEventLogA);
	mprSetCFunction(obj, "eventlog_ReadEventLogA", ejs_eventlog_ReadEventLogA);
	mprSetCFunction(obj, "eventlog_ReportEventA", ejs_eventlog_ReportEventA);
	mprSetCFunction(obj, "eventlog_RegisterClusterSvc", ejs_eventlog_RegisterClusterSvc);
	mprSetCFunction(obj, "eventlog_DeregisterClusterSvc", ejs_eventlog_DeregisterClusterSvc);
	mprSetCFunction(obj, "eventlog_WriteClusterEvents", ejs_eventlog_WriteClusterEvents);
	mprSetCFunction(obj, "eventlog_GetLogIntormation", ejs_eventlog_GetLogIntormation);
	mprSetCFunction(obj, "eventlog_FlushEventLog", ejs_eventlog_FlushEventLog);
	return ejs_rpc_init(obj, "eventlog");
}

NTSTATUS ejs_init_eventlog(void)
{
	ejsDefineCFunction(-1, "eventlog_init", ejs_eventlog_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
