
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_irpc.h"
#include "librpc/gen_ndr/ndr_irpc_ejs.h"


static NTSTATUS ejs_pull_nbtd_info_level(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbtd_info_level *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbtd_statistics(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbtd_statistics *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "total_received", &r->total_received));
	NDR_CHECK(ejs_push_hyper(ejs, v, "total_sent", &r->total_sent));
	NDR_CHECK(ejs_push_hyper(ejs, v, "query_count", &r->query_count));
	NDR_CHECK(ejs_push_hyper(ejs, v, "register_count", &r->register_count));
	NDR_CHECK(ejs_push_hyper(ejs, v, "release_count", &r->release_count));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbtd_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbtd_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NBTD_INFO_STATISTICS:
			if (NULL == r->stats) {
				NDR_CHECK(ejs_push_null(ejs, v, "stats"));
			} else {
				NDR_CHECK(ejs_push_nbtd_statistics(ejs, v, "stats", r->stats));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_smbsrv_info_level(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum smbsrv_info_level *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smbsrv_session_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct smbsrv_session_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "vuid", &r->vuid));
	NDR_CHECK(ejs_push_string(ejs, v, "account_name", r->account_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	NDR_CHECK(ejs_push_string(ejs, v, "client_ip", r->client_ip));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "connect_time", &r->connect_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "auth_time", &r->auth_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_use_time", &r->last_use_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smbsrv_sessions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct smbsrv_sessions *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_sessions", &r->num_sessions));
	if (NULL == r->sessions) {
		NDR_CHECK(ejs_push_null(ejs, v, "sessions"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_sessions;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sessions", i);
				NDR_CHECK(ejs_push_smbsrv_session_info(ejs, v, id, &r->sessions[i]));
			}
			ejs_push_uint32(ejs, v, "sessions" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smbsrv_tcon_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct smbsrv_tcon_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tid", &r->tid));
	NDR_CHECK(ejs_push_string(ejs, v, "share_name", r->share_name));
	NDR_CHECK(ejs_push_string(ejs, v, "client_ip", r->client_ip));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "connect_time", &r->connect_time));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_use_time", &r->last_use_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smbsrv_tcons(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct smbsrv_tcons *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_tcons", &r->num_tcons));
	if (NULL == r->tcons) {
		NDR_CHECK(ejs_push_null(ejs, v, "tcons"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_tcons;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "tcons", i);
				NDR_CHECK(ejs_push_smbsrv_tcon_info(ejs, v, id, &r->tcons[i]));
			}
			ejs_push_uint32(ejs, v, "tcons" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smbsrv_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union smbsrv_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SMBSRV_INFO_SESSIONS:
			NDR_CHECK(ejs_push_smbsrv_sessions(ejs, v, "sessions", &r->sessions));
			break;
		case SMBSRV_INFO_TCONS:
			NDR_CHECK(ejs_push_smbsrv_tcons(ejs, v, "tcons", &r->tcons));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_irpc_uptime(struct ejs_rpc *ejs, struct MprVar *v, struct irpc_uptime *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_irpc_uptime(struct ejs_rpc *ejs, struct MprVar *v, const struct irpc_uptime *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.start_time) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_NTTIME(ejs, v, "start_time", r->out.start_time));
	}
	return NT_STATUS_OK;
}

static int ejs_irpc_uptime(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_irpc, DCERPC_IRPC_UPTIME, (ejs_pull_function_t)ejs_pull_irpc_uptime, (ejs_push_function_t)ejs_push_irpc_uptime);
}


static NTSTATUS ejs_pull_nbtd_information(struct ejs_rpc *ejs, struct MprVar *v, struct nbtd_information *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_nbtd_info_level(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_nbtd_information(struct ejs_rpc *ejs, struct MprVar *v, const struct nbtd_information *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_nbtd_info(ejs, v, "info", &r->out.info));
	return NT_STATUS_OK;
}

static int ejs_nbtd_information(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_irpc, DCERPC_NBTD_INFORMATION, (ejs_pull_function_t)ejs_pull_nbtd_information, (ejs_push_function_t)ejs_push_nbtd_information);
}


static NTSTATUS ejs_pull_nbtd_getdcname(struct ejs_rpc *ejs, struct MprVar *v, struct nbtd_getdcname *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "domainname", &r->in.domainname));
	NDR_CHECK(ejs_pull_string(ejs, v, "ip_address", &r->in.ip_address));
	NDR_CHECK(ejs_pull_string(ejs, v, "my_computername", &r->in.my_computername));
	NDR_CHECK(ejs_pull_string(ejs, v, "my_accountname", &r->in.my_accountname));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "account_control", &r->in.account_control));
	if (ejs_pull_null(ejs, v, "domain_sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_sid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "domain_sid", r->in.domain_sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_nbtd_getdcname(struct ejs_rpc *ejs, struct MprVar *v, const struct nbtd_getdcname *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.dcname) {
		NDR_CHECK(ejs_push_null(ejs, v, "dcname"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dcname", r->out.dcname));
	}
	return NT_STATUS_OK;
}

static int ejs_nbtd_getdcname(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_irpc, DCERPC_NBTD_GETDCNAME, (ejs_pull_function_t)ejs_pull_nbtd_getdcname, (ejs_push_function_t)ejs_push_nbtd_getdcname);
}


static NTSTATUS ejs_pull_smbsrv_information(struct ejs_rpc *ejs, struct MprVar *v, struct smbsrv_information *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_smbsrv_info_level(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_smbsrv_information(struct ejs_rpc *ejs, struct MprVar *v, const struct smbsrv_information *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_smbsrv_info(ejs, v, "info", &r->out.info));
	return NT_STATUS_OK;
}

static int ejs_smbsrv_information(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_irpc, DCERPC_SMBSRV_INFORMATION, (ejs_pull_function_t)ejs_pull_smbsrv_information, (ejs_push_function_t)ejs_push_smbsrv_information);
}

static int ejs_irpc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "irpc", argc, argv);
	mprSetCFunction(obj, "irpc_uptime", ejs_irpc_uptime);
	mprSetCFunction(obj, "nbtd_information", ejs_nbtd_information);
	mprSetCFunction(obj, "nbtd_getdcname", ejs_nbtd_getdcname);
	mprSetCFunction(obj, "smbsrv_information", ejs_smbsrv_information);
	mprSetVar(obj, "SMBSRV_INFO_SESSIONS", mprCreateNumberVar(0));
	mprSetVar(obj, "NBTD_INFO_STATISTICS", mprCreateNumberVar(0));
	mprSetVar(obj, "SMBSRV_INFO_TCONS", mprCreateNumberVar(1));
	return ejs_rpc_init(obj, "irpc");
}

NTSTATUS ejs_init_irpc(void)
{
	ejsDefineCFunction(-1, "irpc_init", ejs_irpc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
