
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_krb5pac.h"
#include "librpc/gen_ndr/ndr_krb5pac_ejs.h"


static NTSTATUS ejs_push_PAC_LOGON_NAME(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_LOGON_NAME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "logon_time", &r->logon_time));
	NDR_CHECK(ejs_push_string(ejs, v, "account_name", r->account_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_PAC_LOGON_NAME(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_LOGON_NAME *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "logon_time", &r->logon_time));
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->account_name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_SIGNATURE_DATA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_SIGNATURE_DATA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "signature", &r->signature));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_SIGNATURE_DATA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_SIGNATURE_DATA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "signature", &r->signature));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_PAC_LOGON_INFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_LOGON_INFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_SamInfo3(ejs, v, "info3", &r->info3));
	if (NULL == r->res_group_dom_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "res_group_dom_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "res_group_dom_sid", r->res_group_dom_sid));
	}
	NDR_CHECK(ejs_push_samr_RidWithAttributeArray(ejs, v, "res_groups", &r->res_groups));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_PAC_LOGON_INFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_LOGON_INFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_SamInfo3(ejs, v, "info3", &r->info3));
	if (ejs_pull_null(ejs, v, "res_group_dom_sid")) {
		r->res_group_dom_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->res_group_dom_sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "res_group_dom_sid", r->res_group_dom_sid));
	}
	NDR_CHECK(ejs_pull_samr_RidWithAttributeArray(ejs, v, "res_groups", &r->res_groups));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_LOGON_INFO_CTR(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_LOGON_INFO_CTR *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_ndr_size", &r->_ndr_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	if (NULL == r->info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_PAC_LOGON_INFO(ejs, v, "info", r->info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_LOGON_INFO_CTR(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_LOGON_INFO_CTR *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "info")) {
		r->info = NULL;
	} else {
		EJS_ALLOC(ejs, r->info);
		NDR_CHECK(ejs_pull_PAC_LOGON_INFO(ejs, v, "info", r->info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_TYPE(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum PAC_TYPE *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_TYPE(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum PAC_TYPE *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_INFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union PAC_INFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case PAC_TYPE_LOGON_INFO:
			NDR_CHECK(ejs_push_PAC_LOGON_INFO_CTR(ejs, v, "logon_info", &r->logon_info));
			break;
		case PAC_TYPE_SRV_CHECKSUM:
			NDR_CHECK(ejs_push_PAC_SIGNATURE_DATA(ejs, v, "srv_cksum", &r->srv_cksum));
			break;
		case PAC_TYPE_KDC_CHECKSUM:
			NDR_CHECK(ejs_push_PAC_SIGNATURE_DATA(ejs, v, "kdc_cksum", &r->kdc_cksum));
			break;
		case PAC_TYPE_LOGON_NAME:
			NDR_CHECK(ejs_push_PAC_LOGON_NAME(ejs, v, "logon_name", &r->logon_name));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_PAC_INFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union PAC_INFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case PAC_TYPE_LOGON_INFO:
			NDR_CHECK(ejs_pull_PAC_LOGON_INFO_CTR(ejs, v, "logon_info", &r->logon_info));
			break;
		case PAC_TYPE_SRV_CHECKSUM:
			NDR_CHECK(ejs_pull_PAC_SIGNATURE_DATA(ejs, v, "srv_cksum", &r->srv_cksum));
			break;
		case PAC_TYPE_KDC_CHECKSUM:
			NDR_CHECK(ejs_pull_PAC_SIGNATURE_DATA(ejs, v, "kdc_cksum", &r->kdc_cksum));
			break;
		case PAC_TYPE_LOGON_NAME:
			NDR_CHECK(ejs_pull_PAC_LOGON_NAME(ejs, v, "logon_name", &r->logon_name));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_PAC_BUFFER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_BUFFER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_PAC_TYPE(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_ndr_size", &r->_ndr_size));
	if (NULL == r->info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_BUFFER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_BUFFER *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_PAC_TYPE(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "info")) {
		r->info = NULL;
	} else {
		EJS_ALLOC(ejs, r->info);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_DATA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_DATA *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_buffers", &r->num_buffers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	{
		uint32_t i;
		for (i=0;i<r->num_buffers;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "buffers", i);
			NDR_CHECK(ejs_push_PAC_BUFFER(ejs, v, id, &r->buffers[i]));
		}
		ejs_push_uint32(ejs, v, "buffers" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_DATA(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_DATA *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_buffers", &r->num_buffers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->buffers, r->num_buffers);
		for (i=0;i<r->num_buffers;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "buffers", i);
			NDR_CHECK(ejs_pull_PAC_BUFFER(ejs, v, id, &r->buffers[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "buffers" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_DATA_BLOB_REM(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct DATA_BLOB_REM *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "remaining", &r->remaining));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_DATA_BLOB_REM(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct DATA_BLOB_REM *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "remaining", &r->remaining));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_BUFFER_RAW(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_BUFFER_RAW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_PAC_TYPE(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ndr_size", &r->ndr_size));
	if (NULL == r->info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_BUFFER_RAW(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_BUFFER_RAW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_PAC_TYPE(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ndr_size", &r->ndr_size));
	if (ejs_pull_null(ejs, v, "info")) {
		r->info = NULL;
	} else {
		EJS_ALLOC(ejs, r->info);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_PAC_DATA_RAW(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct PAC_DATA_RAW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_buffers", &r->num_buffers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	{
		uint32_t i;
		for (i=0;i<r->num_buffers;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "buffers", i);
			NDR_CHECK(ejs_push_PAC_BUFFER_RAW(ejs, v, id, &r->buffers[i]));
		}
		ejs_push_uint32(ejs, v, "buffers" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_PAC_DATA_RAW(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct PAC_DATA_RAW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_buffers", &r->num_buffers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->buffers, r->num_buffers);
		for (i=0;i<r->num_buffers;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "buffers", i);
			NDR_CHECK(ejs_pull_PAC_BUFFER_RAW(ejs, v, id, &r->buffers[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "buffers" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_decode_pac(struct ejs_rpc *ejs, struct MprVar *v, struct decode_pac *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_PAC_DATA(ejs, v, "pac", &r->in.pac));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_pac(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_pac *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_pac(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_krb5pac, DCERPC_DECODE_PAC, (ejs_pull_function_t)ejs_pull_decode_pac, (ejs_push_function_t)ejs_push_decode_pac);
}


static NTSTATUS ejs_pull_decode_pac_raw(struct ejs_rpc *ejs, struct MprVar *v, struct decode_pac_raw *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_PAC_DATA_RAW(ejs, v, "pac", &r->in.pac));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_pac_raw(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_pac_raw *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_pac_raw(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_krb5pac, DCERPC_DECODE_PAC_RAW, (ejs_pull_function_t)ejs_pull_decode_pac_raw, (ejs_push_function_t)ejs_push_decode_pac_raw);
}


static NTSTATUS ejs_pull_decode_login_info(struct ejs_rpc *ejs, struct MprVar *v, struct decode_login_info *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_PAC_LOGON_INFO(ejs, v, "logon_info", &r->in.logon_info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_login_info(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_login_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_login_info(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_krb5pac, DCERPC_DECODE_LOGIN_INFO, (ejs_pull_function_t)ejs_pull_decode_login_info, (ejs_push_function_t)ejs_push_decode_login_info);
}

static int ejs_krb5pac_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "krb5pac", argc, argv);
	mprSetCFunction(obj, "decode_pac", ejs_decode_pac);
	mprSetCFunction(obj, "decode_pac_raw", ejs_decode_pac_raw);
	mprSetCFunction(obj, "decode_login_info", ejs_decode_login_info);
	mprSetVar(obj, "PAC_TYPE_LOGON_NAME", mprCreateNumberVar(10));
	mprSetVar(obj, "PAC_TYPE_SRV_CHECKSUM", mprCreateNumberVar(6));
	mprSetVar(obj, "PAC_TYPE_LOGON_INFO", mprCreateNumberVar(1));
	mprSetVar(obj, "PAC_TYPE_KDC_CHECKSUM", mprCreateNumberVar(7));
	return ejs_rpc_init(obj, "krb5pac");
}

NTSTATUS ejs_init_krb5pac(void)
{
	ejsDefineCFunction(-1, "krb5pac_init", ejs_krb5pac_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
