/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_lsa.h"

#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ NTSTATUS ndr_push_lsa_String(struct ndr_push *ndr, int ndr_flags, const struct lsa_String *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, 2 * strlen_m(r->string) / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_lsa_String(struct ndr_pull *ndr, int ndr_flags, struct lsa_String *r)
{
	uint32_t _ptr_string;
	TALLOC_CTX *_mem_save_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			if (ndr_get_array_length(ndr, &r->string) > ndr_get_array_size(ndr, &r->string)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->string), ndr_get_array_length(ndr, &r->string));
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, ndr_get_array_length(ndr, &r->string), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->string, r->size / 2));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->string, r->length / 2));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_String(struct ndr_print *ndr, const char *name, const struct lsa_String *r)
{
	ndr_print_struct(ndr, name, "lsa_String");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_lsa_StringLarge(struct ndr_push *ndr, int ndr_flags, const struct lsa_StringLarge *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * (strlen_m(r->string) + 1)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * (strlen_m(r->string) + 1) / 2));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m(r->string) / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, 2 * strlen_m(r->string) / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_lsa_StringLarge(struct ndr_pull *ndr, int ndr_flags, struct lsa_StringLarge *r)
{
	uint32_t _ptr_string;
	TALLOC_CTX *_mem_save_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			if (ndr_get_array_length(ndr, &r->string) > ndr_get_array_size(ndr, &r->string)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->string), ndr_get_array_length(ndr, &r->string));
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, ndr_get_array_length(ndr, &r->string), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->string, r->size / 2));
		}
		if (r->string) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->string, r->length / 2));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_StringLarge(struct ndr_print *ndr, const char *name, const struct lsa_StringLarge *r)
{
	ndr_print_struct(ndr, name, "lsa_StringLarge");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * (strlen_m(r->string) + 1):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_lsa_Strings(struct ndr_push *ndr, int ndr_flags, const struct lsa_Strings *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_lsa_Strings(struct ndr_pull *ndr, int ndr_flags, struct lsa_Strings *r)
{
	uint32_t _ptr_names;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_PULL_ALLOC_N(ndr, r->names, ndr_get_array_size(ndr, &r->names));
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_Strings(struct ndr_print *ndr, const char *name, const struct lsa_Strings *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_Strings");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_names_1);
			if (idx_1) {
				ndr_print_lsa_String(ndr, "names", &r->names[cntr_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_lsa_AsciiString(struct ndr_push *ndr, int ndr_flags, const struct lsa_AsciiString *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m(r->string)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m(r->string)));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_LEN4);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_LEN4);
			if (r->string) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_lsa_AsciiString(struct ndr_pull *ndr, int ndr_flags, struct lsa_AsciiString *r)
{
	uint32_t _ptr_string;
	TALLOC_CTX *_mem_save_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_LEN4);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
			if (_ptr_string) {
				NDR_PULL_ALLOC(ndr, r->string);
			} else {
				r->string = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_LEN4);
			if (r->string) {
				_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AsciiString(struct ndr_print *ndr, const char *name, const struct lsa_AsciiString *r)
{
	ndr_print_struct(ndr, name, "lsa_AsciiString");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->string):r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->string):r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LUID(struct ndr_push *ndr, int ndr_flags, const struct lsa_LUID *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->low));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->high));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LUID(struct ndr_pull *ndr, int ndr_flags, struct lsa_LUID *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->low));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->high));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LUID(struct ndr_print *ndr, const char *name, const struct lsa_LUID *r)
{
	ndr_print_struct(ndr, name, "lsa_LUID");
	ndr->depth++;
	ndr_print_uint32(ndr, "low", r->low);
	ndr_print_uint32(ndr, "high", r->high);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_PrivEntry(struct ndr_push *ndr, int ndr_flags, const struct lsa_PrivEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_PrivEntry(struct ndr_pull *ndr, int ndr_flags, struct lsa_PrivEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_PrivEntry(struct ndr_print *ndr, const char *name, const struct lsa_PrivEntry *r)
{
	ndr_print_struct(ndr, name, "lsa_PrivEntry");
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_lsa_LUID(ndr, "luid", &r->luid);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_PrivArray(struct ndr_push *ndr, int ndr_flags, const struct lsa_PrivArray *r)
{
	uint32_t cntr_privs_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->privs));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privs) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_privs_1 = 0; cntr_privs_1 < r->count; cntr_privs_1++) {
				NDR_CHECK(ndr_push_lsa_PrivEntry(ndr, NDR_SCALARS, &r->privs[cntr_privs_1]));
			}
			for (cntr_privs_1 = 0; cntr_privs_1 < r->count; cntr_privs_1++) {
				NDR_CHECK(ndr_push_lsa_PrivEntry(ndr, NDR_BUFFERS, &r->privs[cntr_privs_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_PrivArray(struct ndr_pull *ndr, int ndr_flags, struct lsa_PrivArray *r)
{
	uint32_t _ptr_privs;
	uint32_t cntr_privs_1;
	TALLOC_CTX *_mem_save_privs_0;
	TALLOC_CTX *_mem_save_privs_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, r->privs);
		} else {
			r->privs = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privs) {
			_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->privs));
			NDR_PULL_ALLOC_N(ndr, r->privs, ndr_get_array_size(ndr, &r->privs));
			_mem_save_privs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privs, 0);
			for (cntr_privs_1 = 0; cntr_privs_1 < r->count; cntr_privs_1++) {
				NDR_CHECK(ndr_pull_lsa_PrivEntry(ndr, NDR_SCALARS, &r->privs[cntr_privs_1]));
			}
			for (cntr_privs_1 = 0; cntr_privs_1 < r->count; cntr_privs_1++) {
				NDR_CHECK(ndr_pull_lsa_PrivEntry(ndr, NDR_BUFFERS, &r->privs[cntr_privs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, 0);
		}
		if (r->privs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->privs, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_PrivArray(struct ndr_print *ndr, const char *name, const struct lsa_PrivArray *r)
{
	uint32_t cntr_privs_1;
	ndr_print_struct(ndr, name, "lsa_PrivArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "privs", r->privs);
	ndr->depth++;
	if (r->privs) {
		ndr->print(ndr, "%s: ARRAY(%d)", "privs", r->count);
		ndr->depth++;
		for (cntr_privs_1=0;cntr_privs_1<r->count;cntr_privs_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_privs_1);
			if (idx_1) {
				ndr_print_lsa_PrivEntry(ndr, "privs", &r->privs[cntr_privs_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QosInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_QosInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->impersonation_level));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->context_mode));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->effective_only));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QosInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_QosInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->impersonation_level));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->context_mode));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->effective_only));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QosInfo(struct ndr_print *ndr, const char *name, const struct lsa_QosInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_QosInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "len", r->len);
	ndr_print_uint16(ndr, "impersonation_level", r->impersonation_level);
	ndr_print_uint8(ndr, "context_mode", r->context_mode);
	ndr_print_uint8(ndr, "effective_only", r->effective_only);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ObjectAttribute(struct ndr_push *ndr, int ndr_flags, const struct lsa_ObjectAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->root_dir));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sec_desc));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sec_qos));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->root_dir) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->root_dir));
		}
		if (r->object_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_name, ndr_charset_length(r->object_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->sec_desc) {
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sec_desc));
		}
		if (r->sec_qos) {
			NDR_CHECK(ndr_push_lsa_QosInfo(ndr, NDR_SCALARS, r->sec_qos));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ObjectAttribute(struct ndr_pull *ndr, int ndr_flags, struct lsa_ObjectAttribute *r)
{
	uint32_t _ptr_root_dir;
	TALLOC_CTX *_mem_save_root_dir_0;
	uint32_t _ptr_object_name;
	TALLOC_CTX *_mem_save_object_name_0;
	uint32_t _ptr_sec_desc;
	TALLOC_CTX *_mem_save_sec_desc_0;
	uint32_t _ptr_sec_qos;
	TALLOC_CTX *_mem_save_sec_qos_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_root_dir));
		if (_ptr_root_dir) {
			NDR_PULL_ALLOC(ndr, r->root_dir);
		} else {
			r->root_dir = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_name));
		if (_ptr_object_name) {
			NDR_PULL_ALLOC(ndr, r->object_name);
		} else {
			r->object_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sec_desc));
		if (_ptr_sec_desc) {
			NDR_PULL_ALLOC(ndr, r->sec_desc);
		} else {
			r->sec_desc = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sec_qos));
		if (_ptr_sec_qos) {
			NDR_PULL_ALLOC(ndr, r->sec_qos);
		} else {
			r->sec_qos = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->root_dir) {
			_mem_save_root_dir_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->root_dir, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->root_dir));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_root_dir_0, 0);
		}
		if (r->object_name) {
			_mem_save_object_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_name));
			if (ndr_get_array_length(ndr, &r->object_name) > ndr_get_array_size(ndr, &r->object_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_name), ndr_get_array_length(ndr, &r->object_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_name, ndr_get_array_length(ndr, &r->object_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_name_0, 0);
		}
		if (r->sec_desc) {
			_mem_save_sec_desc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sec_desc, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sec_desc));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_desc_0, 0);
		}
		if (r->sec_qos) {
			_mem_save_sec_qos_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sec_qos, 0);
			NDR_CHECK(ndr_pull_lsa_QosInfo(ndr, NDR_SCALARS, r->sec_qos));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_qos_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ObjectAttribute(struct ndr_print *ndr, const char *name, const struct lsa_ObjectAttribute *r)
{
	ndr_print_struct(ndr, name, "lsa_ObjectAttribute");
	ndr->depth++;
	ndr_print_uint32(ndr, "len", r->len);
	ndr_print_ptr(ndr, "root_dir", r->root_dir);
	ndr->depth++;
	if (r->root_dir) {
		ndr_print_uint8(ndr, "root_dir", *r->root_dir);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_name", r->object_name);
	ndr->depth++;
	if (r->object_name) {
		ndr_print_string(ndr, "object_name", r->object_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "attributes", r->attributes);
	ndr_print_ptr(ndr, "sec_desc", r->sec_desc);
	ndr->depth++;
	if (r->sec_desc) {
		ndr_print_security_descriptor(ndr, "sec_desc", r->sec_desc);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sec_qos", r->sec_qos);
	ndr->depth++;
	if (r->sec_qos) {
		ndr_print_lsa_QosInfo(ndr, "sec_qos", r->sec_qos);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AuditLogInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_AuditLogInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->percent_full));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->log_size));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->retention_time));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_in_progress));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time_to_shutdown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->next_audit_record));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AuditLogInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_AuditLogInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->percent_full));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->log_size));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->retention_time));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_in_progress));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time_to_shutdown));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->next_audit_record));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AuditLogInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditLogInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditLogInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "percent_full", r->percent_full);
	ndr_print_uint32(ndr, "log_size", r->log_size);
	ndr_print_NTTIME(ndr, "retention_time", r->retention_time);
	ndr_print_uint8(ndr, "shutdown_in_progress", r->shutdown_in_progress);
	ndr_print_NTTIME(ndr, "time_to_shutdown", r->time_to_shutdown);
	ndr_print_uint32(ndr, "next_audit_record", r->next_audit_record);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AuditEventsInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_AuditEventsInfo *r)
{
	uint32_t cntr_settings_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auditing_mode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->settings));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->settings) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_settings_1 = 0; cntr_settings_1 < r->count; cntr_settings_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->settings[cntr_settings_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AuditEventsInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_AuditEventsInfo *r)
{
	uint32_t _ptr_settings;
	uint32_t cntr_settings_1;
	TALLOC_CTX *_mem_save_settings_0;
	TALLOC_CTX *_mem_save_settings_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auditing_mode));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_settings));
		if (_ptr_settings) {
			NDR_PULL_ALLOC(ndr, r->settings);
		} else {
			r->settings = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->settings) {
			_mem_save_settings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->settings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->settings));
			NDR_PULL_ALLOC_N(ndr, r->settings, ndr_get_array_size(ndr, &r->settings));
			_mem_save_settings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->settings, 0);
			for (cntr_settings_1 = 0; cntr_settings_1 < r->count; cntr_settings_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->settings[cntr_settings_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_settings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_settings_0, 0);
		}
		if (r->settings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->settings, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AuditEventsInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditEventsInfo *r)
{
	uint32_t cntr_settings_1;
	ndr_print_struct(ndr, name, "lsa_AuditEventsInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "auditing_mode", r->auditing_mode);
	ndr_print_ptr(ndr, "settings", r->settings);
	ndr->depth++;
	if (r->settings) {
		ndr->print(ndr, "%s: ARRAY(%d)", "settings", r->count);
		ndr->depth++;
		for (cntr_settings_1=0;cntr_settings_1<r->count;cntr_settings_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_settings_1);
			if (idx_1) {
				ndr_print_uint32(ndr, "settings", r->settings[cntr_settings_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_DomainInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_DomainInfo *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainInfo(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfo");
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_PDAccountInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_PDAccountInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_PDAccountInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_PDAccountInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_PDAccountInfo(struct ndr_print *ndr, const char *name, const struct lsa_PDAccountInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_PDAccountInfo");
	ndr->depth++;
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ServerRole(struct ndr_push *ndr, int ndr_flags, const struct lsa_ServerRole *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->role));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ServerRole(struct ndr_pull *ndr, int ndr_flags, struct lsa_ServerRole *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->role));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ServerRole(struct ndr_print *ndr, const char *name, const struct lsa_ServerRole *r)
{
	ndr_print_struct(ndr, name, "lsa_ServerRole");
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown", r->unknown);
	ndr_print_uint16(ndr, "role", r->role);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ReplicaSourceInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_ReplicaSourceInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->source));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->source));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ReplicaSourceInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_ReplicaSourceInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->source));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->source));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ReplicaSourceInfo(struct ndr_print *ndr, const char *name, const struct lsa_ReplicaSourceInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_ReplicaSourceInfo");
	ndr->depth++;
	ndr_print_lsa_String(ndr, "source", &r->source);
	ndr_print_lsa_String(ndr, "account", &r->account);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DefaultQuotaInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_DefaultQuotaInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->paged_pool));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->non_paged_pool));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->min_wss));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_wss));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pagefile));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DefaultQuotaInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_DefaultQuotaInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->paged_pool));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->non_paged_pool));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->min_wss));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_wss));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pagefile));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DefaultQuotaInfo(struct ndr_print *ndr, const char *name, const struct lsa_DefaultQuotaInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DefaultQuotaInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "paged_pool", r->paged_pool);
	ndr_print_uint32(ndr, "non_paged_pool", r->non_paged_pool);
	ndr_print_uint32(ndr, "min_wss", r->min_wss);
	ndr_print_uint32(ndr, "max_wss", r->max_wss);
	ndr_print_uint32(ndr, "pagefile", r->pagefile);
	ndr_print_hyper(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ModificationInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_ModificationInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->modified_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->db_create_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ModificationInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_ModificationInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->modified_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->db_create_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ModificationInfo(struct ndr_print *ndr, const char *name, const struct lsa_ModificationInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_ModificationInfo");
	ndr->depth++;
	ndr_print_hyper(ndr, "modified_id", r->modified_id);
	ndr_print_NTTIME(ndr, "db_create_time", r->db_create_time);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AuditFullSetInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_AuditFullSetInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_on_full));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AuditFullSetInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_AuditFullSetInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_on_full));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AuditFullSetInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditFullSetInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditFullSetInfo");
	ndr->depth++;
	ndr_print_uint8(ndr, "shutdown_on_full", r->shutdown_on_full);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AuditFullQueryInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_AuditFullQueryInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->shutdown_on_full));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->log_is_full));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AuditFullQueryInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_AuditFullQueryInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->shutdown_on_full));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->log_is_full));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AuditFullQueryInfo(struct ndr_print *ndr, const char *name, const struct lsa_AuditFullQueryInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_AuditFullQueryInfo");
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown", r->unknown);
	ndr_print_uint8(ndr, "shutdown_on_full", r->shutdown_on_full);
	ndr_print_uint8(ndr, "log_is_full", r->log_is_full);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DnsDomainInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_DnsDomainInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forest));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forest));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->domain_guid));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DnsDomainInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_DnsDomainInfo *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domain));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forest));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domain));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forest));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->domain_guid));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DnsDomainInfo(struct ndr_print *ndr, const char *name, const struct lsa_DnsDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_DnsDomainInfo");
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "name", &r->name);
	ndr_print_lsa_StringLarge(ndr, "dns_domain", &r->dns_domain);
	ndr_print_lsa_StringLarge(ndr, "dns_forest", &r->dns_forest);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_PolicyInformation(struct ndr_push *ndr, int ndr_flags, const union lsa_PolicyInformation *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG:
				NDR_CHECK(ndr_push_lsa_AuditLogInfo(ndr, NDR_SCALARS, &r->audit_log));
			break;

			case LSA_POLICY_INFO_AUDIT_EVENTS:
				NDR_CHECK(ndr_push_lsa_AuditEventsInfo(ndr, NDR_SCALARS, &r->audit_events));
			break;

			case LSA_POLICY_INFO_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domain));
			break;

			case LSA_POLICY_INFO_PD:
				NDR_CHECK(ndr_push_lsa_PDAccountInfo(ndr, NDR_SCALARS, &r->pd));
			break;

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->account_domain));
			break;

			case LSA_POLICY_INFO_ROLE:
				NDR_CHECK(ndr_push_lsa_ServerRole(ndr, NDR_SCALARS, &r->role));
			break;

			case LSA_POLICY_INFO_REPLICA:
				NDR_CHECK(ndr_push_lsa_ReplicaSourceInfo(ndr, NDR_SCALARS, &r->replica));
			break;

			case LSA_POLICY_INFO_QUOTA:
				NDR_CHECK(ndr_push_lsa_DefaultQuotaInfo(ndr, NDR_SCALARS, &r->quota));
			break;

			case LSA_POLICY_INFO_DB:
				NDR_CHECK(ndr_push_lsa_ModificationInfo(ndr, NDR_SCALARS, &r->db));
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_SET:
				NDR_CHECK(ndr_push_lsa_AuditFullSetInfo(ndr, NDR_SCALARS, &r->auditfullset));
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
				NDR_CHECK(ndr_push_lsa_AuditFullQueryInfo(ndr, NDR_SCALARS, &r->auditfullquery));
			break;

			case LSA_POLICY_INFO_DNS:
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG:
			break;

			case LSA_POLICY_INFO_AUDIT_EVENTS:
				NDR_CHECK(ndr_push_lsa_AuditEventsInfo(ndr, NDR_BUFFERS, &r->audit_events));
			break;

			case LSA_POLICY_INFO_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domain));
			break;

			case LSA_POLICY_INFO_PD:
				NDR_CHECK(ndr_push_lsa_PDAccountInfo(ndr, NDR_BUFFERS, &r->pd));
			break;

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->account_domain));
			break;

			case LSA_POLICY_INFO_ROLE:
			break;

			case LSA_POLICY_INFO_REPLICA:
				NDR_CHECK(ndr_push_lsa_ReplicaSourceInfo(ndr, NDR_BUFFERS, &r->replica));
			break;

			case LSA_POLICY_INFO_QUOTA:
			break;

			case LSA_POLICY_INFO_DB:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_SET:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			break;

			case LSA_POLICY_INFO_DNS:
				NDR_CHECK(ndr_push_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_PolicyInformation(struct ndr_pull *ndr, int ndr_flags, union lsa_PolicyInformation *r)
{
	int level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for lsa_PolicyInformation", _level);
		}
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG: {
				NDR_CHECK(ndr_pull_lsa_AuditLogInfo(ndr, NDR_SCALARS, &r->audit_log));
			break; }

			case LSA_POLICY_INFO_AUDIT_EVENTS: {
				NDR_CHECK(ndr_pull_lsa_AuditEventsInfo(ndr, NDR_SCALARS, &r->audit_events));
			break; }

			case LSA_POLICY_INFO_DOMAIN: {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domain));
			break; }

			case LSA_POLICY_INFO_PD: {
				NDR_CHECK(ndr_pull_lsa_PDAccountInfo(ndr, NDR_SCALARS, &r->pd));
			break; }

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN: {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->account_domain));
			break; }

			case LSA_POLICY_INFO_ROLE: {
				NDR_CHECK(ndr_pull_lsa_ServerRole(ndr, NDR_SCALARS, &r->role));
			break; }

			case LSA_POLICY_INFO_REPLICA: {
				NDR_CHECK(ndr_pull_lsa_ReplicaSourceInfo(ndr, NDR_SCALARS, &r->replica));
			break; }

			case LSA_POLICY_INFO_QUOTA: {
				NDR_CHECK(ndr_pull_lsa_DefaultQuotaInfo(ndr, NDR_SCALARS, &r->quota));
			break; }

			case LSA_POLICY_INFO_DB: {
				NDR_CHECK(ndr_pull_lsa_ModificationInfo(ndr, NDR_SCALARS, &r->db));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_SET: {
				NDR_CHECK(ndr_pull_lsa_AuditFullSetInfo(ndr, NDR_SCALARS, &r->auditfullset));
			break; }

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY: {
				NDR_CHECK(ndr_pull_lsa_AuditFullQueryInfo(ndr, NDR_SCALARS, &r->auditfullquery));
			break; }

			case LSA_POLICY_INFO_DNS: {
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_SCALARS, &r->dns));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_POLICY_INFO_AUDIT_LOG:
			break;

			case LSA_POLICY_INFO_AUDIT_EVENTS:
				NDR_CHECK(ndr_pull_lsa_AuditEventsInfo(ndr, NDR_BUFFERS, &r->audit_events));
			break;

			case LSA_POLICY_INFO_DOMAIN:
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domain));
			break;

			case LSA_POLICY_INFO_PD:
				NDR_CHECK(ndr_pull_lsa_PDAccountInfo(ndr, NDR_BUFFERS, &r->pd));
			break;

			case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->account_domain));
			break;

			case LSA_POLICY_INFO_ROLE:
			break;

			case LSA_POLICY_INFO_REPLICA:
				NDR_CHECK(ndr_pull_lsa_ReplicaSourceInfo(ndr, NDR_BUFFERS, &r->replica));
			break;

			case LSA_POLICY_INFO_QUOTA:
			break;

			case LSA_POLICY_INFO_DB:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_SET:
			break;

			case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			break;

			case LSA_POLICY_INFO_DNS:
				NDR_CHECK(ndr_pull_lsa_DnsDomainInfo(ndr, NDR_BUFFERS, &r->dns));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_PolicyInformation(struct ndr_print *ndr, const char *name, const union lsa_PolicyInformation *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_PolicyInformation");
	switch (level) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			ndr_print_lsa_AuditLogInfo(ndr, "audit_log", &r->audit_log);
		break;

		case LSA_POLICY_INFO_AUDIT_EVENTS:
			ndr_print_lsa_AuditEventsInfo(ndr, "audit_events", &r->audit_events);
		break;

		case LSA_POLICY_INFO_DOMAIN:
			ndr_print_lsa_DomainInfo(ndr, "domain", &r->domain);
		break;

		case LSA_POLICY_INFO_PD:
			ndr_print_lsa_PDAccountInfo(ndr, "pd", &r->pd);
		break;

		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			ndr_print_lsa_DomainInfo(ndr, "account_domain", &r->account_domain);
		break;

		case LSA_POLICY_INFO_ROLE:
			ndr_print_lsa_ServerRole(ndr, "role", &r->role);
		break;

		case LSA_POLICY_INFO_REPLICA:
			ndr_print_lsa_ReplicaSourceInfo(ndr, "replica", &r->replica);
		break;

		case LSA_POLICY_INFO_QUOTA:
			ndr_print_lsa_DefaultQuotaInfo(ndr, "quota", &r->quota);
		break;

		case LSA_POLICY_INFO_DB:
			ndr_print_lsa_ModificationInfo(ndr, "db", &r->db);
		break;

		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			ndr_print_lsa_AuditFullSetInfo(ndr, "auditfullset", &r->auditfullset);
		break;

		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			ndr_print_lsa_AuditFullQueryInfo(ndr, "auditfullquery", &r->auditfullquery);
		break;

		case LSA_POLICY_INFO_DNS:
			ndr_print_lsa_DnsDomainInfo(ndr, "dns", &r->dns);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_lsa_SidPtr(struct ndr_push *ndr, int ndr_flags, const struct lsa_SidPtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SidPtr(struct ndr_pull *ndr, int ndr_flags, struct lsa_SidPtr *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SidPtr(struct ndr_print *ndr, const char *name, const struct lsa_SidPtr *r)
{
	ndr_print_struct(ndr, name, "lsa_SidPtr");
	ndr->depth++;
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_lsa_SidArray(struct ndr_push *ndr, int ndr_flags, const struct lsa_SidArray *r)
{
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_SidPtr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_SidPtr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_lsa_SidArray(struct ndr_pull *ndr, int ndr_flags, struct lsa_SidArray *r)
{
	uint32_t _ptr_sids;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		if (r->num_sids < 0 || r->num_sids > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_PULL_ALLOC_N(ndr, r->sids, ndr_get_array_size(ndr, &r->sids));
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_SidPtr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_SidPtr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SidArray(struct ndr_print *ndr, const char *name, const struct lsa_SidArray *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_SidArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", r->num_sids);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->num_sids;cntr_sids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sids_1);
			if (idx_1) {
				ndr_print_lsa_SidPtr(ndr, "sids", &r->sids[cntr_sids_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainList(struct ndr_push *ndr, int ndr_flags, const struct lsa_DomainList *r)
{
	uint32_t cntr_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainList(struct ndr_pull *ndr, int ndr_flags, struct lsa_DomainList *r)
{
	uint32_t _ptr_domains;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_PULL_ALLOC_N(ndr, r->domains, ndr_get_array_size(ndr, &r->domains));
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainList(struct ndr_print *ndr, const char *name, const struct lsa_DomainList *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_DomainList");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%d)", "domains", r->count);
		ndr->depth++;
		for (cntr_domains_1=0;cntr_domains_1<r->count;cntr_domains_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_domains_1);
			if (idx_1) {
				ndr_print_lsa_DomainInfo(ndr, "domains", &r->domains[cntr_domains_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SidType(struct ndr_push *ndr, int ndr_flags, enum lsa_SidType r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SidType(struct ndr_pull *ndr, int ndr_flags, enum lsa_SidType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SidType(struct ndr_print *ndr, const char *name, enum lsa_SidType r)
{
	const char *val = NULL;

	switch (r) {
		case SID_NAME_USE_NONE: val = "SID_NAME_USE_NONE"; break;
		case SID_NAME_USER: val = "SID_NAME_USER"; break;
		case SID_NAME_DOM_GRP: val = "SID_NAME_DOM_GRP"; break;
		case SID_NAME_DOMAIN: val = "SID_NAME_DOMAIN"; break;
		case SID_NAME_ALIAS: val = "SID_NAME_ALIAS"; break;
		case SID_NAME_WKN_GRP: val = "SID_NAME_WKN_GRP"; break;
		case SID_NAME_DELETED: val = "SID_NAME_DELETED"; break;
		case SID_NAME_INVALID: val = "SID_NAME_INVALID"; break;
		case SID_NAME_UNKNOWN: val = "SID_NAME_UNKNOWN"; break;
		case SID_NAME_COMPUTER: val = "SID_NAME_COMPUTER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_lsa_TranslatedSid(struct ndr_push *ndr, int ndr_flags, const struct lsa_TranslatedSid *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TranslatedSid(struct ndr_pull *ndr, int ndr_flags, struct lsa_TranslatedSid *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid");
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TransSidArray(struct ndr_push *ndr, int ndr_flags, const struct lsa_TransSidArray *r)
{
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TransSidArray(struct ndr_pull *ndr, int ndr_flags, struct lsa_TransSidArray *r)
{
	uint32_t _ptr_sids;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_PULL_ALLOC_N(ndr, r->sids, ndr_get_array_size(ndr, &r->sids));
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", r->count);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->count;cntr_sids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sids_1);
			if (idx_1) {
				ndr_print_lsa_TranslatedSid(ndr, "sids", &r->sids[cntr_sids_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_RefDomainList(struct ndr_push *ndr, int ndr_flags, const struct lsa_RefDomainList *r)
{
	uint32_t cntr_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_RefDomainList(struct ndr_pull *ndr, int ndr_flags, struct lsa_RefDomainList *r)
{
	uint32_t _ptr_domains;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_PULL_ALLOC_N(ndr, r->domains, ndr_get_array_size(ndr, &r->domains));
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_RefDomainList(struct ndr_print *ndr, const char *name, const struct lsa_RefDomainList *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_RefDomainList");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%d)", "domains", r->count);
		ndr->depth++;
		for (cntr_domains_1=0;cntr_domains_1<r->count;cntr_domains_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_domains_1);
			if (idx_1) {
				ndr_print_lsa_DomainInfo(ndr, "domains", &r->domains[cntr_domains_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "max_size", r->max_size);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TranslatedName(struct ndr_push *ndr, int ndr_flags, const struct lsa_TranslatedName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TranslatedName(struct ndr_pull *ndr, int ndr_flags, struct lsa_TranslatedName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TranslatedName(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedName *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedName");
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TransNameArray(struct ndr_push *ndr, int ndr_flags, const struct lsa_TransNameArray *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TransNameArray(struct ndr_pull *ndr, int ndr_flags, struct lsa_TransNameArray *r)
{
	uint32_t _ptr_names;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_PULL_ALLOC_N(ndr, r->names, ndr_get_array_size(ndr, &r->names));
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TransNameArray(struct ndr_print *ndr, const char *name, const struct lsa_TransNameArray *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_TransNameArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_names_1);
			if (idx_1) {
				ndr_print_lsa_TranslatedName(ndr, "names", &r->names[cntr_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LUIDAttribute(struct ndr_push *ndr, int ndr_flags, const struct lsa_LUIDAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attribute));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LUIDAttribute(struct ndr_pull *ndr, int ndr_flags, struct lsa_LUIDAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, &r->luid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attribute));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LUIDAttribute(struct ndr_print *ndr, const char *name, const struct lsa_LUIDAttribute *r)
{
	ndr_print_struct(ndr, name, "lsa_LUIDAttribute");
	ndr->depth++;
	ndr_print_lsa_LUID(ndr, "luid", &r->luid);
	ndr_print_uint32(ndr, "attribute", r->attribute);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_PrivilegeSet(struct ndr_push *ndr, int ndr_flags, const struct lsa_PrivilegeSet *r)
{
	uint32_t cntr_set_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		for (cntr_set_0 = 0; cntr_set_0 < r->count; cntr_set_0++) {
			NDR_CHECK(ndr_push_lsa_LUIDAttribute(ndr, NDR_SCALARS, &r->set[cntr_set_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_PrivilegeSet(struct ndr_pull *ndr, int ndr_flags, struct lsa_PrivilegeSet *r)
{
	uint32_t cntr_set_0;
	TALLOC_CTX *_mem_save_set_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->set));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_PULL_ALLOC_N(ndr, r->set, ndr_get_array_size(ndr, &r->set));
		_mem_save_set_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->set, 0);
		for (cntr_set_0 = 0; cntr_set_0 < r->count; cntr_set_0++) {
			NDR_CHECK(ndr_pull_lsa_LUIDAttribute(ndr, NDR_SCALARS, &r->set[cntr_set_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_set_0, 0);
		if (r->set) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->set, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_PrivilegeSet(struct ndr_print *ndr, const char *name, const struct lsa_PrivilegeSet *r)
{
	uint32_t cntr_set_0;
	ndr_print_struct(ndr, name, "lsa_PrivilegeSet");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->print(ndr, "%s: ARRAY(%d)", "set", r->count);
	ndr->depth++;
	for (cntr_set_0=0;cntr_set_0<r->count;cntr_set_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_set_0);
		if (idx_0) {
			ndr_print_lsa_LUIDAttribute(ndr, "set", &r->set[cntr_set_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DATA_BUF(struct ndr_push *ndr, int ndr_flags, const struct lsa_DATA_BUF *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DATA_BUF(struct ndr_pull *ndr, int ndr_flags, struct lsa_DATA_BUF *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->data));
				if (ndr_get_array_length(ndr, &r->data) > ndr_get_array_size(ndr, &r->data)) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data), ndr_get_array_length(ndr, &r->data));
				}
				NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_length(ndr, &r->data)));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->size));
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", r->length);
		ndr_print_uint32(ndr, "size", r->size);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->length);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static NTSTATUS ndr_push_lsa_DATA_BUF2(struct ndr_push *ndr, int ndr_flags, const struct lsa_DATA_BUF2 *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->size));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DATA_BUF2(struct ndr_pull *ndr, int ndr_flags, struct lsa_DATA_BUF2 *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
			if (r->size < 0 || r->size > 65536) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_size(ndr, &r->data)));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->size));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF2(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF2 *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF2");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "size", r->size);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->size);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static NTSTATUS ndr_push_lsa_TrustDomInfoEnum(struct ndr_push *ndr, int ndr_flags, enum lsa_TrustDomInfoEnum r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomInfoEnum(struct ndr_pull *ndr, int ndr_flags, enum lsa_TrustDomInfoEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomInfoEnum(struct ndr_print *ndr, const char *name, enum lsa_TrustDomInfoEnum r)
{
	const char *val = NULL;

	switch (r) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME: val = "LSA_TRUSTED_DOMAIN_INFO_NAME"; break;
		case LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS_INFO: val = "LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS_INFO"; break;
		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET: val = "LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET"; break;
		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD: val = "LSA_TRUSTED_DOMAIN_INFO_PASSWORD"; break;
		case LSA_TRUSTED_DOMAIN_INFO_BASIC: val = "LSA_TRUSTED_DOMAIN_INFO_BASIC"; break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX: val = "LSA_TRUSTED_DOMAIN_INFO_INFO_EX"; break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO: val = "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO"; break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO: val = "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO"; break;
		case LSA_TRUSTED_DOMAIN_INFO_11: val = "LSA_TRUSTED_DOMAIN_INFO_11"; break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL: val = "LSA_TRUSTED_DOMAIN_INFO_INFO_ALL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoName(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoName(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoName(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoName *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoName");
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "netbios_name", &r->netbios_name);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoPosixOffset(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoPosixOffset *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->posix_offset));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoPosixOffset(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoPosixOffset *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->posix_offset));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoPosixOffset(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoPosixOffset *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoPosixOffset");
	ndr->depth++;
	ndr_print_uint32(ndr, "posix_offset", r->posix_offset);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoPassword(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoPassword *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->old_password));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->password) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
		}
		if (r->old_password) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoPassword(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoPassword *r)
{
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_password_0;
	uint32_t _ptr_old_password;
	TALLOC_CTX *_mem_save_old_password_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->password);
		} else {
			r->password = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_password));
		if (_ptr_old_password) {
			NDR_PULL_ALLOC(ndr, r->old_password);
		} else {
			r->old_password = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		if (r->old_password) {
			_mem_save_old_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->old_password, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->old_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_password_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoPassword(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoPassword *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoPassword");
	ndr->depth++;
	ndr_print_ptr(ndr, "password", r->password);
	ndr->depth++;
	if (r->password) {
		ndr_print_lsa_DATA_BUF(ndr, "password", r->password);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "old_password", r->old_password);
	ndr->depth++;
	if (r->old_password) {
		ndr_print_lsa_DATA_BUF(ndr, "old_password", r->old_password);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoBasic(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoBasic *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoBasic(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoBasic *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoBasic(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoBasic *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoBasic");
	ndr->depth++;
	ndr_print_lsa_String(ndr, "netbios_name", &r->netbios_name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoInfoEx(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoInfoEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trust_direction));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trust_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trust_attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoInfoEx(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoInfoEx *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->netbios_name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trust_direction));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trust_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trust_attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->netbios_name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoInfoEx(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoInfoEx *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoInfoEx");
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "domain_name", &r->domain_name);
	ndr_print_lsa_StringLarge(ndr, "netbios_name", &r->netbios_name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "trust_direction", r->trust_direction);
	ndr_print_uint32(ndr, "trust_type", r->trust_type);
	ndr_print_uint32(ndr, "trust_attributes", r->trust_attributes);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoBuffer(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->last_update_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->secret_type));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoBuffer(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->last_update_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secret_type));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoBuffer(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoBuffer *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoBuffer");
	ndr->depth++;
	ndr_print_NTTIME_hyper(ndr, "last_update_time", r->last_update_time);
	ndr_print_uint32(ndr, "secret_type", r->secret_type);
	ndr_print_lsa_DATA_BUF2(ndr, "data", &r->data);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoAuthInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->incoming_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->incoming_current_auth_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->incoming_previous_auth_info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->outgoing_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->outgoing_current_auth_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->outgoing_previous_auth_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->incoming_current_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_current_auth_info));
		}
		if (r->incoming_previous_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_previous_auth_info));
		}
		if (r->outgoing_current_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_current_auth_info));
		}
		if (r->outgoing_previous_auth_info) {
			NDR_CHECK(ndr_push_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_previous_auth_info));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoAuthInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoAuthInfo *r)
{
	uint32_t _ptr_incoming_current_auth_info;
	TALLOC_CTX *_mem_save_incoming_current_auth_info_0;
	uint32_t _ptr_incoming_previous_auth_info;
	TALLOC_CTX *_mem_save_incoming_previous_auth_info_0;
	uint32_t _ptr_outgoing_current_auth_info;
	TALLOC_CTX *_mem_save_outgoing_current_auth_info_0;
	uint32_t _ptr_outgoing_previous_auth_info;
	TALLOC_CTX *_mem_save_outgoing_previous_auth_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->incoming_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_incoming_current_auth_info));
		if (_ptr_incoming_current_auth_info) {
			NDR_PULL_ALLOC(ndr, r->incoming_current_auth_info);
		} else {
			r->incoming_current_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_incoming_previous_auth_info));
		if (_ptr_incoming_previous_auth_info) {
			NDR_PULL_ALLOC(ndr, r->incoming_previous_auth_info);
		} else {
			r->incoming_previous_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->outgoing_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_outgoing_current_auth_info));
		if (_ptr_outgoing_current_auth_info) {
			NDR_PULL_ALLOC(ndr, r->outgoing_current_auth_info);
		} else {
			r->outgoing_current_auth_info = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_outgoing_previous_auth_info));
		if (_ptr_outgoing_previous_auth_info) {
			NDR_PULL_ALLOC(ndr, r->outgoing_previous_auth_info);
		} else {
			r->outgoing_previous_auth_info = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->incoming_current_auth_info) {
			_mem_save_incoming_current_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->incoming_current_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_current_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_incoming_current_auth_info_0, 0);
		}
		if (r->incoming_previous_auth_info) {
			_mem_save_incoming_previous_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->incoming_previous_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->incoming_previous_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_incoming_previous_auth_info_0, 0);
		}
		if (r->outgoing_current_auth_info) {
			_mem_save_outgoing_current_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->outgoing_current_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_current_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_outgoing_current_auth_info_0, 0);
		}
		if (r->outgoing_previous_auth_info) {
			_mem_save_outgoing_previous_auth_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->outgoing_previous_auth_info, 0);
			NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBuffer(ndr, NDR_SCALARS|NDR_BUFFERS, r->outgoing_previous_auth_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_outgoing_previous_auth_info_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoAuthInfo(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoAuthInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "incoming_count", r->incoming_count);
	ndr_print_ptr(ndr, "incoming_current_auth_info", r->incoming_current_auth_info);
	ndr->depth++;
	if (r->incoming_current_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "incoming_current_auth_info", r->incoming_current_auth_info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "incoming_previous_auth_info", r->incoming_previous_auth_info);
	ndr->depth++;
	if (r->incoming_previous_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "incoming_previous_auth_info", r->incoming_previous_auth_info);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "outgoing_count", r->outgoing_count);
	ndr_print_ptr(ndr, "outgoing_current_auth_info", r->outgoing_current_auth_info);
	ndr->depth++;
	if (r->outgoing_current_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "outgoing_current_auth_info", r->outgoing_current_auth_info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "outgoing_previous_auth_info", r->outgoing_previous_auth_info);
	ndr->depth++;
	if (r->outgoing_previous_auth_info) {
		ndr_print_lsa_TrustDomainInfoBuffer(ndr, "outgoing_previous_auth_info", r->outgoing_previous_auth_info);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoFullInfo(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoFullInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoFullInfo(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoFullInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoFullInfo(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoFullInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoFullInfo");
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfo11(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfo11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data1));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfo11(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfo11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data1));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfo11(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfo11 *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfo11");
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_DATA_BUF2(ndr, "data1", &r->data1);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustDomainInfoInfoAll(struct ndr_push *ndr, int ndr_flags, const struct lsa_TrustDomainInfoInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data1));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_push_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data1));
		NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustDomainInfoInfoAll(struct ndr_pull *ndr, int ndr_flags, struct lsa_TrustDomainInfoInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_SCALARS, &r->data1));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
		NDR_CHECK(ndr_pull_lsa_DATA_BUF2(ndr, NDR_BUFFERS, &r->data1));
		NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustDomainInfoInfoAll(struct ndr_print *ndr, const char *name, const struct lsa_TrustDomainInfoInfoAll *r)
{
	ndr_print_struct(ndr, name, "lsa_TrustDomainInfoInfoAll");
	ndr->depth++;
	ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
	ndr_print_lsa_DATA_BUF2(ndr, "data1", &r->data1);
	ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
	ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TrustedDomainInfo(struct ndr_push *ndr, int ndr_flags, const union lsa_TrustedDomainInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, level));
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoName(ndr, NDR_SCALARS, &r->name));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPassword(ndr, NDR_SCALARS, &r->password));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_BASIC:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoBasic(ndr, NDR_SCALARS, &r->info_basic));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo(ndr, NDR_SCALARS, &r->full_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_11:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfo11(ndr, NDR_SCALARS, &r->info11));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoAll(ndr, NDR_SCALARS, &r->info_all));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoName(ndr, NDR_BUFFERS, &r->name));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoPassword(ndr, NDR_BUFFERS, &r->password));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_BASIC:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoBasic(ndr, NDR_BUFFERS, &r->info_basic));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoFullInfo(ndr, NDR_BUFFERS, &r->full_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_11:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoAll(ndr, NDR_BUFFERS, &r->info_all));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TrustedDomainInfo(struct ndr_pull *ndr, int ndr_flags, union lsa_TrustedDomainInfo *r)
{
	int level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for lsa_TrustedDomainInfo", _level);
		}
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoName(ndr, NDR_SCALARS, &r->name));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPosixOffset(ndr, NDR_SCALARS, &r->posix_offset));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPassword(ndr, NDR_SCALARS, &r->password));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_BASIC: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBasic(ndr, NDR_SCALARS, &r->info_basic));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->info_ex));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_SCALARS, &r->auth_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo(ndr, NDR_SCALARS, &r->full_info));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_11: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfo11(ndr, NDR_SCALARS, &r->info11));
			break; }

			case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL: {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoAll(ndr, NDR_SCALARS, &r->info_all));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_TRUSTED_DOMAIN_INFO_NAME:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoName(ndr, NDR_BUFFERS, &r->name));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			break;

			case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoPassword(ndr, NDR_BUFFERS, &r->password));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_BASIC:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoBasic(ndr, NDR_BUFFERS, &r->info_basic));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->info_ex));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoAuthInfo(ndr, NDR_BUFFERS, &r->auth_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoFullInfo(ndr, NDR_BUFFERS, &r->full_info));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_11:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoAll(ndr, NDR_BUFFERS, &r->info_all));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TrustedDomainInfo(struct ndr_print *ndr, const char *name, const union lsa_TrustedDomainInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_TrustedDomainInfo");
	switch (level) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			ndr_print_lsa_TrustDomainInfoName(ndr, "name", &r->name);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			ndr_print_lsa_TrustDomainInfoPosixOffset(ndr, "posix_offset", &r->posix_offset);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			ndr_print_lsa_TrustDomainInfoPassword(ndr, "password", &r->password);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			ndr_print_lsa_TrustDomainInfoBasic(ndr, "info_basic", &r->info_basic);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "info_ex", &r->info_ex);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			ndr_print_lsa_TrustDomainInfoAuthInfo(ndr, "auth_info", &r->auth_info);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			ndr_print_lsa_TrustDomainInfoFullInfo(ndr, "full_info", &r->full_info);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_11:
			ndr_print_lsa_TrustDomainInfo11(ndr, "info11", &r->info11);
		break;

		case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
			ndr_print_lsa_TrustDomainInfoInfoAll(ndr, "info_all", &r->info_all);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_lsa_DATA_BUF_PTR(struct ndr_push *ndr, int ndr_flags, const struct lsa_DATA_BUF_PTR *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buf));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buf) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->buf));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DATA_BUF_PTR(struct ndr_pull *ndr, int ndr_flags, struct lsa_DATA_BUF_PTR *r)
{
	uint32_t _ptr_buf;
	TALLOC_CTX *_mem_save_buf_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buf));
		if (_ptr_buf) {
			NDR_PULL_ALLOC(ndr, r->buf);
		} else {
			r->buf = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buf) {
			_mem_save_buf_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buf, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->buf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buf_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DATA_BUF_PTR(struct ndr_print *ndr, const char *name, const struct lsa_DATA_BUF_PTR *r)
{
	ndr_print_struct(ndr, name, "lsa_DATA_BUF_PTR");
	ndr->depth++;
	ndr_print_ptr(ndr, "buf", r->buf);
	ndr->depth++;
	if (r->buf) {
		ndr_print_lsa_DATA_BUF(ndr, "buf", r->buf);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_RightSet(struct ndr_push *ndr, int ndr_flags, const struct lsa_RightSet *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_RightSet(struct ndr_pull *ndr, int ndr_flags, struct lsa_RightSet *r)
{
	uint32_t _ptr_names;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_PULL_ALLOC_N(ndr, r->names, ndr_get_array_size(ndr, &r->names));
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_RightSet(struct ndr_print *ndr, const char *name, const struct lsa_RightSet *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_RightSet");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_names_1);
			if (idx_1) {
				ndr_print_lsa_StringLarge(ndr, "names", &r->names[cntr_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_StringPointer(struct ndr_push *ndr, int ndr_flags, const struct lsa_StringPointer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->string));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_StringPointer(struct ndr_pull *ndr, int ndr_flags, struct lsa_StringPointer *r)
{
	uint32_t _ptr_string;
	TALLOC_CTX *_mem_save_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->string));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_StringPointer(struct ndr_print *ndr, const char *name, const struct lsa_StringPointer *r)
{
	ndr_print_struct(ndr, name, "lsa_StringPointer");
	ndr->depth++;
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_lsa_String(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainListEx(struct ndr_push *ndr, int ndr_flags, const struct lsa_DomainListEx *r)
{
	uint32_t cntr_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domains));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_push_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainListEx(struct ndr_pull *ndr, int ndr_flags, struct lsa_DomainListEx *r)
{
	uint32_t _ptr_domains;
	uint32_t cntr_domains_1;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->domains);
		} else {
			r->domains = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domains));
			NDR_PULL_ALLOC_N(ndr, r->domains, ndr_get_array_size(ndr, &r->domains));
			_mem_save_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domains, 0);
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_SCALARS, &r->domains[cntr_domains_1]));
			}
			for (cntr_domains_1 = 0; cntr_domains_1 < r->count; cntr_domains_1++) {
				NDR_CHECK(ndr_pull_lsa_TrustDomainInfoInfoEx(ndr, NDR_BUFFERS, &r->domains[cntr_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (r->domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->domains, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainListEx(struct ndr_print *ndr, const char *name, const struct lsa_DomainListEx *r)
{
	uint32_t cntr_domains_1;
	ndr_print_struct(ndr, name, "lsa_DomainListEx");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "domains", r->domains);
	ndr->depth++;
	if (r->domains) {
		ndr->print(ndr, "%s: ARRAY(%d)", "domains", r->count);
		ndr->depth++;
		for (cntr_domains_1=0;cntr_domains_1<r->count;cntr_domains_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_domains_1);
			if (idx_1) {
				ndr_print_lsa_TrustDomainInfoInfoEx(ndr, "domains", &r->domains[cntr_domains_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainInfoKerberos(struct ndr_push *ndr, int ndr_flags, const struct lsa_DomainInfoKerberos *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enforce_restrictions));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->service_tkt_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->user_tkt_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->user_tkt_renewaltime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->clock_skew));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown6));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainInfoKerberos(struct ndr_pull *ndr, int ndr_flags, struct lsa_DomainInfoKerberos *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enforce_restrictions));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->service_tkt_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->user_tkt_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->user_tkt_renewaltime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->clock_skew));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown6));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoKerberos(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfoKerberos *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfoKerberos");
	ndr->depth++;
	ndr_print_uint32(ndr, "enforce_restrictions", r->enforce_restrictions);
	ndr_print_hyper(ndr, "service_tkt_lifetime", r->service_tkt_lifetime);
	ndr_print_hyper(ndr, "user_tkt_lifetime", r->user_tkt_lifetime);
	ndr_print_hyper(ndr, "user_tkt_renewaltime", r->user_tkt_renewaltime);
	ndr_print_hyper(ndr, "clock_skew", r->clock_skew);
	ndr_print_hyper(ndr, "unknown6", r->unknown6);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainInfoEfs(struct ndr_push *ndr, int ndr_flags, const struct lsa_DomainInfoEfs *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->blob_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->efs_blob));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->efs_blob) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->blob_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->efs_blob, r->blob_size));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainInfoEfs(struct ndr_pull *ndr, int ndr_flags, struct lsa_DomainInfoEfs *r)
{
	uint32_t _ptr_efs_blob;
	TALLOC_CTX *_mem_save_efs_blob_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->blob_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_efs_blob));
		if (_ptr_efs_blob) {
			NDR_PULL_ALLOC(ndr, r->efs_blob);
		} else {
			r->efs_blob = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->efs_blob) {
			_mem_save_efs_blob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->efs_blob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->efs_blob));
			NDR_PULL_ALLOC_N(ndr, r->efs_blob, ndr_get_array_size(ndr, &r->efs_blob));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->efs_blob, ndr_get_array_size(ndr, &r->efs_blob)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_efs_blob_0, 0);
		}
		if (r->efs_blob) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->efs_blob, r->blob_size));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainInfoEfs(struct ndr_print *ndr, const char *name, const struct lsa_DomainInfoEfs *r)
{
	ndr_print_struct(ndr, name, "lsa_DomainInfoEfs");
	ndr->depth++;
	ndr_print_uint32(ndr, "blob_size", r->blob_size);
	ndr_print_ptr(ndr, "efs_blob", r->efs_blob);
	ndr->depth++;
	if (r->efs_blob) {
		ndr_print_array_uint8(ndr, "efs_blob", r->efs_blob, r->blob_size);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DomainInformationPolicy(struct ndr_push *ndr, int ndr_flags, const union lsa_DomainInformationPolicy *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_EFS:
				NDR_CHECK(ndr_push_lsa_DomainInfoEfs(ndr, NDR_SCALARS, &r->efs_info));
			break;

			case LSA_DOMAIN_INFO_POLICY_KERBEROS:
				NDR_CHECK(ndr_push_lsa_DomainInfoKerberos(ndr, NDR_SCALARS, &r->kerberos_info));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_EFS:
				NDR_CHECK(ndr_push_lsa_DomainInfoEfs(ndr, NDR_BUFFERS, &r->efs_info));
			break;

			case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DomainInformationPolicy(struct ndr_pull *ndr, int ndr_flags, union lsa_DomainInformationPolicy *r)
{
	int level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for lsa_DomainInformationPolicy", _level);
		}
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_EFS: {
				NDR_CHECK(ndr_pull_lsa_DomainInfoEfs(ndr, NDR_SCALARS, &r->efs_info));
			break; }

			case LSA_DOMAIN_INFO_POLICY_KERBEROS: {
				NDR_CHECK(ndr_pull_lsa_DomainInfoKerberos(ndr, NDR_SCALARS, &r->kerberos_info));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case LSA_DOMAIN_INFO_POLICY_EFS:
				NDR_CHECK(ndr_pull_lsa_DomainInfoEfs(ndr, NDR_BUFFERS, &r->efs_info));
			break;

			case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DomainInformationPolicy(struct ndr_print *ndr, const char *name, const union lsa_DomainInformationPolicy *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "lsa_DomainInformationPolicy");
	switch (level) {
		case LSA_DOMAIN_INFO_POLICY_EFS:
			ndr_print_lsa_DomainInfoEfs(ndr, "efs_info", &r->efs_info);
		break;

		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			ndr_print_lsa_DomainInfoKerberos(ndr, "kerberos_info", &r->kerberos_info);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_lsa_TranslatedName2(struct ndr_push *ndr, int ndr_flags, const struct lsa_TranslatedName2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TranslatedName2(struct ndr_pull *ndr, int ndr_flags, struct lsa_TranslatedName2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TranslatedName2(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedName2 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedName2");
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TransNameArray2(struct ndr_push *ndr, int ndr_flags, const struct lsa_TransNameArray2 *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName2(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedName2(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TransNameArray2(struct ndr_pull *ndr, int ndr_flags, struct lsa_TransNameArray2 *r)
{
	uint32_t _ptr_names;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_PULL_ALLOC_N(ndr, r->names, ndr_get_array_size(ndr, &r->names));
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName2(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedName2(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TransNameArray2(struct ndr_print *ndr, const char *name, const struct lsa_TransNameArray2 *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "lsa_TransNameArray2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_names_1);
			if (idx_1) {
				ndr_print_lsa_TranslatedName2(ndr, "names", &r->names[cntr_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TranslatedSid2(struct ndr_push *ndr, int ndr_flags, const struct lsa_TranslatedSid2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TranslatedSid2(struct ndr_pull *ndr, int ndr_flags, struct lsa_TranslatedSid2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid2(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid2 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid2");
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TransSidArray2(struct ndr_push *ndr, int ndr_flags, const struct lsa_TransSidArray2 *r)
{
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid2(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TransSidArray2(struct ndr_pull *ndr, int ndr_flags, struct lsa_TransSidArray2 *r)
{
	uint32_t _ptr_sids;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_PULL_ALLOC_N(ndr, r->sids, ndr_get_array_size(ndr, &r->sids));
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid2(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray2(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray2 *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", r->count);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->count;cntr_sids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sids_1);
			if (idx_1) {
				ndr_print_lsa_TranslatedSid2(ndr, "sids", &r->sids[cntr_sids_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TranslatedSid3(struct ndr_push *ndr, int ndr_flags, const struct lsa_TranslatedSid3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->sid_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TranslatedSid3(struct ndr_pull *ndr, int ndr_flags, struct lsa_TranslatedSid3 *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->sid_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TranslatedSid3(struct ndr_print *ndr, const char *name, const struct lsa_TranslatedSid3 *r)
{
	ndr_print_struct(ndr, name, "lsa_TranslatedSid3");
	ndr->depth++;
	ndr_print_lsa_SidType(ndr, "sid_type", r->sid_type);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "sid_index", r->sid_index);
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TransSidArray3(struct ndr_push *ndr, int ndr_flags, const struct lsa_TransSidArray3 *r)
{
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid3(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_push_lsa_TranslatedSid3(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TransSidArray3(struct ndr_pull *ndr, int ndr_flags, struct lsa_TransSidArray3 *r)
{
	uint32_t _ptr_sids;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_PULL_ALLOC_N(ndr, r->sids, ndr_get_array_size(ndr, &r->sids));
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid3(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->count; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_lsa_TranslatedSid3(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TransSidArray3(struct ndr_print *ndr, const char *name, const struct lsa_TransSidArray3 *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "lsa_TransSidArray3");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", r->count);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->count;cntr_sids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sids_1);
			if (idx_1) {
				ndr_print_lsa_TranslatedSid3(ndr, "sids", &r->sids[cntr_sids_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_Close(struct ndr_push *ndr, int flags, const struct lsa_Close *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_Close(struct ndr_pull *ndr, int flags, struct lsa_Close *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_Close(struct ndr_print *ndr, const char *name, int flags, const struct lsa_Close *r)
{
	ndr_print_struct(ndr, name, "lsa_Close");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_Delete(struct ndr_push *ndr, int flags, const struct lsa_Delete *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_Delete(struct ndr_pull *ndr, int flags, struct lsa_Delete *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_Delete(struct ndr_print *ndr, const char *name, int flags, const struct lsa_Delete *r)
{
	ndr_print_struct(ndr, name, "lsa_Delete");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_Delete");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_Delete");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumPrivs(struct ndr_push *ndr, int flags, const struct lsa_EnumPrivs *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_count));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.privs == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_PrivArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.privs));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumPrivs(struct ndr_pull *ndr, int flags, struct lsa_EnumPrivs *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_privs_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_count));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.privs);
		ZERO_STRUCTP(r->out.privs);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.privs);
		}
		_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.privs, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PrivArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.privs));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumPrivs(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumPrivs *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumPrivs");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumPrivs");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_count", r->in.max_count);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumPrivs");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "privs", r->out.privs);
		ndr->depth++;
		ndr_print_lsa_PrivArray(ndr, "privs", r->out.privs);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QuerySecurity(struct ndr_push *ndr, int flags, const struct lsa_QuerySecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.sdbuf));
		if (r->out.sdbuf) {
			NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sdbuf));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QuerySecurity(struct ndr_pull *ndr, int flags, struct lsa_QuerySecurity *r)
{
	uint32_t _ptr_sdbuf;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sdbuf_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sdbuf));
		if (_ptr_sdbuf) {
			NDR_PULL_ALLOC(ndr, r->out.sdbuf);
		} else {
			r->out.sdbuf = NULL;
		}
		if (r->out.sdbuf) {
			_mem_save_sdbuf_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.sdbuf, 0);
			NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sdbuf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QuerySecurity(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QuerySecurity *r)
{
	ndr_print_struct(ndr, name, "lsa_QuerySecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "sdbuf", r->out.sdbuf);
		ndr->depth++;
		if (r->out.sdbuf) {
			ndr_print_sec_desc_buf(ndr, "sdbuf", r->out.sdbuf);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetSecObj(struct ndr_push *ndr, int flags, const struct lsa_SetSecObj *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetSecObj(struct ndr_pull *ndr, int flags, struct lsa_SetSecObj *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetSecObj(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetSecObj *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSecObj");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSecObj");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSecObj");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ChangePassword(struct ndr_push *ndr, int flags, const struct lsa_ChangePassword *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ChangePassword(struct ndr_pull *ndr, int flags, struct lsa_ChangePassword *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ChangePassword(struct ndr_print *ndr, const char *name, int flags, const struct lsa_ChangePassword *r)
{
	ndr_print_struct(ndr, name, "lsa_ChangePassword");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_ChangePassword");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_ChangePassword");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenPolicy(struct ndr_push *ndr, int flags, const struct lsa_OpenPolicy *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		if (r->in.attr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenPolicy(struct ndr_pull *ndr, int flags, struct lsa_OpenPolicy *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_attr_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
		}
		_mem_save_attr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.attr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenPolicy(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenPolicy");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "attr", r->in.attr);
		ndr->depth++;
		ndr_print_lsa_ObjectAttribute(ndr, "attr", r->in.attr);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryInfoPolicy(struct ndr_push *ndr, int flags, const struct lsa_QueryInfoPolicy *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryInfoPolicy(struct ndr_pull *ndr, int flags, struct lsa_QueryInfoPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryInfoPolicy(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryInfoPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryInfoPolicy");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryInfoPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryInfoPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_PolicyInformation(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetInfoPolicy(struct ndr_push *ndr, int flags, const struct lsa_SetInfoPolicy *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetInfoPolicy(struct ndr_pull *ndr, int flags, struct lsa_SetInfoPolicy *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetInfoPolicy(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetInfoPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInfoPolicy");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInfoPolicy");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInfoPolicy");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_ClearAuditLog(struct ndr_push *ndr, int flags, const struct lsa_ClearAuditLog *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_ClearAuditLog(struct ndr_pull *ndr, int flags, struct lsa_ClearAuditLog *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_ClearAuditLog(struct ndr_print *ndr, const char *name, int flags, const struct lsa_ClearAuditLog *r)
{
	ndr_print_struct(ndr, name, "lsa_ClearAuditLog");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_ClearAuditLog");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_ClearAuditLog");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CreateAccount(struct ndr_push *ndr, int flags, const struct lsa_CreateAccount *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.acct_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.acct_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CreateAccount(struct ndr_pull *ndr, int flags, struct lsa_CreateAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_acct_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		ZERO_STRUCTP(r->out.acct_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		}
		_mem_save_acct_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.acct_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.acct_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CreateAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CreateAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumAccounts(struct ndr_push *ndr, int flags, const struct lsa_EnumAccounts *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_entries));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumAccounts(struct ndr_pull *ndr, int flags, struct lsa_EnumAccounts *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_entries));
		if (r->in.num_entries < 0 || r->in.num_entries > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sids);
		ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumAccounts(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumAccounts *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccounts");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccounts");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccounts");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CreateTrustedDomain(struct ndr_push *ndr, int flags, const struct lsa_CreateTrustedDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.info == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CreateTrustedDomain(struct ndr_pull *ndr, int flags, struct lsa_CreateTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_trustdom_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomain(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CreateTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_lsa_DomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumTrustDom(struct ndr_push *ndr, int flags, const struct lsa_EnumTrustDom *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.domains == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_DomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumTrustDom(struct ndr_pull *ndr, int flags, struct lsa_EnumTrustDom *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_domains_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		if (r->in.max_size < 0 || r->in.max_size > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.domains);
		ZERO_STRUCTP(r->out.domains);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumTrustDom(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumTrustDom *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumTrustDom");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumTrustDom");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumTrustDom");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_lsa_DomainList(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupNames(struct ndr_push *ndr, int flags, const struct lsa_LookupNames *r)
{
	uint32_t cntr_names_0;
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupNames(struct ndr_pull *ndr, int flags, struct lsa_LookupNames *r)
{
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names < 0 || r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_PULL_ALLOC_N(ndr, r->in.names, ndr_get_array_size(ndr, &r->in.names));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupNames(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupNames *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->in.num_names);
		ndr->depth++;
		for (cntr_names_0=0;cntr_names_0<r->in.num_names;cntr_names_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_names_0);
			if (idx_0) {
				ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupSids(struct ndr_push *ndr, int flags, const struct lsa_LookupSids *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		if (r->in.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupSids(struct ndr_pull *ndr, int flags, struct lsa_LookupSids *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupSids(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupSids *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CreateSecret(struct ndr_push *ndr, int flags, const struct lsa_CreateSecret *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.sec_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sec_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CreateSecret(struct ndr_pull *ndr, int flags, struct lsa_CreateSecret *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sec_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		ZERO_STRUCTP(r->out.sec_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CreateSecret(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CreateSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateSecret");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenAccount(struct ndr_push *ndr, int flags, const struct lsa_OpenAccount *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.acct_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.acct_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenAccount(struct ndr_pull *ndr, int flags, struct lsa_OpenAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_acct_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		ZERO_STRUCTP(r->out.acct_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.acct_handle);
		}
		_mem_save_acct_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.acct_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.acct_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "acct_handle", r->out.acct_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumPrivsAccount(struct ndr_push *ndr, int flags, const struct lsa_EnumPrivsAccount *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.privs));
		if (r->out.privs) {
			NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->out.privs));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumPrivsAccount(struct ndr_pull *ndr, int flags, struct lsa_EnumPrivsAccount *r)
{
	uint32_t _ptr_privs;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_privs_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, r->out.privs);
		} else {
			r->out.privs = NULL;
		}
		if (r->out.privs) {
			_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.privs, 0);
			NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->out.privs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumPrivsAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumPrivsAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumPrivsAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumPrivsAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumPrivsAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "privs", r->out.privs);
		ndr->depth++;
		if (r->out.privs) {
			ndr_print_lsa_PrivilegeSet(ndr, "privs", r->out.privs);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AddPrivilegesToAccount(struct ndr_push *ndr, int flags, const struct lsa_AddPrivilegesToAccount *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.privs == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AddPrivilegesToAccount(struct ndr_pull *ndr, int flags, struct lsa_AddPrivilegesToAccount *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_privs_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.privs);
		}
		_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.privs, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AddPrivilegesToAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_AddPrivilegesToAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_AddPrivilegesToAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_AddPrivilegesToAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "privs", r->in.privs);
		ndr->depth++;
		ndr_print_lsa_PrivilegeSet(ndr, "privs", r->in.privs);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_AddPrivilegesToAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_RemovePrivilegesFromAccount(struct ndr_push *ndr, int flags, const struct lsa_RemovePrivilegesFromAccount *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.remove_all));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.privs));
		if (r->in.privs) {
			NDR_CHECK(ndr_push_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_RemovePrivilegesFromAccount(struct ndr_pull *ndr, int flags, struct lsa_RemovePrivilegesFromAccount *r)
{
	uint32_t _ptr_privs;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_privs_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.remove_all));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privs));
		if (_ptr_privs) {
			NDR_PULL_ALLOC(ndr, r->in.privs);
		} else {
			r->in.privs = NULL;
		}
		if (r->in.privs) {
			_mem_save_privs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.privs, 0);
			NDR_CHECK(ndr_pull_lsa_PrivilegeSet(ndr, NDR_SCALARS, r->in.privs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privs_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_RemovePrivilegesFromAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_RemovePrivilegesFromAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_RemovePrivilegesFromAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RemovePrivilegesFromAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint8(ndr, "remove_all", r->in.remove_all);
		ndr_print_ptr(ndr, "privs", r->in.privs);
		ndr->depth++;
		if (r->in.privs) {
			ndr_print_lsa_PrivilegeSet(ndr, "privs", r->in.privs);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RemovePrivilegesFromAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_GetQuotasForAccount(struct ndr_push *ndr, int flags, const struct lsa_GetQuotasForAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_GetQuotasForAccount(struct ndr_pull *ndr, int flags, struct lsa_GetQuotasForAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_GetQuotasForAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_GetQuotasForAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_GetQuotasForAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetQuotasForAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetQuotasForAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetQuotasForAccount(struct ndr_push *ndr, int flags, const struct lsa_SetQuotasForAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetQuotasForAccount(struct ndr_pull *ndr, int flags, struct lsa_SetQuotasForAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetQuotasForAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetQuotasForAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_SetQuotasForAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetQuotasForAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetQuotasForAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_GetSystemAccessAccount(struct ndr_push *ndr, int flags, const struct lsa_GetSystemAccessAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_GetSystemAccessAccount(struct ndr_pull *ndr, int flags, struct lsa_GetSystemAccessAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_GetSystemAccessAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_GetSystemAccessAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_GetSystemAccessAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetSystemAccessAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetSystemAccessAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetSystemAccessAccount(struct ndr_push *ndr, int flags, const struct lsa_SetSystemAccessAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetSystemAccessAccount(struct ndr_pull *ndr, int flags, struct lsa_SetSystemAccessAccount *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetSystemAccessAccount(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetSystemAccessAccount *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSystemAccessAccount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSystemAccessAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSystemAccessAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenTrustedDomain(struct ndr_push *ndr, int flags, const struct lsa_OpenTrustedDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenTrustedDomain(struct ndr_pull *ndr, int flags, struct lsa_OpenTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_trustdom_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenTrustedDomain(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenTrustedDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryTrustedDomainInfo(struct ndr_push *ndr, int flags, const struct lsa_QueryTrustedDomainInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.trustdom_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trustdom_handle));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryTrustedDomainInfo(struct ndr_pull *ndr, int flags, struct lsa_QueryTrustedDomainInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_trustdom_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfo(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryTrustedDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->in.trustdom_handle);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetInformationTrustedDomain(struct ndr_push *ndr, int flags, const struct lsa_SetInformationTrustedDomain *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetInformationTrustedDomain(struct ndr_pull *ndr, int flags, struct lsa_SetInformationTrustedDomain *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetInformationTrustedDomain(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetInformationTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInformationTrustedDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInformationTrustedDomain");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInformationTrustedDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenSecret(struct ndr_push *ndr, int flags, const struct lsa_OpenSecret *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.sec_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sec_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenSecret(struct ndr_pull *ndr, int flags, struct lsa_OpenSecret *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sec_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		ZERO_STRUCTP(r->out.sec_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenSecret(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenSecret");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->out.sec_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetSecret(struct ndr_push *ndr, int flags, const struct lsa_SetSecret *r)
{
	if (flags & NDR_IN) {
		if (r->in.sec_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_val));
		if (r->in.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_val));
		if (r->in.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetSecret(struct ndr_pull *ndr, int flags, struct lsa_SetSecret *r)
{
	uint32_t _ptr_new_val;
	uint32_t _ptr_old_val;
	TALLOC_CTX *_mem_save_sec_handle_0;
	TALLOC_CTX *_mem_save_new_val_0;
	TALLOC_CTX *_mem_save_old_val_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->in.new_val);
		} else {
			r->in.new_val = NULL;
		}
		if (r->in.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->in.old_val);
		} else {
			r->in.old_val = NULL;
		}
		if (r->in.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetSecret(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetSecret *r)
{
	ndr_print_struct(ndr, name, "lsa_SetSecret");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetSecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_val", r->in.new_val);
		ndr->depth++;
		if (r->in.new_val) {
			ndr_print_lsa_DATA_BUF(ndr, "new_val", r->in.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->in.old_val);
		ndr->depth++;
		if (r->in.old_val) {
			ndr_print_lsa_DATA_BUF(ndr, "old_val", r->in.old_val);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetSecret");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QuerySecret(struct ndr_push *ndr, int flags, const struct lsa_QuerySecret *r)
{
	if (flags & NDR_IN) {
		if (r->in.sec_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_val));
		if (r->in.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_mtime));
		if (r->in.new_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->in.new_mtime));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_val));
		if (r->in.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_mtime));
		if (r->in.old_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->in.old_mtime));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.new_val));
		if (r->out.new_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.new_mtime));
		if (r->out.new_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->out.new_mtime));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.old_val));
		if (r->out.old_val) {
			NDR_CHECK(ndr_push_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.old_val));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.old_mtime));
		if (r->out.old_mtime) {
			NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, *r->out.old_mtime));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QuerySecret(struct ndr_pull *ndr, int flags, struct lsa_QuerySecret *r)
{
	uint32_t _ptr_new_val;
	uint32_t _ptr_new_mtime;
	uint32_t _ptr_old_val;
	uint32_t _ptr_old_mtime;
	TALLOC_CTX *_mem_save_sec_handle_0;
	TALLOC_CTX *_mem_save_new_val_0;
	TALLOC_CTX *_mem_save_new_mtime_0;
	TALLOC_CTX *_mem_save_old_val_0;
	TALLOC_CTX *_mem_save_old_mtime_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sec_handle);
		}
		_mem_save_sec_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sec_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->in.new_val);
		} else {
			r->in.new_val = NULL;
		}
		if (r->in.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_mtime));
		if (_ptr_new_mtime) {
			NDR_PULL_ALLOC(ndr, r->in.new_mtime);
		} else {
			r->in.new_mtime = NULL;
		}
		if (r->in.new_mtime) {
			_mem_save_new_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->in.new_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->in.old_val);
		} else {
			r->in.old_val = NULL;
		}
		if (r->in.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_mtime));
		if (_ptr_old_mtime) {
			NDR_PULL_ALLOC(ndr, r->in.old_mtime);
		} else {
			r->in.old_mtime = NULL;
		}
		if (r->in.old_mtime) {
			_mem_save_old_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->in.old_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_mtime_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_val));
		if (_ptr_new_val) {
			NDR_PULL_ALLOC(ndr, r->out.new_val);
		} else {
			r->out.new_val = NULL;
		}
		if (r->out.new_val) {
			_mem_save_new_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.new_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_mtime));
		if (_ptr_new_mtime) {
			NDR_PULL_ALLOC(ndr, r->out.new_mtime);
		} else {
			r->out.new_mtime = NULL;
		}
		if (r->out.new_mtime) {
			_mem_save_new_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.new_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->out.new_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_val));
		if (_ptr_old_val) {
			NDR_PULL_ALLOC(ndr, r->out.old_val);
		} else {
			r->out.old_val = NULL;
		}
		if (r->out.old_val) {
			_mem_save_old_val_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.old_val, 0);
			NDR_CHECK(ndr_pull_lsa_DATA_BUF_PTR(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.old_val));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_val_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_mtime));
		if (_ptr_old_mtime) {
			NDR_PULL_ALLOC(ndr, r->out.old_mtime);
		} else {
			r->out.old_mtime = NULL;
		}
		if (r->out.old_mtime) {
			_mem_save_old_mtime_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.old_mtime, 0);
			NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, r->out.old_mtime));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_mtime_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QuerySecret(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QuerySecret *r)
{
	ndr_print_struct(ndr, name, "lsa_QuerySecret");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QuerySecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "sec_handle", r->in.sec_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_val", r->in.new_val);
		ndr->depth++;
		if (r->in.new_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "new_val", r->in.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_mtime", r->in.new_mtime);
		ndr->depth++;
		if (r->in.new_mtime) {
			ndr_print_NTTIME_hyper(ndr, "new_mtime", *r->in.new_mtime);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->in.old_val);
		ndr->depth++;
		if (r->in.old_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "old_val", r->in.old_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_mtime", r->in.old_mtime);
		ndr->depth++;
		if (r->in.old_mtime) {
			ndr_print_NTTIME_hyper(ndr, "old_mtime", *r->in.old_mtime);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QuerySecret");
		ndr->depth++;
		ndr_print_ptr(ndr, "new_val", r->out.new_val);
		ndr->depth++;
		if (r->out.new_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "new_val", r->out.new_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_mtime", r->out.new_mtime);
		ndr->depth++;
		if (r->out.new_mtime) {
			ndr_print_NTTIME_hyper(ndr, "new_mtime", *r->out.new_mtime);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_val", r->out.old_val);
		ndr->depth++;
		if (r->out.old_val) {
			ndr_print_lsa_DATA_BUF_PTR(ndr, "old_val", r->out.old_val);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "old_mtime", r->out.old_mtime);
		ndr->depth++;
		if (r->out.old_mtime) {
			ndr_print_NTTIME_hyper(ndr, "old_mtime", *r->out.old_mtime);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupPrivValue(struct ndr_push *ndr, int flags, const struct lsa_LookupPrivValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.name == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
	}
	if (flags & NDR_OUT) {
		if (r->out.luid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, r->out.luid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupPrivValue(struct ndr_pull *ndr, int flags, struct lsa_LookupPrivValue *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_luid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.luid);
		ZERO_STRUCTP(r->out.luid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.luid);
		}
		_mem_save_luid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.luid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, r->out.luid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_luid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivValue(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupPrivValue *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "luid", r->out.luid);
		ndr->depth++;
		ndr_print_lsa_LUID(ndr, "luid", r->out.luid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupPrivName(struct ndr_push *ndr, int flags, const struct lsa_LookupPrivName *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.luid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_LUID(ndr, NDR_SCALARS, r->in.luid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.name));
		if (r->out.name) {
			NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupPrivName(struct ndr_pull *ndr, int flags, struct lsa_LookupPrivName *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_luid_0;
	TALLOC_CTX *_mem_save_name_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.luid);
		}
		_mem_save_luid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.luid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_LUID(ndr, NDR_SCALARS, r->in.luid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_luid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		} else {
			r->out.name = NULL;
		}
		if (r->out.name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.name, 0);
			NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupPrivName *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "luid", r->in.luid);
		ndr->depth++;
		ndr_print_lsa_LUID(ndr, "luid", r->in.luid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivName");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		if (r->out.name) {
			ndr_print_lsa_StringLarge(ndr, "name", r->out.name);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupPrivDisplayName(struct ndr_push *ndr, int flags, const struct lsa_LookupPrivDisplayName *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.name == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		if (r->in.language_id == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.language_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.unknown));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.disp_name));
		if (r->out.disp_name) {
			NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.disp_name));
		}
		if (r->out.language_id == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.language_id));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupPrivDisplayName(struct ndr_pull *ndr, int flags, struct lsa_LookupPrivDisplayName *r)
{
	uint32_t _ptr_disp_name;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_disp_name_0;
	TALLOC_CTX *_mem_save_language_id_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.language_id);
		}
		_mem_save_language_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.language_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.language_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_language_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_PULL_ALLOC(ndr, r->out.language_id);
		*r->out.language_id = *r->in.language_id;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_disp_name));
		if (_ptr_disp_name) {
			NDR_PULL_ALLOC(ndr, r->out.disp_name);
		} else {
			r->out.disp_name = NULL;
		}
		if (r->out.disp_name) {
			_mem_save_disp_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.disp_name, 0);
			NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.disp_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_disp_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.language_id);
		}
		_mem_save_language_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.language_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.language_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_language_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupPrivDisplayName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupPrivDisplayName *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupPrivDisplayName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupPrivDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "language_id", r->in.language_id);
		ndr->depth++;
		ndr_print_uint16(ndr, "language_id", *r->in.language_id);
		ndr->depth--;
		ndr_print_uint16(ndr, "unknown", r->in.unknown);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupPrivDisplayName");
		ndr->depth++;
		ndr_print_ptr(ndr, "disp_name", r->out.disp_name);
		ndr->depth++;
		if (r->out.disp_name) {
			ndr_print_lsa_StringLarge(ndr, "disp_name", r->out.disp_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "language_id", r->out.language_id);
		ndr->depth++;
		ndr_print_uint16(ndr, "language_id", *r->out.language_id);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DeleteObject(struct ndr_push *ndr, int flags, const struct lsa_DeleteObject *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DeleteObject(struct ndr_pull *ndr, int flags, struct lsa_DeleteObject *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DeleteObject(struct ndr_print *ndr, const char *name, int flags, const struct lsa_DeleteObject *r)
{
	ndr_print_struct(ndr, name, "lsa_DeleteObject");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_DeleteObject");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_DeleteObject");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumAccountsWithUserRight(struct ndr_push *ndr, int flags, const struct lsa_EnumAccountsWithUserRight *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.name));
		if (r->in.name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumAccountsWithUserRight(struct ndr_pull *ndr, int flags, struct lsa_EnumAccountsWithUserRight *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		} else {
			r->in.name = NULL;
		}
		if (r->in.name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.sids);
		ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumAccountsWithUserRight(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumAccountsWithUserRight *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccountsWithUserRight");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccountsWithUserRight");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		if (r->in.name) {
			ndr_print_lsa_String(ndr, "name", r->in.name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccountsWithUserRight");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumAccountRights(struct ndr_push *ndr, int flags, const struct lsa_EnumAccountRights *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.rights == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rights));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumAccountRights(struct ndr_pull *ndr, int flags, struct lsa_EnumAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_rights_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rights);
		ZERO_STRUCTP(r->out.rights);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumAccountRights(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumAccountRights");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "rights", r->out.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->out.rights);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_AddAccountRights(struct ndr_push *ndr, int flags, const struct lsa_AddAccountRights *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		if (r->in.rights == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_AddAccountRights(struct ndr_pull *ndr, int flags, struct lsa_AddAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_rights_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_AddAccountRights(struct ndr_print *ndr, const char *name, int flags, const struct lsa_AddAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_AddAccountRights");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_AddAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_ptr(ndr, "rights", r->in.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->in.rights);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_AddAccountRights");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_RemoveAccountRights(struct ndr_push *ndr, int flags, const struct lsa_RemoveAccountRights *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		if (r->in.rights == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_RemoveAccountRights(struct ndr_pull *ndr, int flags, struct lsa_RemoveAccountRights *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_rights_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rights);
		}
		_mem_save_rights_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rights, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RightSet(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.rights));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rights_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_RemoveAccountRights(struct ndr_print *ndr, const char *name, int flags, const struct lsa_RemoveAccountRights *r)
{
	ndr_print_struct(ndr, name, "lsa_RemoveAccountRights");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RemoveAccountRights");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_ptr(ndr, "rights", r->in.rights);
		ndr->depth++;
		ndr_print_lsa_RightSet(ndr, "rights", r->in.rights);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RemoveAccountRights");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryTrustedDomainInfoBySid(struct ndr_push *ndr, int flags, const struct lsa_QueryTrustedDomainInfoBySid *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.dom_sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryTrustedDomainInfoBySid(struct ndr_pull *ndr, int flags, struct lsa_QueryTrustedDomainInfoBySid *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_dom_sid_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		}
		_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfoBySid(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryTrustedDomainInfoBySid *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfoBySid");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfoBySid");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth--;
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfoBySid");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetTrustedDomainInfo(struct ndr_push *ndr, int flags, const struct lsa_SetTrustedDomainInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetTrustedDomainInfo(struct ndr_pull *ndr, int flags, struct lsa_SetTrustedDomainInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetTrustedDomainInfo(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetTrustedDomainInfo *r)
{
	ndr_print_struct(ndr, name, "lsa_SetTrustedDomainInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetTrustedDomainInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetTrustedDomainInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_DeleteTrustedDomain(struct ndr_push *ndr, int flags, const struct lsa_DeleteTrustedDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.dom_sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_DeleteTrustedDomain(struct ndr_pull *ndr, int flags, struct lsa_DeleteTrustedDomain *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_dom_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dom_sid);
		}
		_mem_save_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dom_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dom_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_DeleteTrustedDomain(struct ndr_print *ndr, const char *name, int flags, const struct lsa_DeleteTrustedDomain *r)
{
	ndr_print_struct(ndr, name, "lsa_DeleteTrustedDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_DeleteTrustedDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "dom_sid", r->in.dom_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_DeleteTrustedDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_StorePrivateData(struct ndr_push *ndr, int flags, const struct lsa_StorePrivateData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_StorePrivateData(struct ndr_pull *ndr, int flags, struct lsa_StorePrivateData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_StorePrivateData(struct ndr_print *ndr, const char *name, int flags, const struct lsa_StorePrivateData *r)
{
	ndr_print_struct(ndr, name, "lsa_StorePrivateData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_StorePrivateData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_StorePrivateData");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_RetrievePrivateData(struct ndr_push *ndr, int flags, const struct lsa_RetrievePrivateData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_RetrievePrivateData(struct ndr_pull *ndr, int flags, struct lsa_RetrievePrivateData *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_RetrievePrivateData(struct ndr_print *ndr, const char *name, int flags, const struct lsa_RetrievePrivateData *r)
{
	ndr_print_struct(ndr, name, "lsa_RetrievePrivateData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_RetrievePrivateData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_RetrievePrivateData");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenPolicy2(struct ndr_push *ndr, int flags, const struct lsa_OpenPolicy2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.attr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenPolicy2(struct ndr_pull *ndr, int flags, struct lsa_OpenPolicy2 *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_attr_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.attr);
		}
		_mem_save_attr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.attr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_ObjectAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.attr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenPolicy2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenPolicy2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "attr", r->in.attr);
		ndr->depth++;
		ndr_print_lsa_ObjectAttribute(ndr, "attr", r->in.attr);
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_GetUserName(struct ndr_push *ndr, int flags, const struct lsa_GetUserName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.account_name));
		if (r->in.account_name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.authority_name));
		if (r->in.authority_name) {
			NDR_CHECK(ndr_push_lsa_StringPointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.authority_name));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.account_name));
		if (r->out.account_name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.account_name));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.authority_name));
		if (r->out.authority_name) {
			NDR_CHECK(ndr_push_lsa_StringPointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.authority_name));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_GetUserName(struct ndr_pull *ndr, int flags, struct lsa_GetUserName *r)
{
	uint32_t _ptr_system_name;
	uint32_t _ptr_account_name;
	uint32_t _ptr_authority_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_account_name_0;
	TALLOC_CTX *_mem_save_authority_name_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
		} else {
			r->in.account_name = NULL;
		}
		if (r->in.account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.account_name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
		if (_ptr_authority_name) {
			NDR_PULL_ALLOC(ndr, r->in.authority_name);
		} else {
			r->in.authority_name = NULL;
		}
		if (r->in.authority_name) {
			_mem_save_authority_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.authority_name, 0);
			NDR_CHECK(ndr_pull_lsa_StringPointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.authority_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->out.account_name);
		} else {
			r->out.account_name = NULL;
		}
		if (r->out.account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.account_name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.account_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_authority_name));
		if (_ptr_authority_name) {
			NDR_PULL_ALLOC(ndr, r->out.authority_name);
		} else {
			r->out.authority_name = NULL;
		}
		if (r->out.authority_name) {
			_mem_save_authority_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.authority_name, 0);
			NDR_CHECK(ndr_pull_lsa_StringPointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.authority_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authority_name_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_GetUserName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_GetUserName *r)
{
	ndr_print_struct(ndr, name, "lsa_GetUserName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_GetUserName");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		if (r->in.account_name) {
			ndr_print_lsa_String(ndr, "account_name", r->in.account_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "authority_name", r->in.authority_name);
		ndr->depth++;
		if (r->in.authority_name) {
			ndr_print_lsa_StringPointer(ndr, "authority_name", r->in.authority_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_GetUserName");
		ndr->depth++;
		ndr_print_ptr(ndr, "account_name", r->out.account_name);
		ndr->depth++;
		if (r->out.account_name) {
			ndr_print_lsa_String(ndr, "account_name", r->out.account_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "authority_name", r->out.authority_name);
		ndr->depth++;
		if (r->out.authority_name) {
			ndr_print_lsa_StringPointer(ndr, "authority_name", r->out.authority_name);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryInfoPolicy2(struct ndr_push *ndr, int flags, const struct lsa_QueryInfoPolicy2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryInfoPolicy2(struct ndr_pull *ndr, int flags, struct lsa_QueryInfoPolicy2 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_PolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryInfoPolicy2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryInfoPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryInfoPolicy2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryInfoPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryInfoPolicy2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_PolicyInformation(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetInfoPolicy2(struct ndr_push *ndr, int flags, const struct lsa_SetInfoPolicy2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetInfoPolicy2(struct ndr_pull *ndr, int flags, struct lsa_SetInfoPolicy2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetInfoPolicy2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetInfoPolicy2 *r)
{
	ndr_print_struct(ndr, name, "lsa_SetInfoPolicy2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetInfoPolicy2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetInfoPolicy2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryTrustedDomainInfoByName(struct ndr_push *ndr, int flags, const struct lsa_QueryTrustedDomainInfoByName *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.trusted_domain));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryTrustedDomainInfoByName(struct ndr_pull *ndr, int flags, struct lsa_QueryTrustedDomainInfoByName *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.trusted_domain));
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryTrustedDomainInfoByName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryTrustedDomainInfoByName *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryTrustedDomainInfoByName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "trusted_domain", &r->in.trusted_domain);
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetTrustedDomainInfoByName(struct ndr_push *ndr, int flags, const struct lsa_SetTrustedDomainInfoByName *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.trusted_domain));
		NDR_CHECK(ndr_push_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetTrustedDomainInfoByName(struct ndr_pull *ndr, int flags, struct lsa_SetTrustedDomainInfoByName *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.trusted_domain));
		NDR_CHECK(ndr_pull_lsa_TrustDomInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_TrustedDomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetTrustedDomainInfoByName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetTrustedDomainInfoByName *r)
{
	ndr_print_struct(ndr, name, "lsa_SetTrustedDomainInfoByName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "trusted_domain", &r->in.trusted_domain);
		ndr_print_lsa_TrustDomInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
			ndr_print_lsa_TrustedDomainInfo(ndr, "info", r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetTrustedDomainInfoByName");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_EnumTrustedDomainsEx(struct ndr_push *ndr, int flags, const struct lsa_EnumTrustedDomainsEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.domains == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_DomainListEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_EnumTrustedDomainsEx(struct ndr_pull *ndr, int flags, struct lsa_EnumTrustedDomainsEx *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_domains_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.domains);
		ZERO_STRUCTP(r->out.domains);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_DomainListEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_EnumTrustedDomainsEx(struct ndr_print *ndr, const char *name, int flags, const struct lsa_EnumTrustedDomainsEx *r)
{
	ndr_print_struct(ndr, name, "lsa_EnumTrustedDomainsEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_EnumTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_EnumTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_lsa_DomainListEx(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CreateTrustedDomainEx(struct ndr_push *ndr, int flags, const struct lsa_CreateTrustedDomainEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CreateTrustedDomainEx(struct ndr_pull *ndr, int flags, struct lsa_CreateTrustedDomainEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomainEx(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CreateTrustedDomainEx *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomainEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomainEx");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomainEx");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CloseTrustedDomainEx(struct ndr_push *ndr, int flags, const struct lsa_CloseTrustedDomainEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CloseTrustedDomainEx(struct ndr_pull *ndr, int flags, struct lsa_CloseTrustedDomainEx *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CloseTrustedDomainEx(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CloseTrustedDomainEx *r)
{
	ndr_print_struct(ndr, name, "lsa_CloseTrustedDomainEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CloseTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CloseTrustedDomainEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_QueryDomainInformationPolicy(struct ndr_push *ndr, int flags, const struct lsa_QueryDomainInformationPolicy *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_QueryDomainInformationPolicy(struct ndr_pull *ndr, int flags, struct lsa_QueryDomainInformationPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_QueryDomainInformationPolicy(struct ndr_print *ndr, const char *name, int flags, const struct lsa_QueryDomainInformationPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_QueryDomainInformationPolicy");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_QueryDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_QueryDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_lsa_DomainInformationPolicy(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_SetDomainInformationPolicy(struct ndr_push *ndr, int flags, const struct lsa_SetDomainInformationPolicy *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_push_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_SetDomainInformationPolicy(struct ndr_pull *ndr, int flags, struct lsa_SetDomainInformationPolicy *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
			NDR_CHECK(ndr_pull_lsa_DomainInformationPolicy(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_SetDomainInformationPolicy(struct ndr_print *ndr, const char *name, int flags, const struct lsa_SetDomainInformationPolicy *r)
{
	ndr_print_struct(ndr, name, "lsa_SetDomainInformationPolicy");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_SetDomainInformationPolicy");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
			ndr_print_lsa_DomainInformationPolicy(ndr, "info", r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_SetDomainInformationPolicy");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_OpenTrustedDomainByName(struct ndr_push *ndr, int flags, const struct lsa_OpenTrustedDomainByName *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.trustdom_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_OpenTrustedDomainByName(struct ndr_pull *ndr, int flags, struct lsa_OpenTrustedDomainByName *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_trustdom_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		ZERO_STRUCTP(r->out.trustdom_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trustdom_handle);
		}
		_mem_save_trustdom_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trustdom_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trustdom_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trustdom_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_OpenTrustedDomainByName(struct ndr_print *ndr, const char *name, int flags, const struct lsa_OpenTrustedDomainByName *r)
{
	ndr_print_struct(ndr, name, "lsa_OpenTrustedDomainByName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_OpenTrustedDomainByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_lsa_String(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_OpenTrustedDomainByName");
		ndr->depth++;
		ndr_print_ptr(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "trustdom_handle", r->out.trustdom_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_TestCall(struct ndr_push *ndr, int flags, const struct lsa_TestCall *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_TestCall(struct ndr_pull *ndr, int flags, struct lsa_TestCall *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_TestCall(struct ndr_print *ndr, const char *name, int flags, const struct lsa_TestCall *r)
{
	ndr_print_struct(ndr, name, "lsa_TestCall");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_TestCall");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_TestCall");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupSids2(struct ndr_push *ndr, int flags, const struct lsa_LookupSids2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		if (r->in.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupSids2(struct ndr_pull *ndr, int flags, struct lsa_LookupSids2 *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupSids2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupSids2 *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupNames2(struct ndr_push *ndr, int flags, const struct lsa_LookupNames2 *r)
{
	uint32_t cntr_names_0;
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupNames2(struct ndr_pull *ndr, int flags, struct lsa_LookupNames2 *r)
{
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names < 0 || r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_PULL_ALLOC_N(ndr, r->in.names, ndr_get_array_size(ndr, &r->in.names));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupNames2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupNames2 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->in.num_names);
		ndr->depth++;
		for (cntr_names_0=0;cntr_names_0<r->in.num_names;cntr_names_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_names_0);
			if (idx_0) {
				ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray2(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray2(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CreateTrustedDomainEx2(struct ndr_push *ndr, int flags, const struct lsa_CreateTrustedDomainEx2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CreateTrustedDomainEx2(struct ndr_pull *ndr, int flags, struct lsa_CreateTrustedDomainEx2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CreateTrustedDomainEx2(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CreateTrustedDomainEx2 *r)
{
	ndr_print_struct(ndr, name, "lsa_CreateTrustedDomainEx2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CreateTrustedDomainEx2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CreateTrustedDomainEx2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRWRITE(struct ndr_push *ndr, int flags, const struct lsa_CREDRWRITE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRWRITE(struct ndr_pull *ndr, int flags, struct lsa_CREDRWRITE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRWRITE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRWRITE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRWRITE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRWRITE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRWRITE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRREAD(struct ndr_push *ndr, int flags, const struct lsa_CREDRREAD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRREAD(struct ndr_pull *ndr, int flags, struct lsa_CREDRREAD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRREAD(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRREAD *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRREAD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRREAD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRREAD");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRENUMERATE(struct ndr_push *ndr, int flags, const struct lsa_CREDRENUMERATE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRENUMERATE(struct ndr_pull *ndr, int flags, struct lsa_CREDRENUMERATE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRENUMERATE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRENUMERATE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRENUMERATE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRENUMERATE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRENUMERATE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_push *ndr, int flags, const struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_pull *ndr, int flags, struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRWRITEDOMAINCREDENTIALS");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRWRITEDOMAINCREDENTIALS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRWRITEDOMAINCREDENTIALS");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_push *ndr, int flags, const struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_pull *ndr, int flags, struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRREADDOMAINCREDENTIALS(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRREADDOMAINCREDENTIALS");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRREADDOMAINCREDENTIALS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRREADDOMAINCREDENTIALS");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRDELETE(struct ndr_push *ndr, int flags, const struct lsa_CREDRDELETE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRDELETE(struct ndr_pull *ndr, int flags, struct lsa_CREDRDELETE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRDELETE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRDELETE *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRDELETE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRDELETE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRDELETE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRGETTARGETINFO(struct ndr_push *ndr, int flags, const struct lsa_CREDRGETTARGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRGETTARGETINFO(struct ndr_pull *ndr, int flags, struct lsa_CREDRGETTARGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRGETTARGETINFO(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRGETTARGETINFO *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRGETTARGETINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRGETTARGETINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRGETTARGETINFO");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRPROFILELOADED(struct ndr_push *ndr, int flags, const struct lsa_CREDRPROFILELOADED *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRPROFILELOADED(struct ndr_pull *ndr, int flags, struct lsa_CREDRPROFILELOADED *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRPROFILELOADED(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRPROFILELOADED *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRPROFILELOADED");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRPROFILELOADED");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRPROFILELOADED");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupNames3(struct ndr_push *ndr, int flags, const struct lsa_LookupNames3 *r)
{
	uint32_t cntr_names_0;
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupNames3(struct ndr_pull *ndr, int flags, struct lsa_LookupNames3 *r)
{
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names < 0 || r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_PULL_ALLOC_N(ndr, r->in.names, ndr_get_array_size(ndr, &r->in.names));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupNames3(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupNames3 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames3");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames3");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->in.num_names);
		ndr->depth++;
		for (cntr_names_0=0;cntr_names_0<r->in.num_names;cntr_names_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_names_0);
			if (idx_0) {
				ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames3");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRGETSESSIONTYPES(struct ndr_push *ndr, int flags, const struct lsa_CREDRGETSESSIONTYPES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRGETSESSIONTYPES(struct ndr_pull *ndr, int flags, struct lsa_CREDRGETSESSIONTYPES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRGETSESSIONTYPES(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRGETSESSIONTYPES *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRGETSESSIONTYPES");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRGETSESSIONTYPES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRGETSESSIONTYPES");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARREGISTERAUDITEVENT(struct ndr_push *ndr, int flags, const struct lsa_LSARREGISTERAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARREGISTERAUDITEVENT(struct ndr_pull *ndr, int flags, struct lsa_LSARREGISTERAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARREGISTERAUDITEVENT(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARREGISTERAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARREGISTERAUDITEVENT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARREGISTERAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARREGISTERAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARGENAUDITEVENT(struct ndr_push *ndr, int flags, const struct lsa_LSARGENAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARGENAUDITEVENT(struct ndr_pull *ndr, int flags, struct lsa_LSARGENAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARGENAUDITEVENT(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARGENAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARGENAUDITEVENT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARGENAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARGENAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_push *ndr, int flags, const struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_pull *ndr, int flags, struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARUNREGISTERAUDITEVENT(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARUNREGISTERAUDITEVENT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARUNREGISTERAUDITEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARUNREGISTERAUDITEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARQUERYFORESTTRUSTINFORMATION(struct ndr_push *ndr, int flags, const struct lsa_LSARQUERYFORESTTRUSTINFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARQUERYFORESTTRUSTINFORMATION(struct ndr_pull *ndr, int flags, struct lsa_LSARQUERYFORESTTRUSTINFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARQUERYFORESTTRUSTINFORMATION(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARQUERYFORESTTRUSTINFORMATION *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARQUERYFORESTTRUSTINFORMATION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARQUERYFORESTTRUSTINFORMATION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARQUERYFORESTTRUSTINFORMATION");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARSETFORESTTRUSTINFORMATION(struct ndr_push *ndr, int flags, const struct lsa_LSARSETFORESTTRUSTINFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARSETFORESTTRUSTINFORMATION(struct ndr_pull *ndr, int flags, struct lsa_LSARSETFORESTTRUSTINFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARSETFORESTTRUSTINFORMATION(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARSETFORESTTRUSTINFORMATION *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARSETFORESTTRUSTINFORMATION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARSETFORESTTRUSTINFORMATION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARSETFORESTTRUSTINFORMATION");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_CREDRRENAME(struct ndr_push *ndr, int flags, const struct lsa_CREDRRENAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_CREDRRENAME(struct ndr_pull *ndr, int flags, struct lsa_CREDRRENAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_CREDRRENAME(struct ndr_print *ndr, const char *name, int flags, const struct lsa_CREDRRENAME *r)
{
	ndr_print_struct(ndr, name, "lsa_CREDRRENAME");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_CREDRRENAME");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_CREDRRENAME");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupSids3(struct ndr_push *ndr, int flags, const struct lsa_LookupSids3 *r)
{
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		if (r->in.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.names == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupSids3(struct ndr_pull *ndr, int flags, struct lsa_LookupSids3 *r)
{
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.names);
		*r->out.names = *r->in.names;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupSids3(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupSids3 *r)
{
	ndr_print_struct(ndr, name, "lsa_LookupSids3");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupSids3");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->in.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->in.names);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupSids3");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray2(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LookupNames4(struct ndr_push *ndr, int flags, const struct lsa_LookupNames4 *r)
{
	uint32_t cntr_names_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		if (r->in.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.domains));
		if (r->out.domains) {
			NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		}
		if (r->out.sids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		if (r->out.count == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LookupNames4(struct ndr_pull *ndr, int flags, struct lsa_LookupNames4 *r)
{
	uint32_t cntr_names_0;
	uint32_t _ptr_domains;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_domains_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names < 0 || r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_PULL_ALLOC_N(ndr, r->in.names, ndr_get_array_size(ndr, &r->in.names));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.sids);
		*r->out.sids = *r->in.sids;
		NDR_PULL_ALLOC(ndr, r->out.count);
		*r->out.count = *r->in.count;
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, r->in.num_names));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domains));
		if (_ptr_domains) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		} else {
			r->out.domains = NULL;
		}
		if (r->out.domains) {
			_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, 0);
			NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransSidArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LookupNames4(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LookupNames4 *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "lsa_LookupNames4");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LookupNames4");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->in.num_names);
		ndr->depth++;
		for (cntr_names_0=0;cntr_names_0<r->in.num_names;cntr_names_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_names_0);
			if (idx_0) {
				ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "count", r->in.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->in.count);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LookupNames4");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		if (r->out.domains) {
			ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_TransSidArray3(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSAROPENPOLICYSCE(struct ndr_push *ndr, int flags, const struct lsa_LSAROPENPOLICYSCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSAROPENPOLICYSCE(struct ndr_pull *ndr, int flags, struct lsa_LSAROPENPOLICYSCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSAROPENPOLICYSCE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSAROPENPOLICYSCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSAROPENPOLICYSCE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSAROPENPOLICYSCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSAROPENPOLICYSCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_push *ndr, int flags, const struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_pull *ndr, int flags, struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_push *ndr, int flags, const struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_pull *ndr, int flags, struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_push *ndr, int flags, const struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_pull *ndr, int flags, struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_lsa_LSARADTREPORTSECURITYEVENT(struct ndr_print *ndr, const char *name, int flags, const struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	ndr_print_struct(ndr, name, "lsa_LSARADTREPORTSECURITYEVENT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "lsa_LSARADTREPORTSECURITYEVENT");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "lsa_LSARADTREPORTSECURITYEVENT");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call lsarpc_calls[] = {
	{
		"lsa_Close",
		sizeof(struct lsa_Close),
		(ndr_push_flags_fn_t) ndr_push_lsa_Close,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Close,
		(ndr_print_function_t) ndr_print_lsa_Close,
		False,
	},
	{
		"lsa_Delete",
		sizeof(struct lsa_Delete),
		(ndr_push_flags_fn_t) ndr_push_lsa_Delete,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_Delete,
		(ndr_print_function_t) ndr_print_lsa_Delete,
		False,
	},
	{
		"lsa_EnumPrivs",
		sizeof(struct lsa_EnumPrivs),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumPrivs,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumPrivs,
		(ndr_print_function_t) ndr_print_lsa_EnumPrivs,
		False,
	},
	{
		"lsa_QuerySecurity",
		sizeof(struct lsa_QuerySecurity),
		(ndr_push_flags_fn_t) ndr_push_lsa_QuerySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QuerySecurity,
		(ndr_print_function_t) ndr_print_lsa_QuerySecurity,
		False,
	},
	{
		"lsa_SetSecObj",
		sizeof(struct lsa_SetSecObj),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSecObj,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSecObj,
		(ndr_print_function_t) ndr_print_lsa_SetSecObj,
		False,
	},
	{
		"lsa_ChangePassword",
		sizeof(struct lsa_ChangePassword),
		(ndr_push_flags_fn_t) ndr_push_lsa_ChangePassword,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_ChangePassword,
		(ndr_print_function_t) ndr_print_lsa_ChangePassword,
		False,
	},
	{
		"lsa_OpenPolicy",
		sizeof(struct lsa_OpenPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenPolicy,
		(ndr_print_function_t) ndr_print_lsa_OpenPolicy,
		False,
	},
	{
		"lsa_QueryInfoPolicy",
		sizeof(struct lsa_QueryInfoPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryInfoPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryInfoPolicy,
		(ndr_print_function_t) ndr_print_lsa_QueryInfoPolicy,
		False,
	},
	{
		"lsa_SetInfoPolicy",
		sizeof(struct lsa_SetInfoPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInfoPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInfoPolicy,
		(ndr_print_function_t) ndr_print_lsa_SetInfoPolicy,
		False,
	},
	{
		"lsa_ClearAuditLog",
		sizeof(struct lsa_ClearAuditLog),
		(ndr_push_flags_fn_t) ndr_push_lsa_ClearAuditLog,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_ClearAuditLog,
		(ndr_print_function_t) ndr_print_lsa_ClearAuditLog,
		False,
	},
	{
		"lsa_CreateAccount",
		sizeof(struct lsa_CreateAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateAccount,
		(ndr_print_function_t) ndr_print_lsa_CreateAccount,
		False,
	},
	{
		"lsa_EnumAccounts",
		sizeof(struct lsa_EnumAccounts),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccounts,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccounts,
		(ndr_print_function_t) ndr_print_lsa_EnumAccounts,
		False,
	},
	{
		"lsa_CreateTrustedDomain",
		sizeof(struct lsa_CreateTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomain,
		False,
	},
	{
		"lsa_EnumTrustDom",
		sizeof(struct lsa_EnumTrustDom),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumTrustDom,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumTrustDom,
		(ndr_print_function_t) ndr_print_lsa_EnumTrustDom,
		False,
	},
	{
		"lsa_LookupNames",
		sizeof(struct lsa_LookupNames),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames,
		(ndr_print_function_t) ndr_print_lsa_LookupNames,
		False,
	},
	{
		"lsa_LookupSids",
		sizeof(struct lsa_LookupSids),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids,
		(ndr_print_function_t) ndr_print_lsa_LookupSids,
		False,
	},
	{
		"lsa_CreateSecret",
		sizeof(struct lsa_CreateSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateSecret,
		(ndr_print_function_t) ndr_print_lsa_CreateSecret,
		False,
	},
	{
		"lsa_OpenAccount",
		sizeof(struct lsa_OpenAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenAccount,
		(ndr_print_function_t) ndr_print_lsa_OpenAccount,
		False,
	},
	{
		"lsa_EnumPrivsAccount",
		sizeof(struct lsa_EnumPrivsAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumPrivsAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumPrivsAccount,
		(ndr_print_function_t) ndr_print_lsa_EnumPrivsAccount,
		False,
	},
	{
		"lsa_AddPrivilegesToAccount",
		sizeof(struct lsa_AddPrivilegesToAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_AddPrivilegesToAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_AddPrivilegesToAccount,
		(ndr_print_function_t) ndr_print_lsa_AddPrivilegesToAccount,
		False,
	},
	{
		"lsa_RemovePrivilegesFromAccount",
		sizeof(struct lsa_RemovePrivilegesFromAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_RemovePrivilegesFromAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RemovePrivilegesFromAccount,
		(ndr_print_function_t) ndr_print_lsa_RemovePrivilegesFromAccount,
		False,
	},
	{
		"lsa_GetQuotasForAccount",
		sizeof(struct lsa_GetQuotasForAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetQuotasForAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetQuotasForAccount,
		(ndr_print_function_t) ndr_print_lsa_GetQuotasForAccount,
		False,
	},
	{
		"lsa_SetQuotasForAccount",
		sizeof(struct lsa_SetQuotasForAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetQuotasForAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetQuotasForAccount,
		(ndr_print_function_t) ndr_print_lsa_SetQuotasForAccount,
		False,
	},
	{
		"lsa_GetSystemAccessAccount",
		sizeof(struct lsa_GetSystemAccessAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetSystemAccessAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetSystemAccessAccount,
		(ndr_print_function_t) ndr_print_lsa_GetSystemAccessAccount,
		False,
	},
	{
		"lsa_SetSystemAccessAccount",
		sizeof(struct lsa_SetSystemAccessAccount),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSystemAccessAccount,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSystemAccessAccount,
		(ndr_print_function_t) ndr_print_lsa_SetSystemAccessAccount,
		False,
	},
	{
		"lsa_OpenTrustedDomain",
		sizeof(struct lsa_OpenTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_OpenTrustedDomain,
		False,
	},
	{
		"lsa_QueryTrustedDomainInfo",
		sizeof(struct lsa_QueryTrustedDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfo,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfo,
		False,
	},
	{
		"lsa_SetInformationTrustedDomain",
		sizeof(struct lsa_SetInformationTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInformationTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInformationTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_SetInformationTrustedDomain,
		False,
	},
	{
		"lsa_OpenSecret",
		sizeof(struct lsa_OpenSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenSecret,
		(ndr_print_function_t) ndr_print_lsa_OpenSecret,
		False,
	},
	{
		"lsa_SetSecret",
		sizeof(struct lsa_SetSecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetSecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetSecret,
		(ndr_print_function_t) ndr_print_lsa_SetSecret,
		False,
	},
	{
		"lsa_QuerySecret",
		sizeof(struct lsa_QuerySecret),
		(ndr_push_flags_fn_t) ndr_push_lsa_QuerySecret,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QuerySecret,
		(ndr_print_function_t) ndr_print_lsa_QuerySecret,
		False,
	},
	{
		"lsa_LookupPrivValue",
		sizeof(struct lsa_LookupPrivValue),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivValue,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivValue,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivValue,
		False,
	},
	{
		"lsa_LookupPrivName",
		sizeof(struct lsa_LookupPrivName),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivName,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivName,
		False,
	},
	{
		"lsa_LookupPrivDisplayName",
		sizeof(struct lsa_LookupPrivDisplayName),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupPrivDisplayName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupPrivDisplayName,
		(ndr_print_function_t) ndr_print_lsa_LookupPrivDisplayName,
		False,
	},
	{
		"lsa_DeleteObject",
		sizeof(struct lsa_DeleteObject),
		(ndr_push_flags_fn_t) ndr_push_lsa_DeleteObject,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_DeleteObject,
		(ndr_print_function_t) ndr_print_lsa_DeleteObject,
		False,
	},
	{
		"lsa_EnumAccountsWithUserRight",
		sizeof(struct lsa_EnumAccountsWithUserRight),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccountsWithUserRight,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccountsWithUserRight,
		(ndr_print_function_t) ndr_print_lsa_EnumAccountsWithUserRight,
		False,
	},
	{
		"lsa_EnumAccountRights",
		sizeof(struct lsa_EnumAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumAccountRights,
		(ndr_print_function_t) ndr_print_lsa_EnumAccountRights,
		False,
	},
	{
		"lsa_AddAccountRights",
		sizeof(struct lsa_AddAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_AddAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_AddAccountRights,
		(ndr_print_function_t) ndr_print_lsa_AddAccountRights,
		False,
	},
	{
		"lsa_RemoveAccountRights",
		sizeof(struct lsa_RemoveAccountRights),
		(ndr_push_flags_fn_t) ndr_push_lsa_RemoveAccountRights,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RemoveAccountRights,
		(ndr_print_function_t) ndr_print_lsa_RemoveAccountRights,
		False,
	},
	{
		"lsa_QueryTrustedDomainInfoBySid",
		sizeof(struct lsa_QueryTrustedDomainInfoBySid),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfoBySid,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfoBySid,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfoBySid,
		False,
	},
	{
		"lsa_SetTrustedDomainInfo",
		sizeof(struct lsa_SetTrustedDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetTrustedDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetTrustedDomainInfo,
		(ndr_print_function_t) ndr_print_lsa_SetTrustedDomainInfo,
		False,
	},
	{
		"lsa_DeleteTrustedDomain",
		sizeof(struct lsa_DeleteTrustedDomain),
		(ndr_push_flags_fn_t) ndr_push_lsa_DeleteTrustedDomain,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_DeleteTrustedDomain,
		(ndr_print_function_t) ndr_print_lsa_DeleteTrustedDomain,
		False,
	},
	{
		"lsa_StorePrivateData",
		sizeof(struct lsa_StorePrivateData),
		(ndr_push_flags_fn_t) ndr_push_lsa_StorePrivateData,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_StorePrivateData,
		(ndr_print_function_t) ndr_print_lsa_StorePrivateData,
		False,
	},
	{
		"lsa_RetrievePrivateData",
		sizeof(struct lsa_RetrievePrivateData),
		(ndr_push_flags_fn_t) ndr_push_lsa_RetrievePrivateData,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_RetrievePrivateData,
		(ndr_print_function_t) ndr_print_lsa_RetrievePrivateData,
		False,
	},
	{
		"lsa_OpenPolicy2",
		sizeof(struct lsa_OpenPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenPolicy2,
		(ndr_print_function_t) ndr_print_lsa_OpenPolicy2,
		False,
	},
	{
		"lsa_GetUserName",
		sizeof(struct lsa_GetUserName),
		(ndr_push_flags_fn_t) ndr_push_lsa_GetUserName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_GetUserName,
		(ndr_print_function_t) ndr_print_lsa_GetUserName,
		False,
	},
	{
		"lsa_QueryInfoPolicy2",
		sizeof(struct lsa_QueryInfoPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryInfoPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryInfoPolicy2,
		(ndr_print_function_t) ndr_print_lsa_QueryInfoPolicy2,
		False,
	},
	{
		"lsa_SetInfoPolicy2",
		sizeof(struct lsa_SetInfoPolicy2),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetInfoPolicy2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetInfoPolicy2,
		(ndr_print_function_t) ndr_print_lsa_SetInfoPolicy2,
		False,
	},
	{
		"lsa_QueryTrustedDomainInfoByName",
		sizeof(struct lsa_QueryTrustedDomainInfoByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryTrustedDomainInfoByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryTrustedDomainInfoByName,
		(ndr_print_function_t) ndr_print_lsa_QueryTrustedDomainInfoByName,
		False,
	},
	{
		"lsa_SetTrustedDomainInfoByName",
		sizeof(struct lsa_SetTrustedDomainInfoByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetTrustedDomainInfoByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetTrustedDomainInfoByName,
		(ndr_print_function_t) ndr_print_lsa_SetTrustedDomainInfoByName,
		False,
	},
	{
		"lsa_EnumTrustedDomainsEx",
		sizeof(struct lsa_EnumTrustedDomainsEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_EnumTrustedDomainsEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_EnumTrustedDomainsEx,
		(ndr_print_function_t) ndr_print_lsa_EnumTrustedDomainsEx,
		False,
	},
	{
		"lsa_CreateTrustedDomainEx",
		sizeof(struct lsa_CreateTrustedDomainEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomainEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomainEx,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomainEx,
		False,
	},
	{
		"lsa_CloseTrustedDomainEx",
		sizeof(struct lsa_CloseTrustedDomainEx),
		(ndr_push_flags_fn_t) ndr_push_lsa_CloseTrustedDomainEx,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CloseTrustedDomainEx,
		(ndr_print_function_t) ndr_print_lsa_CloseTrustedDomainEx,
		False,
	},
	{
		"lsa_QueryDomainInformationPolicy",
		sizeof(struct lsa_QueryDomainInformationPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_QueryDomainInformationPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_QueryDomainInformationPolicy,
		(ndr_print_function_t) ndr_print_lsa_QueryDomainInformationPolicy,
		False,
	},
	{
		"lsa_SetDomainInformationPolicy",
		sizeof(struct lsa_SetDomainInformationPolicy),
		(ndr_push_flags_fn_t) ndr_push_lsa_SetDomainInformationPolicy,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_SetDomainInformationPolicy,
		(ndr_print_function_t) ndr_print_lsa_SetDomainInformationPolicy,
		False,
	},
	{
		"lsa_OpenTrustedDomainByName",
		sizeof(struct lsa_OpenTrustedDomainByName),
		(ndr_push_flags_fn_t) ndr_push_lsa_OpenTrustedDomainByName,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_OpenTrustedDomainByName,
		(ndr_print_function_t) ndr_print_lsa_OpenTrustedDomainByName,
		False,
	},
	{
		"lsa_TestCall",
		sizeof(struct lsa_TestCall),
		(ndr_push_flags_fn_t) ndr_push_lsa_TestCall,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_TestCall,
		(ndr_print_function_t) ndr_print_lsa_TestCall,
		False,
	},
	{
		"lsa_LookupSids2",
		sizeof(struct lsa_LookupSids2),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids2,
		(ndr_print_function_t) ndr_print_lsa_LookupSids2,
		False,
	},
	{
		"lsa_LookupNames2",
		sizeof(struct lsa_LookupNames2),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames2,
		(ndr_print_function_t) ndr_print_lsa_LookupNames2,
		False,
	},
	{
		"lsa_CreateTrustedDomainEx2",
		sizeof(struct lsa_CreateTrustedDomainEx2),
		(ndr_push_flags_fn_t) ndr_push_lsa_CreateTrustedDomainEx2,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CreateTrustedDomainEx2,
		(ndr_print_function_t) ndr_print_lsa_CreateTrustedDomainEx2,
		False,
	},
	{
		"lsa_CREDRWRITE",
		sizeof(struct lsa_CREDRWRITE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRWRITE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRWRITE,
		(ndr_print_function_t) ndr_print_lsa_CREDRWRITE,
		False,
	},
	{
		"lsa_CREDRREAD",
		sizeof(struct lsa_CREDRREAD),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRREAD,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRREAD,
		(ndr_print_function_t) ndr_print_lsa_CREDRREAD,
		False,
	},
	{
		"lsa_CREDRENUMERATE",
		sizeof(struct lsa_CREDRENUMERATE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRENUMERATE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRENUMERATE,
		(ndr_print_function_t) ndr_print_lsa_CREDRENUMERATE,
		False,
	},
	{
		"lsa_CREDRWRITEDOMAINCREDENTIALS",
		sizeof(struct lsa_CREDRWRITEDOMAINCREDENTIALS),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRWRITEDOMAINCREDENTIALS,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRWRITEDOMAINCREDENTIALS,
		(ndr_print_function_t) ndr_print_lsa_CREDRWRITEDOMAINCREDENTIALS,
		False,
	},
	{
		"lsa_CREDRREADDOMAINCREDENTIALS",
		sizeof(struct lsa_CREDRREADDOMAINCREDENTIALS),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRREADDOMAINCREDENTIALS,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRREADDOMAINCREDENTIALS,
		(ndr_print_function_t) ndr_print_lsa_CREDRREADDOMAINCREDENTIALS,
		False,
	},
	{
		"lsa_CREDRDELETE",
		sizeof(struct lsa_CREDRDELETE),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRDELETE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRDELETE,
		(ndr_print_function_t) ndr_print_lsa_CREDRDELETE,
		False,
	},
	{
		"lsa_CREDRGETTARGETINFO",
		sizeof(struct lsa_CREDRGETTARGETINFO),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRGETTARGETINFO,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRGETTARGETINFO,
		(ndr_print_function_t) ndr_print_lsa_CREDRGETTARGETINFO,
		False,
	},
	{
		"lsa_CREDRPROFILELOADED",
		sizeof(struct lsa_CREDRPROFILELOADED),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRPROFILELOADED,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRPROFILELOADED,
		(ndr_print_function_t) ndr_print_lsa_CREDRPROFILELOADED,
		False,
	},
	{
		"lsa_LookupNames3",
		sizeof(struct lsa_LookupNames3),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames3,
		(ndr_print_function_t) ndr_print_lsa_LookupNames3,
		False,
	},
	{
		"lsa_CREDRGETSESSIONTYPES",
		sizeof(struct lsa_CREDRGETSESSIONTYPES),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRGETSESSIONTYPES,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRGETSESSIONTYPES,
		(ndr_print_function_t) ndr_print_lsa_CREDRGETSESSIONTYPES,
		False,
	},
	{
		"lsa_LSARREGISTERAUDITEVENT",
		sizeof(struct lsa_LSARREGISTERAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARREGISTERAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARREGISTERAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARREGISTERAUDITEVENT,
		False,
	},
	{
		"lsa_LSARGENAUDITEVENT",
		sizeof(struct lsa_LSARGENAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARGENAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARGENAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARGENAUDITEVENT,
		False,
	},
	{
		"lsa_LSARUNREGISTERAUDITEVENT",
		sizeof(struct lsa_LSARUNREGISTERAUDITEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARUNREGISTERAUDITEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARUNREGISTERAUDITEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARUNREGISTERAUDITEVENT,
		False,
	},
	{
		"lsa_LSARQUERYFORESTTRUSTINFORMATION",
		sizeof(struct lsa_LSARQUERYFORESTTRUSTINFORMATION),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARQUERYFORESTTRUSTINFORMATION,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARQUERYFORESTTRUSTINFORMATION,
		(ndr_print_function_t) ndr_print_lsa_LSARQUERYFORESTTRUSTINFORMATION,
		False,
	},
	{
		"lsa_LSARSETFORESTTRUSTINFORMATION",
		sizeof(struct lsa_LSARSETFORESTTRUSTINFORMATION),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARSETFORESTTRUSTINFORMATION,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARSETFORESTTRUSTINFORMATION,
		(ndr_print_function_t) ndr_print_lsa_LSARSETFORESTTRUSTINFORMATION,
		False,
	},
	{
		"lsa_CREDRRENAME",
		sizeof(struct lsa_CREDRRENAME),
		(ndr_push_flags_fn_t) ndr_push_lsa_CREDRRENAME,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_CREDRRENAME,
		(ndr_print_function_t) ndr_print_lsa_CREDRRENAME,
		False,
	},
	{
		"lsa_LookupSids3",
		sizeof(struct lsa_LookupSids3),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupSids3,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupSids3,
		(ndr_print_function_t) ndr_print_lsa_LookupSids3,
		False,
	},
	{
		"lsa_LookupNames4",
		sizeof(struct lsa_LookupNames4),
		(ndr_push_flags_fn_t) ndr_push_lsa_LookupNames4,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LookupNames4,
		(ndr_print_function_t) ndr_print_lsa_LookupNames4,
		False,
	},
	{
		"lsa_LSAROPENPOLICYSCE",
		sizeof(struct lsa_LSAROPENPOLICYSCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSAROPENPOLICYSCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSAROPENPOLICYSCE,
		(ndr_print_function_t) ndr_print_lsa_LSAROPENPOLICYSCE,
		False,
	},
	{
		"lsa_LSARADTREGISTERSECURITYEVENTSOURCE",
		sizeof(struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		(ndr_print_function_t) ndr_print_lsa_LSARADTREGISTERSECURITYEVENTSOURCE,
		False,
	},
	{
		"lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE",
		sizeof(struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		(ndr_print_function_t) ndr_print_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE,
		False,
	},
	{
		"lsa_LSARADTREPORTSECURITYEVENT",
		sizeof(struct lsa_LSARADTREPORTSECURITYEVENT),
		(ndr_push_flags_fn_t) ndr_push_lsa_LSARADTREPORTSECURITYEVENT,
		(ndr_pull_flags_fn_t) ndr_pull_lsa_LSARADTREPORTSECURITYEVENT,
		(ndr_print_function_t) ndr_print_lsa_LSARADTREPORTSECURITYEVENT,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const lsarpc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\lsarpc]", 
	"ncacn_np:[\\pipe\\netlogon]", 
	"ncacn_np:[\\pipe\\lsass]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct dcerpc_endpoint_list lsarpc_endpoints = {
	.count	= 5,
	.names	= lsarpc_endpoint_strings
};

static const char * const lsarpc_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list lsarpc_authservices = {
	.count	= 5,
	.names	= lsarpc_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_lsarpc = {
	.name		= "lsarpc",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xab}},
		DCERPC_LSARPC_VERSION
	},
	.helpstring	= DCERPC_LSARPC_HELPSTRING,
	.num_calls	= 82,
	.calls		= lsarpc_calls,
	.endpoints	= &lsarpc_endpoints,
	.authservices	= &lsarpc_authservices
};

