
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_mgmt.h"
#include "librpc/gen_ndr/ndr_mgmt_ejs.h"


static NTSTATUS ejs_push_dcerpc_syntax_id_p(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_syntax_id_p *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->id) {
		NDR_CHECK(ejs_push_null(ejs, v, "id"));
	} else {
		NDR_CHECK(ejs_push_dcerpc_syntax_id(ejs, v, "id", r->id));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_rpc_if_id_vector_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct rpc_if_id_vector_t *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "if_id", i);
			NDR_CHECK(ejs_push_dcerpc_syntax_id_p(ejs, v, id, &r->if_id[i]));
		}
		ejs_push_uint32(ejs, v, "if_id" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_mgmt_statistics(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct mgmt_statistics *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "statistics", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->statistics[i]));
		}
		ejs_push_uint32(ejs, v, "statistics" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_mgmt_inq_if_ids(struct ejs_rpc *ejs, struct MprVar *v, struct mgmt_inq_if_ids *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_mgmt_inq_if_ids(struct ejs_rpc *ejs, struct MprVar *v, const struct mgmt_inq_if_ids *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.if_id_vector) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.if_id_vector) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_rpc_if_id_vector_t(ejs, v, "if_id_vector", *r->out.if_id_vector));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_mgmt_inq_if_ids(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_mgmt, DCERPC_MGMT_INQ_IF_IDS, (ejs_pull_function_t)ejs_pull_mgmt_inq_if_ids, (ejs_push_function_t)ejs_push_mgmt_inq_if_ids);
}


static NTSTATUS ejs_pull_mgmt_inq_stats(struct ejs_rpc *ejs, struct MprVar *v, struct mgmt_inq_stats *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_count", &r->in.max_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_mgmt_inq_stats(struct ejs_rpc *ejs, struct MprVar *v, const struct mgmt_inq_stats *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.statistics) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_mgmt_statistics(ejs, v, "statistics", r->out.statistics));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_mgmt_inq_stats(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_mgmt, DCERPC_MGMT_INQ_STATS, (ejs_pull_function_t)ejs_pull_mgmt_inq_stats, (ejs_push_function_t)ejs_push_mgmt_inq_stats);
}


static NTSTATUS ejs_pull_mgmt_is_server_listening(struct ejs_rpc *ejs, struct MprVar *v, struct mgmt_is_server_listening *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_mgmt_is_server_listening(struct ejs_rpc *ejs, struct MprVar *v, const struct mgmt_is_server_listening *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.status) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "status", r->out.status));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_mgmt_is_server_listening(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_mgmt, DCERPC_MGMT_IS_SERVER_LISTENING, (ejs_pull_function_t)ejs_pull_mgmt_is_server_listening, (ejs_push_function_t)ejs_push_mgmt_is_server_listening);
}


static NTSTATUS ejs_pull_mgmt_stop_server_listening(struct ejs_rpc *ejs, struct MprVar *v, struct mgmt_stop_server_listening *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_mgmt_stop_server_listening(struct ejs_rpc *ejs, struct MprVar *v, const struct mgmt_stop_server_listening *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_mgmt_stop_server_listening(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_mgmt, DCERPC_MGMT_STOP_SERVER_LISTENING, (ejs_pull_function_t)ejs_pull_mgmt_stop_server_listening, (ejs_push_function_t)ejs_push_mgmt_stop_server_listening);
}


static NTSTATUS ejs_pull_mgmt_inq_princ_name(struct ejs_rpc *ejs, struct MprVar *v, struct mgmt_inq_princ_name *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "authn_proto", &r->in.authn_proto));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "princ_name_size", &r->in.princ_name_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_mgmt_inq_princ_name(struct ejs_rpc *ejs, struct MprVar *v, const struct mgmt_inq_princ_name *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_string(ejs, v, "princ_name", r->out.princ_name));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_mgmt_inq_princ_name(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_mgmt, DCERPC_MGMT_INQ_PRINC_NAME, (ejs_pull_function_t)ejs_pull_mgmt_inq_princ_name, (ejs_push_function_t)ejs_push_mgmt_inq_princ_name);
}

static int ejs_mgmt_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "mgmt", argc, argv);
	mprSetCFunction(obj, "mgmt_inq_if_ids", ejs_mgmt_inq_if_ids);
	mprSetCFunction(obj, "mgmt_inq_stats", ejs_mgmt_inq_stats);
	mprSetCFunction(obj, "mgmt_is_server_listening", ejs_mgmt_is_server_listening);
	mprSetCFunction(obj, "mgmt_stop_server_listening", ejs_mgmt_stop_server_listening);
	mprSetCFunction(obj, "mgmt_inq_princ_name", ejs_mgmt_inq_princ_name);
	mprSetVar(obj, "MGMT_STATS_PKTS_IN", mprCreateNumberVar(2));
	mprSetVar(obj, "MGMT_STATS_CALLS_IN", mprCreateNumberVar(0));
	mprSetVar(obj, "MGMT_STATS_PKTS_OUT", mprCreateNumberVar(3));
	mprSetVar(obj, "MGMT_STATS_ARRAY_MAX_SIZE", mprCreateNumberVar(4));
	mprSetVar(obj, "MGMT_STATS_CALLS_OUT", mprCreateNumberVar(1));
	return ejs_rpc_init(obj, "mgmt");
}

NTSTATUS ejs_init_mgmt(void)
{
	ejsDefineCFunction(-1, "mgmt_init", ejs_mgmt_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
