
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_netlogon_ejs.h"


static NTSTATUS ejs_push_netr_UasInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_UasInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->account_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "account_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "account_name", r->account_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "priv", &r->priv));
	NDR_CHECK(ejs_push_uint32(ejs, v, "auth_flags", &r->auth_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bad_pw_count", &r->bad_pw_count));
	NDR_CHECK(ejs_push_time_t(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_time_t(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_time_t(ejs, v, "logoff_time", &r->logoff_time));
	NDR_CHECK(ejs_push_time_t(ejs, v, "kickoff_time", &r->kickoff_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "password_age", &r->password_age));
	NDR_CHECK(ejs_push_time_t(ejs, v, "pw_can_change", &r->pw_can_change));
	NDR_CHECK(ejs_push_time_t(ejs, v, "pw_must_change", &r->pw_must_change));
	if (NULL == r->computer) {
		NDR_CHECK(ejs_push_null(ejs, v, "computer"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "computer", r->computer));
	}
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	if (NULL == r->script_path) {
		NDR_CHECK(ejs_push_null(ejs, v, "script_path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "script_path", r->script_path));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_UasLogoffInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_UasLogoffInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "duration", &r->duration));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_AcctLockStr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_AcctLockStr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	if (NULL == r->bindata) {
		NDR_CHECK(ejs_push_null(ejs, v, "bindata"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->length / 2;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "bindata", i);
				NDR_CHECK(ejs_push_uint16(ejs, v, id, &r->bindata[i]));
			}
			ejs_push_uint32(ejs, v, "bindata" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_IdentityInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_IdentityInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "parameter_control", &r->parameter_control));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logon_id_low", &r->logon_id_low));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logon_id_high", &r->logon_id_high));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstation", &r->workstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_IdentityInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_IdentityInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "parameter_control", &r->parameter_control));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "logon_id_low", &r->logon_id_low));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "logon_id_high", &r->logon_id_high));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "workstation", &r->workstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_PasswordInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_PasswordInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_IdentityInfo(ejs, v, "identity_info", &r->identity_info));
	NDR_CHECK(ejs_push_samr_Password(ejs, v, "lmpassword", &r->lmpassword));
	NDR_CHECK(ejs_push_samr_Password(ejs, v, "ntpassword", &r->ntpassword));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_PasswordInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_PasswordInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_IdentityInfo(ejs, v, "identity_info", &r->identity_info));
	NDR_CHECK(ejs_pull_samr_Password(ejs, v, "lmpassword", &r->lmpassword));
	NDR_CHECK(ejs_pull_samr_Password(ejs, v, "ntpassword", &r->ntpassword));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_ChallengeResponse(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_ChallengeResponse *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_ChallengeResponse(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_ChallengeResponse *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->length);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_NetworkInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_NetworkInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_IdentityInfo(ejs, v, "identity_info", &r->identity_info));
	ejs_push_array_uint8(ejs, v, "challenge", r->challenge, 8);
	NDR_CHECK(ejs_push_netr_ChallengeResponse(ejs, v, "nt", &r->nt));
	NDR_CHECK(ejs_push_netr_ChallengeResponse(ejs, v, "lm", &r->lm));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_NetworkInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_NetworkInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_IdentityInfo(ejs, v, "identity_info", &r->identity_info));
	ejs_pull_array_uint8(ejs, v, "challenge", r->challenge, 8);
	NDR_CHECK(ejs_pull_netr_ChallengeResponse(ejs, v, "nt", &r->nt));
	NDR_CHECK(ejs_pull_netr_ChallengeResponse(ejs, v, "lm", &r->lm));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_LogonLevel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_LogonLevel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->password) {
				NDR_CHECK(ejs_push_null(ejs, v, "password"));
			} else {
				NDR_CHECK(ejs_push_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 2:
			if (NULL == r->network) {
				NDR_CHECK(ejs_push_null(ejs, v, "network"));
			} else {
				NDR_CHECK(ejs_push_netr_NetworkInfo(ejs, v, "network", r->network));
			}
			break;
		case 3:
			if (NULL == r->password) {
				NDR_CHECK(ejs_push_null(ejs, v, "password"));
			} else {
				NDR_CHECK(ejs_push_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 5:
			if (NULL == r->password) {
				NDR_CHECK(ejs_push_null(ejs, v, "password"));
			} else {
				NDR_CHECK(ejs_push_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 6:
			if (NULL == r->network) {
				NDR_CHECK(ejs_push_null(ejs, v, "network"));
			} else {
				NDR_CHECK(ejs_push_netr_NetworkInfo(ejs, v, "network", r->network));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_netr_LogonLevel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union netr_LogonLevel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "password")) {
				r->password = NULL;
			} else {
				EJS_ALLOC(ejs, r->password);
				NDR_CHECK(ejs_pull_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "network")) {
				r->network = NULL;
			} else {
				EJS_ALLOC(ejs, r->network);
				NDR_CHECK(ejs_pull_netr_NetworkInfo(ejs, v, "network", r->network));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "password")) {
				r->password = NULL;
			} else {
				EJS_ALLOC(ejs, r->password);
				NDR_CHECK(ejs_pull_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 5:
			if (ejs_pull_null(ejs, v, "password")) {
				r->password = NULL;
			} else {
				EJS_ALLOC(ejs, r->password);
				NDR_CHECK(ejs_pull_netr_PasswordInfo(ejs, v, "password", r->password));
			}
			break;
		case 6:
			if (ejs_pull_null(ejs, v, "network")) {
				r->network = NULL;
			} else {
				EJS_ALLOC(ejs, r->network);
				NDR_CHECK(ejs_pull_netr_NetworkInfo(ejs, v, "network", r->network));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_netr_GroupMembership(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_GroupMembership *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_GroupMembership(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_GroupMembership *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_UserSessionKey(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_UserSessionKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "key", r->key, 16);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_UserSessionKey(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_UserSessionKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "key", r->key, 16);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_LMSessionKey(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_LMSessionKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "key", r->key, 8);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_LMSessionKey(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_LMSessionKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "key", r->key, 8);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_UserFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_netr_UserFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_netr_SamBaseInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_SamBaseInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_samr_RidWithAttributeArray(ejs, v, "groups", &r->groups));
	NDR_CHECK(ejs_push_netr_UserFlags(ejs, v, "user_flags", &r->user_flags));
	NDR_CHECK(ejs_push_netr_UserSessionKey(ejs, v, "key", &r->key));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "logon_server", &r->logon_server));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "domain", &r->domain));
	if (NULL == r->domain_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "domain_sid", r->domain_sid));
	}
	NDR_CHECK(ejs_push_netr_LMSessionKey(ejs, v, "LMSessKey", &r->LMSessKey));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	{
		uint32_t i;
		for (i=0;i<7;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown[i]));
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_SamBaseInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_SamBaseInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_pull_samr_RidWithAttributeArray(ejs, v, "groups", &r->groups));
	NDR_CHECK(ejs_pull_netr_UserFlags(ejs, v, "user_flags", &r->user_flags));
	NDR_CHECK(ejs_pull_netr_UserSessionKey(ejs, v, "key", &r->key));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "logon_server", &r->logon_server));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "domain", &r->domain));
	if (ejs_pull_null(ejs, v, "domain_sid")) {
		r->domain_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "domain_sid", r->domain_sid));
	}
	NDR_CHECK(ejs_pull_netr_LMSessionKey(ejs, v, "LMSessKey", &r->LMSessKey));
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	{
		uint32_t i;
		for (i=0;i<7;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_SamInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_SamInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_SamBaseInfo(ejs, v, "base", &r->base));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_SamInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_SamInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_SamBaseInfo(ejs, v, "base", &r->base));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_SidAttr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_SidAttr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "attribute", &r->attribute));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_SidAttr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_SidAttr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attribute", &r->attribute));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_SamInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_SamInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_SamBaseInfo(ejs, v, "base", &r->base));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sidcount", &r->sidcount));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->sidcount;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_netr_SidAttr(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_SamInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_SamInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_SamBaseInfo(ejs, v, "base", &r->base));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sidcount", &r->sidcount));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->sidcount);
			for (i=0;i<r->sidcount;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_netr_SidAttr(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_SamInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_SamInfo6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_SamBaseInfo(ejs, v, "base", &r->base));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sidcount", &r->sidcount));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->sidcount;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_netr_SidAttr(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "principle", &r->principle));
	{
		uint32_t i;
		for (i=0;i<20;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown4", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown4[i]));
		}
		ejs_push_uint32(ejs, v, "unknown4" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_SamInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_SamInfo6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_SamBaseInfo(ejs, v, "base", &r->base));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sidcount", &r->sidcount));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->sidcount);
			for (i=0;i<r->sidcount;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_netr_SidAttr(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "principle", &r->principle));
	{
		uint32_t i;
		for (i=0;i<20;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown4", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown4[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown4" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_PacInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_PacInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pac_size", &r->pac_size));
	if (NULL == r->pac) {
		NDR_CHECK(ejs_push_null(ejs, v, "pac"));
	} else {
		ejs_push_array_uint8(ejs, v, "pac", r->pac, r->pac_size);
	}
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_domain", &r->logon_domain));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_server", &r->logon_server));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "principal_name", &r->principal_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "auth_size", &r->auth_size));
	if (NULL == r->auth) {
		NDR_CHECK(ejs_push_null(ejs, v, "auth"));
	} else {
		ejs_push_array_uint8(ejs, v, "auth", r->auth, r->auth_size);
	}
	NDR_CHECK(ejs_push_netr_UserSessionKey(ejs, v, "user_session_key", &r->user_session_key));
	{
		uint32_t i;
		for (i=0;i<10;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "expansionroom", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->expansionroom[i]));
		}
		ejs_push_uint32(ejs, v, "expansionroom" ".length", &i);
	}
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_PacInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_PacInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pac_size", &r->pac_size));
	if (ejs_pull_null(ejs, v, "pac")) {
		r->pac = NULL;
	} else {
		EJS_ALLOC(ejs, r->pac);
		EJS_ALLOC_N(ejs, r->pac, r->pac_size);
		ejs_pull_array_uint8(ejs, v, "pac", r->pac, r->pac_size);
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_domain", &r->logon_domain));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_server", &r->logon_server));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "principal_name", &r->principal_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "auth_size", &r->auth_size));
	if (ejs_pull_null(ejs, v, "auth")) {
		r->auth = NULL;
	} else {
		EJS_ALLOC(ejs, r->auth);
		EJS_ALLOC_N(ejs, r->auth, r->auth_size);
		ejs_pull_array_uint8(ejs, v, "auth", r->auth, r->auth_size);
	}
	NDR_CHECK(ejs_pull_netr_UserSessionKey(ejs, v, "user_session_key", &r->user_session_key));
	{
		uint32_t i;
		for (i=0;i<10;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "expansionroom", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->expansionroom[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "expansionroom" ".length", &i);
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_Validation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_Validation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			if (NULL == r->sam2) {
				NDR_CHECK(ejs_push_null(ejs, v, "sam2"));
			} else {
				NDR_CHECK(ejs_push_netr_SamInfo2(ejs, v, "sam2", r->sam2));
			}
			break;
		case 3:
			if (NULL == r->sam3) {
				NDR_CHECK(ejs_push_null(ejs, v, "sam3"));
			} else {
				NDR_CHECK(ejs_push_netr_SamInfo3(ejs, v, "sam3", r->sam3));
			}
			break;
		case 4:
			if (NULL == r->pac) {
				NDR_CHECK(ejs_push_null(ejs, v, "pac"));
			} else {
				NDR_CHECK(ejs_push_netr_PacInfo(ejs, v, "pac", r->pac));
			}
			break;
		case 5:
			if (NULL == r->pac) {
				NDR_CHECK(ejs_push_null(ejs, v, "pac"));
			} else {
				NDR_CHECK(ejs_push_netr_PacInfo(ejs, v, "pac", r->pac));
			}
			break;
		case 6:
			if (NULL == r->sam6) {
				NDR_CHECK(ejs_push_null(ejs, v, "sam6"));
			} else {
				NDR_CHECK(ejs_push_netr_SamInfo6(ejs, v, "sam6", r->sam6));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_netr_Validation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union netr_Validation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			if (ejs_pull_null(ejs, v, "sam2")) {
				r->sam2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->sam2);
				NDR_CHECK(ejs_pull_netr_SamInfo2(ejs, v, "sam2", r->sam2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "sam3")) {
				r->sam3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->sam3);
				NDR_CHECK(ejs_pull_netr_SamInfo3(ejs, v, "sam3", r->sam3));
			}
			break;
		case 4:
			if (ejs_pull_null(ejs, v, "pac")) {
				r->pac = NULL;
			} else {
				EJS_ALLOC(ejs, r->pac);
				NDR_CHECK(ejs_pull_netr_PacInfo(ejs, v, "pac", r->pac));
			}
			break;
		case 5:
			if (ejs_pull_null(ejs, v, "pac")) {
				r->pac = NULL;
			} else {
				EJS_ALLOC(ejs, r->pac);
				NDR_CHECK(ejs_pull_netr_PacInfo(ejs, v, "pac", r->pac));
			}
			break;
		case 6:
			if (ejs_pull_null(ejs, v, "sam6")) {
				r->sam6 = NULL;
			} else {
				EJS_ALLOC(ejs, r->sam6);
				NDR_CHECK(ejs_pull_netr_SamInfo6(ejs, v, "sam6", r->sam6));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_netr_Credential(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_Credential *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "data", r->data, 8);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_Credential(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_Credential *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "data", r->data, 8);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_Authenticator(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_Authenticator *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_Credential(ejs, v, "cred", &r->cred));
	NDR_CHECK(ejs_push_time_t(ejs, v, "timestamp", &r->timestamp));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_Authenticator(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_Authenticator *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_Credential(ejs, v, "cred", &r->cred));
	NDR_CHECK(ejs_pull_time_t(ejs, v, "timestamp", &r->timestamp));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_DELETE_USER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_DELETE_USER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->account_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "account_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "account_name", r->account_name));
	}
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_USER_KEY16(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_USER_KEY16 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_samr_Password(ejs, v, "pwd", &r->pwd));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_USER_KEY16(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_USER_KEY16 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_samr_Password(ejs, v, "pwd", &r->pwd));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_PasswordHistory(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_PasswordHistory *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "nt_length", &r->nt_length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "nt_size", &r->nt_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_flags", &r->nt_flags));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm_length", &r->lm_length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm_size", &r->lm_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lm_flags", &r->lm_flags));
	ejs_push_array_uint8(ejs, v, "nt_history", r->nt_history, r->nt_length);
	ejs_push_array_uint8(ejs, v, "lm_history", r->lm_history, r->lm_length);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_PasswordHistory(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_PasswordHistory *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "nt_length", &r->nt_length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "nt_size", &r->nt_size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_flags", &r->nt_flags));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm_length", &r->lm_length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm_size", &r->lm_size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lm_flags", &r->lm_flags));
	EJS_ALLOC_N(ejs, r->nt_history, r->nt_length);
	ejs_pull_array_uint8(ejs, v, "nt_history", r->nt_history, r->nt_length);
	EJS_ALLOC_N(ejs, r->lm_history, r->lm_length);
	ejs_pull_array_uint8(ejs, v, "lm_history", r->lm_history, r->lm_length);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_USER_KEYS2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_USER_KEYS2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_USER_KEY16(ejs, v, "lmpassword", &r->lmpassword));
	NDR_CHECK(ejs_push_netr_USER_KEY16(ejs, v, "ntpassword", &r->ntpassword));
	NDR_CHECK(ejs_push_netr_PasswordHistory(ejs, v, "lmhistory", &r->lmhistory));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_USER_KEYS2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_USER_KEYS2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_USER_KEY16(ejs, v, "lmpassword", &r->lmpassword));
	NDR_CHECK(ejs_pull_netr_USER_KEY16(ejs, v, "ntpassword", &r->ntpassword));
	NDR_CHECK(ejs_pull_netr_PasswordHistory(ejs, v, "lmhistory", &r->lmhistory));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_USER_KEY_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_USER_KEY_UNION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_USER_KEYS2(ejs, v, "keys2", &r->keys2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_USER_KEY_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_USER_KEY_UNION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_USER_KEYS2(ejs, v, "keys2", &r->keys2));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_netr_USER_KEYS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_USER_KEYS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_netr_USER_KEY_UNION(ejs, v, "keys", &r->keys));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_netr_USER_KEYS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_USER_KEYS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_netr_USER_KEY_UNION(ejs, v, "keys", &r->keys));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_USER_PRIVATE_INFO(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_USER_PRIVATE_INFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "SensitiveDataFlag", &r->SensitiveDataFlag));
	NDR_CHECK(ejs_push_uint32(ejs, v, "DataLength", &r->DataLength));
	if (NULL == r->SensitiveData) {
		NDR_CHECK(ejs_push_null(ejs, v, "SensitiveData"));
	} else {
		ejs_push_array_uint8(ejs, v, "SensitiveData", r->SensitiveData, r->DataLength);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_USER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_USER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_push_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_push_samr_Password(ejs, v, "lmpassword", &r->lmpassword));
	NDR_CHECK(ejs_push_samr_Password(ejs, v, "ntpassword", &r->ntpassword));
	NDR_CHECK(ejs_push_uint8(ejs, v, "nt_password_present", &r->nt_password_present));
	NDR_CHECK(ejs_push_uint8(ejs, v, "lm_password_present", &r->lm_password_present));
	NDR_CHECK(ejs_push_uint8(ejs, v, "password_expired", &r->password_expired));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "parameters", &r->parameters));
	NDR_CHECK(ejs_push_uint16(ejs, v, "country_code", &r->country_code));
	NDR_CHECK(ejs_push_uint16(ejs, v, "code_page", &r->code_page));
	NDR_CHECK(ejs_push_netr_USER_PRIVATE_INFO(ejs, v, "user_private_info", &r->user_private_info));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_DOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_DOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_push_dlong(ejs, v, "force_logoff_time", &r->force_logoff_time));
	NDR_CHECK(ejs_push_uint16(ejs, v, "min_password_length", &r->min_password_length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "password_history_length", &r->password_history_length));
	NDR_CHECK(ejs_push_dlong(ejs, v, "max_password_age", &r->max_password_age));
	NDR_CHECK(ejs_push_dlong(ejs, v, "min_password_age", &r->min_password_age));
	NDR_CHECK(ejs_push_udlong(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "domain_create_time", &r->domain_create_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_netr_AcctLockStr(ejs, v, "account_lockout", &r->account_lockout));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logon_to_chgpass", &r->logon_to_chgpass));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_GROUP(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_GROUP *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "group_name", &r->group_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_RENAME(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_RENAME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "OldName", &r->OldName));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "NewName", &r->NewName));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_GROUP_MEMBER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_GROUP_MEMBER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->rids) {
		NDR_CHECK(ejs_push_null(ejs, v, "rids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_rids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "rids", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->rids[i]));
			}
			ejs_push_uint32(ejs, v, "rids" ".length", &i);
		}
	}
	if (NULL == r->attribs) {
		NDR_CHECK(ejs_push_null(ejs, v, "attribs"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_rids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "attribs", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->attribs[i]));
			}
			ejs_push_uint32(ejs, v, "attribs" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_rids", &r->num_rids));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_ALIAS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_ALIAS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "alias_name", &r->alias_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_ALIAS_MEMBER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_ALIAS_MEMBER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidArray(ejs, v, "sids", &r->sids));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_QUOTA_LIMITS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_QUOTA_LIMITS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pagedpoollimit", &r->pagedpoollimit));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nonpagedpoollimit", &r->nonpagedpoollimit));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minimumworkingsetsize", &r->minimumworkingsetsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maximumworkingsetsize", &r->maximumworkingsetsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pagefilelimit", &r->pagefilelimit));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "timelimit", &r->timelimit));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_POLICY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_POLICY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxlogsize", &r->maxlogsize));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "auditretentionperiod", &r->auditretentionperiod));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auditingmode", &r->auditingmode));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxauditeventcount", &r->maxauditeventcount));
	if (NULL == r->eventauditoptions) {
		NDR_CHECK(ejs_push_null(ejs, v, "eventauditoptions"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->maxauditeventcount + 1;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "eventauditoptions", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->eventauditoptions[i]));
			}
			ejs_push_uint32(ejs, v, "eventauditoptions" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "primary_domain_name", &r->primary_domain_name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_push_netr_QUOTA_LIMITS(ejs, v, "quota_limits", &r->quota_limits));
	NDR_CHECK(ejs_push_udlong(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "db_create_time", &r->db_create_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_TRUSTED_DOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_TRUSTED_DOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_controllers", &r->num_controllers));
	if (NULL == r->controller_names) {
		NDR_CHECK(ejs_push_null(ejs, v, "controller_names"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_controllers;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "controller_names", i);
				NDR_CHECK(ejs_push_lsa_String(ejs, v, id, &r->controller_names[i]));
			}
			ejs_push_uint32(ejs, v, "controller_names" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "posix_offset", &r->posix_offset));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_DELETE_TRUST(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_DELETE_TRUST *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_ACCOUNT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_ACCOUNT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "privilege_entries", &r->privilege_entries));
	NDR_CHECK(ejs_push_uint32(ejs, v, "privilege_control", &r->privilege_control));
	if (NULL == r->privilege_attrib) {
		NDR_CHECK(ejs_push_null(ejs, v, "privilege_attrib"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->privilege_entries;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "privilege_attrib", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->privilege_attrib[i]));
			}
			ejs_push_uint32(ejs, v, "privilege_attrib" ".length", &i);
		}
	}
	if (NULL == r->privilege_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "privilege_name"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->privilege_entries;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "privilege_name", i);
				NDR_CHECK(ejs_push_lsa_String(ejs, v, id, &r->privilege_name[i]));
			}
			ejs_push_uint32(ejs, v, "privilege_name" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_netr_QUOTA_LIMITS(ejs, v, "quotalimits", &r->quotalimits));
	NDR_CHECK(ejs_push_uint32(ejs, v, "system_flags", &r->system_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_DELETE_ACCOUNT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_DELETE_ACCOUNT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_DELETE_SECRET(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_DELETE_SECRET *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_CIPHER_VALUE(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_CIPHER_VALUE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "len", &r->len));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxlen", &r->maxlen));
	if (NULL == r->cipher_data) {
		NDR_CHECK(ejs_push_null(ejs, v, "cipher_data"));
	} else {
		ejs_push_array_uint8(ejs, v, "cipher_data", r->cipher_data, r->len);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_SECRET(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_SECRET *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_CIPHER_VALUE(ejs, v, "current_cipher", &r->current_cipher));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "current_cipher_set_time", &r->current_cipher_set_time));
	NDR_CHECK(ejs_push_netr_CIPHER_VALUE(ejs, v, "old_cipher", &r->old_cipher));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "old_cipher_set_time", &r->old_cipher_set_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "SecurityInformation", &r->SecurityInformation));
	NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", &r->sdbuf));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown6", &r->unknown6));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown7", &r->unknown7));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown8", &r->unknown8));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DeltaEnum(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum netr_DeltaEnum *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_DELTA_UNION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NETR_DELTA_DOMAIN:
			if (NULL == r->domain) {
				NDR_CHECK(ejs_push_null(ejs, v, "domain"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_DOMAIN(ejs, v, "domain", r->domain));
			}
			break;
		case NETR_DELTA_GROUP:
			if (NULL == r->group) {
				NDR_CHECK(ejs_push_null(ejs, v, "group"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_GROUP(ejs, v, "group", r->group));
			}
			break;
		case NETR_DELTA_DELETE_GROUP:
			break;
		case NETR_DELTA_RENAME_GROUP:
			if (NULL == r->rename_group) {
				NDR_CHECK(ejs_push_null(ejs, v, "rename_group"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_RENAME(ejs, v, "rename_group", r->rename_group));
			}
			break;
		case NETR_DELTA_USER:
			if (NULL == r->user) {
				NDR_CHECK(ejs_push_null(ejs, v, "user"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_USER(ejs, v, "user", r->user));
			}
			break;
		case NETR_DELTA_DELETE_USER:
			break;
		case NETR_DELTA_RENAME_USER:
			if (NULL == r->rename_user) {
				NDR_CHECK(ejs_push_null(ejs, v, "rename_user"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_RENAME(ejs, v, "rename_user", r->rename_user));
			}
			break;
		case NETR_DELTA_GROUP_MEMBER:
			if (NULL == r->group_member) {
				NDR_CHECK(ejs_push_null(ejs, v, "group_member"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_GROUP_MEMBER(ejs, v, "group_member", r->group_member));
			}
			break;
		case NETR_DELTA_ALIAS:
			if (NULL == r->alias) {
				NDR_CHECK(ejs_push_null(ejs, v, "alias"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_ALIAS(ejs, v, "alias", r->alias));
			}
			break;
		case NETR_DELTA_DELETE_ALIAS:
			break;
		case NETR_DELTA_RENAME_ALIAS:
			if (NULL == r->rename_alias) {
				NDR_CHECK(ejs_push_null(ejs, v, "rename_alias"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_RENAME(ejs, v, "rename_alias", r->rename_alias));
			}
			break;
		case NETR_DELTA_ALIAS_MEMBER:
			if (NULL == r->alias_member) {
				NDR_CHECK(ejs_push_null(ejs, v, "alias_member"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_ALIAS_MEMBER(ejs, v, "alias_member", r->alias_member));
			}
			break;
		case NETR_DELTA_POLICY:
			if (NULL == r->policy) {
				NDR_CHECK(ejs_push_null(ejs, v, "policy"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_POLICY(ejs, v, "policy", r->policy));
			}
			break;
		case NETR_DELTA_TRUSTED_DOMAIN:
			if (NULL == r->trusted_domain) {
				NDR_CHECK(ejs_push_null(ejs, v, "trusted_domain"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_TRUSTED_DOMAIN(ejs, v, "trusted_domain", r->trusted_domain));
			}
			break;
		case NETR_DELTA_DELETE_TRUST:
			NDR_CHECK(ejs_push_netr_DELTA_DELETE_TRUST(ejs, v, "delete_trust", &r->delete_trust));
			break;
		case NETR_DELTA_ACCOUNT:
			if (NULL == r->account) {
				NDR_CHECK(ejs_push_null(ejs, v, "account"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_ACCOUNT(ejs, v, "account", r->account));
			}
			break;
		case NETR_DELTA_DELETE_ACCOUNT:
			NDR_CHECK(ejs_push_netr_DELTA_DELETE_ACCOUNT(ejs, v, "delete_account", &r->delete_account));
			break;
		case NETR_DELTA_SECRET:
			if (NULL == r->secret) {
				NDR_CHECK(ejs_push_null(ejs, v, "secret"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_SECRET(ejs, v, "secret", r->secret));
			}
			break;
		case NETR_DELTA_DELETE_SECRET:
			NDR_CHECK(ejs_push_netr_DELTA_DELETE_SECRET(ejs, v, "delete_secret", &r->delete_secret));
			break;
		case NETR_DELTA_DELETE_GROUP2:
			if (NULL == r->delete_group) {
				NDR_CHECK(ejs_push_null(ejs, v, "delete_group"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_DELETE_USER(ejs, v, "delete_group", r->delete_group));
			}
			break;
		case NETR_DELTA_DELETE_USER2:
			if (NULL == r->delete_user) {
				NDR_CHECK(ejs_push_null(ejs, v, "delete_user"));
			} else {
				NDR_CHECK(ejs_push_netr_DELTA_DELETE_USER(ejs, v, "delete_user", r->delete_user));
			}
			break;
		case NETR_DELTA_MODIFY_COUNT:
			if (NULL == r->modified_count) {
				NDR_CHECK(ejs_push_null(ejs, v, "modified_count"));
			} else {
				NDR_CHECK(ejs_push_udlong(ejs, v, "modified_count", r->modified_count));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_netr_DELTA_ID_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_DELTA_ID_UNION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NETR_DELTA_DOMAIN:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_GROUP:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_DELETE_GROUP:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_RENAME_GROUP:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_USER:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_DELETE_USER:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_RENAME_USER:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_GROUP_MEMBER:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_ALIAS:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_DELETE_ALIAS:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_RENAME_ALIAS:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_ALIAS_MEMBER:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_POLICY:
			if (NULL == r->sid) {
				NDR_CHECK(ejs_push_null(ejs, v, "sid"));
			} else {
				NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
			}
			break;
		case NETR_DELTA_TRUSTED_DOMAIN:
			if (NULL == r->sid) {
				NDR_CHECK(ejs_push_null(ejs, v, "sid"));
			} else {
				NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
			}
			break;
		case NETR_DELTA_DELETE_TRUST:
			if (NULL == r->sid) {
				NDR_CHECK(ejs_push_null(ejs, v, "sid"));
			} else {
				NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
			}
			break;
		case NETR_DELTA_ACCOUNT:
			if (NULL == r->sid) {
				NDR_CHECK(ejs_push_null(ejs, v, "sid"));
			} else {
				NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
			}
			break;
		case NETR_DELTA_DELETE_ACCOUNT:
			if (NULL == r->sid) {
				NDR_CHECK(ejs_push_null(ejs, v, "sid"));
			} else {
				NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
			}
			break;
		case NETR_DELTA_SECRET:
			if (NULL == r->name) {
				NDR_CHECK(ejs_push_null(ejs, v, "name"));
			} else {
				NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
			}
			break;
		case NETR_DELTA_DELETE_SECRET:
			if (NULL == r->name) {
				NDR_CHECK(ejs_push_null(ejs, v, "name"));
			} else {
				NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
			}
			break;
		case NETR_DELTA_DELETE_GROUP2:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_DELETE_USER2:
			NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
			break;
		case NETR_DELTA_MODIFY_COUNT:
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_netr_DELTA_ENUM(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_ENUM *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_DeltaEnum(ejs, v, "delta_type", &r->delta_type));
	ejs_set_switch(ejs, r->delta_type);
	NDR_CHECK(ejs_push_netr_DELTA_ID_UNION(ejs, v, "delta_id_union", &r->delta_id_union));
	ejs_set_switch(ejs, r->delta_type);
	NDR_CHECK(ejs_push_netr_DELTA_UNION(ejs, v, "delta_union", &r->delta_union));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DELTA_ENUM_ARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DELTA_ENUM_ARRAY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_deltas", &r->num_deltas));
	if (NULL == r->delta_enum) {
		NDR_CHECK(ejs_push_null(ejs, v, "delta_enum"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_deltas;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "delta_enum", i);
				NDR_CHECK(ejs_push_netr_DELTA_ENUM(ejs, v, id, &r->delta_enum[i]));
			}
			ejs_push_uint32(ejs, v, "delta_enum" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_UAS_INFO_0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_UAS_INFO_0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "computer_name", r->computer_name, 16);
	NDR_CHECK(ejs_push_uint32(ejs, v, "timecreated", &r->timecreated));
	NDR_CHECK(ejs_push_uint32(ejs, v, "serial_number", &r->serial_number));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_UAS_INFO_0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_UAS_INFO_0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "computer_name", r->computer_name, 16);
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timecreated", &r->timecreated));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "serial_number", &r->serial_number));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_NETLOGON_INFO_1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_NETLOGON_INFO_1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pdc_connection_status", &r->pdc_connection_status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_NETLOGON_INFO_2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_NETLOGON_INFO_2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pdc_connection_status", &r->pdc_connection_status));
	NDR_CHECK(ejs_push_string(ejs, v, "trusted_dc_name", r->trusted_dc_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tc_connection_status", &r->tc_connection_status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_NETLOGON_INFO_3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_NETLOGON_INFO_3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logon_attempts", &r->logon_attempts));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown4", &r->unknown4));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown5", &r->unknown5));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_CONTROL_QUERY_INFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_CONTROL_QUERY_INFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_netr_NETLOGON_INFO_1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (NULL == r->info2) {
				NDR_CHECK(ejs_push_null(ejs, v, "info2"));
			} else {
				NDR_CHECK(ejs_push_netr_NETLOGON_INFO_2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (NULL == r->info3) {
				NDR_CHECK(ejs_push_null(ejs, v, "info3"));
			} else {
				NDR_CHECK(ejs_push_netr_NETLOGON_INFO_3(ejs, v, "info3", r->info3));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_netr_LogonControlCode(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum netr_LogonControlCode *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_CONTROL_DATA_INFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union netr_CONTROL_DATA_INFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (ejs_pull_null(ejs, v, "domain")) {
				r->domain = NULL;
			} else {
				EJS_ALLOC(ejs, r->domain);
				NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
			}
			break;
		case NETLOGON_CONTROL_TC_QUERY:
			if (ejs_pull_null(ejs, v, "domain")) {
				r->domain = NULL;
			} else {
				EJS_ALLOC(ejs, r->domain);
				NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
			}
			break;
		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (ejs_pull_null(ejs, v, "domain")) {
				r->domain = NULL;
			} else {
				EJS_ALLOC(ejs, r->domain);
				NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
			}
			break;
		case NETLOGON_CONTROL_SET_DBFLAG:
			NDR_CHECK(ejs_pull_uint32(ejs, v, "debug_level", &r->debug_level));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_netr_DsRGetDCNameInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DsRGetDCNameInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->dc_unc) {
		NDR_CHECK(ejs_push_null(ejs, v, "dc_unc"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dc_unc", r->dc_unc));
	}
	if (NULL == r->dc_address) {
		NDR_CHECK(ejs_push_null(ejs, v, "dc_address"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dc_address", r->dc_address));
	}
	NDR_CHECK(ejs_push_int32(ejs, v, "dc_address_type", &r->dc_address_type));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_guid", &r->domain_guid));
	if (NULL == r->domain_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	}
	if (NULL == r->forest_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "forest_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "forest_name", r->forest_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "dc_flags", &r->dc_flags));
	if (NULL == r->dc_site_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dc_site_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dc_site_name", r->dc_site_name));
	}
	if (NULL == r->client_site_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "client_site_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client_site_name", r->client_site_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_Blob(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_Blob *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->length);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_BinaryString(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_BinaryString *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->length / 2;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "data", i);
				NDR_CHECK(ejs_push_uint16(ejs, v, id, &r->data[i]));
			}
			ejs_push_uint32(ejs, v, "data" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_BinaryString(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_BinaryString *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "size", &r->size));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->data, r->size / 2);
			for (i=0;i<r->length / 2;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "data", i);
				NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->data[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "data" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_DomainQuery1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_DomainQuery1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_Blob(ejs, v, "blob", &r->blob));
	if (ejs_pull_null(ejs, v, "workstation_domain")) {
		r->workstation_domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->workstation_domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "workstation_domain", &r->workstation_domain));
	}
	if (ejs_pull_null(ejs, v, "workstation_site")) {
		r->workstation_site = NULL;
	} else {
		EJS_ALLOC(ejs, r->workstation_site);
		NDR_CHECK(ejs_pull_string(ejs, v, "workstation_site", &r->workstation_site));
	}
	if (ejs_pull_null(ejs, v, "unknown1")) {
		r->unknown1 = NULL;
	} else {
		EJS_ALLOC(ejs, r->unknown1);
		NDR_CHECK(ejs_pull_string(ejs, v, "unknown1", &r->unknown1));
	}
	if (ejs_pull_null(ejs, v, "unknown2")) {
		r->unknown2 = NULL;
	} else {
		EJS_ALLOC(ejs, r->unknown2);
		NDR_CHECK(ejs_pull_string(ejs, v, "unknown2", &r->unknown2));
	}
	if (ejs_pull_null(ejs, v, "unknown3")) {
		r->unknown3 = NULL;
	} else {
		EJS_ALLOC(ejs, r->unknown3);
		NDR_CHECK(ejs_pull_string(ejs, v, "unknown3", &r->unknown3));
	}
	if (ejs_pull_null(ejs, v, "unknown4")) {
		r->unknown4 = NULL;
	} else {
		EJS_ALLOC(ejs, r->unknown4);
		NDR_CHECK(ejs_pull_string(ejs, v, "unknown4", &r->unknown4));
	}
	NDR_CHECK(ejs_pull_netr_BinaryString(ejs, v, "blob2", &r->blob2));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "product", &r->product));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown5", &r->unknown5));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown6", &r->unknown6));
	{
		uint32_t i;
		for (i=0;i<4;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown7", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown7[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown7" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_netr_DomainQuery(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union netr_DomainQuery *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (ejs_pull_null(ejs, v, "query1")) {
				r->query1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->query1);
				NDR_CHECK(ejs_pull_netr_DomainQuery1(ejs, v, "query1", r->query1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "query1")) {
				r->query1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->query1);
				NDR_CHECK(ejs_pull_netr_DomainQuery1(ejs, v, "query1", r->query1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_netr_DomainTrustInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DomainTrustInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domainname", &r->domainname));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "fulldomainname", &r->fulldomainname));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	{
		uint32_t i;
		for (i=0;i<4;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown1", i);
			NDR_CHECK(ejs_push_netr_BinaryString(ejs, v, id, &r->unknown1[i]));
		}
		ejs_push_uint32(ejs, v, "unknown1" ".length", &i);
	}
	{
		uint32_t i;
		for (i=0;i<4;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown[i]));
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DomainInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DomainInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_DomainTrustInfo(ejs, v, "domaininfo", &r->domaininfo));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_trusts", &r->num_trusts));
	if (NULL == r->trusts) {
		NDR_CHECK(ejs_push_null(ejs, v, "trusts"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_trusts;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "trusts", i);
				NDR_CHECK(ejs_push_netr_DomainTrustInfo(ejs, v, id, &r->trusts[i]));
			}
			ejs_push_uint32(ejs, v, "trusts" ".length", &i);
		}
	}
	{
		uint32_t i;
		for (i=0;i<14;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown[i]));
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_DomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union netr_DomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_netr_DomainInfo1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_netr_DomainInfo1(ejs, v, "info1", r->info1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_netr_CryptPassword(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct netr_CryptPassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "data", r->data, 512);
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_TrustFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_netr_TrustFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_netr_TrustType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum netr_TrustType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_netr_TrustAttributes(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_netr_DomainTrust(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct netr_DomainTrust *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->netbios_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "netbios_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "netbios_name", r->netbios_name));
	}
	if (NULL == r->dns_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "dns_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dns_name", r->dns_name));
	}
	NDR_CHECK(ejs_push_netr_TrustFlags(ejs, v, "trust_flags", &r->trust_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "parent_index", &r->parent_index));
	NDR_CHECK(ejs_push_netr_TrustType(ejs, v, "trust_type", &r->trust_type));
	NDR_CHECK(ejs_push_netr_TrustAttributes(ejs, v, "trust_attributes", &r->trust_attributes));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_push_GUID(ejs, v, "guid", &r->guid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_netr_LogonUasLogon(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonUasLogon *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "workstation", &r->in.workstation));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonUasLogon(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonUasLogon *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_netr_UasInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonUasLogon(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONUASLOGON, (ejs_pull_function_t)ejs_pull_netr_LogonUasLogon, (ejs_push_function_t)ejs_push_netr_LogonUasLogon);
}


static NTSTATUS ejs_pull_netr_LogonUasLogoff(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonUasLogoff *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "workstation", &r->in.workstation));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonUasLogoff(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonUasLogoff *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_UasLogoffInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonUasLogoff(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONUASLOGOFF, (ejs_pull_function_t)ejs_pull_netr_LogonUasLogoff, (ejs_push_function_t)ejs_push_netr_LogonUasLogoff);
}


static NTSTATUS ejs_pull_netr_LogonSamLogon(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonSamLogon *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	if (ejs_pull_null(ejs, v, "credential")) {
		r->in.credential = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.credential);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", r->in.credential));
	}
	if (ejs_pull_null(ejs, v, "return_authenticator")) {
		r->in.return_authenticator = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.return_authenticator);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", r->in.return_authenticator));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_level", &r->in.logon_level));
	ejs_set_switch(ejs, r->in.logon_level);
	NDR_CHECK(ejs_pull_netr_LogonLevel(ejs, v, "logon", &r->in.logon));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "validation_level", &r->in.validation_level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonSamLogon(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonSamLogon *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.return_authenticator) {
		NDR_CHECK(ejs_push_null(ejs, v, "return_authenticator"));
	} else {
		NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", r->out.return_authenticator));
	}
	ejs_set_switch(ejs, r->in.validation_level);
	NDR_CHECK(ejs_push_netr_Validation(ejs, v, "validation", &r->out.validation));
	NDR_CHECK(ejs_push_uint8(ejs, v, "authoritative", &r->out.authoritative));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonSamLogon(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONSAMLOGON, (ejs_pull_function_t)ejs_pull_netr_LogonSamLogon, (ejs_push_function_t)ejs_push_netr_LogonSamLogon);
}


static NTSTATUS ejs_pull_netr_LogonSamLogoff(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonSamLogoff *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	if (ejs_pull_null(ejs, v, "credential")) {
		r->in.credential = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.credential);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", r->in.credential));
	}
	if (ejs_pull_null(ejs, v, "return_authenticator")) {
		r->in.return_authenticator = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.return_authenticator);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", r->in.return_authenticator));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_level", &r->in.logon_level));
	ejs_set_switch(ejs, r->in.logon_level);
	NDR_CHECK(ejs_pull_netr_LogonLevel(ejs, v, "logon", &r->in.logon));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonSamLogoff(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonSamLogoff *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.return_authenticator) {
		NDR_CHECK(ejs_push_null(ejs, v, "return_authenticator"));
	} else {
		NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", r->out.return_authenticator));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonSamLogoff(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONSAMLOGOFF, (ejs_pull_function_t)ejs_pull_netr_LogonSamLogoff, (ejs_push_function_t)ejs_push_netr_LogonSamLogoff);
}


static NTSTATUS ejs_pull_netr_ServerReqChallenge(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerReqChallenge *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	if (ejs_pull_null(ejs, v, "credentials")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.credentials);
		NDR_CHECK(ejs_pull_netr_Credential(ejs, v, "credentials", r->in.credentials));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerReqChallenge(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerReqChallenge *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.credentials) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_netr_Credential(ejs, v, "credentials", r->out.credentials));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerReqChallenge(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERREQCHALLENGE, (ejs_pull_function_t)ejs_pull_netr_ServerReqChallenge, (ejs_push_function_t)ejs_push_netr_ServerReqChallenge);
}


static NTSTATUS ejs_pull_netr_ServerAuthenticate(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerAuthenticate *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_netr_SchannelType(ejs, v, "secure_channel_type", &r->in.secure_channel_type));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	if (ejs_pull_null(ejs, v, "credentials")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.credentials);
		NDR_CHECK(ejs_pull_netr_Credential(ejs, v, "credentials", r->in.credentials));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerAuthenticate(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerAuthenticate *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.credentials) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_netr_Credential(ejs, v, "credentials", r->out.credentials));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerAuthenticate(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERAUTHENTICATE, (ejs_pull_function_t)ejs_pull_netr_ServerAuthenticate, (ejs_push_function_t)ejs_push_netr_ServerAuthenticate);
}


static NTSTATUS ejs_pull_netr_ServerPasswordSet(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerPasswordSet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_netr_SchannelType(ejs, v, "secure_channel_type", &r->in.secure_channel_type));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_samr_Password(ejs, v, "new_password", &r->in.new_password));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerPasswordSet(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerPasswordSet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerPasswordSet(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERPASSWORDSET, (ejs_pull_function_t)ejs_pull_netr_ServerPasswordSet, (ejs_push_function_t)ejs_push_netr_ServerPasswordSet);
}


static NTSTATUS ejs_pull_netr_DatabaseDeltas(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DatabaseDeltas *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_netr_SamDatabaseID(ejs, v, "database_id", &r->in.database_id));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "sequence_num", &r->in.sequence_num));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "preferredmaximumlength", &r->in.preferredmaximumlength));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DatabaseDeltas(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DatabaseDeltas *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	NDR_CHECK(ejs_push_udlong(ejs, v, "sequence_num", &r->out.sequence_num));
	if (NULL == r->out.delta_enum_array) {
		NDR_CHECK(ejs_push_null(ejs, v, "delta_enum_array"));
	} else {
		NDR_CHECK(ejs_push_netr_DELTA_ENUM_ARRAY(ejs, v, "delta_enum_array", r->out.delta_enum_array));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DatabaseDeltas(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DATABASEDELTAS, (ejs_pull_function_t)ejs_pull_netr_DatabaseDeltas, (ejs_push_function_t)ejs_push_netr_DatabaseDeltas);
}


static NTSTATUS ejs_pull_netr_DatabaseSync(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DatabaseSync *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_netr_SamDatabaseID(ejs, v, "database_id", &r->in.database_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sync_context", &r->in.sync_context));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "preferredmaximumlength", &r->in.preferredmaximumlength));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DatabaseSync(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DatabaseSync *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sync_context", &r->out.sync_context));
	if (NULL == r->out.delta_enum_array) {
		NDR_CHECK(ejs_push_null(ejs, v, "delta_enum_array"));
	} else {
		NDR_CHECK(ejs_push_netr_DELTA_ENUM_ARRAY(ejs, v, "delta_enum_array", r->out.delta_enum_array));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DatabaseSync(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DATABASESYNC, (ejs_pull_function_t)ejs_pull_netr_DatabaseSync, (ejs_push_function_t)ejs_push_netr_DatabaseSync);
}


static NTSTATUS ejs_pull_netr_AccountDeltas(struct ejs_rpc *ejs, struct MprVar *v, struct netr_AccountDeltas *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_netr_UAS_INFO_0(ejs, v, "uas", &r->in.uas));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->in.count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buffersize", &r->in.buffersize));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_AccountDeltas(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_AccountDeltas *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	NDR_CHECK(ejs_push_uint32(ejs, v, "count_returned", &r->out.count_returned));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_entries", &r->out.total_entries));
	NDR_CHECK(ejs_push_netr_UAS_INFO_0(ejs, v, "recordid", &r->out.recordid));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_AccountDeltas(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_ACCOUNTDELTAS, (ejs_pull_function_t)ejs_pull_netr_AccountDeltas, (ejs_push_function_t)ejs_push_netr_AccountDeltas);
}


static NTSTATUS ejs_pull_netr_AccountSync(struct ejs_rpc *ejs, struct MprVar *v, struct netr_AccountSync *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reference", &r->in.reference));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buffersize", &r->in.buffersize));
	NDR_CHECK(ejs_pull_netr_UAS_INFO_0(ejs, v, "recordid", &r->in.recordid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_AccountSync(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_AccountSync *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	NDR_CHECK(ejs_push_uint32(ejs, v, "count_returned", &r->out.count_returned));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_entries", &r->out.total_entries));
	NDR_CHECK(ejs_push_uint32(ejs, v, "next_reference", &r->out.next_reference));
	NDR_CHECK(ejs_push_netr_UAS_INFO_0(ejs, v, "recordid", &r->out.recordid));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_AccountSync(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_ACCOUNTSYNC, (ejs_pull_function_t)ejs_pull_netr_AccountSync, (ejs_push_function_t)ejs_push_netr_AccountSync);
}


static NTSTATUS ejs_pull_netr_GetDcName(struct ejs_rpc *ejs, struct MprVar *v, struct netr_GetDcName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	if (ejs_pull_null(ejs, v, "domainname")) {
		r->in.domainname = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domainname);
		NDR_CHECK(ejs_pull_string(ejs, v, "domainname", &r->in.domainname));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_GetDcName(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_GetDcName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.dcname) {
		NDR_CHECK(ejs_push_null(ejs, v, "dcname"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dcname", r->out.dcname));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_GetDcName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_GETDCNAME, (ejs_pull_function_t)ejs_pull_netr_GetDcName, (ejs_push_function_t)ejs_push_netr_GetDcName);
}


static NTSTATUS ejs_pull_netr_LogonControl(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonControl *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	NDR_CHECK(ejs_pull_netr_LogonControlCode(ejs, v, "function_code", &r->in.function_code));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonControl(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonControl *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_netr_CONTROL_QUERY_INFORMATION(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonControl(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONCONTROL, (ejs_pull_function_t)ejs_pull_netr_LogonControl, (ejs_push_function_t)ejs_push_netr_LogonControl);
}


static NTSTATUS ejs_pull_netr_GetAnyDCName(struct ejs_rpc *ejs, struct MprVar *v, struct netr_GetAnyDCName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	if (ejs_pull_null(ejs, v, "domainname")) {
		r->in.domainname = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domainname);
		NDR_CHECK(ejs_pull_string(ejs, v, "domainname", &r->in.domainname));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_GetAnyDCName(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_GetAnyDCName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.dcname) {
		NDR_CHECK(ejs_push_null(ejs, v, "dcname"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "dcname", r->out.dcname));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_GetAnyDCName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_GETANYDCNAME, (ejs_pull_function_t)ejs_pull_netr_GetAnyDCName, (ejs_push_function_t)ejs_push_netr_GetAnyDCName);
}


static NTSTATUS ejs_pull_netr_LogonControl2(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonControl2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "function_code", &r->in.function_code));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.function_code);
	NDR_CHECK(ejs_pull_netr_CONTROL_DATA_INFORMATION(ejs, v, "data", &r->in.data));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonControl2(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonControl2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_netr_CONTROL_QUERY_INFORMATION(ejs, v, "query", &r->out.query));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonControl2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONCONTROL2, (ejs_pull_function_t)ejs_pull_netr_LogonControl2, (ejs_push_function_t)ejs_push_netr_LogonControl2);
}


static NTSTATUS ejs_pull_netr_ServerAuthenticate2(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerAuthenticate2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_netr_SchannelType(ejs, v, "secure_channel_type", &r->in.secure_channel_type));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	if (ejs_pull_null(ejs, v, "credentials")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.credentials);
		NDR_CHECK(ejs_pull_netr_Credential(ejs, v, "credentials", r->in.credentials));
	}
	if (ejs_pull_null(ejs, v, "negotiate_flags")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.negotiate_flags);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "negotiate_flags", r->in.negotiate_flags));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerAuthenticate2(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerAuthenticate2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.credentials) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_netr_Credential(ejs, v, "credentials", r->out.credentials));
	}
	if (NULL == r->out.negotiate_flags) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "negotiate_flags", r->out.negotiate_flags));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerAuthenticate2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERAUTHENTICATE2, (ejs_pull_function_t)ejs_pull_netr_ServerAuthenticate2, (ejs_push_function_t)ejs_push_netr_ServerAuthenticate2);
}


static NTSTATUS ejs_pull_netr_DatabaseSync2(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DatabaseSync2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_netr_SamDatabaseID(ejs, v, "database_id", &r->in.database_id));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "restart_state", &r->in.restart_state));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sync_context", &r->in.sync_context));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "preferredmaximumlength", &r->in.preferredmaximumlength));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DatabaseSync2(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DatabaseSync2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sync_context", &r->out.sync_context));
	if (NULL == r->out.delta_enum_array) {
		NDR_CHECK(ejs_push_null(ejs, v, "delta_enum_array"));
	} else {
		NDR_CHECK(ejs_push_netr_DELTA_ENUM_ARRAY(ejs, v, "delta_enum_array", r->out.delta_enum_array));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DatabaseSync2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DATABASESYNC2, (ejs_pull_function_t)ejs_pull_netr_DatabaseSync2, (ejs_push_function_t)ejs_push_netr_DatabaseSync2);
}


static NTSTATUS ejs_pull_netr_DatabaseRedo(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DatabaseRedo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	NDR_CHECK(ejs_pull_string(ejs, v, "computername", &r->in.computername));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", &r->in.return_authenticator));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "change_log_entry_size", &r->in.change_log_entry_size));
	if (ejs_pull_null(ejs, v, "change_log_entry")) {
		r->in.change_log_entry = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.change_log_entry);
		EJS_ALLOC_N(ejs, r->in.change_log_entry, r->in.change_log_entry_size);
		ejs_pull_array_uint8(ejs, v, "change_log_entry", r->in.change_log_entry, r->in.change_log_entry_size);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DatabaseRedo(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DatabaseRedo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	if (NULL == r->out.delta_enum_array) {
		NDR_CHECK(ejs_push_null(ejs, v, "delta_enum_array"));
	} else {
		NDR_CHECK(ejs_push_netr_DELTA_ENUM_ARRAY(ejs, v, "delta_enum_array", r->out.delta_enum_array));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DatabaseRedo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DATABASEREDO, (ejs_pull_function_t)ejs_pull_netr_DatabaseRedo, (ejs_push_function_t)ejs_push_netr_DatabaseRedo);
}


static NTSTATUS ejs_pull_netr_LogonControl2Ex(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonControl2Ex *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->in.logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->in.logon_server));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "function_code", &r->in.function_code));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.function_code);
	NDR_CHECK(ejs_pull_netr_CONTROL_DATA_INFORMATION(ejs, v, "data", &r->in.data));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonControl2Ex(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonControl2Ex *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_netr_CONTROL_QUERY_INFORMATION(ejs, v, "query", &r->out.query));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonControl2Ex(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONCONTROL2EX, (ejs_pull_function_t)ejs_pull_netr_LogonControl2Ex, (ejs_push_function_t)ejs_push_netr_LogonControl2Ex);
}


static NTSTATUS ejs_pull_netr_NETRENUMERATETRUSTEDDOMAINS(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRENUMERATETRUSTEDDOMAINS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRENUMERATETRUSTEDDOMAINS(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRENUMERATETRUSTEDDOMAINS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRENUMERATETRUSTEDDOMAINS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRENUMERATETRUSTEDDOMAINS, (ejs_pull_function_t)ejs_pull_netr_NETRENUMERATETRUSTEDDOMAINS, (ejs_push_function_t)ejs_push_netr_NETRENUMERATETRUSTEDDOMAINS);
}


static NTSTATUS ejs_pull_netr_DsRGetDCName(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DsRGetDCName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->in.domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->in.domain_name));
	}
	if (ejs_pull_null(ejs, v, "domain_guid")) {
		r->in.domain_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_guid", r->in.domain_guid));
	}
	if (ejs_pull_null(ejs, v, "site_guid")) {
		r->in.site_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.site_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "site_guid", r->in.site_guid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DsRGetDCName(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DsRGetDCName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_netr_DsRGetDCNameInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DsRGetDCName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETDCNAME, (ejs_pull_function_t)ejs_pull_netr_DsRGetDCName, (ejs_push_function_t)ejs_push_netr_DsRGetDCName);
}


static NTSTATUS ejs_pull_netr_NETRLOGONDUMMYROUTINE1(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONDUMMYROUTINE1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONDUMMYROUTINE1(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONDUMMYROUTINE1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONDUMMYROUTINE1(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONDUMMYROUTINE1, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONDUMMYROUTINE1, (ejs_push_function_t)ejs_push_netr_NETRLOGONDUMMYROUTINE1);
}


static NTSTATUS ejs_pull_netr_NETRLOGONSETSERVICEBITS(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONSETSERVICEBITS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONSETSERVICEBITS(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONSETSERVICEBITS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONSETSERVICEBITS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONSETSERVICEBITS, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONSETSERVICEBITS, (ejs_push_function_t)ejs_push_netr_NETRLOGONSETSERVICEBITS);
}


static NTSTATUS ejs_pull_netr_NETRLOGONGETTRUSTRID(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONGETTRUSTRID *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONGETTRUSTRID(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONGETTRUSTRID *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONGETTRUSTRID(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONGETTRUSTRID, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONGETTRUSTRID, (ejs_push_function_t)ejs_push_netr_NETRLOGONGETTRUSTRID);
}


static NTSTATUS ejs_pull_netr_NETRLOGONCOMPUTESERVERDIGEST(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONCOMPUTESERVERDIGEST *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONCOMPUTESERVERDIGEST(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONCOMPUTESERVERDIGEST *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONCOMPUTESERVERDIGEST(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONCOMPUTESERVERDIGEST, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONCOMPUTESERVERDIGEST, (ejs_push_function_t)ejs_push_netr_NETRLOGONCOMPUTESERVERDIGEST);
}


static NTSTATUS ejs_pull_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONCOMPUTECLIENTDIGEST(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONCOMPUTECLIENTDIGEST, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONCOMPUTECLIENTDIGEST, (ejs_push_function_t)ejs_push_netr_NETRLOGONCOMPUTECLIENTDIGEST);
}


static NTSTATUS ejs_pull_netr_ServerAuthenticate3(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerAuthenticate3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_netr_SchannelType(ejs, v, "secure_channel_type", &r->in.secure_channel_type));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	if (ejs_pull_null(ejs, v, "credentials")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.credentials);
		NDR_CHECK(ejs_pull_netr_Credential(ejs, v, "credentials", r->in.credentials));
	}
	if (ejs_pull_null(ejs, v, "negotiate_flags")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.negotiate_flags);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "negotiate_flags", r->in.negotiate_flags));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerAuthenticate3(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerAuthenticate3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.credentials) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_netr_Credential(ejs, v, "credentials", r->out.credentials));
	}
	if (NULL == r->out.negotiate_flags) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "negotiate_flags", r->out.negotiate_flags));
	}
	if (NULL == r->out.rid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rid", r->out.rid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerAuthenticate3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERAUTHENTICATE3, (ejs_pull_function_t)ejs_pull_netr_ServerAuthenticate3, (ejs_push_function_t)ejs_push_netr_ServerAuthenticate3);
}


static NTSTATUS ejs_pull_netr_DsRGetDCNameEx(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DsRGetDCNameEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->in.domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->in.domain_name));
	}
	if (ejs_pull_null(ejs, v, "domain_guid")) {
		r->in.domain_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_guid", r->in.domain_guid));
	}
	if (ejs_pull_null(ejs, v, "site_name")) {
		r->in.site_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.site_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "site_name", &r->in.site_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DsRGetDCNameEx(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DsRGetDCNameEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_netr_DsRGetDCNameInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DsRGetDCNameEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETDCNAMEEX, (ejs_pull_function_t)ejs_pull_netr_DsRGetDCNameEx, (ejs_push_function_t)ejs_push_netr_DsRGetDCNameEx);
}


static NTSTATUS ejs_pull_netr_DsRGetSiteName(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DsRGetSiteName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DsRGetSiteName(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DsRGetSiteName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.site) {
		NDR_CHECK(ejs_push_null(ejs, v, "site"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "site", r->out.site));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DsRGetSiteName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETSITENAME, (ejs_pull_function_t)ejs_pull_netr_DsRGetSiteName, (ejs_push_function_t)ejs_push_netr_DsRGetSiteName);
}


static NTSTATUS ejs_pull_netr_LogonGetDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonGetDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	if (ejs_pull_null(ejs, v, "credential")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.credential);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", r->in.credential));
	}
	if (ejs_pull_null(ejs, v, "return_authenticator")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.return_authenticator);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", r->in.return_authenticator));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_netr_DomainQuery(ejs, v, "query", &r->in.query));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonGetDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonGetDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.return_authenticator) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", r->out.return_authenticator));
	}
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_netr_DomainInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonGetDomainInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONGETDOMAININFO, (ejs_pull_function_t)ejs_pull_netr_LogonGetDomainInfo, (ejs_push_function_t)ejs_push_netr_LogonGetDomainInfo);
}


static NTSTATUS ejs_pull_netr_ServerPasswordSet2(struct ejs_rpc *ejs, struct MprVar *v, struct netr_ServerPasswordSet2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	NDR_CHECK(ejs_pull_netr_SchannelType(ejs, v, "secure_channel_type", &r->in.secure_channel_type));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", &r->in.credential));
	NDR_CHECK(ejs_pull_netr_CryptPassword(ejs, v, "new_password", &r->in.new_password));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_ServerPasswordSet2(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_ServerPasswordSet2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", &r->out.return_authenticator));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_ServerPasswordSet2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_SERVERPASSWORDSET2, (ejs_pull_function_t)ejs_pull_netr_ServerPasswordSet2, (ejs_push_function_t)ejs_push_netr_ServerPasswordSet2);
}


static NTSTATUS ejs_pull_netr_NETRSERVERPASSWORDGET(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRSERVERPASSWORDGET *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRSERVERPASSWORDGET(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRSERVERPASSWORDGET *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRSERVERPASSWORDGET(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRSERVERPASSWORDGET, (ejs_pull_function_t)ejs_pull_netr_NETRSERVERPASSWORDGET, (ejs_push_function_t)ejs_push_netr_NETRSERVERPASSWORDGET);
}


static NTSTATUS ejs_pull_netr_NETRLOGONSENDTOSAM(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONSENDTOSAM *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONSENDTOSAM(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONSENDTOSAM *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONSENDTOSAM(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONSENDTOSAM, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONSENDTOSAM, (ejs_push_function_t)ejs_push_netr_NETRLOGONSENDTOSAM);
}


static NTSTATUS ejs_pull_netr_DSRADDRESSTOSITENAMESW(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DSRADDRESSTOSITENAMESW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DSRADDRESSTOSITENAMESW(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DSRADDRESSTOSITENAMESW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DSRADDRESSTOSITENAMESW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRADDRESSTOSITENAMESW, (ejs_pull_function_t)ejs_pull_netr_DSRADDRESSTOSITENAMESW, (ejs_push_function_t)ejs_push_netr_DSRADDRESSTOSITENAMESW);
}


static NTSTATUS ejs_pull_netr_DsRGetDCNameEx2(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DsRGetDCNameEx2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "client_account")) {
		r->in.client_account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.client_account);
		NDR_CHECK(ejs_pull_string(ejs, v, "client_account", &r->in.client_account));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "mask", &r->in.mask));
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->in.domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->in.domain_name));
	}
	if (ejs_pull_null(ejs, v, "domain_guid")) {
		r->in.domain_guid = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_guid);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_guid", r->in.domain_guid));
	}
	if (ejs_pull_null(ejs, v, "site_name")) {
		r->in.site_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.site_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "site_name", &r->in.site_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DsRGetDCNameEx2(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DsRGetDCNameEx2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_netr_DsRGetDCNameInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DsRGetDCNameEx2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETDCNAMEEX2, (ejs_pull_function_t)ejs_pull_netr_DsRGetDCNameEx2, (ejs_push_function_t)ejs_push_netr_DsRGetDCNameEx2);
}


static NTSTATUS ejs_pull_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN, (ejs_pull_function_t)ejs_pull_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, (ejs_push_function_t)ejs_push_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN);
}


static NTSTATUS ejs_pull_netr_NETRENUMERATETRUSTEDDOMAINSEX(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRENUMERATETRUSTEDDOMAINSEX *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRENUMERATETRUSTEDDOMAINSEX(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRENUMERATETRUSTEDDOMAINSEX *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRENUMERATETRUSTEDDOMAINSEX(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRENUMERATETRUSTEDDOMAINSEX, (ejs_pull_function_t)ejs_pull_netr_NETRENUMERATETRUSTEDDOMAINSEX, (ejs_push_function_t)ejs_push_netr_NETRENUMERATETRUSTEDDOMAINSEX);
}


static NTSTATUS ejs_pull_netr_DSRADDRESSTOSITENAMESEXW(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DSRADDRESSTOSITENAMESEXW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DSRADDRESSTOSITENAMESEXW(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DSRADDRESSTOSITENAMESEXW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DSRADDRESSTOSITENAMESEXW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRADDRESSTOSITENAMESEXW, (ejs_pull_function_t)ejs_pull_netr_DSRADDRESSTOSITENAMESEXW, (ejs_push_function_t)ejs_push_netr_DSRADDRESSTOSITENAMESEXW);
}


static NTSTATUS ejs_pull_netr_DSRGETDCSITECOVERAGEW(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DSRGETDCSITECOVERAGEW *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DSRGETDCSITECOVERAGEW(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DSRGETDCSITECOVERAGEW *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DSRGETDCSITECOVERAGEW(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETDCSITECOVERAGEW, (ejs_pull_function_t)ejs_pull_netr_DSRGETDCSITECOVERAGEW, (ejs_push_function_t)ejs_push_netr_DSRGETDCSITECOVERAGEW);
}


static NTSTATUS ejs_pull_netr_LogonSamLogonEx(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonSamLogonEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_level", &r->in.logon_level));
	ejs_set_switch(ejs, r->in.logon_level);
	NDR_CHECK(ejs_pull_netr_LogonLevel(ejs, v, "logon", &r->in.logon));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "validation_level", &r->in.validation_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonSamLogonEx(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonSamLogonEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.validation_level);
	NDR_CHECK(ejs_push_netr_Validation(ejs, v, "validation", &r->out.validation));
	NDR_CHECK(ejs_push_uint8(ejs, v, "authoritative", &r->out.authoritative));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->out.flags));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonSamLogonEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONSAMLOGONEX, (ejs_pull_function_t)ejs_pull_netr_LogonSamLogonEx, (ejs_push_function_t)ejs_push_netr_LogonSamLogonEx);
}


static NTSTATUS ejs_pull_netr_DsrEnumerateDomainTrusts(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DsrEnumerateDomainTrusts *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_netr_TrustFlags(ejs, v, "trust_flags", &r->in.trust_flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DsrEnumerateDomainTrusts(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DsrEnumerateDomainTrusts *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->out.count));
	if (NULL == r->out.trusts) {
		NDR_CHECK(ejs_push_null(ejs, v, "trusts"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->out.count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "trusts", i);
				NDR_CHECK(ejs_push_netr_DomainTrust(ejs, v, id, &r->out.trusts[i]));
			}
			ejs_push_uint32(ejs, v, "trusts" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DsrEnumerateDomainTrusts(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRENUMERATEDOMAINTRUSTS, (ejs_pull_function_t)ejs_pull_netr_DsrEnumerateDomainTrusts, (ejs_push_function_t)ejs_push_netr_DsrEnumerateDomainTrusts);
}


static NTSTATUS ejs_pull_netr_DSRDEREGISTERDNSHOSTRECORDS(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DSRDEREGISTERDNSHOSTRECORDS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DSRDEREGISTERDNSHOSTRECORDS(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DSRDEREGISTERDNSHOSTRECORDS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DSRDEREGISTERDNSHOSTRECORDS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRDEREGISTERDNSHOSTRECORDS, (ejs_pull_function_t)ejs_pull_netr_DSRDEREGISTERDNSHOSTRECORDS, (ejs_push_function_t)ejs_push_netr_DSRDEREGISTERDNSHOSTRECORDS);
}


static NTSTATUS ejs_pull_netr_NETRSERVERTRUSTPASSWORDSGET(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRSERVERTRUSTPASSWORDSGET *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRSERVERTRUSTPASSWORDSGET(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRSERVERTRUSTPASSWORDSGET *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRSERVERTRUSTPASSWORDSGET(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRSERVERTRUSTPASSWORDSGET, (ejs_pull_function_t)ejs_pull_netr_NETRSERVERTRUSTPASSWORDSGET, (ejs_push_function_t)ejs_push_netr_NETRSERVERTRUSTPASSWORDSGET);
}


static NTSTATUS ejs_pull_netr_DSRGETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, struct netr_DSRGETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_DSRGETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_DSRGETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_DSRGETFORESTTRUSTINFORMATION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_DSRGETFORESTTRUSTINFORMATION, (ejs_pull_function_t)ejs_pull_netr_DSRGETFORESTTRUSTINFORMATION, (ejs_push_function_t)ejs_push_netr_DSRGETFORESTTRUSTINFORMATION);
}


static NTSTATUS ejs_pull_netr_NETRGETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRGETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRGETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRGETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRGETFORESTTRUSTINFORMATION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRGETFORESTTRUSTINFORMATION, (ejs_pull_function_t)ejs_pull_netr_NETRGETFORESTTRUSTINFORMATION, (ejs_push_function_t)ejs_push_netr_NETRGETFORESTTRUSTINFORMATION);
}


static NTSTATUS ejs_pull_netr_LogonSamLogonWithFlags(struct ejs_rpc *ejs, struct MprVar *v, struct netr_LogonSamLogonWithFlags *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "computer_name")) {
		r->in.computer_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.computer_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	}
	if (ejs_pull_null(ejs, v, "credential")) {
		r->in.credential = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.credential);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "credential", r->in.credential));
	}
	if (ejs_pull_null(ejs, v, "return_authenticator")) {
		r->in.return_authenticator = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.return_authenticator);
		NDR_CHECK(ejs_pull_netr_Authenticator(ejs, v, "return_authenticator", r->in.return_authenticator));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_level", &r->in.logon_level));
	ejs_set_switch(ejs, r->in.logon_level);
	NDR_CHECK(ejs_pull_netr_LogonLevel(ejs, v, "logon", &r->in.logon));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "validation_level", &r->in.validation_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_LogonSamLogonWithFlags(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_LogonSamLogonWithFlags *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.return_authenticator) {
		NDR_CHECK(ejs_push_null(ejs, v, "return_authenticator"));
	} else {
		NDR_CHECK(ejs_push_netr_Authenticator(ejs, v, "return_authenticator", r->out.return_authenticator));
	}
	ejs_set_switch(ejs, r->in.validation_level);
	NDR_CHECK(ejs_push_netr_Validation(ejs, v, "validation", &r->out.validation));
	NDR_CHECK(ejs_push_uint8(ejs, v, "authoritative", &r->out.authoritative));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->out.flags));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_LogonSamLogonWithFlags(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_LOGONSAMLOGONWITHFLAGS, (ejs_pull_function_t)ejs_pull_netr_LogonSamLogonWithFlags, (ejs_push_function_t)ejs_push_netr_LogonSamLogonWithFlags);
}


static NTSTATUS ejs_pull_netr_NETRSERVERGETTRUSTINFO(struct ejs_rpc *ejs, struct MprVar *v, struct netr_NETRSERVERGETTRUSTINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_netr_NETRSERVERGETTRUSTINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct netr_NETRSERVERGETTRUSTINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_netr_NETRSERVERGETTRUSTINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_netlogon, DCERPC_NETR_NETRSERVERGETTRUSTINFO, (ejs_pull_function_t)ejs_pull_netr_NETRSERVERGETTRUSTINFO, (ejs_push_function_t)ejs_push_netr_NETRSERVERGETTRUSTINFO);
}

static int ejs_netlogon_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "netlogon", argc, argv);
	mprSetCFunction(obj, "netr_LogonUasLogon", ejs_netr_LogonUasLogon);
	mprSetCFunction(obj, "netr_LogonUasLogoff", ejs_netr_LogonUasLogoff);
	mprSetCFunction(obj, "netr_LogonSamLogon", ejs_netr_LogonSamLogon);
	mprSetCFunction(obj, "netr_LogonSamLogoff", ejs_netr_LogonSamLogoff);
	mprSetCFunction(obj, "netr_ServerReqChallenge", ejs_netr_ServerReqChallenge);
	mprSetCFunction(obj, "netr_ServerAuthenticate", ejs_netr_ServerAuthenticate);
	mprSetCFunction(obj, "netr_ServerPasswordSet", ejs_netr_ServerPasswordSet);
	mprSetCFunction(obj, "netr_DatabaseDeltas", ejs_netr_DatabaseDeltas);
	mprSetCFunction(obj, "netr_DatabaseSync", ejs_netr_DatabaseSync);
	mprSetCFunction(obj, "netr_AccountDeltas", ejs_netr_AccountDeltas);
	mprSetCFunction(obj, "netr_AccountSync", ejs_netr_AccountSync);
	mprSetCFunction(obj, "netr_GetDcName", ejs_netr_GetDcName);
	mprSetCFunction(obj, "netr_LogonControl", ejs_netr_LogonControl);
	mprSetCFunction(obj, "netr_GetAnyDCName", ejs_netr_GetAnyDCName);
	mprSetCFunction(obj, "netr_LogonControl2", ejs_netr_LogonControl2);
	mprSetCFunction(obj, "netr_ServerAuthenticate2", ejs_netr_ServerAuthenticate2);
	mprSetCFunction(obj, "netr_DatabaseSync2", ejs_netr_DatabaseSync2);
	mprSetCFunction(obj, "netr_DatabaseRedo", ejs_netr_DatabaseRedo);
	mprSetCFunction(obj, "netr_LogonControl2Ex", ejs_netr_LogonControl2Ex);
	mprSetCFunction(obj, "netr_NETRENUMERATETRUSTEDDOMAINS", ejs_netr_NETRENUMERATETRUSTEDDOMAINS);
	mprSetCFunction(obj, "netr_DsRGetDCName", ejs_netr_DsRGetDCName);
	mprSetCFunction(obj, "netr_NETRLOGONDUMMYROUTINE1", ejs_netr_NETRLOGONDUMMYROUTINE1);
	mprSetCFunction(obj, "netr_NETRLOGONSETSERVICEBITS", ejs_netr_NETRLOGONSETSERVICEBITS);
	mprSetCFunction(obj, "netr_NETRLOGONGETTRUSTRID", ejs_netr_NETRLOGONGETTRUSTRID);
	mprSetCFunction(obj, "netr_NETRLOGONCOMPUTESERVERDIGEST", ejs_netr_NETRLOGONCOMPUTESERVERDIGEST);
	mprSetCFunction(obj, "netr_NETRLOGONCOMPUTECLIENTDIGEST", ejs_netr_NETRLOGONCOMPUTECLIENTDIGEST);
	mprSetCFunction(obj, "netr_ServerAuthenticate3", ejs_netr_ServerAuthenticate3);
	mprSetCFunction(obj, "netr_DsRGetDCNameEx", ejs_netr_DsRGetDCNameEx);
	mprSetCFunction(obj, "netr_DsRGetSiteName", ejs_netr_DsRGetSiteName);
	mprSetCFunction(obj, "netr_LogonGetDomainInfo", ejs_netr_LogonGetDomainInfo);
	mprSetCFunction(obj, "netr_ServerPasswordSet2", ejs_netr_ServerPasswordSet2);
	mprSetCFunction(obj, "netr_NETRSERVERPASSWORDGET", ejs_netr_NETRSERVERPASSWORDGET);
	mprSetCFunction(obj, "netr_NETRLOGONSENDTOSAM", ejs_netr_NETRLOGONSENDTOSAM);
	mprSetCFunction(obj, "netr_DSRADDRESSTOSITENAMESW", ejs_netr_DSRADDRESSTOSITENAMESW);
	mprSetCFunction(obj, "netr_DsRGetDCNameEx2", ejs_netr_DsRGetDCNameEx2);
	mprSetCFunction(obj, "netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN", ejs_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN);
	mprSetCFunction(obj, "netr_NETRENUMERATETRUSTEDDOMAINSEX", ejs_netr_NETRENUMERATETRUSTEDDOMAINSEX);
	mprSetCFunction(obj, "netr_DSRADDRESSTOSITENAMESEXW", ejs_netr_DSRADDRESSTOSITENAMESEXW);
	mprSetCFunction(obj, "netr_DSRGETDCSITECOVERAGEW", ejs_netr_DSRGETDCSITECOVERAGEW);
	mprSetCFunction(obj, "netr_LogonSamLogonEx", ejs_netr_LogonSamLogonEx);
	mprSetCFunction(obj, "netr_DsrEnumerateDomainTrusts", ejs_netr_DsrEnumerateDomainTrusts);
	mprSetCFunction(obj, "netr_DSRDEREGISTERDNSHOSTRECORDS", ejs_netr_DSRDEREGISTERDNSHOSTRECORDS);
	mprSetCFunction(obj, "netr_NETRSERVERTRUSTPASSWORDSGET", ejs_netr_NETRSERVERTRUSTPASSWORDSGET);
	mprSetCFunction(obj, "netr_DSRGETFORESTTRUSTINFORMATION", ejs_netr_DSRGETFORESTTRUSTINFORMATION);
	mprSetCFunction(obj, "netr_NETRGETFORESTTRUSTINFORMATION", ejs_netr_NETRGETFORESTTRUSTINFORMATION);
	mprSetCFunction(obj, "netr_LogonSamLogonWithFlags", ejs_netr_LogonSamLogonWithFlags);
	mprSetCFunction(obj, "netr_NETRSERVERGETTRUSTINFO", ejs_netr_NETRSERVERGETTRUSTINFO);
	mprSetVar(obj, "NETLOGON_NTLMV2_ENABLED", mprCreateNumberVar(( 0x0100 )));
	mprSetVar(obj, "NETR_TRUST_TYPE_DOWNLEVEL", mprCreateNumberVar(1));
	mprSetVar(obj, "NETR_DELTA_RENAME_ALIAS", mprCreateNumberVar(11));
	mprSetVar(obj, "NETR_DELTA_USER", mprCreateNumberVar(5));
	mprSetVar(obj, "NETLOGON_GUEST", mprCreateNumberVar(( 0x0001 )));
	mprSetVar(obj, "NETLOGON_RESOURCE_GROUPS", mprCreateNumberVar(( 0x0200 )));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "NETLOGON_NEG_128BIT", mprCreateNumberVar(0x00004000));
	mprSetVar(obj, "NETLOGON_CONTROL_SET_DBFLAG", mprCreateNumberVar(65534));
	mprSetVar(obj, "NETLOGON_SUBAUTH_SESSION_KEY", mprCreateNumberVar(( 0x0040 )));
	mprSetVar(obj, "NETLOGON_USED_LM_PASSWORD", mprCreateNumberVar(( 0x0008 )));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "NETR_DELTA_ACCOUNT", mprCreateNumberVar(16));
	mprSetVar(obj, "NETLOGON_NEG_SCHANNEL", mprCreateNumberVar(0x40000000));
	mprSetVar(obj, "NETR_DELTA_DELETE_ALIAS", mprCreateNumberVar(10));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "NETLOGON_CONTROL_TRANSPORT_NOTIFY", mprCreateNumberVar(7));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "NETR_DELTA_DELETE_SECRET", mprCreateNumberVar(19));
	mprSetVar(obj, "NETR_TRUST_FLAG_PRIMARY", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "NETLOGON_CACHED_ACCOUNT", mprCreateNumberVar(( 0x0004 )));
	mprSetVar(obj, "NETR_DELTA_ALIAS_MEMBER", mprCreateNumberVar(12));
	mprSetVar(obj, "NETR_DELTA_GROUP_MEMBER", mprCreateNumberVar(8));
	mprSetVar(obj, "NETLOGON_NOENCRYPTION", mprCreateNumberVar(( 0x0002 )));
	mprSetVar(obj, "NETR_DELTA_GROUP", mprCreateNumberVar(2));
	mprSetVar(obj, "NETR_TRUST_TYPE_MIT", mprCreateNumberVar(3));
	mprSetVar(obj, "MSV1_0_CLEARTEXT_PASSWORD_ALLOWED", mprCreateNumberVar(0x002));
	mprSetVar(obj, "NETR_DELTA_DELETE_ACCOUNT", mprCreateNumberVar(17));
	mprSetVar(obj, "MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT", mprCreateNumberVar(0x800));
	mprSetVar(obj, "NETLOGON_SERVER_TRUST_ACCOUNT", mprCreateNumberVar(( 0x0080 )));
	mprSetVar(obj, "NETR_TRUST_FLAG_NATIVE", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "NETR_TRUST_TYPE_DCE", mprCreateNumberVar(4));
	mprSetVar(obj, "NETLOGON_CONTROL_TC_QUERY", mprCreateNumberVar(6));
	mprSetVar(obj, "NETR_DELTA_DOMAIN", mprCreateNumberVar(1));
	mprSetVar(obj, "NETR_DELTA_TRUSTED_DOMAIN", mprCreateNumberVar(14));
	mprSetVar(obj, "MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT", mprCreateNumberVar(0x020));
	mprSetVar(obj, "NETLOGON_CONTROL_REDISCOVER", mprCreateNumberVar(5));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "NETR_DELTA_DELETE_USER2", mprCreateNumberVar(21));
	mprSetVar(obj, "NETR_DELTA_DELETE_GROUP2", mprCreateNumberVar(20));
	mprSetVar(obj, "NETR_DELTA_SECRET", mprCreateNumberVar(18));
	mprSetVar(obj, "NETR_DELTA_DELETE_TRUST", mprCreateNumberVar(15));
	mprSetVar(obj, "NETLOGON_NEG_ARCFOUR", mprCreateNumberVar(0x00000004));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "NETR_DELTA_POLICY", mprCreateNumberVar(13));
	mprSetVar(obj, "NETR_DELTA_DELETE_USER", mprCreateNumberVar(6));
	mprSetVar(obj, "NETR_TRUST_FLAG_OUTBOUND", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "NETR_TRUST_FLAG_TREEROOT", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "NETR_DELTA_RENAME_GROUP", mprCreateNumberVar(4));
	mprSetVar(obj, "NETR_TRUST_FLAG_INBOUND", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "NETR_TRUST_TYPE_UPLEVEL", mprCreateNumberVar(2));
	mprSetVar(obj, "NETLOGON_PROFILE_PATH_RETURNED", mprCreateNumberVar(( 0x0400 )));
	mprSetVar(obj, "NETR_DELTA_RENAME_USER", mprCreateNumberVar(7));
	mprSetVar(obj, "NETR_DELTA_DELETE_GROUP", mprCreateNumberVar(3));
	mprSetVar(obj, "NETLOGON_EXTRA_SIDS", mprCreateNumberVar(( 0x0020 )));
	mprSetVar(obj, "NETR_DELTA_ALIAS", mprCreateNumberVar(9));
	mprSetVar(obj, "NETR_DELTA_MODIFY_COUNT", mprCreateNumberVar(22));
	mprSetVar(obj, "NETR_TRUST_ATTRIBUTE_WITHIN_FOREST", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "NETR_TRUST_FLAG_IN_FOREST", mprCreateNumberVar(( 0x00000001 )));
	return ejs_rpc_init(obj, "netlogon");
}

NTSTATUS ejs_init_netlogon(void)
{
	ejsDefineCFunction(-1, "netlogon_init", ejs_netlogon_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
