/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_netlogon.h"

/* netlogon - dcerpc server boilerplate generated by pidl */


static NTSTATUS netlogon__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETLOGON_BIND
	return DCESRV_INTERFACE_NETLOGON_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void netlogon__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETLOGON_UNBIND
	DCESRV_INTERFACE_NETLOGON_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS netlogon__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_netlogon.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_netlogon.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_netlogon.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_netlogon, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netlogon__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct netr_LogonUasLogon *r2 = (struct netr_LogonUasLogon *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogon, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonUasLogon(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogon will reply async\n"));
		}
		break;
	}
	case 1: {
		struct netr_LogonUasLogoff *r2 = (struct netr_LogonUasLogoff *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogoff, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonUasLogoff(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogoff will reply async\n"));
		}
		break;
	}
	case 2: {
		struct netr_LogonSamLogon *r2 = (struct netr_LogonSamLogon *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogon, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonSamLogon(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogon will reply async\n"));
		}
		break;
	}
	case 3: {
		struct netr_LogonSamLogoff *r2 = (struct netr_LogonSamLogoff *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogoff, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonSamLogoff(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogoff will reply async\n"));
		}
		break;
	}
	case 4: {
		struct netr_ServerReqChallenge *r2 = (struct netr_ServerReqChallenge *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerReqChallenge, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerReqChallenge(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerReqChallenge will reply async\n"));
		}
		break;
	}
	case 5: {
		struct netr_ServerAuthenticate *r2 = (struct netr_ServerAuthenticate *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerAuthenticate(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate will reply async\n"));
		}
		break;
	}
	case 6: {
		struct netr_ServerPasswordSet *r2 = (struct netr_ServerPasswordSet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerPasswordSet(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet will reply async\n"));
		}
		break;
	}
	case 7: {
		struct netr_DatabaseDeltas *r2 = (struct netr_DatabaseDeltas *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseDeltas, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DatabaseDeltas(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseDeltas will reply async\n"));
		}
		break;
	}
	case 8: {
		struct netr_DatabaseSync *r2 = (struct netr_DatabaseSync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DatabaseSync(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync will reply async\n"));
		}
		break;
	}
	case 9: {
		struct netr_AccountDeltas *r2 = (struct netr_AccountDeltas *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountDeltas, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_AccountDeltas(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountDeltas will reply async\n"));
		}
		break;
	}
	case 10: {
		struct netr_AccountSync *r2 = (struct netr_AccountSync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountSync, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_AccountSync(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountSync will reply async\n"));
		}
		break;
	}
	case 11: {
		struct netr_GetDcName *r2 = (struct netr_GetDcName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetDcName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_GetDcName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetDcName will reply async\n"));
		}
		break;
	}
	case 12: {
		struct netr_LogonControl *r2 = (struct netr_LogonControl *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonControl(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl will reply async\n"));
		}
		break;
	}
	case 13: {
		struct netr_GetAnyDCName *r2 = (struct netr_GetAnyDCName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetAnyDCName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_GetAnyDCName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetAnyDCName will reply async\n"));
		}
		break;
	}
	case 14: {
		struct netr_LogonControl2 *r2 = (struct netr_LogonControl2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonControl2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2 will reply async\n"));
		}
		break;
	}
	case 15: {
		struct netr_ServerAuthenticate2 *r2 = (struct netr_ServerAuthenticate2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerAuthenticate2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate2 will reply async\n"));
		}
		break;
	}
	case 16: {
		struct netr_DatabaseSync2 *r2 = (struct netr_DatabaseSync2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DatabaseSync2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync2 will reply async\n"));
		}
		break;
	}
	case 17: {
		struct netr_DatabaseRedo *r2 = (struct netr_DatabaseRedo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseRedo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DatabaseRedo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseRedo will reply async\n"));
		}
		break;
	}
	case 18: {
		struct netr_LogonControl2Ex *r2 = (struct netr_LogonControl2Ex *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2Ex, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonControl2Ex(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2Ex will reply async\n"));
		}
		break;
	}
	case 19: {
		struct netr_NETRENUMERATETRUSTEDDOMAINS *r2 = (struct netr_NETRENUMERATETRUSTEDDOMAINS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRENUMERATETRUSTEDDOMAINS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRENUMERATETRUSTEDDOMAINS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRENUMERATETRUSTEDDOMAINS will reply async\n"));
		}
		break;
	}
	case 20: {
		struct netr_DsRGetDCName *r2 = (struct netr_DsRGetDCName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DsRGetDCName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCName will reply async\n"));
		}
		break;
	}
	case 21: {
		struct netr_NETRLOGONDUMMYROUTINE1 *r2 = (struct netr_NETRLOGONDUMMYROUTINE1 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONDUMMYROUTINE1, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONDUMMYROUTINE1(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONDUMMYROUTINE1 will reply async\n"));
		}
		break;
	}
	case 22: {
		struct netr_NETRLOGONSETSERVICEBITS *r2 = (struct netr_NETRLOGONSETSERVICEBITS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSETSERVICEBITS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONSETSERVICEBITS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONSETSERVICEBITS will reply async\n"));
		}
		break;
	}
	case 23: {
		struct netr_NETRLOGONGETTRUSTRID *r2 = (struct netr_NETRLOGONGETTRUSTRID *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTRUSTRID, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONGETTRUSTRID(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONGETTRUSTRID will reply async\n"));
		}
		break;
	}
	case 24: {
		struct netr_NETRLOGONCOMPUTESERVERDIGEST *r2 = (struct netr_NETRLOGONCOMPUTESERVERDIGEST *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONCOMPUTESERVERDIGEST(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTESERVERDIGEST will reply async\n"));
		}
		break;
	}
	case 25: {
		struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r2 = (struct netr_NETRLOGONCOMPUTECLIENTDIGEST *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONCOMPUTECLIENTDIGEST(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTECLIENTDIGEST will reply async\n"));
		}
		break;
	}
	case 26: {
		struct netr_ServerAuthenticate3 *r2 = (struct netr_ServerAuthenticate3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerAuthenticate3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate3 will reply async\n"));
		}
		break;
	}
	case 27: {
		struct netr_DsRGetDCNameEx *r2 = (struct netr_DsRGetDCNameEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DsRGetDCNameEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx will reply async\n"));
		}
		break;
	}
	case 28: {
		struct netr_DsRGetSiteName *r2 = (struct netr_DsRGetSiteName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetSiteName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DsRGetSiteName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetSiteName will reply async\n"));
		}
		break;
	}
	case 29: {
		struct netr_LogonGetDomainInfo *r2 = (struct netr_LogonGetDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetDomainInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonGetDomainInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonGetDomainInfo will reply async\n"));
		}
		break;
	}
	case 30: {
		struct netr_ServerPasswordSet2 *r2 = (struct netr_ServerPasswordSet2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_ServerPasswordSet2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet2 will reply async\n"));
		}
		break;
	}
	case 31: {
		struct netr_NETRSERVERPASSWORDGET *r2 = (struct netr_NETRSERVERPASSWORDGET *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERPASSWORDGET, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRSERVERPASSWORDGET(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERPASSWORDGET will reply async\n"));
		}
		break;
	}
	case 32: {
		struct netr_NETRLOGONSENDTOSAM *r2 = (struct netr_NETRLOGONSENDTOSAM *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSENDTOSAM, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONSENDTOSAM(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONSENDTOSAM will reply async\n"));
		}
		break;
	}
	case 33: {
		struct netr_DSRADDRESSTOSITENAMESW *r2 = (struct netr_DSRADDRESSTOSITENAMESW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRADDRESSTOSITENAMESW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DSRADDRESSTOSITENAMESW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRADDRESSTOSITENAMESW will reply async\n"));
		}
		break;
	}
	case 34: {
		struct netr_DsRGetDCNameEx2 *r2 = (struct netr_DsRGetDCNameEx2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DsRGetDCNameEx2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx2 will reply async\n"));
		}
		break;
	}
	case 35: {
		struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r2 = (struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN will reply async\n"));
		}
		break;
	}
	case 36: {
		struct netr_NETRENUMERATETRUSTEDDOMAINSEX *r2 = (struct netr_NETRENUMERATETRUSTEDDOMAINSEX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRENUMERATETRUSTEDDOMAINSEX, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRENUMERATETRUSTEDDOMAINSEX(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRENUMERATETRUSTEDDOMAINSEX will reply async\n"));
		}
		break;
	}
	case 37: {
		struct netr_DSRADDRESSTOSITENAMESEXW *r2 = (struct netr_DSRADDRESSTOSITENAMESEXW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRADDRESSTOSITENAMESEXW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DSRADDRESSTOSITENAMESEXW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRADDRESSTOSITENAMESEXW will reply async\n"));
		}
		break;
	}
	case 38: {
		struct netr_DSRGETDCSITECOVERAGEW *r2 = (struct netr_DSRGETDCSITECOVERAGEW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRGETDCSITECOVERAGEW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DSRGETDCSITECOVERAGEW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRGETDCSITECOVERAGEW will reply async\n"));
		}
		break;
	}
	case 39: {
		struct netr_LogonSamLogonEx *r2 = (struct netr_LogonSamLogonEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonSamLogonEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonEx will reply async\n"));
		}
		break;
	}
	case 40: {
		struct netr_DsrEnumerateDomainTrusts *r2 = (struct netr_DsrEnumerateDomainTrusts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrEnumerateDomainTrusts, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DsrEnumerateDomainTrusts(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrEnumerateDomainTrusts will reply async\n"));
		}
		break;
	}
	case 41: {
		struct netr_DSRDEREGISTERDNSHOSTRECORDS *r2 = (struct netr_DSRDEREGISTERDNSHOSTRECORDS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRDEREGISTERDNSHOSTRECORDS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DSRDEREGISTERDNSHOSTRECORDS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRDEREGISTERDNSHOSTRECORDS will reply async\n"));
		}
		break;
	}
	case 42: {
		struct netr_NETRSERVERTRUSTPASSWORDSGET *r2 = (struct netr_NETRSERVERTRUSTPASSWORDSGET *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERTRUSTPASSWORDSGET, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRSERVERTRUSTPASSWORDSGET(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERTRUSTPASSWORDSGET will reply async\n"));
		}
		break;
	}
	case 43: {
		struct netr_DSRGETFORESTTRUSTINFORMATION *r2 = (struct netr_DSRGETFORESTTRUSTINFORMATION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRGETFORESTTRUSTINFORMATION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_DSRGETFORESTTRUSTINFORMATION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRGETFORESTTRUSTINFORMATION will reply async\n"));
		}
		break;
	}
	case 44: {
		struct netr_NETRGETFORESTTRUSTINFORMATION *r2 = (struct netr_NETRGETFORESTTRUSTINFORMATION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRGETFORESTTRUSTINFORMATION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRGETFORESTTRUSTINFORMATION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRGETFORESTTRUSTINFORMATION will reply async\n"));
		}
		break;
	}
	case 45: {
		struct netr_LogonSamLogonWithFlags *r2 = (struct netr_LogonSamLogonWithFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonWithFlags, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_LogonSamLogonWithFlags(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonWithFlags will reply async\n"));
		}
		break;
	}
	case 46: {
		struct netr_NETRSERVERGETTRUSTINFO *r2 = (struct netr_NETRSERVERGETTRUSTINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERGETTRUSTINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_netr_NETRSERVERGETTRUSTINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERGETTRUSTINFO will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_netlogon, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netlogon__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct netr_LogonUasLogon *r2 = (struct netr_LogonUasLogon *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogon replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogon, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonUasLogon\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct netr_LogonUasLogoff *r2 = (struct netr_LogonUasLogoff *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogoff replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogoff, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonUasLogoff\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct netr_LogonSamLogon *r2 = (struct netr_LogonSamLogon *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogon replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogon, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonSamLogon\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct netr_LogonSamLogoff *r2 = (struct netr_LogonSamLogoff *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogoff replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogoff, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonSamLogoff\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct netr_ServerReqChallenge *r2 = (struct netr_ServerReqChallenge *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerReqChallenge replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerReqChallenge, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerReqChallenge\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct netr_ServerAuthenticate *r2 = (struct netr_ServerAuthenticate *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerAuthenticate\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct netr_ServerPasswordSet *r2 = (struct netr_ServerPasswordSet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerPasswordSet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct netr_DatabaseDeltas *r2 = (struct netr_DatabaseDeltas *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseDeltas replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseDeltas, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DatabaseDeltas\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct netr_DatabaseSync *r2 = (struct netr_DatabaseSync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DatabaseSync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct netr_AccountDeltas *r2 = (struct netr_AccountDeltas *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountDeltas replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountDeltas, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_AccountDeltas\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct netr_AccountSync *r2 = (struct netr_AccountSync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountSync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountSync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_AccountSync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct netr_GetDcName *r2 = (struct netr_GetDcName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetDcName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetDcName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_GetDcName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct netr_LogonControl *r2 = (struct netr_LogonControl *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonControl\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct netr_GetAnyDCName *r2 = (struct netr_GetAnyDCName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetAnyDCName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetAnyDCName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_GetAnyDCName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct netr_LogonControl2 *r2 = (struct netr_LogonControl2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonControl2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct netr_ServerAuthenticate2 *r2 = (struct netr_ServerAuthenticate2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerAuthenticate2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct netr_DatabaseSync2 *r2 = (struct netr_DatabaseSync2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DatabaseSync2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct netr_DatabaseRedo *r2 = (struct netr_DatabaseRedo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseRedo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseRedo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DatabaseRedo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct netr_LogonControl2Ex *r2 = (struct netr_LogonControl2Ex *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2Ex replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2Ex, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonControl2Ex\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct netr_NETRENUMERATETRUSTEDDOMAINS *r2 = (struct netr_NETRENUMERATETRUSTEDDOMAINS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRENUMERATETRUSTEDDOMAINS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRENUMERATETRUSTEDDOMAINS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRENUMERATETRUSTEDDOMAINS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct netr_DsRGetDCName *r2 = (struct netr_DsRGetDCName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DsRGetDCName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct netr_NETRLOGONDUMMYROUTINE1 *r2 = (struct netr_NETRLOGONDUMMYROUTINE1 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONDUMMYROUTINE1 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONDUMMYROUTINE1, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONDUMMYROUTINE1\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct netr_NETRLOGONSETSERVICEBITS *r2 = (struct netr_NETRLOGONSETSERVICEBITS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONSETSERVICEBITS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSETSERVICEBITS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONSETSERVICEBITS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct netr_NETRLOGONGETTRUSTRID *r2 = (struct netr_NETRLOGONGETTRUSTRID *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONGETTRUSTRID replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTRUSTRID, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONGETTRUSTRID\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct netr_NETRLOGONCOMPUTESERVERDIGEST *r2 = (struct netr_NETRLOGONCOMPUTESERVERDIGEST *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTESERVERDIGEST replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONCOMPUTESERVERDIGEST\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r2 = (struct netr_NETRLOGONCOMPUTECLIENTDIGEST *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTECLIENTDIGEST replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONCOMPUTECLIENTDIGEST\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct netr_ServerAuthenticate3 *r2 = (struct netr_ServerAuthenticate3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerAuthenticate3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct netr_DsRGetDCNameEx *r2 = (struct netr_DsRGetDCNameEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DsRGetDCNameEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct netr_DsRGetSiteName *r2 = (struct netr_DsRGetSiteName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetSiteName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetSiteName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DsRGetSiteName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct netr_LogonGetDomainInfo *r2 = (struct netr_LogonGetDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonGetDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonGetDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct netr_ServerPasswordSet2 *r2 = (struct netr_ServerPasswordSet2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_ServerPasswordSet2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct netr_NETRSERVERPASSWORDGET *r2 = (struct netr_NETRSERVERPASSWORDGET *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERPASSWORDGET replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERPASSWORDGET, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRSERVERPASSWORDGET\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct netr_NETRLOGONSENDTOSAM *r2 = (struct netr_NETRLOGONSENDTOSAM *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONSENDTOSAM replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSENDTOSAM, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONSENDTOSAM\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct netr_DSRADDRESSTOSITENAMESW *r2 = (struct netr_DSRADDRESSTOSITENAMESW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRADDRESSTOSITENAMESW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRADDRESSTOSITENAMESW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DSRADDRESSTOSITENAMESW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct netr_DsRGetDCNameEx2 *r2 = (struct netr_DsRGetDCNameEx2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DsRGetDCNameEx2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r2 = (struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct netr_NETRENUMERATETRUSTEDDOMAINSEX *r2 = (struct netr_NETRENUMERATETRUSTEDDOMAINSEX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRENUMERATETRUSTEDDOMAINSEX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRENUMERATETRUSTEDDOMAINSEX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRENUMERATETRUSTEDDOMAINSEX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct netr_DSRADDRESSTOSITENAMESEXW *r2 = (struct netr_DSRADDRESSTOSITENAMESEXW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRADDRESSTOSITENAMESEXW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRADDRESSTOSITENAMESEXW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DSRADDRESSTOSITENAMESEXW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct netr_DSRGETDCSITECOVERAGEW *r2 = (struct netr_DSRGETDCSITECOVERAGEW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRGETDCSITECOVERAGEW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRGETDCSITECOVERAGEW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DSRGETDCSITECOVERAGEW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct netr_LogonSamLogonEx *r2 = (struct netr_LogonSamLogonEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonSamLogonEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct netr_DsrEnumerateDomainTrusts *r2 = (struct netr_DsrEnumerateDomainTrusts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrEnumerateDomainTrusts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrEnumerateDomainTrusts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DsrEnumerateDomainTrusts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct netr_DSRDEREGISTERDNSHOSTRECORDS *r2 = (struct netr_DSRDEREGISTERDNSHOSTRECORDS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRDEREGISTERDNSHOSTRECORDS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRDEREGISTERDNSHOSTRECORDS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DSRDEREGISTERDNSHOSTRECORDS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct netr_NETRSERVERTRUSTPASSWORDSGET *r2 = (struct netr_NETRSERVERTRUSTPASSWORDSGET *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERTRUSTPASSWORDSGET replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERTRUSTPASSWORDSGET, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRSERVERTRUSTPASSWORDSGET\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct netr_DSRGETFORESTTRUSTINFORMATION *r2 = (struct netr_DSRGETFORESTTRUSTINFORMATION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DSRGETFORESTTRUSTINFORMATION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DSRGETFORESTTRUSTINFORMATION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_DSRGETFORESTTRUSTINFORMATION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct netr_NETRGETFORESTTRUSTINFORMATION *r2 = (struct netr_NETRGETFORESTTRUSTINFORMATION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRGETFORESTTRUSTINFORMATION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRGETFORESTTRUSTINFORMATION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRGETFORESTTRUSTINFORMATION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct netr_LogonSamLogonWithFlags *r2 = (struct netr_LogonSamLogonWithFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonWithFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonWithFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_LogonSamLogonWithFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct netr_NETRSERVERGETTRUSTINFO *r2 = (struct netr_NETRSERVERGETTRUSTINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRSERVERGETTRUSTINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRSERVERGETTRUSTINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in netr_NETRSERVERGETTRUSTINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_netlogon, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netlogon__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_netlogon.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_netlogon_interface = {
	.name		= "netlogon",
	.syntax_id  = {{0x12345678,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0xcf,0xfb}},1.0},
	.bind		= netlogon__op_bind,
	.unbind		= netlogon__op_unbind,
	.ndr_pull	= netlogon__op_ndr_pull,
	.dispatch	= netlogon__op_dispatch,
	.reply		= netlogon__op_reply,
	.ndr_push	= netlogon__op_ndr_push
};


static NTSTATUS netlogon__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_netlogon.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_netlogon.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_netlogon_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("netlogon_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL netlogon__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_netlogon_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_netlogon_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_netlogon_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL netlogon__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_netlogon_interface.name, name)==0) {
		memcpy(iface, &dcesrv_netlogon_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_netlogon_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "netlogon";

	/* fill in all the operations */
	ep_server.init_server = netlogon__op_init_server;

	ep_server.interface_by_uuid = netlogon__op_interface_by_uuid;
	ep_server.interface_by_name = netlogon__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'netlogon' endpoint server!\n"));
		return ret;
	}

	return ret;
}

