
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_remact.h"
#include "librpc/gen_ndr/ndr_remact_ejs.h"



static NTSTATUS ejs_pull_RemoteActivation(struct ejs_rpc *ejs, struct MprVar *v, struct RemoteActivation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_ORPCTHIS(ejs, v, "this", &r->in.this));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "Clsid", &r->in.Clsid));
	if (ejs_pull_null(ejs, v, "pwszObjectName")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pwszObjectName);
		NDR_CHECK(ejs_pull_string(ejs, v, "pwszObjectName", &r->in.pwszObjectName));
	}
	if (ejs_pull_null(ejs, v, "pObjectStorage")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pObjectStorage);
		NDR_CHECK(ejs_pull_MInterfacePointer(ejs, v, "pObjectStorage", r->in.pObjectStorage));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ClientImpLevel", &r->in.ClientImpLevel));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Mode", &r->in.Mode));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Interfaces", &r->in.Interfaces));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "num_protseqs", &r->in.num_protseqs));
	if (ejs_pull_null(ejs, v, "pIIDs")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pIIDs);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->in.pIIDs, r->in.Interfaces);
			for (i=0;i<r->in.Interfaces;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "pIIDs", i);
				NDR_CHECK(ejs_pull_GUID(ejs, v, id, &r->in.pIIDs[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "pIIDs" ".length", &i);
		}
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.protseq, r->in.num_protseqs);
		for (i=0;i<r->in.num_protseqs;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "protseq", i);
			NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->in.protseq[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "protseq" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_RemoteActivation(struct ejs_rpc *ejs, struct MprVar *v, const struct RemoteActivation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.that) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_ORPCTHAT(ejs, v, "that", r->out.that));
	}
	if (NULL == r->out.pOxid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_hyper(ejs, v, "pOxid", r->out.pOxid));
	}
	if (NULL == r->out.pdsaOxidBindings) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_DUALSTRINGARRAY(ejs, v, "pdsaOxidBindings", r->out.pdsaOxidBindings));
	}
	if (NULL == r->out.ipidRemUnknown) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_GUID(ejs, v, "ipidRemUnknown", r->out.ipidRemUnknown));
	}
	if (NULL == r->out.AuthnHint) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "AuthnHint", r->out.AuthnHint));
	}
	if (NULL == r->out.ServerVersion) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_COMVERSION(ejs, v, "ServerVersion", r->out.ServerVersion));
	}
	if (NULL == r->out.hr) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_WERROR(ejs, v, "hr", r->out.hr));
	}
	{
		uint32_t i;
		for (i=0;i<r->in.Interfaces;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "ifaces", i);
			if (NULL == r->out.ifaces[i]) {
				return NT_STATUS_INVALID_PARAMETER_MIX;
			} else {
				NDR_CHECK(ejs_push_MInterfacePointer(ejs, v, id, r->out.ifaces[i]));
			}
		}
		ejs_push_uint32(ejs, v, "ifaces" ".length", &i);
	}
	{
		uint32_t i;
		for (i=0;i<r->in.Interfaces;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "results", i);
			NDR_CHECK(ejs_push_WERROR(ejs, v, id, &r->out.results[i]));
		}
		ejs_push_uint32(ejs, v, "results" ".length", &i);
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_RemoteActivation(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_IRemoteActivation, DCERPC_REMOTEACTIVATION, (ejs_pull_function_t)ejs_pull_RemoteActivation, (ejs_push_function_t)ejs_push_RemoteActivation);
}

static int ejs_IRemoteActivation_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "IRemoteActivation", argc, argv);
	mprSetCFunction(obj, "RemoteActivation", ejs_RemoteActivation);
	mprSetVar(obj, "MODE_GET_CLASS_OBJECT", mprCreateNumberVar(0xffffffff));
	return ejs_rpc_init(obj, "IRemoteActivation");
}

NTSTATUS ejs_init_IRemoteActivation(void)
{
	ejsDefineCFunction(-1, "IRemoteActivation_init", ejs_IRemoteActivation_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
