
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/gen_ndr/ndr_samr_ejs.h"


_PUBLIC_ NTSTATUS ejs_push_samr_AcctFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_samr_AcctFlags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_samr_SamEntry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_SamEntry *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->idx));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_SamArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_SamArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->entries) {
		NDR_CHECK(ejs_push_null(ejs, v, "entries"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
				NDR_CHECK(ejs_push_samr_SamEntry(ejs, v, id, &r->entries[i]));
			}
			ejs_push_uint32(ejs, v, "entries" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_Role(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum samr_Role *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_Role(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum samr_Role *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_PasswordProperties(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_samr_PasswordProperties(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_samr_DomInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "min_password_length", &r->min_password_length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "password_history_length", &r->password_history_length));
	NDR_CHECK(ejs_push_samr_PasswordProperties(ejs, v, "password_properties", &r->password_properties));
	NDR_CHECK(ejs_push_dlong(ejs, v, "max_password_age", &r->max_password_age));
	NDR_CHECK(ejs_push_dlong(ejs, v, "min_password_age", &r->min_password_age));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "min_password_length", &r->min_password_length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "password_history_length", &r->password_history_length));
	NDR_CHECK(ejs_pull_samr_PasswordProperties(ejs, v, "password_properties", &r->password_properties));
	NDR_CHECK(ejs_pull_dlong(ejs, v, "max_password_age", &r->max_password_age));
	NDR_CHECK(ejs_pull_dlong(ejs, v, "min_password_age", &r->min_password_age));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "force_logoff_time", &r->force_logoff_time));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "primary", &r->primary));
	NDR_CHECK(ejs_push_udlong(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_samr_Role(ejs, v, "role", &r->role));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_users", &r->num_users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_groups", &r->num_groups));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_aliases", &r->num_aliases));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "force_logoff_time", &r->force_logoff_time));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "primary", &r->primary));
	NDR_CHECK(ejs_pull_udlong(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_samr_Role(ejs, v, "role", &r->role));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_users", &r->num_users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_groups", &r->num_groups));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_aliases", &r->num_aliases));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "force_logoff_time", &r->force_logoff_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "force_logoff_time", &r->force_logoff_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "comment", &r->comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "domain_name", &r->domain_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "domain_name", &r->domain_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "primary", &r->primary));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "primary", &r->primary));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_Role(ejs, v, "role", &r->role));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo7 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_Role(ejs, v, "role", &r->role));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo8(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo8 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "domain_create_time", &r->domain_create_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo8(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo8 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "domain_create_time", &r->domain_create_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo9(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo9 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo9(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo9 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo11 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_DomInfo2(ejs, v, "info2", &r->info2));
	NDR_CHECK(ejs_push_hyper(ejs, v, "lockout_duration", &r->lockout_duration));
	NDR_CHECK(ejs_push_hyper(ejs, v, "lockout_window", &r->lockout_window));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lockout_threshold", &r->lockout_threshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo11 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_DomInfo2(ejs, v, "info2", &r->info2));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "lockout_duration", &r->lockout_duration));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "lockout_window", &r->lockout_window));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lockout_threshold", &r->lockout_threshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo12(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo12 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "lockout_duration", &r->lockout_duration));
	NDR_CHECK(ejs_push_hyper(ejs, v, "lockout_window", &r->lockout_window));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lockout_threshold", &r->lockout_threshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo12(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo12 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "lockout_duration", &r->lockout_duration));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "lockout_window", &r->lockout_window));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lockout_threshold", &r->lockout_threshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomInfo13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DomInfo13 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "domain_create_time", &r->domain_create_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_DomInfo13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_DomInfo13 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "sequence_num", &r->sequence_num));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "domain_create_time", &r->domain_create_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_DomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_samr_DomInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_samr_DomInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_samr_DomInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_samr_DomInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_samr_DomInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_push_samr_DomInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_push_samr_DomInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_push_samr_DomInfo8(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_push_samr_DomInfo9(ejs, v, "info9", &r->info9));
			break;
		case 11:
			NDR_CHECK(ejs_push_samr_DomInfo11(ejs, v, "info11", &r->info11));
			break;
		case 12:
			NDR_CHECK(ejs_push_samr_DomInfo12(ejs, v, "info12", &r->info12));
			break;
		case 13:
			NDR_CHECK(ejs_push_samr_DomInfo13(ejs, v, "info13", &r->info13));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_samr_DomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union samr_DomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_samr_DomInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_samr_DomInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_pull_samr_DomInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_pull_samr_DomInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_pull_samr_DomInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_pull_samr_DomInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_pull_samr_DomInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_pull_samr_DomInfo8(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_pull_samr_DomInfo9(ejs, v, "info9", &r->info9));
			break;
		case 11:
			NDR_CHECK(ejs_pull_samr_DomInfo11(ejs, v, "info11", &r->info11));
			break;
		case 12:
			NDR_CHECK(ejs_pull_samr_DomInfo12(ejs, v, "info12", &r->info12));
			break;
		case 13:
			NDR_CHECK(ejs_pull_samr_DomInfo13(ejs, v, "info13", &r->info13));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_samr_Ids(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_Ids *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->ids) {
		NDR_CHECK(ejs_push_null(ejs, v, "ids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "ids", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->ids[i]));
			}
			ejs_push_uint32(ejs, v, "ids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_GroupAttrs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_samr_GroupAttrs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_samr_GroupInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_GroupInfoAll *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_members", &r->num_members));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_GroupInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_GroupInfoAll *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_members", &r->num_members));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_GroupInfoAttributes(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_GroupInfoAttributes *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_GroupInfoAttributes(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_GroupInfoAttributes *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_GroupInfoEnum(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum samr_GroupInfoEnum *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_GroupInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_GroupInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case GROUPINFOALL:
			NDR_CHECK(ejs_push_samr_GroupInfoAll(ejs, v, "all", &r->all));
			break;
		case GROUPINFONAME:
			NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
			break;
		case GROUPINFOATTRIBUTES:
			NDR_CHECK(ejs_push_samr_GroupInfoAttributes(ejs, v, "attributes", &r->attributes));
			break;
		case GROUPINFODESCRIPTION:
			NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
			break;
		case GROUPINFOALL2:
			NDR_CHECK(ejs_push_samr_GroupInfoAll(ejs, v, "all2", &r->all2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_samr_GroupInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union samr_GroupInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case GROUPINFOALL:
			NDR_CHECK(ejs_pull_samr_GroupInfoAll(ejs, v, "all", &r->all));
			break;
		case GROUPINFONAME:
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
			break;
		case GROUPINFOATTRIBUTES:
			NDR_CHECK(ejs_pull_samr_GroupInfoAttributes(ejs, v, "attributes", &r->attributes));
			break;
		case GROUPINFODESCRIPTION:
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
			break;
		case GROUPINFOALL2:
			NDR_CHECK(ejs_pull_samr_GroupInfoAll(ejs, v, "all2", &r->all2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_samr_RidTypeArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_RidTypeArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->rids) {
		NDR_CHECK(ejs_push_null(ejs, v, "rids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "rids", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->rids[i]));
			}
			ejs_push_uint32(ejs, v, "rids" ".length", &i);
		}
	}
	if (NULL == r->types) {
		NDR_CHECK(ejs_push_null(ejs, v, "types"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "types", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->types[i]));
			}
			ejs_push_uint32(ejs, v, "types" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_AliasInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_AliasInfoAll *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_members", &r->num_members));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_AliasInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_AliasInfoAll *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_members", &r->num_members));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_AliasInfoEnum(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum samr_AliasInfoEnum *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_AliasInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_AliasInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case ALIASINFOALL:
			NDR_CHECK(ejs_push_samr_AliasInfoAll(ejs, v, "all", &r->all));
			break;
		case ALIASINFONAME:
			NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
			break;
		case ALIASINFODESCRIPTION:
			NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_samr_AliasInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union samr_AliasInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case ALIASINFOALL:
			NDR_CHECK(ejs_pull_samr_AliasInfoAll(ejs, v, "all", &r->all));
			break;
		case ALIASINFONAME:
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
			break;
		case ALIASINFODESCRIPTION:
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_samr_UserInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "comment", &r->comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_push_uint16(ejs, v, "country_code", &r->country_code));
	NDR_CHECK(ejs_push_uint16(ejs, v, "code_page", &r->code_page));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "country_code", &r->country_code));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "code_page", &r->code_page));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_LogonHours(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_LogonHours *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "units_per_week", &r->units_per_week));
	if (NULL == r->bits) {
		NDR_CHECK(ejs_push_null(ejs, v, "bits"));
	} else {
		ejs_push_array_uint8(ejs, v, "bits", r->bits, r->units_per_week / 8);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_samr_LogonHours(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_LogonHours *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "units_per_week", &r->units_per_week));
	if (ejs_pull_null(ejs, v, "bits")) {
		r->bits = NULL;
	} else {
		EJS_ALLOC(ejs, r->bits);
		EJS_ALLOC_N(ejs, r->bits, 1260);
		ejs_pull_array_uint8(ejs, v, "bits", r->bits, r->units_per_week / 8);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_push_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_push_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_pull_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_push_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_pull_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo6 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo7 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo8(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo8 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo8(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo8 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo9(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo9 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo9(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo9 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo10 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo10 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_drive", &r->home_drive));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo11 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo11 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_script", &r->logon_script));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo12(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo12 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo12(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo12 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "profile_path", &r->profile_path));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo13 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo13 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo14(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo14 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstations", &r->workstations));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo14(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo14 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "workstations", &r->workstations));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo16(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo16 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo16(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo16 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo17(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo17 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo17(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo17 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo20(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo20 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "parameters", &r->parameters));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo20(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo20 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "parameters", &r->parameters));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_FieldsPresent(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_samr_FieldsPresent(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_samr_UserInfo21(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo21 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "parameters", &r->parameters));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_push_uint32(ejs, v, "buf_count", &r->buf_count));
	if (NULL == r->buffer) {
		NDR_CHECK(ejs_push_null(ejs, v, "buffer"));
	} else {
		ejs_push_array_uint8(ejs, v, "buffer", r->buffer, r->buf_count);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_push_samr_FieldsPresent(ejs, v, "fields_present", &r->fields_present));
	NDR_CHECK(ejs_push_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_push_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "country_code", &r->country_code));
	NDR_CHECK(ejs_push_uint16(ejs, v, "code_page", &r->code_page));
	NDR_CHECK(ejs_push_uint8(ejs, v, "nt_password_set", &r->nt_password_set));
	NDR_CHECK(ejs_push_uint8(ejs, v, "lm_password_set", &r->lm_password_set));
	NDR_CHECK(ejs_push_uint8(ejs, v, "password_expired", &r->password_expired));
	NDR_CHECK(ejs_push_uint8(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo21(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo21 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logon", &r->last_logon));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_logoff", &r->last_logoff));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "last_password_change", &r->last_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "acct_expiry", &r->acct_expiry));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "allow_password_change", &r->allow_password_change));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "force_password_change", &r->force_password_change));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_directory", &r->home_directory));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "home_drive", &r->home_drive));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "logon_script", &r->logon_script));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "profile_path", &r->profile_path));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "description", &r->description));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "workstations", &r->workstations));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "comment", &r->comment));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "parameters", &r->parameters));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "unknown3", &r->unknown3));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_count", &r->buf_count));
	if (ejs_pull_null(ejs, v, "buffer")) {
		r->buffer = NULL;
	} else {
		EJS_ALLOC(ejs, r->buffer);
		EJS_ALLOC_N(ejs, r->buffer, r->buf_count);
		ejs_pull_array_uint8(ejs, v, "buffer", r->buffer, r->buf_count);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "primary_gid", &r->primary_gid));
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_pull_samr_FieldsPresent(ejs, v, "fields_present", &r->fields_present));
	NDR_CHECK(ejs_pull_samr_LogonHours(ejs, v, "logon_hours", &r->logon_hours));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "bad_password_count", &r->bad_password_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_count", &r->logon_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "country_code", &r->country_code));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "code_page", &r->code_page));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "nt_password_set", &r->nt_password_set));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "lm_password_set", &r->lm_password_set));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "password_expired", &r->password_expired));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "unknown4", &r->unknown4));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_CryptPassword(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_CryptPassword *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "data", r->data, 516);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_samr_CryptPassword(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_CryptPassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "data", r->data, 516);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo23(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo23 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_UserInfo21(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_push_samr_CryptPassword(ejs, v, "password", &r->password));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo23(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo23 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_UserInfo21(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "password", &r->password));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo24(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo24 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_CryptPassword(ejs, v, "password", &r->password));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pw_len", &r->pw_len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo24(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo24 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "password", &r->password));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pw_len", &r->pw_len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_CryptPasswordEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_CryptPasswordEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "data", r->data, 532);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_CryptPasswordEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_CryptPasswordEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "data", r->data, 532);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo25(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo25 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_UserInfo21(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_push_samr_CryptPasswordEx(ejs, v, "password", &r->password));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo25(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo25 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_UserInfo21(ejs, v, "info", &r->info));
	NDR_CHECK(ejs_pull_samr_CryptPasswordEx(ejs, v, "password", &r->password));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo26(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_UserInfo26 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_CryptPasswordEx(ejs, v, "password", &r->password));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pw_len", &r->pw_len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_UserInfo26(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_UserInfo26 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_samr_CryptPasswordEx(ejs, v, "password", &r->password));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pw_len", &r->pw_len));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_UserInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_UserInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_samr_UserInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_samr_UserInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_samr_UserInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_samr_UserInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_samr_UserInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_push_samr_UserInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_push_samr_UserInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_push_samr_UserInfo8(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_push_samr_UserInfo9(ejs, v, "info9", &r->info9));
			break;
		case 10:
			NDR_CHECK(ejs_push_samr_UserInfo10(ejs, v, "info10", &r->info10));
			break;
		case 11:
			NDR_CHECK(ejs_push_samr_UserInfo11(ejs, v, "info11", &r->info11));
			break;
		case 12:
			NDR_CHECK(ejs_push_samr_UserInfo12(ejs, v, "info12", &r->info12));
			break;
		case 13:
			NDR_CHECK(ejs_push_samr_UserInfo13(ejs, v, "info13", &r->info13));
			break;
		case 14:
			NDR_CHECK(ejs_push_samr_UserInfo14(ejs, v, "info14", &r->info14));
			break;
		case 16:
			NDR_CHECK(ejs_push_samr_UserInfo16(ejs, v, "info16", &r->info16));
			break;
		case 17:
			NDR_CHECK(ejs_push_samr_UserInfo17(ejs, v, "info17", &r->info17));
			break;
		case 20:
			NDR_CHECK(ejs_push_samr_UserInfo20(ejs, v, "info20", &r->info20));
			break;
		case 21:
			NDR_CHECK(ejs_push_samr_UserInfo21(ejs, v, "info21", &r->info21));
			break;
		case 23:
			NDR_CHECK(ejs_push_samr_UserInfo23(ejs, v, "info23", &r->info23));
			break;
		case 24:
			NDR_CHECK(ejs_push_samr_UserInfo24(ejs, v, "info24", &r->info24));
			break;
		case 25:
			NDR_CHECK(ejs_push_samr_UserInfo25(ejs, v, "info25", &r->info25));
			break;
		case 26:
			NDR_CHECK(ejs_push_samr_UserInfo26(ejs, v, "info26", &r->info26));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_samr_UserInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union samr_UserInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_samr_UserInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_samr_UserInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_pull_samr_UserInfo3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_pull_samr_UserInfo4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_pull_samr_UserInfo5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_pull_samr_UserInfo6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_pull_samr_UserInfo7(ejs, v, "info7", &r->info7));
			break;
		case 8:
			NDR_CHECK(ejs_pull_samr_UserInfo8(ejs, v, "info8", &r->info8));
			break;
		case 9:
			NDR_CHECK(ejs_pull_samr_UserInfo9(ejs, v, "info9", &r->info9));
			break;
		case 10:
			NDR_CHECK(ejs_pull_samr_UserInfo10(ejs, v, "info10", &r->info10));
			break;
		case 11:
			NDR_CHECK(ejs_pull_samr_UserInfo11(ejs, v, "info11", &r->info11));
			break;
		case 12:
			NDR_CHECK(ejs_pull_samr_UserInfo12(ejs, v, "info12", &r->info12));
			break;
		case 13:
			NDR_CHECK(ejs_pull_samr_UserInfo13(ejs, v, "info13", &r->info13));
			break;
		case 14:
			NDR_CHECK(ejs_pull_samr_UserInfo14(ejs, v, "info14", &r->info14));
			break;
		case 16:
			NDR_CHECK(ejs_pull_samr_UserInfo16(ejs, v, "info16", &r->info16));
			break;
		case 17:
			NDR_CHECK(ejs_pull_samr_UserInfo17(ejs, v, "info17", &r->info17));
			break;
		case 20:
			NDR_CHECK(ejs_pull_samr_UserInfo20(ejs, v, "info20", &r->info20));
			break;
		case 21:
			NDR_CHECK(ejs_pull_samr_UserInfo21(ejs, v, "info21", &r->info21));
			break;
		case 23:
			NDR_CHECK(ejs_pull_samr_UserInfo23(ejs, v, "info23", &r->info23));
			break;
		case 24:
			NDR_CHECK(ejs_pull_samr_UserInfo24(ejs, v, "info24", &r->info24));
			break;
		case 25:
			NDR_CHECK(ejs_pull_samr_UserInfo25(ejs, v, "info25", &r->info25));
			break;
		case 26:
			NDR_CHECK(ejs_pull_samr_UserInfo26(ejs, v, "info26", &r->info26));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_samr_Password(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_Password *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "hash", r->hash, 16);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_samr_Password(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_Password *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "hash", r->hash, 16);
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_RidWithAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_RidWithAttribute *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_samr_RidWithAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_RidWithAttribute *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_samr_GroupAttrs(ejs, v, "attributes", &r->attributes));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_samr_RidWithAttributeArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_RidWithAttributeArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->rids) {
		NDR_CHECK(ejs_push_null(ejs, v, "rids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "rids", i);
				NDR_CHECK(ejs_push_samr_RidWithAttribute(ejs, v, id, &r->rids[i]));
			}
			ejs_push_uint32(ejs, v, "rids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_samr_RidWithAttributeArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_RidWithAttributeArray *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "rids")) {
		r->rids = NULL;
	} else {
		EJS_ALLOC(ejs, r->rids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->rids, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "rids", i);
				NDR_CHECK(ejs_pull_samr_RidWithAttribute(ejs, v, id, &r->rids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "rids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispEntryGeneral(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispEntryGeneral *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->idx));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "full_name", &r->full_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispInfoGeneral(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispInfoGeneral *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->entries) {
		NDR_CHECK(ejs_push_null(ejs, v, "entries"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
				NDR_CHECK(ejs_push_samr_DispEntryGeneral(ejs, v, id, &r->entries[i]));
			}
			ejs_push_uint32(ejs, v, "entries" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispEntryFull(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispEntryFull *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->idx));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_samr_AcctFlags(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispInfoFull(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispInfoFull *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->entries) {
		NDR_CHECK(ejs_push_null(ejs, v, "entries"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
				NDR_CHECK(ejs_push_samr_DispEntryFull(ejs, v, id, &r->entries[i]));
			}
			ejs_push_uint32(ejs, v, "entries" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispEntryFullGroup(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispEntryFullGroup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->idx));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_samr_GroupAttrs(ejs, v, "acct_flags", &r->acct_flags));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", &r->account_name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "description", &r->description));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispInfoFullGroups(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispInfoFullGroups *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->entries) {
		NDR_CHECK(ejs_push_null(ejs, v, "entries"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
				NDR_CHECK(ejs_push_samr_DispEntryFullGroup(ejs, v, id, &r->entries[i]));
			}
			ejs_push_uint32(ejs, v, "entries" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispEntryAscii(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispEntryAscii *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->idx));
	NDR_CHECK(ejs_push_lsa_AsciiString(ejs, v, "account_name", &r->account_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispInfoAscii(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_DispInfoAscii *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->entries) {
		NDR_CHECK(ejs_push_null(ejs, v, "entries"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
				NDR_CHECK(ejs_push_samr_DispEntryAscii(ejs, v, id, &r->entries[i]));
			}
			ejs_push_uint32(ejs, v, "entries" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_DispInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_DispInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_samr_DispInfoGeneral(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_samr_DispInfoFull(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_samr_DispInfoFullGroups(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_samr_DispInfoAscii(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_samr_DispInfoAscii(ejs, v, "info5", &r->info5));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_samr_PwInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_PwInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "min_password_length", &r->min_password_length));
	NDR_CHECK(ejs_push_samr_PasswordProperties(ejs, v, "password_properties", &r->password_properties));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_ChangeReject(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_ChangeReject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_samr_RejectReason(ejs, v, "reason", &r->reason));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_ConnectInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct samr_ConnectInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_ConnectInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct samr_ConnectInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_samr_ConnectInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union samr_ConnectInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_samr_ConnectInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_samr_ConnectInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union samr_ConnectInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_pull_samr_ConnectInfo1(ejs, v, "info1", &r->info1));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_samr_Connect(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Connect *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Connect(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Connect *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.connect_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "connect_handle", r->out.connect_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Connect(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CONNECT, (ejs_pull_function_t)ejs_pull_samr_Connect, (ejs_push_function_t)ejs_push_samr_Connect);
}


static NTSTATUS ejs_pull_samr_Close(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Close *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Close(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Close *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Close(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CLOSE, (ejs_pull_function_t)ejs_pull_samr_Close, (ejs_push_function_t)ejs_push_samr_Close);
}


static NTSTATUS ejs_pull_samr_SetSecurity(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetSecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "sec_info", &r->in.sec_info));
	if (ejs_pull_null(ejs, v, "sdbuf")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sdbuf);
		NDR_CHECK(ejs_pull_sec_desc_buf(ejs, v, "sdbuf", r->in.sdbuf));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetSecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetSecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetSecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETSECURITY, (ejs_pull_function_t)ejs_pull_samr_SetSecurity, (ejs_push_function_t)ejs_push_samr_SetSecurity);
}


static NTSTATUS ejs_pull_samr_QuerySecurity(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QuerySecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "sec_info", &r->in.sec_info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QuerySecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QuerySecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sdbuf) {
		NDR_CHECK(ejs_push_null(ejs, v, "sdbuf"));
	} else {
		NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", r->out.sdbuf));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QuerySecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYSECURITY, (ejs_pull_function_t)ejs_pull_samr_QuerySecurity, (ejs_push_function_t)ejs_push_samr_QuerySecurity);
}


static NTSTATUS ejs_pull_samr_Shutdown(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Shutdown *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "connect_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.connect_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "connect_handle", r->in.connect_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Shutdown(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Shutdown *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Shutdown(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SHUTDOWN, (ejs_pull_function_t)ejs_pull_samr_Shutdown, (ejs_push_function_t)ejs_push_samr_Shutdown);
}


static NTSTATUS ejs_pull_samr_LookupDomain(struct ejs_rpc *ejs, struct MprVar *v, struct samr_LookupDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "connect_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.connect_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "connect_handle", r->in.connect_handle));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "domain_name", r->in.domain_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_LookupDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_LookupDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->out.sid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_LookupDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_LOOKUPDOMAIN, (ejs_pull_function_t)ejs_pull_samr_LookupDomain, (ejs_push_function_t)ejs_push_samr_LookupDomain);
}


static NTSTATUS ejs_pull_samr_EnumDomains(struct ejs_rpc *ejs, struct MprVar *v, struct samr_EnumDomains *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "connect_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.connect_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "connect_handle", r->in.connect_handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_EnumDomains(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_EnumDomains *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.sam) {
		NDR_CHECK(ejs_push_null(ejs, v, "sam"));
	} else {
		NDR_CHECK(ejs_push_samr_SamArray(ejs, v, "sam", r->out.sam));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->out.num_entries));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_EnumDomains(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ENUMDOMAINS, (ejs_pull_function_t)ejs_pull_samr_EnumDomains, (ejs_push_function_t)ejs_push_samr_EnumDomains);
}


static NTSTATUS ejs_pull_samr_OpenDomain(struct ejs_rpc *ejs, struct MprVar *v, struct samr_OpenDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "connect_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.connect_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "connect_handle", r->in.connect_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_OpenDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_OpenDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domain_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "domain_handle", r->out.domain_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_OpenDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_OPENDOMAIN, (ejs_pull_function_t)ejs_pull_samr_OpenDomain, (ejs_push_function_t)ejs_push_samr_OpenDomain);
}


static NTSTATUS ejs_pull_samr_QueryDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_DomainInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryDomainInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYDOMAININFO, (ejs_pull_function_t)ejs_pull_samr_QueryDomainInfo, (ejs_push_function_t)ejs_push_samr_QueryDomainInfo);
}


static NTSTATUS ejs_pull_samr_SetDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_DomainInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetDomainInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETDOMAININFO, (ejs_pull_function_t)ejs_pull_samr_SetDomainInfo, (ejs_push_function_t)ejs_push_samr_SetDomainInfo);
}


static NTSTATUS ejs_pull_samr_CreateDomainGroup(struct ejs_rpc *ejs, struct MprVar *v, struct samr_CreateDomainGroup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", r->in.name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_CreateDomainGroup(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_CreateDomainGroup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.group_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "group_handle", r->out.group_handle));
	}
	if (NULL == r->out.rid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rid", r->out.rid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_CreateDomainGroup(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CREATEDOMAINGROUP, (ejs_pull_function_t)ejs_pull_samr_CreateDomainGroup, (ejs_push_function_t)ejs_push_samr_CreateDomainGroup);
}


static NTSTATUS ejs_pull_samr_EnumDomainGroups(struct ejs_rpc *ejs, struct MprVar *v, struct samr_EnumDomainGroups *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_size", &r->in.max_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_EnumDomainGroups(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_EnumDomainGroups *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.sam) {
		NDR_CHECK(ejs_push_null(ejs, v, "sam"));
	} else {
		NDR_CHECK(ejs_push_samr_SamArray(ejs, v, "sam", r->out.sam));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->out.num_entries));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_EnumDomainGroups(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ENUMDOMAINGROUPS, (ejs_pull_function_t)ejs_pull_samr_EnumDomainGroups, (ejs_push_function_t)ejs_push_samr_EnumDomainGroups);
}


static NTSTATUS ejs_pull_samr_CreateUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_CreateUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "account_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.account_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", r->in.account_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_CreateUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_CreateUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.user_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "user_handle", r->out.user_handle));
	}
	if (NULL == r->out.rid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rid", r->out.rid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_CreateUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CREATEUSER, (ejs_pull_function_t)ejs_pull_samr_CreateUser, (ejs_push_function_t)ejs_push_samr_CreateUser);
}


static NTSTATUS ejs_pull_samr_EnumDomainUsers(struct ejs_rpc *ejs, struct MprVar *v, struct samr_EnumDomainUsers *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->in.acct_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_size", &r->in.max_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_EnumDomainUsers(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_EnumDomainUsers *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.sam) {
		NDR_CHECK(ejs_push_null(ejs, v, "sam"));
	} else {
		NDR_CHECK(ejs_push_samr_SamArray(ejs, v, "sam", r->out.sam));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->out.num_entries));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_EnumDomainUsers(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ENUMDOMAINUSERS, (ejs_pull_function_t)ejs_pull_samr_EnumDomainUsers, (ejs_push_function_t)ejs_push_samr_EnumDomainUsers);
}


static NTSTATUS ejs_pull_samr_CreateDomAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_CreateDomAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "alias_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "alias_name", r->in.alias_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_CreateDomAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_CreateDomAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.alias_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "alias_handle", r->out.alias_handle));
	}
	if (NULL == r->out.rid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rid", r->out.rid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_CreateDomAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CREATEDOMALIAS, (ejs_pull_function_t)ejs_pull_samr_CreateDomAlias, (ejs_push_function_t)ejs_push_samr_CreateDomAlias);
}


static NTSTATUS ejs_pull_samr_EnumDomainAliases(struct ejs_rpc *ejs, struct MprVar *v, struct samr_EnumDomainAliases *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->in.acct_flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_EnumDomainAliases(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_EnumDomainAliases *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.sam) {
		NDR_CHECK(ejs_push_null(ejs, v, "sam"));
	} else {
		NDR_CHECK(ejs_push_samr_SamArray(ejs, v, "sam", r->out.sam));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->out.num_entries));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_EnumDomainAliases(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ENUMDOMAINALIASES, (ejs_pull_function_t)ejs_pull_samr_EnumDomainAliases, (ejs_push_function_t)ejs_push_samr_EnumDomainAliases);
}


static NTSTATUS ejs_pull_samr_GetAliasMembership(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetAliasMembership *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetAliasMembership(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetAliasMembership *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.rids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_samr_Ids(ejs, v, "rids", r->out.rids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetAliasMembership(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETALIASMEMBERSHIP, (ejs_pull_function_t)ejs_pull_samr_GetAliasMembership, (ejs_push_function_t)ejs_push_samr_GetAliasMembership);
}


static NTSTATUS ejs_pull_samr_LookupNames(struct ejs_rpc *ejs, struct MprVar *v, struct samr_LookupNames *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->in.num_names));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.names, 1000);
		for (i=0;i<r->in.num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->in.names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_LookupNames(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_LookupNames *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_samr_Ids(ejs, v, "rids", &r->out.rids));
	NDR_CHECK(ejs_push_samr_Ids(ejs, v, "types", &r->out.types));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_LookupNames(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_LOOKUPNAMES, (ejs_pull_function_t)ejs_pull_samr_LookupNames, (ejs_push_function_t)ejs_push_samr_LookupNames);
}


static NTSTATUS ejs_pull_samr_LookupRids(struct ejs_rpc *ejs, struct MprVar *v, struct samr_LookupRids *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_rids", &r->in.num_rids));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.rids, 1000);
		for (i=0;i<r->in.num_rids;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "rids", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->in.rids[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "rids" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_LookupRids(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_LookupRids *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_lsa_Strings(ejs, v, "names", &r->out.names));
	NDR_CHECK(ejs_push_samr_Ids(ejs, v, "types", &r->out.types));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_LookupRids(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_LOOKUPRIDS, (ejs_pull_function_t)ejs_pull_samr_LookupRids, (ejs_push_function_t)ejs_push_samr_LookupRids);
}


static NTSTATUS ejs_pull_samr_OpenGroup(struct ejs_rpc *ejs, struct MprVar *v, struct samr_OpenGroup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_OpenGroup(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_OpenGroup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.group_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "group_handle", r->out.group_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_OpenGroup(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_OPENGROUP, (ejs_pull_function_t)ejs_pull_samr_OpenGroup, (ejs_push_function_t)ejs_push_samr_OpenGroup);
}


static NTSTATUS ejs_pull_samr_QueryGroupInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryGroupInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	NDR_CHECK(ejs_pull_samr_GroupInfoEnum(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryGroupInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryGroupInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_GroupInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryGroupInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYGROUPINFO, (ejs_pull_function_t)ejs_pull_samr_QueryGroupInfo, (ejs_push_function_t)ejs_push_samr_QueryGroupInfo);
}


static NTSTATUS ejs_pull_samr_SetGroupInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetGroupInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	NDR_CHECK(ejs_pull_samr_GroupInfoEnum(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_GroupInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetGroupInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetGroupInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetGroupInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETGROUPINFO, (ejs_pull_function_t)ejs_pull_samr_SetGroupInfo, (ejs_push_function_t)ejs_push_samr_SetGroupInfo);
}


static NTSTATUS ejs_pull_samr_AddGroupMember(struct ejs_rpc *ejs, struct MprVar *v, struct samr_AddGroupMember *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_AddGroupMember(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_AddGroupMember *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_AddGroupMember(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ADDGROUPMEMBER, (ejs_pull_function_t)ejs_pull_samr_AddGroupMember, (ejs_push_function_t)ejs_push_samr_AddGroupMember);
}


static NTSTATUS ejs_pull_samr_DeleteDomainGroup(struct ejs_rpc *ejs, struct MprVar *v, struct samr_DeleteDomainGroup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_DeleteDomainGroup(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_DeleteDomainGroup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.group_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "group_handle", r->out.group_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_DeleteDomainGroup(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_DELETEDOMAINGROUP, (ejs_pull_function_t)ejs_pull_samr_DeleteDomainGroup, (ejs_push_function_t)ejs_push_samr_DeleteDomainGroup);
}


static NTSTATUS ejs_pull_samr_DeleteGroupMember(struct ejs_rpc *ejs, struct MprVar *v, struct samr_DeleteGroupMember *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_DeleteGroupMember(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_DeleteGroupMember *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_DeleteGroupMember(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_DELETEGROUPMEMBER, (ejs_pull_function_t)ejs_pull_samr_DeleteGroupMember, (ejs_push_function_t)ejs_push_samr_DeleteGroupMember);
}


static NTSTATUS ejs_pull_samr_QueryGroupMember(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryGroupMember *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryGroupMember(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryGroupMember *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.rids) {
		NDR_CHECK(ejs_push_null(ejs, v, "rids"));
	} else {
		NDR_CHECK(ejs_push_samr_RidTypeArray(ejs, v, "rids", r->out.rids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryGroupMember(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYGROUPMEMBER, (ejs_pull_function_t)ejs_pull_samr_QueryGroupMember, (ejs_push_function_t)ejs_push_samr_QueryGroupMember);
}


static NTSTATUS ejs_pull_samr_SetMemberAttributesOfGroup(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetMemberAttributesOfGroup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "group_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.group_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "group_handle", r->in.group_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetMemberAttributesOfGroup(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetMemberAttributesOfGroup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetMemberAttributesOfGroup(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETMEMBERATTRIBUTESOFGROUP, (ejs_pull_function_t)ejs_pull_samr_SetMemberAttributesOfGroup, (ejs_push_function_t)ejs_push_samr_SetMemberAttributesOfGroup);
}


static NTSTATUS ejs_pull_samr_OpenAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_OpenAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_OpenAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_OpenAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.alias_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "alias_handle", r->out.alias_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_OpenAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_OPENALIAS, (ejs_pull_function_t)ejs_pull_samr_OpenAlias, (ejs_push_function_t)ejs_push_samr_OpenAlias);
}


static NTSTATUS ejs_pull_samr_QueryAliasInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryAliasInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	NDR_CHECK(ejs_pull_samr_AliasInfoEnum(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryAliasInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryAliasInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_AliasInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryAliasInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYALIASINFO, (ejs_pull_function_t)ejs_pull_samr_QueryAliasInfo, (ejs_push_function_t)ejs_push_samr_QueryAliasInfo);
}


static NTSTATUS ejs_pull_samr_SetAliasInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetAliasInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	NDR_CHECK(ejs_pull_samr_AliasInfoEnum(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_AliasInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetAliasInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetAliasInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetAliasInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETALIASINFO, (ejs_pull_function_t)ejs_pull_samr_SetAliasInfo, (ejs_push_function_t)ejs_push_samr_SetAliasInfo);
}


static NTSTATUS ejs_pull_samr_DeleteDomAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_DeleteDomAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_DeleteDomAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_DeleteDomAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.alias_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "alias_handle", r->out.alias_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_DeleteDomAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_DELETEDOMALIAS, (ejs_pull_function_t)ejs_pull_samr_DeleteDomAlias, (ejs_push_function_t)ejs_push_samr_DeleteDomAlias);
}


static NTSTATUS ejs_pull_samr_AddAliasMember(struct ejs_rpc *ejs, struct MprVar *v, struct samr_AddAliasMember *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_AddAliasMember(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_AddAliasMember *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_AddAliasMember(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ADDALIASMEMBER, (ejs_pull_function_t)ejs_pull_samr_AddAliasMember, (ejs_push_function_t)ejs_push_samr_AddAliasMember);
}


static NTSTATUS ejs_pull_samr_DeleteAliasMember(struct ejs_rpc *ejs, struct MprVar *v, struct samr_DeleteAliasMember *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_DeleteAliasMember(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_DeleteAliasMember *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_DeleteAliasMember(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_DELETEALIASMEMBER, (ejs_pull_function_t)ejs_pull_samr_DeleteAliasMember, (ejs_push_function_t)ejs_push_samr_DeleteAliasMember);
}


static NTSTATUS ejs_pull_samr_GetMembersInAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetMembersInAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetMembersInAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetMembersInAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_SidArray(ejs, v, "sids", r->out.sids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetMembersInAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETMEMBERSINALIAS, (ejs_pull_function_t)ejs_pull_samr_GetMembersInAlias, (ejs_push_function_t)ejs_push_samr_GetMembersInAlias);
}


static NTSTATUS ejs_pull_samr_OpenUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_OpenUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_OpenUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_OpenUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.user_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "user_handle", r->out.user_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_OpenUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_OPENUSER, (ejs_pull_function_t)ejs_pull_samr_OpenUser, (ejs_push_function_t)ejs_push_samr_OpenUser);
}


static NTSTATUS ejs_pull_samr_DeleteUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_DeleteUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_DeleteUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_DeleteUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.user_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "user_handle", r->out.user_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_DeleteUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_DELETEUSER, (ejs_pull_function_t)ejs_pull_samr_DeleteUser, (ejs_push_function_t)ejs_push_samr_DeleteUser);
}


static NTSTATUS ejs_pull_samr_QueryUserInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryUserInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryUserInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryUserInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_UserInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryUserInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYUSERINFO, (ejs_pull_function_t)ejs_pull_samr_QueryUserInfo, (ejs_push_function_t)ejs_push_samr_QueryUserInfo);
}


static NTSTATUS ejs_pull_samr_SetUserInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetUserInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_UserInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetUserInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetUserInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetUserInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETUSERINFO, (ejs_pull_function_t)ejs_pull_samr_SetUserInfo, (ejs_push_function_t)ejs_push_samr_SetUserInfo);
}


static NTSTATUS ejs_pull_samr_ChangePasswordUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_ChangePasswordUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "lm_present", &r->in.lm_present));
	if (ejs_pull_null(ejs, v, "old_lm_crypted")) {
		r->in.old_lm_crypted = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.old_lm_crypted);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "old_lm_crypted", r->in.old_lm_crypted));
	}
	if (ejs_pull_null(ejs, v, "new_lm_crypted")) {
		r->in.new_lm_crypted = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.new_lm_crypted);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "new_lm_crypted", r->in.new_lm_crypted));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "nt_present", &r->in.nt_present));
	if (ejs_pull_null(ejs, v, "old_nt_crypted")) {
		r->in.old_nt_crypted = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.old_nt_crypted);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "old_nt_crypted", r->in.old_nt_crypted));
	}
	if (ejs_pull_null(ejs, v, "new_nt_crypted")) {
		r->in.new_nt_crypted = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.new_nt_crypted);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "new_nt_crypted", r->in.new_nt_crypted));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "cross1_present", &r->in.cross1_present));
	if (ejs_pull_null(ejs, v, "nt_cross")) {
		r->in.nt_cross = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.nt_cross);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "nt_cross", r->in.nt_cross));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "cross2_present", &r->in.cross2_present));
	if (ejs_pull_null(ejs, v, "lm_cross")) {
		r->in.lm_cross = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.lm_cross);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "lm_cross", r->in.lm_cross));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_ChangePasswordUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_ChangePasswordUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_ChangePasswordUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CHANGEPASSWORDUSER, (ejs_pull_function_t)ejs_pull_samr_ChangePasswordUser, (ejs_push_function_t)ejs_push_samr_ChangePasswordUser);
}


static NTSTATUS ejs_pull_samr_GetGroupsForUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetGroupsForUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetGroupsForUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetGroupsForUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.rids) {
		NDR_CHECK(ejs_push_null(ejs, v, "rids"));
	} else {
		NDR_CHECK(ejs_push_samr_RidWithAttributeArray(ejs, v, "rids", r->out.rids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetGroupsForUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETGROUPSFORUSER, (ejs_pull_function_t)ejs_pull_samr_GetGroupsForUser, (ejs_push_function_t)ejs_push_samr_GetGroupsForUser);
}


static NTSTATUS ejs_pull_samr_QueryDisplayInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryDisplayInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start_idx", &r->in.start_idx));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_entries", &r->in.max_entries));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryDisplayInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryDisplayInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_size", &r->out.total_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "returned_size", &r->out.returned_size));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_samr_DispInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryDisplayInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYDISPLAYINFO, (ejs_pull_function_t)ejs_pull_samr_QueryDisplayInfo, (ejs_push_function_t)ejs_push_samr_QueryDisplayInfo);
}


static NTSTATUS ejs_pull_samr_GetDisplayEnumerationIndex(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetDisplayEnumerationIndex *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->in.name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetDisplayEnumerationIndex(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetDisplayEnumerationIndex *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->out.idx));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetDisplayEnumerationIndex(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETDISPLAYENUMERATIONINDEX, (ejs_pull_function_t)ejs_pull_samr_GetDisplayEnumerationIndex, (ejs_push_function_t)ejs_push_samr_GetDisplayEnumerationIndex);
}


static NTSTATUS ejs_pull_samr_TestPrivateFunctionsDomain(struct ejs_rpc *ejs, struct MprVar *v, struct samr_TestPrivateFunctionsDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_TestPrivateFunctionsDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_TestPrivateFunctionsDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_TestPrivateFunctionsDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_TESTPRIVATEFUNCTIONSDOMAIN, (ejs_pull_function_t)ejs_pull_samr_TestPrivateFunctionsDomain, (ejs_push_function_t)ejs_push_samr_TestPrivateFunctionsDomain);
}


static NTSTATUS ejs_pull_samr_TestPrivateFunctionsUser(struct ejs_rpc *ejs, struct MprVar *v, struct samr_TestPrivateFunctionsUser *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_TestPrivateFunctionsUser(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_TestPrivateFunctionsUser *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_TestPrivateFunctionsUser(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_TESTPRIVATEFUNCTIONSUSER, (ejs_pull_function_t)ejs_pull_samr_TestPrivateFunctionsUser, (ejs_push_function_t)ejs_push_samr_TestPrivateFunctionsUser);
}


static NTSTATUS ejs_pull_samr_GetUserPwInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetUserPwInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetUserPwInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetUserPwInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_samr_PwInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetUserPwInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETUSERPWINFO, (ejs_pull_function_t)ejs_pull_samr_GetUserPwInfo, (ejs_push_function_t)ejs_push_samr_GetUserPwInfo);
}


static NTSTATUS ejs_pull_samr_RemoveMemberFromForeignDomain(struct ejs_rpc *ejs, struct MprVar *v, struct samr_RemoveMemberFromForeignDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_RemoveMemberFromForeignDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_RemoveMemberFromForeignDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_RemoveMemberFromForeignDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN, (ejs_pull_function_t)ejs_pull_samr_RemoveMemberFromForeignDomain, (ejs_push_function_t)ejs_push_samr_RemoveMemberFromForeignDomain);
}


static NTSTATUS ejs_pull_samr_QueryDomainInfo2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryDomainInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryDomainInfo2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryDomainInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_DomainInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryDomainInfo2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYDOMAININFO2, (ejs_pull_function_t)ejs_pull_samr_QueryDomainInfo2, (ejs_push_function_t)ejs_push_samr_QueryDomainInfo2);
}


static NTSTATUS ejs_pull_samr_QueryUserInfo2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryUserInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryUserInfo2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryUserInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_samr_UserInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryUserInfo2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYUSERINFO2, (ejs_pull_function_t)ejs_pull_samr_QueryUserInfo2, (ejs_push_function_t)ejs_push_samr_QueryUserInfo2);
}


static NTSTATUS ejs_pull_samr_QueryDisplayInfo2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryDisplayInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start_idx", &r->in.start_idx));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_entries", &r->in.max_entries));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryDisplayInfo2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryDisplayInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_size", &r->out.total_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "returned_size", &r->out.returned_size));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_samr_DispInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryDisplayInfo2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYDISPLAYINFO2, (ejs_pull_function_t)ejs_pull_samr_QueryDisplayInfo2, (ejs_push_function_t)ejs_push_samr_QueryDisplayInfo2);
}


static NTSTATUS ejs_pull_samr_GetDisplayEnumerationIndex2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetDisplayEnumerationIndex2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->in.name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetDisplayEnumerationIndex2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetDisplayEnumerationIndex2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idx", &r->out.idx));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetDisplayEnumerationIndex2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETDISPLAYENUMERATIONINDEX2, (ejs_pull_function_t)ejs_pull_samr_GetDisplayEnumerationIndex2, (ejs_push_function_t)ejs_push_samr_GetDisplayEnumerationIndex2);
}


static NTSTATUS ejs_pull_samr_CreateUser2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_CreateUser2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	if (ejs_pull_null(ejs, v, "account_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.account_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", r->in.account_name));
	}
	NDR_CHECK(ejs_pull_samr_AcctFlags(ejs, v, "acct_flags", &r->in.acct_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_CreateUser2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_CreateUser2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.user_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "user_handle", r->out.user_handle));
	}
	if (NULL == r->out.access_granted) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "access_granted", r->out.access_granted));
	}
	if (NULL == r->out.rid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "rid", r->out.rid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_CreateUser2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CREATEUSER2, (ejs_pull_function_t)ejs_pull_samr_CreateUser2, (ejs_push_function_t)ejs_push_samr_CreateUser2);
}


static NTSTATUS ejs_pull_samr_QueryDisplayInfo3(struct ejs_rpc *ejs, struct MprVar *v, struct samr_QueryDisplayInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "start_idx", &r->in.start_idx));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_entries", &r->in.max_entries));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_size", &r->in.buf_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_QueryDisplayInfo3(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_QueryDisplayInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "total_size", &r->out.total_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "returned_size", &r->out.returned_size));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_samr_DispInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_QueryDisplayInfo3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_QUERYDISPLAYINFO3, (ejs_pull_function_t)ejs_pull_samr_QueryDisplayInfo3, (ejs_push_function_t)ejs_push_samr_QueryDisplayInfo3);
}


static NTSTATUS ejs_pull_samr_AddMultipleMembersToAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_AddMultipleMembersToAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_AddMultipleMembersToAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_AddMultipleMembersToAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_AddMultipleMembersToAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_ADDMULTIPLEMEMBERSTOALIAS, (ejs_pull_function_t)ejs_pull_samr_AddMultipleMembersToAlias, (ejs_push_function_t)ejs_push_samr_AddMultipleMembersToAlias);
}


static NTSTATUS ejs_pull_samr_RemoveMultipleMembersFromAlias(struct ejs_rpc *ejs, struct MprVar *v, struct samr_RemoveMultipleMembersFromAlias *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "alias_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.alias_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "alias_handle", r->in.alias_handle));
	}
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_RemoveMultipleMembersFromAlias(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_RemoveMultipleMembersFromAlias *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_RemoveMultipleMembersFromAlias(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS, (ejs_pull_function_t)ejs_pull_samr_RemoveMultipleMembersFromAlias, (ejs_push_function_t)ejs_push_samr_RemoveMultipleMembersFromAlias);
}


static NTSTATUS ejs_pull_samr_OemChangePasswordUser2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_OemChangePasswordUser2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_lsa_AsciiString(ejs, v, "server", r->in.server));
	}
	if (ejs_pull_null(ejs, v, "account")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.account);
		NDR_CHECK(ejs_pull_lsa_AsciiString(ejs, v, "account", r->in.account));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->in.password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "password", r->in.password));
	}
	if (ejs_pull_null(ejs, v, "hash")) {
		r->in.hash = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.hash);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "hash", r->in.hash));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_OemChangePasswordUser2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_OemChangePasswordUser2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_OemChangePasswordUser2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_OEMCHANGEPASSWORDUSER2, (ejs_pull_function_t)ejs_pull_samr_OemChangePasswordUser2, (ejs_push_function_t)ejs_push_samr_OemChangePasswordUser2);
}


static NTSTATUS ejs_pull_samr_ChangePasswordUser2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_ChangePasswordUser2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "server", r->in.server));
	}
	if (ejs_pull_null(ejs, v, "account")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.account);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account", r->in.account));
	}
	if (ejs_pull_null(ejs, v, "nt_password")) {
		r->in.nt_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.nt_password);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "nt_password", r->in.nt_password));
	}
	if (ejs_pull_null(ejs, v, "nt_verifier")) {
		r->in.nt_verifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.nt_verifier);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "nt_verifier", r->in.nt_verifier));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "lm_change", &r->in.lm_change));
	if (ejs_pull_null(ejs, v, "lm_password")) {
		r->in.lm_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.lm_password);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "lm_password", r->in.lm_password));
	}
	if (ejs_pull_null(ejs, v, "lm_verifier")) {
		r->in.lm_verifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.lm_verifier);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "lm_verifier", r->in.lm_verifier));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_ChangePasswordUser2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_ChangePasswordUser2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_ChangePasswordUser2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CHANGEPASSWORDUSER2, (ejs_pull_function_t)ejs_pull_samr_ChangePasswordUser2, (ejs_push_function_t)ejs_push_samr_ChangePasswordUser2);
}


static NTSTATUS ejs_pull_samr_GetDomPwInfo(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetDomPwInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->in.domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "domain_name", r->in.domain_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetDomPwInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetDomPwInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_samr_PwInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetDomPwInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETDOMPWINFO, (ejs_pull_function_t)ejs_pull_samr_GetDomPwInfo, (ejs_push_function_t)ejs_push_samr_GetDomPwInfo);
}


static NTSTATUS ejs_pull_samr_Connect2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Connect2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Connect2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Connect2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.connect_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "connect_handle", r->out.connect_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Connect2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CONNECT2, (ejs_pull_function_t)ejs_pull_samr_Connect2, (ejs_push_function_t)ejs_push_samr_Connect2);
}


static NTSTATUS ejs_pull_samr_SetUserInfo2(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetUserInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "user_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.user_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "user_handle", r->in.user_handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_UserInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetUserInfo2(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetUserInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetUserInfo2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETUSERINFO2, (ejs_pull_function_t)ejs_pull_samr_SetUserInfo2, (ejs_push_function_t)ejs_push_samr_SetUserInfo2);
}


static NTSTATUS ejs_pull_samr_SetBootKeyInformation(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetBootKeyInformation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "connect_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.connect_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "connect_handle", r->in.connect_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown3", &r->in.unknown3));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetBootKeyInformation(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetBootKeyInformation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetBootKeyInformation(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETBOOTKEYINFORMATION, (ejs_pull_function_t)ejs_pull_samr_SetBootKeyInformation, (ejs_push_function_t)ejs_push_samr_SetBootKeyInformation);
}


static NTSTATUS ejs_pull_samr_GetBootKeyInformation(struct ejs_rpc *ejs, struct MprVar *v, struct samr_GetBootKeyInformation *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_GetBootKeyInformation(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_GetBootKeyInformation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->out.unknown));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_GetBootKeyInformation(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_GETBOOTKEYINFORMATION, (ejs_pull_function_t)ejs_pull_samr_GetBootKeyInformation, (ejs_push_function_t)ejs_push_samr_GetBootKeyInformation);
}


static NTSTATUS ejs_pull_samr_Connect3(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Connect3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Connect3(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Connect3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.connect_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "connect_handle", r->out.connect_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Connect3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CONNECT3, (ejs_pull_function_t)ejs_pull_samr_Connect3, (ejs_push_function_t)ejs_push_samr_Connect3);
}


static NTSTATUS ejs_pull_samr_Connect4(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Connect4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Connect4(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Connect4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.connect_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "connect_handle", r->out.connect_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Connect4(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CONNECT4, (ejs_pull_function_t)ejs_pull_samr_Connect4, (ejs_push_function_t)ejs_push_samr_Connect4);
}


static NTSTATUS ejs_pull_samr_ChangePasswordUser3(struct ejs_rpc *ejs, struct MprVar *v, struct samr_ChangePasswordUser3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server")) {
		r->in.server = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "server", r->in.server));
	}
	if (ejs_pull_null(ejs, v, "account")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.account);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account", r->in.account));
	}
	if (ejs_pull_null(ejs, v, "nt_password")) {
		r->in.nt_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.nt_password);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "nt_password", r->in.nt_password));
	}
	if (ejs_pull_null(ejs, v, "nt_verifier")) {
		r->in.nt_verifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.nt_verifier);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "nt_verifier", r->in.nt_verifier));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "lm_change", &r->in.lm_change));
	if (ejs_pull_null(ejs, v, "lm_password")) {
		r->in.lm_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.lm_password);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "lm_password", r->in.lm_password));
	}
	if (ejs_pull_null(ejs, v, "lm_verifier")) {
		r->in.lm_verifier = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.lm_verifier);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "lm_verifier", r->in.lm_verifier));
	}
	if (ejs_pull_null(ejs, v, "password3")) {
		r->in.password3 = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.password3);
		NDR_CHECK(ejs_pull_samr_CryptPassword(ejs, v, "password3", r->in.password3));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_ChangePasswordUser3(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_ChangePasswordUser3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.dominfo) {
		NDR_CHECK(ejs_push_null(ejs, v, "dominfo"));
	} else {
		NDR_CHECK(ejs_push_samr_DomInfo1(ejs, v, "dominfo", r->out.dominfo));
	}
	if (NULL == r->out.reject) {
		NDR_CHECK(ejs_push_null(ejs, v, "reject"));
	} else {
		NDR_CHECK(ejs_push_samr_ChangeReject(ejs, v, "reject", r->out.reject));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_ChangePasswordUser3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CHANGEPASSWORDUSER3, (ejs_pull_function_t)ejs_pull_samr_ChangePasswordUser3, (ejs_push_function_t)ejs_push_samr_ChangePasswordUser3);
}


static NTSTATUS ejs_pull_samr_Connect5(struct ejs_rpc *ejs, struct MprVar *v, struct samr_Connect5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_samr_ConnectInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_Connect5(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_Connect5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	if (NULL == r->out.info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, r->out.level);
		NDR_CHECK(ejs_push_samr_ConnectInfo(ejs, v, "info", r->out.info));
	}
	if (NULL == r->out.connect_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "connect_handle", r->out.connect_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_Connect5(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_CONNECT5, (ejs_pull_function_t)ejs_pull_samr_Connect5, (ejs_push_function_t)ejs_push_samr_Connect5);
}


static NTSTATUS ejs_pull_samr_RidToSid(struct ejs_rpc *ejs, struct MprVar *v, struct samr_RidToSid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "domain_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "domain_handle", r->in.domain_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->in.rid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_RidToSid(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_RidToSid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->out.sid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_RidToSid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_RIDTOSID, (ejs_pull_function_t)ejs_pull_samr_RidToSid, (ejs_push_function_t)ejs_push_samr_RidToSid);
}


static NTSTATUS ejs_pull_samr_SetDsrmPassword(struct ejs_rpc *ejs, struct MprVar *v, struct samr_SetDsrmPassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "name")) {
		r->in.name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", r->in.name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	if (ejs_pull_null(ejs, v, "hash")) {
		r->in.hash = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.hash);
		NDR_CHECK(ejs_pull_samr_Password(ejs, v, "hash", r->in.hash));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_SetDsrmPassword(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_SetDsrmPassword *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_SetDsrmPassword(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_SETDSRMPASSWORD, (ejs_pull_function_t)ejs_pull_samr_SetDsrmPassword, (ejs_push_function_t)ejs_push_samr_SetDsrmPassword);
}


static NTSTATUS ejs_pull_samr_ValidatePassword(struct ejs_rpc *ejs, struct MprVar *v, struct samr_ValidatePassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_samr_ValidatePassword(struct ejs_rpc *ejs, struct MprVar *v, const struct samr_ValidatePassword *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_samr_ValidatePassword(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_samr, DCERPC_SAMR_VALIDATEPASSWORD, (ejs_pull_function_t)ejs_pull_samr_ValidatePassword, (ejs_push_function_t)ejs_push_samr_ValidatePassword);
}

static int ejs_samr_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "samr", argc, argv);
	mprSetCFunction(obj, "samr_Connect", ejs_samr_Connect);
	mprSetCFunction(obj, "samr_Close", ejs_samr_Close);
	mprSetCFunction(obj, "samr_SetSecurity", ejs_samr_SetSecurity);
	mprSetCFunction(obj, "samr_QuerySecurity", ejs_samr_QuerySecurity);
	mprSetCFunction(obj, "samr_Shutdown", ejs_samr_Shutdown);
	mprSetCFunction(obj, "samr_LookupDomain", ejs_samr_LookupDomain);
	mprSetCFunction(obj, "samr_EnumDomains", ejs_samr_EnumDomains);
	mprSetCFunction(obj, "samr_OpenDomain", ejs_samr_OpenDomain);
	mprSetCFunction(obj, "samr_QueryDomainInfo", ejs_samr_QueryDomainInfo);
	mprSetCFunction(obj, "samr_SetDomainInfo", ejs_samr_SetDomainInfo);
	mprSetCFunction(obj, "samr_CreateDomainGroup", ejs_samr_CreateDomainGroup);
	mprSetCFunction(obj, "samr_EnumDomainGroups", ejs_samr_EnumDomainGroups);
	mprSetCFunction(obj, "samr_CreateUser", ejs_samr_CreateUser);
	mprSetCFunction(obj, "samr_EnumDomainUsers", ejs_samr_EnumDomainUsers);
	mprSetCFunction(obj, "samr_CreateDomAlias", ejs_samr_CreateDomAlias);
	mprSetCFunction(obj, "samr_EnumDomainAliases", ejs_samr_EnumDomainAliases);
	mprSetCFunction(obj, "samr_GetAliasMembership", ejs_samr_GetAliasMembership);
	mprSetCFunction(obj, "samr_LookupNames", ejs_samr_LookupNames);
	mprSetCFunction(obj, "samr_LookupRids", ejs_samr_LookupRids);
	mprSetCFunction(obj, "samr_OpenGroup", ejs_samr_OpenGroup);
	mprSetCFunction(obj, "samr_QueryGroupInfo", ejs_samr_QueryGroupInfo);
	mprSetCFunction(obj, "samr_SetGroupInfo", ejs_samr_SetGroupInfo);
	mprSetCFunction(obj, "samr_AddGroupMember", ejs_samr_AddGroupMember);
	mprSetCFunction(obj, "samr_DeleteDomainGroup", ejs_samr_DeleteDomainGroup);
	mprSetCFunction(obj, "samr_DeleteGroupMember", ejs_samr_DeleteGroupMember);
	mprSetCFunction(obj, "samr_QueryGroupMember", ejs_samr_QueryGroupMember);
	mprSetCFunction(obj, "samr_SetMemberAttributesOfGroup", ejs_samr_SetMemberAttributesOfGroup);
	mprSetCFunction(obj, "samr_OpenAlias", ejs_samr_OpenAlias);
	mprSetCFunction(obj, "samr_QueryAliasInfo", ejs_samr_QueryAliasInfo);
	mprSetCFunction(obj, "samr_SetAliasInfo", ejs_samr_SetAliasInfo);
	mprSetCFunction(obj, "samr_DeleteDomAlias", ejs_samr_DeleteDomAlias);
	mprSetCFunction(obj, "samr_AddAliasMember", ejs_samr_AddAliasMember);
	mprSetCFunction(obj, "samr_DeleteAliasMember", ejs_samr_DeleteAliasMember);
	mprSetCFunction(obj, "samr_GetMembersInAlias", ejs_samr_GetMembersInAlias);
	mprSetCFunction(obj, "samr_OpenUser", ejs_samr_OpenUser);
	mprSetCFunction(obj, "samr_DeleteUser", ejs_samr_DeleteUser);
	mprSetCFunction(obj, "samr_QueryUserInfo", ejs_samr_QueryUserInfo);
	mprSetCFunction(obj, "samr_SetUserInfo", ejs_samr_SetUserInfo);
	mprSetCFunction(obj, "samr_ChangePasswordUser", ejs_samr_ChangePasswordUser);
	mprSetCFunction(obj, "samr_GetGroupsForUser", ejs_samr_GetGroupsForUser);
	mprSetCFunction(obj, "samr_QueryDisplayInfo", ejs_samr_QueryDisplayInfo);
	mprSetCFunction(obj, "samr_GetDisplayEnumerationIndex", ejs_samr_GetDisplayEnumerationIndex);
	mprSetCFunction(obj, "samr_TestPrivateFunctionsDomain", ejs_samr_TestPrivateFunctionsDomain);
	mprSetCFunction(obj, "samr_TestPrivateFunctionsUser", ejs_samr_TestPrivateFunctionsUser);
	mprSetCFunction(obj, "samr_GetUserPwInfo", ejs_samr_GetUserPwInfo);
	mprSetCFunction(obj, "samr_RemoveMemberFromForeignDomain", ejs_samr_RemoveMemberFromForeignDomain);
	mprSetCFunction(obj, "samr_QueryDomainInfo2", ejs_samr_QueryDomainInfo2);
	mprSetCFunction(obj, "samr_QueryUserInfo2", ejs_samr_QueryUserInfo2);
	mprSetCFunction(obj, "samr_QueryDisplayInfo2", ejs_samr_QueryDisplayInfo2);
	mprSetCFunction(obj, "samr_GetDisplayEnumerationIndex2", ejs_samr_GetDisplayEnumerationIndex2);
	mprSetCFunction(obj, "samr_CreateUser2", ejs_samr_CreateUser2);
	mprSetCFunction(obj, "samr_QueryDisplayInfo3", ejs_samr_QueryDisplayInfo3);
	mprSetCFunction(obj, "samr_AddMultipleMembersToAlias", ejs_samr_AddMultipleMembersToAlias);
	mprSetCFunction(obj, "samr_RemoveMultipleMembersFromAlias", ejs_samr_RemoveMultipleMembersFromAlias);
	mprSetCFunction(obj, "samr_OemChangePasswordUser2", ejs_samr_OemChangePasswordUser2);
	mprSetCFunction(obj, "samr_ChangePasswordUser2", ejs_samr_ChangePasswordUser2);
	mprSetCFunction(obj, "samr_GetDomPwInfo", ejs_samr_GetDomPwInfo);
	mprSetCFunction(obj, "samr_Connect2", ejs_samr_Connect2);
	mprSetCFunction(obj, "samr_SetUserInfo2", ejs_samr_SetUserInfo2);
	mprSetCFunction(obj, "samr_SetBootKeyInformation", ejs_samr_SetBootKeyInformation);
	mprSetCFunction(obj, "samr_GetBootKeyInformation", ejs_samr_GetBootKeyInformation);
	mprSetCFunction(obj, "samr_Connect3", ejs_samr_Connect3);
	mprSetCFunction(obj, "samr_Connect4", ejs_samr_Connect4);
	mprSetCFunction(obj, "samr_ChangePasswordUser3", ejs_samr_ChangePasswordUser3);
	mprSetCFunction(obj, "samr_Connect5", ejs_samr_Connect5);
	mprSetCFunction(obj, "samr_RidToSid", ejs_samr_RidToSid);
	mprSetCFunction(obj, "samr_SetDsrmPassword", ejs_samr_SetDsrmPassword);
	mprSetCFunction(obj, "samr_ValidatePassword", ejs_samr_ValidatePassword);
	mprSetVar(obj, "ACB_SMARTCARD_REQUIRED", mprCreateNumberVar(( 0x00001000 )));
	mprSetVar(obj, "DOMAIN_PASSWORD_LOCKOUT_ADMINS", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SAMR_FIELD_PASSWORD", mprCreateNumberVar(( 0x01000000 )));
	mprSetVar(obj, "SAMR_FIELD_CODE_PAGE", mprCreateNumberVar(( 0x00800000 )));
	mprSetVar(obj, "ACB_HOMDIRREQ", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "GROUPINFOALL2", mprCreateNumberVar(5));
	mprSetVar(obj, "SE_GROUP_USE_FOR_DENY_ONLY", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "SAMR_FIELD_ACCOUNT_NAME", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SE_GROUP_MANDATORY", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SAMR_FIELD_PARAMETERS", mprCreateNumberVar(( 0x00200000 )));
	mprSetVar(obj, "SAMR_FIELD_LOGON_SCRIPT", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "ACB_DONT_REQUIRE_PREAUTH", mprCreateNumberVar(( 0x00010000 )));
	mprSetVar(obj, "SE_GROUP_LOGON_ID", mprCreateNumberVar(( 0xC0000000 )));
	mprSetVar(obj, "DOMAIN_PASSWORD_COMPLEX", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SE_GROUP_OWNER", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "GROUPINFOATTRIBUTES", mprCreateNumberVar(3));
	mprSetVar(obj, "ACB_SVRTRUST", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "DOMAIN_REFUSE_PASSWORD_CHANGE", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "GROUPINFODESCRIPTION", mprCreateNumberVar(4));
	mprSetVar(obj, "ACB_ENC_TXT_PWD_ALLOWED", mprCreateNumberVar(( 0x00000800 )));
	mprSetVar(obj, "SAMR_FIELD_ACCT_FLAGS", mprCreateNumberVar(( 0x00100000 )));
	mprSetVar(obj, "DOMAIN_PASSWORD_NO_ANON_CHANGE", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SE_GROUP_RESOURCE", mprCreateNumberVar(( 0x20000000 )));
	mprSetVar(obj, "ALIASINFONAME", mprCreateNumberVar(2));
	mprSetVar(obj, "DOMAIN_PASSWORD_STORE_CLEARTEXT", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "ACB_AUTOLOCK", mprCreateNumberVar(( 0x00000400 )));
	mprSetVar(obj, "SAMR_ROLE_DOMAIN_BDC", mprCreateNumberVar(2));
	mprSetVar(obj, "SAMR_FIELD_HOME_DRIVE", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "ALIASINFODESCRIPTION", mprCreateNumberVar(3));
	mprSetVar(obj, "GROUPINFOALL", mprCreateNumberVar(1));
	mprSetVar(obj, "ACB_NOT_DELEGATED", mprCreateNumberVar(( 0x00004000 )));
	mprSetVar(obj, "SAMR_FIELD_FULL_NAME", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SAMR_ROLE_STANDALONE", mprCreateNumberVar(0));
	mprSetVar(obj, "ACB_TEMPDUP", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "DOMAIN_PASSWORD_NO_CLEAR_CHANGE", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SAMR_ENUM_USERS_MULTIPLIER", mprCreateNumberVar(54));
	mprSetVar(obj, "ALIASINFOALL", mprCreateNumberVar(1));
	mprSetVar(obj, "SAMR_FIELD_HOME_DIRECTORY", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "SAMR_ROLE_DOMAIN_PDC", mprCreateNumberVar(3));
	mprSetVar(obj, "ACB_PWNOTREQ", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SAMR_FIELD_PASSWORD2", mprCreateNumberVar(( 0x02000000 )));
	mprSetVar(obj, "ACB_TRUSTED_FOR_DELEGATION", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "ACB_NO_AUTH_DATA_REQD", mprCreateNumberVar(( 0x00080000 )));
	mprSetVar(obj, "ACB_DOMTRUST", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "SAMR_FIELD_COUNTRY_CODE", mprCreateNumberVar(( 0x00400000 )));
	mprSetVar(obj, "SAMR_ROLE_DOMAIN_MEMBER", mprCreateNumberVar(1));
	mprSetVar(obj, "ACB_NORMAL", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "SAMR_FIELD_PROFILE_PATH", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "GROUPINFONAME", mprCreateNumberVar(2));
	mprSetVar(obj, "ACB_PWNOEXP", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "SAMR_FIELD_PRIMARY_GID", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "ACB_PW_EXPIRED", mprCreateNumberVar(( 0x00020000 )));
	mprSetVar(obj, "ACB_USE_DES_KEY_ONLY", mprCreateNumberVar(( 0x00008000 )));
	mprSetVar(obj, "ACB_MNS", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "ACB_DISABLED", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SAMR_FIELD_LOGON_HOURS", mprCreateNumberVar(( 0x00002000 )));
	mprSetVar(obj, "ACB_WSTRUST", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "SE_GROUP_ENABLED", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SAMR_FIELD_DESCRIPTION", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "SAMR_FIELD_COMMENT", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "SE_GROUP_ENABLED_BY_DEFAULT", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SAMR_FIELD_WORKSTATIONS", mprCreateNumberVar(( 0x00000400 )));
	return ejs_rpc_init(obj, "samr");
}

NTSTATUS ejs_init_samr(void)
{
	ejsDefineCFunction(-1, "samr_init", ejs_samr_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
