
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_security_ejs.h"


static NTSTATUS ejs_push_security_ace_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint8_t *r)
{
	return ejs_push_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_pull_security_ace_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint8_t *r)
{
	return ejs_pull_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_push_security_ace_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum security_ace_type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_security_ace_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum security_ace_type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_security_ace_object_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_security_ace_object_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_security_ace_object_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union security_ace_object_type *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			NDR_CHECK(ejs_push_GUID(ejs, v, "type", &r->type));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_security_ace_object_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union security_ace_object_type *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			NDR_CHECK(ejs_pull_GUID(ejs, v, "type", &r->type));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_security_ace_object_inherited_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union security_ace_object_inherited_type *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			NDR_CHECK(ejs_push_GUID(ejs, v, "inherited_type", &r->inherited_type));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_security_ace_object_inherited_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union security_ace_object_inherited_type *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			NDR_CHECK(ejs_pull_GUID(ejs, v, "inherited_type", &r->inherited_type));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_security_ace_object(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct security_ace_object *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_security_ace_object_flags(ejs, v, "flags", &r->flags));
	ejs_set_switch(ejs, r->flags & SEC_ACE_OBJECT_TYPE_PRESENT);
	NDR_CHECK(ejs_push_security_ace_object_type(ejs, v, "type", &r->type));
	ejs_set_switch(ejs, r->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT);
	NDR_CHECK(ejs_push_security_ace_object_inherited_type(ejs, v, "inherited_type", &r->inherited_type));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_security_ace_object(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct security_ace_object *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_security_ace_object_flags(ejs, v, "flags", &r->flags));
	ejs_set_switch(ejs, r->flags & SEC_ACE_OBJECT_TYPE_PRESENT);
	NDR_CHECK(ejs_pull_security_ace_object_type(ejs, v, "type", &r->type));
	ejs_set_switch(ejs, r->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT);
	NDR_CHECK(ejs_pull_security_ace_object_inherited_type(ejs, v, "inherited_type", &r->inherited_type));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_security_ace_object_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union security_ace_object_ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT:
			NDR_CHECK(ejs_push_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_ACCESS_DENIED_OBJECT:
			NDR_CHECK(ejs_push_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT:
			NDR_CHECK(ejs_push_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT:
			NDR_CHECK(ejs_push_security_ace_object(ejs, v, "object", &r->object));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_security_ace_object_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union security_ace_object_ctr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT:
			NDR_CHECK(ejs_pull_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_ACCESS_DENIED_OBJECT:
			NDR_CHECK(ejs_pull_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT:
			NDR_CHECK(ejs_pull_security_ace_object(ejs, v, "object", &r->object));
			break;
		case SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT:
			NDR_CHECK(ejs_pull_security_ace_object(ejs, v, "object", &r->object));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_security_ace(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct security_ace *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_security_ace_type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_security_ace_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "access_mask", &r->access_mask));
	ejs_set_switch(ejs, r->type);
	NDR_CHECK(ejs_push_security_ace_object_ctr(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_push_dom_sid(ejs, v, "trustee", &r->trustee));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_security_ace(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct security_ace *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_security_ace_type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_security_ace_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->access_mask));
	ejs_set_switch(ejs, r->type);
	NDR_CHECK(ejs_pull_security_ace_object_ctr(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_pull_dom_sid(ejs, v, "trustee", &r->trustee));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_security_acl_revision(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum security_acl_revision *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_security_acl_revision(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum security_acl_revision *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_security_acl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct security_acl *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_security_acl_revision(ejs, v, "revision", &r->revision));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_aces", &r->num_aces));
	{
		uint32_t i;
		for (i=0;i<r->num_aces;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "aces", i);
			NDR_CHECK(ejs_push_security_ace(ejs, v, id, &r->aces[i]));
		}
		ejs_push_uint32(ejs, v, "aces" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_security_acl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct security_acl *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_security_acl_revision(ejs, v, "revision", &r->revision));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_aces", &r->num_aces));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->aces, r->num_aces);
		for (i=0;i<r->num_aces;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "aces", i);
			NDR_CHECK(ejs_pull_security_ace(ejs, v, id, &r->aces[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "aces" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_security_descriptor_revision(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum security_descriptor_revision *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_security_descriptor_revision(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum security_descriptor_revision *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_security_descriptor_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint16_t *r)
{
	return ejs_push_uint16(ejs, v, name, r);
}
static NTSTATUS ejs_pull_security_descriptor_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint16_t *r)
{
	return ejs_pull_uint16(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_push_security_descriptor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct security_descriptor *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_security_descriptor_revision(ejs, v, "revision", &r->revision));
	NDR_CHECK(ejs_push_security_descriptor_type(ejs, v, "type", &r->type));
	if (NULL == r->owner_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "owner_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "owner_sid", r->owner_sid));
	}
	if (NULL == r->group_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "group_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "group_sid", r->group_sid));
	}
	if (NULL == r->sacl) {
		NDR_CHECK(ejs_push_null(ejs, v, "sacl"));
	} else {
		NDR_CHECK(ejs_push_security_acl(ejs, v, "sacl", r->sacl));
	}
	if (NULL == r->dacl) {
		NDR_CHECK(ejs_push_null(ejs, v, "dacl"));
	} else {
		NDR_CHECK(ejs_push_security_acl(ejs, v, "dacl", r->dacl));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_security_descriptor(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct security_descriptor *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_security_descriptor_revision(ejs, v, "revision", &r->revision));
	NDR_CHECK(ejs_pull_security_descriptor_type(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "owner_sid")) {
		r->owner_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->owner_sid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "owner_sid", r->owner_sid));
	}
	if (ejs_pull_null(ejs, v, "group_sid")) {
		r->group_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->group_sid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "group_sid", r->group_sid));
	}
	if (ejs_pull_null(ejs, v, "sacl")) {
		r->sacl = NULL;
	} else {
		EJS_ALLOC(ejs, r->sacl);
		NDR_CHECK(ejs_pull_security_acl(ejs, v, "sacl", r->sacl));
	}
	if (ejs_pull_null(ejs, v, "dacl")) {
		r->dacl = NULL;
	} else {
		EJS_ALLOC(ejs, r->dacl);
		NDR_CHECK(ejs_pull_security_acl(ejs, v, "dacl", r->dacl));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_sec_desc_buf(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct sec_desc_buf *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sd_size", &r->sd_size));
	if (NULL == r->sd) {
		NDR_CHECK(ejs_push_null(ejs, v, "sd"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_sec_desc_buf(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct sec_desc_buf *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "sd")) {
		r->sd = NULL;
	} else {
		EJS_ALLOC(ejs, r->sd);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_security_token(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct security_token *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->user_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "user_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "user_sid", r->user_sid));
	}
	if (NULL == r->group_sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "group_sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "group_sid", r->group_sid));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_sids", &r->num_sids));
	{
		uint32_t i;
		for (i=0;i<r->num_sids;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
			if (NULL == r->sids[i]) {
				NDR_CHECK(ejs_push_null(ejs, v, id));
			} else {
				NDR_CHECK(ejs_push_dom_sid(ejs, v, id, r->sids[i]));
			}
		}
		ejs_push_uint32(ejs, v, "sids" ".length", &i);
	}
	NDR_CHECK(ejs_push_udlong(ejs, v, "privilege_mask", &r->privilege_mask));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_security_token(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct security_token *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "user_sid")) {
		r->user_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->user_sid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "user_sid", r->user_sid));
	}
	if (ejs_pull_null(ejs, v, "group_sid")) {
		r->group_sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->group_sid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "group_sid", r->group_sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_sids", &r->num_sids));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->sids, r->num_sids);
		for (i=0;i<r->num_sids;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
			if (ejs_pull_null(ejs, v, id)) {
				r->sids[i] = NULL;
			} else {
				EJS_ALLOC(ejs, r->sids[i]);
				NDR_CHECK(ejs_pull_dom_sid(ejs, v, id, r->sids[i]));
			}
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "sids" ".length", &i);
	}
	NDR_CHECK(ejs_pull_udlong(ejs, v, "privilege_mask", &r->privilege_mask));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_security_secinfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
_PUBLIC_ NTSTATUS ejs_pull_security_secinfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static int ejs_security_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "security", argc, argv);
	mprSetVar(obj, "SEC_FLAG_MAXIMUM_ALLOWED", mprCreateNumberVar(0x02000000));
	mprSetVar(obj, "SID_BUILTIN_GUESTS", mprString("S-1-5-32-546"));
	mprSetVar(obj, "DOMAIN_RID_USERS", mprCreateNumberVar(513));
	mprSetVar(obj, "SEC_ADS_READ_PROP", mprCreateNumberVar(0x00000010));
	mprSetVar(obj, "SEC_STD_SYNCHRONIZE", mprCreateNumberVar(0x00100000));
	mprSetVar(obj, "SID_BUILTIN_PREW2K", mprString("S-1-5-32-554"));
	mprSetVar(obj, "SEC_FILE_WRITE_DATA", mprCreateNumberVar(0x00000002));
	mprSetVar(obj, "SEC_STD_ALL", mprCreateNumberVar(0x001F0000));
	mprSetVar(obj, "DOMAIN_RID_ADMINISTRATOR", mprCreateNumberVar(500));
	mprSetVar(obj, "SEC_ACE_FLAG_INHERIT_ONLY", mprCreateNumberVar(( 0x08 )));
	mprSetVar(obj, "SEC_FILE_APPEND_DATA", mprCreateNumberVar(0x00000004));
	mprSetVar(obj, "SEC_RIGHTS_FILE_ALL", mprCreateNumberVar(SEC_STD_ALL|SEC_FILE_ALL));
	mprSetVar(obj, "SEC_DESC_DACL_DEFAULTED", mprCreateNumberVar(( 0x0008 )));
	mprSetVar(obj, "SID_NT_LOCAL_SERVICE", mprString("S-1-5-19"));
	mprSetVar(obj, "SID_NT_ANONYMOUS", mprString("S-1-5-7"));
	mprSetVar(obj, "SEC_ACE_FLAG_OBJECT_INHERIT", mprCreateNumberVar(( 0x01 )));
	mprSetVar(obj, "SID_BUILTIN_REPLICATOR", mprString("S-1-5-32-552"));
	mprSetVar(obj, "SID_NT_REMOTE_INTERACTIVE", mprString("S-1-5-14"));
	mprSetVar(obj, "SID_BUILTIN_RAS_SERVERS", mprString("S-1-5-32-553"));
	mprSetVar(obj, "SID_NT_SERVICE", mprString("S-1-5-6"));
	mprSetVar(obj, "SEC_RIGHTS_FILE_WRITE", mprCreateNumberVar(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_WRITE_DATA|SEC_FILE_WRITE_ATTRIBUTE|SEC_FILE_WRITE_EA|SEC_FILE_APPEND_DATA));
	mprSetVar(obj, "SID_BUILTIN_ADMINISTRATORS", mprString("S-1-5-32-544"));
	mprSetVar(obj, "SID_NT_DIALUP", mprString("S-1-5-1"));
	mprSetVar(obj, "SEC_FLAG_SYSTEM_SECURITY", mprCreateNumberVar(0x01000000));
	mprSetVar(obj, "SEC_RIGHTS_FILE_READ", mprCreateNumberVar(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_READ_DATA|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_READ_EA));
	mprSetVar(obj, "SEC_STD_WRITE_DAC", mprCreateNumberVar(0x00040000));
	mprSetVar(obj, "SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT", mprCreateNumberVar(7));
	mprSetVar(obj, "SEC_ADS_DELETE_CHILD", mprCreateNumberVar(0x00000002));
	mprSetVar(obj, "SEC_RIGHTS_DIR_WRITE", mprCreateNumberVar(SEC_RIGHTS_FILE_WRITE));
	mprSetVar(obj, "SEC_DIR_ADD_FILE", mprCreateNumberVar(0x00000002));
	mprSetVar(obj, "SEC_GENERIC_WRITE", mprCreateNumberVar(0x40000000));
	mprSetVar(obj, "SEC_GENERIC_ALL", mprCreateNumberVar(0x10000000));
	mprSetVar(obj, "SID_NT_SELF", mprString("S-1-5-10"));
	mprSetVar(obj, "SEC_STD_REQUIRED", mprCreateNumberVar(0x000F0000));
	mprSetVar(obj, "SEC_ADS_CREATE_CHILD", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "SEC_ACE_FLAG_CONTAINER_INHERIT", mprCreateNumberVar(( 0x02 )));
	mprSetVar(obj, "SEC_RIGHTS_DIR_EXECUTE", mprCreateNumberVar(SEC_RIGHTS_FILE_EXECUTE));
	mprSetVar(obj, "SEC_ADS_WRITE_PROP", mprCreateNumberVar(0x00000020));
	mprSetVar(obj, "SEC_DIR_READ_ATTRIBUTE", mprCreateNumberVar(0x00000080));
	mprSetVar(obj, "SID_CREATOR_OWNER", mprString("S-1-3-0"));
	mprSetVar(obj, "SEC_DIR_READ_EA", mprCreateNumberVar(0x00000008));
	mprSetVar(obj, "SID_NT_SYSTEM", mprString("S-1-5-18"));
	mprSetVar(obj, "SEC_DESC_SACL_PRESENT", mprCreateNumberVar(( 0x0010 )));
	mprSetVar(obj, "SECURITY_ACL_REVISION_ADS", mprCreateNumberVar(4));
	mprSetVar(obj, "SEC_DESC_SACL_AUTO_INHERIT_REQ", mprCreateNumberVar(( 0x0200 )));
	mprSetVar(obj, "SECINFO_DACL", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "SECINFO_GROUP", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SID_BUILTIN_SERVER_OPERATORS", mprString("S-1-5-32-549"));
	mprSetVar(obj, "NT4_ACL_REVISION", mprCreateNumberVar(SECURITY_ACL_REVISION_NT4));
	mprSetVar(obj, "SID_CREATOR_OWNER_DOMAIN", mprString("S-1-3"));
	mprSetVar(obj, "SECURITY_DESCRIPTOR_REVISION_1", mprCreateNumberVar(1));
	mprSetVar(obj, "SEC_REG_CREATE_LINK", mprCreateNumberVar(0x00000020));
	mprSetVar(obj, "SEC_REG_NOTIFY", mprCreateNumberVar(0x00000010));
	mprSetVar(obj, "SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT", mprCreateNumberVar(5));
	mprSetVar(obj, "SEC_REG_CREATE_SUBKEY", mprCreateNumberVar(0x00000004));
	mprSetVar(obj, "SEC_ACE_TYPE_ACCESS_ALLOWED", mprCreateNumberVar(0));
	mprSetVar(obj, "SEC_DIR_TRAVERSE", mprCreateNumberVar(0x00000020));
	mprSetVar(obj, "SEC_DESC_RM_CONTROL_VALID", mprCreateNumberVar(( 0x4000 )));
	mprSetVar(obj, "SEC_DESC_DACL_AUTO_INHERIT_REQ", mprCreateNumberVar(( 0x0100 )));
	mprSetVar(obj, "SEC_FILE_READ_DATA", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "SID_NT_TERMINAL_SERVER_USERS", mprString("S-1-5-13"));
	mprSetVar(obj, "SID_NT_ENTERPRISE_DCS", mprString("S-1-5-9"));
	mprSetVar(obj, "SEC_DESC_SACL_DEFAULTED", mprCreateNumberVar(( 0x0020 )));
	mprSetVar(obj, "SEC_DESC_DACL_TRUSTED", mprCreateNumberVar(( 0x0040 )));
	mprSetVar(obj, "SEC_RIGHTS_DIR_ALL", mprCreateNumberVar(SEC_RIGHTS_FILE_ALL));
	mprSetVar(obj, "SEC_DESC_SELF_RELATIVE", mprCreateNumberVar(( 0x8000 )));
	mprSetVar(obj, "SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "SEC_ACE_FLAG_VALID_INHERIT", mprCreateNumberVar(( 0x0f )));
	mprSetVar(obj, "SID_NT_RESTRICTED", mprString("S-1-5-12"));
	mprSetVar(obj, "SEC_DESC_GROUP_DEFAULTED", mprCreateNumberVar(( 0x0002 )));
	mprSetVar(obj, "SEC_ADS_LIST_OBJECT", mprCreateNumberVar(0x00000080));
	mprSetVar(obj, "SEC_DESC_DACL_PRESENT", mprCreateNumberVar(( 0x0004 )));
	mprSetVar(obj, "SEC_DIR_DELETE_CHILD", mprCreateNumberVar(0x00000040));
	mprSetVar(obj, "SEC_ACE_TYPE_SYSTEM_AUDIT", mprCreateNumberVar(2));
	mprSetVar(obj, "SEC_FILE_READ_ATTRIBUTE", mprCreateNumberVar(0x00000080));
	mprSetVar(obj, "SEC_ACE_FLAG_NO_PROPAGATE_INHERIT", mprCreateNumberVar(( 0x04 )));
	mprSetVar(obj, "SEC_RIGHTS_FILE_EXECUTE", mprCreateNumberVar(SEC_STD_SYNCHRONIZE|SEC_STD_READ_CONTROL|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_EXECUTE));
	mprSetVar(obj, "SID_NT_INTERACTIVE", mprString("S-1-5-4"));
	mprSetVar(obj, "SECURITY_ACL_REVISION_NT4", mprCreateNumberVar(2));
	mprSetVar(obj, "SEC_MASK_STANDARD", mprCreateNumberVar(0x00FF0000));
	mprSetVar(obj, "SID_BUILTIN_POWER_USERS", mprString("S-1-5-32-547"));
	mprSetVar(obj, "SEC_ACE_FLAG_SUCCESSFUL_ACCESS", mprCreateNumberVar(( 0x40 )));
	mprSetVar(obj, "DOMAIN_RID_ADMINS", mprCreateNumberVar(512));
	mprSetVar(obj, "SEC_ACE_FLAG_FAILED_ACCESS", mprCreateNumberVar(( 0x80 )));
	mprSetVar(obj, "SEC_ADS_LIST", mprCreateNumberVar(0x00000004));
	mprSetVar(obj, "SEC_FILE_READ_EA", mprCreateNumberVar(0x00000008));
	mprSetVar(obj, "SID_WORLD_DOMAIN", mprString("S-1-1"));
	mprSetVar(obj, "SEC_ADS_SELF_WRITE", mprCreateNumberVar(0x00000008));
	mprSetVar(obj, "SEC_FILE_WRITE_ATTRIBUTE", mprCreateNumberVar(0x00000100));
	mprSetVar(obj, "DOMAIN_RID_GUEST", mprCreateNumberVar(501));
	mprSetVar(obj, "SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT", mprCreateNumberVar(8));
	mprSetVar(obj, "SEC_REG_QUERY_VALUE", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "SID_CREATOR_GROUP", mprString("S-1-3-1"));
	mprSetVar(obj, "DOMAIN_RID_DCS", mprCreateNumberVar(516));
	mprSetVar(obj, "SID_NT_PROXY", mprString("S-1-5-8"));
	mprSetVar(obj, "SID_NT_AUTHENTICATED_USERS", mprString("S-1-5-11"));
	mprSetVar(obj, "SEC_REG_SET_VALUE", mprCreateNumberVar(0x00000002));
	mprSetVar(obj, "SECINFO_OWNER", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SID_BUILTIN_ACCOUNT_OPERATORS", mprString("S-1-5-32-548"));
	mprSetVar(obj, "SEC_GENERIC_EXECUTE", mprCreateNumberVar(0x20000000));
	mprSetVar(obj, "SEC_ADS_CONTROL_ACCESS", mprCreateNumberVar(0x00000100));
	mprSetVar(obj, "SEC_ACE_FLAG_INHERITED_ACE", mprCreateNumberVar(( 0x10 )));
	mprSetVar(obj, "SEC_FILE_EXECUTE", mprCreateNumberVar(0x00000020));
	mprSetVar(obj, "SID_NT_AUTHORITY", mprString("S-1-5"));
	mprSetVar(obj, "SEC_DIR_ADD_SUBDIR", mprCreateNumberVar(0x00000004));
	mprSetVar(obj, "SEC_ACE_TYPE_SYSTEM_ALARM", mprCreateNumberVar(3));
	mprSetVar(obj, "SID_NULL", mprString("S-1-0-0"));
	mprSetVar(obj, "SEC_FILE_WRITE_EA", mprCreateNumberVar(0x00000010));
	mprSetVar(obj, "DOMAIN_RID_LOGON", mprCreateNumberVar(9));
	mprSetVar(obj, "SID_WORLD", mprString("S-1-1-0"));
	mprSetVar(obj, "SEC_DIR_LIST", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "SD_REVISION", mprCreateNumberVar(SECURITY_DESCRIPTOR_REVISION_1));
	mprSetVar(obj, "SEC_STD_READ_CONTROL", mprCreateNumberVar(0x00020000));
	mprSetVar(obj, "SEC_MASK_GENERIC", mprCreateNumberVar(0xF0000000));
	mprSetVar(obj, "SEC_FILE_ALL", mprCreateNumberVar(0x000001ff));
	mprSetVar(obj, "SEC_GENERIC_READ", mprCreateNumberVar(0x80000000));
	mprSetVar(obj, "SEC_DIR_WRITE_EA", mprCreateNumberVar(0x00000010));
	mprSetVar(obj, "DOMAIN_RID_ENTERPRISE_ADMINS", mprCreateNumberVar(519));
	mprSetVar(obj, "DOMAIN_RID_SCHEMA_ADMINS", mprCreateNumberVar(518));
	mprSetVar(obj, "SEC_MASK_SPECIFIC", mprCreateNumberVar(0x0000FFFF));
	mprSetVar(obj, "SID_BUILTIN_USERS", mprString("S-1-5-32-545"));
	mprSetVar(obj, "DOMAIN_RID_CERT_ADMINS", mprCreateNumberVar(517));
	mprSetVar(obj, "SEC_REG_ENUM_SUBKEYS", mprCreateNumberVar(0x00000008));
	mprSetVar(obj, "SEC_RIGHTS_DIR_READ", mprCreateNumberVar(SEC_RIGHTS_FILE_READ));
	mprSetVar(obj, "SEC_ACE_TYPE_ACCESS_DENIED_OBJECT", mprCreateNumberVar(6));
	mprSetVar(obj, "SEC_DESC_DACL_PROTECTED", mprCreateNumberVar(( 0x1000 )));
	mprSetVar(obj, "SID_BUILTIN", mprString("S-1-5-32"));
	mprSetVar(obj, "SEC_DESC_SACL_AUTO_INHERITED", mprCreateNumberVar(( 0x0800 )));
	mprSetVar(obj, "SID_BUILTIN_BACKUP_OPERATORS", mprString("S-1-5-32-551"));
	mprSetVar(obj, "SEC_DESC_DACL_AUTO_INHERITED", mprCreateNumberVar(( 0x0400 )));
	mprSetVar(obj, "SID_BUILTIN_PRINT_OPERATORS", mprString("S-1-5-32-550"));
	mprSetVar(obj, "SID_NT_BATCH", mprString("S-1-5-3"));
	mprSetVar(obj, "SEC_MASK_FLAGS", mprCreateNumberVar(0x0F000000));
	mprSetVar(obj, "SEC_DESC_OWNER_DEFAULTED", mprCreateNumberVar(( 0x0001 )));
	mprSetVar(obj, "SEC_ACE_TYPE_ACCESS_DENIED", mprCreateNumberVar(1));
	mprSetVar(obj, "SEC_STD_WRITE_OWNER", mprCreateNumberVar(0x00080000));
	mprSetVar(obj, "SEC_ACE_TYPE_ALLOWED_COMPOUND", mprCreateNumberVar(4));
	mprSetVar(obj, "SEC_STD_DELETE", mprCreateNumberVar(0x00010000));
	mprSetVar(obj, "SECINFO_SACL", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "SEC_DIR_WRITE_ATTRIBUTE", mprCreateNumberVar(0x00000100));
	mprSetVar(obj, "SEC_DESC_SACL_PROTECTED", mprCreateNumberVar(( 0x2000 )));
	mprSetVar(obj, "SID_NT_NETWORK", mprString("S-1-5-2"));
	mprSetVar(obj, "SID_NT_NETWORK_SERVICE", mprString("S-1-5-20"));
	mprSetVar(obj, "SEC_DESC_SERVER_SECURITY", mprCreateNumberVar(( 0x0080 )));
	mprSetVar(obj, "SEC_ACE_OBJECT_TYPE_PRESENT", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "SID_NT_THIS_ORGANISATION", mprString("S-1-5-15"));
	mprSetVar(obj, "SEC_ADS_DELETE_TREE", mprCreateNumberVar(0x00000040));
	return ejs_rpc_init(obj, "security");
}

NTSTATUS ejs_init_security(void)
{
	ejsDefineCFunction(-1, "security_init", ejs_security_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
