
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_unixinfo.h"
#include "librpc/gen_ndr/ndr_unixinfo_ejs.h"


static NTSTATUS ejs_push_unixinfo_GetPWUidInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct unixinfo_GetPWUidInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "status", &r->status));
	NDR_CHECK(ejs_push_string(ejs, v, "homedir", r->homedir));
	NDR_CHECK(ejs_push_string(ejs, v, "shell", r->shell));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_unixinfo_SidToUid(struct ejs_rpc *ejs, struct MprVar *v, struct unixinfo_SidToUid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_dom_sid(ejs, v, "sid", &r->in.sid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_unixinfo_SidToUid(struct ejs_rpc *ejs, struct MprVar *v, const struct unixinfo_SidToUid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.uid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_hyper(ejs, v, "uid", r->out.uid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_unixinfo_SidToUid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_unixinfo, DCERPC_UNIXINFO_SIDTOUID, (ejs_pull_function_t)ejs_pull_unixinfo_SidToUid, (ejs_push_function_t)ejs_push_unixinfo_SidToUid);
}


static NTSTATUS ejs_pull_unixinfo_UidToSid(struct ejs_rpc *ejs, struct MprVar *v, struct unixinfo_UidToSid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "uid", &r->in.uid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_unixinfo_UidToSid(struct ejs_rpc *ejs, struct MprVar *v, const struct unixinfo_UidToSid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "sid", r->out.sid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_unixinfo_UidToSid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_unixinfo, DCERPC_UNIXINFO_UIDTOSID, (ejs_pull_function_t)ejs_pull_unixinfo_UidToSid, (ejs_push_function_t)ejs_push_unixinfo_UidToSid);
}


static NTSTATUS ejs_pull_unixinfo_SidToGid(struct ejs_rpc *ejs, struct MprVar *v, struct unixinfo_SidToGid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_dom_sid(ejs, v, "sid", &r->in.sid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_unixinfo_SidToGid(struct ejs_rpc *ejs, struct MprVar *v, const struct unixinfo_SidToGid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.gid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_hyper(ejs, v, "gid", r->out.gid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_unixinfo_SidToGid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_unixinfo, DCERPC_UNIXINFO_SIDTOGID, (ejs_pull_function_t)ejs_pull_unixinfo_SidToGid, (ejs_push_function_t)ejs_push_unixinfo_SidToGid);
}


static NTSTATUS ejs_pull_unixinfo_GidToSid(struct ejs_rpc *ejs, struct MprVar *v, struct unixinfo_GidToSid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "gid", &r->in.gid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_unixinfo_GidToSid(struct ejs_rpc *ejs, struct MprVar *v, const struct unixinfo_GidToSid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "sid", r->out.sid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_unixinfo_GidToSid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_unixinfo, DCERPC_UNIXINFO_GIDTOSID, (ejs_pull_function_t)ejs_pull_unixinfo_GidToSid, (ejs_push_function_t)ejs_push_unixinfo_GidToSid);
}


static NTSTATUS ejs_pull_unixinfo_GetPWUid(struct ejs_rpc *ejs, struct MprVar *v, struct unixinfo_GetPWUid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.uids, *r->in.count);
		for (i=0;i<*r->in.count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "uids", i);
			NDR_CHECK(ejs_pull_hyper(ejs, v, id, &r->in.uids[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "uids" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_unixinfo_GetPWUid(struct ejs_rpc *ejs, struct MprVar *v, const struct unixinfo_GetPWUid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	{
		uint32_t i;
		for (i=0;i<*r->out.count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "infos", i);
			NDR_CHECK(ejs_push_unixinfo_GetPWUidInfo(ejs, v, id, &r->out.infos[i]));
		}
		ejs_push_uint32(ejs, v, "infos" ".length", &i);
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_unixinfo_GetPWUid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_unixinfo, DCERPC_UNIXINFO_GETPWUID, (ejs_pull_function_t)ejs_pull_unixinfo_GetPWUid, (ejs_push_function_t)ejs_push_unixinfo_GetPWUid);
}

static int ejs_unixinfo_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "unixinfo", argc, argv);
	mprSetCFunction(obj, "unixinfo_SidToUid", ejs_unixinfo_SidToUid);
	mprSetCFunction(obj, "unixinfo_UidToSid", ejs_unixinfo_UidToSid);
	mprSetCFunction(obj, "unixinfo_SidToGid", ejs_unixinfo_SidToGid);
	mprSetCFunction(obj, "unixinfo_GidToSid", ejs_unixinfo_GidToSid);
	mprSetCFunction(obj, "unixinfo_GetPWUid", ejs_unixinfo_GetPWUid);
	return ejs_rpc_init(obj, "unixinfo");
}

NTSTATUS ejs_init_unixinfo(void)
{
	ejsDefineCFunction(-1, "unixinfo_init", ejs_unixinfo_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
