
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_winbind.h"
#include "librpc/gen_ndr/ndr_winbind_ejs.h"



static NTSTATUS ejs_pull_winbind_information(struct ejs_rpc *ejs, struct MprVar *v, struct winbind_information *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winbind_information(struct ejs_rpc *ejs, struct MprVar *v, const struct winbind_information *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_winbind_information(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winbind, DCERPC_WINBIND_INFORMATION, (ejs_pull_function_t)ejs_pull_winbind_information, (ejs_push_function_t)ejs_push_winbind_information);
}


static NTSTATUS ejs_pull_winbind_remote_control(struct ejs_rpc *ejs, struct MprVar *v, struct winbind_remote_control *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winbind_remote_control(struct ejs_rpc *ejs, struct MprVar *v, const struct winbind_remote_control *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winbind_remote_control(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winbind, DCERPC_WINBIND_REMOTE_CONTROL, (ejs_pull_function_t)ejs_pull_winbind_remote_control, (ejs_push_function_t)ejs_push_winbind_remote_control);
}


static NTSTATUS ejs_pull_winbind_SamLogon(struct ejs_rpc *ejs, struct MprVar *v, struct winbind_SamLogon *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "logon_level", &r->in.logon_level));
	ejs_set_switch(ejs, r->in.logon_level);
	NDR_CHECK(ejs_pull_netr_LogonLevel(ejs, v, "logon", &r->in.logon));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "validation_level", &r->in.validation_level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_winbind_SamLogon(struct ejs_rpc *ejs, struct MprVar *v, const struct winbind_SamLogon *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.validation_level);
	NDR_CHECK(ejs_push_netr_Validation(ejs, v, "validation", &r->out.validation));
	NDR_CHECK(ejs_push_uint8(ejs, v, "authoritative", &r->out.authoritative));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->out.flags));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_winbind_SamLogon(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_winbind, DCERPC_WINBIND_SAMLOGON, (ejs_pull_function_t)ejs_pull_winbind_SamLogon, (ejs_push_function_t)ejs_push_winbind_SamLogon);
}

static int ejs_winbind_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "winbind", argc, argv);
	mprSetCFunction(obj, "winbind_information", ejs_winbind_information);
	mprSetCFunction(obj, "winbind_remote_control", ejs_winbind_remote_control);
	mprSetCFunction(obj, "winbind_SamLogon", ejs_winbind_SamLogon);
	return ejs_rpc_init(obj, "winbind");
}

NTSTATUS ejs_init_winbind(void)
{
	ejsDefineCFunction(-1, "winbind_init", ejs_winbind_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
