
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_winsrepl.h"
#include "librpc/gen_ndr/ndr_winsrepl_ejs.h"


static NTSTATUS ejs_push_wrepl_ip(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_ip *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "owner", r->owner));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "ip", r->ip));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_ip(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_ip *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "owner", &r->owner));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "ip", &r->ip));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_address_list(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_address_list *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_ips", &r->num_ips));
	{
		uint32_t i;
		for (i=0;i<r->num_ips;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "ips", i);
			NDR_CHECK(ejs_push_wrepl_ip(ejs, v, id, &r->ips[i]));
		}
		ejs_push_uint32(ejs, v, "ips" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_address_list(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_address_list *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_ips", &r->num_ips));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->ips, r->num_ips);
		for (i=0;i<r->num_ips;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "ips", i);
			NDR_CHECK(ejs_pull_wrepl_ip(ejs, v, id, &r->ips[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "ips" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_addresses(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union wrepl_addresses *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_push_ipv4address(ejs, v, "ip", r->ip));
			break;
		case 2:
			NDR_CHECK(ejs_push_wrepl_address_list(ejs, v, "addresses", &r->addresses));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wrepl_addresses(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union wrepl_addresses *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_pull_ipv4address(ejs, v, "ip", &r->ip));
			break;
		case 2:
			NDR_CHECK(ejs_pull_wrepl_address_list(ejs, v, "addresses", &r->addresses));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_wrepl_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_wrepl_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_wrepl_group_flag(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum wrepl_group_flag *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_group_flag(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum wrepl_group_flag *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_wins_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_wins_name *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_wrepl_nbt_name(ejs, v, "name", r->name));
	NDR_CHECK(ejs_push_wrepl_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_wrepl_group_flag(ejs, v, "is_group", &r->is_group));
	NDR_CHECK(ejs_push_udlongr(ejs, v, "id", &r->id));
	ejs_set_switch(ejs, r->flags & 2);
	NDR_CHECK(ejs_push_wrepl_addresses(ejs, v, "addresses", &r->addresses));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "unknown", r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_wins_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_wins_name *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_wrepl_nbt_name(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_wrepl_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_udlongr(ejs, v, "id", &r->id));
	ejs_set_switch(ejs, r->flags & 2);
	NDR_CHECK(ejs_pull_wrepl_addresses(ejs, v, "addresses", &r->addresses));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_send_reply(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_send_reply *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_names", &r->num_names));
	{
		uint32_t i;
		for (i=0;i<r->num_names;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_push_wrepl_wins_name(ejs, v, id, &r->names[i]));
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_send_reply(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_send_reply *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->num_names));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->names, r->num_names);
		for (i=0;i<r->num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_wrepl_wins_name(ejs, v, id, &r->names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_wins_owner(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_wins_owner *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "address", r->address));
	NDR_CHECK(ejs_push_udlongr(ejs, v, "max_version", &r->max_version));
	NDR_CHECK(ejs_push_udlongr(ejs, v, "min_version", &r->min_version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->type));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_wins_owner(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_wins_owner *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "address", &r->address));
	NDR_CHECK(ejs_pull_udlongr(ejs, v, "max_version", &r->max_version));
	NDR_CHECK(ejs_pull_udlongr(ejs, v, "min_version", &r->min_version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->type));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_table(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_table *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "partner_count", &r->partner_count));
	{
		uint32_t i;
		for (i=0;i<r->partner_count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "partners", i);
			NDR_CHECK(ejs_push_wrepl_wins_owner(ejs, v, id, &r->partners[i]));
		}
		ejs_push_uint32(ejs, v, "partners" ".length", &i);
	}
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "initiator", r->initiator));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_table(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_table *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "partner_count", &r->partner_count));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->partners, r->partner_count);
		for (i=0;i<r->partner_count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "partners", i);
			NDR_CHECK(ejs_pull_wrepl_wins_owner(ejs, v, id, &r->partners[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "partners" ".length", &i);
	}
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "initiator", &r->initiator));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_replication_cmd(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum wrepl_replication_cmd *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_replication_cmd(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum wrepl_replication_cmd *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_replication_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union wrepl_replication_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case WREPL_REPL_TABLE_QUERY:
			break;
		case WREPL_REPL_TABLE_REPLY:
			NDR_CHECK(ejs_push_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_SEND_REQUEST:
			NDR_CHECK(ejs_push_wrepl_wins_owner(ejs, v, "owner", &r->owner));
			break;
		case WREPL_REPL_SEND_REPLY:
			NDR_CHECK(ejs_push_wrepl_send_reply(ejs, v, "reply", &r->reply));
			break;
		case WREPL_REPL_UPDATE:
			NDR_CHECK(ejs_push_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_UPDATE2:
			NDR_CHECK(ejs_push_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_INFORM:
			NDR_CHECK(ejs_push_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_INFORM2:
			NDR_CHECK(ejs_push_wrepl_table(ejs, v, "table", &r->table));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wrepl_replication_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union wrepl_replication_info *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case WREPL_REPL_TABLE_QUERY:
			break;
		case WREPL_REPL_TABLE_REPLY:
			NDR_CHECK(ejs_pull_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_SEND_REQUEST:
			NDR_CHECK(ejs_pull_wrepl_wins_owner(ejs, v, "owner", &r->owner));
			break;
		case WREPL_REPL_SEND_REPLY:
			NDR_CHECK(ejs_pull_wrepl_send_reply(ejs, v, "reply", &r->reply));
			break;
		case WREPL_REPL_UPDATE:
			NDR_CHECK(ejs_pull_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_UPDATE2:
			NDR_CHECK(ejs_pull_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_INFORM:
			NDR_CHECK(ejs_pull_wrepl_table(ejs, v, "table", &r->table));
			break;
		case WREPL_REPL_INFORM2:
			NDR_CHECK(ejs_pull_wrepl_table(ejs, v, "table", &r->table));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_wrepl_replication(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_replication *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_wrepl_replication_cmd(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_push_wrepl_replication_info(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_replication(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_replication *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_wrepl_replication_cmd(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_pull_wrepl_replication_info(ejs, v, "info", &r->info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_start(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_start *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "assoc_ctx", &r->assoc_ctx));
	NDR_CHECK(ejs_push_uint16(ejs, v, "minor_version", &r->minor_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "major_version", &r->major_version));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_start(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_start *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "assoc_ctx", &r->assoc_ctx));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "minor_version", &r->minor_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "major_version", &r->major_version));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_stop(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_stop *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reason", &r->reason));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_stop(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_stop *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reason", &r->reason));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_mess_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum wrepl_mess_type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wrepl_mess_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum wrepl_mess_type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wrepl_message(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union wrepl_message *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case WREPL_START_ASSOCIATION:
			NDR_CHECK(ejs_push_wrepl_start(ejs, v, "start", &r->start));
			break;
		case WREPL_START_ASSOCIATION_REPLY:
			NDR_CHECK(ejs_push_wrepl_start(ejs, v, "start_reply", &r->start_reply));
			break;
		case WREPL_STOP_ASSOCIATION:
			NDR_CHECK(ejs_push_wrepl_stop(ejs, v, "stop", &r->stop));
			break;
		case WREPL_REPLICATION:
			NDR_CHECK(ejs_push_wrepl_replication(ejs, v, "replication", &r->replication));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wrepl_message(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union wrepl_message *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case WREPL_START_ASSOCIATION:
			NDR_CHECK(ejs_pull_wrepl_start(ejs, v, "start", &r->start));
			break;
		case WREPL_START_ASSOCIATION_REPLY:
			NDR_CHECK(ejs_pull_wrepl_start(ejs, v, "start_reply", &r->start_reply));
			break;
		case WREPL_STOP_ASSOCIATION:
			NDR_CHECK(ejs_pull_wrepl_stop(ejs, v, "stop", &r->stop));
			break;
		case WREPL_REPLICATION:
			NDR_CHECK(ejs_pull_wrepl_replication(ejs, v, "replication", &r->replication));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_wrepl_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opcode", &r->opcode));
	NDR_CHECK(ejs_push_uint32(ejs, v, "assoc_ctx", &r->assoc_ctx));
	NDR_CHECK(ejs_push_wrepl_mess_type(ejs, v, "mess_type", &r->mess_type));
	ejs_set_switch(ejs, r->mess_type);
	NDR_CHECK(ejs_push_wrepl_message(ejs, v, "message", &r->message));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "padding", &r->padding));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_wrepl_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opcode", &r->opcode));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "assoc_ctx", &r->assoc_ctx));
	NDR_CHECK(ejs_pull_wrepl_mess_type(ejs, v, "mess_type", &r->mess_type));
	ejs_set_switch(ejs, r->mess_type);
	NDR_CHECK(ejs_pull_wrepl_message(ejs, v, "message", &r->message));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "padding", &r->padding));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_wrepl_wrap(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wrepl_wrap *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_wrepl_packet(ejs, v, "packet", &r->packet));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_wrepl_wrap(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wrepl_wrap *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_wrepl_packet(ejs, v, "packet", &r->packet));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_decode_winsrepl(struct ejs_rpc *ejs, struct MprVar *v, struct decode_winsrepl *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_wrepl_wrap(ejs, v, "p", &r->in.p));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_decode_winsrepl(struct ejs_rpc *ejs, struct MprVar *v, const struct decode_winsrepl *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_decode_winsrepl(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wrepl, DCERPC_DECODE_WINSREPL, (ejs_pull_function_t)ejs_pull_decode_winsrepl, (ejs_push_function_t)ejs_push_decode_winsrepl);
}

static int ejs_wrepl_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "wrepl", argc, argv);
	mprSetCFunction(obj, "decode_winsrepl", ejs_decode_winsrepl);
	mprSetVar(obj, "WREPL_START_ASSOCIATION", mprCreateNumberVar(0));
	mprSetVar(obj, "WREPL_FLAGS_RECORD_TYPE", mprCreateNumberVar(( 0x00000003 )));
	mprSetVar(obj, "WREPL_REPL_SEND_REQUEST", mprCreateNumberVar(2));
	mprSetVar(obj, "WREPL_GROUP_FLAG_NO_GROUP", mprCreateNumberVar(0x00000000));
	mprSetVar(obj, "WREPL_REPL_INFORM", mprCreateNumberVar(8));
	mprSetVar(obj, "WREPL_STOP_ASSOCIATION", mprCreateNumberVar(2));
	mprSetVar(obj, "WREPL_REPL_UPDATE2", mprCreateNumberVar(5));
	mprSetVar(obj, "WREPL_REPL_TABLE_QUERY", mprCreateNumberVar(0));
	mprSetVar(obj, "WREPL_FLAGS_IS_STATIC", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "WREPL_REPL_UPDATE", mprCreateNumberVar(4));
	mprSetVar(obj, "WREPL_REPL_SEND_REPLY", mprCreateNumberVar(3));
	mprSetVar(obj, "WREPL_GROUP_FLAG_IS_GROUP", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "WREPL_REPL_TABLE_REPLY", mprCreateNumberVar(1));
	mprSetVar(obj, "WREPL_FLAGS_RECORD_STATE", mprCreateNumberVar(( 0x0000000C )));
	mprSetVar(obj, "WREPL_FLAGS_NODE_TYPE", mprCreateNumberVar(( 0x00000060 )));
	mprSetVar(obj, "WREPL_OPCODE_BITS", mprCreateNumberVar(0x7800));
	mprSetVar(obj, "WREPL_REPL_INFORM2", mprCreateNumberVar(9));
	mprSetVar(obj, "WINS_REPLICATION_PORT", mprCreateNumberVar(42));
	mprSetVar(obj, "WREPL_START_ASSOCIATION_REPLY", mprCreateNumberVar(1));
	mprSetVar(obj, "WREPL_FLAGS_REGISTERED_LOCAL", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "WREPL_REPLICATION", mprCreateNumberVar(3));
	return ejs_rpc_init(obj, "wrepl");
}

NTSTATUS ejs_init_wrepl(void)
{
	ejsDefineCFunction(-1, "wrepl_init", ejs_wrepl_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
