/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_wkssvc.h"

#include "librpc/gen_ndr/ndr_srvsvc.h"
static NTSTATUS ndr_push_wkssvc_NetWkstaInfo100(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_minor));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo100(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo100 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_domain_name;
	TALLOC_CTX *_mem_save_domain_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_minor));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			if (ndr_get_array_length(ndr, &r->domain_name) > ndr_get_array_size(ndr, &r->domain_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain_name), ndr_get_array_length(ndr, &r->domain_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo100(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo100 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo100");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version_major", r->version_major);
	ndr_print_uint32(ndr, "version_minor", r->version_minor);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo101(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_minor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lan_root));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lan_root) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lan_root, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lan_root, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lan_root, ndr_charset_length(r->lan_root, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo101(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo101 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_domain_name;
	TALLOC_CTX *_mem_save_domain_name_0;
	uint32_t _ptr_lan_root;
	TALLOC_CTX *_mem_save_lan_root_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_minor));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lan_root));
		if (_ptr_lan_root) {
			NDR_PULL_ALLOC(ndr, r->lan_root);
		} else {
			r->lan_root = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			if (ndr_get_array_length(ndr, &r->domain_name) > ndr_get_array_size(ndr, &r->domain_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain_name), ndr_get_array_length(ndr, &r->domain_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		if (r->lan_root) {
			_mem_save_lan_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lan_root, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lan_root));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lan_root));
			if (ndr_get_array_length(ndr, &r->lan_root) > ndr_get_array_size(ndr, &r->lan_root)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->lan_root), ndr_get_array_length(ndr, &r->lan_root));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->lan_root), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lan_root, ndr_get_array_length(ndr, &r->lan_root), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lan_root_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo101(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo101 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo101");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version_major", r->version_major);
	ndr_print_uint32(ndr, "version_minor", r->version_minor);
	ndr_print_ptr(ndr, "lan_root", r->lan_root);
	ndr->depth++;
	if (r->lan_root) {
		ndr_print_string(ndr, "lan_root", r->lan_root);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo102(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_srvsvc_PlatformId(ndr, NDR_SCALARS, r->platform_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_minor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lan_root));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logged_on_users));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lan_root) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lan_root, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lan_root, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lan_root, ndr_charset_length(r->lan_root, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo102(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo102 *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_domain_name;
	TALLOC_CTX *_mem_save_domain_name_0;
	uint32_t _ptr_lan_root;
	TALLOC_CTX *_mem_save_lan_root_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_srvsvc_PlatformId(ndr, NDR_SCALARS, &r->platform_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_minor));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lan_root));
		if (_ptr_lan_root) {
			NDR_PULL_ALLOC(ndr, r->lan_root);
		} else {
			r->lan_root = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logged_on_users));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			if (ndr_get_array_length(ndr, &r->domain_name) > ndr_get_array_size(ndr, &r->domain_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain_name), ndr_get_array_length(ndr, &r->domain_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		if (r->lan_root) {
			_mem_save_lan_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lan_root, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lan_root));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lan_root));
			if (ndr_get_array_length(ndr, &r->lan_root) > ndr_get_array_size(ndr, &r->lan_root)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->lan_root), ndr_get_array_length(ndr, &r->lan_root));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->lan_root), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lan_root, ndr_get_array_length(ndr, &r->lan_root), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lan_root_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo102(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo102 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo102");
	ndr->depth++;
	ndr_print_srvsvc_PlatformId(ndr, "platform_id", r->platform_id);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version_major", r->version_major);
	ndr_print_uint32(ndr, "version_minor", r->version_minor);
	ndr_print_ptr(ndr, "lan_root", r->lan_root);
	ndr->depth++;
	if (r->lan_root) {
		ndr_print_string(ndr, "lan_root", r->lan_root);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "logged_on_users", r->logged_on_users);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo502(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->char_wait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->collection_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_collection_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->keep_connection));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_commands));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size_char_buf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_threads));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lock_quota));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lock_increment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lock_maximum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pipe_increment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pipe_maximum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cache_file_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dormant_file_limit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->read_ahead_throughput));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_mailslot_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_srv_announce_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_illegal_dgram_events));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dgram_event_reset_freq));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->log_election_packets));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_opportunistic_locking));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_unlock_behind));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_close_behind));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buf_named_pipes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_lock_read_unlock));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->utilize_nt_caching));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_raw_read));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_raw_write));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_write_raw_data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_encryption));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buf_files_deny_write));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buf_read_only_files));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->force_core_create_mode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->use_512_byte_max_transfer));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo502(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->char_wait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->collection_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_collection_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->keep_connection));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_commands));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size_char_buf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_threads));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lock_quota));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lock_increment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lock_maximum));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pipe_increment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pipe_maximum));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cache_file_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dormant_file_limit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->read_ahead_throughput));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_mailslot_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_srv_announce_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_illegal_dgram_events));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dgram_event_reset_freq));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->log_election_packets));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_opportunistic_locking));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_unlock_behind));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_close_behind));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buf_named_pipes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_lock_read_unlock));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->utilize_nt_caching));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_raw_read));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_raw_write));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_write_raw_data));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_encryption));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buf_files_deny_write));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buf_read_only_files));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->force_core_create_mode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->use_512_byte_max_transfer));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo502(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo502 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo502");
	ndr->depth++;
	ndr_print_uint32(ndr, "char_wait", r->char_wait);
	ndr_print_uint32(ndr, "collection_time", r->collection_time);
	ndr_print_uint32(ndr, "maximum_collection_count", r->maximum_collection_count);
	ndr_print_uint32(ndr, "keep_connection", r->keep_connection);
	ndr_print_uint32(ndr, "max_commands", r->max_commands);
	ndr_print_uint32(ndr, "session_timeout", r->session_timeout);
	ndr_print_uint32(ndr, "size_char_buf", r->size_char_buf);
	ndr_print_uint32(ndr, "max_threads", r->max_threads);
	ndr_print_uint32(ndr, "lock_quota", r->lock_quota);
	ndr_print_uint32(ndr, "lock_increment", r->lock_increment);
	ndr_print_uint32(ndr, "lock_maximum", r->lock_maximum);
	ndr_print_uint32(ndr, "pipe_increment", r->pipe_increment);
	ndr_print_uint32(ndr, "pipe_maximum", r->pipe_maximum);
	ndr_print_uint32(ndr, "cache_file_timeout", r->cache_file_timeout);
	ndr_print_uint32(ndr, "dormant_file_limit", r->dormant_file_limit);
	ndr_print_uint32(ndr, "read_ahead_throughput", r->read_ahead_throughput);
	ndr_print_uint32(ndr, "num_mailslot_buffers", r->num_mailslot_buffers);
	ndr_print_uint32(ndr, "num_srv_announce_buffers", r->num_srv_announce_buffers);
	ndr_print_uint32(ndr, "max_illegal_dgram_events", r->max_illegal_dgram_events);
	ndr_print_uint32(ndr, "dgram_event_reset_freq", r->dgram_event_reset_freq);
	ndr_print_uint32(ndr, "log_election_packets", r->log_election_packets);
	ndr_print_uint32(ndr, "use_opportunistic_locking", r->use_opportunistic_locking);
	ndr_print_uint32(ndr, "use_unlock_behind", r->use_unlock_behind);
	ndr_print_uint32(ndr, "use_close_behind", r->use_close_behind);
	ndr_print_uint32(ndr, "buf_named_pipes", r->buf_named_pipes);
	ndr_print_uint32(ndr, "use_lock_read_unlock", r->use_lock_read_unlock);
	ndr_print_uint32(ndr, "utilize_nt_caching", r->utilize_nt_caching);
	ndr_print_uint32(ndr, "use_raw_read", r->use_raw_read);
	ndr_print_uint32(ndr, "use_raw_write", r->use_raw_write);
	ndr_print_uint32(ndr, "use_write_raw_data", r->use_write_raw_data);
	ndr_print_uint32(ndr, "use_encryption", r->use_encryption);
	ndr_print_uint32(ndr, "buf_files_deny_write", r->buf_files_deny_write);
	ndr_print_uint32(ndr, "buf_read_only_files", r->buf_read_only_files);
	ndr_print_uint32(ndr, "force_core_create_mode", r->force_core_create_mode);
	ndr_print_uint32(ndr, "use_512_byte_max_transfer", r->use_512_byte_max_transfer);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1010(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->char_wait));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1010(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->char_wait));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1010(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1010 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1010");
	ndr->depth++;
	ndr_print_uint32(ndr, "char_wait", r->char_wait);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1011(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->collection_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1011(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->collection_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1011(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1011 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1011");
	ndr->depth++;
	ndr_print_uint32(ndr, "collection_time", r->collection_time);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1012(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_collection_count));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1012(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_collection_count));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1012(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1012 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1012");
	ndr->depth++;
	ndr_print_uint32(ndr, "maximum_collection_count", r->maximum_collection_count);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1013(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->keep_connection));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1013(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->keep_connection));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1013(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1013 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1013");
	ndr->depth++;
	ndr_print_uint32(ndr, "keep_connection", r->keep_connection);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1018(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1018(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1018(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1018 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1018");
	ndr->depth++;
	ndr_print_uint32(ndr, "session_timeout", r->session_timeout);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1023(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size_char_buf));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1023(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size_char_buf));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1023(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1023 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1023");
	ndr->depth++;
	ndr_print_uint32(ndr, "size_char_buf", r->size_char_buf);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1027(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1027 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->errorlog_sz));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1027(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1027 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->errorlog_sz));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1027(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1027 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1027");
	ndr->depth++;
	ndr_print_uint32(ndr, "errorlog_sz", r->errorlog_sz);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo1033(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaInfo1033 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_threads));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo1033(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaInfo1033 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_threads));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo1033(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaInfo1033 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaInfo1033");
	ndr->depth++;
	ndr_print_uint32(ndr, "max_threads", r->max_threads);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaInfo(struct ndr_push *ndr, int ndr_flags, const union wkssvc_NetWkstaInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 100:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info100));
			break;

			case 101:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info101));
			break;

			case 102:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info102));
			break;

			case 502:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info502));
			break;

			case 1010:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1010));
			break;

			case 1011:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1011));
			break;

			case 1012:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1012));
			break;

			case 1013:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1013));
			break;

			case 1018:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1018));
			break;

			case 1023:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1023));
			break;

			case 1027:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1027));
			break;

			case 1033:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1033));
			break;

			default:
			break;

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 100:
				if (r->info100) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
				}
			break;

			case 101:
				if (r->info101) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo101(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
				}
			break;

			case 102:
				if (r->info102) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo102(ndr, NDR_SCALARS|NDR_BUFFERS, r->info102));
				}
			break;

			case 502:
				if (r->info502) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo502(ndr, NDR_SCALARS, r->info502));
				}
			break;

			case 1010:
				if (r->info1010) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1010(ndr, NDR_SCALARS, r->info1010));
				}
			break;

			case 1011:
				if (r->info1011) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1011(ndr, NDR_SCALARS, r->info1011));
				}
			break;

			case 1012:
				if (r->info1012) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1012(ndr, NDR_SCALARS, r->info1012));
				}
			break;

			case 1013:
				if (r->info1013) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1013(ndr, NDR_SCALARS, r->info1013));
				}
			break;

			case 1018:
				if (r->info1018) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1018(ndr, NDR_SCALARS, r->info1018));
				}
			break;

			case 1023:
				if (r->info1023) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1023(ndr, NDR_SCALARS, r->info1023));
				}
			break;

			case 1027:
				if (r->info1027) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1027(ndr, NDR_SCALARS, r->info1027));
				}
			break;

			case 1033:
				if (r->info1033) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo1033(ndr, NDR_SCALARS, r->info1033));
				}
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaInfo(struct ndr_pull *ndr, int ndr_flags, union wkssvc_NetWkstaInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info100_0;
	TALLOC_CTX *_mem_save_info101_0;
	TALLOC_CTX *_mem_save_info102_0;
	TALLOC_CTX *_mem_save_info502_0;
	TALLOC_CTX *_mem_save_info1010_0;
	TALLOC_CTX *_mem_save_info1011_0;
	TALLOC_CTX *_mem_save_info1012_0;
	TALLOC_CTX *_mem_save_info1013_0;
	TALLOC_CTX *_mem_save_info1018_0;
	TALLOC_CTX *_mem_save_info1023_0;
	TALLOC_CTX *_mem_save_info1027_0;
	TALLOC_CTX *_mem_save_info1033_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for wkssvc_NetWkstaInfo", _level);
		}
		switch (level) {
			case 100: {
				uint32_t _ptr_info100;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info100));
				if (_ptr_info100) {
					NDR_PULL_ALLOC(ndr, r->info100);
				} else {
					r->info100 = NULL;
				}
			break; }

			case 101: {
				uint32_t _ptr_info101;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info101));
				if (_ptr_info101) {
					NDR_PULL_ALLOC(ndr, r->info101);
				} else {
					r->info101 = NULL;
				}
			break; }

			case 102: {
				uint32_t _ptr_info102;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info102));
				if (_ptr_info102) {
					NDR_PULL_ALLOC(ndr, r->info102);
				} else {
					r->info102 = NULL;
				}
			break; }

			case 502: {
				uint32_t _ptr_info502;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info502));
				if (_ptr_info502) {
					NDR_PULL_ALLOC(ndr, r->info502);
				} else {
					r->info502 = NULL;
				}
			break; }

			case 1010: {
				uint32_t _ptr_info1010;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1010));
				if (_ptr_info1010) {
					NDR_PULL_ALLOC(ndr, r->info1010);
				} else {
					r->info1010 = NULL;
				}
			break; }

			case 1011: {
				uint32_t _ptr_info1011;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1011));
				if (_ptr_info1011) {
					NDR_PULL_ALLOC(ndr, r->info1011);
				} else {
					r->info1011 = NULL;
				}
			break; }

			case 1012: {
				uint32_t _ptr_info1012;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1012));
				if (_ptr_info1012) {
					NDR_PULL_ALLOC(ndr, r->info1012);
				} else {
					r->info1012 = NULL;
				}
			break; }

			case 1013: {
				uint32_t _ptr_info1013;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1013));
				if (_ptr_info1013) {
					NDR_PULL_ALLOC(ndr, r->info1013);
				} else {
					r->info1013 = NULL;
				}
			break; }

			case 1018: {
				uint32_t _ptr_info1018;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1018));
				if (_ptr_info1018) {
					NDR_PULL_ALLOC(ndr, r->info1018);
				} else {
					r->info1018 = NULL;
				}
			break; }

			case 1023: {
				uint32_t _ptr_info1023;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1023));
				if (_ptr_info1023) {
					NDR_PULL_ALLOC(ndr, r->info1023);
				} else {
					r->info1023 = NULL;
				}
			break; }

			case 1027: {
				uint32_t _ptr_info1027;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1027));
				if (_ptr_info1027) {
					NDR_PULL_ALLOC(ndr, r->info1027);
				} else {
					r->info1027 = NULL;
				}
			break; }

			case 1033: {
				uint32_t _ptr_info1033;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1033));
				if (_ptr_info1033) {
					NDR_PULL_ALLOC(ndr, r->info1033);
				} else {
					r->info1033 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 100:
				if (r->info100) {
					_mem_save_info100_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info100, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info100_0, 0);
				}
			break;

			case 101:
				if (r->info101) {
					_mem_save_info101_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info101, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo101(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info101_0, 0);
				}
			break;

			case 102:
				if (r->info102) {
					_mem_save_info102_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info102, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo102(ndr, NDR_SCALARS|NDR_BUFFERS, r->info102));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info102_0, 0);
				}
			break;

			case 502:
				if (r->info502) {
					_mem_save_info502_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info502, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo502(ndr, NDR_SCALARS, r->info502));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info502_0, 0);
				}
			break;

			case 1010:
				if (r->info1010) {
					_mem_save_info1010_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1010, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1010(ndr, NDR_SCALARS, r->info1010));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1010_0, 0);
				}
			break;

			case 1011:
				if (r->info1011) {
					_mem_save_info1011_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1011, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1011(ndr, NDR_SCALARS, r->info1011));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1011_0, 0);
				}
			break;

			case 1012:
				if (r->info1012) {
					_mem_save_info1012_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1012, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1012(ndr, NDR_SCALARS, r->info1012));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1012_0, 0);
				}
			break;

			case 1013:
				if (r->info1013) {
					_mem_save_info1013_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1013, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1013(ndr, NDR_SCALARS, r->info1013));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1013_0, 0);
				}
			break;

			case 1018:
				if (r->info1018) {
					_mem_save_info1018_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1018, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1018(ndr, NDR_SCALARS, r->info1018));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1018_0, 0);
				}
			break;

			case 1023:
				if (r->info1023) {
					_mem_save_info1023_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1023, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1023(ndr, NDR_SCALARS, r->info1023));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1023_0, 0);
				}
			break;

			case 1027:
				if (r->info1027) {
					_mem_save_info1027_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1027, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1027(ndr, NDR_SCALARS, r->info1027));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1027_0, 0);
				}
			break;

			case 1033:
				if (r->info1033) {
					_mem_save_info1033_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1033, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo1033(ndr, NDR_SCALARS, r->info1033));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1033_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaInfo(struct ndr_print *ndr, const char *name, const union wkssvc_NetWkstaInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "wkssvc_NetWkstaInfo");
	switch (level) {
		case 100:
			ndr_print_ptr(ndr, "info100", r->info100);
			ndr->depth++;
			if (r->info100) {
				ndr_print_wkssvc_NetWkstaInfo100(ndr, "info100", r->info100);
			}
			ndr->depth--;
		break;

		case 101:
			ndr_print_ptr(ndr, "info101", r->info101);
			ndr->depth++;
			if (r->info101) {
				ndr_print_wkssvc_NetWkstaInfo101(ndr, "info101", r->info101);
			}
			ndr->depth--;
		break;

		case 102:
			ndr_print_ptr(ndr, "info102", r->info102);
			ndr->depth++;
			if (r->info102) {
				ndr_print_wkssvc_NetWkstaInfo102(ndr, "info102", r->info102);
			}
			ndr->depth--;
		break;

		case 502:
			ndr_print_ptr(ndr, "info502", r->info502);
			ndr->depth++;
			if (r->info502) {
				ndr_print_wkssvc_NetWkstaInfo502(ndr, "info502", r->info502);
			}
			ndr->depth--;
		break;

		case 1010:
			ndr_print_ptr(ndr, "info1010", r->info1010);
			ndr->depth++;
			if (r->info1010) {
				ndr_print_wkssvc_NetWkstaInfo1010(ndr, "info1010", r->info1010);
			}
			ndr->depth--;
		break;

		case 1011:
			ndr_print_ptr(ndr, "info1011", r->info1011);
			ndr->depth++;
			if (r->info1011) {
				ndr_print_wkssvc_NetWkstaInfo1011(ndr, "info1011", r->info1011);
			}
			ndr->depth--;
		break;

		case 1012:
			ndr_print_ptr(ndr, "info1012", r->info1012);
			ndr->depth++;
			if (r->info1012) {
				ndr_print_wkssvc_NetWkstaInfo1012(ndr, "info1012", r->info1012);
			}
			ndr->depth--;
		break;

		case 1013:
			ndr_print_ptr(ndr, "info1013", r->info1013);
			ndr->depth++;
			if (r->info1013) {
				ndr_print_wkssvc_NetWkstaInfo1013(ndr, "info1013", r->info1013);
			}
			ndr->depth--;
		break;

		case 1018:
			ndr_print_ptr(ndr, "info1018", r->info1018);
			ndr->depth++;
			if (r->info1018) {
				ndr_print_wkssvc_NetWkstaInfo1018(ndr, "info1018", r->info1018);
			}
			ndr->depth--;
		break;

		case 1023:
			ndr_print_ptr(ndr, "info1023", r->info1023);
			ndr->depth++;
			if (r->info1023) {
				ndr_print_wkssvc_NetWkstaInfo1023(ndr, "info1023", r->info1023);
			}
			ndr->depth--;
		break;

		case 1027:
			ndr_print_ptr(ndr, "info1027", r->info1027);
			ndr->depth++;
			if (r->info1027) {
				ndr_print_wkssvc_NetWkstaInfo1027(ndr, "info1027", r->info1027);
			}
			ndr->depth--;
		break;

		case 1033:
			ndr_print_ptr(ndr, "info1033", r->info1033);
			ndr->depth++;
			if (r->info1033) {
				ndr_print_wkssvc_NetWkstaInfo1033(ndr, "info1033", r->info1033);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static NTSTATUS ndr_push_USER_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_USER_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_0 *r)
{
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_USER_INFO_0(struct ndr_print *ndr, const char *name, const struct USER_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_0");
	ndr->depth++;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_USER_INFO_0_CONTAINER(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_0_CONTAINER *r)
{
	uint32_t cntr_user0_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user0));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user0) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
			for (cntr_user0_1 = 0; cntr_user0_1 < r->entries_read; cntr_user0_1++) {
				NDR_CHECK(ndr_push_USER_INFO_0(ndr, NDR_SCALARS, &r->user0[cntr_user0_1]));
			}
			for (cntr_user0_1 = 0; cntr_user0_1 < r->entries_read; cntr_user0_1++) {
				NDR_CHECK(ndr_push_USER_INFO_0(ndr, NDR_BUFFERS, &r->user0[cntr_user0_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_USER_INFO_0_CONTAINER(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_0_CONTAINER *r)
{
	uint32_t _ptr_user0;
	uint32_t cntr_user0_1;
	TALLOC_CTX *_mem_save_user0_0;
	TALLOC_CTX *_mem_save_user0_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entries_read));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user0));
		if (_ptr_user0) {
			NDR_PULL_ALLOC(ndr, r->user0);
		} else {
			r->user0 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user0) {
			_mem_save_user0_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user0, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user0));
			NDR_PULL_ALLOC_N(ndr, r->user0, ndr_get_array_size(ndr, &r->user0));
			_mem_save_user0_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user0, 0);
			for (cntr_user0_1 = 0; cntr_user0_1 < r->entries_read; cntr_user0_1++) {
				NDR_CHECK(ndr_pull_USER_INFO_0(ndr, NDR_SCALARS, &r->user0[cntr_user0_1]));
			}
			for (cntr_user0_1 = 0; cntr_user0_1 < r->entries_read; cntr_user0_1++) {
				NDR_CHECK(ndr_pull_USER_INFO_0(ndr, NDR_BUFFERS, &r->user0[cntr_user0_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user0_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user0_0, 0);
		}
		if (r->user0) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->user0, r->entries_read));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_USER_INFO_0_CONTAINER(struct ndr_print *ndr, const char *name, const struct USER_INFO_0_CONTAINER *r)
{
	uint32_t cntr_user0_1;
	ndr_print_struct(ndr, name, "USER_INFO_0_CONTAINER");
	ndr->depth++;
	ndr_print_uint32(ndr, "entries_read", r->entries_read);
	ndr_print_ptr(ndr, "user0", r->user0);
	ndr->depth++;
	if (r->user0) {
		ndr->print(ndr, "%s: ARRAY(%d)", "user0", r->entries_read);
		ndr->depth++;
		for (cntr_user0_1=0;cntr_user0_1<r->entries_read;cntr_user0_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_user0_1);
			if (idx_1) {
				ndr_print_USER_INFO_0(ndr, "user0", &r->user0[cntr_user0_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_USER_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->logon_domain));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->other_domains));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->logon_server));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user_name, ndr_charset_length(r->user_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->logon_domain) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->logon_domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->logon_domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->logon_domain, ndr_charset_length(r->logon_domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->other_domains) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->other_domains, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->other_domains, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->other_domains, ndr_charset_length(r->other_domains, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->logon_server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->logon_server, ndr_charset_length(r->logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_USER_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1 *r)
{
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_logon_domain;
	TALLOC_CTX *_mem_save_logon_domain_0;
	uint32_t _ptr_other_domains;
	TALLOC_CTX *_mem_save_other_domains_0;
	uint32_t _ptr_logon_server;
	TALLOC_CTX *_mem_save_logon_server_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
		if (_ptr_user_name) {
			NDR_PULL_ALLOC(ndr, r->user_name);
		} else {
			r->user_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_domain));
		if (_ptr_logon_domain) {
			NDR_PULL_ALLOC(ndr, r->logon_domain);
		} else {
			r->logon_domain = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_other_domains));
		if (_ptr_other_domains) {
			NDR_PULL_ALLOC(ndr, r->other_domains);
		} else {
			r->other_domains = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->logon_server);
		} else {
			r->logon_server = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user_name) {
			_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user_name));
			if (ndr_get_array_length(ndr, &r->user_name) > ndr_get_array_size(ndr, &r->user_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user_name), ndr_get_array_length(ndr, &r->user_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user_name, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
		}
		if (r->logon_domain) {
			_mem_save_logon_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->logon_domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->logon_domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->logon_domain));
			if (ndr_get_array_length(ndr, &r->logon_domain) > ndr_get_array_size(ndr, &r->logon_domain)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->logon_domain), ndr_get_array_length(ndr, &r->logon_domain));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->logon_domain), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->logon_domain, ndr_get_array_length(ndr, &r->logon_domain), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_domain_0, 0);
		}
		if (r->other_domains) {
			_mem_save_other_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->other_domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->other_domains));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->other_domains));
			if (ndr_get_array_length(ndr, &r->other_domains) > ndr_get_array_size(ndr, &r->other_domains)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->other_domains), ndr_get_array_length(ndr, &r->other_domains));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->other_domains), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->other_domains, ndr_get_array_length(ndr, &r->other_domains), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_other_domains_0, 0);
		}
		if (r->logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->logon_server));
			if (ndr_get_array_length(ndr, &r->logon_server) > ndr_get_array_size(ndr, &r->logon_server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->logon_server), ndr_get_array_length(ndr, &r->logon_server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->logon_server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->logon_server, ndr_get_array_length(ndr, &r->logon_server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_USER_INFO_1(struct ndr_print *ndr, const char *name, const struct USER_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1");
	ndr->depth++;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "logon_domain", r->logon_domain);
	ndr->depth++;
	if (r->logon_domain) {
		ndr_print_string(ndr, "logon_domain", r->logon_domain);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "other_domains", r->other_domains);
	ndr->depth++;
	if (r->other_domains) {
		ndr_print_string(ndr, "other_domains", r->other_domains);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "logon_server", r->logon_server);
	ndr->depth++;
	if (r->logon_server) {
		ndr_print_string(ndr, "logon_server", r->logon_server);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_USER_INFO_1_CONTAINER(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1_CONTAINER *r)
{
	uint32_t cntr_user1_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user1) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
			for (cntr_user1_1 = 0; cntr_user1_1 < r->entries_read; cntr_user1_1++) {
				NDR_CHECK(ndr_push_USER_INFO_1(ndr, NDR_SCALARS, &r->user1[cntr_user1_1]));
			}
			for (cntr_user1_1 = 0; cntr_user1_1 < r->entries_read; cntr_user1_1++) {
				NDR_CHECK(ndr_push_USER_INFO_1(ndr, NDR_BUFFERS, &r->user1[cntr_user1_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_USER_INFO_1_CONTAINER(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1_CONTAINER *r)
{
	uint32_t _ptr_user1;
	uint32_t cntr_user1_1;
	TALLOC_CTX *_mem_save_user1_0;
	TALLOC_CTX *_mem_save_user1_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entries_read));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user1));
		if (_ptr_user1) {
			NDR_PULL_ALLOC(ndr, r->user1);
		} else {
			r->user1 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->user1) {
			_mem_save_user1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user1));
			NDR_PULL_ALLOC_N(ndr, r->user1, ndr_get_array_size(ndr, &r->user1));
			_mem_save_user1_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user1, 0);
			for (cntr_user1_1 = 0; cntr_user1_1 < r->entries_read; cntr_user1_1++) {
				NDR_CHECK(ndr_pull_USER_INFO_1(ndr, NDR_SCALARS, &r->user1[cntr_user1_1]));
			}
			for (cntr_user1_1 = 0; cntr_user1_1 < r->entries_read; cntr_user1_1++) {
				NDR_CHECK(ndr_pull_USER_INFO_1(ndr, NDR_BUFFERS, &r->user1[cntr_user1_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user1_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user1_0, 0);
		}
		if (r->user1) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->user1, r->entries_read));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_USER_INFO_1_CONTAINER(struct ndr_print *ndr, const char *name, const struct USER_INFO_1_CONTAINER *r)
{
	uint32_t cntr_user1_1;
	ndr_print_struct(ndr, name, "USER_INFO_1_CONTAINER");
	ndr->depth++;
	ndr_print_uint32(ndr, "entries_read", r->entries_read);
	ndr_print_ptr(ndr, "user1", r->user1);
	ndr->depth++;
	if (r->user1) {
		ndr->print(ndr, "%s: ARRAY(%d)", "user1", r->entries_read);
		ndr->depth++;
		for (cntr_user1_1=0;cntr_user1_1<r->entries_read;cntr_user1_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_user1_1);
			if (idx_1) {
				ndr_print_USER_INFO_1(ndr, "user1", &r->user1[cntr_user1_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_WKS_USER_ENUM_UNION(struct ndr_push *ndr, int ndr_flags, const union WKS_USER_ENUM_UNION *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->user0));
			break;

			case 1:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->user1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->user0) {
					NDR_CHECK(ndr_push_USER_INFO_0_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user0));
				}
			break;

			case 1:
				if (r->user1) {
					NDR_CHECK(ndr_push_USER_INFO_1_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user1));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKS_USER_ENUM_UNION(struct ndr_pull *ndr, int ndr_flags, union WKS_USER_ENUM_UNION *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_user0_0;
	TALLOC_CTX *_mem_save_user1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for WKS_USER_ENUM_UNION", _level);
		}
		switch (level) {
			case 0: {
				uint32_t _ptr_user0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user0));
				if (_ptr_user0) {
					NDR_PULL_ALLOC(ndr, r->user0);
				} else {
					r->user0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_user1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user1));
				if (_ptr_user1) {
					NDR_PULL_ALLOC(ndr, r->user1);
				} else {
					r->user1 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->user0) {
					_mem_save_user0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->user0, 0);
					NDR_CHECK(ndr_pull_USER_INFO_0_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user0_0, 0);
				}
			break;

			case 1:
				if (r->user1) {
					_mem_save_user1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->user1, 0);
					NDR_CHECK(ndr_pull_USER_INFO_1_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user1_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKS_USER_ENUM_UNION(struct ndr_print *ndr, const char *name, const union WKS_USER_ENUM_UNION *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "WKS_USER_ENUM_UNION");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "user0", r->user0);
			ndr->depth++;
			if (r->user0) {
				ndr_print_USER_INFO_0_CONTAINER(ndr, "user0", r->user0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "user1", r->user1);
			ndr->depth++;
			if (r->user1) {
				ndr_print_USER_INFO_1_CONTAINER(ndr, "user1", r->user1);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_wkssvc_NetWkstaTransportInfo0(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaTransportInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->quality_of_service));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->vc_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->address));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->wan_link));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->address) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->address, ndr_charset_length(r->address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaTransportInfo0(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaTransportInfo0 *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_address;
	TALLOC_CTX *_mem_save_address_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->quality_of_service));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->vc_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_address));
		if (_ptr_address) {
			NDR_PULL_ALLOC(ndr, r->address);
		} else {
			r->address = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->wan_link));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->address) {
			_mem_save_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->address));
			if (ndr_get_array_length(ndr, &r->address) > ndr_get_array_size(ndr, &r->address)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->address), ndr_get_array_length(ndr, &r->address));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->address), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->address, ndr_get_array_length(ndr, &r->address), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_address_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaTransportInfo0(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaTransportInfo0 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaTransportInfo0");
	ndr->depth++;
	ndr_print_uint32(ndr, "quality_of_service", r->quality_of_service);
	ndr_print_uint32(ndr, "vc_count", r->vc_count);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "address", r->address);
	ndr->depth++;
	if (r->address) {
		ndr_print_string(ndr, "address", r->address);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "wan_link", r->wan_link);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaTransportCtr0(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_NetWkstaTransportCtr0 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_wkssvc_NetWkstaTransportInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_wkssvc_NetWkstaTransportInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaTransportCtr0(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_NetWkstaTransportCtr0 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_wkssvc_NetWkstaTransportInfo0(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_wkssvc_NetWkstaTransportInfo0(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaTransportCtr0(struct ndr_print *ndr, const char *name, const struct wkssvc_NetWkstaTransportCtr0 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaTransportCtr0");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_array_1);
			if (idx_1) {
				ndr_print_wkssvc_NetWkstaTransportInfo0(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaTransportCtr(struct ndr_push *ndr, int ndr_flags, const union wkssvc_NetWkstaTransportCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr0));
			break;

			default:
			break;

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					NDR_CHECK(ndr_push_wkssvc_NetWkstaTransportCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
				}
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaTransportCtr(struct ndr_pull *ndr, int ndr_flags, union wkssvc_NetWkstaTransportCtr *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr0_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for wkssvc_NetWkstaTransportCtr", _level);
		}
		switch (level) {
			case 0: {
				uint32_t _ptr_ctr0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr0));
				if (_ptr_ctr0) {
					NDR_PULL_ALLOC(ndr, r->ctr0);
				} else {
					r->ctr0 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->ctr0) {
					_mem_save_ctr0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr0, 0);
					NDR_CHECK(ndr_pull_wkssvc_NetWkstaTransportCtr0(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr0_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaTransportCtr(struct ndr_print *ndr, const char *name, const union wkssvc_NetWkstaTransportCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "wkssvc_NetWkstaTransportCtr");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "ctr0", r->ctr0);
			ndr->depth++;
			if (r->ctr0) {
				ndr_print_wkssvc_NetWkstaTransportCtr0(ndr, "ctr0", r->ctr0);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static NTSTATUS ndr_push_wkssvc_PasswordBuffer(struct ndr_push *ndr, int ndr_flags, const struct wkssvc_PasswordBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 524));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_PasswordBuffer(struct ndr_pull *ndr, int ndr_flags, struct wkssvc_PasswordBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, 524));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_PasswordBuffer(struct ndr_print *ndr, const char *name, const struct wkssvc_PasswordBuffer *r)
{
	ndr_print_struct(ndr, name, "wkssvc_PasswordBuffer");
	ndr->depth++;
	ndr_print_array_uint8(ndr, "data", r->data, 524);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_joinflags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_joinflags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_joinflags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_DEFER_SPN", WKSSVC_JOIN_FLAGS_DEFER_SPN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_MACHINE_PWD_PASSED", WKSSVC_JOIN_FLAGS_MACHINE_PWD_PASSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_JOIN_UNSECURE", WKSSVC_JOIN_FLAGS_JOIN_UNSECURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_DOMAIN_JOIN_IF_JOINED", WKSSVC_JOIN_FLAGS_DOMAIN_JOIN_IF_JOINED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_WIN9X_UPGRADE", WKSSVC_JOIN_FLAGS_WIN9X_UPGRADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_ACCOUNT_DELETE", WKSSVC_JOIN_FLAGS_ACCOUNT_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_ACCOUNT_CREATE", WKSSVC_JOIN_FLAGS_ACCOUNT_CREATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_JOIN_TYPE", WKSSVC_JOIN_FLAGS_JOIN_TYPE, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_renameflags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_renameflags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_renameflags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WKSSVC_JOIN_FLAGS_ACCOUNT_CREATE", WKSSVC_JOIN_FLAGS_ACCOUNT_CREATE, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaGetInfo(struct ndr_push *ndr, int flags, const struct wkssvc_NetWkstaGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaGetInfo(struct ndr_pull *ndr, int flags, struct wkssvc_NetWkstaGetInfo *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetWkstaGetInfo *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetWkstaGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetWkstaGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_wkssvc_NetWkstaInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaSetInfo(struct ndr_push *ndr, int flags, const struct wkssvc_NetWkstaSetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_wkssvc_NetWkstaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		if (r->in.parm_error == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.parm_error));
	}
	if (flags & NDR_OUT) {
		if (r->out.parm_error == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.parm_error));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaSetInfo(struct ndr_pull *ndr, int flags, struct wkssvc_NetWkstaSetInfo *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_parm_error_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_wkssvc_NetWkstaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.parm_error);
		}
		_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.parm_error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.parm_error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.parm_error);
		*r->out.parm_error = *r->in.parm_error;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.parm_error);
		}
		_mem_save_parm_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.parm_error, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.parm_error));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parm_error_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetWkstaSetInfo *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetWkstaSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_wkssvc_NetWkstaInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "parm_error", r->in.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->in.parm_error);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetWkstaSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaEnumUsers(struct ndr_push *ndr, int flags, const struct wkssvc_NetWkstaEnumUsers *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.users == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_WKS_USER_ENUM_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.prefmaxlen));
		if (r->in.resumehandle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resumehandle));
	}
	if (flags & NDR_OUT) {
		if (r->out.users == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_WKS_USER_ENUM_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.users));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.entriesread));
		if (r->out.entriesread) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.entriesread));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.totalentries));
		if (r->out.totalentries) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.totalentries));
		}
		if (r->out.resumehandle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resumehandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaEnumUsers(struct ndr_pull *ndr, int flags, struct wkssvc_NetWkstaEnumUsers *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_entriesread;
	uint32_t _ptr_totalentries;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_users_0;
	TALLOC_CTX *_mem_save_entriesread_0;
	TALLOC_CTX *_mem_save_totalentries_0;
	TALLOC_CTX *_mem_save_resumehandle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.users);
		}
		_mem_save_users_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.users, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WKS_USER_ENUM_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.users));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_users_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.prefmaxlen));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resumehandle);
		}
		_mem_save_resumehandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resumehandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resumehandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resumehandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.users);
		*r->out.users = *r->in.users;
		NDR_PULL_ALLOC(ndr, r->out.resumehandle);
		*r->out.resumehandle = *r->in.resumehandle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.users);
		}
		_mem_save_users_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.users, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WKS_USER_ENUM_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.users));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_users_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entriesread));
		if (_ptr_entriesread) {
			NDR_PULL_ALLOC(ndr, r->out.entriesread);
		} else {
			r->out.entriesread = NULL;
		}
		if (r->out.entriesread) {
			_mem_save_entriesread_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.entriesread, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.entriesread));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entriesread_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_totalentries));
		if (_ptr_totalentries) {
			NDR_PULL_ALLOC(ndr, r->out.totalentries);
		} else {
			r->out.totalentries = NULL;
		}
		if (r->out.totalentries) {
			_mem_save_totalentries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.totalentries, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.totalentries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_totalentries_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resumehandle);
		}
		_mem_save_resumehandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resumehandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resumehandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resumehandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaEnumUsers(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetWkstaEnumUsers *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaEnumUsers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetWkstaEnumUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "users", r->in.users);
		ndr->depth++;
		ndr_print_WKS_USER_ENUM_UNION(ndr, "users", r->in.users);
		ndr->depth--;
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resumehandle", r->in.resumehandle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resumehandle", *r->in.resumehandle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetWkstaEnumUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "users", r->out.users);
		ndr->depth++;
		ndr_print_WKS_USER_ENUM_UNION(ndr, "users", r->out.users);
		ndr->depth--;
		ndr_print_ptr(ndr, "entriesread", r->out.entriesread);
		ndr->depth++;
		if (r->out.entriesread) {
			ndr_print_uint32(ndr, "entriesread", *r->out.entriesread);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "totalentries", r->out.totalentries);
		ndr->depth++;
		if (r->out.totalentries) {
			ndr_print_uint32(ndr, "totalentries", *r->out.totalentries);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "resumehandle", r->out.resumehandle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resumehandle", *r->out.resumehandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRWKSTAUSERGETINFO(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRWKSTAUSERGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRWKSTAUSERGETINFO(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRWKSTAUSERGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRWKSTAUSERGETINFO(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRWKSTAUSERGETINFO *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRWKSTAUSERGETINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRWKSTAUSERGETINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRWKSTAUSERGETINFO");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRWKSTAUSERSETINFO(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRWKSTAUSERSETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRWKSTAUSERSETINFO(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRWKSTAUSERSETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRWKSTAUSERSETINFO(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRWKSTAUSERSETINFO *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRWKSTAUSERSETINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRWKSTAUSERSETINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRWKSTAUSERSETINFO");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetWkstaTransportEnum(struct ndr_push *ndr, int flags, const struct wkssvc_NetWkstaTransportEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.ctr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.ctr, r->in.level));
		NDR_CHECK(ndr_push_wkssvc_NetWkstaTransportCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_buffer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.level));
		if (r->out.ctr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, r->out.level));
		NDR_CHECK(ndr_push_wkssvc_NetWkstaTransportCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.totalentries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetWkstaTransportEnum(struct ndr_pull *ndr, int flags, struct wkssvc_NetWkstaTransportEnum *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_ctr_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.ctr, r->in.level));
		NDR_CHECK(ndr_pull_wkssvc_NetWkstaTransportCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_buffer));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		*r->out.ctr = *r->in.ctr;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, r->out.level));
		NDR_CHECK(ndr_pull_wkssvc_NetWkstaTransportCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.totalentries));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetWkstaTransportEnum(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetWkstaTransportEnum *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetWkstaTransportEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetWkstaTransportEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "ctr", r->in.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.ctr, r->in.level);
		ndr_print_wkssvc_NetWkstaTransportCtr(ndr, "ctr", r->in.ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_buffer", r->in.max_buffer);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetWkstaTransportEnum");
		ndr->depth++;
		ndr_print_uint32(ndr, "level", r->out.level);
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, r->out.level);
		ndr_print_wkssvc_NetWkstaTransportCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_uint32(ndr, "totalentries", r->out.totalentries);
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRWKSTATRANSPORTADD(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRWKSTATRANSPORTADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRWKSTATRANSPORTADD(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRWKSTATRANSPORTADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRWKSTATRANSPORTADD(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRWKSTATRANSPORTADD *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRWKSTATRANSPORTADD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRWKSTATRANSPORTADD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRWKSTATRANSPORTADD");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRWKSTATRANSPORTDEL(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRWKSTATRANSPORTDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRWKSTATRANSPORTDEL(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRWKSTATRANSPORTDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRWKSTATRANSPORTDEL(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRWKSTATRANSPORTDEL *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRWKSTATRANSPORTDEL");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRWKSTATRANSPORTDEL");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRWKSTATRANSPORTDEL");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRUSEADD(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRUSEADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRUSEADD(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRUSEADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRUSEADD(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRUSEADD *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRUSEADD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRUSEADD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRUSEADD");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRUSEGETINFO(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRUSEGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRUSEGETINFO(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRUSEGETINFO *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRUSEGETINFO(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRUSEGETINFO *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRUSEGETINFO");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRUSEGETINFO");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRUSEGETINFO");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRUSEDEL(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRUSEDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRUSEDEL(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRUSEDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRUSEDEL(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRUSEDEL *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRUSEDEL");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRUSEDEL");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRUSEDEL");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRUSEENUM(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRUSEENUM *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRUSEENUM(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRUSEENUM *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRUSEENUM(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRUSEENUM *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRUSEENUM");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRUSEENUM");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRUSEENUM");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRMESSAGEBUFFERSEND(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRMESSAGEBUFFERSEND *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRMESSAGEBUFFERSEND(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRMESSAGEBUFFERSEND *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRMESSAGEBUFFERSEND(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRMESSAGEBUFFERSEND *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRMESSAGEBUFFERSEND");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRMESSAGEBUFFERSEND");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRMESSAGEBUFFERSEND");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRWORKSTATIONSTATISTICSGET(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRWORKSTATIONSTATISTICSGET(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRWORKSTATIONSTATISTICSGET(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRWORKSTATIONSTATISTICSGET");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRWORKSTATIONSTATISTICSGET");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRWORKSTATIONSTATISTICSGET");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRLOGONDOMAINNAMEADD(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRLOGONDOMAINNAMEADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRLOGONDOMAINNAMEADD(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRLOGONDOMAINNAMEADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRLOGONDOMAINNAMEADD(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRLOGONDOMAINNAMEADD *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRLOGONDOMAINNAMEADD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRLOGONDOMAINNAMEADD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRLOGONDOMAINNAMEADD");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRLOGONDOMAINNAMEDEL(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRLOGONDOMAINNAMEDEL(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRLOGONDOMAINNAMEDEL(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRLOGONDOMAINNAMEDEL");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRLOGONDOMAINNAMEDEL");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRLOGONDOMAINNAMEDEL");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRJOINDOMAIN(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRJOINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRJOINDOMAIN(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRJOINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRJOINDOMAIN(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRJOINDOMAIN *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRJOINDOMAIN");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRJOINDOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRJOINDOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRUNJOINDOMAIN(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRUNJOINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRUNJOINDOMAIN(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRUNJOINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRUNJOINDOMAIN(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRUNJOINDOMAIN *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRUNJOINDOMAIN");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRUNJOINDOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRUNJOINDOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRRENAMEMACHINEINDOMAIN(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRRENAMEMACHINEINDOMAIN(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRRENAMEMACHINEINDOMAIN(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRRENAMEMACHINEINDOMAIN");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRRENAMEMACHINEINDOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRRENAMEMACHINEINDOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRVALIDATENAME(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRVALIDATENAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRVALIDATENAME(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRVALIDATENAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRVALIDATENAME(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRVALIDATENAME *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRVALIDATENAME");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRVALIDATENAME");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRVALIDATENAME");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRGETJOININFORMATION(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRGETJOININFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRGETJOININFORMATION(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRGETJOININFORMATION *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRGETJOININFORMATION(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRGETJOININFORMATION *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRGETJOININFORMATION");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRGETJOININFORMATION");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRGETJOININFORMATION");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRGETJOINABLEOUS(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRGETJOINABLEOUS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRGETJOINABLEOUS(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRGETJOINABLEOUS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRGETJOINABLEOUS(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRGETJOINABLEOUS *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRGETJOINABLEOUS");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRGETJOINABLEOUS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRGETJOINABLEOUS");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetrJoinDomain2(struct ndr_push *ndr, int flags, const struct wkssvc_NetrJoinDomain2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.domain_name == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.account_name));
		if (r->in.account_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.admin_account));
		if (r->in.admin_account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.admin_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.admin_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.admin_account, ndr_charset_length(r->in.admin_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.encrypted_password));
		if (r->in.encrypted_password) {
			NDR_CHECK(ndr_push_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.encrypted_password));
		}
		NDR_CHECK(ndr_push_wkssvc_joinflags(ndr, NDR_SCALARS, r->in.join_flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetrJoinDomain2(struct ndr_pull *ndr, int flags, struct wkssvc_NetrJoinDomain2 *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_account_name;
	uint32_t _ptr_admin_account;
	uint32_t _ptr_encrypted_password;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_account_name_0;
	TALLOC_CTX *_mem_save_admin_account_0;
	TALLOC_CTX *_mem_save_encrypted_password_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
		if (ndr_get_array_length(ndr, &r->in.domain_name) > ndr_get_array_size(ndr, &r->in.domain_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.domain_name), ndr_get_array_length(ndr, &r->in.domain_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.domain_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, ndr_get_array_length(ndr, &r->in.domain_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
		} else {
			r->in.account_name = NULL;
		}
		if (r->in.account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.account_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
			if (ndr_get_array_length(ndr, &r->in.account_name) > ndr_get_array_size(ndr, &r->in.account_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.account_name), ndr_get_array_length(ndr, &r->in.account_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.account_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, ndr_get_array_length(ndr, &r->in.account_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_admin_account));
		if (_ptr_admin_account) {
			NDR_PULL_ALLOC(ndr, r->in.admin_account);
		} else {
			r->in.admin_account = NULL;
		}
		if (r->in.admin_account) {
			_mem_save_admin_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.admin_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.admin_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.admin_account));
			if (ndr_get_array_length(ndr, &r->in.admin_account) > ndr_get_array_size(ndr, &r->in.admin_account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.admin_account), ndr_get_array_length(ndr, &r->in.admin_account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.admin_account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.admin_account, ndr_get_array_length(ndr, &r->in.admin_account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_admin_account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_encrypted_password));
		if (_ptr_encrypted_password) {
			NDR_PULL_ALLOC(ndr, r->in.encrypted_password);
		} else {
			r->in.encrypted_password = NULL;
		}
		if (r->in.encrypted_password) {
			_mem_save_encrypted_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.encrypted_password, 0);
			NDR_CHECK(ndr_pull_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.encrypted_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_encrypted_password_0, 0);
		}
		NDR_CHECK(ndr_pull_wkssvc_joinflags(ndr, NDR_SCALARS, &r->in.join_flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetrJoinDomain2(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetrJoinDomain2 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetrJoinDomain2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetrJoinDomain2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		if (r->in.account_name) {
			ndr_print_string(ndr, "account_name", r->in.account_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "admin_account", r->in.admin_account);
		ndr->depth++;
		if (r->in.admin_account) {
			ndr_print_string(ndr, "admin_account", r->in.admin_account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "encrypted_password", r->in.encrypted_password);
		ndr->depth++;
		if (r->in.encrypted_password) {
			ndr_print_wkssvc_PasswordBuffer(ndr, "encrypted_password", r->in.encrypted_password);
		}
		ndr->depth--;
		ndr_print_wkssvc_joinflags(ndr, "join_flags", r->in.join_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetrJoinDomain2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetrUnjoinDomain2(struct ndr_push *ndr, int flags, const struct wkssvc_NetrUnjoinDomain2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.account));
		if (r->in.account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account, ndr_charset_length(r->in.account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.encrypted_password));
		if (r->in.encrypted_password) {
			NDR_CHECK(ndr_push_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.encrypted_password));
		}
		NDR_CHECK(ndr_push_wkssvc_joinflags(ndr, NDR_SCALARS, r->in.unjoin_flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetrUnjoinDomain2(struct ndr_pull *ndr, int flags, struct wkssvc_NetrUnjoinDomain2 *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_account;
	uint32_t _ptr_encrypted_password;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_account_0;
	TALLOC_CTX *_mem_save_encrypted_password_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account));
		if (_ptr_account) {
			NDR_PULL_ALLOC(ndr, r->in.account);
		} else {
			r->in.account = NULL;
		}
		if (r->in.account) {
			_mem_save_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account));
			if (ndr_get_array_length(ndr, &r->in.account) > ndr_get_array_size(ndr, &r->in.account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.account), ndr_get_array_length(ndr, &r->in.account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account, ndr_get_array_length(ndr, &r->in.account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_encrypted_password));
		if (_ptr_encrypted_password) {
			NDR_PULL_ALLOC(ndr, r->in.encrypted_password);
		} else {
			r->in.encrypted_password = NULL;
		}
		if (r->in.encrypted_password) {
			_mem_save_encrypted_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.encrypted_password, 0);
			NDR_CHECK(ndr_pull_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.encrypted_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_encrypted_password_0, 0);
		}
		NDR_CHECK(ndr_pull_wkssvc_joinflags(ndr, NDR_SCALARS, &r->in.unjoin_flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetrUnjoinDomain2(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetrUnjoinDomain2 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetrUnjoinDomain2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetrUnjoinDomain2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "encrypted_password", r->in.encrypted_password);
		ndr->depth++;
		if (r->in.encrypted_password) {
			ndr_print_wkssvc_PasswordBuffer(ndr, "encrypted_password", r->in.encrypted_password);
		}
		ndr->depth--;
		ndr_print_wkssvc_joinflags(ndr, "unjoin_flags", r->in.unjoin_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetrUnjoinDomain2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetrRenameMachineInDomain2(struct ndr_push *ndr, int flags, const struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.NewMachineName));
		if (r->in.NewMachineName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.NewMachineName, ndr_charset_length(r->in.NewMachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Account));
		if (r->in.Account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Account, ndr_charset_length(r->in.Account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.EncryptedPassword));
		if (r->in.EncryptedPassword) {
			NDR_CHECK(ndr_push_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
		}
		NDR_CHECK(ndr_push_wkssvc_renameflags(ndr, NDR_SCALARS, r->in.RenameOptions));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetrRenameMachineInDomain2(struct ndr_pull *ndr, int flags, struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_NewMachineName;
	uint32_t _ptr_Account;
	uint32_t _ptr_EncryptedPassword;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_NewMachineName_0;
	TALLOC_CTX *_mem_save_Account_0;
	TALLOC_CTX *_mem_save_EncryptedPassword_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NewMachineName));
		if (_ptr_NewMachineName) {
			NDR_PULL_ALLOC(ndr, r->in.NewMachineName);
		} else {
			r->in.NewMachineName = NULL;
		}
		if (r->in.NewMachineName) {
			_mem_save_NewMachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.NewMachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.NewMachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.NewMachineName));
			if (ndr_get_array_length(ndr, &r->in.NewMachineName) > ndr_get_array_size(ndr, &r->in.NewMachineName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.NewMachineName), ndr_get_array_length(ndr, &r->in.NewMachineName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.NewMachineName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.NewMachineName, ndr_get_array_length(ndr, &r->in.NewMachineName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NewMachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Account));
		if (_ptr_Account) {
			NDR_PULL_ALLOC(ndr, r->in.Account);
		} else {
			r->in.Account = NULL;
		}
		if (r->in.Account) {
			_mem_save_Account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Account));
			if (ndr_get_array_length(ndr, &r->in.Account) > ndr_get_array_size(ndr, &r->in.Account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Account), ndr_get_array_length(ndr, &r->in.Account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Account, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EncryptedPassword));
		if (_ptr_EncryptedPassword) {
			NDR_PULL_ALLOC(ndr, r->in.EncryptedPassword);
		} else {
			r->in.EncryptedPassword = NULL;
		}
		if (r->in.EncryptedPassword) {
			_mem_save_EncryptedPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.EncryptedPassword, 0);
			NDR_CHECK(ndr_pull_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EncryptedPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_wkssvc_renameflags(ndr, NDR_SCALARS, &r->in.RenameOptions));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetrRenameMachineInDomain2(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetrRenameMachineInDomain2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetrRenameMachineInDomain2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "NewMachineName", r->in.NewMachineName);
		ndr->depth++;
		if (r->in.NewMachineName) {
			ndr_print_string(ndr, "NewMachineName", r->in.NewMachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "Account", r->in.Account);
		ndr->depth++;
		if (r->in.Account) {
			ndr_print_string(ndr, "Account", r->in.Account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		ndr->depth++;
		if (r->in.EncryptedPassword) {
			ndr_print_wkssvc_PasswordBuffer(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		}
		ndr->depth--;
		ndr_print_wkssvc_renameflags(ndr, "RenameOptions", r->in.RenameOptions);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetrRenameMachineInDomain2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRVALIDATENAME2(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRVALIDATENAME2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRVALIDATENAME2(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRVALIDATENAME2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRVALIDATENAME2(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRVALIDATENAME2 *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRVALIDATENAME2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRVALIDATENAME2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRVALIDATENAME2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRGETJOINABLEOUS2(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRGETJOINABLEOUS2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRGETJOINABLEOUS2(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRGETJOINABLEOUS2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRGETJOINABLEOUS2(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRGETJOINABLEOUS2 *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRGETJOINABLEOUS2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRGETJOINABLEOUS2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRGETJOINABLEOUS2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetrAddAlternateComputerName(struct ndr_push *ndr, int flags, const struct wkssvc_NetrAddAlternateComputerName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.NewAlternateMachineName));
		if (r->in.NewAlternateMachineName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewAlternateMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.NewAlternateMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.NewAlternateMachineName, ndr_charset_length(r->in.NewAlternateMachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Account));
		if (r->in.Account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Account, ndr_charset_length(r->in.Account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.EncryptedPassword));
		if (r->in.EncryptedPassword) {
			NDR_CHECK(ndr_push_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetrAddAlternateComputerName(struct ndr_pull *ndr, int flags, struct wkssvc_NetrAddAlternateComputerName *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_NewAlternateMachineName;
	uint32_t _ptr_Account;
	uint32_t _ptr_EncryptedPassword;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_NewAlternateMachineName_0;
	TALLOC_CTX *_mem_save_Account_0;
	TALLOC_CTX *_mem_save_EncryptedPassword_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NewAlternateMachineName));
		if (_ptr_NewAlternateMachineName) {
			NDR_PULL_ALLOC(ndr, r->in.NewAlternateMachineName);
		} else {
			r->in.NewAlternateMachineName = NULL;
		}
		if (r->in.NewAlternateMachineName) {
			_mem_save_NewAlternateMachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.NewAlternateMachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.NewAlternateMachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.NewAlternateMachineName));
			if (ndr_get_array_length(ndr, &r->in.NewAlternateMachineName) > ndr_get_array_size(ndr, &r->in.NewAlternateMachineName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.NewAlternateMachineName), ndr_get_array_length(ndr, &r->in.NewAlternateMachineName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.NewAlternateMachineName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.NewAlternateMachineName, ndr_get_array_length(ndr, &r->in.NewAlternateMachineName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NewAlternateMachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Account));
		if (_ptr_Account) {
			NDR_PULL_ALLOC(ndr, r->in.Account);
		} else {
			r->in.Account = NULL;
		}
		if (r->in.Account) {
			_mem_save_Account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Account));
			if (ndr_get_array_length(ndr, &r->in.Account) > ndr_get_array_size(ndr, &r->in.Account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Account), ndr_get_array_length(ndr, &r->in.Account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Account, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EncryptedPassword));
		if (_ptr_EncryptedPassword) {
			NDR_PULL_ALLOC(ndr, r->in.EncryptedPassword);
		} else {
			r->in.EncryptedPassword = NULL;
		}
		if (r->in.EncryptedPassword) {
			_mem_save_EncryptedPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.EncryptedPassword, 0);
			NDR_CHECK(ndr_pull_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EncryptedPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetrAddAlternateComputerName(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetrAddAlternateComputerName *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetrAddAlternateComputerName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetrAddAlternateComputerName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "NewAlternateMachineName", r->in.NewAlternateMachineName);
		ndr->depth++;
		if (r->in.NewAlternateMachineName) {
			ndr_print_string(ndr, "NewAlternateMachineName", r->in.NewAlternateMachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "Account", r->in.Account);
		ndr->depth++;
		if (r->in.Account) {
			ndr_print_string(ndr, "Account", r->in.Account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		ndr->depth++;
		if (r->in.EncryptedPassword) {
			ndr_print_wkssvc_PasswordBuffer(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Reserved", r->in.Reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetrAddAlternateComputerName");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_wkssvc_NetrRemoveAlternateComputerName(struct ndr_push *ndr, int flags, const struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.AlternateMachineNameToRemove));
		if (r->in.AlternateMachineNameToRemove) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.AlternateMachineNameToRemove, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.AlternateMachineNameToRemove, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.AlternateMachineNameToRemove, ndr_charset_length(r->in.AlternateMachineNameToRemove, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Account));
		if (r->in.Account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Account, ndr_charset_length(r->in.Account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.EncryptedPassword));
		if (r->in.EncryptedPassword) {
			NDR_CHECK(ndr_push_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_wkssvc_NetrRemoveAlternateComputerName(struct ndr_pull *ndr, int flags, struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	uint32_t _ptr_server_name;
	uint32_t _ptr_AlternateMachineNameToRemove;
	uint32_t _ptr_Account;
	uint32_t _ptr_EncryptedPassword;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_AlternateMachineNameToRemove_0;
	TALLOC_CTX *_mem_save_Account_0;
	TALLOC_CTX *_mem_save_EncryptedPassword_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_AlternateMachineNameToRemove));
		if (_ptr_AlternateMachineNameToRemove) {
			NDR_PULL_ALLOC(ndr, r->in.AlternateMachineNameToRemove);
		} else {
			r->in.AlternateMachineNameToRemove = NULL;
		}
		if (r->in.AlternateMachineNameToRemove) {
			_mem_save_AlternateMachineNameToRemove_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.AlternateMachineNameToRemove, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.AlternateMachineNameToRemove));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.AlternateMachineNameToRemove));
			if (ndr_get_array_length(ndr, &r->in.AlternateMachineNameToRemove) > ndr_get_array_size(ndr, &r->in.AlternateMachineNameToRemove)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.AlternateMachineNameToRemove), ndr_get_array_length(ndr, &r->in.AlternateMachineNameToRemove));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.AlternateMachineNameToRemove), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.AlternateMachineNameToRemove, ndr_get_array_length(ndr, &r->in.AlternateMachineNameToRemove), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AlternateMachineNameToRemove_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Account));
		if (_ptr_Account) {
			NDR_PULL_ALLOC(ndr, r->in.Account);
		} else {
			r->in.Account = NULL;
		}
		if (r->in.Account) {
			_mem_save_Account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Account));
			if (ndr_get_array_length(ndr, &r->in.Account) > ndr_get_array_size(ndr, &r->in.Account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Account), ndr_get_array_length(ndr, &r->in.Account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Account, ndr_get_array_length(ndr, &r->in.Account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EncryptedPassword));
		if (_ptr_EncryptedPassword) {
			NDR_PULL_ALLOC(ndr, r->in.EncryptedPassword);
		} else {
			r->in.EncryptedPassword = NULL;
		}
		if (r->in.EncryptedPassword) {
			_mem_save_EncryptedPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.EncryptedPassword, 0);
			NDR_CHECK(ndr_pull_wkssvc_PasswordBuffer(ndr, NDR_SCALARS, r->in.EncryptedPassword));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EncryptedPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_wkssvc_NetrRemoveAlternateComputerName(struct ndr_print *ndr, const char *name, int flags, const struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	ndr_print_struct(ndr, name, "wkssvc_NetrRemoveAlternateComputerName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wkssvc_NetrRemoveAlternateComputerName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "AlternateMachineNameToRemove", r->in.AlternateMachineNameToRemove);
		ndr->depth++;
		if (r->in.AlternateMachineNameToRemove) {
			ndr_print_string(ndr, "AlternateMachineNameToRemove", r->in.AlternateMachineNameToRemove);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "Account", r->in.Account);
		ndr->depth++;
		if (r->in.Account) {
			ndr_print_string(ndr, "Account", r->in.Account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		ndr->depth++;
		if (r->in.EncryptedPassword) {
			ndr_print_wkssvc_PasswordBuffer(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Reserved", r->in.Reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wkssvc_NetrRemoveAlternateComputerName");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRSETPRIMARYCOMPUTERNAME");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRSETPRIMARYCOMPUTERNAME");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRSETPRIMARYCOMPUTERNAME");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_WKSSVC_NETRENUMERATECOMPUTERNAMES(struct ndr_push *ndr, int flags, const struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_WKSSVC_NETRENUMERATECOMPUTERNAMES(struct ndr_pull *ndr, int flags, struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_WKSSVC_NETRENUMERATECOMPUTERNAMES(struct ndr_print *ndr, const char *name, int flags, const struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r)
{
	ndr_print_struct(ndr, name, "WKSSVC_NETRENUMERATECOMPUTERNAMES");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WKSSVC_NETRENUMERATECOMPUTERNAMES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WKSSVC_NETRENUMERATECOMPUTERNAMES");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call wkssvc_calls[] = {
	{
		"wkssvc_NetWkstaGetInfo",
		sizeof(struct wkssvc_NetWkstaGetInfo),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetWkstaGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetWkstaGetInfo,
		(ndr_print_function_t) ndr_print_wkssvc_NetWkstaGetInfo,
		False,
	},
	{
		"wkssvc_NetWkstaSetInfo",
		sizeof(struct wkssvc_NetWkstaSetInfo),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetWkstaSetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetWkstaSetInfo,
		(ndr_print_function_t) ndr_print_wkssvc_NetWkstaSetInfo,
		False,
	},
	{
		"wkssvc_NetWkstaEnumUsers",
		sizeof(struct wkssvc_NetWkstaEnumUsers),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetWkstaEnumUsers,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetWkstaEnumUsers,
		(ndr_print_function_t) ndr_print_wkssvc_NetWkstaEnumUsers,
		False,
	},
	{
		"WKSSVC_NETRWKSTAUSERGETINFO",
		sizeof(struct WKSSVC_NETRWKSTAUSERGETINFO),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRWKSTAUSERGETINFO,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRWKSTAUSERGETINFO,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRWKSTAUSERGETINFO,
		False,
	},
	{
		"WKSSVC_NETRWKSTAUSERSETINFO",
		sizeof(struct WKSSVC_NETRWKSTAUSERSETINFO),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRWKSTAUSERSETINFO,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRWKSTAUSERSETINFO,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRWKSTAUSERSETINFO,
		False,
	},
	{
		"wkssvc_NetWkstaTransportEnum",
		sizeof(struct wkssvc_NetWkstaTransportEnum),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetWkstaTransportEnum,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetWkstaTransportEnum,
		(ndr_print_function_t) ndr_print_wkssvc_NetWkstaTransportEnum,
		False,
	},
	{
		"WKSSVC_NETRWKSTATRANSPORTADD",
		sizeof(struct WKSSVC_NETRWKSTATRANSPORTADD),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRWKSTATRANSPORTADD,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRWKSTATRANSPORTADD,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRWKSTATRANSPORTADD,
		False,
	},
	{
		"WKSSVC_NETRWKSTATRANSPORTDEL",
		sizeof(struct WKSSVC_NETRWKSTATRANSPORTDEL),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRWKSTATRANSPORTDEL,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRWKSTATRANSPORTDEL,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRWKSTATRANSPORTDEL,
		False,
	},
	{
		"WKSSVC_NETRUSEADD",
		sizeof(struct WKSSVC_NETRUSEADD),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRUSEADD,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRUSEADD,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRUSEADD,
		False,
	},
	{
		"WKSSVC_NETRUSEGETINFO",
		sizeof(struct WKSSVC_NETRUSEGETINFO),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRUSEGETINFO,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRUSEGETINFO,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRUSEGETINFO,
		False,
	},
	{
		"WKSSVC_NETRUSEDEL",
		sizeof(struct WKSSVC_NETRUSEDEL),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRUSEDEL,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRUSEDEL,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRUSEDEL,
		False,
	},
	{
		"WKSSVC_NETRUSEENUM",
		sizeof(struct WKSSVC_NETRUSEENUM),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRUSEENUM,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRUSEENUM,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRUSEENUM,
		False,
	},
	{
		"WKSSVC_NETRMESSAGEBUFFERSEND",
		sizeof(struct WKSSVC_NETRMESSAGEBUFFERSEND),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRMESSAGEBUFFERSEND,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRMESSAGEBUFFERSEND,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRMESSAGEBUFFERSEND,
		False,
	},
	{
		"WKSSVC_NETRWORKSTATIONSTATISTICSGET",
		sizeof(struct WKSSVC_NETRWORKSTATIONSTATISTICSGET),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRWORKSTATIONSTATISTICSGET,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRWORKSTATIONSTATISTICSGET,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRWORKSTATIONSTATISTICSGET,
		False,
	},
	{
		"WKSSVC_NETRLOGONDOMAINNAMEADD",
		sizeof(struct WKSSVC_NETRLOGONDOMAINNAMEADD),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRLOGONDOMAINNAMEADD,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRLOGONDOMAINNAMEADD,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRLOGONDOMAINNAMEADD,
		False,
	},
	{
		"WKSSVC_NETRLOGONDOMAINNAMEDEL",
		sizeof(struct WKSSVC_NETRLOGONDOMAINNAMEDEL),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRLOGONDOMAINNAMEDEL,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRLOGONDOMAINNAMEDEL,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRLOGONDOMAINNAMEDEL,
		False,
	},
	{
		"WKSSVC_NETRJOINDOMAIN",
		sizeof(struct WKSSVC_NETRJOINDOMAIN),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRJOINDOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRJOINDOMAIN,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRJOINDOMAIN,
		False,
	},
	{
		"WKSSVC_NETRUNJOINDOMAIN",
		sizeof(struct WKSSVC_NETRUNJOINDOMAIN),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRUNJOINDOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRUNJOINDOMAIN,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRUNJOINDOMAIN,
		False,
	},
	{
		"WKSSVC_NETRRENAMEMACHINEINDOMAIN",
		sizeof(struct WKSSVC_NETRRENAMEMACHINEINDOMAIN),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRRENAMEMACHINEINDOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRRENAMEMACHINEINDOMAIN,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRRENAMEMACHINEINDOMAIN,
		False,
	},
	{
		"WKSSVC_NETRVALIDATENAME",
		sizeof(struct WKSSVC_NETRVALIDATENAME),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRVALIDATENAME,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRVALIDATENAME,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRVALIDATENAME,
		False,
	},
	{
		"WKSSVC_NETRGETJOININFORMATION",
		sizeof(struct WKSSVC_NETRGETJOININFORMATION),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRGETJOININFORMATION,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRGETJOININFORMATION,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRGETJOININFORMATION,
		False,
	},
	{
		"WKSSVC_NETRGETJOINABLEOUS",
		sizeof(struct WKSSVC_NETRGETJOINABLEOUS),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRGETJOINABLEOUS,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRGETJOINABLEOUS,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRGETJOINABLEOUS,
		False,
	},
	{
		"wkssvc_NetrJoinDomain2",
		sizeof(struct wkssvc_NetrJoinDomain2),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetrJoinDomain2,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetrJoinDomain2,
		(ndr_print_function_t) ndr_print_wkssvc_NetrJoinDomain2,
		False,
	},
	{
		"wkssvc_NetrUnjoinDomain2",
		sizeof(struct wkssvc_NetrUnjoinDomain2),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetrUnjoinDomain2,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetrUnjoinDomain2,
		(ndr_print_function_t) ndr_print_wkssvc_NetrUnjoinDomain2,
		False,
	},
	{
		"wkssvc_NetrRenameMachineInDomain2",
		sizeof(struct wkssvc_NetrRenameMachineInDomain2),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetrRenameMachineInDomain2,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetrRenameMachineInDomain2,
		(ndr_print_function_t) ndr_print_wkssvc_NetrRenameMachineInDomain2,
		False,
	},
	{
		"WKSSVC_NETRVALIDATENAME2",
		sizeof(struct WKSSVC_NETRVALIDATENAME2),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRVALIDATENAME2,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRVALIDATENAME2,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRVALIDATENAME2,
		False,
	},
	{
		"WKSSVC_NETRGETJOINABLEOUS2",
		sizeof(struct WKSSVC_NETRGETJOINABLEOUS2),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRGETJOINABLEOUS2,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRGETJOINABLEOUS2,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRGETJOINABLEOUS2,
		False,
	},
	{
		"wkssvc_NetrAddAlternateComputerName",
		sizeof(struct wkssvc_NetrAddAlternateComputerName),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetrAddAlternateComputerName,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetrAddAlternateComputerName,
		(ndr_print_function_t) ndr_print_wkssvc_NetrAddAlternateComputerName,
		False,
	},
	{
		"wkssvc_NetrRemoveAlternateComputerName",
		sizeof(struct wkssvc_NetrRemoveAlternateComputerName),
		(ndr_push_flags_fn_t) ndr_push_wkssvc_NetrRemoveAlternateComputerName,
		(ndr_pull_flags_fn_t) ndr_pull_wkssvc_NetrRemoveAlternateComputerName,
		(ndr_print_function_t) ndr_print_wkssvc_NetrRemoveAlternateComputerName,
		False,
	},
	{
		"WKSSVC_NETRSETPRIMARYCOMPUTERNAME",
		sizeof(struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRSETPRIMARYCOMPUTERNAME,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRSETPRIMARYCOMPUTERNAME,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRSETPRIMARYCOMPUTERNAME,
		False,
	},
	{
		"WKSSVC_NETRENUMERATECOMPUTERNAMES",
		sizeof(struct WKSSVC_NETRENUMERATECOMPUTERNAMES),
		(ndr_push_flags_fn_t) ndr_push_WKSSVC_NETRENUMERATECOMPUTERNAMES,
		(ndr_pull_flags_fn_t) ndr_pull_WKSSVC_NETRENUMERATECOMPUTERNAMES,
		(ndr_print_function_t) ndr_print_WKSSVC_NETRENUMERATECOMPUTERNAMES,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const wkssvc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\wkssvc]", 
};

static const struct dcerpc_endpoint_list wkssvc_endpoints = {
	.count	= 1,
	.names	= wkssvc_endpoint_strings
};

static const char * const wkssvc_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list wkssvc_authservices = {
	.count	= 1,
	.names	= wkssvc_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_wkssvc = {
	.name		= "wkssvc",
	.syntax_id	= {
		{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x46,0xc3,0xf8,0x7e,0x34,0x5a}},
		DCERPC_WKSSVC_VERSION
	},
	.helpstring	= DCERPC_WKSSVC_HELPSTRING,
	.num_calls	= 31,
	.calls		= wkssvc_calls,
	.endpoints	= &wkssvc_endpoints,
	.authservices	= &wkssvc_authservices
};

