/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_wkssvc.h"

/* wkssvc - dcerpc server boilerplate generated by pidl */


static NTSTATUS wkssvc__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WKSSVC_BIND
	return DCESRV_INTERFACE_WKSSVC_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void wkssvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WKSSVC_UNBIND
	DCESRV_INTERFACE_WKSSVC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS wkssvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_wkssvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_wkssvc.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_wkssvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaGetInfo will reply async\n"));
		}
		break;
	}
	case 1: {
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaSetInfo will reply async\n"));
		}
		break;
	}
	case 2: {
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaEnumUsers(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaEnumUsers will reply async\n"));
		}
		break;
	}
	case 3: {
		struct WKSSVC_NETRWKSTAUSERGETINFO *r2 = (struct WKSSVC_NETRWKSTAUSERGETINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTAUSERGETINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRWKSTAUSERGETINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTAUSERGETINFO will reply async\n"));
		}
		break;
	}
	case 4: {
		struct WKSSVC_NETRWKSTAUSERSETINFO *r2 = (struct WKSSVC_NETRWKSTAUSERSETINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTAUSERSETINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRWKSTAUSERSETINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTAUSERSETINFO will reply async\n"));
		}
		break;
	}
	case 5: {
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetWkstaTransportEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaTransportEnum will reply async\n"));
		}
		break;
	}
	case 6: {
		struct WKSSVC_NETRWKSTATRANSPORTADD *r2 = (struct WKSSVC_NETRWKSTATRANSPORTADD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTATRANSPORTADD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRWKSTATRANSPORTADD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTATRANSPORTADD will reply async\n"));
		}
		break;
	}
	case 7: {
		struct WKSSVC_NETRWKSTATRANSPORTDEL *r2 = (struct WKSSVC_NETRWKSTATRANSPORTDEL *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTATRANSPORTDEL, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRWKSTATRANSPORTDEL(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTATRANSPORTDEL will reply async\n"));
		}
		break;
	}
	case 8: {
		struct WKSSVC_NETRUSEADD *r2 = (struct WKSSVC_NETRUSEADD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEADD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRUSEADD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEADD will reply async\n"));
		}
		break;
	}
	case 9: {
		struct WKSSVC_NETRUSEGETINFO *r2 = (struct WKSSVC_NETRUSEGETINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEGETINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRUSEGETINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEGETINFO will reply async\n"));
		}
		break;
	}
	case 10: {
		struct WKSSVC_NETRUSEDEL *r2 = (struct WKSSVC_NETRUSEDEL *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEDEL, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRUSEDEL(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEDEL will reply async\n"));
		}
		break;
	}
	case 11: {
		struct WKSSVC_NETRUSEENUM *r2 = (struct WKSSVC_NETRUSEENUM *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEENUM, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRUSEENUM(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEENUM will reply async\n"));
		}
		break;
	}
	case 12: {
		struct WKSSVC_NETRMESSAGEBUFFERSEND *r2 = (struct WKSSVC_NETRMESSAGEBUFFERSEND *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRMESSAGEBUFFERSEND, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRMESSAGEBUFFERSEND(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRMESSAGEBUFFERSEND will reply async\n"));
		}
		break;
	}
	case 13: {
		struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r2 = (struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWORKSTATIONSTATISTICSGET, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRWORKSTATIONSTATISTICSGET(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWORKSTATIONSTATISTICSGET will reply async\n"));
		}
		break;
	}
	case 14: {
		struct WKSSVC_NETRLOGONDOMAINNAMEADD *r2 = (struct WKSSVC_NETRLOGONDOMAINNAMEADD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRLOGONDOMAINNAMEADD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRLOGONDOMAINNAMEADD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRLOGONDOMAINNAMEADD will reply async\n"));
		}
		break;
	}
	case 15: {
		struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r2 = (struct WKSSVC_NETRLOGONDOMAINNAMEDEL *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRLOGONDOMAINNAMEDEL, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRLOGONDOMAINNAMEDEL(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRLOGONDOMAINNAMEDEL will reply async\n"));
		}
		break;
	}
	case 16: {
		struct WKSSVC_NETRJOINDOMAIN *r2 = (struct WKSSVC_NETRJOINDOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRJOINDOMAIN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRJOINDOMAIN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRJOINDOMAIN will reply async\n"));
		}
		break;
	}
	case 17: {
		struct WKSSVC_NETRUNJOINDOMAIN *r2 = (struct WKSSVC_NETRUNJOINDOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUNJOINDOMAIN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRUNJOINDOMAIN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUNJOINDOMAIN will reply async\n"));
		}
		break;
	}
	case 18: {
		struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r2 = (struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRRENAMEMACHINEINDOMAIN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRRENAMEMACHINEINDOMAIN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRRENAMEMACHINEINDOMAIN will reply async\n"));
		}
		break;
	}
	case 19: {
		struct WKSSVC_NETRVALIDATENAME *r2 = (struct WKSSVC_NETRVALIDATENAME *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRVALIDATENAME, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRVALIDATENAME(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRVALIDATENAME will reply async\n"));
		}
		break;
	}
	case 20: {
		struct WKSSVC_NETRGETJOININFORMATION *r2 = (struct WKSSVC_NETRGETJOININFORMATION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOININFORMATION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRGETJOININFORMATION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOININFORMATION will reply async\n"));
		}
		break;
	}
	case 21: {
		struct WKSSVC_NETRGETJOINABLEOUS *r2 = (struct WKSSVC_NETRGETJOINABLEOUS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOINABLEOUS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRGETJOINABLEOUS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOINABLEOUS will reply async\n"));
		}
		break;
	}
	case 22: {
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrJoinDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain2 will reply async\n"));
		}
		break;
	}
	case 23: {
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrUnjoinDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain2 will reply async\n"));
		}
		break;
	}
	case 24: {
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrRenameMachineInDomain2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain2 will reply async\n"));
		}
		break;
	}
	case 25: {
		struct WKSSVC_NETRVALIDATENAME2 *r2 = (struct WKSSVC_NETRVALIDATENAME2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRVALIDATENAME2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRVALIDATENAME2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRVALIDATENAME2 will reply async\n"));
		}
		break;
	}
	case 26: {
		struct WKSSVC_NETRGETJOINABLEOUS2 *r2 = (struct WKSSVC_NETRGETJOINABLEOUS2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOINABLEOUS2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRGETJOINABLEOUS2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOINABLEOUS2 will reply async\n"));
		}
		break;
	}
	case 27: {
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrAddAlternateComputerName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrAddAlternateComputerName will reply async\n"));
		}
		break;
	}
	case 28: {
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_wkssvc_NetrRemoveAlternateComputerName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRemoveAlternateComputerName will reply async\n"));
		}
		break;
	}
	case 29: {
		struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r2 = (struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRSETPRIMARYCOMPUTERNAME, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRSETPRIMARYCOMPUTERNAME will reply async\n"));
		}
		break;
	}
	case 30: {
		struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r2 = (struct WKSSVC_NETRENUMERATECOMPUTERNAMES *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRENUMERATECOMPUTERNAMES, NDR_IN, r2);
		}
		r2->out.result = dcesrv_WKSSVC_NETRENUMERATECOMPUTERNAMES(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRENUMERATECOMPUTERNAMES will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaEnumUsers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaEnumUsers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct WKSSVC_NETRWKSTAUSERGETINFO *r2 = (struct WKSSVC_NETRWKSTAUSERGETINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTAUSERGETINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTAUSERGETINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRWKSTAUSERGETINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct WKSSVC_NETRWKSTAUSERSETINFO *r2 = (struct WKSSVC_NETRWKSTAUSERSETINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTAUSERSETINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTAUSERSETINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRWKSTAUSERSETINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaTransportEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetWkstaTransportEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct WKSSVC_NETRWKSTATRANSPORTADD *r2 = (struct WKSSVC_NETRWKSTATRANSPORTADD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTATRANSPORTADD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTATRANSPORTADD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRWKSTATRANSPORTADD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct WKSSVC_NETRWKSTATRANSPORTDEL *r2 = (struct WKSSVC_NETRWKSTATRANSPORTDEL *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWKSTATRANSPORTDEL replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWKSTATRANSPORTDEL, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRWKSTATRANSPORTDEL\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct WKSSVC_NETRUSEADD *r2 = (struct WKSSVC_NETRUSEADD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEADD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEADD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRUSEADD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct WKSSVC_NETRUSEGETINFO *r2 = (struct WKSSVC_NETRUSEGETINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEGETINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEGETINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRUSEGETINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct WKSSVC_NETRUSEDEL *r2 = (struct WKSSVC_NETRUSEDEL *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEDEL replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEDEL, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRUSEDEL\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct WKSSVC_NETRUSEENUM *r2 = (struct WKSSVC_NETRUSEENUM *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUSEENUM replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUSEENUM, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRUSEENUM\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct WKSSVC_NETRMESSAGEBUFFERSEND *r2 = (struct WKSSVC_NETRMESSAGEBUFFERSEND *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRMESSAGEBUFFERSEND replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRMESSAGEBUFFERSEND, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRMESSAGEBUFFERSEND\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r2 = (struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRWORKSTATIONSTATISTICSGET replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRWORKSTATIONSTATISTICSGET, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRWORKSTATIONSTATISTICSGET\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct WKSSVC_NETRLOGONDOMAINNAMEADD *r2 = (struct WKSSVC_NETRLOGONDOMAINNAMEADD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRLOGONDOMAINNAMEADD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRLOGONDOMAINNAMEADD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRLOGONDOMAINNAMEADD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r2 = (struct WKSSVC_NETRLOGONDOMAINNAMEDEL *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRLOGONDOMAINNAMEDEL replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRLOGONDOMAINNAMEDEL, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRLOGONDOMAINNAMEDEL\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct WKSSVC_NETRJOINDOMAIN *r2 = (struct WKSSVC_NETRJOINDOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRJOINDOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRJOINDOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRJOINDOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct WKSSVC_NETRUNJOINDOMAIN *r2 = (struct WKSSVC_NETRUNJOINDOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRUNJOINDOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRUNJOINDOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRUNJOINDOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r2 = (struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRRENAMEMACHINEINDOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRRENAMEMACHINEINDOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRRENAMEMACHINEINDOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct WKSSVC_NETRVALIDATENAME *r2 = (struct WKSSVC_NETRVALIDATENAME *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRVALIDATENAME replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRVALIDATENAME, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRVALIDATENAME\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct WKSSVC_NETRGETJOININFORMATION *r2 = (struct WKSSVC_NETRGETJOININFORMATION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOININFORMATION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOININFORMATION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRGETJOININFORMATION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct WKSSVC_NETRGETJOINABLEOUS *r2 = (struct WKSSVC_NETRGETJOINABLEOUS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOINABLEOUS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOINABLEOUS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRGETJOINABLEOUS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrJoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrUnjoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrRenameMachineInDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct WKSSVC_NETRVALIDATENAME2 *r2 = (struct WKSSVC_NETRVALIDATENAME2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRVALIDATENAME2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRVALIDATENAME2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRVALIDATENAME2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct WKSSVC_NETRGETJOINABLEOUS2 *r2 = (struct WKSSVC_NETRGETJOINABLEOUS2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRGETJOINABLEOUS2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRGETJOINABLEOUS2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRGETJOINABLEOUS2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrAddAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrAddAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRemoveAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in wkssvc_NetrRemoveAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r2 = (struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRSETPRIMARYCOMPUTERNAME replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRSETPRIMARYCOMPUTERNAME, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRSETPRIMARYCOMPUTERNAME\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r2 = (struct WKSSVC_NETRENUMERATECOMPUTERNAMES *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function WKSSVC_NETRENUMERATECOMPUTERNAMES replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(WKSSVC_NETRENUMERATECOMPUTERNAMES, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in WKSSVC_NETRENUMERATECOMPUTERNAMES\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_wkssvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_wkssvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_wkssvc_interface = {
	.name		= "wkssvc",
	.syntax_id  = {{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x46,0xc3,0xf8,0x7e,0x34,0x5a}},1.0},
	.bind		= wkssvc__op_bind,
	.unbind		= wkssvc__op_unbind,
	.ndr_pull	= wkssvc__op_ndr_pull,
	.dispatch	= wkssvc__op_dispatch,
	.reply		= wkssvc__op_reply,
	.ndr_push	= wkssvc__op_ndr_push
};


static NTSTATUS wkssvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_wkssvc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_wkssvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_wkssvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("wkssvc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL wkssvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_wkssvc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_wkssvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_wkssvc_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL wkssvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_wkssvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_wkssvc_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_wkssvc_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "wkssvc";

	/* fill in all the operations */
	ep_server.init_server = wkssvc__op_init_server;

	ep_server.interface_by_uuid = wkssvc__op_interface_by_uuid;
	ep_server.interface_by_name = wkssvc__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'wkssvc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

