/* header auto-generated by pidl */

#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_spoolss
#define _HEADER_spoolss

#define SPOOLSS_ARCHITECTURE_NT_X86	( "Windows NT x86" )
struct spoolss_Time {
	uint16_t year;
	uint16_t month;
	uint16_t day_of_week;
	uint16_t day;
	uint16_t hour;
	uint16_t minute;
	uint16_t second;
	uint16_t millisecond;
};

struct spoolss_PrinterInfo0 {
	const char * printername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * servername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t cjobs;
	uint32_t total_jobs;
	uint32_t total_bytes;
	struct spoolss_Time time;
	uint32_t global_counter;
	uint32_t total_pages;
	uint32_t version;
	uint32_t unknown10;
	uint32_t unknown11;
	uint32_t unknown12;
	uint32_t session_counter;
	uint32_t unknown14;
	uint32_t printer_errors;
	uint32_t unknown16;
	uint32_t unknown17;
	uint32_t unknown18;
	uint32_t unknown19;
	uint32_t change_id;
	uint32_t unknown21;
	uint32_t status;
	uint32_t unknown23;
	uint32_t c_setprinter;
	uint16_t unknown25;
	uint16_t unknown26;
	uint32_t unknown27;
	uint32_t unknown28;
	uint32_t unknown29;
};

struct spoolss_DeviceMode {
	const char * devicename;/* [flag(LIBNDR_FLAG_STR_FIXLEN32)] */
	uint16_t specversion;
	uint16_t driverversion;
	uint16_t size;
	uint16_t __driverextra_length;/* [value(r->driverextra_data.length)] */
	uint32_t fields;
	uint16_t orientation;
	uint16_t papersize;
	uint16_t paperlength;
	uint16_t paperwidth;
	uint16_t scale;
	uint16_t copies;
	uint16_t defaultsource;
	uint16_t printquality;
	uint16_t color;
	uint16_t duplex;
	uint16_t yresolution;
	uint16_t ttoption;
	uint16_t collate;
	const char * formname;/* [flag(LIBNDR_FLAG_STR_FIXLEN32)] */
	uint16_t logpixels;
	uint32_t bitsperpel;
	uint32_t pelswidth;
	uint32_t pelsheight;
	uint32_t displayflags;
	uint32_t displayfrequency;
	uint32_t icmmethod;
	uint32_t icmintent;
	uint32_t mediatype;
	uint32_t dithertype;
	uint32_t reserved1;
	uint32_t reserved2;
	uint32_t panningwidth;
	uint32_t panningheight;
	DATA_BLOB driverextra_data;/* [subcontext_size(__driverextra_length),subcontext(0),flag(LIBNDR_FLAG_REMAINING)] */
}/* [gensize,public] */;

/* bitmap spoolss_EnumPrinterFlags */
#define PRINTER_ENUM_DEFAULT ( 0x00000001 )
#define PRINTER_ENUM_LOCAL ( 0x00000002 )
#define PRINTER_ENUM_CONNECTIONS ( 0x00000004 )
#define PRINTER_ENUM_FAVORITE ( 0x00000004 )
#define PRINTER_ENUM_NAME ( 0x00000008 )
#define PRINTER_ENUM_REMOTE ( 0x00000010 )
#define PRINTER_ENUM_SHARED ( 0x00000020 )
#define PRINTER_ENUM_NETWORK ( 0x00000040 )
#define PRINTER_ENUM_EXPAND ( 0x00004000 )
#define PRINTER_ENUM_CONTAINER ( 0x00008000 )
#define PRINTER_ENUM_ICON1 ( 0x00010000 )
#define PRINTER_ENUM_ICON2 ( 0x00020000 )
#define PRINTER_ENUM_ICON3 ( 0x00040000 )
#define PRINTER_ENUM_ICON4 ( 0x00080000 )
#define PRINTER_ENUM_ICON5 ( 0x00100000 )
#define PRINTER_ENUM_ICON6 ( 0x00200000 )
#define PRINTER_ENUM_ICON7 ( 0x00400000 )
#define PRINTER_ENUM_ICON8 ( 0x00800000 )
#define PRINTER_ENUM_HIDE ( 0x01000000 )

struct spoolss_PrinterInfo1 {
	uint32_t flags;
	const char * name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * description;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * comment;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

/* bitmap spoolss_PrinterAttributes */
#define PRINTER_ATTRIBUTE_QUEUED ( 0x00000001 )
#define PRINTER_ATTRIBUTE_DIRECT ( 0x00000002 )
#define PRINTER_ATTRIBUTE_DEFAULT ( 0x00000004 )
#define PRINTER_ATTRIBUTE_SHARED ( 0x00000008 )
#define PRINTER_ATTRIBUTE_NETWORK ( 0x00000010 )
#define PRINTER_ATTRIBUTE_HIDDEN ( 0x00000020 )
#define PRINTER_ATTRIBUTE_LOCAL ( 0x00000040 )
#define PRINTER_ATTRIBUTE_ENABLE_DEVQ ( 0x00000080 )
#define PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS ( 0x00000100 )
#define PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST ( 0x00000200 )
#define PRINTER_ATTRIBUTE_WORK_OFFLINE ( 0x00000400 )
#define PRINTER_ATTRIBUTE_ENABLE_BIDI ( 0x00000800 )
#define PRINTER_ATTRIBUTE_RAW_ONLY ( 0x00001000 )
#define PRINTER_ATTRIBUTE_PUBLISHED ( 0x00002000 )
#define PRINTER_ATTRIBUTE_FAX ( 0x00004000 )
#define PRINTER_ATTRIBUTE_TS ( 0x00008000 )

/* bitmap spoolss_PrinterStatus */
#define PRINTER_STATUS_PAUSED ( 0x00000001 )
#define PRINTER_STATUS_ERROR ( 0x00000002 )
#define PRINTER_STATUS_PENDING_DELETION ( 0x00000004 )
#define PRINTER_STATUS_PAPER_JAM ( 0x00000008 )
#define PRINTER_STATUS_PAPER_OUT ( 0x00000010 )
#define PRINTER_STATUS_MANUAL_FEED ( 0x00000020 )
#define PRINTER_STATUS_PAPER_PROBLEM ( 0x00000040 )
#define PRINTER_STATUS_OFFLINE ( 0x00000080 )
#define PRINTER_STATUS_IO_ACTIVE ( 0x00000100 )
#define PRINTER_STATUS_BUSY ( 0x00000200 )
#define PRINTER_STATUS_PRINTING ( 0x00000400 )
#define PRINTER_STATUS_OUTPUT_BIN_FULL ( 0x00000800 )
#define PRINTER_STATUS_NOT_AVAILABLE ( 0x00001000 )
#define PRINTER_STATUS_WAITING ( 0x00002000 )
#define PRINTER_STATUS_PROCESSING ( 0x00004000 )
#define PRINTER_STATUS_INITIALIZING ( 0x00008000 )
#define PRINTER_STATUS_WARMING_UP ( 0x00010000 )
#define PRINTER_STATUS_TONER_LOW ( 0x00020000 )
#define PRINTER_STATUS_NO_TONER ( 0x00040000 )
#define PRINTER_STATUS_PAGE_PUNT ( 0x00080000 )
#define PRINTER_STATUS_USER_INTERVENTION ( 0x00100000 )
#define PRINTER_STATUS_OUT_OF_MEMORY ( 0x00200000 )
#define PRINTER_STATUS_DOOR_OPEN ( 0x00400000 )
#define PRINTER_STATUS_SERVER_UNKNOWN ( 0x00800000 )
#define PRINTER_STATUS_POWER_SAVE ( 0x01000000 )

struct spoolss_PrinterInfo2 {
	const char * servername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * printername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * sharename;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * portname;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * drivername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * comment;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * location;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	struct spoolss_DeviceMode *devmode;/* [relative,subcontext(0)] */
	const char * sepfile;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * printprocessor;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * datatype;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * parameters;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	struct security_descriptor *secdesc;/* [relative,subcontext(0)] */
	uint32_t attributes;
	uint32_t priority;
	uint32_t defaultpriority;
	uint32_t starttime;
	uint32_t untiltime;
	uint32_t status;
	uint32_t cjobs;
	uint32_t averageppm;
};

struct spoolss_PrinterInfo3 {
	struct security_descriptor *secdesc;/* [relative,subcontext(0)] */
};

struct spoolss_PrinterInfo4 {
	const char * printername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * servername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t attributes;
};

struct spoolss_PrinterInfo5 {
	const char * printername;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * portname;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t attributes;
	uint32_t device_not_selected_timeout;
	uint32_t transmission_retry_timeout;
};

struct spoolss_PrinterInfo6 {
	uint32_t status;
};

/* bitmap spoolss_DsPrintAction */
#define DSPRINT_PUBLISH ( 0x00000001 )
#define DSPRINT_UPDATE ( 0x00000002 )
#define DSPRINT_UNPUBLISH ( 0x00000004 )
#define DSPRINT_REPUBLISH ( 0x00000008 )
#define DSPRINT_PENDING ( 0x80000000 )

struct spoolss_PrinterInfo7 {
	const char * guid;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t action;
};

struct spoolss_DeviceModeInfo {
	struct spoolss_DeviceMode *devmode;/* [relative,subcontext(0)] */
};

union spoolss_PrinterInfo {
	struct spoolss_PrinterInfo0 info0;/* [case(0)] */
	struct spoolss_PrinterInfo1 info1;/* [case] */
	struct spoolss_PrinterInfo2 info2;/* [case(2)] */
	struct spoolss_PrinterInfo3 info3;/* [case(3)] */
	struct spoolss_PrinterInfo4 info4;/* [case(4)] */
	struct spoolss_PrinterInfo5 info5;/* [case(5)] */
	struct spoolss_PrinterInfo6 info6;/* [case(6)] */
	struct spoolss_PrinterInfo7 info7;/* [case(7)] */
	struct spoolss_DeviceModeInfo info8;/* [case(8)] */
	struct spoolss_DeviceModeInfo info9;/* [case(9)] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_DevmodeContainer {
	uint32_t _ndr_size;/* [value(_ndr_size_spoolss_DeviceMode(devmode,ndr->flags))] */
	struct spoolss_DeviceMode *devmode;/* [unique,subcontext_size(_ndr_size),subcontext(4)] */
};

struct spoolss_JobInfo1 {
	uint32_t job_id;
	const char * printer_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * server_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * user_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * document_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_type;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * text_status;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t status;
	uint32_t priority;
	uint32_t position;
	uint32_t total_pages;
	uint32_t pages_printed;
	struct spoolss_Time time;
};

union spoolss_JobInfo {
	struct spoolss_JobInfo1 info1;/* [case] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_JobInfoContainer {
	uint32_t level;
	union spoolss_JobInfo info;/* [switch_is(level)] */
};

#ifndef USE_UINT_ENUMS
enum spoolss_JobControl {
	SPOOLSS_JOB_CONTROL_PAUSE=1,
	SPOOLSS_JOB_CONTROL_RESUME=2,
	SPOOLSS_JOB_CONTROL_CANCEL=3,
	SPOOLSS_JOB_CONTROL_RESTART=4,
	SPOOLSS_JOB_CONTROL_DELETE=5,
	SPOOLSS_JOB_CONTROL_SEND_TO_PRINTER=6,
	SPOOLSS_JOB_CONTROL_LAST_PAGE_EJECTED=7
};
#else
enum spoolss_JobControl { __donnot_use_enum_spoolss_JobControl=0x7FFFFFFF};
#define SPOOLSS_JOB_CONTROL_PAUSE ( 1 )
#define SPOOLSS_JOB_CONTROL_RESUME ( 2 )
#define SPOOLSS_JOB_CONTROL_CANCEL ( 3 )
#define SPOOLSS_JOB_CONTROL_RESTART ( 4 )
#define SPOOLSS_JOB_CONTROL_DELETE ( 5 )
#define SPOOLSS_JOB_CONTROL_SEND_TO_PRINTER ( 6 )
#define SPOOLSS_JOB_CONTROL_LAST_PAGE_EJECTED ( 7 )
#endif

#ifndef USE_UINT_ENUMS
enum spoolss_PrinterControl {
	SPOOLSS_PRINTER_CONTROL_UNPAUSE=0,
	SPOOLSS_PRINTER_CONTROL_PAUSE=1,
	SPOOLSS_PRINTER_CONTROL_RESUME=2,
	SPOOLSS_PRINTER_CONTROL_PURGE=3,
	SPOOLSS_PRINTER_CONTROL_SET_STATUS=4
};
#else
enum spoolss_PrinterControl { __donnot_use_enum_spoolss_PrinterControl=0x7FFFFFFF};
#define SPOOLSS_PRINTER_CONTROL_UNPAUSE ( 0 )
#define SPOOLSS_PRINTER_CONTROL_PAUSE ( 1 )
#define SPOOLSS_PRINTER_CONTROL_RESUME ( 2 )
#define SPOOLSS_PRINTER_CONTROL_PURGE ( 3 )
#define SPOOLSS_PRINTER_CONTROL_SET_STATUS ( 4 )
#endif

union spoolss_SetPrinterInfo {
	struct spoolss_PrinterInfo0 *info0;/* [unique,case(0)] */
	struct spoolss_PrinterInfo1 *info1;/* [unique,case] */
	struct spoolss_PrinterInfo2 *info2;/* [unique,case(2)] */
	struct spoolss_PrinterInfo3 *info3;/* [unique,case(3)] */
	struct spoolss_PrinterInfo4 *info4;/* [unique,case(4)] */
	struct spoolss_PrinterInfo5 *info5;/* [unique,case(5)] */
	struct spoolss_PrinterInfo6 *info6;/* [unique,case(6)] */
	struct spoolss_PrinterInfo7 *info7;/* [unique,case(7)] */
	struct spoolss_DeviceModeInfo *info8;/* [unique,case(8)] */
	struct spoolss_DeviceModeInfo *info9;/* [unique,case(9)] */
}/* [switch_type(uint32)] */;

struct spoolss_DriverInfo1 {
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

#ifndef USE_UINT_ENUMS
enum spoolss_DriverOSVersion {
	SPOOLSS_DRIVER_VERSION_9X=0,
	SPOOLSS_DRIVER_VERSION_NT35=1,
	SPOOLSS_DRIVER_VERSION_NT4=2,
	SPOOLSS_DRIVER_VERSION_200X=3
};
#else
enum spoolss_DriverOSVersion { __donnot_use_enum_spoolss_DriverOSVersion=0x7FFFFFFF};
#define SPOOLSS_DRIVER_VERSION_9X ( 0 )
#define SPOOLSS_DRIVER_VERSION_NT35 ( 1 )
#define SPOOLSS_DRIVER_VERSION_NT4 ( 2 )
#define SPOOLSS_DRIVER_VERSION_200X ( 3 )
#endif

struct spoolss_DriverInfo2 {
	enum spoolss_DriverOSVersion version;
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * architecture;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * driver_path;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * config_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

struct spoolss_DriverInfo3 {
	enum spoolss_DriverOSVersion version;
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * architecture;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * driver_path;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * config_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * help_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char ** dependent_files;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * default_datatype;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

struct spoolss_DriverInfo4 {
	enum spoolss_DriverOSVersion version;
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * architecture;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * driver_path;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * config_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * help_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char ** dependent_files;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * default_datatype;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char ** previous_names;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

struct spoolss_DriverInfo5 {
	enum spoolss_DriverOSVersion version;
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * architecture;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * driver_path;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * config_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t driver_attributes;
	uint32_t config_version;
	uint32_t driver_version;
};

struct spoolss_DriverInfo6 {
	enum spoolss_DriverOSVersion version;
	const char * driver_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * architecture;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * driver_path;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * data_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * config_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * help_file;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char ** dependent_files;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * default_datatype;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char ** previous_names;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	NTTIME driver_data;
	uint64_t driver_version;
	const char * manufacturer_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * manufacturer_url;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * hardware_id;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * provider;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

union spoolss_DriverInfo {
	struct spoolss_DriverInfo1 info1;/* [case] */
	struct spoolss_DriverInfo2 info2;/* [case(2)] */
	struct spoolss_DriverInfo3 info3;/* [case(3)] */
	struct spoolss_DriverInfo4 info4;/* [case(4)] */
	struct spoolss_DriverInfo5 info5;/* [case(5)] */
	struct spoolss_DriverInfo6 info6;/* [case(6)] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_DriverDirectoryInfo1 {
	const char * directory_name;/* [flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

union spoolss_DriverDirectoryInfo {
	struct spoolss_DriverDirectoryInfo1 info1;/* [case] */
}/* [gensize,relative_base,nodiscriminant,public] */;

struct spoolss_PrintProcessorInfo1 {
	const char * print_processor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

union spoolss_PrintProcessorInfo {
	struct spoolss_PrintProcessorInfo1 info1;/* [case] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_DocumentInfo1 {
	const char *document_name;/* [unique,charset(UTF16)] */
	const char *output_file;/* [unique,charset(UTF16)] */
	const char *datatype;/* [unique,charset(UTF16)] */
};

union spoolss_DocumentInfo {
	struct spoolss_DocumentInfo1 *info1;/* [unique,case] */
}/* [switch_type(uint32)] */;

struct spoolss_OSVersion {
	uint32_t _ndr_size;/* [value(ndr_size_spoolss_OSVersion(r,ndr->flags))] */
	uint32_t major;
	uint32_t minor;
	uint32_t build;
	uint32_t unknown;/* [value(2)] */
	const char * extra_string;/* [subcontext_size(256),subcontext(0),flag(LIBNDR_FLAG_STR_NULLTERM)] */
}/* [gensize,public] */;

struct spoolss_OSVersionEx {
	uint32_t _ndr_size;/* [value(ndr_size_spoolss_OSVersionEx(r,ndr->flags))] */
	uint32_t major;
	uint32_t minor;
	uint32_t build;
	uint32_t unknown1;/* [value(2)] */
	const char * extra_string;/* [subcontext_size(256),subcontext(0),flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t unknown2;
	uint32_t unknown3;
}/* [gensize,public] */;

#ifndef USE_UINT_ENUMS
enum spoolss_PrinterDataType {
	SPOOLSS_PRINTER_DATA_TYPE_NULL=0,
	SPOOLSS_PRINTER_DATA_TYPE_STRING=1,
	SPOOLSS_PRINTER_DATA_TYPE_BINARY=3,
	SPOOLSS_PRINTER_DATA_TYPE_UINT32=4,
	SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY=7
};
#else
enum spoolss_PrinterDataType { __donnot_use_enum_spoolss_PrinterDataType=0x7FFFFFFF};
#define SPOOLSS_PRINTER_DATA_TYPE_NULL ( 0 )
#define SPOOLSS_PRINTER_DATA_TYPE_STRING ( 1 )
#define SPOOLSS_PRINTER_DATA_TYPE_BINARY ( 3 )
#define SPOOLSS_PRINTER_DATA_TYPE_UINT32 ( 4 )
#define SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY ( 7 )
#endif

union spoolss_PrinterData {
	const char * string;/* [flag(LIBNDR_FLAG_STR_NULLTERM),case(SPOOLSS_PRINTER_DATA_TYPE_STRING)] */
	DATA_BLOB binary;/* [flag(LIBNDR_FLAG_REMAINING),case(SPOOLSS_PRINTER_DATA_TYPE_BINARY)] */
	uint32_t value;/* [case(SPOOLSS_PRINTER_DATA_TYPE_UINT32)] */
	const char ** string_array;/* [flag(LIBNDR_FLAG_STR_NULLTERM),case(SPOOLSS_PRINTER_DATA_TYPE_STRING_ARRAY)] */
	DATA_BLOB data;/* [flag(LIBNDR_FLAG_REMAINING),default] */
}/* [gensize,public,nodiscriminant] */;

#ifndef USE_UINT_ENUMS
enum spoolss_FormFlags {
	SPOOLSS_FORM_USER=0,
	SPOOLSS_FORM_BUILTIN=1,
	SPOOLSS_FORM_PRINTER=2
};
#else
enum spoolss_FormFlags { __donnot_use_enum_spoolss_FormFlags=0x7FFFFFFF};
#define SPOOLSS_FORM_USER ( 0 )
#define SPOOLSS_FORM_BUILTIN ( 1 )
#define SPOOLSS_FORM_PRINTER ( 2 )
#endif

struct spoolss_FormSize {
	uint32_t width;
	uint32_t height;
};

struct spoolss_FormArea {
	uint32_t left;
	uint32_t top;
	uint32_t right;
	uint32_t bottom;
};

struct spoolss_FormInfo1 {
	enum spoolss_FormFlags flags;
	const char * form_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	struct spoolss_FormSize size;
	struct spoolss_FormArea area;
};

union spoolss_FormInfo {
	struct spoolss_FormInfo1 info1;/* [case] */
}/* [relative_base,gensize,public,nodiscriminant] */;

struct spoolss_AddFormInfo1 {
	enum spoolss_FormFlags flags;
	const char *form_name;/* [unique,charset(UTF16)] */
	struct spoolss_FormSize size;
	struct spoolss_FormArea area;
};

union spoolss_AddFormInfo {
	struct spoolss_AddFormInfo1 *info1;/* [unique,case] */
}/* [switch_type(uint32)] */;

struct spoolss_PortInfo1 {
	const char * port_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

/* bitmap spoolss_PortType */
#define SPOOLSS_PORT_TYPE_WRITE ( 0x00000001 )
#define SPOOLSS_PORT_TYPE_READ ( 0x00000002 )
#define SPOOLSS_PORT_TYPE_REDIRECTED ( 0x00000004 )
#define SPOOLSS_PORT_TYPE_NET_ATTACHED ( 0x00000008 )

struct spoolss_PortInfo2 {
	const char * port_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * description;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	uint32_t port_type;
	uint32_t reserved;
};

union spoolss_PortInfo {
	struct spoolss_PortInfo1 info1;/* [case] */
	struct spoolss_PortInfo2 info2;/* [case(2)] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_MonitorInfo1 {
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

struct spoolss_MonitorInfo2 {
	const char * monitor_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * environment;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * dll_name;/* [relative,flag(LIBNDR_FLAG_STR_NULLTERM)] */
};

union spoolss_MonitorInfo {
	struct spoolss_MonitorInfo1 info1;/* [case] */
	struct spoolss_MonitorInfo2 info2;/* [case(2)] */
}/* [relative_base,nodiscriminant,public] */;

struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2 {
	uint16_t u1;
	uint16_t u2;
	uint32_t u3;
	uint32_t u4;
	uint32_t count;
	uint16_t *array;/* [unique,size_is(count)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1 {
	uint32_t u1;
	uint32_t u2;
	uint32_t count;
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2 *t2;/* [unique,size_is(count)] */
};

struct spoolss_UserLevel1 {
	uint32_t size;
	const char *client;/* [unique,charset(UTF16)] */
	const char *user;/* [unique,charset(UTF16)] */
	uint32_t build;
	uint32_t major;
	uint32_t minor;
	uint32_t processor;
};

union spoolss_UserLevel {
	struct spoolss_UserLevel1 *level1;/* [unique,case] */
};


struct _spoolss_EnumPrinters {
	struct {
		uint32_t flags;
		const char *server;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumPrinters {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_PrinterInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumPrinters {
	struct {
		uint32_t flags;
		const char *server;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_PrinterInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_OpenPrinter {
	struct {
		const char *printername;/* [unique,charset(UTF16)] */
		const char *datatype;/* [unique,charset(UTF16)] */
		struct spoolss_DevmodeContainer devmode_ctr;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct spoolss_SetJob {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t job_id;
		struct spoolss_JobInfoContainer *ctr;/* [unique] */
		enum spoolss_JobControl command;
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_GetJob {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t job_id;
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_JobInfo *info;/* [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */
		uint32_t needed;
		WERROR result;
	} out;

};


struct _spoolss_EnumJobs {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t firstjob;
		uint32_t numjobs;
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumJobs {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_JobInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumJobs {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t firstjob;
		uint32_t numjobs;
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_JobInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_AddPrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_SetPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		union spoolss_SetPrinterInfo info;/* [switch_is(level)] */
		struct spoolss_DevmodeContainer devmode_ctr;
		struct sec_desc_buf secdesc_ctr;
		enum spoolss_PrinterControl command;
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_GetPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_PrinterInfo *info;/* [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */
		uint32_t needed;
		WERROR result;
	} out;

};


struct spoolss_AddPrinterDriver {
	struct {
		WERROR result;
	} out;

};


struct _spoolss_EnumPrinterDrivers {
	struct {
		const char *server;/* [unique,charset(UTF16)] */
		const char *environment;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumPrinterDrivers {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_DriverInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumPrinterDrivers {
	struct {
		const char *server;/* [unique,charset(UTF16)] */
		const char *environment;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_DriverInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_GetPrinterDriver {
	struct {
		WERROR result;
	} out;

};


struct spoolss_GetPrinterDriverDirectory {
	struct {
		const char *server;/* [unique,charset(UTF16)] */
		const char *environment;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_DriverDirectoryInfo *info;/* [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */
		uint32_t needed;
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterDriver {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *server;/* [unique,charset(UTF16)] */
		const char *architecture;/* [charset(UTF16)] */
		const char *driver;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_AddPrintProcessor {
	struct {
		WERROR result;
	} out;

};


struct _spoolss_EnumPrintProcessors {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		const char *environment;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumPrintProcessors {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_PrintProcessorInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumPrintProcessors {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		const char *environment;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_PrintProcessorInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_GetPrintProcessorDirectory {
	struct {
		WERROR result;
	} out;

};


struct spoolss_StartDocPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		union spoolss_DocumentInfo info;/* [switch_is(level)] */
	} in;

	struct {
		uint32_t job_id;
		WERROR result;
	} out;

};


struct spoolss_StartPagePrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_WritePrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
		DATA_BLOB data;
		uint32_t _data_size;/* [value(r->in.data.length)] */
	} in;

	struct {
		uint32_t num_written;
		WERROR result;
	} out;

};


struct spoolss_EndPagePrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_AbortPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_ReadPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t data_size;
	} in;

	struct {
		DATA_BLOB data;
		uint32_t _data_size;/* [value(r->out.data.length)] */
		WERROR result;
	} out;

};


struct spoolss_EndDocPrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_AddJob {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ScheduleJob {
	struct {
		WERROR result;
	} out;

};


struct _spoolss_GetPrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *value_name;/* [charset(UTF16)] */
		uint32_t offered;
	} in;

	struct {
		enum spoolss_PrinterDataType type;
		DATA_BLOB data;
		uint32_t needed;
		WERROR result;
	} out;

};


struct __spoolss_GetPrinterData {
	struct {
		enum spoolss_PrinterDataType type;
	} in;

	struct {
		union spoolss_PrinterData data;/* [switch_is(type)] */
	} out;

};


struct spoolss_GetPrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *value_name;/* [charset(UTF16)] */
		uint32_t offered;
	} in;

	struct {
		enum spoolss_PrinterDataType type;
		union spoolss_PrinterData data;/* [subcontext_size(offered),subcontext(4),switch_is(type)] */
		uint32_t needed;
		WERROR result;
	} out;

};


struct _spoolss_SetPrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *value_name;/* [charset(UTF16)] */
		enum spoolss_PrinterDataType type;
		DATA_BLOB data;
		uint32_t _offered;
	} in;

	struct {
		WERROR result;
	} out;

};


struct __spoolss_SetPrinterData {
	struct {
		enum spoolss_PrinterDataType type;
	} in;

	struct {
		union spoolss_PrinterData data;/* [switch_is(type)] */
	} out;

};


struct spoolss_SetPrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *value_name;/* [charset(UTF16)] */
		enum spoolss_PrinterDataType type;
		union spoolss_PrinterData data;/* [subcontext(4),switch_is(type)] */
		uint32_t _offered;/* [value(ndr_size_spoolss_PrinterData(&data,type,flags))] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_WaitForPrinterChange {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ClosePrinter {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct spoolss_AddForm {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		union spoolss_AddFormInfo info;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_DeleteForm {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *form_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_GetForm {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *form_name;/* [charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_FormInfo *info;/* [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */
		uint32_t needed;
		WERROR result;
	} out;

};


struct spoolss_SetForm {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *form_name;/* [charset(UTF16)] */
		uint32_t level;
		union spoolss_AddFormInfo info;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct _spoolss_EnumForms {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumForms {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_FormInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumForms {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_FormInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct _spoolss_EnumPorts {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumPorts {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_PortInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumPorts {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_PortInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct _spoolss_EnumMonitors {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct __spoolss_EnumMonitors {
	struct {
		uint32_t level;
		uint32_t count;
	} in;

	struct {
		union spoolss_MonitorInfo *info;/* [switch_is(level)] */
	} out;

};


struct spoolss_EnumMonitors {
	struct {
		const char *servername;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
	} in;

	struct {
		union spoolss_MonitorInfo *info;/* [unique,switch_is(level),size_is(count)] */
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_AddPort {
	struct {
		const char *server_name;/* [unique,charset(UTF16)] */
		uint32_t unknown;
		const char *monitor_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_ConfigurePort {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePort {
	struct {
		WERROR result;
	} out;

};


struct spoolss_CreatePrinterIC {
	struct {
		WERROR result;
	} out;

};


struct spoolss_PlayGDIScriptOnPrinterIC {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterIC {
	struct {
		WERROR result;
	} out;

};


struct spoolss_AddPrinterConnection {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterConnection {
	struct {
		WERROR result;
	} out;

};


struct spoolss_PrinterMessageBox {
	struct {
		WERROR result;
	} out;

};


struct spoolss_AddMonitor {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeleteMonitor {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrintProcessor {
	struct {
		WERROR result;
	} out;

};


struct spoolss_AddPrintProvidor {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrintProvidor {
	struct {
		WERROR result;
	} out;

};


struct spoolss_EnumPrintProcDataTypes {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ResetPrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_GetPrinterDriver2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *architecture;/* [unique,charset(UTF16)] */
		uint32_t level;
		DATA_BLOB *buffer;/* [unique] */
		uint32_t offered;
		uint32_t client_major_version;
		uint32_t client_minor_version;
	} in;

	struct {
		DATA_BLOB *info;/* [unique] */
		uint32_t needed;
		uint32_t server_major_version;
		uint32_t server_minor_version;
		WERROR result;
	} out;

};


struct spoolss_FindFirstPrinterChangeNotification {
	struct {
		WERROR result;
	} out;

};


struct spoolss_FindNextPrinterChangeNotification {
	struct {
		WERROR result;
	} out;

};


struct spoolss_FindClosePrinterNotify {
	struct {
		WERROR result;
	} out;

};


struct spoolss_RouterFindFirstPrinterChangeNotificationOld {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ReplyOpenPrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_RouterReplyPrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ReplyClosePrinter {
	struct {
		WERROR result;
	} out;

};


struct spoolss_AddPortEx {
	struct {
		WERROR result;
	} out;

};


struct spoolss_RouterFindFirstPrinterChangeNotification {
	struct {
		WERROR result;
	} out;

};


struct spoolss_SpoolerInit {
	struct {
		WERROR result;
	} out;

};


struct spoolss_ResetPrinterEx {
	struct {
		WERROR result;
	} out;

};


struct spoolss_RemoteFindFirstPrinterChangeNotifyEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t u1;
		uint32_t u2;
		const char *str;/* [unique,charset(UTF16)] */
		uint32_t u3;
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1 *t1;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_RouterRefreshPrinterChangeNotification {
	struct {
		WERROR result;
	} out;

};


struct spoolss_RemoteFindNextPrinterChangeNotifyEx {
	struct {
		WERROR result;
	} out;

};


struct spoolss_44 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_OpenPrinterEx {
	struct {
		const char *printername;/* [unique,charset(UTF16)] */
		const char *datatype;/* [unique,charset(UTF16)] */
		struct spoolss_DevmodeContainer devmode_ctr;
		uint32_t access_mask;
		uint32_t level;
		union spoolss_UserLevel userlevel;/* [switch_is(level)] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		WERROR result;
	} out;

};


struct spoolss_AddPrinterEx {
	struct {
		const char *server;/* [unique,charset(UTF16)] */
		uint32_t level;
		union spoolss_PrinterInfo *info;/* [unique,switch_is(level)] */
		struct spoolss_DevmodeContainer devmode_ctr;
		struct security_descriptor *secdesc;/* [unique] */
		uint32_t ulevel;
		union spoolss_UserLevel userlevel;/* [switch_is(ulevel)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_47 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_EnumPrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t enum_index;
		uint32_t value_offered;
		uint32_t *data_size;/* [ref] */
	} in;

	struct {
		const char * value_name;/* [flag(LIBNDR_FLAG_STR_SIZE4)] */
		uint32_t value_needed;
		uint32_t printerdata_type;
		DATA_BLOB buffer;
		uint32_t *data_size;/* [ref] */
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *value_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_4a {
	struct {
		WERROR result;
	} out;

};


struct spoolss_4b {
	struct {
		WERROR result;
	} out;

};


struct spoolss_4c {
	struct {
		WERROR result;
	} out;

};


struct spoolss_SetPrinterDataEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *key_name;/* [charset(UTF16)] */
		const char *value_name;/* [charset(UTF16)] */
		uint32_t type;
		DATA_BLOB buffer;
		uint32_t offered;
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_GetPrinterDataEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *key_name;/* [charset(UTF16)] */
		const char *value_name;/* [charset(UTF16)] */
		uint32_t offered;
	} in;

	struct {
		uint32_t type;
		DATA_BLOB buffer;
		uint32_t needed;
		WERROR result;
	} out;

};


struct spoolss_EnumPrinterDataEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *key_name;/* [charset(UTF16)] */
		uint32_t offered;
	} in;

	struct {
		DATA_BLOB buffer;
		uint32_t needed;
		uint32_t count;
		WERROR result;
	} out;

};


struct spoolss_EnumPrinterKey {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterDataEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *key_name;/* [charset(UTF16)] */
		const char *value_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterKey {
	struct {
		WERROR result;
	} out;

};


struct spoolss_53 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_DeletePrinterDriverEx {
	struct {
		WERROR result;
	} out;

};


struct spoolss_55 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_56 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_57 {
	struct {
		WERROR result;
	} out;

};


struct spoolss_XcvData {
	struct {
		struct policy_handle *handle;/* [ref] */
		const char *function_name;/* [charset(UTF16)] */
		DATA_BLOB in_data;
		uint32_t _in_data_length;/* [value(r->in.in_data.length)] */
		uint32_t offered;
		uint32_t unknown1;
	} in;

	struct {
		DATA_BLOB out_data;
		uint32_t needed;
		uint32_t unknown2;
		WERROR result;
	} out;

};


struct spoolss_AddPrinterDriverEx {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5a {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5b {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5c {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5d {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5e {
	struct {
		WERROR result;
	} out;

};


struct spoolss_5f {
	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_spoolss */
