/* This file is autogenerated by pidl. DO NOT EDIT */
%module svcctl

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_svcctl_c.h"
#include "librpc/gen_ndr/svcctl.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(svcctl_ServerType);


%inline {
struct svcctl { struct dcerpc_pipe *pipe; };
}

%extend svcctl {
	svcctl (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct svcctl *ret = talloc(mem_ctx, struct svcctl);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_svcctl, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~svcctl() {
		talloc_free(self);
	}
	
	/* svcctl_CloseServiceHandle */
	WERROR CloseServiceHandle(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_CloseServiceHandle r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_svcctl_CloseServiceHandle(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* svcctl_ControlService */
	WERROR ControlService(struct policy_handle *handle, uint32_t control, struct SERVICE_STATUS *status, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_ControlService r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.control = control;
		
		status = dcerpc_svcctl_ControlService(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		return r.out.result;
	}
	
	/* svcctl_DeleteService */
	WERROR DeleteService(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_DeleteService r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_svcctl_DeleteService(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_LockServiceDatabase */
	WERROR LockServiceDatabase(struct policy_handle *handle, struct policy_handle lock, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_LockServiceDatabase r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_svcctl_LockServiceDatabase(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: lock [out] argument is not a pointer */
		*lock = *r.out.lock;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceObjectSecurity */
	WERROR QueryServiceObjectSecurity(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceObjectSecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_QueryServiceObjectSecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_SetServiceObjectSecurity */
	WERROR SetServiceObjectSecurity(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_SetServiceObjectSecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_SetServiceObjectSecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_QueryServiceStatus */
	WERROR QueryServiceStatus(struct policy_handle *handle, struct SERVICE_STATUS *status, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceStatus r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_svcctl_QueryServiceStatus(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		return r.out.result;
	}
	
	/* svcctl_SetServiceStatus */
	WERROR SetServiceStatus(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_SetServiceStatus r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_SetServiceStatus(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_UnlockServiceDatabase */
	WERROR UnlockServiceDatabase(struct policy_handle *lock, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_UnlockServiceDatabase r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.lock = lock;
		
		status = dcerpc_svcctl_UnlockServiceDatabase(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*lock = *r.out.lock;
		return r.out.result;
	}
	
	/* svcctl_NotifyBootConfigStatus */
	WERROR NotifyBootConfigStatus(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_NotifyBootConfigStatus r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_NotifyBootConfigStatus(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_SCSetServiceBitsW */
	WERROR SCSetServiceBitsW(struct policy_handle *handle, uint32_t bits, uint32_t bitson, uint32_t immediate, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_SCSetServiceBitsW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.bits = bits;
		r.in.bitson = bitson;
		r.in.immediate = immediate;
		
		status = dcerpc_svcctl_SCSetServiceBitsW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_ChangeServiceConfigW */
	WERROR ChangeServiceConfigW(struct policy_handle *handle, uint32_t type, uint32_t start, uint32_t error, const char *binary_path, const char *load_order_group, uint32_t tag_id, const char *dependencies, const char *service_start_name, const char *password, const char *display_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_ChangeServiceConfigW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.type = type;
		r.in.start = start;
		r.in.error = error;
		r.in.binary_path = binary_path;
		r.in.load_order_group = load_order_group;
		r.in.dependencies = dependencies;
		r.in.service_start_name = service_start_name;
		r.in.password = password;
		r.in.display_name = display_name;
		
		status = dcerpc_svcctl_ChangeServiceConfigW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: tag_id [out] argument is not a pointer */
		*tag_id = *r.out.tag_id;
		return r.out.result;
	}
	
	/* svcctl_CreateServiceW */
	WERROR CreateServiceW(struct policy_handle *scmanager_handle, const char *ServiceName, const char *DisplayName, uint32_t desired_access, uint32_t type, uint32_t start_type, uint32_t error_control, const char *binary_path, const char *LoadOrderGroupKey, uint32_t *TagId, uint8_t *dependencies, uint32_t dependencies_size, const char *service_start_name, uint8_t *password, uint32_t password_size, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_CreateServiceW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.scmanager_handle = scmanager_handle;
		r.in.ServiceName = ServiceName;
		r.in.DisplayName = DisplayName;
		r.in.desired_access = desired_access;
		r.in.type = type;
		r.in.start_type = start_type;
		r.in.error_control = error_control;
		r.in.binary_path = binary_path;
		r.in.LoadOrderGroupKey = LoadOrderGroupKey;
		r.in.TagId = TagId;
		r.in.dependencies = dependencies;
		r.in.dependencies_size = dependencies_size;
		r.in.service_start_name = service_start_name;
		r.in.password = password;
		r.in.password_size = password_size;
		
		status = dcerpc_svcctl_CreateServiceW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*TagId = *r.out.TagId;
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* svcctl_EnumDependentServicesW */
	WERROR EnumDependentServicesW(struct policy_handle *service, uint32_t state, struct ENUM_SERVICE_STATUS *status, uint32_t buf_size, uint32_t bytes_needed, uint32_t services_returned, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_EnumDependentServicesW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.service = service;
		r.in.state = state;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_EnumDependentServicesW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: services_returned [out] argument is not a pointer */
		*services_returned = *r.out.services_returned;
		return r.out.result;
	}
	
	/* svcctl_EnumServicesStatusW */
	WERROR EnumServicesStatusW(struct policy_handle *handle, uint32_t type, uint32_t state, uint32_t buf_size, uint8_t *service, uint32_t bytes_needed, uint32_t services_returned, uint32_t *resume_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_EnumServicesStatusW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.type = type;
		r.in.state = state;
		r.in.buf_size = buf_size;
		r.in.resume_handle = resume_handle;
		
		status = dcerpc_svcctl_EnumServicesStatusW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: service [out] argument is not a pointer */
		*service = *r.out.service;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: services_returned [out] argument is not a pointer */
		*services_returned = *r.out.services_returned;
		*resume_handle = *r.out.resume_handle;
		return r.out.result;
	}
	
	/* svcctl_OpenSCManagerW */
	WERROR OpenSCManagerW(const char *MachineName, const char *DatabaseName, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_OpenSCManagerW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.MachineName = MachineName;
		r.in.DatabaseName = DatabaseName;
		r.in.access_mask = access_mask;
		
		status = dcerpc_svcctl_OpenSCManagerW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* svcctl_OpenServiceW */
	WERROR OpenServiceW(struct policy_handle *scmanager_handle, const char *ServiceName, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_OpenServiceW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.scmanager_handle = scmanager_handle;
		r.in.ServiceName = ServiceName;
		r.in.access_mask = access_mask;
		
		status = dcerpc_svcctl_OpenServiceW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceConfigW */
	WERROR QueryServiceConfigW(struct policy_handle *handle, uint8_t *query, uint32_t buf_size, uint32_t bytes_needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceConfigW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceConfigW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: query [out] argument is not a pointer */
		*query = *r.out.query;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceLockStatusW */
	WERROR QueryServiceLockStatusW(struct policy_handle *handle, uint32_t buf_size, struct SERVICE_LOCK_STATUS *status, uint32_t *required_buf_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceLockStatusW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceLockStatusW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		*required_buf_size = *r.out.required_buf_size;
		return r.out.result;
	}
	
	/* svcctl_StartServiceW */
	WERROR StartServiceW(struct policy_handle *handle, uint32_t NumArgs, const char *Arguments, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_StartServiceW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.NumArgs = NumArgs;
		r.in.Arguments = Arguments;
		
		status = dcerpc_svcctl_StartServiceW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_GetServiceDisplayNameW */
	WERROR GetServiceDisplayNameW(struct policy_handle *handle, const char *service_name, const char *display_name, uint32_t *display_name_length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_GetServiceDisplayNameW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.service_name = service_name;
		r.in.display_name_length = display_name_length;
		
		status = dcerpc_svcctl_GetServiceDisplayNameW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*display_name = *r.out.display_name;
		*display_name_length = *r.out.display_name_length;
		return r.out.result;
	}
	
	/* svcctl_GetServiceKeyNameW */
	WERROR GetServiceKeyNameW(struct policy_handle *handle, const char *service_name, const char *key_name, uint32_t *display_name_length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_GetServiceKeyNameW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.service_name = service_name;
		r.in.display_name_length = display_name_length;
		
		status = dcerpc_svcctl_GetServiceKeyNameW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*key_name = *r.out.key_name;
		*display_name_length = *r.out.display_name_length;
		return r.out.result;
	}
	
	/* svcctl_SCSetServiceBitsA */
	WERROR SCSetServiceBitsA(struct policy_handle *handle, uint32_t bits, uint32_t bitson, uint32_t immediate, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_SCSetServiceBitsA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.bits = bits;
		r.in.bitson = bitson;
		r.in.immediate = immediate;
		
		status = dcerpc_svcctl_SCSetServiceBitsA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_ChangeServiceConfigA */
	WERROR ChangeServiceConfigA(struct policy_handle *handle, uint32_t type, uint32_t start, uint32_t error, const char *binary_path, const char *load_order_group, uint32_t tag_id, const char *dependencies, const char *service_start_name, const char *password, const char *display_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_ChangeServiceConfigA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.type = type;
		r.in.start = start;
		r.in.error = error;
		r.in.binary_path = binary_path;
		r.in.load_order_group = load_order_group;
		r.in.dependencies = dependencies;
		r.in.service_start_name = service_start_name;
		r.in.password = password;
		r.in.display_name = display_name;
		
		status = dcerpc_svcctl_ChangeServiceConfigA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: tag_id [out] argument is not a pointer */
		*tag_id = *r.out.tag_id;
		return r.out.result;
	}
	
	/* svcctl_CreateServiceA */
	WERROR CreateServiceA(struct policy_handle *handle, const char *ServiceName, const char *DisplayName, uint32_t desired_access, uint32_t type, uint32_t start_type, uint32_t error_control, const char *binary_path, const char *LoadOrderGroupKey, uint32_t *TagId, const char *dependencies, const char *service_start_name, const char *password, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_CreateServiceA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.ServiceName = ServiceName;
		r.in.DisplayName = DisplayName;
		r.in.desired_access = desired_access;
		r.in.type = type;
		r.in.start_type = start_type;
		r.in.error_control = error_control;
		r.in.binary_path = binary_path;
		r.in.LoadOrderGroupKey = LoadOrderGroupKey;
		r.in.dependencies = dependencies;
		r.in.service_start_name = service_start_name;
		r.in.password = password;
		
		status = dcerpc_svcctl_CreateServiceA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*TagId = *r.out.TagId;
		return r.out.result;
	}
	
	/* svcctl_EnumDependentServicesA */
	WERROR EnumDependentServicesA(struct policy_handle *service, uint32_t state, struct ENUM_SERVICE_STATUS *status, uint32_t buf_size, uint32_t bytes_needed, uint32_t services_returned, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_EnumDependentServicesA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.service = service;
		r.in.state = state;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_EnumDependentServicesA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: services_returned [out] argument is not a pointer */
		*services_returned = *r.out.services_returned;
		return r.out.result;
	}
	
	/* svcctl_EnumServicesStatusA */
	WERROR EnumServicesStatusA(struct policy_handle *handle, uint32_t type, uint32_t state, uint32_t buf_size, uint8_t *service, uint32_t bytes_needed, uint32_t services_returned, uint32_t *resume_handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_EnumServicesStatusA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.type = type;
		r.in.state = state;
		r.in.buf_size = buf_size;
		r.in.resume_handle = resume_handle;
		
		status = dcerpc_svcctl_EnumServicesStatusA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: service [out] argument is not a pointer */
		*service = *r.out.service;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: services_returned [out] argument is not a pointer */
		*services_returned = *r.out.services_returned;
		*resume_handle = *r.out.resume_handle;
		return r.out.result;
	}
	
	/* svcctl_OpenSCManagerA */
	WERROR OpenSCManagerA(const char *MachineName, const char *DatabaseName, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_OpenSCManagerA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.MachineName = MachineName;
		r.in.DatabaseName = DatabaseName;
		r.in.access_mask = access_mask;
		
		status = dcerpc_svcctl_OpenSCManagerA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* svcctl_OpenServiceA */
	WERROR OpenServiceA(struct policy_handle *scmanager_handle, const char *ServiceName, uint32_t access_mask, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_OpenServiceA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.scmanager_handle = scmanager_handle;
		r.in.ServiceName = ServiceName;
		r.in.access_mask = access_mask;
		
		status = dcerpc_svcctl_OpenServiceA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_QueryServiceConfigA */
	WERROR QueryServiceConfigA(struct policy_handle *handle, uint8_t *query, uint32_t buf_size, uint32_t bytes_needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceConfigA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceConfigA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: query [out] argument is not a pointer */
		*query = *r.out.query;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceLockStatusA */
	WERROR QueryServiceLockStatusA(struct policy_handle *handle, uint32_t buf_size, struct SERVICE_LOCK_STATUS *status, uint32_t *required_buf_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceLockStatusA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceLockStatusA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*status = *r.out.status;
		*required_buf_size = *r.out.required_buf_size;
		return r.out.result;
	}
	
	/* svcctl_StartServiceA */
	WERROR StartServiceA(struct policy_handle *handle, uint32_t NumArgs, const char *Arguments, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_StartServiceA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.NumArgs = NumArgs;
		r.in.Arguments = Arguments;
		
		status = dcerpc_svcctl_StartServiceA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_GetServiceDisplayNameA */
	WERROR GetServiceDisplayNameA(struct policy_handle *handle, const char *service_name, const char *display_name, uint32_t *display_name_length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_GetServiceDisplayNameA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.service_name = service_name;
		r.in.display_name_length = display_name_length;
		
		status = dcerpc_svcctl_GetServiceDisplayNameA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*display_name = *r.out.display_name;
		*display_name_length = *r.out.display_name_length;
		return r.out.result;
	}
	
	/* svcctl_GetServiceKeyNameA */
	WERROR GetServiceKeyNameA(struct policy_handle *handle, const char *service_name, const char *key_name, uint32_t *display_name_length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_GetServiceKeyNameA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.service_name = service_name;
		r.in.display_name_length = display_name_length;
		
		status = dcerpc_svcctl_GetServiceKeyNameA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*key_name = *r.out.key_name;
		*display_name_length = *r.out.display_name_length;
		return r.out.result;
	}
	
	/* svcctl_GetCurrentGroupeStateW */
	WERROR GetCurrentGroupeStateW(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_GetCurrentGroupeStateW r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_GetCurrentGroupeStateW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_EnumServiceGroupW */
	WERROR EnumServiceGroupW(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_EnumServiceGroupW r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_EnumServiceGroupW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_ChangeServiceConfig2A */
	WERROR ChangeServiceConfig2A(struct policy_handle *handle, uint32_t info_level, uint8_t *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_ChangeServiceConfig2A r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info_level = info_level;
		r.in.info = info;
		
		status = dcerpc_svcctl_ChangeServiceConfig2A(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_ChangeServiceConfig2W */
	WERROR ChangeServiceConfig2W(struct policy_handle *handle, uint32_t info_level, uint8_t *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_ChangeServiceConfig2W r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info_level = info_level;
		r.in.info = info;
		
		status = dcerpc_svcctl_ChangeServiceConfig2W(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* svcctl_QueryServiceConfig2A */
	WERROR QueryServiceConfig2A(struct policy_handle *handle, uint32_t info_level, uint8_t *buffer, uint32_t buf_size, uint32_t bytes_needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceConfig2A r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info_level = info_level;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceConfig2A(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceConfig2W */
	WERROR QueryServiceConfig2W(struct policy_handle *handle, uint32_t info_level, uint8_t *buffer, uint32_t buf_size, uint32_t bytes_needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceConfig2W r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info_level = info_level;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceConfig2W(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		return r.out.result;
	}
	
	/* svcctl_QueryServiceStatusEx */
	WERROR QueryServiceStatusEx(struct policy_handle *handle, uint32_t info_level, uint8_t *buffer, uint32_t buf_size, uint32_t bytes_needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_QueryServiceStatusEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.info_level = info_level;
		r.in.buf_size = buf_size;
		
		status = dcerpc_svcctl_QueryServiceStatusEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		return r.out.result;
	}
	
	/* EnumServicesStatusExA */
	WERROR EnumServicesStatusExA(struct policy_handle *scmanager, uint32_t info_level, uint32_t type, uint32_t state, uint8_t *services, uint32_t buf_size, uint32_t bytes_needed, uint32_t service_returned, uint32_t *resume_handle, const char *group_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EnumServicesStatusExA r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.scmanager = scmanager;
		r.in.info_level = info_level;
		r.in.type = type;
		r.in.state = state;
		r.in.buf_size = buf_size;
		r.in.resume_handle = resume_handle;
		
		status = dcerpc_EnumServicesStatusExA(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: services [out] argument is not a pointer */
		*services = *r.out.services;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: service_returned [out] argument is not a pointer */
		*service_returned = *r.out.service_returned;
		*resume_handle = *r.out.resume_handle;
		*group_name = *r.out.group_name;
		return r.out.result;
	}
	
	/* EnumServicesStatusExW */
	WERROR EnumServicesStatusExW(struct policy_handle *scmanager, uint32_t info_level, uint32_t type, uint32_t state, uint8_t *services, uint32_t buf_size, uint32_t bytes_needed, uint32_t service_returned, uint32_t *resume_handle, const char *group_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct EnumServicesStatusExW r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.scmanager = scmanager;
		r.in.info_level = info_level;
		r.in.type = type;
		r.in.state = state;
		r.in.buf_size = buf_size;
		r.in.resume_handle = resume_handle;
		
		status = dcerpc_EnumServicesStatusExW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: services [out] argument is not a pointer */
		*services = *r.out.services;
		/* FIXME: bytes_needed [out] argument is not a pointer */
		*bytes_needed = *r.out.bytes_needed;
		/* FIXME: service_returned [out] argument is not a pointer */
		*service_returned = *r.out.service_returned;
		*resume_handle = *r.out.resume_handle;
		*group_name = *r.out.group_name;
		return r.out.result;
	}
	
	/* svcctl_SCSendTSMessage */
	WERROR SCSendTSMessage(TALLOC_CTX *mem_ctx = NULL)
	{
		struct svcctl_SCSendTSMessage r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_svcctl_SCSendTSMessage(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* SERVICE_LOCK_STATUS */
/* SERVICE_STATUS */
/* ENUM_SERVICE_STATUS */
/* svcctl_ServerType */
/* SERVICE_CONTROL */

