/* This file is autogenerated by pidl. DO NOT EDIT */
%module winreg

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_winreg_c.h"
#include "librpc/gen_ndr/winreg.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(winreg_String);


%inline {
struct winreg { struct dcerpc_pipe *pipe; };
}

%extend winreg {
	winreg (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct winreg *ret = talloc(mem_ctx, struct winreg);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_winreg, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~winreg() {
		talloc_free(self);
	}
	
	/* winreg_OpenHKCR */
	WERROR OpenHKCR(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKCR r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKCR(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKCU */
	WERROR OpenHKCU(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKCU r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKCU(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKLM */
	WERROR OpenHKLM(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKLM r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKLM(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKPD */
	WERROR OpenHKPD(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKPD r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKPD(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKU */
	WERROR OpenHKU(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKU r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKU(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_CloseKey */
	WERROR CloseKey(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_CloseKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_winreg_CloseKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_CreateKey */
	WERROR CreateKey(struct policy_handle *handle, struct winreg_String name, struct winreg_String keyclass, uint32_t options, uint32_t access_mask, struct winreg_SecBuf *secdesc, struct policy_handle *new_handle, enum winreg_CreateAction *action_taken, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_CreateKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.keyclass = keyclass;
		r.in.options = options;
		r.in.access_mask = access_mask;
		r.in.secdesc = secdesc;
		r.in.action_taken = action_taken;
		
		status = dcerpc_winreg_CreateKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*new_handle = *r.out.new_handle;
		*action_taken = *r.out.action_taken;
		return r.out.result;
	}
	
	/* winreg_DeleteKey */
	WERROR DeleteKey(struct policy_handle *handle, struct winreg_String key, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_DeleteKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.key = key;
		
		status = dcerpc_winreg_DeleteKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_DeleteValue */
	WERROR DeleteValue(struct policy_handle *handle, struct winreg_String value, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_DeleteValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value = value;
		
		status = dcerpc_winreg_DeleteValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_EnumKey */
	WERROR EnumKey(struct policy_handle *handle, uint32_t enum_index, struct winreg_StringBuf *name, struct winreg_StringBuf *keyclass, NTTIME *last_changed_time, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_EnumKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.enum_index = enum_index;
		r.in.name = name;
		r.in.keyclass = keyclass;
		r.in.last_changed_time = last_changed_time;
		
		status = dcerpc_winreg_EnumKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*name = *r.out.name;
		*keyclass = *r.out.keyclass;
		*last_changed_time = *r.out.last_changed_time;
		return r.out.result;
	}
	
	/* winreg_EnumValue */
	WERROR EnumValue(struct policy_handle *handle, uint32_t enum_index, struct winreg_StringBuf *name, enum winreg_Type *type, uint8_t *value, uint32_t *size, uint32_t *length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_EnumValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.enum_index = enum_index;
		r.in.name = name;
		r.in.type = type;
		r.in.value = value;
		r.in.size = size;
		r.in.length = length;
		
		status = dcerpc_winreg_EnumValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*name = *r.out.name;
		*type = *r.out.type;
		*value = *r.out.value;
		*size = *r.out.size;
		*length = *r.out.length;
		return r.out.result;
	}
	
	/* winreg_FlushKey */
	WERROR FlushKey(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_FlushKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_winreg_FlushKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_GetKeySecurity */
	WERROR GetKeySecurity(struct policy_handle *handle, uint32_t sec_info, struct KeySecurityData *sd, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_GetKeySecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.sec_info = sec_info;
		r.in.sd = sd;
		
		status = dcerpc_winreg_GetKeySecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sd = *r.out.sd;
		return r.out.result;
	}
	
	/* winreg_LoadKey */
	WERROR LoadKey(struct policy_handle *handle, struct winreg_String *keyname, struct winreg_String *filename, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_LoadKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.keyname = keyname;
		r.in.filename = filename;
		
		status = dcerpc_winreg_LoadKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_NotifyChangeKeyValue */
	WERROR NotifyChangeKeyValue(struct policy_handle *handle, uint8_t watch_subtree, uint32_t notify_filter, uint32_t unknown, struct winreg_String string1, struct winreg_String string2, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_NotifyChangeKeyValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.watch_subtree = watch_subtree;
		r.in.notify_filter = notify_filter;
		r.in.unknown = unknown;
		r.in.string1 = string1;
		r.in.string2 = string2;
		r.in.unknown2 = unknown2;
		
		status = dcerpc_winreg_NotifyChangeKeyValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_OpenKey */
	WERROR OpenKey(struct policy_handle *parent_handle, struct winreg_String keyname, uint32_t unknown, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.parent_handle = parent_handle;
		r.in.keyname = keyname;
		r.in.unknown = unknown;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_QueryInfoKey */
	WERROR QueryInfoKey(struct policy_handle *handle, struct winreg_String class_in, struct winreg_String *class_out, uint32_t *num_subkeys, uint32_t *max_subkeylen, uint32_t *max_subkeysize, uint32_t *num_values, uint32_t *max_valnamelen, uint32_t *max_valbufsize, uint32_t *secdescsize, NTTIME *last_changed_time, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_QueryInfoKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.class_in = class_in;
		
		status = dcerpc_winreg_QueryInfoKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*class_out = *r.out.class_out;
		*num_subkeys = *r.out.num_subkeys;
		*max_subkeylen = *r.out.max_subkeylen;
		*max_subkeysize = *r.out.max_subkeysize;
		*num_values = *r.out.num_values;
		*max_valnamelen = *r.out.max_valnamelen;
		*max_valbufsize = *r.out.max_valbufsize;
		*secdescsize = *r.out.secdescsize;
		*last_changed_time = *r.out.last_changed_time;
		return r.out.result;
	}
	
	/* winreg_QueryValue */
	WERROR QueryValue(struct policy_handle *handle, struct winreg_String value_name, enum winreg_Type *type, uint8_t *data, uint32_t *size, uint32_t *length, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_QueryValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		r.in.type = type;
		r.in.data = data;
		r.in.size = size;
		r.in.length = length;
		
		status = dcerpc_winreg_QueryValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*type = *r.out.type;
		*data = *r.out.data;
		*size = *r.out.size;
		*length = *r.out.length;
		return r.out.result;
	}
	
	/* winreg_ReplaceKey */
	WERROR ReplaceKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_ReplaceKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_ReplaceKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_RestoreKey */
	WERROR RestoreKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_RestoreKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_RestoreKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_SaveKey */
	WERROR SaveKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_SaveKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_SaveKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_SetKeySecurity */
	WERROR SetKeySecurity(struct policy_handle *handle, uint32_t access_mask, struct KeySecurityData *sd, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_SetKeySecurity r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.access_mask = access_mask;
		r.in.sd = sd;
		
		status = dcerpc_winreg_SetKeySecurity(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*sd = *r.out.sd;
		return r.out.result;
	}
	
	/* winreg_SetValue */
	WERROR SetValue(struct policy_handle *handle, struct winreg_String name, enum winreg_Type type, uint8_t *data, uint32_t size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_SetValue r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.name = name;
		r.in.type = type;
		r.in.data = data;
		r.in.size = size;
		
		status = dcerpc_winreg_SetValue(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_UnLoadKey */
	WERROR UnLoadKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_UnLoadKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_UnLoadKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_InitiateSystemShutdown */
	WERROR InitiateSystemShutdown(uint16_t *hostname, struct initshutdown_String *message, uint32_t timeout, uint8_t force_apps, uint8_t reboot, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_InitiateSystemShutdown r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.hostname = hostname;
		r.in.message = message;
		r.in.timeout = timeout;
		r.in.force_apps = force_apps;
		r.in.reboot = reboot;
		
		status = dcerpc_winreg_InitiateSystemShutdown(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_AbortSystemShutdown */
	WERROR AbortSystemShutdown(uint16_t *server, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_AbortSystemShutdown r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		
		status = dcerpc_winreg_AbortSystemShutdown(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_GetVersion */
	WERROR GetVersion(struct policy_handle *handle, uint32_t *version, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_GetVersion r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_winreg_GetVersion(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*version = *r.out.version;
		return r.out.result;
	}
	
	/* winreg_OpenHKCC */
	WERROR OpenHKCC(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKCC r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKCC(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKDD */
	WERROR OpenHKDD(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKDD r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKDD(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_QueryMultipleValues */
	WERROR QueryMultipleValues(struct policy_handle *key_handle, struct QueryMultipleValue *values, uint32_t num_values, uint8_t *buffer, uint32_t *buffer_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_QueryMultipleValues r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.key_handle = key_handle;
		r.in.values = values;
		r.in.num_values = num_values;
		r.in.buffer = buffer;
		r.in.buffer_size = buffer_size;
		
		status = dcerpc_winreg_QueryMultipleValues(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*values = *r.out.values;
		*buffer = *r.out.buffer;
		*buffer_size = *r.out.buffer_size;
		return r.out.result;
	}
	
	/* winreg_InitiateSystemShutdownEx */
	WERROR InitiateSystemShutdownEx(uint16_t *hostname, struct initshutdown_String *message, uint32_t timeout, uint8_t force_apps, uint8_t reboot, uint32_t reason, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_InitiateSystemShutdownEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.hostname = hostname;
		r.in.message = message;
		r.in.timeout = timeout;
		r.in.force_apps = force_apps;
		r.in.reboot = reboot;
		r.in.reason = reason;
		
		status = dcerpc_winreg_InitiateSystemShutdownEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_SaveKeyEx */
	WERROR SaveKeyEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_SaveKeyEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_SaveKeyEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* winreg_OpenHKPT */
	WERROR OpenHKPT(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKPT r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKPT(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_OpenHKPN */
	WERROR OpenHKPN(uint16_t *system_name, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_OpenHKPN r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.system_name = system_name;
		r.in.access_mask = access_mask;
		
		status = dcerpc_winreg_OpenHKPN(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* winreg_QueryMultipleValues2 */
	WERROR QueryMultipleValues2(TALLOC_CTX *mem_ctx = NULL)
	{
		struct winreg_QueryMultipleValues2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_winreg_QueryMultipleValues2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* winreg_AccessMask */
/* winreg_Type */
/* winreg_String */
/* KeySecurityData */
/* winreg_SecBuf */
/* winreg_CreateAction */
/* winreg_StringBuf */
/* QueryMultipleValue */

