{type:"doctree",attributes:{"hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"api","fullName":"api","name":"api","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"api","fullName":"api.ClassViewer","name":"ClassViewer","hasWarning":"true","superClass":"qx.ui.embed.HtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Shows the class details.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_constantHasDetails"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the constant was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks whether a constant has details.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the constant has details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_createConstantInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the constant was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"showDetails"},children:[{type:"desc",attributes:{"text":"<p>whether to show the details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the information about a constant.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the information about the constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createDescHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the item was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"showDetails"},children:[{type:"desc",attributes:{"text":"<p>whether to show details. If <code>false</code> only the first sentence of the description will be shown.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the description of an item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the description.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createDescriptionHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"description"},children:[{type:"desc",attributes:{"text":"<p>the description.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"packageBaseClass"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class to use for auto-adding packages.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map,null"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates <span class=\"caps\">HTML</span> that replaces all &#64;link-attributes with links.</p>"}}]},{type:"method",attributes:{"name":"_createErrorHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the item was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the documentation errors of an item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the documentation errors.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createEventInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the event was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"showDetails"},children:[{type:"desc",attributes:{"text":"<p>whether to show the details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the information about an event.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the information about the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createInfoPanel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type to create the info panel for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"listName"},children:[{type:"desc",attributes:{"text":"<p>the name of the node list in the class doc node where the items shown by this info panel are stored.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"labelText"},children:[{type:"desc",attributes:{"text":"<p>the label text describing the node type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"infoFactory"},children:[{type:"desc",attributes:{"text":"<p>the factory method creating the <span class=\"caps\">HTML</span> for one item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"function"}}]}]},{type:"param",attributes:{"name":"hasDetailDecider"},children:[{type:"desc",attributes:{"text":"<p>a function returning <code>true</code> when a item has details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"function"}}]}]},{type:"param",attributes:{"name":"addInheritedCheckBox"},children:[{type:"desc",attributes:{"text":"<p>whether to add a &#8220;show inherited&#8230;&#8221; checkbox.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]},{type:"param",attributes:{"name":"isOpen"},children:[{type:"desc",attributes:{"text":"<p>whether the info panel is open by default.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates an info panel. An info panel shows the information about one item type (e.g. for public methods).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> for the info panel.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createItemLinkHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"linkText"},children:[{type:"desc",attributes:{"text":"<p>the link text (e.g. &#8220;mypackage.MyClass#myMethod alt text&#8221;)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"packageBaseClass"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class to use when auto-adding the package to a class name having no package specified. If null, no automatic package addition is done.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map,null"}}]}]},{type:"param",attributes:{"name":"useIcon"},children:[{type:"desc",attributes:{"text":"<p>whether to add an icon to the link.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean,true"}}]}]},{type:"param",attributes:{"name":"useShortName"},children:[{type:"desc",attributes:{"text":"<p>whether to use the short name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean,false"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> for a link to an item.</p>"}}]},{type:"method",attributes:{"name":"_createMethodInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the method was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"showDetails"},children:[{type:"desc",attributes:{"text":"<p>whether to show the details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the information about a method.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the information about the method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createPropertyInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the property was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"showDetails"},children:[{type:"desc",attributes:{"text":"<p>whether to show the details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the information about a property.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the information about the property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createSeeAlsoHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the item was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the &#64;see attributes of an item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the &#64;see attributes.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_createTypeHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"typeNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node to show the type for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"packageBaseClass"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class <code>typeNode</code> belongs to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"defaultType"},children:[{type:"desc",attributes:{"text":"<p>the type name to use if <code>typeNode</code> is <code>null</code> or defines no type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"useShortName"},children:[{type:"desc",attributes:{"text":"<p>whether to use short class names (without package).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean,true"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing the type of a doc node.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> showing the type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"_descHasDetails"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether the description of an item has details (has more than one sentence).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the description of an item has details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_eventHasDetails"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the event was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks whether an event has details.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the event has details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_extractFirstSentence"},children:[{type:"params",children:[{type:"param",attributes:{"name":"text"},children:[{type:"desc",attributes:{"text":"<p>the text.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Extracts the first sentence from a text.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the first sentence from the text.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"hasError":"true","name":"_fixLinks"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"22"}}]}]},{type:"method",attributes:{"name":"_getClassDocNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"className"},children:[{type:"desc",attributes:{"text":"<p>the name of the class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the doc node of a class.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the doc node of the class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"_getItemElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>the item&#8217;s name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the <span class=\"caps\">HTML</span> element showing the details of an item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> element showing the details of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"name":"_getTypeForItemNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"itemNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the node type for a doc node.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the item&#8217;s node type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"_hasErrorHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks whether a item has documentation errors.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the item has documentation errors.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_hasSeeAlsoHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks whether a item has &#64;see attributes.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the item has &#64;see attributes.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_methodHasDetails"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"fromClassNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class the method was defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks whether a method has details.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the method has details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_onInheritedCheckBoxClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of which the inherited-checkbox was clicked.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the user clicked on a &#8220;show inherited&#8230;&#8221; checkbox.</p>"}}]},{type:"method",attributes:{"name":"_onShowInfoPanelBodyClicked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of which the show/hide-body-button was clicked.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the user clicked a button for showing/hiding the body of an info panel.</p>"}}]},{type:"method",attributes:{"name":"_onShowItemDetailClicked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of the item to show/hide the details.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>the name of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"fromClassName"},children:[{type:"desc",attributes:{"text":"<p>the name of the class the item the item was defined in.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the user clicked a button for showing/hiding the details of an item.</p>"}}]},{type:"method",attributes:{"name":"_selectItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"itemName"},children:[{type:"desc",attributes:{"text":"<p>the name of the item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects an item.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.embed.HtmlEmbed","name":"_syncHtml"},children:[{type:"desc",attributes:{"text":"<p>Initializes the content of the embedding <span class=\"caps\">DIV</span>. Will be called by the HtmlEmbed element initialization routine.</p>"}}]},{type:"method",attributes:{"name":"_updateInfoPanel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nodeType"},children:[{type:"desc",attributes:{"text":"<p>the node type of which to update the info panel.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Updates an info panel.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"name":"showClass"},children:[{type:"params",children:[{type:"param",attributes:{"name":"classNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node of the class to show.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Shows the information about a class.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"showInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"classNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"294"}}]}]},{type:"method",attributes:{"name":"showItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"itemName"},children:[{type:"desc",attributes:{"text":"<p>the name of the item to highlight.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Highlights an item (property, method or constant) and scrolls it visible.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"PRIMITIVES"},children:[{type:"desc",attributes:{"text":"<p>The primitive types. These types will not be shown with links.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"constant",attributes:{"name":"ITEM_SPEC_REGEX"},children:[{type:"desc",attributes:{"text":"<p>The regexp for parsing a item name (e.g. &#8220;mypackage.MyClass#MY_CONSTANT alternative text&#8221;).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"regexp"}}]}]},{type:"constant",attributes:{"name":"SENTENCE_END_REGEX"},children:[{type:"desc",attributes:{"text":"<p>The regexp that finds the end of a sentence.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"regexp"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_CONSTRUCTOR"},children:[{type:"desc",attributes:{"text":"<p>The node type of a constructor.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_PROPERTY"},children:[{type:"desc",attributes:{"text":"<p>The node type of a property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_EVENT"},children:[{type:"desc",attributes:{"text":"<p>The node type of an event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_METHOD_PUBLIC"},children:[{type:"desc",attributes:{"text":"<p>The node type of a public method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_METHOD_PROTECTED"},children:[{type:"desc",attributes:{"text":"<p>The node type of a protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_METHOD_STATIC_PUBLIC"},children:[{type:"desc",attributes:{"text":"<p>The node type of a static public method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_METHOD_STATIC_PROTECTED"},children:[{type:"desc",attributes:{"text":"<p>The node type of a static protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NODE_TYPE_CONSTANT"},children:[{type:"desc",attributes:{"text":"<p>The node type of a constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"DIV_START"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a div.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"DIV_START_DESC"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a div containing an item description.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"DIV_START_DETAIL_HEADLINE"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a div containing the headline of an item detail.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"DIV_START_DETAIL_TEXT"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a div containing the text of an item detail.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"DIV_START_ERROR_HEADLINE"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a div containing the headline of an item error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"DIV_END"},children:[{type:"desc",attributes:{"text":"<p>The end tag of a div.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"SPAN_START_OPTIONAL"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a span containing an optional detail.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"SPAN_START_PARAM_NAME"},children:[{type:"desc",attributes:{"text":"<p>The start tag of a span containing a parameter name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"SPAN_END"},children:[{type:"desc",attributes:{"text":"<p>The end tag of a span.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"createImageHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"imgUrl"},children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">URL</span> of the image. May be a string or an array of strings (for overlay images).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"tooltip"},children:[{type:"desc",attributes:{"text":"<p>the tooltip to show.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"styleAttributes"},children:[{type:"desc",attributes:{"text":"<p>the style attributes to add to the image.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> showing an image.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"createOverlayImageHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>the width of the images.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"height"},children:[{type:"desc",attributes:{"text":"<p>the height of the images.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"imgUrlArr"},children:[{type:"desc",attributes:{"text":"<p>the URLs of the images. The last image will be painted on top.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"param",attributes:{"name":"toolTip"},children:[{type:"desc",attributes:{"text":"<p>the tooltip of the icon.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string,null"}}]}]},{type:"param",attributes:{"name":"styleAttributes"},children:[{type:"desc",attributes:{"text":"<p>custom <span class=\"caps\">CSS</span> style attributes.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string,null"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates <span class=\"caps\">HTML</span> that shows an overlay image (several images on top of each other). The resulting <span class=\"caps\">HTML</span> will behave inline.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> with the overlay image.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"api","fullName":"api.InfoViewer","name":"InfoViewer","hasWarning":"true","superClass":"qx.ui.embed.HtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Shows the class details.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"showInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"classNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"21"}}]}]}]}]},{type:"class",attributes:{"packageName":"api","fullName":"api.TreeUtil","name":"TreeUtil","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A util class for handling the documentation tree.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"getChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"docNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node to get the child of.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"childType"},children:[{type:"desc",attributes:{"text":"<p>the type of the child to get.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the child of a doc node having a certain type.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the wanted child or <code>null</code> if <code>docNode</code> is <code>null</code> or has no such child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getChildByAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"docNode"},children:[{type:"desc",attributes:{"text":"<p>the doc node to get the child of.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"attributeName"},children:[{type:"desc",attributes:{"text":"<p>the name of the attribute the wanted child must have.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"attributeValue"},children:[{type:"desc",attributes:{"text":"<p>the value of the attribute the wanted child must have.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the child of a doc node having a certain attribute value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the wanted child or <code>code</code> if there is no such child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getClassDocNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"docTree"},children:[{type:"desc",attributes:{"text":"<p>the documentation tree.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"className"},children:[{type:"desc",attributes:{"text":"<p>the name of the class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the doc node of a class.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the doc node of the class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getIconUrl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>the node to get the icon for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"inherited"},children:[{type:"desc",attributes:{"text":"<p>whether the node was inherited.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean,false"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the icon <span class=\"caps\">URL</span> of a doc node.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">URL</span> of the icon. May be a string or an array of string (in case of an overlay icon).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getItemDocNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"classNode"},children:[{type:"desc",attributes:{"text":"<p>the class node the item belongs to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"itemName"},children:[{type:"desc",attributes:{"text":"<p>the name of the item to search.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Searches the doc node of a item. Only use this method if you don&#8217;t know the type of the item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the doc node of the item or <code>null</code> if the class has no such item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"ITEM_LIST_ARR"},children:[{type:"desc",attributes:{"text":"<p>The names of lists containing items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_ABSTRACT"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;abstract&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;error&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;inherited&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_OVERRIDDEN"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;overridden&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_STATIC"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;static&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"OVERLAY_WARN"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the overlay &#8220;warning&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_PACKAGE"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a package.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_PACKAGE_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a package with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a class with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a class with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_STATIC"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a static class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_STATIC_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a static class with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_STATIC_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a static class with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_ABSTRACT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_ABSTRACT_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract class with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CLASS_ABSTRACT_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract class with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a property with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a property with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_INHERITED_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited property with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_INHERITED_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited property with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_OVERRIDDEN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_OVERRIDDEN_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden property with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_PROPERTY_OVERRIDDEN_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden property with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_EVENT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_EVENT_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_INHERITED_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_INHERITED_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_OVERRIDDEN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_OVERRIDDEN_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_OVERRIDDEN_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_STATIC"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public static method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_STATIC_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public static method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public abstract method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public abstract method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a public abstract method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_OVERRIDDEN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public abstract method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_OVERRIDDEN_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public abstract method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_OVERRIDDEN_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden public abstract method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public abstract method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_INHERITED_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public abstract method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_ABSTRACT_INHERITED_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited public abstract method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_CTOR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a constructor.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PUB_CTOR_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a constructor with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a protected method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a protected method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_INHERITED_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited protected method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_INHERITED_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited protected method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_OVERRIDDEN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_OVERRIDDEN_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden protected method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_OVERRIDDEN_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an overridden protected method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_STATIC"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a protected static method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_STATIC_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a protected static method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract protected method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an abstract protected method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT_INHERITED"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited abstract protected method.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT_INHERITED_WARN"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited abstract protected method with warning.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_METHOD_PROT_ABSTRACT_INHERITED_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of an inherited abstract protected method with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"constant",attributes:{"name":"ICON_CONSTANT"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a constant.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"constant",attributes:{"name":"ICON_CONSTANT_ERROR"},children:[{type:"desc",attributes:{"text":"<p>The icon <span class=\"caps\">URL</span> of a constant with error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]}]}]},{type:"class",attributes:{"packageName":"api","fullName":"api.Viewer","name":"Viewer","hasWarning":"true","superClass":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">API</span> viewer. Shows the <span class=\"caps\">API</span> documentation.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"Object","name":"docTree"},children:[{type:"desc",attributes:{"text":"<p>The documentation tree to show.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createInheritanceNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parentTreeNode"}},{type:"param",attributes:{"name":"classDocNode"},children:[{type:"desc",attributes:{"text":"<p>the documentation node of the class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"docTree"},children:[{type:"desc",attributes:{"text":"<p>the documentation tree.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the tree node for a class containing class nodes for all its child classes.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter parentTreeNode is not documented.","column":"35","line":"215"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_fillPackageNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeNode"},children:[{type:"desc",attributes:{"text":"<p>the package tree node.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tree.TreeFolder"}}]}]},{type:"param",attributes:{"name":"docNode"},children:[{type:"desc",attributes:{"text":"<p>the documentation node of the package.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"depth"}}]},{type:"desc",attributes:{"text":"<p>Fills a package tree node with tree nodes for the sub packages and classes.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter depth is not documented.","column":"29","line":"161"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHistoryRequest"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"265"}}]}]},{type:"method",attributes:{"name":"_onTreeSelectionChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the tree selection has changed.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_selectTreeNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTreeNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"270"}}]}]},{type:"method",attributes:{"name":"_updateTree"},children:[{type:"params",children:[{type:"param",attributes:{"name":"docTree"},children:[{type:"desc",attributes:{"text":"<p>the documentation tree to use for updating.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Updates the tree on the left.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"name":"load"},children:[{type:"params",children:[{type:"param",attributes:{"name":"url"},children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">URL</span>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Loads the <span class=\"caps\">API</span> doc tree from a <span class=\"caps\">URL</span>. The <span class=\"caps\">URL</span> must point to a <span class=\"caps\">JSON</span> encoded doc tree.</p>"}}]},{type:"method",attributes:{"name":"selectItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fullItemName"},children:[{type:"desc",attributes:{"text":"<p>the full name of the item to select. (e.g. &#8220;qx.mypackage.MyClass&#8221; or &#8220;qx.mypackage.MyClass#myProperty&#8221;)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects an item (class, property, method or constant).</p>"}}]},{type:"method",attributes:{"name":"showClassByName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"className"},children:[{type:"desc",attributes:{"text":"<p>the name of the class to show.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Shows a certain class.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"PACKAGE_TREE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"342"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"INHERITENCE_TREE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"343"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx","name":"qx","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx","fullName":"qx.OO","isStatic":"true","name":"OO","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addFastProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vConfig"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"124"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"714"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addPropertyGroup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"228"}}]}]},{type:"method",attributes:{"isStatic":"true","name":"defineClass"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vClassName"},children:[{type:"desc",attributes:{"text":"<p>fully qualified class name (e.g. &#8220;qx.ui.form.Button&#8221;)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vSuper"},children:[{type:"desc",attributes:{"text":"<p>super class</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vConstructor"},children:[{type:"desc",attributes:{"text":"<p>the constructor of the new class</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define a new qooxdoo class All classes should be defined in this way.</p>"}}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"inheritField"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vField"}},{type:"param",attributes:{"name":"vData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"741"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isAvailable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vClassName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"747"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"326"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_createProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"364"}}]}]}]}]}]},{type:"packages",children:[{type:"package",attributes:{"packageName":"qx","fullName":"qx.client","name":"client","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.client","fullName":"qx.client.Builder","name":"Builder","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"flags"}}]},{type:"desc",attributes:{"text":"<p>A class to generate a widget hierarchy from <span class=\"caps\">XML</span></p>\n\n<p>qx.client.Builder is not thread safe by design &#8211; state information is stored at the instance level &#8211; only use it from a single thread</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter flags is not documented.","column":"1","line":"32"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"build"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"},children:[{type:"desc",attributes:{"text":"<p>can either be the application instance, or a widget to append the xml toplevel widgets to</p>"}}]},{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>can be either a xml string, or a xml dom document or fragment</p>"}}]}]},{type:"desc",attributes:{"text":"<p>parse the children of the xml and appending all widgets to the parent widget</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"buildFromUrl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"}},{type:"param",attributes:{"name":"url"}}]},{type:"desc",attributes:{"text":"<p>Asynchronous method &#8211; fetches <span class=\"caps\">XML</span> data from the <span class=\"caps\">URL</span> then delegates to build to process the xml Dispatches a qx.event.type.Event(&#8220;done&#8221;) after the hierarchy is built</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter parent is not documented.","column":"25","line":"62"}},{type:"error",attributes:{"msg":"Parameter url is not documented.","column":"25","line":"62"}}]}]},{type:"method",attributes:{"hasError":"true","name":"registerPropertyEditor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"className"}},{type:"param",attributes:{"name":"propertyName"}},{type:"param",attributes:{"name":"editor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"294"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_buildEventListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"}},{type:"param",attributes:{"name":"args"}},{type:"param",attributes:{"name":"text"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"103"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_buildNodes"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"}},{type:"param",attributes:{"name":"nodes"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"92"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_buildWidgetFromNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"}},{type:"param",attributes:{"name":"node"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"163"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_coerce"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"372"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_extractClassName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"438"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_findPropertyEditor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"className"}},{type:"param",attributes:{"name":"propertyName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"277"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_mapXmlAttribToObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"448"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_newError"},children:[{type:"params",children:[{type:"param",attributes:{"name":"message"}},{type:"param",attributes:{"name":"data"}},{type:"param",attributes:{"name":"exception"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"463"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_registerDefaultPropertyEditors"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"299"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setProperties"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"}},{type:"param",attributes:{"name":"name"}},{type:"param",attributes:{"name":"value"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"410"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"}},{type:"param",attributes:{"name":"name"}},{type:"param",attributes:{"name":"value"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"406"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setWidgetProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"}},{type:"param",attributes:{"name":"name"}},{type:"param",attributes:{"name":"value"}}]},{type:"desc",attributes:{"text":"<p>Set a widget&#8217;s property using a propertyEditor</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter widget is not documented.","column":"31","line":"269"}},{type:"error",attributes:{"msg":"Parameter name is not documented.","column":"31","line":"269"}},{type:"error",attributes:{"msg":"Parameter value is not documented.","column":"31","line":"269"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.client","fullName":"qx.client.Command","name":"Command","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"execute"},children:[{type:"desc",attributes:{"text":"<p>when the command is executed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vShortcut"},children:[{type:"desc",attributes:{"text":"<p>(string) shortcuts can be composed of optional modifier keys Control, Alt, Shift, Meta and a non modifier key. If no non modifier key is specified, the second paramater is evaluated. The key must be seperated by a &#8217;&#8217;+&#8217;&#8217; or &#8217;&#8217;-&#8217;&#8217; character. Examples: Alt+F1, Control+C, Control+Alt+Enf</p>"}}]},{type:"param",attributes:{"name":"vKeyCodeOrIdentifier"},children:[{type:"desc",attributes:{"text":"<p>(int)  Additional key of the command. It is interpreted as a keyIdentifier if it is given as integer. Otherwhise it is interpreted as keyCode.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>This contains a command with shortcut.</p>\n\n<p>Each command could be assigned to multiple widgets.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"number","name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>keyCode (Deprecated) Still there for compatibility with the old key handler/commands</p>"}}]},{type:"property",attributes:{"type":"string","name":"keyIdentifier"},children:[{type:"desc",attributes:{"text":"<p>KeyIdentifier</p>"}}]},{type:"property",attributes:{"type":"string","name":"shortcut"},children:[{type:"desc",attributes:{"text":"<p>the command shortcut</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Target","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor</p>"}}]},{type:"method",attributes:{"name":"execute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTarget"},children:[{type:"desc",attributes:{"text":"<p>(Object)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Fire the &#8220;execute&#8221; event on this command.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"toString"},children:[{type:"desc",attributes:{"text":"<p>Returns the shortcut as string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) shortcut</p>"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_matchesKeyEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>(qx.event.type.KeyEvent) the key event object</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Checks wether the given key event matches the command&#8217;s shortcut</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(boolean) wether the commands shortcut matches the key event</p>"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.client","fullName":"qx.client.History","name":"History","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"request"},children:[{type:"desc",attributes:{"text":"<p>Fired when the user moved in the history. The data property of the event holds the command, which was passed to {@link #addToHistory}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A helper for using the browser history in JavaScript Applications without reloading the main page.</p>\n\n<p>Adds entries to the browser history and fires a &#8220;request&#8221; event when one of the entries was requested by the user (e.g. by clicking on the back button).</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addToHistory"},children:[{type:"params",children:[{type:"param",attributes:{"name":"command"},children:[{type:"desc",attributes:{"text":"<p>a string representing the old state of the application. This command will be delivered in the data property of the &#8220;request&#8221; event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"newTitle"},children:[{type:"desc",attributes:{"text":"<p>the page title to set after the history entry is done. This title should represent the new state of the application.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds an entry to the browser history.</p>"}}]},{type:"method",attributes:{"name":"init"},children:[{type:"desc",attributes:{"text":"<p>Initializes the History. This method has to called by applications using this class once during initialization. Subsequent calls have no (negative) effect.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_onHistoryLoad"},children:[{type:"params",children:[{type:"param",attributes:{"name":"location"},children:[{type:"desc",attributes:{"text":"<p>the location property of the window object of the helper page.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the history helper page was loaded.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.client","fullName":"qx.client.NativeWindow","name":"NativeWindow","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vUrl"}},{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"allowScrollbars"},children:[{type:"desc",attributes:{"text":"<p>If the window is able to scroll and has visible scrollbars if needed</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"dependent"},children:[{type:"desc",attributes:{"text":"<p>Should be window be dependent on this application window</p>"}}]},{type:"property",attributes:{"defaultValue":"250","type":"number","name":"height"},children:[{type:"desc",attributes:{"text":"<p>The outer height of the window.</p>"}}]},{type:"property",attributes:{"defaultValue":"100","type":"number","name":"left"},children:[{type:"desc",attributes:{"text":"<p>The left screen coordinate of the window.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"modal"},children:[{type:"desc",attributes:{"text":"<p>Should be window be modal</p>"}}]},{type:"property",attributes:{"type":"string","name":"name"},children:[{type:"desc",attributes:{"text":"<p>The window name</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"open"},children:[{type:"desc",attributes:{"text":"<p>If the window is open or closed</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"resizeable"},children:[{type:"desc",attributes:{"text":"<p>If the window is resizeable</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"showLocation"},children:[{type:"desc",attributes:{"text":"<p>Should the location(bar) be shown</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"showMenubar"},children:[{type:"desc",attributes:{"text":"<p>Should the menubar be shown</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"showStatusbar"},children:[{type:"desc",attributes:{"text":"<p>Should the statusbar be shown</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"showToolbar"},children:[{type:"desc",attributes:{"text":"<p>Should the toolbar be shown</p>"}}]},{type:"property",attributes:{"defaultValue":"\"Ready\"","type":"string","name":"status"},children:[{type:"desc",attributes:{"text":"<p>The text of the statusbar</p>"}}]},{type:"property",attributes:{"defaultValue":"200","type":"number","name":"top"},children:[{type:"desc",attributes:{"text":"<p>The top screen coordinate of the window.</p>"}}]},{type:"property",attributes:{"type":"string","name":"url"},children:[{type:"desc",attributes:{"text":"<p>The url</p>"}}]},{type:"property",attributes:{"defaultValue":"400","type":"number","name":"width"},children:[{type:"desc",attributes:{"text":"<p>The outer width of the window.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_centerHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"l"}},{type:"param",attributes:{"name":"t"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"519"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_close"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"464"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyDimension"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"199"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"173"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"568"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"588"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_open"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"338"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"blur"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"549"}}]}]},{type:"method",attributes:{"hasError":"true","name":"centerToOpener"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"515"}}]}]},{type:"method",attributes:{"hasError":"true","name":"centerToScreen"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"507"}}]}]},{type:"method",attributes:{"hasError":"true","name":"centerToScreenArea"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"511"}}]}]},{type:"method",attributes:{"hasError":"true","name":"close"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"318"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"focus"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"542"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getName"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"261"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isClosed"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"300"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isLoaded"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"322"}}]}]},{type:"method",attributes:{"hasError":"true","name":"open"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"314"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.client","fullName":"qx.client.Timer","name":"Timer","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"interval"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vInterval"}}]},{type:"desc",attributes:{"text":"<p>Global timer support. Simplifies javascript intervals for objects.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vInterval is not documented.","column":"1","line":"31"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"__oninterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"43"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"58"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"117"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"1000","type":"number","name":"interval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"46"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"restart"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"96"}}]}]},{type:"method",attributes:{"hasError":"true","name":"restartWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vInterval"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","name":"start"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"82"}}]}]},{type:"method",attributes:{"hasError":"true","name":"startWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vInterval"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"86"}}]}]},{type:"method",attributes:{"hasError":"true","name":"stop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"92"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"once"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunction"}},{type:"param",attributes:{"name":"vObject"}},{type:"param",attributes:{"name":"vTimeout"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"167"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.component","name":"component","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"AbstractApplication","hasWarning":"true","packageName":"qx.component","superClass":"qx.component.AbstractComponent","childClasses":"qx.component.DummyApplication,swat.main.Main","fullName":"qx.component.AbstractApplication"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"name":"AbstractComponent","hasWarning":"true","packageName":"qx.component","superClass":"qx.core.Target","childClasses":"qx.component.AbstractApplication,qx.component.init.AbstractInitComponent","fullName":"qx.component.AbstractComponent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"close"},children:[{type:"desc",attributes:{"text":"<p>Terminate this component.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"name":"finalize"},children:[{type:"desc",attributes:{"text":"<p>Run finalization part of component creation.</p>"}}]},{type:"method",attributes:{"name":"initialize"},children:[{type:"desc",attributes:{"text":"<p>Run initialisation part of component creation.</p>"}}]},{type:"method",attributes:{"name":"main"},children:[{type:"desc",attributes:{"text":"<p>Run main  part of component creation.</p>"}}]},{type:"method",attributes:{"name":"terminate"},children:[{type:"desc",attributes:{"text":"<p>Terminate this component.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.component","fullName":"qx.component.DummyApplication","name":"DummyApplication","hasWarning":"true","superClass":"qx.component.AbstractApplication"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]}]},{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.component","fullName":"qx.component.init","name":"init","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"AbstractInitComponent","hasWarning":"true","packageName":"qx.component.init","superClass":"qx.component.AbstractComponent","childClasses":"qx.component.init.BasicInitComponent","fullName":"qx.component.init.AbstractInitComponent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.component.AbstractComponent","name":"close"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Terminate this component.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"18","line":"56"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.component.AbstractComponent","name":"finalize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Run finalization part of component creation.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"21","line":"49"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.component.AbstractComponent","name":"initialize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Run initialisation part of component creation.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"23","line":"35"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.component.AbstractComponent","name":"main"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Run main  part of component creation.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"17","line":"42"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.component.AbstractComponent","name":"terminate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Terminate this component.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"22","line":"63"}}]}]}]}]},{type:"class",attributes:{"name":"BasicInitComponent","hasWarning":"true","packageName":"qx.component.init","superClass":"qx.component.init.AbstractInitComponent","childClasses":"qx.component.init.InterfaceInitComponent","fullName":"qx.component.init.BasicInitComponent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onbeforeunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"47"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"40"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"51"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.component.init","fullName":"qx.component.init.InterfaceInitComponent","name":"InterfaceInitComponent","hasWarning":"true","superClass":"qx.component.init.BasicInitComponent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.component.init.AbstractInitComponent","overriddenFrom":"qx.component.init.AbstractInitComponent","name":"close"}},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.component.AbstractComponent","name":"dispose"}},{type:"method",attributes:{"docFrom":"qx.component.init.AbstractInitComponent","overriddenFrom":"qx.component.init.AbstractInitComponent","name":"finalize"}},{type:"method",attributes:{"docFrom":"qx.component.init.AbstractInitComponent","overriddenFrom":"qx.component.init.AbstractInitComponent","name":"initialize"}},{type:"method",attributes:{"hasError":"true","name":"isUiReady"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"42"}}]}]},{type:"method",attributes:{"docFrom":"qx.component.init.AbstractInitComponent","overriddenFrom":"qx.component.init.AbstractInitComponent","name":"main"}},{type:"method",attributes:{"hasError":"true","name":"preload"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"127"}}]}]},{type:"method",attributes:{"docFrom":"qx.component.init.AbstractInitComponent","overriddenFrom":"qx.component.init.AbstractInitComponent","name":"terminate"}}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.component.init.BasicInitComponent","overriddenFrom":"qx.component.init.BasicInitComponent","name":"_onload","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_printPreloadComplete"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"137"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.core","name":"core"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.core","fullName":"qx.core.Init","name":"Init","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Initialize qooxdoo.</p>\n\n<p>Attaches qooxdoo callbacks to the load events (onload, onunload, onbeforeunload) and initializes the qooxdoo application. The initializations starts automatically.</p>\n\n<p>Make shure you set the application to your application before the load event is fired: <pre>qx.core.Init.getInstance().setApplication(YourApplication)</pre></p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"__onbeforeunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>private</p>"}}]},{type:"method",attributes:{"name":"__onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>private</p>"}}]},{type:"method",attributes:{"name":"__onunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>private</p>"}}]},{type:"method",attributes:{"name":"_onbeforeunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>beforeunload event handler</p>"}}]},{type:"method",attributes:{"name":"_onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>load event handler</p>"}}]},{type:"method",attributes:{"name":"_onunload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>unload event handler</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"Function","name":"application"},children:[{type:"desc",attributes:{"text":"<p>Reference to the constructor of the main application.</p>\n\n<p>Set this before the onload event is fired.</p>"}}]},{type:"property",attributes:{"instance":"qx.component.init.BasicInitComponent","type":"Object","name":"component"},children:[{type:"desc",attributes:{"text":"<p>Instance of the component initializer.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"defineClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"},children:[{type:"desc",attributes:{"text":"<p>callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define the close function Don&#8217;t use this method directly. Use setApplication instead!</p>"}}]},{type:"method",attributes:{"name":"defineFinalize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"},children:[{type:"desc",attributes:{"text":"<p>callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define the finalize function Don&#8217;t use this method directly. Use setApplication instead!</p>"}}]},{type:"method",attributes:{"name":"defineInitialize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"},children:[{type:"desc",attributes:{"text":"<p>callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define the initialisation function Don&#8217;t use this method directly. Use setApplication instead!</p>"}}]},{type:"method",attributes:{"name":"defineMain"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"},children:[{type:"desc",attributes:{"text":"<p>callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define the main function Don&#8217;t use this method directly. Use setApplication instead!</p>"}}]},{type:"method",attributes:{"name":"defineTerminate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"},children:[{type:"desc",attributes:{"text":"<p>callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>define the terminate function Don&#8217;t use this method directly. Use setApplication instead!</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Target","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor</p>"}}]},{type:"method",attributes:{"name":"getApplicationInstance"},children:[{type:"desc",attributes:{"text":"<p>Rreturns an instance of the current qooxdoo Application</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>instance of the current qooxdoo application</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.component.AbstractApplication"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.core","fullName":"qx.core.Object","name":"Object","childClasses":"api.TreeUtil,qx.core.Target,qx.dev.TimeTracker,qx.dev.log.Filter,qx.dev.log.LogEventProcessor,qx.event.type.Event,qx.renderer.border.Border,qx.renderer.border.BorderPresets,qx.renderer.color.Color,qx.renderer.font.Font,qx.renderer.layout.LayoutImpl,qx.renderer.theme.AppearanceTheme,qx.renderer.theme.ColorTheme,qx.renderer.theme.IconTheme,qx.renderer.theme.WidgetTheme,qx.type.Selection,qx.type.StringBuilder,qx.type.Version,qx.ui.table.CellEditorFactory,qx.ui.table.DataCellRenderer,qx.ui.table.DataRowRenderer,qx.ui.table.HeaderCellRenderer,qx.ui.table.SelectionManager,qx.ui.treefullcontrol.TreeRowStructure,qx.util.format.Format,qx.util.fsm.State,qx.util.fsm.Transition,swat.main.AbstractModule,swat.main.AbstractModuleFsm,swat.main.Module,swat.module.ldbbrowse.Gui,swat.module.statistics.Gui"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"true","name":"vAutoDispose"},children:[{type:"desc",attributes:{"text":"<p>wether the object should be disposed automatically by qooxdoo</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>The qooxdoo base object. All qooxdoo classes extend this one</p>\n\n<p>This class contains functions for: <ul> <li> logging </li> <li> common getter/setter </li> <li> user data </li> <li> object destruction </li> </ul></p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor. This method is called by qooxdoo on object destruction.</p>\n\n<p>Any class that holds ressources like links to <span class=\"caps\">DOM</span> nodes must overwrite this method and free theese ressources.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"fromHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"hash"},children:[{type:"desc",attributes:{"text":"<p>hash code of an object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Class function which returns an object given its hash code</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"summary"},children:[{type:"desc",attributes:{"text":"<p>Summary of allocated objects</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>summary of allocated objects.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"toHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Generate an unique key for the given object and return it. Sets object._hashCode to the generated key.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>unique key for the given object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isEnabled","defaultValue":"true","type":"boolean","name":"enabled"},children:[{type:"desc",attributes:{"text":"<p>Enable or disable the Object.</p>\n\n<p>The actual semantic of this property depends on concrete subclass of qx.core.Object.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"debug"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a debug message.</p>"}}]},{type:"method",attributes:{"name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Dispose this object</p>"}}]},{type:"method",attributes:{"name":"error"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs an error message.</p>"}}]},{type:"method",attributes:{"name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propertyNames"},children:[{type:"desc",attributes:{"text":"<p>list of the properties to get</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}},{type:"entry",attributes:{"type":"array"}},{type:"entry",attributes:{"type":"hash"}}]}]},{type:"param",attributes:{"defaultValue":"\"array\"","name":"outputHint"},children:[{type:"desc",attributes:{"text":"<p>how should the values be returned. Possible values are &#8220;hash&#8221; and &#8220;array&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets multiple properties at once by using a property list</p>"}}]},{type:"method",attributes:{"name":"getDisposed"},children:[{type:"desc",attributes:{"text":"<p>Returns true if the object is disposed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>wether the object has been disposed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"getLogger"},children:[{type:"desc",attributes:{"text":"<p>Returns the logger of this class.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the logger of this class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.dev.log.Logger"}}]}]}]},{type:"method",attributes:{"name":"getSetting"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vKey"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a settings from global setting definition</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>value of the global setting</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"getUserData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vKey"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Load user defined data from the object</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the user data</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"info"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs an info message.</p>"}}]},{type:"method",attributes:{"name":"isDisposed"},children:[{type:"desc",attributes:{"text":"<p>Returns true if the object is disposed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>wether the object has been disposed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"set"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propertyValues"},children:[{type:"desc",attributes:{"text":"<p>A hash of key-value pairs.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets multiple properties at once by using a property list</p>"}}]},{type:"method",attributes:{"name":"setUserData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vKey"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vValue"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Store user defined data inside the object.</p>"}}]},{type:"method",attributes:{"name":"toHashCode"},children:[{type:"desc",attributes:{"text":"<p>Return unique hash code of object</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>unique hash code of the object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"toString"},children:[{type:"desc",attributes:{"text":"<p>Returns a string represantation of the qooxdoo object.</p>"}}]},{type:"method",attributes:{"name":"warn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a warning message.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.core","fullName":"qx.core.Target","name":"Target","childClasses":"qx.client.Builder,qx.client.Command,qx.client.History,qx.client.NativeWindow,qx.client.Timer,qx.component.AbstractComponent,qx.core.Init,qx.event.handler.EventHandler,qx.event.handler.FocusHandler,qx.event.handler.KeyEventHandler,qx.io.image.Preloader,qx.io.image.PreloaderSystem,qx.io.remote.AbstractRemoteTransport,qx.io.remote.Exchange,qx.io.remote.Request,qx.io.remote.RequestQueue,qx.io.remote.Response,qx.io.remote.Rpc,qx.manager.object.AliasManager,qx.manager.object.ObjectManager,qx.manager.selection.RadioManager,qx.manager.selection.SelectionManager,qx.type.Range,qx.ui.core.Widget,qx.ui.table.SelectionModel,qx.ui.table.TableColumnModel,qx.ui.table.TableModel,qx.ui.table.TablePaneModel,qx.util.fsm.FiniteStateMachine","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"true","name":"vAutoDispose"},children:[{type:"desc",attributes:{"text":"<p>wether the object should be disposed automatically by qooxdoo</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>This is the main constructor for all objects that need to be connected to qx.event.type.Event objects.</p>\n\n<p>In objects created with this constructor, you find functions to addEventListener or removeEventListener to or from the created object. Each event to connect to has a type in form of an identification string. This type could be the name of a regular dom event like &#8220;click&#8221; or something self-defined like &#8220;ready&#8221;.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"EVENTPREFIX"},children:[{type:"desc",attributes:{"text":""}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addEventListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vFunction"},children:[{type:"desc",attributes:{"text":"<p>event callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"window","name":"vObject"},children:[{type:"desc",attributes:{"text":"<p>reference to the &#8216;this&#8217; variable inside the callback</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add event listener to an object.</p>"}}]},{type:"method",attributes:{"name":"createDispatchDataEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vData"},children:[{type:"desc",attributes:{"text":"<p>user defined data attached to the event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks if the event is registered. If so it creates an event object and dispatches it.</p>"}}]},{type:"method",attributes:{"name":"createDispatchEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks if the event is registered. If so it creates an event object and dispatches it.</p>"}}]},{type:"method",attributes:{"name":"dispatchEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEvent"},children:[{type:"desc",attributes:{"text":"<p>event to dispatch</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"param",attributes:{"name":"vEnableDispose"},children:[{type:"desc",attributes:{"text":"<p>wether the event object should be disposed after all event handlers run.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Dispatch an event</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>wether the event default was prevented or not. Returns true, when the event was <span class=\"caps\">NOT</span> prevented.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor.</p>"}}]},{type:"method",attributes:{"name":"hasEventListeners"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Check if there are one or more listeners for an event type.</p>"}}]},{type:"method",attributes:{"name":"removeEventListener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>name of the event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vFunction"},children:[{type:"desc",attributes:{"text":"<p>event callback function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"window","name":"vObject"},children:[{type:"desc",attributes:{"text":"<p>reference to the &#8216;this&#8217; variable inside the callback</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove event listener from object</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_dispatchEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEvent"},children:[{type:"desc",attributes:{"text":"<p>event to dispatch</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal event dispatch method</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.core","fullName":"qx.core.Version","isStatic":"true","name":"Version"},children:[{type:"constants",children:[{type:"constant",attributes:{"name":"major"},children:[{type:"desc",attributes:{"text":"<p>qooxdoo major version number</p>"}}]},{type:"constant",attributes:{"name":"minor"},children:[{type:"desc",attributes:{"text":"<p>qooxdoo minor version number</p>"}}]},{type:"constant",attributes:{"name":"revision"},children:[{type:"desc",attributes:{"text":"<p>qooxdoo revision number</p>"}}]},{type:"constant",attributes:{"name":"state"},children:[{type:"desc",attributes:{"text":"<p>qooxdoo revision state</p>"}}]},{type:"constant",attributes:{"name":"svn"},children:[{type:"desc",attributes:{"text":"<p>qooxdoo subversion revision number</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"toString"},children:[{type:"desc",attributes:{"text":"<p>returns the qooxdoo version string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>qooxdoo version string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.dev","name":"dev","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.dev","fullName":"qx.dev.log","name":"log"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.AlertAppender","name":"AlertAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An appender that writes each message to a native alert().</p>\n\n<p>This class does not depend on qooxdoo widgets, so it also works when there are problems with widgets or when the widgets are not yet initialized.</p>\n\n<p>It allows to go through the log messages step-by-step, since the alert window temporarily halts the regular program execution. That way even the dispose process can easily be debugged.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}}]}]},{type:"class",attributes:{"isAbstract":"true","name":"Appender","packageName":"qx.dev.log","superClass":"qx.dev.log.LogEventProcessor","childClasses":"qx.dev.log.AlertAppender,qx.dev.log.DivAppender,qx.dev.log.FireBugAppender,qx.dev.log.ForwardAppender,qx.dev.log.RingBufferAppender,qx.dev.log.WindowAppender","fullName":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An appender. Does the actual logging.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"true","type":"boolean","name":"useLongFormat"},children:[{type:"desc",attributes:{"text":"<p>Whether the logger name and log level should be included in the formatted log message.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The event to append.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Appends a log event to the log.</p>"}}]},{type:"method",attributes:{"name":"formatLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The log event to format.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Formats a log event.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The formatted event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.dev.log.LogEventProcessor","overriddenFrom":"qx.dev.log.LogEventProcessor","name":"handleLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_beautyStackTrace"},children:[{type:"params",children:[{type:"param",attributes:{"name":"stack"},children:[{type:"desc",attributes:{"text":"<p>the stack trace to beautify.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Beautifies a stack trace.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the beautified stack trace.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.DefaultFilter","name":"DefaultFilter","superClass":"qx.dev.log.Filter"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The default filter. Has a minimum level and can be enabled or disabled.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"enabled","defaultValue":"true","getAlias":"isEnabled","allowNull":"false","overriddenFrom":"qx.core.Object","type":"boolean"},children:[{type:"desc",attributes:{"text":"<p>Whether the filter should be enabled. If set to false all log events will be denied.</p>"}}]},{type:"property",attributes:{"defaultValue":"null","type":"number","name":"minLevel"},children:[{type:"desc",attributes:{"text":"<p>The minimum log level. If set only log messages with a level greater or equal to the set level will be accepted.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Filter","overriddenFrom":"qx.dev.log.Filter","name":"decide"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.DivAppender","name":"DivAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"\"qx_log\"","name":"divId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the div element to write the messages to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>An appender that writes all messages to a div element.</p>\n\n<p>This class does not depend on qooxdoo widgets, so it also works when there are problems with widgets or when the widgets are not yet initialized.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"\"log-body\"","type":"string","name":"bodyClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for the body div {containing the log messages}.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-debug\"","type":"string","name":"debugClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for a div showing a debug message.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-error\"","type":"string","name":"errorClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for a div showing a error message.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-group\"","type":"string","name":"groupClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for a div showing the name of the current group.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-head\"","type":"string","name":"headClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for the head div {containing the clear button}.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-info\"","type":"string","name":"infoClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for a div showing a info message.</p>"}}]},{type:"property",attributes:{"defaultValue":"500","type":"number","name":"maxMessages"},children:[{type:"desc",attributes:{"text":"<p>The maximum number of messages to show. If null the number of messages is not limited.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"log-warn\"","type":"string","name":"warnClassName"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">CSS</span> class name for a div showing a warn message.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_createClearButtonHandler"},children:[{type:"params",children:[{type:"param",attributes:{"name":"logElem"},children:[{type:"desc",attributes:{"text":"<p>the element to clear when the handler is called.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates an onclick handler that clears a div element. This method is used to create a minimum closure.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the handler.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}}]}]},{type:"class",attributes:{"isAbstract":"true","name":"Filter","packageName":"qx.dev.log","superClass":"qx.core.Object","childClasses":"qx.dev.log.DefaultFilter","fullName":"qx.dev.log.Filter"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A filter for log events.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"decide"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The event to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Decidies whether a log event is accepted.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>{@link #ACCEPT}, {@link #DENY} or {@link #NEUTRAL}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"ACCEPT"},children:[{type:"desc",attributes:{"text":"<p>Specifies that the log event is accepted.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"DENY"},children:[{type:"desc",attributes:{"text":"<p>Specifies that the log event is denied.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"NEUTRAL"},children:[{type:"desc",attributes:{"text":"<p>Specifies that the filter is neutral to the log event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.FireBugAppender","name":"FireBugAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An appender that writes all messages to FireBug, a nice extension for debugging and developing under Firefox.</p>\n\n<p>This class does not depend on qooxdoo widgets, so it also works when there are problems with widgets or when the widgets are not yet initialized.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.ForwardAppender","name":"ForwardAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"targetProcessor"},children:[{type:"desc",attributes:{"text":"<p>The log event processor Where to pass the log events.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LogEventProcessor"}}]}]}]},{type:"desc",attributes:{"text":"<p>An appender that forwards all log events to a log event processor.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"LogEventProcessor","packageName":"qx.dev.log","superClass":"qx.core.Object","childClasses":"qx.dev.log.Appender,qx.dev.log.Logger","fullName":"qx.dev.log.LogEventProcessor"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Processes log events. May be configured with filters in order to specify which log events should be processed.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addFilter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"filter"},children:[{type:"desc",attributes:{"text":"<p>The filter to append.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Filter"}}]}]}]},{type:"desc",attributes:{"text":"<p>Appends a filter to the filter chain.</p>"}}]},{type:"method",attributes:{"name":"clearFilters"},children:[{type:"desc",attributes:{"text":"<p>Clears the filter chain.</p>"}}]},{type:"method",attributes:{"name":"decideLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Decides whether a log event is processed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>{@link Filter#ACCEPT}, {@link Filter#DENY} or {@link Filter#NEUTRAL}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getHeadFilter"},children:[{type:"desc",attributes:{"text":"<p>Returns the head filter from the chain. Returns null if there are no filters.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the head filter from the chain.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Filter"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"handleLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The log event to process.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Processes a log event.</p>"}}]},{type:"method",attributes:{"name":"setEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"enabled"},children:[{type:"desc",attributes:{"text":"<p>whether event processing should be enabled.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets whether event processing should be enabled.</p>\n\n<p>Note: This will clear all custom filters.</p>"}}]},{type:"method",attributes:{"name":"setMinLevel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"minLevel"},children:[{type:"desc",attributes:{"text":"<p>the new min level.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the min level an event must have in order to be processed.</p>\n\n<p>Note: This will clear all custom filters.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_getDefaultFilter"},children:[{type:"desc",attributes:{"text":"<p>Returns the default filter from the chain. If the head filter is no default filter, the chain will be cleared and a default filter will be created.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default filter.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Filter"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.Logger","name":"Logger","superClass":"qx.dev.log.LogEventProcessor"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>The category name of this logger. (Normally a class or package name)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"parentLogger"},children:[{type:"desc",attributes:{"text":"<p>The parent logger.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Logger"}}]}]}]},{type:"desc",attributes:{"text":"<p>A logger. Logs messages of one log category.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addAppender"},children:[{type:"params",children:[{type:"param",attributes:{"name":"appender"},children:[{type:"desc",attributes:{"text":"<p>the appender to add.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Appender"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds an appender.</p>\n\n<p>If a logger has an appender, log events will not be passed to the appenders of parent loggers. If you want this behaviour, also append a {@link ForwardAppender}.</p>"}}]},{type:"method",attributes:{"name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The event to append.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Passes a log event to the appenders. If the logger has no appenders the event will be passed to the appenders of the parent logger, and so on.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"debug"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a debug message.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"error"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs an error message.</p>"}}]},{type:"method",attributes:{"name":"fatal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, its object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a fatal message.</p>"}}]},{type:"method",attributes:{"name":"getName"},children:[{type:"desc",attributes:{"text":"<p>Returns the name of this logger. (Normally a class or package name)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"getParentLogger"},children:[{type:"desc",attributes:{"text":"<p>Returns the parent logger.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the parent logger.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Logger"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.dev.log.LogEventProcessor","overriddenFrom":"qx.dev.log.LogEventProcessor","name":"handleLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]},{type:"method",attributes:{"name":"indent"},children:[{type:"desc",attributes:{"text":"<p>Indents all following log messages by one.</p>\n\n<p>This affects all log messages. Even those of other loggers.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"info"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs an info message.</p>"}}]},{type:"method",attributes:{"name":"log"},children:[{type:"params",children:[{type:"param",attributes:{"name":"level"},children:[{type:"desc",attributes:{"text":"<p>the log level.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a message.</p>"}}]},{type:"method",attributes:{"name":"measure"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a debug message and measures the time since the last call of measure.</p>"}}]},{type:"method",attributes:{"name":"measureReset"},children:[{type:"desc",attributes:{"text":"<p>Resets the measure timer.</p>"}}]},{type:"method",attributes:{"name":"printStackTrace"},children:[{type:"desc",attributes:{"text":"<p>Logs the current stack trace as a debug message.</p>"}}]},{type:"method",attributes:{"name":"removeAllAppenders"},children:[{type:"desc",attributes:{"text":"<p>Removes all appenders.</p>"}}]},{type:"method",attributes:{"name":"removeAppender"},children:[{type:"params",children:[{type:"param",attributes:{"name":"appender"},children:[{type:"desc",attributes:{"text":"<p>the appender to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Appender"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes an appender.</p>"}}]},{type:"method",attributes:{"name":"unindent"},children:[{type:"desc",attributes:{"text":"<p>Unindents all following log messages by one.</p>\n\n<p>This affects all log messages. Even those of other loggers.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"warn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"msg"},children:[{type:"desc",attributes:{"text":"<p>the message to log. If this is not a string, the object dump will be logged.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the instance the log message comes from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"exc"},children:[{type:"desc",attributes:{"text":"<p>the exception to log.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Logs a warning message.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"getClassLogger"},children:[{type:"params",children:[{type:"param",attributes:{"name":"clazz"},children:[{type:"desc",attributes:{"text":"<p>The class of which to return the logger.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the logger of a class.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"LEVEL_ALL"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">ALL</span> level has the lowest possible rank and is intended to turn on all logging.</p>"}}]},{type:"constant",attributes:{"name":"LEVEL_DEBUG"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">DEBUG</span> Level designates fine-grained informational events that are most useful to debug an application.</p>"}}]},{type:"constant",attributes:{"name":"LEVEL_INFO"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">INFO</span> level designates informational messages that highlight the progress of the application at coarse-grained level.</p>"}}]},{type:"constant",attributes:{"name":"LEVEL_WARN"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">WARN</span> level designates potentially harmful situations.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"LEVEL_ERROR"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">ERROR</span> level designates error events that might still allow the application to continue running.</p>"}}]},{type:"constant",attributes:{"name":"LEVEL_FATAL"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">FATAL</span> level designates very severe error events that will presumably lead the application to abort.</p>"}}]},{type:"constant",attributes:{"name":"LEVEL_OFF"},children:[{type:"desc",attributes:{"text":"<p>(int) The <span class=\"caps\">OFF</span> has the highest possible rank and is intended to turn off logging.</p>"}}]},{type:"constant",attributes:{"name":"ROOT_LOGGER"},children:[{type:"desc",attributes:{"text":"<p>The root logger. This is the root of the logger tree. All loggers should be a child or grand child of this root logger.</p>\n\n<p>This logger logs by default everything greater than level <span class=\"caps\">INFO</span> to a log window.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Logger"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.RingBufferAppender","name":"RingBufferAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An appender that writes all messages to a memory container. The messages can be retrieved later, f. i. when an error dialog pops up and the question arises what actions have caused the error.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"50","type":"number","name":"maxMessages"},children:[{type:"desc",attributes:{"text":"<p>The maximum number of messages to hold. If null the number of messages is not limited. Warning: Changing this property will clear the events logged so far.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"name":"formatLogEvents"},children:[{type:"params",children:[{type:"param",attributes:{"name":"count"},children:[{type:"desc",attributes:{"text":"<p>The number of events to retreive. If there are more events than the given count, the oldest ones will not be returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a string holding the information of log events which have been logged previously.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"retrieveLogEvents"},children:[{type:"params",children:[{type:"param",attributes:{"name":"count"},children:[{type:"desc",attributes:{"text":"<p>The number of events to retreive. If there are more events than the given count, the oldest ones will not be returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns log events which have been logged previously.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>array of stored log events</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"array"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev.log","fullName":"qx.dev.log.WindowAppender","name":"WindowAppender","superClass":"qx.dev.log.Appender"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"\"qx_log\"","name":"name"},children:[{type:"desc",attributes:{"text":"<p>the name of the log window.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>An appender that writes all messages to a log window.</p>\n\n<p>This class does not depend on qooxdoo widgets, so it also works when there are problems with widgets or when the widgets are not yet initialized.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"500","type":"number","name":"maxMessages"},children:[{type:"desc",attributes:{"text":"<p>The maximum number of messages to show. If null the number of messages is not limited.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"false","type":"boolean","name":"popUnder"},children:[{type:"desc",attributes:{"text":"<p>Whether the window should appear under the main window.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.dev.log.Appender","overriddenFrom":"qx.dev.log.Appender","name":"appendLogEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]}]},{type:"method",attributes:{"name":"closeWindow"},children:[{type:"desc",attributes:{"text":"<p>Closes the log window.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"name":"openWindow"},children:[{type:"desc",attributes:{"text":"<p>Creates and opens the log window if it doesn&#8217;t alread exist.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"getAppender"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"},children:[{type:"desc",attributes:{"text":"<p>the ID of the wanted WindowAppender.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a prviously registered WindowAppender.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the WindowAppender or null if no WindowAppender with this ID is registered.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"WindowAppender"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"register"},children:[{type:"params",children:[{type:"param",attributes:{"name":"appender"},children:[{type:"desc",attributes:{"text":"<p>the WindowAppender to register.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"WindowAppender"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers a WindowAppender. This is used by the WindowAppender internally. You don&#8217;t have to call this.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the ID.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]}]}]}]}]}]},{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.dev","fullName":"qx.dev.Pollution","isStatic":"true","name":"Pollution","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"consoleInfo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"173"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"extract"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"178"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getHtmlTable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"214"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getTextList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"object"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"235"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dev","fullName":"qx.dev.TimeTracker","name":"TimeTracker","hasWarning":"true","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"compare"},children:[{type:"params",children:[{type:"param",attributes:{"name":"a"}},{type:"param",attributes:{"name":"b"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"35"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"buttonSets"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"50"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"start"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRounds"}},{type:"param",attributes:{"name":"vLoops"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"97"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.dom","name":"dom","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Dimension","isStatic":"true","name":"Dimension","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"84"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBoxHeightForZeroWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"63"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"80"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBoxWidthForZeroHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"46"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getInnerHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"158"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getInnerWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"157"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getOuterHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"44"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getOuterWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"43"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarSizeBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"219"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarSizeLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"216"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarSizeRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"218"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarSizeTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"217"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarVisibleX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"221"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScrollBarVisibleY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"222"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Element","isStatic":"true","name":"Element"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"cleanWhitespace"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes whitespace-only text node children</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"isEmpty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Checks if a element has no content</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"setTextContent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> node</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"sValue"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the textValue of the given <span class=\"caps\">DOM</span> element. Wrapper for element.innerText and element.textContent.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.ElementFromPoint","isStatic":"true","name":"ElementFromPoint","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getElementAbsolutePointChecker"},children:[{type:"params",children:[{type:"param",attributes:{"name":"chc"}},{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"58","line":"94"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getElementFromPoint"},children:[{type:"params",children:[{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"47","line":"26"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getElementFromPointChecker"},children:[{type:"params",children:[{type:"param",attributes:{"name":"chc"}},{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"54","line":"64"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getElementFromPointHandler"},children:[{type:"params",children:[{type:"param",attributes:{"name":"node"}},{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}},{type:"param",attributes:{"name":"recursive"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"54","line":"30"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.EventRegistration","isStatic":"true","name":"EventRegistration"}},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Iframe","isStatic":"true","name":"Iframe","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBody"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIframe"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"83"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Location","isStatic":"true","name":"Location","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientAreaBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"155"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientAreaRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"154"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientInnerBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"166"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientInnerLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"163"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientInnerRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"165"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientInnerTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"164"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientOuterBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"36"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientOuterLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"33"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientOuterRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"35"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientOuterTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"34"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageAreaBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"158"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageAreaRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"157"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageInnerBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageInnerLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"168"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageInnerRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"170"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageInnerTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"169"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageOuterBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"31"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageOuterLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"28"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageOuterRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"30"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageOuterTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"29"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenAreaBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"229"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenAreaLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"226"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenAreaRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"228"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenAreaTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"227"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenBoxBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"219"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenBoxRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"218"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenInnerBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"234"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenInnerLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"231"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenInnerRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"233"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenInnerTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"232"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenOuterBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"224"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenOuterLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"221"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenOuterRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"223"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenOuterTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"222"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Node","isStatic":"true","name":"Node","hasWarning":"true"},children:[{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"ELEMENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"26"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ATTRIBUTE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"27"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TEXT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"28"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"CDATA_SECTION"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"29"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ENTITY_REFERENCE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"30"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ENTITY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"31"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"PROCESSING_INSTRUCTION"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"32"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"COMMENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"33"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"DOCUMENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"34"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"DOCUMENT_TYPE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"35"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"DOCUMENT_FRAGMENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"36"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"NOTATION"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"37"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Offset","isStatic":"true","name":"Offset"}},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Scroll","isStatic":"true","name":"Scroll","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getLeftSum"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"27"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getTopSum"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"41"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.ScrollIntoView","isStatic":"true","name":"ScrollIntoView","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"scrollX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}},{type:"param",attributes:{"name":"vAlignLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"35"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"scrollY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}},{type:"param",attributes:{"name":"vAlignTop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"106"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Style","isStatic":"true","name":"Style","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBorderBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"122"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBorderLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"119"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBorderRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"121"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getBorderTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"120"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getMarginBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"112"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getMarginLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"109"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getMarginRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"111"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getMarginTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"110"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"117"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"114"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"116"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"115"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getStyleSize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}},{type:"param",attributes:{"name":"prop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"105"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.StyleSheet","isStatic":"true","name":"StyleSheet"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"addImport"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vUrl"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>add an import of an external <span class=\"caps\">CSS</span> file to a stylesheet</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"addRule"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":"<p>the target Stylesheet object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vSelector"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"vStyle"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>insert a new <span class=\"caps\">CSS</span> rule into a given Stylesheet</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"createElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCssText"},children:[{type:"desc",attributes:{"text":"<p>optional string of css rules</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>create a new Stylesheet node and append it to the document</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeAllImports"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>remove all imports from a stylesheet</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeAllRules"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>remove all <span class=\"caps\">CSS</span> rules from a stylesheet</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeImport"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vUrl"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">URL</span> of the importet <span class=\"caps\">CSS</span> file</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>removes an import from a stylesheet</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"removeRule"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"},children:[{type:"desc",attributes:{"text":"<p>the Stylesheet</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"vSelector"},children:[{type:"desc",attributes:{"text":"<p>the Selector of the rule to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>remove a <span class=\"caps\">CSS</span> rule from a stylesheet</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.dom","fullName":"qx.dom.Window","isStatic":"true","name":"Window"}}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.event","name":"event","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.event","fullName":"qx.event.handler","name":"handler","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.event.handler","fullName":"qx.event.handler.DragAndDropHandler","name":"DragAndDropHandler","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"events",children:[{type:"event",attributes:{"name":"dragdrop"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]},{type:"event",attributes:{"name":"dragend"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]},{type:"event",attributes:{"name":"dragmove"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]},{type:"event",attributes:{"name":"dragout"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]},{type:"event",attributes:{"name":"dragover"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]},{type:"event",attributes:{"name":"dragstart"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DragEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This manager (singleton) manage all drag and drop handling of a qx.core.Init instance.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"currentAction"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"55"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"cursor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"54"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"destinationWidget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"53"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"sourceWidget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"52"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_endDrag"},children:[{type:"params",children:[{type:"param",attributes:{"name":"currentDestinationWidget"}},{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>This will be called to the end of each drag and drop session</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter currentDestinationWidget is not documented.","column":"21","line":"472"}},{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"21","line":"472"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_endDragCore"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"491"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalNewAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vKeyShift"}},{type:"param",attributes:{"name":"vKeyCtrl"}},{type:"param",attributes:{"name":"vKeyAlt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"731"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_fireUserEvents"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromWidget"}},{type:"param",attributes:{"name":"toWidget"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"197"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"397"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleKeyUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"422"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>This starts the core drag and drop session.</p>\n\n<p>To really get drag and drop working you need to define a function which you attach to &#8220;dragstart&#8221;-event, which invokes at least this.startDrag()</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"29","line":"253"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Handler for mouse move events</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"29","line":"281"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Handle mouse up event. Normally this finalize the drag and drop event.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"27","line":"346"}}]}]},{type:"method",attributes:{"name":"_renderCursor"},children:[{type:"desc",attributes:{"text":"<p>Select and setup the current used cursor</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAction"}},{type:"param",attributes:{"name":"vForce"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"694"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vMimeType"}},{type:"param",attributes:{"name":"vData"}}]},{type:"desc",attributes:{"text":"<p>Add data of mimetype.</p>\n\n<p>#param vMimeType[String]: A valid mimetype<br />\n#param vData[Any]: Any value for the mimetype</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vMimeType is not documented.","column":"20","line":"109"}},{type:"error",attributes:{"msg":"Parameter vData is not documented.","column":"20","line":"109"}}]}]},{type:"method",attributes:{"hasError":"true","name":"cancelDrag"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Cancel current drag and drop session</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"23","line":"458"}}]}]},{type:"method",attributes:{"hasError":"true","name":"clearActions"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"704"}}]}]},{type:"method",attributes:{"hasError":"true","name":"clearData"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"117"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.manager.object.ObjectManager","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vMimeType"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"113"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getDropDataTypes"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"135"}}]}]},{type:"method",attributes:{"hasError":"true","name":"globalCancelDrag"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"462"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleKeyEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>This wraps the key events to custom handlers.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"27","line":"379"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>This wraps the mouse events to custom handlers.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"29","line":"231"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAction"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"710"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAction"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"720"}}]}]},{type:"method",attributes:{"name":"startDrag"},children:[{type:"desc",attributes:{"text":"<p>This needed be called from any &#8220;dragstart&#8221; event to really start drag session.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"supportsDrop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"598"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.event.handler","fullName":"qx.event.handler.EventHandler","name":"EventHandler","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This manager registers and manage all incoming key and mouse events.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"__ondragevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"45"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onmouseevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"44"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onselectevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"46"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onwindowblur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"49"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onwindowfocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"50"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onwindowresize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"51"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_checkKeyEventMatch"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"169"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondragevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"1010"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyevent_post"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}},{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vKeyCode"}},{type:"param",attributes:{"name":"vCharCode"}},{type:"param",attributes:{"name":"vKeyIdentifier"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"486"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseevent_post"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}},{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vDomTarget"}}]},{type:"desc",attributes:{"text":"<p>This is the crossbrowser post handler for all mouse events.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vDomEvent is not documented.","column":"31","line":"728"}},{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"31","line":"728"}},{type:"error",attributes:{"msg":"Parameter vDomTarget is not documented.","column":"31","line":"728"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onselectevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"1031"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onwindowblur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1057"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onwindowfocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"1091"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onwindowresize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1107"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"allowClientContextMenu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"62"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"allowClientSelectAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"63"}}]}]},{type:"property",attributes:{"allowNull":"true","hasError":"true","type":"Object","name":"captureWidget","instance":"qx.ui.core.Widget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"65"}}]}]},{type:"property",attributes:{"allowNull":"true","hasError":"true","type":"Object","name":"focusRoot","instance":"qx.ui.core.Parent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"66"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addCommand"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCommand"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"161"}}]}]},{type:"method",attributes:{"hasError":"true","name":"attachEvents"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"201"}}]}]},{type:"method",attributes:{"hasError":"true","name":"attachEventTypes"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEventTypes"}},{type:"param",attributes:{"name":"vFunctionPointer"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"249"}}]}]},{type:"method",attributes:{"hasError":"true","name":"detachEvents"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"219"}}]}]},{type:"method",attributes:{"hasError":"true","name":"detachEventTypes"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEventTypes"}},{type:"param",attributes:{"name":"vFunctionPointer"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"269"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"removeCommand"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCommand"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"165"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getOriginalTargetObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"300"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getOriginalTargetObjectFromEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}},{type:"param",attributes:{"name":"vWindow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"373"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getRelatedOriginalTargetObjectFromEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"52","line":"391"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getRelatedTargetObjectFromEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"440"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getTargetObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNode"}},{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"401"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getTargetObjectFromEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"435"}}]}]},{type:"method",attributes:{"isStatic":"true","name":"stopDomEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"},children:[{type:"desc",attributes:{"text":"<p>(Element) <span class=\"caps\">DOM</span> event object</p>"}}]}]},{type:"desc",attributes:{"text":"<p>stops further propagation of the event</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.event.handler","fullName":"qx.event.handler.FocusHandler","name":"FocusHandler","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"desc",attributes:{"text":"<p>This object gets an instance in each focus root and manage the focus handling for it.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vWidget is not documented.","column":"1","line":"31"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"compareTabOrder"},children:[{type:"params",children:[{type:"param",attributes:{"name":"c1"}},{type:"param",attributes:{"name":"c2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"106"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getAttachedWidget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"51"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirstWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParentContainer"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"160"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParentContainer"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"164"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWidgetAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParentContainer"}},{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"168"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWidgetBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParentContainer"}},{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"191"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_getAllAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vWidget"}},{type:"param",attributes:{"name":"vArray"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"215"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getAllBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vWidget"}},{type:"param",attributes:{"name":"vArray"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"239"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getFirst"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vFirstWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getLast"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vLastWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"292"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vContainer"}},{type:"param",attributes:{"name":"vEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"72"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.event.handler","fullName":"qx.event.handler.KeyEventHandler","name":"KeyEventHandler","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This class provides unified key event handler for Internet Explorer, Firefox, Opera and Safari</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"__onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"39"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onkeyupdown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"40"}}]}]},{type:"method",attributes:{"name":"_attachEvents"},children:[{type:"desc",attributes:{"text":"<p>attach the key event handler to the <span class=\"caps\">DOM</span> events</p>"}}]},{type:"method",attributes:{"name":"_charCodeToIdentifier"},children:[{type:"params",children:[{type:"param",attributes:{"name":"charCode"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>converts a character code to the corresponding identifier</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) key identifier</p>"}}]}]},{type:"method",attributes:{"name":"_detachEvents"},children:[{type:"desc",attributes:{"text":"<p>detach the key event handler from the <span class=\"caps\">DOM</span> events</p>"}}]},{type:"method",attributes:{"name":"_idealKeyHandler"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>(string) keyboard code</p>"}}]},{type:"param",attributes:{"name":"charCode"},children:[{type:"desc",attributes:{"text":"<p>(string) character code</p>"}}]},{type:"param",attributes:{"name":"eventType"},children:[{type:"desc",attributes:{"text":"<p>(string) type of the event (keydown, keypress, keyup)</p>"}}]},{type:"param",attributes:{"name":"domEvent"},children:[{type:"desc",attributes:{"text":"<p>(Element) DomEvent</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Key handler for an idealized browser. Runs after the browser specific key handlers have normalized the key events.</p>"}}]},{type:"method",attributes:{"name":"_identifierToKeyCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyIdentifier"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>converts a key identifier back to a keycode</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(int) keyboard code</p>"}}]}]},{type:"method",attributes:{"name":"_isIdentifiableKeyCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Check wether the keycode can be reliably detected in keyup/keydown events</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(boolean)</p>"}}]}]},{type:"method",attributes:{"name":"_isNonPrintableKeyCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Checks wether the keyCode represents a non printable key</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(boolean)</p>"}}]}]},{type:"method",attributes:{"name":"_keyCodeToIdentifier"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>(int)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>converts a keyboard code to the corresponding identifier</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) key identifier</p>"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Target","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor</p>"}}]},{type:"method",attributes:{"name":"isValidKeyIdentifier"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyIdentifier"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Checks wether a given string is a valid keyIdentifier</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(boolean) wether the given string is a valid keyIdentifier</p>"}}]}]},{type:"method",attributes:{"name":"oldKeyNameToKeyIdentifier"},children:[{type:"params",children:[{type:"param",attributes:{"name":"keyName"},children:[{type:"desc",attributes:{"text":"<p>(string) old name of the key.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>converts an old key name as found in</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) corresponding keyIdentifier or &#8220;Unidentified&#8221; if a conversion was not possible</p>"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.event","fullName":"qx.event.type","name":"type","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.event.type","fullName":"qx.event.type.DataEvent","name":"DataEvent","hasWarning":"true","superClass":"qx.event.type.Event"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vData"}}]},{type:"desc",attributes:{"text":"<p>Event object for property changes.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vData is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","name":"data"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"37"}}]}]},{type:"property",attributes:{"docFrom":"qx.event.type.Event","defaultValue":"false","overriddenFrom":"qx.event.type.Event","name":"propagationStopped","hasWarning":"true"}}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.event.type.Event","name":"dispose"}}]}]},{type:"class",attributes:{"name":"DomEvent","hasWarning":"true","packageName":"qx.event.type","superClass":"qx.event.type.Event","childClasses":"qx.event.type.KeyEvent,qx.event.type.MouseEvent","fullName":"qx.event.type.DomEvent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vDomEvent"}},{type:"param",attributes:{"name":"vDomTarget"}},{type:"param",attributes:{"name":"vTarget"}},{type:"param",attributes:{"name":"vOriginalTarget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"docFrom":"qx.event.type.Event","defaultValue":"true","overriddenFrom":"qx.event.type.Event","name":"bubbles","hasWarning":"true"}},{type:"property",attributes:{"hasError":"true","name":"domEvent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"40"}}]}]},{type:"property",attributes:{"hasError":"true","name":"domTarget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"41"}}]}]},{type:"property",attributes:{"docFrom":"qx.event.type.Event","defaultValue":"false","overriddenFrom":"qx.event.type.Event","name":"propagationStopped","hasWarning":"true"}}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computeModifiers"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"51"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.event.type.Event","name":"dispose"}},{type:"method",attributes:{"name":"isAltPressed"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the the alt key is pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the the alt key is pressed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isCtrlOrCommandPressed"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the ctrl key or (on the Mac) the command key is pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> if the command key is pressed on the Mac or the ctrl key is pressed on another system."}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isCtrlPressed"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the the ctrl key is pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the the ctrl key is pressed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isMetaPressed"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the the meta key is pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the the meta key is pressed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isShiftPressed"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the the shift key is pressed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the the shift key is pressed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"SHIFT_MASK"},children:[{type:"desc",attributes:{"text":"<p>The modifier mask for the shift key.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"CTRL_MASK"},children:[{type:"desc",attributes:{"text":"<p>The modifier mask for the control key.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"ALT_MASK"},children:[{type:"desc",attributes:{"text":"<p>The modifier mask for the alt key.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"META_MASK"},children:[{type:"desc",attributes:{"text":"<p>The modifier mask for the meta key (e.g. apple key on Macs).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.event.type","fullName":"qx.event.type.DragEvent","name":"DragEvent","hasWarning":"true","superClass":"qx.event.type.MouseEvent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vMouseEvent"}},{type:"param",attributes:{"name":"vTarget"}},{type:"param",attributes:{"name":"vRelatedTarget"}}]},{type:"desc",attributes:{"text":"<p>The event object for drag and drop sessions</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vMouseEvent is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vTarget is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vRelatedTarget is not documented.","column":"1","line":"29"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sAction"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"118"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sType"}},{type:"param",attributes:{"name":"oData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"91"}}]}]},{type:"method",attributes:{"hasError":"true","name":"clearActions"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"130"}}]}]},{type:"method",attributes:{"hasError":"true","name":"clearData"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"99"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.event.type.DomEvent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getAction"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"126"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sType"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"95"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getDropDataTypes"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"103"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMouseEvent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"55"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sAction"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"122"}}]}]},{type:"method",attributes:{"hasError":"true","name":"startDrag"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"70"}}]}]}]}]},{type:"class",attributes:{"name":"Event","hasWarning":"true","packageName":"qx.event.type","superClass":"qx.core.Object","childClasses":"qx.event.type.DataEvent,qx.event.type.DomEvent,qx.event.type.FocusEvent","fullName":"qx.event.type.Event"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}}]},{type:"desc",attributes:{"text":"<p>The qooxdoo core event object. Each event object for qx.core.Targets should extend this class.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"false","name":"autoDispose"},children:[{type:"desc",attributes:{"text":"<p>If the event object should automatically be disposed by the dispatcher</p>"}}]},{type:"property",attributes:{"defaultValue":"false","hasError":"true","name":"bubbles"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"43"}}]}]},{type:"property",attributes:{"hasError":"true","name":"currentTarget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"41"}}]}]},{type:"property",attributes:{"defaultValue":"false","hasError":"true","name":"defaultPrevented"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"45"}}]}]},{type:"property",attributes:{"hasError":"true","name":"originalTarget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"38"}}]}]},{type:"property",attributes:{"defaultValue":"true","hasError":"true","name":"propagationStopped"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"44"}}]}]},{type:"property",attributes:{"hasError":"true","name":"relatedTarget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"40"}}]}]},{type:"property",attributes:{"hasError":"true","name":"target"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"39"}}]}]},{type:"property",attributes:{"hasError":"true","name":"type"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"36"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"preventDefault"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"59"}}]}]},{type:"method",attributes:{"hasError":"true","name":"stopPropagation"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"63"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.event.type","fullName":"qx.event.type.FocusEvent","name":"FocusEvent","hasWarning":"true","superClass":"qx.event.type.Event"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vTarget"}}]},{type:"desc",attributes:{"text":"<p>This event handles all focus events.</p>\n\n<p>The four supported types are: 1+2: focus and blur also propagate the target object 3+4: focusout and focusin are bubbling to the parent objects</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vTarget is not documented.","column":"1","line":"33"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.event.type","fullName":"qx.event.type.KeyEvent","name":"KeyEvent","superClass":"qx.event.type.DomEvent"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"},children:[{type:"desc",attributes:{"text":"<p>(string) event type (keydown, keypress, keyinput, keyup)</p>"}}]},{type:"param",attributes:{"name":"vDomEvent"},children:[{type:"desc",attributes:{"text":"<p>(Element) <span class=\"caps\">DOM</span> event object</p>"}}]},{type:"param",attributes:{"name":"vDomTarget"},children:[{type:"desc",attributes:{"text":"<p>(Element) target element of the <span class=\"caps\">DOM</span> event</p>"}}]},{type:"param",attributes:{"name":"vTarget"},children:[{type:"desc",attributes:{"text":""}}]},{type:"param",attributes:{"name":"vOriginalTarget"},children:[{type:"desc",attributes:{"text":""}}]},{type:"param",attributes:{"name":"vKeyCode"},children:[{type:"desc",attributes:{"text":"<p>(int)</p>"}}]},{type:"param",attributes:{"name":"vCharCode"},children:[{type:"desc",attributes:{"text":"<p>(int)</p>"}}]},{type:"param",attributes:{"name":"vKeyIdentifier"},children:[{type:"desc",attributes:{"text":"<p>(string)</p>"}}]}]},{type:"desc",attributes:{"text":"<p>A key event instance contains all data for each occured key event</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"charCode"},children:[{type:"desc",attributes:{"text":"<p>Unicode number of the pressed character. Only valid in &#8220;keyinput&#8221; events</p>"}}]},{type:"property",attributes:{"name":"keyCode"},children:[{type:"desc",attributes:{"text":"<p>Legacy keycode</p>"}}]},{type:"property",attributes:{"name":"keyIdentifier"},children:[{type:"desc",attributes:{"text":"<p>Identifier of the pressed key. Not Valid in &#8220;keyinput&#8221; events&#8221;</p>"}}]}]}]},{type:"class",attributes:{"name":"MouseEvent","hasWarning":"true","packageName":"qx.event.type","superClass":"qx.event.type.DomEvent","childClasses":"qx.event.type.DragEvent","fullName":"qx.event.type.MouseEvent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vType"}},{type:"param",attributes:{"name":"vDomEvent"}},{type:"param",attributes:{"name":"vDomTarget"}},{type:"param",attributes:{"name":"vTarget"}},{type:"param",attributes:{"name":"vOriginalTarget"}},{type:"param",attributes:{"name":"vRelatedTarget"}}]},{type:"desc",attributes:{"text":"<p>A mouse event instance contains all data for each occured mouse event</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vType is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vDomEvent is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vDomTarget is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vTarget is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vOriginalTarget is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vRelatedTarget is not documented.","column":"1","line":"29"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"C_BUTTON_LEFT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"38"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"C_BUTTON_MIDDLE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"39"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"C_BUTTON_RIGHT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"40"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"C_BUTTON_NONE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"41"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_storeEventState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"58"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getButton"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"75"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"71"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getClientY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"72"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"73"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPageY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"74"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"69"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getScreenY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"70"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"getScreenX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"101"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScreenY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"105"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isMiddleButtonPressed"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"237"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isRightButtonPressed"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"241"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","name":"button"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"217"}}]}]},{type:"property",attributes:{"hasError":"true","name":"wheelDelta"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"290"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computeButton"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"245"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.io","name":"io","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.io","fullName":"qx.io.image","name":"image","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.io.image","fullName":"qx.io.image.Preloader","name":"Preloader","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"error"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"load"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]},{type:"desc",attributes:{"text":"<p>This is the preloader used from qx.ui.basic.Image instances.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vSource is not documented.","column":"1","line":"32"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getIsPng"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"114"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSource"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"108"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getUri"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"107"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isErroneous"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"110"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isLoaded"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"109"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"__onerror"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"138"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"__onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"137"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onerror"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"154"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"140"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.io.image","fullName":"qx.io.image.PreloaderSystem","name":"PreloaderSystem","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"completed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPreloadList"}},{type:"param",attributes:{"name":"vCallBack"}},{type:"param",attributes:{"name":"vCallBackScope"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vPreloadList is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vCallBack is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vCallBackScope is not documented.","column":"1","line":"29"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"start"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"69"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_check"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"141"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onerror"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"114"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"120"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"108"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.io","fullName":"qx.io.local","name":"local","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.io.local","fullName":"qx.io.local.CookieApi","isStatic":"true","name":"CookieApi","hasWarning":"true"},children:[{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"STR_EXPIRES"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"26"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_PATH"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"27"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_DOMAIN"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"28"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_SECURE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"29"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_DELDATA"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"30"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"del"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vPath"}},{type:"param",attributes:{"name":"vDomain"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"107"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"43"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"set"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vValue"}},{type:"param",attributes:{"name":"vExpires"}},{type:"param",attributes:{"name":"vPath"}},{type:"param",attributes:{"name":"vDomain"}},{type:"param",attributes:{"name":"vSecure"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"65"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.io.local","fullName":"qx.io.local.CookieTransport","isStatic":"true","name":"CookieTransport","hasWarning":"true"},children:[{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"BASENAME"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"26"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ITEMSEPARATOR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"27"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"KEYVALUESEPARATOR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"28"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MAXCOOKIES"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"29"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MAXSIZE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"30"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"del"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"66"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"delAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"88"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"54"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"80"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"replaceAll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"84"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"set"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"43"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"setAll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"73"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_delCookie"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"177"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_getAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_setAll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"124"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_setCookie"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vString"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"171"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.io","fullName":"qx.io.remote","name":"remote","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"isAbstract":"true","name":"AbstractRemoteTransport","hasWarning":"true","packageName":"qx.io.remote","superClass":"qx.core.Target","childClasses":"qx.io.remote.IframeTransport,qx.io.remote.ScriptTransport,qx.io.remote.XmlHttpTransport","fullName":"qx.io.remote.AbstractRemoteTransport"},children:[{type:"events",children:[{type:"event",attributes:{"name":"aborted"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"completed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"configured"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"created"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"failed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"receiving"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"sending"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":""}}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"boolean","name":"asynchronous"},children:[{type:"desc",attributes:{"text":"<p>Set the request to asynchronous</p>"}}]},{type:"property",attributes:{"type":"string","name":"data"},children:[{type:"desc",attributes:{"text":"<p>Set the data to be sent via this request</p>"}}]},{type:"property",attributes:{"type":"string","name":"method"},children:[{type:"desc",attributes:{"text":"<p>Determines what type of request to issue</p>"}}]},{type:"property",attributes:{"type":"Object","name":"parameters"},children:[{type:"desc",attributes:{"text":"<p>Request parameters to send.</p>"}}]},{type:"property",attributes:{"type":"string","name":"password"},children:[{type:"desc",attributes:{"text":"<p>Password to use for <span class=\"caps\">HTTP</span> authentication</p>"}}]},{type:"property",attributes:{"type":"Object","name":"requestHeaders"},children:[{type:"desc",attributes:{"text":"<p>Request headers</p>"}}]},{type:"property",attributes:{"type":"string","name":"responseType"},children:[{type:"desc",attributes:{"text":"<p>Response Type</p>"}}]},{type:"property",attributes:{"possibleValues":"\"created\", \"configured\", \"sending\", \"receiving\", \"completed\", \"aborted\", \"timeout\", \"failed\"","defaultValue":"\"created\"","type":"string","name":"state"},children:[{type:"desc",attributes:{"text":"<p>The state of the current request</p>"}}]},{type:"property",attributes:{"type":"string","name":"url"},children:[{type:"desc",attributes:{"text":"<p>Target url to issue the request to</p>"}}]},{type:"property",attributes:{"type":"boolean","name":"useBasicHttpAuth"},children:[{type:"desc",attributes:{"text":"<p>Use Basic <span class=\"caps\">HTTP</span> Authentication</p>"}}]},{type:"property",attributes:{"type":"string","name":"username"},children:[{type:"desc",attributes:{"text":"<p>Username to use for <span class=\"caps\">HTTP</span> authentication</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"abort"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"133"}}]}]},{type:"method",attributes:{"name":"failed"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the failed state (&#8220;failed&#8221;).</p>\n\n<p>Listeners of the &#8220;failed&#8221; signal are notified about the event.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"getFetchedLength"},children:[{type:"desc",attributes:{"text":"<p>Returns the length of the content as fetched thus far</p>"}}]},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"201"}}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Provides an hash of all response headers.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"getResponseText"},children:[{type:"desc",attributes:{"text":"<p>Provides the response text from the request when available and null otherwise. By passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will be made available to the caller.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"getResponseXml"},children:[{type:"desc",attributes:{"text":"<p>Provides the <span class=\"caps\">XML</span> provided by the response if any and null otherwise. By passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will be made available to the caller.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the current status code of the request if available or -1 if not.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Provides the status text for the current request if available and null otherwise.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"send"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"129"}}]}]},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"desc",attributes:{"text":"<p>Add a request header to this transports qx.io.remote.Request.</p>\n\n<p>This method is virtual and concrete subclasses are supposed to implement it.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vLabel is not documented.","column":"29","line":"186"}},{type:"error",attributes:{"msg":"Parameter vValue is not documented.","column":"29","line":"186"}}]}]},{type:"method",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":""}}]}]}]},{type:"class",attributes:{"packageName":"qx.io.remote","fullName":"qx.io.remote.Exchange","name":"Exchange","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"aborted"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"completed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"failed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"receiving"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"sending"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vRequest is not documented.","column":"1","line":"38"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"canHandle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vImpl"}},{type:"param",attributes:{"name":"vNeeds"}},{type:"param",attributes:{"name":"vResponseType"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"103"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initTypes"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"81"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"registerType"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vClass"}},{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"77"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"statusCodeToString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStatusCode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"286"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"wasSuccessful"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStatusCode"}},{type:"param",attributes:{"name":"vReadyState"}},{type:"param",attributes:{"name":"vIsLocal"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"168"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"Object","name":"implementation"},children:[{type:"desc",attributes:{"text":"<p>Set the implementation to use to send the request with.</p>\n\n<p>The implementation should be a subclass of qx.io.remote.AbstractRemoteTransport and must implement all methods in the transport <span class=\"caps\">API</span>.</p>"}}]},{type:"property",attributes:{"instance":"qx.io.remote.Request","type":"Object","name":"request"},children:[{type:"desc",attributes:{"text":"<p>Set the request to send with this transport.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"configured\", \"sending\", \"receiving\", \"completed\", \"aborted\", \"timeout\", \"failed\"","defaultValue":"\"configured\"","hasError":"true","type":"string","name":"state"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"359"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the aborted (&#8220;aborted&#8221;) state.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"send"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"385"}}]}]},{type:"method",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the timeout state.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onabort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"525"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oncompleted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"521"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onfailed"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"529"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onreceiving"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"517"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onsending"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"513"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ontimeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"533"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"IframeTransport","hasWarning":"true","packageName":"qx.io.remote","superClass":"qx.io.remote.AbstractRemoteTransport","fullName":"qx.io.remote.IframeTransport"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Transports requests to a server using an <span class=\"caps\">IFRAME</span>.</p>\n\n<p>This class should not be used directly by client programmers.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isSupported"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"102"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getFetchedLength"},children:[{type:"desc",attributes:{"text":"<p>Returns the length of the content as fetched thus far</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getIframeBody"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"327"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIframeDocument"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"323"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIframeHtmlContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"364"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIframeTextContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"344"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIframeWindow"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"319"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getResponseContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"381"}}]}]},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeader","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Provides an hash of all response headers.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the current status code of the request if available or -1 if not.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Provides the status text for the current request if available and null otherwise.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"send","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vValue"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Converting complete state to numeric value and update state property</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"20","line":"192"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onreadystatechange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Converting named readyState to numeric value and update state property</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"32","line":"204"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_switchReadyState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vReadyState"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"208"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.io.remote","fullName":"qx.io.remote.Request","name":"Request","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vUrl"},children:[{type:"desc",attributes:{"text":"<p>Target url to issue the request to.</p>"}}]},{type:"param",attributes:{"name":"vMethod"},children:[{type:"desc",attributes:{"text":"<p>Determines what type of request to issue (GET or <span class=\"caps\">POST</span>). Default is <span class=\"caps\">GET</span>.</p>"}}]},{type:"param",attributes:{"name":"vResponseType"},children:[{type:"desc",attributes:{"text":"<p>The mime type of the response. Default is text/plain.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>This class is used to send <span class=\"caps\">HTTP</span> requests to the server.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isAsynchronous","defaultValue":"true","type":"boolean","name":"asynchronous"},children:[{type:"desc",attributes:{"text":"<p>Set the request to asynchronous.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"crossDomain"},children:[{type:"desc",attributes:{"text":"<p>Indicate that the request is cross domain.</p>\n\n<p>A request is cross domain if the request&#8217;s <span class=\"caps\">URL</span> points to a host other than the local host. This switches the concrete implementation that is used for sending the request from qx.io.remote.XmlHttpTransport to qx.io.remote.ScriptTransport, because only the latter can handle cross domain requests.</p>"}}]},{type:"property",attributes:{"type":"string","name":"data"},children:[{type:"desc",attributes:{"text":"<p>Set the data to be sent via this request</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"fileUpload"},children:[{type:"desc",attributes:{"text":"<p>Indicate that the request will be used for a file upload.</p>\n\n<p>The request will be used for a file upload.  This switches the concrete implementation that is used for sending the request from qx.io.remote.XmlHttpTransport to qx.io.remote.IFrameTransport, because only the latter can handle file uploads.</p>"}}]},{type:"property",attributes:{"possibleValues":"qx.net.Http.METHOD_GET, qx.net.Http.METHOD_POST, qx.net.Http.METHOD_PUT, qx.net.Http.METHOD_HEAD, qx.net.Http.METHOD_DELETE","type":"string","name":"method"},children:[{type:"desc",attributes:{"text":"<p>Determines what type of request to issue (GET or <span class=\"caps\">POST</span>).</p>"}}]},{type:"property",attributes:{"type":"string","name":"password"},children:[{type:"desc",attributes:{"text":"<p>Password to use for <span class=\"caps\">HTTP</span> authentication. Null if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]},{type:"property",attributes:{"type":"boolean","name":"prohibitCaching"},children:[{type:"desc",attributes:{"text":"<p>Prohibit request from being cached.</p>\n\n<p>Setting the value to true adds a parameter &#8220;nocache&#8221; to the request with a value of the current time. Setting the value to false removes the parameter.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"text/plain\", \"text/javascript\", \"text/json\", \"application/xml\", \"text/html\"","hasError":"true","type":"string","name":"responseType"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"120"}}]}]},{type:"property",attributes:{"possibleValues":"\"configured\", \"queued\", \"sending\", \"receiving\", \"completed\", \"aborted\", \"timeout\", \"failed\"","defaultValue":"\"configured\"","hasError":"true","type":"string","name":"state"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"101"}}]}]},{type:"property",attributes:{"type":"number","name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Number of millieseconds before the request is being timed out.</p>\n\n<p>If this property is null, the timeout for the request comes is the qx.io.remote.RequestQueue&#8217;s property defaultTimeout.</p>"}}]},{type:"property",attributes:{"instance":"qx.io.remote.Exchange","type":"Object","name":"transport"},children:[{type:"desc",attributes:{"text":"<p>The transport instance used for the request.</p>\n\n<p>This is necessary to be able to abort an asynchronous request.</p>"}}]},{type:"property",attributes:{"type":"string","name":"url"},children:[{type:"desc",attributes:{"text":"<p>Target url to issue the request to.</p>"}}]},{type:"property",attributes:{"type":"boolean","name":"useBasicHttpAuth"},children:[{type:"desc",attributes:{"text":"<p>Use Basic <span class=\"caps\">HTTP</span> Authentication</p>"}}]},{type:"property",attributes:{"type":"string","name":"username"},children:[{type:"desc",attributes:{"text":"<p>Username to use for <span class=\"caps\">HTTP</span> authentication. Null if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Abort sending this request.</p>\n\n<p>The request is removed from the singleton class qx.io.remote.RequestQueue&#8217;s list of pending events. If the request haven&#8217;t been scheduled this method is a noop.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"name":"getParameter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"},children:[{type:"desc",attributes:{"text":"<p>String identifier of the parameter to get.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Get a parameter in the request.</p>"}}]},{type:"method",attributes:{"name":"getParameters"},children:[{type:"desc",attributes:{"text":"<p>Returns an object containg all parameters for the request.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"438"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRequestHeaders"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"442"}}]}]},{type:"method",attributes:{"name":"getSequenceNumber"},children:[{type:"desc",attributes:{"text":"<p>Obtain the sequence (id) number used for this request</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"isAborted"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"253"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isCompleted"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"249"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isConfigured"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"233"}}]}]},{type:"method",attributes:{"name":"isFailed"},children:[{type:"desc",attributes:{"text":"<p>Return true if the request is in the failed state (&#8220;failed&#8221;).</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"isQueued"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"237"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isReceiving"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"245"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isSending"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"241"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isTimeout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"257"}}]}]},{type:"method",attributes:{"name":"removeParameter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"},children:[{type:"desc",attributes:{"text":"<p>String identifier of the parameter to remove.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Remove a parameter from the request.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"removeRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"434"}}]}]},{type:"method",attributes:{"hasError":"true","name":"reset"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"206"}}]}]},{type:"method",attributes:{"name":"send"},children:[{type:"desc",attributes:{"text":"<p>Schedule this request for transport to server.</p>\n\n<p>The request is added to the singleton class qx.io.remote.RequestQueue&#8217;s list of pending requests.</p>"}}]},{type:"method",attributes:{"name":"setParameter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"},children:[{type:"desc",attributes:{"text":"<p>String identifier of the parameter to add.</p>"}}]},{type:"param",attributes:{"name":"vValue"},children:[{type:"desc",attributes:{"text":"<p>Value of parameter. May be a string (for one parameter) or an array of strings (for setting multiple parameter values with the same parameter name).</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Add a parameter to the request.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"desc",attributes:{"text":"<p>Add a request header to the request.</p>\n\n<p>Example: request.setRequestHeader(&#8220;Content-Type&#8221;, &#8220;text/html&#8221;)</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vId is not documented.","column":"29","line":"430"}},{type:"error",attributes:{"msg":"Parameter vValue is not documented.","column":"29","line":"430"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onaborted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"320"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oncompleted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"308"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onfailed"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"358"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onqueued"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"281"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onreceiving"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"299"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onsending"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"290"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ontimeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"332"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.io.remote","fullName":"qx.io.remote.RequestQueue","name":"RequestQueue","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Handles scheduling of requests to be sent to a server.</p>\n\n<p>This class is a singleton and is used by qx.io.remote.Request to schedule its requests. It should not be used directly.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"5000","type":"number","name":"defaultTimeout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"58"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"3","type":"number","name":"maxConcurrentRequests"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"57"}}]}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"maxTotalRequests"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"56"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_check"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"83"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_debug"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"71"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"280"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oncompleted"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"201"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"227"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onsending"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"190"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTransport"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"147"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"abort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"}}]},{type:"desc",attributes:{"text":"<p>Remove the request from the pending requests queue.</p>\n\n<p>The underlying transport of the request is forced into the aborted state (&#8220;aborted&#8221;) and listeners of the &#8220;aborted&#8221; signal are notified about the event. If the request isn&#8217;t in the pending requests queue, this method is a noop.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vRequest is not documented.","column":"18","line":"325"}}]}]},{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRequest"}}]},{type:"desc",attributes:{"text":"<p>Add the request to the pending requests queue.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vRequest is not documented.","column":"16","line":"305"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.io.remote","fullName":"qx.io.remote.Response","name":"Response","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","name":"content"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"44"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"responseHeaders"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"45"}}]}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"state"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"39"}}]}]},{type:"property",attributes:{"type":"number","name":"statusCode"},children:[{type:"desc",attributes:{"text":"<p>Status code of the response.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHeader"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"82"}}]}]}]}]},{type:"class",attributes:{"hasError":"true","name":"Rpc","hasWarning":"true","packageName":"qx.io.remote","superClass":"qx.core.Target","fullName":"qx.io.remote.Rpc"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation contains malformed event attribute.","column":"18","line":"70"}},{type:"error",attributes:{"msg":"Documentation contains malformed event attribute.","column":"18","line":"70"}},{type:"error",attributes:{"msg":"Documentation contains malformed event attribute.","column":"18","line":"70"}},{type:"error",attributes:{"msg":"Documentation contains malformed event attribute.","column":"18","line":"70"}}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"url"},children:[{type:"desc",attributes:{"text":"<p>identifies the url where the service is found.  Note that if the url is to a domain (server) other than where the qooxdoo script came from, i.e. it is cross-domain, then you must also call the setCrossDomain(true) method to enable the IframeTrannsport instead of the XmlHttpTransport, since the latter can not handle cross-domain requests.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"serviceName"},children:[{type:"desc",attributes:{"text":"<p>identifies the service. For the Java implementation, this is the fully qualified name of the class that offers the service methods (e.g. &#8220;my.pkg.MyService&#8221;).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Provides a Remote Procedure Call (RPC) implementation.</p>\n\n<p>Each instance of this class represents a &#8220;Service&#8221;. These services can correspond to various concepts on the server side (depending on the programming language/environment being used), but usually, a service means a class on the server.</p>\n\n<p>In case multiple instances of the same service are needed, they can be distinguished by ids. If such an id is specified, the server routes all calls to a service that have the same id to the same server-side instance.</p>\n\n<p>When calling a server-side method, the parameters and return values are converted automatically. Supported types are int (and Integer), double (and Double), String, Date, Map, and JavaBeans. Beans must habe a default constructor on the server side and are represented by simple JavaScript objects on the client side (used as associative arrays with keys matching the server-side properties). Beans can also be nested, but be careful to not create circular references! There are no checks to detect these (which would be expensive), so you as the user are responsible for avoiding them.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"crossDomain"},children:[{type:"desc",attributes:{"text":"<p>Indicate that the request is cross domain.</p>\n\n<p>A request is cross domain if the request&#8217;s <span class=\"caps\">URL</span> points to a host other than the local host. This switches the concrete implementation that is used for sending the request from qx.io.remote.XmlHttpTransport to qx.io.remote.ScriptTransport because only the latter can handle cross domain requests.</p>"}}]},{type:"property",attributes:{"type":"string","name":"password"},children:[{type:"desc",attributes:{"text":"<p>Password to use for <span class=\"caps\">HTTP</span> authentication. Null if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]},{type:"property",attributes:{"defaultValue":"undefined","type":"Object","name":"serverData"},children:[{type:"desc",attributes:{"text":"<p>Data sent as &#8220;out of band&#8221; data in the request to the server.  The format of the data is opaque to <span class=\"caps\">RPC</span> and may be recognized only by particular servers It is up to the server to decide what to do with it: whether to ignore it, handle it locally before calling the specified method, or pass it on to the method.  This server data is not sent to the server if it has been set to &#8216;undefined&#8217;.</p>"}}]},{type:"property",attributes:{"defaultValue":"null","type":"string","name":"serviceName"},children:[{type:"desc",attributes:{"text":"<p>The service name.</p>"}}]},{type:"property",attributes:{"type":"number","name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>The timeout for asynchronous calls in milliseconds.</p>"}}]},{type:"property",attributes:{"defaultValue":"null","type":"string","name":"url"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> at which the service is located.</p>"}}]},{type:"property",attributes:{"type":"boolean","name":"useBasicHttpAuth"},children:[{type:"desc",attributes:{"text":"<p>Use Basic <span class=\"caps\">HTTP</span> Authentication</p>"}}]},{type:"property",attributes:{"type":"string","name":"username"},children:[{type:"desc",attributes:{"text":"<p>Username to use for <span class=\"caps\">HTTP</span> authentication. Null if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_callInternal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"args"}},{type:"param",attributes:{"name":"callType"}},{type:"param",attributes:{"name":"refreshSession"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"178"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"abort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"opaqueCallRef"},children:[{type:"desc",attributes:{"text":"<p>the call reference as returned by <code>callAsync</code> or <code>callAsyncListeners</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Aborts an asynchronous server call. Consequently, the callback function provided to <code>callAsync</code> or <code>callAsyncListeners</code> will be called with an exception.</p>"}}]},{type:"method",attributes:{"name":"callAsync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"handler"},children:[{type:"desc",attributes:{"text":"<p>the callback function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"methodName"},children:[{type:"desc",attributes:{"text":"<p>the name of the method to call.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Makes an asynchronous server call. The method arguments (if any) follow after the method name (as normal JavaScript arguments, separated by commas, not as an array).</p>\n\n<p>When an answer from the server arrives, the <code>handler</code> function is called with the result of the call as the first,  an exception as the second parameter, and the id (aka sequence number) of the invoking request as the third parameter. If the call was successful, the second parameter is <code>null</code>. If there was a problem, the second parameter contains an exception, and the first one is <code>null</code>.</p>\n\n<p>The return value of this method is a call reference that you can store if you want to abort the request later on. This value should be treated as opaque and can change completely in the future! The only thing you can rely on is that the <code>abort</code> method will accept this reference and that you can retrieve the sequence number of the request by invoking the getSequenceNumber() method (see below).</p>\n\n<p>If a specific method is being called, asynchronously, a number of times in succession, the getSequenceNumber() method may be used to disambiguate which request a response corresponds to.  The sequence number value is a value which increments with each request.)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the method call reference.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"callAsyncListeners"},children:[{type:"params",children:[{type:"param",attributes:{"name":"coalesce"},children:[{type:"desc",attributes:{"text":"<p>(boolean)    coalesce all failure types (&#8220;failed&#8221;, &#8220;timeout&#8221;, and &#8220;aborted&#8221;) to &#8220;failed&#8221;. This is reasonable in many cases, as the provided exception contains adequate disambiguating information.</p>"}}]},{type:"param",attributes:{"name":"methodName"},children:[{type:"desc",attributes:{"text":"<p>(string)   the name of the method to call.</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Makes an asynchronous server call and dispatch an event upon completion or failure. The method arguments (if any) follow after the method name (as normal JavaScript arguments, separated by commas, not as an array).</p>\n\n<p>When an answer from the server arrives (or fails to arrive on time), if an exception occurred, a &#8220;failed&#8221;, &#8220;timeout&#8221; or &#8220;aborted&#8221; event, as appropriate, is dispatched to any waiting event listeners.  If no exception occurred, a &#8220;completed&#8221; event is dispatched.</p>\n\n<p>When a &#8220;failed&#8221;, &#8220;timeout&#8221; or &#8220;aborted&#8221; event is dispatched, the event data contains an object with the properties &#8216;origin&#8217;, &#8216;code&#8217;, &#8216;message&#8217; and &#8216;id&#8217;.  The object has a toString() function which may be called to convert the exception to a string.</p>\n\n<p>When a &#8220;completed&#8221; event is dispatched, the event data contains the <span class=\"caps\">JSON</span>-RPC result.</p>\n\n<p>The return value of this method is a call reference that you can store if you want to abort the request later on. This value should be treated as opaque and can change completely in the future! The only thing you can rely on is that the <code>abort</code> method will accept this reference and that you can retrieve the sequence number of the request by invoking the getSequenceNumber() method (see below).</p>\n\n<p>If a specific method is being called, asynchronously, a number of times in succession, the getSequenceNumber() method may be used to disambiguate which request a response corresponds to.  The sequence number value is a value which increments with each request.)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(var)                 the method call reference.</p>"}}]}]},{type:"method",attributes:{"name":"callSync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"methodName"},children:[{type:"desc",attributes:{"text":"<p>the name of the method to call.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Makes a synchronous server call. The method arguments (if any) follow after the method name (as normal JavaScript arguments, separated by commas, not as an array).</p>\n\n<p>If a problem occurs when making the call, an exception is thrown.</p>\n\n<p><span class=\"caps\">WARNING</span>.  With some browsers, the synchronous interface causes the browser to hang while awaiting a response!  If the server decides to pause for a minute or two, your browser may do nothing (including refreshing following window changes) until the response is received.  Instead, use the asynchronous interface.</p>\n\n<p><span class=\"caps\">YOU</span> <span class=\"caps\">HAVE</span> <span class=\"caps\">BEEN</span> <span class=\"caps\">WARNED</span>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the result returned by the server.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"fixUrl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"url"},children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">URL</span> to examine.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Helper method to rewrite a <span class=\"caps\">URL</span> with a stale session id (so that it includes the correct session id afterwards).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the (possibly re-written) <span class=\"caps\">URL</span>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"name":"refreshSession"},children:[{type:"params",children:[{type:"param",attributes:{"name":"handler"},children:[{type:"desc",attributes:{"text":"<p>a callback function that is called when the refresh is complete (or failed).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>Refreshes a server session by retrieving the session id again from the server.</p>\n\n<p>The specified handler function is called when the refresh is complete. The first parameter can be <code>true</code> (indicating that a refresh either wasn&#8217;t necessary at this time or it was successful) or <code>false</code> (indicating that a refresh would have been necessary but can&#8217;t be performed because the server backend doesn&#8217;t support it). If there is a non-null second parameter, it&#8217;s an exception indicating that there was an error when refreshing the session.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"makeServerURL"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"instanceId"},children:[{type:"desc",attributes:{"text":"<p>an optional identifier for the server side instance that should be used. All calls to the same service with the same instance id are routed to the same object instance on the server. The instance id can also be used to provide additional data for the service instantiation on the server.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates an <span class=\"caps\">URL</span> for talking to a local service. A local service is one that lives in the same application as the page calling the service. For backends that don&#8217;t support this auto-generation, this method returns null.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the url.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"ScriptTransport","hasWarning":"true","packageName":"qx.io.remote","superClass":"qx.io.remote.AbstractRemoteTransport","fullName":"qx.io.remote.ScriptTransport"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Transports requests to a server using dynamic script tags.</p>\n\n<p>This class should not be used directly by client programmers.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isSupported"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"79"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getFetchedLength"},children:[{type:"desc",attributes:{"text":"<p>Returns the length of the content as fetched thus far</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getResponseContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"304"}}]}]},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeader","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Provides an hash of all response headers.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the current status code of the request if available or -1 if not.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Provides the status text for the current request if available and null otherwise.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"send","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vValue"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_switchReadyState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vReadyState"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"171"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_requestFinished"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}},{type:"param",attributes:{"name":"content"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"189"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.io.remote","fullName":"qx.io.remote.XmlHttpTransport","name":"XmlHttpTransport","hasWarning":"true","superClass":"qx.io.remote.AbstractRemoteTransport"},children:[{type:"events",children:[{type:"event",attributes:{"name":"aborted"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"completed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"configured"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"created"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"failed"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"receiving"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"sending"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":""}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isAbstract":"true","isStatic":"true","name":"createRequestObject"},children:[{type:"desc",attributes:{"text":"<p>Return a new request object suitable for the client browser.</p>\n\n<p>qx.io.remote.XmlHttpTransport&#8217;s isSupported method scans which request object to use. The createRequestObject method is then replaced with a method that creates request suitable for the client browser. If the client browser doesn&#8217;t support <span class=\"caps\">XMLHTTP</span> requests, the method isn&#8217;t replaced and the error &#8220;XMLHTTP is not supported!&#8221; is thrown.</p>"}}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isSupported"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"82"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_createActiveXRequestObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"61","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_createNativeRequestObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"60","line":"167"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"name":"failedLocally"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the failed state (&#8220;failed&#8221;).</p>\n\n<p>This method should be used only if the requests <span class=\"caps\">URI</span> was local access. I.e. it started with &#8220;file://&#8221;.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getFetchedLength"},children:[{type:"desc",attributes:{"text":"<p>Returns the length of the content as fetched thus far</p>"}}]},{type:"method",attributes:{"name":"getReadyState"},children:[{type:"desc",attributes:{"text":"<p>Get the ready state of this transports request.</p>\n\n<p>For qx.io.remote.XmlHttpTransports, the ready state is a number between 1 to 4.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getRequest"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"196"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getResponseContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"673"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}}]},{type:"desc",attributes:{"text":"<p>Returns a specific header provided by the server upon sending a request, with header name determined by the argument headerName.</p>\n\n<p>Only available at readyState 3 and 4 universally and in readyState 2 in Gecko.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vLabel is not documented.","column":"30","line":"489"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Provides a hash of all response headers.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseText"},children:[{type:"desc",attributes:{"text":"<p>Provides the response text from the request when available and null otherwise.  By passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will be made available to the caller.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getResponseXml"},children:[{type:"desc",attributes:{"text":"<p>Provides the <span class=\"caps\">XML</span> provided by the response if any and null otherwise.  By passing true as the &#8220;partial&#8221; parameter of this method, incomplete data will be made available to the caller.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the current status code of the request if available or -1 if not.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Provides the status text for the current request if available and null otherwise.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getStringResponseHeaders"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"500"}}]}]},{type:"method",attributes:{"docFrom":"qx.io.remote.AbstractRemoteTransport","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"send","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.io.remote.AbstractRemoteTransport","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"desc",attributes:{"text":"<p>Add a request header to this transports request.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vLabel is not documented.","column":"29","line":"466"}},{type:"error",attributes:{"msg":"Parameter vValue is not documented.","column":"29","line":"466"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"733"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onreadystatechange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"393"}}]}]}]}]}]}]}]},{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.io","fullName":"qx.io.Json","isStatic":"true","name":"Json","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"parseQx"},children:[{type:"params",children:[{type:"param",attributes:{"name":"text"}}]},{type:"desc",attributes:{"text":"<p>Parse a <span class=\"caps\">JSON</span> text, producing a JavaScript value. It triggers an exception if there is a syntax error.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter text is not documented.","column":"22","line":"359"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"BEAUTIFYING_INDENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"383"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BEAUTIFYING_LINE_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"385"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.lang","name":"lang","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Array","isStatic":"true","name":"Array","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"append"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"a"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"143"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"clone"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"84"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"obj"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"156"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"copy"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"80"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromArguments"},children:[{type:"params",children:[{type:"param",attributes:{"name":"args"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"27"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromShortHand"},children:[{type:"params",children:[{type:"param",attributes:{"name":"params"}}]},{type:"desc",attributes:{"text":"<p>Utility function for padding/margin and all other shorthand handling.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter params is not documented.","column":"31","line":"34"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getFirst"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"92"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getLast"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"88"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"insertAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"o"}},{type:"param",attributes:{"name":"o2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"119"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"insertAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"obj"}},{type:"param",attributes:{"name":"i"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"96"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"insertBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"obj"}},{type:"param",attributes:{"name":"obj2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"103"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"obj"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"147"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeAll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"139"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arr"}},{type:"param",attributes:{"name":"i"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"135"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Core","isStatic":"true","name":"Core"}},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Generics","isStatic":"true","name":"Generics","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"init"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"64"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.MshtmlEmu","isStatic":"true","name":"MshtmlEmu"}},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Number","isStatic":"true","name":"Number","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isBetweenRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nr"}},{type:"param",attributes:{"name":"vmin"}},{type:"param",attributes:{"name":"vmax"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"30"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isInRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nr"}},{type:"param",attributes:{"name":"vmin"}},{type:"param",attributes:{"name":"vmax"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"26"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"limit"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nr"}},{type:"param",attributes:{"name":"vmin"}},{type:"param",attributes:{"name":"vmax"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"34"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Object","isStatic":"true","name":"Object","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"carefullyMergeWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObjectA"}},{type:"param",attributes:{"name":"vObjectB"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"97"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"copy"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"119"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getKeys"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"64"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getKeysAsString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"74"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getLength"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"53"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getValues"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"78"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"hasMinLength"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}},{type:"param",attributes:{"name":"j"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"39"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"isEmpty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"h"}}]},{type:"desc",attributes:{"text":"<p>Function to check if a hash has any keys</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter h is not documented.","column":"20","line":"30"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"merge"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObjectA"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"108"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"mergeWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObjectA"}},{type:"param",attributes:{"name":"vObjectB"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"88"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.Prototypes","isStatic":"true","name":"Prototypes","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"init"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"46"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.String","isStatic":"true","name":"String","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}},{type:"param",attributes:{"name":"v"}},{type:"param",attributes:{"name":"sep"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"89"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}},{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"145"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"endsWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fullstr"}},{type:"param",attributes:{"name":"substr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"66"}}]}]},{type:"method",attributes:{"isStatic":"true","name":"escapeRegexpChars"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"},children:[{type:"desc",attributes:{"text":"<p>the string where to escape the chars.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Escapes all chars that have a special meaning in regular expressions</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the string with the escaped chars.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"pad"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}},{type:"param",attributes:{"name":"length"}},{type:"param",attributes:{"name":"ch"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"70"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}},{type:"param",attributes:{"name":"v"}},{type:"param",attributes:{"name":"sep"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"119"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"startsWith"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fullstr"}},{type:"param",attributes:{"name":"substr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"62"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"stripTags"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"58"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"toCamelCase"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"27"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"toFirstUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"85"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"trim"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"54"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"trimLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"46"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"trimRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"50"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.lang","fullName":"qx.lang.XmlEmu","isStatic":"true","name":"XmlEmu"}}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.manager","name":"manager","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.manager","fullName":"qx.manager.object","name":"object","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.AliasManager","name":"AliasManager","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"change"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manage global resource aliases</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPrefix"}},{type:"param",attributes:{"name":"vPath"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"69"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPrefix"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"75"}}]}]},{type:"method",attributes:{"hasError":"true","name":"resolve"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPrefix"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"81"}}]}]},{type:"method",attributes:{"hasError":"true","name":"resolvePath"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPath"}},{type:"param",attributes:{"name":"vForceUpdate"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"96"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computePath"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPath"}},{type:"param",attributes:{"name":"vForce"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"109"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.AppearanceManager","name":"AppearanceManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","hasError":"true","type":"Object","name":"appearanceTheme","instance":"qx.renderer.theme.AppearanceTheme"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"54"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.manager.object.ObjectManager","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"registerAppearanceTheme"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vThemeClass"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"67"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.ColorManager","name":"ColorManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","hasError":"true","type":"Object","name":"colorTheme","instance":"qx.renderer.theme.ColorTheme"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"60"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"add","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oObject"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createThemeList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"xCor"}},{type:"param",attributes:{"name":"yCor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"160"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.manager.object.ObjectManager","name":"dispose"}},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.manager.object.ObjectManager","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"has","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]}]},{type:"method",attributes:{"hasError":"true","name":"registerColorTheme"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vThemeClass"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"73"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"remove","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oObject"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColorThemeById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"82"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.IframeManager","name":"IframeManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manages multiple instances of qx.ui.embed.Iframe.</p>\n\n<p>The problem: When dragging over an iframe then all mouse events will be passed to the document of the iframe, not the main document.</p>\n\n<p>The solution: In order to be able to track mouse events over iframes, this manager will block all iframes during a drag with a glasspane.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"handleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"42"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"51"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.ImageManager","name":"ImageManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manage the global image path (prefix) and allowes themed icons.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.theme.IconTheme","hasError":"true","type":"Object","name":"iconTheme"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"70"}}]}]},{type:"property",attributes:{"instance":"qx.renderer.theme.WidgetTheme","hasError":"true","type":"Object","name":"widgetTheme"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"71"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"createThemeList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"xCor"}},{type:"param",attributes:{"name":"yCor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"230"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.manager.object.ObjectManager","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getPostPreloadImageList"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"174"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPreloadImageList"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"160"}}]}]},{type:"method",attributes:{"hasError":"true","name":"preload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPath"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"252"}}]}]},{type:"method",attributes:{"hasError":"true","name":"registerIconTheme"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vThemeClass"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"84"}}]}]},{type:"method",attributes:{"hasError":"true","name":"registerWidgetTheme"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vThemeClass"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"93"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setIconThemeById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setWidgetThemeById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"106"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onaliaschange"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"122"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateImages"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"200"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.ImagePreloaderManager","name":"ImagePreloaderManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manage all qx.io.image.Preloader instances.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"add","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]}]},{type:"method",attributes:{"hasError":"true","name":"create"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"59"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.manager.object.ObjectManager","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"has","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"remove","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.MenuManager","name":"MenuManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manages multiple instances of qx.ui.menu.Menu and their state.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTarget"}},{type:"param",attributes:{"name":"vEventName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"43"}}]}]}]}]},{type:"class",attributes:{"name":"ObjectManager","hasWarning":"true","packageName":"qx.manager.object","superClass":"qx.core.Target","childClasses":"qx.event.handler.DragAndDropHandler,qx.manager.object.AppearanceManager,qx.manager.object.ColorManager,qx.manager.object.IframeManager,qx.manager.object.ImageManager,qx.manager.object.ImagePreloaderManager,qx.manager.object.MenuManager,qx.manager.object.PopupManager,qx.manager.object.ToolTipManager,qx.manager.object.WindowManager","fullName":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This class allows basic managment of assigned objects.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"45"}}]}]},{type:"method",attributes:{"hasError":"true","name":"disableAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"84"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"enableAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"77"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"get"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"73"}}]}]},{type:"method",attributes:{"hasError":"true","name":"has"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"65"}}]}]},{type:"method",attributes:{"hasError":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"55"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.PopupManager","name":"PopupManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton is used to manager multiple instances of popups and their state.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTarget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"41"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.ToolTipManager","name":"ToolTipManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This manages ToolTip instances</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.ui.popup.ToolTip","hasError":"true","type":"Object","name":"currentToolTip"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"33"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"handleBlur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"159"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleFocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"142"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"104"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"80"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.object","fullName":"qx.manager.object.WindowManager","name":"WindowManager","hasWarning":"true","superClass":"qx.manager.object.ObjectManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This singleton manages qx.ui.window.Windows</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"Object","name":"activeWindow"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"33"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"add","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWindow"}}]}]},{type:"method",attributes:{"hasError":"true","name":"compareWindows"},children:[{type:"params",children:[{type:"param",attributes:{"name":"w1"}},{type:"param",attributes:{"name":"w2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"107"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.object.ObjectManager","overriddenFrom":"qx.manager.object.ObjectManager","name":"remove","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWindow"}}]}]},{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oTarget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"80"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.manager","fullName":"qx.manager.selection","name":"selection","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.manager.selection","fullName":"qx.manager.selection.DomSelectionManager","name":"DomSelectionManager","hasWarning":"true","superClass":"qx.manager.selection.SelectionManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBoundedWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getAbove","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getFirst","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"getItemBaseClassName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"56"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemClassName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"48"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHashCode","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemLeft","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItems","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemTop","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemWidth","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getLast","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getNextSibling","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getPreviousSibling","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getUnder","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"isBefore","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemAnchorState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsAnchor"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemLeadState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsLead"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemSelectionState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"scrollItemIntoView","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setItemClassName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vClassName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"52"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_updateState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vState"}},{type:"param",attributes:{"name":"vIsState"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"224"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.manager.selection","fullName":"qx.manager.selection.RadioManager","name":"RadioManager","hasWarning":"true","superClass":"qx.core.Target"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vMembers"}}]},{type:"desc",attributes:{"text":"<p>Each instance manage vItems set of radio options: qx.ui.form.RadioButton, qx.ui.toolbar.RadioButton, ...</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vName is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vMembers is not documented.","column":"1","line":"29"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"AUTO_NAME_PREFIX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"52","line":"46"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"name"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"58"}}]}]},{type:"property",attributes:{"hasError":"true","name":"selected"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"57"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"99"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"71"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleItemChecked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vChecked"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"75"}}]}]},{type:"method",attributes:{"hasError":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"138"}}]}]},{type:"method",attributes:{"hasError":"true","name":"selectNext"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"206"}}]}]},{type:"method",attributes:{"hasError":"true","name":"selectPrevious"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"228"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"176"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_selectByIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"250"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"SelectionManager","hasWarning":"true","packageName":"qx.manager.selection","superClass":"qx.core.Target","childClasses":"qx.manager.selection.DomSelectionManager,qx.manager.selection.TreeFullControlSelectionManager,qx.manager.selection.TreeSelectionManager,qx.manager.selection.VirtualSelectionManager","fullName":"qx.manager.selection.SelectionManager"},children:[{type:"events",children:[{type:"event",attributes:{"name":"changeSelection"},children:[{type:"desc",attributes:{"text":"<p>sets the data property of the event object to an arryas of selected items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBoundedWidget"}}]},{type:"desc",attributes:{"text":"<p>This class represents a selection and manage incoming events for widgets which need selection support.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vBoundedWidget is not documented.","column":"1","line":"32"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"Object","name":"anchorItem"},children:[{type:"desc",attributes:{"text":"<p>The current anchor in range selections.</p>"}}]},{type:"property",attributes:{"type":"Object","name":"boundedWidget"},children:[{type:"desc",attributes:{"text":"<p>This contains the currently assigned widget (qx.ui.form.List, ...)</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"canDeselect"},children:[{type:"desc",attributes:{"text":"<p>Should the user be able to select</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"dragSelection"},children:[{type:"desc",attributes:{"text":"<p>Enable drag selection?</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"fireChange"},children:[{type:"desc",attributes:{"text":"<p>Should a change event be fired?</p>"}}]},{type:"property",attributes:{"type":"Object","name":"leadItem"},children:[{type:"desc",attributes:{"text":"<p>The last selected item</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"multiColumnSupport"},children:[{type:"desc",attributes:{"text":"<p>Grid selection</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"multiSelection"},children:[{type:"desc",attributes:{"text":"<p>Should multiple selection be allowed?</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_deselectAll"},children:[{type:"desc",attributes:{"text":"<p>Sub method for deselectAll. Handles the real work to deselect all items.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_deselectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}}]},{type:"desc",attributes:{"text":"<p>Internal method for deselection of ranges.</p>\n\n<p>#param vItem1[qx.ui.core.Widget]: Start item<br />\n#param vItem2[qx.ui.core.Widget]: Stop item</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem1 is not documented.","column":"31","line":"698"}},{type:"error",attributes:{"msg":"Parameter vItem2 is not documented.","column":"31","line":"698"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_dispatchChange"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1188"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getChangeValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1203"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getFirst"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"139"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getLast"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"143"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_hasChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"sOldValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"1199"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondragup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"772"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}},{type:"param",attributes:{"name":"e"}},{type:"param",attributes:{"name":"bOver"}}]},{type:"desc",attributes:{"text":"<p>Internal handler for all mouse events bound to this manager.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter oItem is not documented.","column":"26","line":"815"}},{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"26","line":"815"}},{type:"error",attributes:{"msg":"Parameter bOver is not documented.","column":"26","line":"815"}}]}]},{type:"method",attributes:{"name":"_selectAll"},children:[{type:"desc",attributes:{"text":"<p>Sub method for selectAll. Handles the real work to select all items.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_selectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}},{type:"param",attributes:{"name":"vDeselect"}}]},{type:"desc",attributes:{"text":"<p>Sub method for selectItemRange. Handles the real work to select a range of items.</p>\n\n<p>#param vItem1[qx.ui.core.Widget]: Start item<br />\n#param vItem2[qx.ui.core.Widget]: Stop item<br />\n#param vDelect[Boolean]: Deselect currently selected items first?</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem1 is not documented.","column":"29","line":"652"}},{type:"error",attributes:{"msg":"Parameter vItem2 is not documented.","column":"29","line":"652"}},{type:"error",attributes:{"msg":"Parameter vDeselect is not documented.","column":"29","line":"652"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"deselectAll"},children:[{type:"desc",attributes:{"text":"<p>Deselect all items.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"getAbove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"1262"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"1226"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getEnd"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"1222"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirst"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"147"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHome"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"1218"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"229"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"259"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"247"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"163"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemSelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"315"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"251"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemToSelect"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vKeyboardEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1132"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"255"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLast"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"155"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"1244"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNext"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"175"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNextSibling"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"167"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPageDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"desc",attributes:{"text":"<p>Jump a &#8220;page&#8221; down.</p>\n\n<p>#param vItem[qx.ui.core.Widget]: Relative to this widget</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem is not documented.","column":"24","line":"1345"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPageUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"desc",attributes:{"text":"<p>Jump a &#8220;page&#8221; up.</p>\n\n<p>#param vItem[qx.ui.core.Widget]: Relative to this widget</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem is not documented.","column":"22","line":"1289"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPrevious"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"193"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPreviousSibling"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"1253"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSelectedItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"423"}}]}]},{type:"method",attributes:{"name":"getSelectedItems"},children:[{type:"desc",attributes:{"text":"<p>Get the selected items (objects)</p>"}}]},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"getUnder"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"1267"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"1235"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"806"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleDblClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"809"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1006"}}]}]},{type:"method",attributes:{"name":"handleKeyPress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDomEvent"},children:[{type:"desc",attributes:{"text":"<p>(Element) <span class=\"caps\">DOM</span> event object</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Handles key event to perform selection and navigation</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"734"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"796"}}]}]},{type:"method",attributes:{"hasError":"true","name":"handleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"779"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"211"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isEqual"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"217"}}]}]},{type:"method",attributes:{"hasError":"true","name":"renderItemAnchorState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsAnchor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"287"}}]}]},{type:"method",attributes:{"hasError":"true","name":"renderItemLeadState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsLead"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"296"}}]}]},{type:"method",attributes:{"hasError":"true","name":"renderItemSelectionState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"278"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vTopLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"243"}}]}]},{type:"method",attributes:{"name":"selectAll"},children:[{type:"desc",attributes:{"text":"<p>Select all items.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"selectItemRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem1"}},{type:"param",attributes:{"name":"vItem2"}}]},{type:"desc",attributes:{"text":"<p>Select a range of items.</p>\n\n<p>#param vItem1[qx.ui.core.Widget]: Start item<br />\n#param vItem2[qx.ui.core.Widget]: Stop item</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem1 is not documented.","column":"28","line":"621"}},{type:"error",attributes:{"msg":"Parameter vItem2 is not documented.","column":"28","line":"621"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setItemSelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vSelected"}}]},{type:"desc",attributes:{"text":"<p>Make a single item selected / not selected</p>\n\n<p>#param vItem[qx.ui.core.Widget]: Item which should be selected / not selected<br />\n#param vSelected[Boolean]: Should this item be selected?</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem is not documented.","column":"28","line":"325"}},{type:"error",attributes:{"msg":"Parameter vSelected is not documented.","column":"28","line":"325"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setSelectedItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"472"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setSelectedItems"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItems"}}]},{type:"desc",attributes:{"text":"<p>Select given items</p>\n\n<p>#param vItems[Array of Widgets]: Items to select</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItems is not documented.","column":"29","line":"432"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"TreeFullControlSelectionManager","hasWarning":"true","packageName":"qx.manager.selection","superClass":"qx.manager.selection.SelectionManager","fullName":"qx.manager.selection.TreeFullControlSelectionManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBoundedWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"_getFirst","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"_getLast","hasWarning":"true"}}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItems","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemTop","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getNext","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getPrevious","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemSelectionState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"scrollItemIntoView","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"TreeSelectionManager","hasWarning":"true","packageName":"qx.manager.selection","superClass":"qx.manager.selection.SelectionManager","fullName":"qx.manager.selection.TreeSelectionManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBoundedWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"_getFirst","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"_getLast","hasWarning":"true"}}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItems","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemTop","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getNext","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getPrevious","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemSelectionState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"scrollItemIntoView","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"VirtualSelectionManager","hasWarning":"true","packageName":"qx.manager.selection","superClass":"qx.manager.selection.SelectionManager","fullName":"qx.manager.selection.VirtualSelectionManager"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBoundedWidget"}}]},{type:"desc",attributes:{"text":"<p>This class represents a selection and manage incoming events for widgets which need selection support.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vBoundedWidget is not documented.","column":"1","line":"29"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getFirst","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"desc",attributes:{"text":"<p>In a qx.ui.listview.ListView there are no disabled entries support currently.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vItem is not documented.","column":"27","line":"118"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHashCode","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemLeft","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItems","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemTop","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getItemWidth","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getLast","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getNextSibling","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"getPreviousSibling","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemAnchorState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsAnchor"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemLeadState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsLead"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"renderItemSelectionState","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]}]},{type:"method",attributes:{"docFrom":"qx.manager.selection.SelectionManager","overriddenFrom":"qx.manager.selection.SelectionManager","name":"scrollItemIntoView","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vTopLeft"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.net","name":"net","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.net","fullName":"qx.net.Http","isStatic":"true","name":"Http","hasWarning":"true"},children:[{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"METHOD_GET"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"26"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"METHOD_POST"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"27"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"METHOD_PUT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"28"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"METHOD_HEAD"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"29"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"METHOD_DELETE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"30"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.net","fullName":"qx.net.Protocol","isStatic":"true","name":"Protocol","hasWarning":"true"},children:[{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"HTTP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"26"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"HTTPS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"27"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"FTP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"28"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"FILE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"29"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"URI_HTTP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"31"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"URI_HTTPS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"32"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"URI_FTP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"33"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"URI_FILE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"3","line":"34"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.renderer","name":"renderer","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.renderer","fullName":"qx.renderer.border","name":"border","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Border","hasWarning":"true","packageName":"qx.renderer.border","superClass":"qx.core.Object","childClasses":"qx.renderer.border.BorderObject","fullName":"qx.renderer.border.Border"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"desc",attributes:{"text":"<p>Border implementation for qx.ui.core.Widget instances.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vWidth is not documented.","column":"1","line":"31"}},{type:"error",attributes:{"msg":"Parameter vStyle is not documented.","column":"1","line":"31"}},{type:"error",attributes:{"msg":"Parameter vColor is not documented.","column":"1","line":"31"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.color.Color","hasError":"true","type":"Object","name":"bottomColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"81"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"\"none\"","type":"string","name":"bottomStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"76"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"bottomWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"71"}}]}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","hasError":"true","type":"Object","name":"leftColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"82"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"\"none\"","type":"string","name":"leftStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"77"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"leftWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"72"}}]}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","hasError":"true","type":"Object","name":"rightColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"80"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"\"none\"","type":"string","name":"rightStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"75"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"rightWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"70"}}]}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","hasError":"true","type":"Object","name":"topColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"79"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"\"none\"","type":"string","name":"topStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"74"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"topWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"69"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDefString"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"93"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getUseEnhancedCrossBrowserMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"579"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"211"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"180"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"220"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"202"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"170"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"193"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"160"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"628"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyWidgetXCommon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"648"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyWidgetYCommon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"677"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalUseEnhancedCrossBrowserMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"588"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_generateDefString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"423"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleColorRegistration"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"470"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyBorderBottomProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"547"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyBorderLeftProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"559"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyBorderRightProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"535"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyBorderTopProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"523"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"634"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetWidgetX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"640"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetWidgetY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"644"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateColors"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColorObject"}},{type:"param",attributes:{"name":"vNewValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"451"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.border","fullName":"qx.renderer.border.BorderCache","isStatic":"true","name":"BorderCache","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"BorderCache"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"27"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.border","fullName":"qx.renderer.border.BorderObject","name":"BorderObject","hasWarning":"true","superClass":"qx.renderer.border.Border"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vStyle"}},{type:"param",attributes:{"name":"vColor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDefString"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"46","line":"41"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addListenerWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"96"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.renderer.border.Border","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"removeListenerWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"100"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_sync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEdge"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"104"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.border","fullName":"qx.renderer.border.BorderPresets","name":"BorderPresets","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Some common used border styles.</p>"}}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.renderer","fullName":"qx.renderer.color","name":"color","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Color","hasWarning":"true","packageName":"qx.renderer.color","superClass":"qx.core.Object","childClasses":"qx.renderer.color.ColorObject","fullName":"qx.renderer.color.Color"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromRandom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"200"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDefString"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"196"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"rgb2style"},children:[{type:"params",children:[{type:"param",attributes:{"name":"r"}},{type:"param",attributes:{"name":"g"}},{type:"param",attributes:{"name":"b"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"51"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getBlue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"371"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getGreen"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"362"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHex"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"315"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRed"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"353"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"283"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"276"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isHtmlColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"256"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isRgbColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"252"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isThemedColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"260"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"267"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_evalHex"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"324"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalRgb"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"383"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalStyle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"292"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_normalize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vInValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"413"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.color","fullName":"qx.renderer.color.ColorCache","isStatic":"true","name":"ColorCache","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"ColorCache"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"27"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.color","fullName":"qx.renderer.color.ColorObject","name":"ColorObject","hasWarning":"true","superClass":"qx.renderer.color.Color"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDefString"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"54"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyThemedValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"80"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncObjects"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"96"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateTheme"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTheme"}}]},{type:"desc",attributes:{"text":"<p>Set a new value from selected theme (only for Operating System Colors)</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vTheme is not documented.","column":"25","line":"70"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"119"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.renderer.color.Color","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"123"}}]}]},{type:"method",attributes:{"docFrom":"qx.renderer.color.Color","overriddenFrom":"qx.renderer.color.Color","name":"setValue","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.renderer","fullName":"qx.renderer.font","name":"font","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Font","hasWarning":"true","packageName":"qx.renderer.font","superClass":"qx.core.Object","childClasses":"qx.renderer.font.FontObject","fullName":"qx.renderer.font.Font"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSize"}},{type:"param",attributes:{"name":"vName"}}]},{type:"desc",attributes:{"text":"<p>Font implementation for qx.ui.core.Widget instances.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vSize is not documented.","column":"1","line":"31"}},{type:"error",attributes:{"msg":"Parameter vName is not documented.","column":"1","line":"31"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"bold"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"58"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"italic"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"59"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"name"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"57"}}]}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"size"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"56"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"strikeout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"61"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"underline"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"60"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"176"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_compile"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"149"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"73"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"189"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"fromString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"88"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.renderer.font","fullName":"qx.renderer.font.FontCache","isStatic":"true","name":"FontCache","hasWarning":"true"},children:[{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"FontCache"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"27"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.font","fullName":"qx.renderer.font.FontObject","name":"FontObject","hasWarning":"true","superClass":"qx.renderer.font.Font"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSize"}},{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addListenerWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"42"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.renderer.font.Font","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"removeListenerWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"o"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"46"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_sync"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEdge"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"50"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.renderer","fullName":"qx.renderer.layout","name":"layout","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.CanvasLayoutImpl","name":"CanvasLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.LayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"88"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl: [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"69"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildNeededHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the needed height of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"37","line":"139"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildNeededWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the needed width of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"36","line":"117"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>This is called from qx.ui.core.Widget and  it&#8217;s task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"209"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"273"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"286"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"186"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"173"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.DockLayoutImpl","name":"DockLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.LayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"METHOD_LOCATION"},children:[{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl: [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [11] <span class=\"caps\">DISPOSER</span></p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"127"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box width of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"115"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"flushChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChildrenQueue"}}]},{type:"desc",attributes:{"text":"<p>This method have full control of the order in which the registered (or also non-registered) children should be layouted on the horizontal axis.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChildrenQueue is not documented.","column":"31","line":"230"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getChildAlign"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"249"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getChildAlignMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"253"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>This is called from qx.ui.core.Widget and  it&#8217;s task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"273"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"273"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_location_left"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"297"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_location_top"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"287"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"165"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"152"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Updates children on special jobs</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"204"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.FlowLayoutImpl","name":"FlowLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.LayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"STR_FIRST"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"30"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_LAST"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"31"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_NEXT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"32"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STR_PREVIOUS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"48","line":"33"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"computeChildrenNeededHeight"},children:[{type:"desc",attributes:{"text":"<p>Calculate the layout to get the needed height of the children</p>"}}]},{type:"method",attributes:{"name":"computeChildrenNeededWidth"},children:[{type:"desc",attributes:{"text":"<p>Global Structure:</p>\n\n<p>[01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl:</p>\n\n<p>[01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [11] <span class=\"caps\">DISPOSER</span></p>"}}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"flushChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChildrenQueue"}}]},{type:"desc",attributes:{"text":"<p>This method have full control of the order in which the registered (or also non-registered) children should be layouted on the horizontal axis.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChildrenQueue is not documented.","column":"31","line":"263"}}]}]},{type:"method",attributes:{"docFrom":"qx.renderer.layout.LayoutImpl","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_location"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"367"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"170"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"158"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Updates children on special jobs</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"193"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnMoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vOldIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a child should be moved inside the same parent to a new positions. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"38","line":"239"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"38","line":"239"}},{type:"error",attributes:{"msg":"Parameter vOldIndex is not documented.","column":"38","line":"239"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a widget should be removed from the current layout. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"40","line":"215"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"40","line":"215"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateSelfOnChildOuterWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes it&#8217;s outer width. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"46","line":"135"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.GridLayoutImpl","name":"GridLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.LayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"99"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Global Structure:</p>\n\n<p>[01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl:</p>\n\n<p>[04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"68"}}]}]},{type:"method",attributes:{"name":"computeChildrenNeededHeight"},children:[{type:"desc",attributes:{"text":"<p>Compute and return the height needed by all children of this widget which is in a grid layout the height used by all rows.</p>"}}]},{type:"method",attributes:{"name":"computeChildrenNeededWidth"},children:[{type:"desc",attributes:{"text":"<p>Compute and return the width needed by all children of this widget which is in a grid layout the width used by all columns.</p>"}}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>This is called from qx.ui.core.Widget and  it&#8217;s task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"227"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"227"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"254"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"278"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_sizeX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"244"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_sizeY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"249"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"201"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"189"}}]}]}]}]},{type:"class",attributes:{"name":"HorizontalBoxLayoutImpl","hasWarning":"true","packageName":"qx.renderer.layout","superClass":"qx.renderer.layout.LayoutImpl","childClasses":"qx.renderer.layout.MenuButtonLayoutImpl","fullName":"qx.renderer.layout.HorizontalBoxLayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"enableFlexSupport"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"31"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"72"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl: [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"65"}}]}]},{type:"method",attributes:{"name":"computeChildrenFlexWidth"},children:[{type:"desc",attributes:{"text":"<p>Computes the width of all flexible children.</p>"}}]},{type:"method",attributes:{"name":"computeChildrenNeededWidth"},children:[{type:"desc",attributes:{"text":"<p>Compute and return the width needed by all children of this widget</p>"}}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"flushChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChildrenQueue"}}]},{type:"desc",attributes:{"text":"<p>This method have full control of the order in which the registered (or also non-registered) children should be layouted on the horizontal axis.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChildrenQueue is not documented.","column":"31","line":"577"}}]}]},{type:"method",attributes:{"hasError":"true","name":"invalidateChildrenFlexWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"316"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>This is called from qx.ui.core.Widget and  it&#8217;s task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"662"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"662"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"742"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"808"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"395"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"377"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Updates children on special jobs</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"444"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnMoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vOldIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a child should be moved inside the same parent to a new positions. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"38","line":"550"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"38","line":"550"}},{type:"error",attributes:{"msg":"Parameter vOldIndex is not documented.","column":"38","line":"550"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a widget should be removed from the current layout. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"40","line":"498"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"40","line":"498"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateSelfOnChildOuterWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes its outer width. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"46","line":"356"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateSelfOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vJobQueue"}}]},{type:"desc",attributes:{"text":"<p>Invalidate and recompute things because of job in queue (before the rest of job handling will be executed).</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vJobQueue is not documented.","column":"38","line":"423"}}]}]}]}]},{type:"class",attributes:{"name":"LayoutImpl","hasWarning":"true","packageName":"qx.renderer.layout","superClass":"qx.core.Object","childClasses":"qx.renderer.layout.CanvasLayoutImpl,qx.renderer.layout.DockLayoutImpl,qx.renderer.layout.FlowLayoutImpl,qx.renderer.layout.GridLayoutImpl,qx.renderer.layout.HorizontalBoxLayoutImpl,qx.renderer.layout.VerticalBoxLayoutImpl","fullName":"qx.renderer.layout.LayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"78"}}]}]},{type:"method",attributes:{"hasError":"true","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"71"}}]}]},{type:"method",attributes:{"hasError":"true","name":"computeChildNeededHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the needed height of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"37","line":"110"}}]}]},{type:"method",attributes:{"hasError":"true","name":"computeChildNeededWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the needed width of the given child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"36","line":"95"}}]}]},{type:"method",attributes:{"name":"computeChildrenNeededHeight_max"},children:[{type:"desc",attributes:{"text":"<p>Calculate the maximum needed height of all children</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"computeChildrenNeededHeight_sum"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"164"}}]}]},{type:"method",attributes:{"name":"computeChildrenNeededWidth_max"},children:[{type:"desc",attributes:{"text":"<p>Calculate the maximum needed width of all children</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"computeChildrenNeededWidth_sum"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"155"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Dispose the layout implmentation and release the associated widget.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"flushChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChildrenQueue"}}]},{type:"desc",attributes:{"text":"<p>Has full control of the order in which the registered (or non-registered) children should be layouted.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChildrenQueue is not documented.","column":"31","line":"303"}}]}]},{type:"method",attributes:{"name":"getWidget"},children:[{type:"desc",attributes:{"text":"<p>Returns the associated widget</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>Called from qx.ui.core.Widget. Its task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"329"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"329"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_marginX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>Apply the margin values as pure stylesheet equivalent.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"32","line":"381"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"32","line":"381"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_marginY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"396"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_sizeX_essentialWrapper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"47","line":"411"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_sizeY_essentialWrapper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"47","line":"415"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the layout widget has changed. Normally this includes updates to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"224"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the layout widget has changed. Normally this includes updates to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"218"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildrenOnAddChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"desc",attributes:{"text":"<p>Add child to current layout. Rarely needed by some layout implementations.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"37","line":"273"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"37","line":"273"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Updates children on job queue flush. This is executed at the end of the job queue handling.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"257"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildrenOnMoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vOldIndex"}}]},{type:"desc",attributes:{"text":"<p>Move child within its parent to a new position. Needed by layouts where the children depend on each other, like flow or box layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"38","line":"285"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"38","line":"285"}},{type:"error",attributes:{"msg":"Parameter vOldIndex is not documented.","column":"38","line":"285"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateChildrenOnRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"desc",attributes:{"text":"<p>Remove child from current layout. Needed by layouts where the children depend on each other, like flow or box layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"40","line":"279"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"40","line":"279"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateSelfOnChildOuterHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes its outer height. Needed by layouts where the children depend on each other, like flow or box layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"47","line":"202"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateSelfOnChildOuterWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes its outer width. Needed by layouts where the children depend on each other, like flow or box layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"46","line":"196"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateSelfOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vJobQueue"}}]},{type:"desc",attributes:{"text":"<p>Invalidate and recompute cached data according to job queue. This is executed at the beginning of the job queue handling.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vJobQueue is not documented.","column":"38","line":"240"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.MenuButtonLayoutImpl","name":"MenuButtonLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.HorizontalBoxLayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"overriddenFrom":"qx.renderer.layout.HorizontalBoxLayoutImpl","name":"computeChildrenNeededWidth"},children:[{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.HorizontalBoxLayoutImpl: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [11] <span class=\"caps\">DISPOSER</span></p>"}}]},{type:"method",attributes:{"docFrom":"qx.renderer.layout.HorizontalBoxLayoutImpl","overriddenFrom":"qx.renderer.layout.HorizontalBoxLayoutImpl","name":"layoutChild_locationX","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.HorizontalBoxLayoutImpl","name":"updateSelfOnChildOuterWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes its outer width. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"46","line":"103"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.renderer.layout","fullName":"qx.renderer.layout.MenuLayoutImpl","name":"MenuLayoutImpl","hasWarning":"true","superClass":"qx.renderer.layout.VerticalBoxLayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.VerticalBoxLayoutImpl","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.VerticalBoxLayoutImpl: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"76"}}]}]}]}]},{type:"class",attributes:{"name":"VerticalBoxLayoutImpl","hasWarning":"true","packageName":"qx.renderer.layout","superClass":"qx.renderer.layout.LayoutImpl","childClasses":"qx.renderer.layout.MenuLayoutImpl","fullName":"qx.renderer.layout.VerticalBoxLayoutImpl"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"enableFlexSupport"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"31"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Compute and return the box height of the given child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"34","line":"78"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"computeChildBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Global Structure: [01] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">BOX</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [03] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> <span class=\"caps\">ALL</span> <span class=\"caps\">CHILDREN</span> [04] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">WHEN</span> A <span class=\"caps\">CHILD</span> <span class=\"caps\">CHANGES</span> <span class=\"caps\">ITS</span> <span class=\"caps\">OUTER</span> <span class=\"caps\">DIMENSIONS</span> [05] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILD</span> ON <span class=\"caps\">INNER</span> <span class=\"caps\">DIMENSION</span> <span class=\"caps\">CHANGES</span> OF <span class=\"caps\">LAYOUT</span> [06] <span class=\"caps\">UPDATE</span> <span class=\"caps\">LAYOUT</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [07] <span class=\"caps\">UPDATE</span> <span class=\"caps\">CHILDREN</span> ON <span class=\"caps\">JOB</span> <span class=\"caps\">QUEUE</span> <span class=\"caps\">FLUSH</span> [08] <span class=\"caps\">CHILDREN</span> <span class=\"caps\">ADD</span>/REMOVE/MOVE <span class=\"caps\">HANDLING</span> [09] <span class=\"caps\">FLUSH</span> <span class=\"caps\">LAYOUT</span> <span class=\"caps\">QUEUES</span> OF <span class=\"caps\">CHILDREN</span> [10] <span class=\"caps\">LAYOUT</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>\n\n<p>Inherits from qx.renderer.layout.LayoutImpl: [02] <span class=\"caps\">COMPUTE</span> <span class=\"caps\">NEEDED</span> <span class=\"caps\">DIMENSIONS</span> <span class=\"caps\">FOR</span> AN <span class=\"caps\">INDIVIDUAL</span> <span class=\"caps\">CHILD</span> [11] <span class=\"caps\">DISPOSER</span></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"33","line":"66"}}]}]},{type:"method",attributes:{"name":"computeChildrenFlexHeight"},children:[{type:"desc",attributes:{"text":"<p>Computes the height of all flexible children.</p>"}}]},{type:"method",attributes:{"name":"computeChildrenNeededHeight"},children:[{type:"desc",attributes:{"text":"<p>Compute and return the height needed by all children of this widget</p>"}}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"flushChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChildrenQueue"}}]},{type:"desc",attributes:{"text":"<p>This method have full control of the order in which the registered (or also non-registered) children should be layouted on the horizontal axis.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChildrenQueue is not documented.","column":"31","line":"579"}}]}]},{type:"method",attributes:{"hasError":"true","name":"invalidateChildrenFlexHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"317"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"desc",attributes:{"text":"<p>This is called from qx.ui.core.Widget and  it&#8217;s task is to apply the layout (excluding border and padding) to the child.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"24","line":"665"}},{type:"error",attributes:{"msg":"Parameter vJobs is not documented.","column":"24","line":"665"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"811"}}]}]},{type:"method",attributes:{"hasError":"true","name":"layoutChild_locationY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vJobs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"745"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner height of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"43","line":"395"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildOnInnerWidthChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Actions that should be done if the inner width of the widget was changed. Normally this includes update to percent values and ranges.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"42","line":"376"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vQueue"}}]},{type:"desc",attributes:{"text":"<p>Updates children on special jobs</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vQueue is not documented.","column":"42","line":"445"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnMoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vOldIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a child should be moved inside the same parent to a new positions. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"38","line":"552"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"38","line":"552"}},{type:"error",attributes:{"msg":"Parameter vOldIndex is not documented.","column":"38","line":"552"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateChildrenOnRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"desc",attributes:{"text":"<p>This method combines calls of methods which should be done if a widget should be removed from the current layout. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"40","line":"500"}},{type:"error",attributes:{"msg":"Parameter vIndex is not documented.","column":"40","line":"500"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateSelfOnChildOuterHeightChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Things to do and layout when any of the childs changes its outer height. Needed by layouts where the children depends on each-other, like flow- or box-layouts.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"47","line":"355"}}]}]},{type:"method",attributes:{"hasError":"true","overriddenFrom":"qx.renderer.layout.LayoutImpl","name":"updateSelfOnJobQueueFlush"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vJobQueue"}}]},{type:"desc",attributes:{"text":"<p>Invalidate and recompute things because of job in queue (before the rest of job handling will be executed).</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vJobQueue is not documented.","column":"38","line":"424"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.renderer","fullName":"qx.renderer.theme","name":"theme","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"AppearanceTheme","hasWarning":"true","packageName":"qx.renderer.theme","superClass":"qx.core.Object","childClasses":"qx.theme.appearance.Classic","fullName":"qx.renderer.theme.AppearanceTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTitle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"\"\"","hasError":"true","type":"string","name":"title"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"42"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getAppearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"70"}}]}]},{type:"method",attributes:{"hasError":"true","name":"initialFrom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"99"}}]}]},{type:"method",attributes:{"hasError":"true","name":"registerAppearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"66"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setupAppearance"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAppearance"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"74"}}]}]},{type:"method",attributes:{"hasError":"true","name":"stateFrom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vStates"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"121"}}]}]}]}]},{type:"class",attributes:{"name":"ColorTheme","hasWarning":"true","packageName":"qx.renderer.theme","superClass":"qx.core.Object","childClasses":"qx.theme.color.System,qx.theme.color.WindowsClassic,qx.theme.color.WindowsLunaBlue,qx.theme.color.WindowsLunaGreen,qx.theme.color.WindowsLunaSilver,qx.theme.color.WindowsRoyale","fullName":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTitle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"\"\"","hasError":"true","type":"string","name":"title"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"45"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"compile"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"88"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getStyleByName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"73"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getValueByName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"69"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_compileValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"101"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_register"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"107"}}]}]}]}]},{type:"class",attributes:{"name":"IconTheme","hasWarning":"true","packageName":"qx.renderer.theme","superClass":"qx.core.Object","childClasses":"qx.theme.icon.CrystalSvg,qx.theme.icon.Nuvola","fullName":"qx.renderer.theme.IconTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTitle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"\"\"","hasError":"true","type":"string","name":"title"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"34"}}]}]}]}]},{type:"class",attributes:{"name":"WidgetTheme","hasWarning":"true","packageName":"qx.renderer.theme","superClass":"qx.core.Object","childClasses":"qx.theme.widget.Windows","fullName":"qx.renderer.theme.WidgetTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTitle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"\"\"","hasError":"true","type":"string","name":"title"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"34"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.sys","name":"sys","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.sys","fullName":"qx.sys.Client","name":"Client","hasWarning":"true"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>Basic client detection implementation</p>\n\n<p>Version shemes following wikipedia: major.minor[.revision[.build]] <a href=\"http://en.wikipedia.org/wiki/Software_version\">http://en.wikipedia.org/wiki/Software_version</a></p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"getBuild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"252"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getDefaultLocale"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"296"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getEmulation"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"256"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getEngine"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"232"}}]}]},{type:"method",attributes:{"name":"getEngineBoxSizingAttribute"},children:[{type:"desc",attributes:{"text":"<p>Returns the <span class=\"caps\">CSS</span> attribute name for box-sizing if supported.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the attribute name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"hasError":"true","name":"getLocale"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"288"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLocaleVariant"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"292"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMajor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"240"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMinor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"244"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPlatform"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"316"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRevision"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"248"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRunsLocally"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"228"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getVersion"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"236"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isGecko"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"264"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isInQuirksMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"284"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isKhtml"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"272"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isMshtml"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"260"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isOpera"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"268"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isSafari2"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"280"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isWebkit"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"276"}}]}]},{type:"method",attributes:{"name":"runsOnMacintosh"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the client platform is a Macintosh machine.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the client platform is a Macintosh.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"runsOnUnix"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the client platform is a X11 powered machine.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the client platform is a X11 powered machine.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"runsOnWindows"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the client platform is a Windows machine.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the client platform is a Windows.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"supportsInnerText"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the client supports the W3C property innerText of <span class=\"caps\">DOM</span> element nodes.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the client supports innerText.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"hasError":"true","name":"supportsSvg"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"351"}}]}]},{type:"method",attributes:{"name":"supportsTextContent"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the client supports the W3C property textContent of <span class=\"caps\">DOM</span> element nodes.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the client supports textContent.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"hasError":"true","name":"supportsVml"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"347"}}]}]},{type:"method",attributes:{"hasError":"true","name":"usesDefaultLocale"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"300"}}]}]},{type:"method",attributes:{"hasError":"true","name":"usesSvgBuiltin"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"355"}}]}]},{type:"method",attributes:{"hasError":"true","name":"usesSvgPlugin"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"359"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.theme","name":"theme","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.theme","fullName":"qx.theme.appearance","name":"appearance","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.theme.appearance","fullName":"qx.theme.appearance.Classic","name":"Classic","hasWarning":"true","superClass":"qx.renderer.theme.AppearanceTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTitle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"35"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.theme","fullName":"qx.theme.color","name":"color","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.System","name":"System","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.WindowsClassic","name":"WindowsClassic","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.WindowsLunaBlue","name":"WindowsLunaBlue","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.WindowsLunaGreen","name":"WindowsLunaGreen","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.WindowsLunaSilver","name":"WindowsLunaSilver","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.color","fullName":"qx.theme.color.WindowsRoyale","name":"WindowsRoyale","hasWarning":"true","superClass":"qx.renderer.theme.ColorTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.theme","fullName":"qx.theme.icon","name":"icon","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.theme.icon","fullName":"qx.theme.icon.CrystalSvg","name":"CrystalSvg","hasWarning":"true","superClass":"qx.renderer.theme.IconTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.theme.icon","fullName":"qx.theme.icon.Nuvola","name":"Nuvola","hasWarning":"true","superClass":"qx.renderer.theme.IconTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.theme","fullName":"qx.theme.widget","name":"widget","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.theme.widget","fullName":"qx.theme.widget.Windows","name":"Windows","hasWarning":"true","superClass":"qx.renderer.theme.WidgetTheme"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.type","name":"type","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.type","fullName":"qx.type.Range","name":"Range","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"change"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This manager is used by all objects which needs ranges like qx.ui.form.Spinner, ...</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"100","type":"number","name":"max"},children:[{type:"desc",attributes:{"text":"<p>maximal value of the Range object</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"min"},children:[{type:"desc",attributes:{"text":"<p>minimal value of the Range object</p>"}}]},{type:"property",attributes:{"defaultValue":"1","type":"number","name":"step"},children:[{type:"desc",attributes:{"text":"<p>Step size for increments/decrements of the value property</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"value"},children:[{type:"desc",attributes:{"text":"<p>current value of the Range object</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.type","fullName":"qx.type.Selection","name":"Selection","hasWarning":"true","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vManager"}}]},{type:"desc",attributes:{"text":"<p>Helper for qx.manager.selection.SelectionManager, contains data for selections</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vManager is not documented.","column":"1","line":"29"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"16","line":"47"}}]}]},{type:"method",attributes:{"hasError":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"59"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getChangeValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"81"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirst"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"74"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemHashCode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"93"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isEmpty"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"97"}}]}]},{type:"method",attributes:{"hasError":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"oItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"51"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"55"}}]}]},{type:"method",attributes:{"hasError":"true","name":"toArray"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"63"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.type","fullName":"qx.type.StringBuilder","name":"StringBuilder","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A string builder class</p>\n\n<p>+= operator is faster in Firefox and Opera. Array push/join is faster in Internet Explorer</p>\n\n<p>Even with this wrapper, which costs some time, this is faster in Firefox than the alternative Array concat in all browsers (which is in relation to IE&#8217;s performance issues only marginal). The IE performance loss caused by this wrapper is not relevant.</p>\n\n<p>So this class seems to be the best compromise to handle string concatination.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>(string) variable number os strings to be added</p>"}}]}]},{type:"desc",attributes:{"text":"<p>Append a variable number of string arguments</p>"}}]},{type:"method",attributes:{"name":"clear"},children:[{type:"desc",attributes:{"text":"<p>Resets the contents of the Stringbuilder equivalent to <pre>str = &#8221;&#8221;; </pre></p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Destructor</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"get"},children:[{type:"desc",attributes:{"text":"<p>Returns the contents of the concatenated string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) string content</p>"}}]}]},{type:"method",attributes:{"name":"init"},children:[{type:"desc",attributes:{"text":"<p>Initializes the contents of the Stringbuilder equivalent to <pre>str = &#8221;&#8221;; </pre></p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.core.Object","name":"toString"},children:[{type:"desc",attributes:{"text":"<p>Returns the contents of the concatenated string</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(string) string content</p>"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.type","fullName":"qx.type.Version","name":"Version","hasWarning":"true","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"arrVersion"}}]},{type:"desc",attributes:{"text":"<p>This class contains a version string and can extract major, minor and revision flags from this string. It can also compare a incoming version object with the stored version string and checks if this version is smaller or identical than the stored one.</p>\n\n<p>Flash detection and embed (<a href=\"http://blog.deconcept.com/flashobject\">http://blog.deconcept.com/flashobject</a>) (non qooxdoo Version by Geoff Stearns) Copyright 2005 Geoff Stearns. Released under the <span class=\"caps\">MIT</span> License (<a href=\"http://www.opensource.org/licenses/mit-license.php\">http://www.opensource.org/licenses/mit-license.php</a>).</p>\n\n<p>Modified for qooxdoo by Sebastian Werner. Based on version 1.2.3. Relicensed under <span class=\"caps\">LGPL</span> in assent of Geoff Stearns.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter arrVersion is not documented.","column":"1","line":"38"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getMajor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"87"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMinor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"91"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRev"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"95"}}]}]},{type:"method",attributes:{"hasError":"true","name":"versionIsValid"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fv"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"74"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx","fullName":"qx.ui","name":"ui","hasWarning":"true"},children:[{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.basic","name":"basic","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Atom","hasWarning":"true","packageName":"qx.ui.basic","superClass":"qx.ui.layout.BoxLayout","childClasses":"qx.ui.form.Button,qx.ui.form.CheckBox,qx.ui.form.ListItem,qx.ui.listview.HeaderCell,qx.ui.pageview.AbstractButton","fullName":"qx.ui.basic.Atom"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"desc",attributes:{"text":"<p>A multi-prupose widget used by many more complex widgets.</p>\n\n<p>The intended purpose of qx.ui.basic.Atom is to easily align the common icon-text combination in different ways. This is useful for all types of buttons, menuentires, tooltips, ...</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vLabel is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vIcon is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vIconWidth is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vIconHeight is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vFlash is not documented.","column":"1","line":"33"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"SHOW_LABEL"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"79"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"SHOW_ICON"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"80"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"SHOW_BOTH"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"81"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"string","name":"disabledIcon"},children:[{type:"desc",attributes:{"text":"<p>Any <span class=\"caps\">URI</span> String supported by qx.ui.basic.Image to display a disabled icon.</p>\n\n<p>If not set the normal icon is shown transparently.</p>"}}]},{type:"property",attributes:{"type":"string","name":"icon"},children:[{type:"desc",attributes:{"text":"<p>Any <span class=\"caps\">URI</span> String supported by qx.ui.basic.Image to display a icon</p>"}}]},{type:"property",attributes:{"type":"number","name":"iconHeight"},children:[{type:"desc",attributes:{"text":"<p>The height of the icon If configured, this makes qx.ui.basic.Atom a little bit faster as it does not need to wait until the image loading is finished.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"top\", \"right\", \"bottom\", \"left\"","defaultValue":"\"left\"","type":"string","name":"iconPosition"},children:[{type:"desc",attributes:{"text":"<p>The position of the icon in relation to the text. Only useful/needed if text and icon is configured and &#8216;show&#8217; is configured as &#8216;both&#8217; (default)</p>"}}]},{type:"property",attributes:{"type":"number","name":"iconWidth"},children:[{type:"desc",attributes:{"text":"<p>The width of the icon. If configured, this makes qx.ui.basic.Atom a little bit faster as it does not need to wait until the image loading is finished.</p>"}}]},{type:"property",attributes:{"type":"string","name":"label"},children:[{type:"desc",attributes:{"text":"<p>The label/caption/text of the qx.ui.basic.Atom instance</p>"}}]},{type:"property",attributes:{"possibleValues":"\"both\", \"label\", \"icon\", \"none\", null","defaultValue":"\"both\"","type":"string","name":"show"},children:[{type:"desc",attributes:{"text":"<p>Configure the visibility of the sub elements/widgets. Possible values: both, text, icon, none</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createIcon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"159"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createLabel"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"148"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleIcon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"329"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleLabel"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"306"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateIcon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"177"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getIconObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"200"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLabelObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"196"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.basic","fullName":"qx.ui.basic.HorizontalSpacer","name":"HorizontalSpacer","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"name":"Image","hasWarning":"true","packageName":"qx.ui.basic","superClass":"qx.ui.basic.Terminator","childClasses":"qx.ui.listview.ContentCellImage","fullName":"qx.ui.basic.Image"},children:[{type:"events",children:[{type:"event",attributes:{"name":"error"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}},{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vHeight"}}]},{type:"desc",attributes:{"text":"<p>This widget is for all images in qooxdoo projects.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vSource is not documented.","column":"1","line":"32"}},{type:"error",attributes:{"msg":"Parameter vWidth is not documented.","column":"1","line":"32"}},{type:"error",attributes:{"msg":"Parameter vHeight is not documented.","column":"1","line":"32"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"loaded"},children:[{type:"desc",attributes:{"text":"<p>The loading status.</p>\n\n<p>True if the image is loaded correctly. False if no image is loaded or the one that should be loaded is currently loading or not available.</p>"}}]},{type:"property",attributes:{"type":"Object","name":"preloader"},children:[{type:"desc",attributes:{"text":"<p>The assigned preloader instance of the image.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"resizeToInner"},children:[{type:"desc",attributes:{"text":"<p>Should the image be maxified in it&#8217;s own container?</p>"}}]},{type:"property",attributes:{"type":"string","name":"source"},children:[{type:"desc",attributes:{"text":"<p>The source uri of the image.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.basic.Terminator","overriddenFrom":"qx.ui.basic.Terminator","name":"_applyContent","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"443"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"425"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyElement","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onerror"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"98"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_postApply"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"333"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.basic","fullName":"qx.ui.basic.Inline","name":"Inline","hasWarning":"true","superClass":"qx.ui.layout.CanvasLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"inlineNodeId"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"37"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.basic","fullName":"qx.ui.basic.Label","name":"Label","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}},{type:"param",attributes:{"name":"vMnemonic"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.font.Font","type":"Object","name":"font"},children:[{type:"desc",attributes:{"text":"<p>The font property describes how to paint the font on the widget.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"none\", \"default\", \"extended\", \"multiline\", \"extendedmultiline\", \"all\"","defaultValue":"\"default\"","type":"string","name":"fontPropertiesProfile"},children:[{type:"desc",attributes:{"text":"<p>The styles which should be copied</p>"}}]},{type:"property",attributes:{"type":"string","name":"html"},children:[{type:"desc",attributes:{"text":"<p>Any text string which can contain <span class=\"caps\">HTML</span>, too</p>"}}]},{type:"property",attributes:{"type":"string","name":"mnemonic"},children:[{type:"desc",attributes:{"text":"<p>A single character which will be underlined inside the text.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"left\", \"center\", \"right\", \"justify\"","defaultValue":"\"left\"","type":"string","name":"textAlign"},children:[{type:"desc",attributes:{"text":"<p>The alignment of the text.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"wrap"},children:[{type:"desc",attributes:{"text":"<p>Wrap the text?</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"SYMBOL_ELLIPSIS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"111"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"SUPPORT_NATIVE_ELLIPSIS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"112"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"createMeasureNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"194"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"htmlToText"},children:[{type:"params",children:[{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"128"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"textToHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"169"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_htmlToText"},children:[{type:"params",children:[{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"132"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_textToHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"s"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"173"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computeObjectNeededDimensions"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"294"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"354"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"348"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_copyStyles"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"315"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_postApply"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"371"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_postApplyHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}},{type:"param",attributes:{"name":"vHtml"}},{type:"param",attributes:{"name":"vMnemonicMode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"532"}}]}]}]}]},{type:"class",attributes:{"name":"Terminator","hasWarning":"true","packageName":"qx.ui.basic","superClass":"qx.ui.core.Widget","childClasses":"qx.ui.basic.HorizontalSpacer,qx.ui.basic.Image,qx.ui.basic.Label,qx.ui.basic.VerticalSpacer,qx.ui.core.ClientDocumentBlocker,qx.ui.embed.Flash,qx.ui.embed.Gallery,qx.ui.embed.GalleryList,qx.ui.embed.HtmlEmbed,qx.ui.embed.Iframe,qx.ui.embed.NodeEmbed,qx.ui.embed.TextEmbed,qx.ui.form.InputCheckSymbol,qx.ui.form.TextField,qx.ui.listview.HeaderSeparator,qx.ui.table.TablePane","fullName":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This widget is the last widget of the current child chain.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"77"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyPaddingX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vChanges"}},{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"44"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyPaddingY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vChanges"}},{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"55"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_isHeightEssential"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"164"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_isWidthEssential"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"139"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_layoutPost"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChanges"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"101"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.basic","fullName":"qx.ui.basic.VerticalSpacer","name":"VerticalSpacer","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.component","name":"component","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.component","fullName":"qx.ui.component.ColorPopup","name":"ColorPopup","hasWarning":"true","superClass":"qx.ui.popup.Popup"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"tables"}}]},{type:"desc",attributes:{"text":"<p>A color popup</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter tables is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"blue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"53"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"green"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"52"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"red"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"51"}}]}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","hasError":"true","type":"Object","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"49"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createAutoBtn"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"77"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createBoxes"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"92"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createColorSelector"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"167"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createLayout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"67"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createPreview"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"131"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createSelectorBtn"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"157"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onAutomaticBtnExecute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"277"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBeforeAppear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"305"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onColorSelectorCancel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"301"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onColorSelectorOk"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"294"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onFieldMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"269"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onFieldMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"273"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onSelectorButtonExecute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"282"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_rotatePreviousColors"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"222"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.popup.Popup","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.component","fullName":"qx.ui.component.ColorSelector","name":"ColorSelector","hasWarning":"true","superClass":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"dialogcancel"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"dialogok"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPreviousRed"}},{type:"param",attributes:{"name":"vPreviousGreen"}},{type:"param",attributes:{"name":"vPreviousBlue"}}]},{type:"desc",attributes:{"text":"<p>A typical color selector as known from native applications.</p>\n\n<p>Includes support for <span class=\"caps\">RGB</span> and <span class=\"caps\">HSB</span> color areas.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vPreviousRed is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vPreviousGreen is not documented.","column":"1","line":"33"}},{type:"error",attributes:{"msg":"Parameter vPreviousBlue is not documented.","column":"1","line":"33"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"255","type":"number","name":"blue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"77"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"100","type":"number","name":"brightness"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"81"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"255","type":"number","name":"green"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"76"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"hue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"79"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"255","type":"number","name":"red"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"75"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"0","type":"number","name":"saturation"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"80"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createBrightnessPane"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"191"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createButtonBar"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"128"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createControlBar"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"121"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createControlPane"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"157"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createHexField"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"311"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createHsbSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"362"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createHueSaturationPane"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"166"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createInputFieldSet"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"272"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createPresetFieldSet"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"228"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createPreviewContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"402"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createPreviewFieldSet"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"284"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createRgbSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"334"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBrightnessFieldMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"687"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBrightnessHandleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"661"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBrightnessHandleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"679"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBrightnessHandleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"673"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onBrightnessPaneMouseWheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"699"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onButtonCancelExecute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"727"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onButtonOkExecute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"723"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onColorFieldClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"981"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHexFieldChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"919"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHueSaturationFieldMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"769"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHueSaturationHandleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"742"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHueSaturationHandleMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"761"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHueSaturationHandleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"755"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onHueSaturationPaneMouseWheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"782"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setBlueFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"847"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setBrightnessFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"895"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setBrightnessOnFieldEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"703"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setGreenFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"836"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setHexFromRgb"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"964"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setHueFromRgb"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"1007"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setHueFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"873"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setHueSaturationOnFieldEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"786"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setPreviewFromRgb"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"1053"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setRedFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"825"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setRgbFromHue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"1025"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setSaturationFromSpinner"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"884"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"setPreviousColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRed"}},{type:"param",attributes:{"name":"vGreen"}},{type:"param",attributes:{"name":"vBlue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"1066"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.component","fullName":"qx.ui.component.DateChooser","name":"DateChooser","hasWarning":"true","superClass":"qx.ui.layout.BoxLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"select"},children:[{type:"desc",attributes:{"text":"<p>Fired when a date was selected. The event holds the new selected date in its data property.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"date"},children:[{type:"desc",attributes:{"text":"<p>The initial date to show. If <code>null</code> the current day (today) is shown.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Date"}}]}]}]},{type:"desc",attributes:{"text":"<p>Shows calendar and allows choosing a date.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"null","type":"Object","name":"date"},children:[{type:"desc",attributes:{"text":"<p>The currently selected date.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Date"}}]}]},{type:"property",attributes:{"defaultValue":"null","type":"number","name":"shownMonth"},children:[{type:"desc",attributes:{"text":"<p>The currently shown month. 0 = january, 1 = february, and so on.</p>"}}]},{type:"property",attributes:{"defaultValue":"null","type":"number","name":"shownYear"},children:[{type:"desc",attributes:{"text":"<p>The currently shown year.</p>"}}]},{type:"property",attributes:{"defaultValue":"1","type":"number","name":"startOfWeek"},children:[{type:"desc",attributes:{"text":"<p>The start of the week. 0 = sunday, 1 = monday, and so on.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_isWeekend"},children:[{type:"params",children:[{type:"param",attributes:{"name":"dayOfWeek"},children:[{type:"desc",attributes:{"text":"<p>the day to check. (0 = sunday, 1 = monday, ..., 6 = saturday)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a certain day of week belongs to the week end.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the day belongs to the week end.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"_onDayClicked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when a day has been clicked.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_onDayDblClicked"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"255"}}]}]},{type:"method",attributes:{"name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when a key was pressed.</p>"}}]},{type:"method",attributes:{"name":"_onNavButtonClicked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when a navigation button has been clicked.</p>"}}]},{type:"method",attributes:{"name":"_updateDatePane"},children:[{type:"desc",attributes:{"text":"<p>Updates the date pane.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"name":"showMonth"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"month"},children:[{type:"desc",attributes:{"text":"<p>the month to show (0 = january). If not set the month will remain the same.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"year"},children:[{type:"desc",attributes:{"text":"<p>the year to show. If not set the year will remain the same.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Shows a certain month.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"MONTH_YEAR_FORMAT"},children:[{type:"desc",attributes:{"text":"<p>The format for the date year label at the top center.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.format.DateFormat"}}]}]},{type:"constant",attributes:{"name":"WEEKDAY_FORMAT"},children:[{type:"desc",attributes:{"text":"<p>The format for the weekday labels (the headers of the date table).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.format.DateFormat"}}]}]},{type:"constant",attributes:{"name":"WEEK_FORMAT"},children:[{type:"desc",attributes:{"text":"<p>The format for the week labels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.format.DateFormat"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.core","name":"core","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.core","fullName":"qx.ui.core.ClientDocument","name":"ClientDocument","hasWarning":"true","superClass":"qx.ui.layout.CanvasLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"windowblur"},children:[{type:"desc",attributes:{"text":"<p>Fired when the window looses the focus. (Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"windowfocus"},children:[{type:"desc",attributes:{"text":"<p>Fired when the window gets the focus. (Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"windowresize"},children:[{type:"desc",attributes:{"text":"<p>Fired when the window has been resized. (Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This is the basic widget of all qooxdoo applications.</p>\n\n<p>qx.ui.core.ClientDocument is the parent of all children inside your application. It also handles their resizing and focus navigation.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"globalCursor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"89"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_computeInnerHeight","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_computeInnerWidth","hasWarning":"true"}},{type:"method",attributes:{"name":"_getBlocker"},children:[{type:"desc",attributes:{"text":"<p>Returns the blocker widget if already created; otherwise create it first</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the blocker widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"ClientDocumentBlocker"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyElement","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onwindowresize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"348"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addCssRule"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"}},{type:"param",attributes:{"name":"vSelector"}},{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"278"}}]}]},{type:"method",attributes:{"hasError":"true","name":"block"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vActiveChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"blockHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"193"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createStyleElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCssText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"274"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getDocumentElement"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"147"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWindowElement"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"146"}}]}]},{type:"method",attributes:{"hasError":"true","name":"release"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vActiveChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"230"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAllCssRules"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"286"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeCssRule"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSheet"}},{type:"param",attributes:{"name":"vSelector"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"282"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.core","fullName":"qx.ui.core.ClientDocumentBlocker","name":"ClientDocumentBlocker","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>qx.ui.core.ClientDocumentBlocker blocks the inputs from the user. This will be used internally to allow better modal dialogs for example.</p>"}}]}]}]},{type:"class",attributes:{"name":"Parent","hasWarning":"true","packageName":"qx.ui.core","superClass":"qx.ui.core.Widget","childClasses":"qx.ui.layout.BoxLayout,qx.ui.layout.CanvasLayout,qx.ui.layout.DockLayout,qx.ui.layout.FlowLayout,qx.ui.layout.GridLayout","fullName":"qx.ui.core.Parent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"30"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"ABSTRACT_CLASS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"45"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.ui.core.Widget","type":"Object","name":"activeChild"},children:[{type:"desc",attributes:{"text":"<p>The current active child.</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.core.Widget","type":"Object","name":"focusedChild"},children:[{type:"desc",attributes:{"text":"<p>The current focused child.</p>"}}]},{type:"property",attributes:{"instance":"qx.event.handler.FocusHandler","type":"Object","name":"focusHandler"},children:[{type:"desc",attributes:{"text":"<p>Individual focus handler for all child elements.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"activateFocusRoot"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"111"}}]}]},{type:"method",attributes:{"name":"add"},children:[{type:"desc",attributes:{"text":"<p>Add/Append another widget. Allows to add multiple at one, a parameter could be a widget.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"addAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vAfter"}}]},{type:"desc",attributes:{"text":"<p>Add a widget after another already inserted child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"21","line":"510"}},{type:"error",attributes:{"msg":"Parameter vAfter is not documented.","column":"21","line":"510"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"441"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addAtBegin"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"474"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addAtEnd"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"478"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vBefore"}}]},{type:"desc",attributes:{"text":"<p>Add a widget before another already inserted child</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"22","line":"489"}},{type:"error",attributes:{"msg":"Parameter vBefore is not documented.","column":"22","line":"489"}}]}]},{type:"method",attributes:{"hasError":"true","name":"contains"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"desc",attributes:{"text":"<p>Check if the given qx.ui.core.Widget is a children.</p>\n\n<p>#param des[qx.ui.core.Widget]: The widget which should be checked.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vWidget is not documented.","column":"21","line":"334"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"forEachChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"646"}}]}]},{type:"method",attributes:{"hasError":"true","name":"forEachVisibleChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFunc"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"654"}}]}]},{type:"method",attributes:{"name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Return the array of all children</p>"}}]},{type:"method",attributes:{"name":"getChildrenLength"},children:[{type:"desc",attributes:{"text":"<p>Get children count</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getFirstActiveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIgnoreClasses"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"608"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirstChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"600"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirstVisibleChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"604"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"getFocusRoot","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"getInnerHeightForChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"1072"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getInnerWidthForChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"1068"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastActiveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIgnoreClasses"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"631"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"623"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastVisibleChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"627"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLayoutImpl"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"278"}}]}]},{type:"method",attributes:{"name":"getVisibleChildrenLength"},children:[{type:"desc",attributes:{"text":"<p>Get length of visible children</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"getWidgetFromPointHelper","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]}]},{type:"method",attributes:{"name":"hasChildren"},children:[{type:"desc",attributes:{"text":"<p>Check if the widget has a children</p>"}}]},{type:"method",attributes:{"name":"hasVisibleChildren"},children:[{type:"desc",attributes:{"text":"<p>Check if the widget has any visible children</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"desc",attributes:{"text":"<p>Get the position of a children.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vChild is not documented.","column":"20","line":"325"}}]}]},{type:"method",attributes:{"name":"isEmpty"},children:[{type:"desc",attributes:{"text":"<p>Check if there are any childrens inside</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"isFocusRoot","hasWarning":"true"}},{type:"method",attributes:{"name":"isVisibleEmpty"},children:[{type:"desc",attributes:{"text":"<p>Check if there are any visible childrens inside</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"recursiveAddToStateQueue","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"remapChildrenHandlingTo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vTarget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"1140"}}]}]},{type:"method",attributes:{"name":"remove"},children:[{type:"desc",attributes:{"text":"<p>Remove one or multiple childrens.</p>"}}]},{type:"method",attributes:{"name":"removeAll"},children:[{type:"desc",attributes:{"text":"<p>Remove all childrens.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"562"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_addChildrenToLayoutQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"891"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_addChildrenToStateQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"804"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_addChildToChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"840"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterDisappear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterInsertDom","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterRemoveDom","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeInsertDom","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeRemoveDom","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_changeInnerHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"1050"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_changeInnerWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"1032"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_cloneRecursive","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cloneInstance"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"1028"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"1024"}}]}]},{type:"method",attributes:{"name":"_computeVisibleChildren"},children:[{type:"desc",attributes:{"text":"<p>Return the array of all visible children (which are configured as visible=true)</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_createLayoutImpl"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"274"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_flushChildrenQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"870"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleDisplayableCustom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDisplayable"}},{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vHint"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"785"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_layoutChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"898"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onfocuskeyevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"115"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_recursiveAppearanceThemeUpdate","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewAppearanceTheme"}},{type:"param",attributes:{"name":"vOldAppearanceTheme"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_removeChildFromChildrenQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"858"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.core","fullName":"qx.ui.core.ScrollBar","name":"ScrollBar","superClass":"qx.ui.layout.BoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"false","name":"horizontal"},children:[{type:"desc",attributes:{"text":"<p>whether the scroll bar should be horizontal. If false it will be vertical.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>A scroll bar.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","type":"number","name":"maximum"},children:[{type:"desc",attributes:{"text":"<p>The maximum value of the scroll bar. Note that the size of the scroll bar is substracted.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"false","type":"boolean","name":"mergeEvents"},children:[{type:"desc",attributes:{"text":"<p>Whether to merge consecutive scroll event. If true, events will be collected until the user stops scrolling, so the scroll bar itself will move smoothly and the scrolled content will update asynchroniously.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"0","type":"number","name":"value"},children:[{type:"desc",attributes:{"text":"<p>The current value of the scroll bar. This value is between 0 and (maxium &#8211; size), where size is the width of a horizontal resp. the height of a vertical scroll bar in pixels.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Parent","name":"_afterAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_computePreferredInnerHeight","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_computePreferredInnerWidth","hasWarning":"true"}},{type:"method",attributes:{"name":"_getScrollBarWidth"},children:[{type:"desc",attributes:{"text":"<p>Gets the width of vertical scroll bar.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the width in pixels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyVisibility","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"name":"_onscroll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the user scrolled.</p>"}}]},{type:"method",attributes:{"name":"_positionKnob"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value where to postion the scroll bar.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Positions the scroll bar knob at a certain value.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}}]},{type:"constants",children:[{type:"constant",attributes:{"name":"EVENT_DELAY"},children:[{type:"desc",attributes:{"text":"<p>The delay when to update the scroll bar value after a scroll event if {@link #mergeEvents} is true (in milliseconds). All scroll events that arrive in shorter time will be merged.</p>"}}]}]}]},{type:"class",attributes:{"name":"Widget","hasWarning":"true","packageName":"qx.ui.core","superClass":"qx.core.Target","childClasses":"qx.ui.basic.Terminator,qx.ui.core.Parent","fullName":"qx.ui.core.Widget"},children:[{type:"events",children:[{type:"event",attributes:{"name":"appear"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeAppear"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeDisappear"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeInsertDom"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeRemoveDom"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"blur"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.ui.core.Parent})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.FocusEvent"}}]}]},{type:"event",attributes:{"name":"click"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"contextmenu"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"create"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"dblclick"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"disappear"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"execute"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"FADE_FINISHED"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]},{type:"event",attributes:{"name":"focus"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.ui.core.Parent})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.FocusEvent"}}]}]},{type:"event",attributes:{"name":"focusin"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.ui.core.Parent})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.FocusEvent"}}]}]},{type:"event",attributes:{"name":"focusout"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.ui.core.Parent})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.FocusEvent"}}]}]},{type:"event",attributes:{"name":"insertDom"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"keydown"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyEvent"}}]}]},{type:"event",attributes:{"name":"keyinput"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyEvent"}}]}]},{type:"event",attributes:{"name":"keypress"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyEvent"}}]}]},{type:"event",attributes:{"name":"keyup"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyEvent"}}]}]},{type:"event",attributes:{"name":"mousedown"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"mousemove"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"mouseout"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"mouseover"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"mouseup"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"mousewheel"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.event.handler.EventHandler})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]},{type:"event",attributes:{"name":"removeDom"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>This is the main widget, all visible objects in the application extend this.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"ABSTRACT_CLASS"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"103"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"SCROLLBAR_SIZE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"106"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TYPE_NULL"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3066"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TYPE_PIXEL"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"3067"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TYPE_PERCENT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"3068"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TYPE_AUTO"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3069"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TYPE_FLEX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3070"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"FADE_IN"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"5543"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"FADE_OUT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5544"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"FADE_FINISHED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"5545"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"allowStretchX"},children:[{type:"desc",attributes:{"text":"<p>Should this widget be stretched on the x-axis if the layout handler will do this? Used by some layout handlers (qx.ui.layout.BoxLayout, ...).</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"allowStretchY"},children:[{type:"desc",attributes:{"text":"<p>Should this widget be stretched on the y-axis if the layout handler will do this? Used by some layout handlers (qx.ui.layout.BoxLayout, ...).</p>"}}]},{type:"property",attributes:{"getAlias":"isAnonymous","defaultValue":"false","type":"boolean","name":"anonymous"},children:[{type:"desc",attributes:{"text":"<p>If you switch this to true, the widget doesn&#8217;t handle events directly. It will redirect them to the parent widget.</p>"}}]},{type:"property",attributes:{"type":"string","name":"appearance"},children:[{type:"desc",attributes:{"text":"<p>Appearance of the widget</p>"}}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","type":"Object","name":"backgroundColor"},children:[{type:"desc",attributes:{"text":"<p>The backgroundColor style property of the rendered widget. As input are allowed any instance of qx.renderer.color.Color or a string which defines the color itself.</p>"}}]},{type:"property",attributes:{"type":"string","name":"backgroundImage"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property background-image.</p>\n\n<p>The <span class=\"caps\">URI</span> of the image file to use as background image.</p>"}}]},{type:"property",attributes:{"instance":"qx.renderer.border.Border","type":"Object","name":"border"},children:[{type:"desc",attributes:{"text":"<p>The border property describes how to paint the border on the widget.</p>\n\n<p>This should be used with caution since in some cases (mostly complex widgets) this might give unrespected results.</p>"}}]},{type:"property",attributes:{"name":"bottom","unitDetection":"pixelPercent"},children:[{type:"desc",attributes:{"text":"<p>The distance from the outer bottom border to the parent bottom area edge.</p>\n\n<p>You could only set two of the three vertical dimension properties (boxTop, boxBottom, boxHeight) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Capture all events and map them to this widget</p>"}}]},{type:"property",attributes:{"type":"number","name":"clipHeight"},children:[{type:"desc",attributes:{"text":"<p>Clipping of the widget (height)</p>"}}]},{type:"property",attributes:{"type":"number","name":"clipLeft"},children:[{type:"desc",attributes:{"text":"<p>Clipping of the widget (left)</p>"}}]},{type:"property",attributes:{"type":"number","name":"clipTop"},children:[{type:"desc",attributes:{"text":"<p>Clipping of the widget (top)</p>"}}]},{type:"property",attributes:{"type":"number","name":"clipWidth"},children:[{type:"desc",attributes:{"text":"<p>Clipping of the widget (width)</p>"}}]},{type:"property",attributes:{"instance":"qx.renderer.color.Color","type":"Object","name":"color"},children:[{type:"desc",attributes:{"text":"<p>The color style property of the rendered widget. As input are allowed any instance of qx.renderer.color.Color or a string which defines the color itself.</p>"}}]},{type:"property",attributes:{"instance":"qx.client.Command","type":"Object","name":"command"},children:[{type:"desc",attributes:{"text":"<p>A command called if the widget should be excecuted (a placeholder for buttons, ...)</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.menu.Menu","type":"Object","name":"contextMenu"},children:[{type:"desc",attributes:{"text":"<p>Contains the context menu object connected to the widget. (Need real implementation)</p>"}}]},{type:"property",attributes:{"type":"string","name":"cursor"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property cursor.</p>\n\n<p>The name of the cursor to show when the mouse pointer is over the widget. This is any valid CSS2 cursor name defined by W3C.</p>\n\n<p>The following values are possible: <ul><li>default</li> <li>crosshair</li> <li>pointer (hand is the ie name and will mapped to pointer in non-ie).</li> <li>move</li> <li>n-resize</li> <li>ne-resize</li> <li>e-resize</li> <li>se-resize</li> <li>s-resize</li> <li>sw-resize</li> <li>w-resize</li> <li>nw-resize</li> <li>text</li> <li>wait</li> <li>help </li> <li>url([file]) = self defined cursor, file should be an <span class=\"caps\">ANI</span>- or <span class=\"caps\">CUR</span>-type</li> </ul></p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"display"},children:[{type:"desc",attributes:{"text":"<p>If the widget should be displayed. Use this property instead of visibility if the change in visibility should have effects on the parent widget.</p>"}}]},{type:"property",attributes:{"name":"dropDataTypes"},children:[{type:"desc",attributes:{"text":"<p>Contains the support drop types for drag and drop support</p>"}}]},{type:"property",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element node (if the widget is created, otherwise null)</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"enableElementFocus"},children:[{type:"desc",attributes:{"text":"<p>Use <span class=\"caps\">DOM</span> focussing (focus() and blur() methods of <span class=\"caps\">DOM</span> nodes)</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"0","type":"number","name":"fadeCounter"},children:[{type:"desc",attributes:{"text":"<p>The current state of a fade in progress.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"40","type":"number","name":"fadeInterval"},children:[{type:"desc",attributes:{"text":"<p>The time between the fade steps.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"100","type":"number","name":"fadeMax"},children:[{type:"desc",attributes:{"text":"<p>The maximum opacity for a fadeIn.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"10","type":"number","name":"fadeSteps"},children:[{type:"desc",attributes:{"text":"<p>The amount of steps for the fade.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"400","type":"number","name":"fadeTime"},children:[{type:"desc",attributes:{"text":"<p>The duration for the fade.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"10","type":"number","name":"fadeUnit"},children:[{type:"desc",attributes:{"text":"<p>The amount of oppacity changed on each fade step.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"focused"},children:[{type:"desc",attributes:{"text":"<p>Handle focus state of this widget.</p>\n\n<p>someWidget.setFocused(true) set the current focus to this widget. someWidget.setFocused(false) remove the current focus and leave it blank.</p>\n\n<p>Normally you didn&#8217;t need to set this directly.</p>"}}]},{type:"property",attributes:{"name":"height","unitDetection":"pixelPercentAutoFlex"},children:[{type:"desc",attributes:{"text":"<p>The height of the box (including padding and border).</p>\n\n<p>You could only set two of the three vertical dimension properties (boxTop, boxBottom, boxHeight) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"hideFocus"},children:[{type:"desc",attributes:{"text":"<p>If the focus outline should be hidden.</p>"}}]},{type:"property",attributes:{"type":"string","name":"horizontalAlign"},children:[{type:"desc",attributes:{"text":"<p>This is used by many layout managers to control the individual horizontal alignment of this widget inside this parent.</p>\n\n<p>This should be used with caution since in some cases this might give unrespected results.</p>"}}]},{type:"property",attributes:{"name":"left","unitDetection":"pixelPercent"},children:[{type:"desc",attributes:{"text":"<p>The distance from the outer left border to the parent left area edge.</p>\n\n<p>You could only set two of the three horizonal dimension properties (boxLeft, boxRight, boxWidth) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"type":"number","name":"marginBottom"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (bottom)</p>"}}]},{type:"property",attributes:{"type":"number","name":"marginLeft"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (left)</p>"}}]},{type:"property",attributes:{"type":"number","name":"marginRight"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (right)</p>"}}]},{type:"property",attributes:{"type":"number","name":"marginTop"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (top)</p>"}}]},{type:"property",attributes:{"name":"maxHeight","unitDetection":"pixelPercentAuto"},children:[{type:"desc",attributes:{"text":"<p>The maximum height of the box (including padding and border).</p>\n\n<p>Set this to omit the expanding of the box height above this value.</p>"}}]},{type:"property",attributes:{"name":"maxWidth","unitDetection":"pixelPercentAuto"},children:[{type:"desc",attributes:{"text":"<p>The maximum width of the box (including padding and border).</p>\n\n<p>Set this to omit the expanding of the box width above this value.</p>"}}]},{type:"property",attributes:{"name":"minHeight","unitDetection":"pixelPercentAuto"},children:[{type:"desc",attributes:{"text":"<p>The minimum height of the box (including padding and border).</p>\n\n<p>Set this to omit the shrinking of the box height under this value.</p>"}}]},{type:"property",attributes:{"name":"minWidth","unitDetection":"pixelPercentAuto"},children:[{type:"desc",attributes:{"text":"<p>The minimum width of the box (including padding and border).</p>\n\n<p>Set this to omit the shrinking of the box width under this value.</p>"}}]},{type:"property",attributes:{"type":"number","name":"opacity"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property opacity.</p>\n\n<p>The uniform opacity setting to be applied across an entire object. Behaves like the new <span class=\"caps\">CSS</span>-3 Property. Any values outside the range 0.0 (fully transparent) to 1.0 (fully opaque) will be clamped to this range.</p>"}}]},{type:"property",attributes:{"type":"string","name":"overflow"},children:[{type:"desc",attributes:{"text":"<p>Describes how to handle content that is too large to fit inside the widget.</p>\n\n<p>Overflow modes:<br />\n* hidden: The content is clipped<br />\n* auto: Scroll bars are shown as needed<br />\n* scroll: Scroll bars are always shown. Even if there is enough room for the content inside the widget.<br />\n* scrollX: Scroll bars for the X-Axis are always shown. Even if there is enough room for the content inside the widget.<br />\n* scrollY: Scroll bars for the Y-Axis are always shown. Even if there is enough room for the content inside the widget.</p>"}}]},{type:"property",attributes:{"type":"number","name":"paddingBottom"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (bottom)</p>"}}]},{type:"property",attributes:{"type":"number","name":"paddingLeft"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (left)</p>"}}]},{type:"property",attributes:{"type":"number","name":"paddingRight"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (right)</p>"}}]},{type:"property",attributes:{"type":"number","name":"paddingTop"},children:[{type:"desc",attributes:{"text":"<p>Padding of the widget (top)</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.core.Parent","defaultValue":"null","type":"Object","name":"parent"},children:[{type:"desc",attributes:{"text":"<p>The parent widget (the real object, no ID or something)</p>"}}]},{type:"property",attributes:{"name":"right","unitDetection":"pixelPercent"},children:[{type:"desc",attributes:{"text":"<p>The distance from the outer right border to the parent right area edge.</p>\n\n<p>You could only set two of the three horizonal dimension properties (boxLeft, boxRight, boxWidth) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"getAlias":"isSelectable","defaultValue":"true","type":"boolean","name":"selectable"},children:[{type:"desc",attributes:{"text":"<p>Toggle the possibility to select the element of this widget.</p>"}}]},{type:"property",attributes:{"defaultValue":"-1","type":"number","name":"tabIndex"},children:[{type:"desc",attributes:{"text":"<p>Set this to a positive value makes the widget able to get the focus. It even is reachable through the usage of the tab-key.</p>\n\n<p>Widgets with the same tabIndex are handled through there position in the document.</p>"}}]},{type:"property",attributes:{"defaultValue":"\"div\"","type":"string","name":"tagName"},children:[{type:"desc",attributes:{"text":"<p>The tagname of the element which should automatically be created</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.popup.ToolTip","type":"Object","name":"toolTip"},children:[{type:"desc",attributes:{"text":"<p>Contains the tooltip object connected to the widget.</p>"}}]},{type:"property",attributes:{"name":"top","unitDetection":"pixelPercent"},children:[{type:"desc",attributes:{"text":"<p>The distance from the outer top border to the parent top area edge.</p>\n\n<p>You could only set two of the three vertical dimension properties (boxTop, boxBottom, boxHeight) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"type":"string","name":"verticalAlign"},children:[{type:"desc",attributes:{"text":"<p>This is used by many layout managers to control the individual vertical alignment of this widget inside this parent.</p>\n\n<p>This should be used with caution since in some cases this might give unrespected results.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"visibility"},children:[{type:"desc",attributes:{"text":"<p>Simple and fast switch of the visibility of a widget.</p>"}}]},{type:"property",attributes:{"name":"width","unitDetection":"pixelPercentAutoFlex"},children:[{type:"desc",attributes:{"text":"<p>The width of the box (including padding and border).</p>\n\n<p>You could only set two of the three horizonal dimension properties (boxLeft, boxRight, boxWidth) at the same time. This will be omitted during the setup of the new third value. To reset a value you didn&#8217;t want anymore, set it to null.</p>"}}]},{type:"property",attributes:{"type":"number","name":"zIndex"},children:[{type:"desc",attributes:{"text":"<p>Mapping to native style property z-index.</p>\n\n<p>This should be used with caution since in some cases this might give unrespected results.</p>"}}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalDisplayQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"958"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalElementQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"750"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalJobQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"854"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalLayoutQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"905"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalStateQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"801"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"addToGlobalWidgetQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"696"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalDisplayQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"988"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalElementQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"768"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalJobQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"872"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalLayoutQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"923"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalStateQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"819"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"flushGlobalWidgetQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"714"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getActiveSiblingHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vObject"}},{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vCalc"}},{type:"param",attributes:{"name":"vIgnoreClasses"}},{type:"param",attributes:{"name":"vMode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"1163"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getActiveSiblingHelperIgnore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIgnoreClasses"}},{type:"param",attributes:{"name":"vInstance"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"50","line":"1152"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initApplyMethods"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"2138"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initLayoutProperties"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"3154"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initOverflow"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"4886"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalDisplayQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"50","line":"986"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalElementQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"50","line":"759"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalJobQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"46","line":"863"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalLayoutQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vParent"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"49","line":"914"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalStateQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"48","line":"810"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"removeFromGlobalWidgetQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"49","line":"705"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vState"}}]},{type:"desc",attributes:{"text":"<p>Sets a state.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>state</code>.","column":"21","line":"3825"}},{type:"error",attributes:{"msg":"Parameter vState is not documented.","column":"21","line":"3825"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToDocument"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1792"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToJobQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1863"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToLayoutChanges"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2952"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"2961"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToQueueRuntime"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"2965"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addToStateQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"3988"}}]}]},{type:"method",attributes:{"name":"auto"},children:[{type:"desc",attributes:{"text":"<p>A bounded setup to the preferred width/height of the widget. Keeps in sync if the content or requirements of the widget changes</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"blur"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"4436"}}]}]},{type:"method",attributes:{"hasError":"true","name":"clone"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cloneRecursive"}},{type:"param",attributes:{"name":"customPropertyList"}}]},{type:"desc",attributes:{"text":"<p>Returns a cloned copy of the current instance of qx.ui.core.Widget.</p>\n\n<p>#param cloneRecursive[Boolean]: Should the widget cloned recursive (including all childs)?<br />\n#param customPropertyList[Array]: Optional (reduced) list of properties to copy through</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter cloneRecursive is not documented.","column":"18","line":"5288"}},{type:"error",attributes:{"msg":"Parameter customPropertyList is not documented.","column":"18","line":"5288"}}]}]},{type:"method",attributes:{"hasError":"true","name":"connect"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"1699"}}]}]},{type:"method",attributes:{"hasError":"true","name":"disconnect"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"1703"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.core.Target","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"execute"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"5345"}}]}]},{type:"method",attributes:{"hasError":"true","name":"fadeIn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSteps"}},{type:"param",attributes:{"name":"vTime"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"5548"}}]}]},{type:"method",attributes:{"hasError":"true","name":"fadeOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSteps"}},{type:"param",attributes:{"name":"vTime"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"5557"}}]}]},{type:"method",attributes:{"hasError":"true","name":"focus"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"4430"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getActiveChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"4357"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getBottomValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"2801"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getCachedBorderBottom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"5199"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getCachedBorderLeft"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"5203"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getCachedBorderRight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"5195"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getCachedBorderTop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"5191"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getClientHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5415"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getClientWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"5409"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getCssClassName"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"4568"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFadeTimer"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5566"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFocusRoot"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"4348"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHeightValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"2708"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHtmlAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"4196"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHtmlProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"4130"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLeftValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"2660"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMaxHeightValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"2762"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMaxWidthValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"2639"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMinHeightValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"2741"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMinWidthValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"2618"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNeededHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"2298"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNeededWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"2293"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNextActiveSibling"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIgnoreClasses"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"3743"}}]}]},{type:"method",attributes:{"name":"getNextSibling"},children:[{type:"desc",attributes:{"text":"<p>Returns the next sibling.</p>"}}]},{type:"method",attributes:{"name":"getNextVisibleSibling"},children:[{type:"desc",attributes:{"text":"<p>Returns the next visible sibling.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getOffsetHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5427"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getOffsetLeft"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"5385"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getOffsetTop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5391"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getOffsetWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"5421"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getOverflowX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5009"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getOverflowY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5015"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPreviousActiveSibling"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIgnoreClasses"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"3737"}}]}]},{type:"method",attributes:{"name":"getPreviousSibling"},children:[{type:"desc",attributes:{"text":"<p>Returns the previous sibling.</p>"}}]},{type:"method",attributes:{"name":"getPreviousVisibleSibling"},children:[{type:"desc",attributes:{"text":"<p>Returns the previous visible sibling.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getRightValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"2678"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScrollHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5439"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScrollLeft"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"5397"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScrollTop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5403"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScrollWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"5433"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getStyleProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"4232"}}]}]},{type:"method",attributes:{"name":"getTopLevelWidget"},children:[{type:"desc",attributes:{"text":"<p>The widget which is at the top level, which contains all others (normally a instance of qx.ui.core.ClientDocument).</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"getTopValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"2783"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWidgetFromPoint"},children:[{type:"params",children:[{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"4585"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWidgetFromPointHelper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"x"}},{type:"param",attributes:{"name":"y"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"4591"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWidthValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"2585"}}]}]},{type:"method",attributes:{"name":"hasState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vState"},children:[{type:"desc",attributes:{"text":"<p>the state to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a state is set.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the state is set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"hasError":"true","name":"hide"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"1695"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isAppearRelevant"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"1610"}}]}]},{type:"method",attributes:{"name":"isCreated"},children:[{type:"desc",attributes:{"text":"<p>Check if the widget is created (or the element is already available).</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"isDisplayable"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1317"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isFirstChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"3749"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isFirstVisibleChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"3757"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isFocusable"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"4340"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isFocusRoot"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"4344"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isLastChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"3753"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isLastVisibleChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"3761"}}]}]},{type:"method",attributes:{"name":"isMaterialized"},children:[{type:"desc",attributes:{"text":"<p>If the widget is visible and rendered on the screen.</p>"}}]},{type:"method",attributes:{"name":"isSeeable"},children:[{type:"desc",attributes:{"text":"<p>If the widget is currently seeable which means that it:</p>\n\n<ul>\n<li>has a also seeable parent</li>\n<li>visibility is true</li>\n<li>display is true</li>\n</ul>"}}]},{type:"method",attributes:{"hasError":"true","name":"moveSelfAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAfter"}}]},{type:"desc",attributes:{"text":"<p>Move myself to immediately after another child of the same parent.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vAfter is not documented.","column":"26","line":"3663"}}]}]},{type:"method",attributes:{"hasError":"true","name":"moveSelfBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBefore"}}]},{type:"desc",attributes:{"text":"<p>Move myself to immediately before another child of the same parent.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vBefore is not documented.","column":"27","line":"3656"}}]}]},{type:"method",attributes:{"name":"moveSelfToBegin"},children:[{type:"desc",attributes:{"text":"<p>Move myself to the head of the list: make me the first child.</p>"}}]},{type:"method",attributes:{"name":"moveSelfToEnd"},children:[{type:"desc",attributes:{"text":"<p>Move myself to the end of the list: make me the last child.</p>"}}]},{type:"method",attributes:{"name":"pack"},children:[{type:"desc",attributes:{"text":"<p>A single setup to the current preferred pixel values of the widget</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"recursiveAddToStateQueue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"3992"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeHtmlAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"4181"}}]}]},{type:"method",attributes:{"name":"removeState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vState"},children:[{type:"desc",attributes:{"text":"<p>the state to clear.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Clears a state.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"removeStyleProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"4267"}}]}]},{type:"method",attributes:{"hasError":"true","name":"resetFader"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"5575"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAlignTopLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"5455"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAlignLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5461"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAlignTop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5470"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setCssClassName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"4564"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setHtmlAttribute"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"4166"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setHtmlProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"4078"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setScrollLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nScrollLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"5373"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setScrollTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nScrollTop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5379"}}]}]},{type:"method",attributes:{"name":"setState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"state"},children:[{type:"desc",attributes:{"text":"<p>the state to set or clear.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"enabled"},children:[{type:"desc",attributes:{"text":"<p>whether the state should be set. If false it will be cleared.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets or clears a state.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"setStyleProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propName"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"4236"}}]}]},{type:"method",attributes:{"hasError":"true","name":"show"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"17","line":"1689"}}]}]},{type:"method",attributes:{"hasError":"true","name":"supportsDrop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDragCache"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"5492"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_afterAppear"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"1566"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_afterDisappear"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1590"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_afterInsertDom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1630"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_afterRemoveDom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"1642"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyBackgroundColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"5109"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyBorderX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vChanges"}},{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"2981"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyBorderY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vChanges"}},{type:"param",attributes:{"name":"vStyle"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"2987"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"5105"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyElementData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]},{type:"desc",attributes:{"text":"<p>Placeholder method to add attributes and other content to element node</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter el is not documented.","column":"30","line":"4065"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyHtmlAttributes"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"4205"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyHtmlProperties"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"4139"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyInitialAppearance"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"3879"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyOverflow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"pn"}},{type:"param",attributes:{"name":"pv"}},{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"4997"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyStateAppearance"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"3899"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyStyleProperties"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vElement"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"4298"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_beforeAppear"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"1560"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_beforeDisappear"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"1573"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_beforeInsertDom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"1624"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_beforeRemoveDom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"1636"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_cloneRecursive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cloneInstance"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5332"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_compileClipString"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"4821"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeBoxHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"2263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeBoxHeightFallback"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"2251"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeBoxWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"2255"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeBoxWidthFallback"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"2247"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeDisplayable"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"1556"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeFadeOpacity"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"5635"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeFrameHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"2857"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeFrameWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2836"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasAutoX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3034"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasAutoY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3040"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasFlexX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3046"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasFlexY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"3050"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasPercentX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"3018"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeHasPercentY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"3026"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeInnerHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"2289"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeInnerWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2285"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeOuterHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"2278"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeOuterWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2271"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredBoxHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"2929"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredBoxWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"2920"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePercentX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"2559"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePercentXLimit"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"2563"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePercentY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"2567"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePercentYLimit"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"2571"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePixel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2551"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeValuePixelLimit"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"2555"}}]}]},{type:"method",attributes:{"name":"_createElementImpl"},children:[{type:"desc",attributes:{"text":"<p>Create widget with empty element (of specified tagname).</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_evalUnitsPixelPercent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"3120"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalUnitsPixelPercentAuto"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"3096"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_evalUnitsPixelPercentAutoFlex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"3072"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_flushJobQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"q"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"1877"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_handleDisplayable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHint"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"1403"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateFrameDimensions"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"2878"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidatePreferredInnerDimensions"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"48","line":"2899"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyClip"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"4817"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyEnabled"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"3777"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyPaddingX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5254"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyPaddingY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"5260"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninlineevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"3584"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninlineinput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"3607"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninlineproperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"3619"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"5585"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputeFlexX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"2315"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputeFlexY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"2330"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputePercentX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2357"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputePercentY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"2396"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recursiveAppearanceThemeUpdate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewAppearanceTheme"}},{type:"param",attributes:{"name":"vOldAppearanceTheme"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"4039"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetAppearanceThemeWrapper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewAppearanceTheme"}},{type:"param",attributes:{"name":"vOldAppearanceTheme"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"3923"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetBackgroundColor"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"5117"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"5113"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_unitDetectionPixelPercent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propData"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"3390"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_unitDetectionPixelPercentAuto"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propData"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"43","line":"3304"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_unitDetectionPixelPercentAutoFlex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propData"}},{type:"param",attributes:{"name":"propValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"47","line":"3194"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateBorder"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vEdge"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"5207"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateColors"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColor"}},{type:"param",attributes:{"name":"vNewValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"5094"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_visualizeBlur"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"4400"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_visualizeFocus"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"4416"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_visualPropertyCheck"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"5366"}}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"__oninlineevent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"3573"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.embed","name":"embed","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.embed","fullName":"qx.ui.embed.Flash","name":"Flash","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}},{type:"param",attributes:{"name":"vVersion"}}]},{type:"desc",attributes:{"text":"<p>Original non qooxdoo Version by Geoff Stearns Flash detection and embed &#8211; <a href=\"http://blog.deconcept.com/flashobject/\">http://blog.deconcept.com/flashobject/</a> FlashObject is&#169; 2005 Geoff Stearns and is released under the <span class=\"caps\">MIT</span> License <a href=\"http://www.opensource.org/licenses/mit-license.php\">http://www.opensource.org/licenses/mit-license.php</a></p>\n\n<p>Modified for qooxdoo by Sebastian Werner Based on version 1.2.3 Relicensed under <span class=\"caps\">LGPL</span> in assent of Geoff Stearns</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vSource is not documented.","column":"1","line":"36"}},{type:"error",attributes:{"msg":"Parameter vVersion is not documented.","column":"1","line":"36"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"enableDetection"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"55"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"enableExpressInstall"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"54"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"loop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"62"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"menu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"63"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"play"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"61"}}]}]},{type:"property",attributes:{"possibleValues":"\"low\", \"autolow\", \"autohigh\", \"medium\", \"high\", \"best\"","defaultValue":"\"high\"","hasError":"true","type":"string","name":"quality"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"58"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"redirectUrl"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"56"}}]}]},{type:"property",attributes:{"possibleValues":"\"showall\", \"noborder\", \"excactfit\", \"noscale\"","defaultValue":"\"showall\"","hasError":"true","type":"string","name":"scale"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"59"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"source"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"51"}}]}]},{type:"property",attributes:{"hasError":"true","name":"version"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"52"}}]}]},{type:"property",attributes:{"possibleValues":"\"window\", \"opaque\", \"transparent\"","defaultValue":"\"\"","hasError":"true","type":"string","name":"wmode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"60"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"EXPRESSINSTALL"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"65"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MINREQUIRED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"66"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"PLAYERVERSION"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"67"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"PLUGINKEY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"68"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ACTIVEXKEY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"69"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"getPlayerVersion"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"81"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyBackgroundColor","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewValue"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyElementData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyBackgroundColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"205"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyParam"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"189"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"generateParamTags"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"281"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getParam"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"241"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getParams"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"245"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getVariable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getVariablePairs"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"298"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getVariables"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"267"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setParam"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"}},{type:"param",attributes:{"name":"value"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"237"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setVariable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"name"}},{type:"param",attributes:{"name":"value"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"259"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.embed","fullName":"qx.ui.embed.Gallery","name":"Gallery","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"events",children:[{type:"event",attributes:{"name":"beforeToolTipAppear"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"loadComplete"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vGalleryList"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vGalleryList is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"40","type":"number","name":"decorHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"68"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"showComment"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"70"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"showTitle"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"69"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"100","type":"number","name":"thumbMaxHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"67"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"100","type":"number","name":"thumbMaxWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"66"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyElementData"}},{type:"method",attributes:{"hasError":"true","name":"_onclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"301"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondblclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"310"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"319"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"244"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousemove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"262"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"253"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addFromPartialList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPartialList"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"217"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addFromUpdatedList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNewList"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"226"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"d"}},{type:"param",attributes:{"name":"i"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"412"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createImageCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"inode"}},{type:"param",attributes:{"name":"d"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"439"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createProtoCell"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"485"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createView"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"394"}}]}]},{type:"method",attributes:{"hasError":"true","name":"deleteById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"165"}}]}]},{type:"method",attributes:{"hasError":"true","name":"deleteByPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPos"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"169"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getEntryById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"197"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getEntryByNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"213"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getEntryByPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPosition"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"205"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFirstChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"374"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"370"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"378"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getList"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getListItemTarget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"dt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"323"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"98"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNodeById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"201"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getNodeByPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPosition"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPositionById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"186"}}]}]},{type:"method",attributes:{"hasError":"true","name":"imageOnComplete"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"460"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"116"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"346"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"352"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"356"}}]}]},{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vGalleryList"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"106"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateImageById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vSrc"}},{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"122"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateImageDimensionsById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"127"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateImageDimensionsByPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPos"}},{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"44","line":"131"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateImageSrcById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}},{type:"param",attributes:{"name":"vSrc"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"149"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateImageSrcByPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vPos"}},{type:"param",attributes:{"name":"vSrc"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"153"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"imageOnError"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"477"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"imageOnLoad"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"469"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.embed","fullName":"qx.ui.embed.GalleryList","name":"GalleryList","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"events",children:[{type:"event",attributes:{"name":"loadComplete"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"galleryList"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter galleryList is not documented.","column":"1","line":"28"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"40","type":"number","name":"decorHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"52"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"60","type":"number","name":"thumbMaxHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"51"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"60","type":"number","name":"thumbMaxWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"50"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyElementData"}},{type:"method",attributes:{"hasError":"true","name":"_onclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"123"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondblclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"132"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"141"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"105"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"114"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"createImageCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"inode"}},{type:"param",attributes:{"name":"d"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"261"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createProtoCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"tHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"282"}}]}]},{type:"method",attributes:{"hasError":"true","name":"createView"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"221"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getFirstChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"202"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"198"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLastChild"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"206"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getListItemTarget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"dt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"145"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"76"}}]}]},{type:"method",attributes:{"hasError":"true","name":"imageOnComplete"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"341"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeAll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"92"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"170"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"176"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"180"}}]}]},{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vGalleryList"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"81"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"imageOnError"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"358"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"imageOnLoad"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"350"}}]}]}]}]},{type:"class",attributes:{"name":"HtmlEmbed","hasWarning":"true","packageName":"qx.ui.embed","superClass":"qx.ui.basic.Terminator","childClasses":"api.ClassViewer,api.InfoViewer,qx.ui.embed.IconHtmlEmbed,qx.ui.embed.LinkEmbed,qx.ui.listview.ContentCellHtml,swat.module.ldbbrowse.LdifViewer","fullName":"qx.ui.embed.HtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.font.Font","type":"Object","name":"font"},children:[{type:"desc",attributes:{"text":"<p>The font property describes how to paint the font on the widget.</p>"}}]},{type:"property",attributes:{"type":"string","name":"html"},children:[{type:"desc",attributes:{"text":"<p>Any text string which can contain <span class=\"caps\">HTML</span>, too</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"wrap"},children:[{type:"desc",attributes:{"text":"<p>Wrap the text?</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyElementData"}},{type:"method",attributes:{"hasError":"true","name":"_syncHtml"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"110"}}]}]}]}]},{type:"class",attributes:{"name":"IconHtmlEmbed","hasWarning":"true","packageName":"qx.ui.embed","superClass":"qx.ui.embed.HtmlEmbed","childClasses":"qx.ui.listview.ContentCellIconHtml","fullName":"qx.ui.embed.IconHtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"string","name":"icon"},children:[{type:"desc",attributes:{"text":"<p>Any <span class=\"caps\">URI</span> String supported by qx.ui.basic.Image to display a icon</p>"}}]},{type:"property",attributes:{"type":"number","name":"iconHeight"},children:[{type:"desc",attributes:{"text":"<p>The height of the icon If configured, this makes qx.ui.embed.IconHtmlEmbed a little bit faster as it does not need to wait until the image loading is finished.</p>"}}]},{type:"property",attributes:{"type":"number","name":"iconWidth"},children:[{type:"desc",attributes:{"text":"<p>The width of the icon. If configured, this makes qx.ui.embed.IconHtmlEmbed a little bit faster as it does not need to wait until the image loading is finished.</p>"}}]},{type:"property",attributes:{"defaultValue":"4","type":"number","name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Space in pixels between the icon and the <span class=\"caps\">HTML</span>.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.embed.HtmlEmbed","overriddenFrom":"qx.ui.embed.HtmlEmbed","name":"_syncHtml","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.embed","fullName":"qx.ui.embed.Iframe","name":"Iframe","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"events",children:[{type:"event",attributes:{"name":"load"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vSource is not documented.","column":"1","line":"29"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"__onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"41"}}]}]},{type:"method",attributes:{"hasError":"true","name":"__onreadystatechange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"40"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applySource"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"202"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_modifyElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"140"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onload"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"242"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onreadystatechange"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"235"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"frameName"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"63"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"source"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"61"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"block"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"116"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getBlockerNode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"94"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIframeNode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"81"}}]}]},{type:"method",attributes:{"hasError":"true","name":"release"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"123"}}]}]},{type:"method",attributes:{"hasError":"true","name":"reload"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"111"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setBlockerNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBlockerNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"98"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setIframeNode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIframeNode"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"85"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initBlocker"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"408"}}]}]},{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"initIframe"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vFrameName"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"371"}}]}]}]}]},{type:"class",attributes:{"name":"LinkEmbed","hasWarning":"true","packageName":"qx.ui.embed","superClass":"qx.ui.embed.HtmlEmbed","childClasses":"qx.ui.listview.ContentCellLink","fullName":"qx.ui.embed.LinkEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}},{type:"param",attributes:{"name":"vUri"}},{type:"param",attributes:{"name":"vTarget"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"\"_blank\"","type":"string","name":"target"},children:[{type:"desc",attributes:{"text":"<p>Any valid html target</p>"}}]},{type:"property",attributes:{"defaultValue":"\"#\"","type":"string","name":"uri"},children:[{type:"desc",attributes:{"text":"<p>Any valid html <span class=\"caps\">URI</span></p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"LINK_START"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"70"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"HREF_START"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"71"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"HREF_STOP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"72"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"LINK_STOP"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"73"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.embed.HtmlEmbed","overriddenFrom":"qx.ui.embed.HtmlEmbed","name":"_syncHtml","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.embed","fullName":"qx.ui.embed.NodeEmbed","name":"NodeEmbed","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"sourceNodeId"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"35"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createElementImpl"}}]}]},{type:"class",attributes:{"name":"TextEmbed","hasWarning":"true","packageName":"qx.ui.embed","superClass":"qx.ui.basic.Terminator","childClasses":"qx.ui.listview.ContentCellText","fullName":"qx.ui.embed.TextEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.font.Font","type":"Object","name":"font"},children:[{type:"desc",attributes:{"text":"<p>The font property describes how to paint the font on the widget.</p>"}}]},{type:"property",attributes:{"type":"string","name":"text"},children:[{type:"desc",attributes:{"text":"<p>Any text string which can contain <span class=\"caps\">TEXT</span>, too</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"\"left\"","type":"string","name":"textAlign","possibleValues":"\"left\", \"center\", \"right\", \"justify\""},children:[{type:"desc",attributes:{"text":"<p>The horizontal alignment of the text.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"wrap"},children:[{type:"desc",attributes:{"text":"<p>Wrap the text?</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyElementData"}},{type:"method",attributes:{"hasError":"true","name":"_syncText"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"119"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.form","name":"form","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Button","hasWarning":"true","packageName":"qx.ui.form","superClass":"qx.ui.basic.Atom","childClasses":"qx.ui.form.RepeatButton,qx.ui.toolbar.Button","fullName":"qx.ui.form.Button"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"135"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"146"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"97"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"78"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"63"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"107"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.basic.Atom","name":"dispose"}}]}]},{type:"class",attributes:{"name":"CheckBox","hasWarning":"true","packageName":"qx.ui.form","superClass":"qx.ui.basic.Atom","childClasses":"qx.ui.form.RadioButton","fullName":"qx.ui.form.CheckBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vValue"}},{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vChecked"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isChecked","type":"boolean","name":"checked"},children:[{type:"desc",attributes:{"text":"<p>If the widget is checked</p>"}}]},{type:"property",attributes:{"type":"string","name":"name"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">HTML</span> name of the form element used by the widget</p>"}}]},{type:"property",attributes:{"type":"string","name":"value"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">HTML</span> value of the form element used by the widget</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.basic.Atom","overriddenFrom":"qx.ui.basic.Atom","name":"_createIcon","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.basic.Atom","overriddenFrom":"qx.ui.basic.Atom","name":"_handleIcon","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.basic.Atom","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"176"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"184"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.basic.Atom","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.ComboBox","name":"ComboBox","hasWarning":"true","superClass":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"beforeInitialOpen"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A combo-box for qooxdoo.</p>\n\n<p>The major additional feature compared to typical select fields is that it allows it to be editable. Also images are supported inside the popup list.</p>\n\n<p>Features: <ul> <li>Editable text field</li> <li>Complete key-navigation</li> <li>Images inside the list</li> <li>Images and text inside the list</li> </ul></p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isEditable","hasError":"true","type":"boolean","name":"editable"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"160"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"10","type":"number","name":"pagingInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"163"}}]}]},{type:"property",attributes:{"instance":"qx.ui.form.ListItem","hasError":"true","type":"Object","name":"selected"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"161"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"162"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getButton"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"190"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getField"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"186"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getList"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"182"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"174"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"178"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_closePopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"332"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onbeforedisappear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"382"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"367"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"511"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyinput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"644"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"563"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"395"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"451"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"434"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousewheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"468"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onpopupappear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"359"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_openPopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"308"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_testClosePopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"338"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_togglePopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"345"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_visualizeBlur","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_visualizeFocus","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.ComboBoxEx","name":"ComboBoxEx","hasWarning":"true","superClass":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"beforeInitialOpen"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An enhanced combo-box for qooxdoo.</p>\n\n<p>Features:  <ul> <li>Editable text field</li> <li>Complete key-navigation</li> <li>Mouse wheel navigation</li> <li>Multicolumn display in list</li> <li>If more than one column, headers are automatically shown</li> <li>Can show the ID and/or description of each list item</li> <li>Automatically calculating needed width</li> <li>Popup list always shows full contents, and can be wider than text field</li> <li>Search values through popup dialog</li> <li>Internationalization support of messages (through custom settings)</li> </ul></p>\n\n<p>Pending features:  <ul> <li>Images inside the list</li> <li>Autocomplete on key input</li> </ul></p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"allowSearch"},children:[{type:"desc",attributes:{"text":"<p>Allow the search dialog when double clicking the combo, or pressing special keys?.</p>"}}]},{type:"property",attributes:{"getAlias":"isEditable","type":"boolean","name":"editable"},children:[{type:"desc",attributes:{"text":"<p>Is the text field component editable or the user can only select from the list?</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"ensureSomethingSelected"},children:[{type:"desc",attributes:{"text":"<p>Ensures that always an item is selected (in case the selection isn&#8217;t empty). Only used when editable is false.</p>"}}]},{type:"property",attributes:{"getAlias":"isIdColumnVisible","defaultValue":"false","type":"boolean","name":"idColumnVisible"},children:[{type:"desc",attributes:{"text":"<p>Show the ID column (column 0) of the selection data?</p>"}}]},{type:"property",attributes:{"defaultValue":"\"- \"","type":"string","name":"idDescriptionSeparator"},children:[{type:"desc",attributes:{"text":"<p>Only used when editable is false and showOnTextField==&#8216;idAndDescription&#8217;.</p>"}}]},{type:"property",attributes:{"defaultValue":"10","type":"number","name":"maxVisibleRows"},children:[{type:"desc",attributes:{"text":"<p>Maximum number of visible rows in the popup list.</p>"}}]},{type:"property",attributes:{"defaultValue":"10","type":"number","name":"pagingInterval"},children:[{type:"desc",attributes:{"text":"<p>How many items to transverse with PageUp and PageDn.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"description\", \"idAndDescription\"","defaultValue":"\"description\"","type":"string","name":"showOnTextField"},children:[{type:"desc",attributes:{"text":"<p>Only used when editable is false.  It determines what to show in the text field of the combo box.</p>"}}]},{type:"property",attributes:{"type":"string","name":"value"},children:[{type:"desc",attributes:{"text":"<p>0 based. -1 means no selected index.  It retrieves always the value column of the selection, not the description.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getButton"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"186"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnHeaders"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propVal"}}]},{type:"desc",attributes:{"text":"<p>Getter for {@link #setColumnHeaders}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"String","dimensions":"1"}}]}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter propVal is not documented.","column":"29","line":"262"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getField"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"182"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getList"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"178"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"174"}}]}]},{type:"method",attributes:{"name":"getSelectedIndex"},children:[{type:"desc",attributes:{"text":"<p>Getter for {@link #setSelectedIndex}.</p>"}}]},{type:"method",attributes:{"name":"getSelectedRow"},children:[{type:"desc",attributes:{"text":"<p>Gets the current selected row of the selection.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>null if nothing selected or an array</p>"}}]}]},{type:"method",attributes:{"name":"getSelection"},children:[{type:"desc",attributes:{"text":"<p>Getter for {@link #setSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"isSearchInProgress"},children:[{type:"desc",attributes:{"text":"<p>Does this combo have the searched dialog open?</p>"}}]},{type:"method",attributes:{"name":"openSearchDialog"},children:[{type:"desc",attributes:{"text":"<p>Opens a popup search dialog, useful when the combo has a lot of items. This dialog is triggered by double clicking the combo, pressing F3 or Ctrl+F.</p>"}}]},{type:"method",attributes:{"name":"setColumnHeaders"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columns"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"String","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the header for each column.</p>"}}]},{type:"method",attributes:{"name":"setSelectedIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>-1 means no selected index</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the index of the currently selected item in the list.</p>"}}]},{type:"method",attributes:{"name":"setSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"data"},children:[{type:"desc",attributes:{"text":"<p>Array of values.  Its value is an array, with the following info:<ul>. <li>Column 0 represents the ID, i.e. the value that is stored internally and used by the app.</li> <li>Column 1 represents the description, the text that the end user normally sees.</li> <li>Columns > 1 will also be shown in the popup list, it you have set the appropiate column headers with {@link #setColumnHeaders}.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the list of selectable items.</p>"}}]},{type:"method",attributes:{"name":"sizeTextFieldToContent"},children:[{type:"desc",attributes:{"text":"<p>Sizes the width of the text field component to the needed value to show any selection item.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_calculateDimensions"},children:[{type:"desc",attributes:{"text":"<p>Calculates the needed dimensions for the text field and list components</p>"}}]},{type:"method",attributes:{"name":"_closePopup"},children:[{type:"desc",attributes:{"text":"<p>Hide the popup list.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_createList"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columns"}}]},{type:"desc",attributes:{"text":"<p>Creates the list component.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter columns is not documented.","column":"24","line":"202"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getComboSetting"},children:[{type:"params",children:[{type:"param",attributes:{"name":"key"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"190"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getTextWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"text"}}]},{type:"desc",attributes:{"text":"<p>Calculates the width of the given text. The default font is used.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"integer"}}]}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter text is not documented.","column":"26","line":"541"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onChangeSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"749"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"784"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"841"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"904"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"798"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"814"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousewheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"828"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onpopupappear"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"777"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_openPopup"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"414"}}]}]},{type:"method",attributes:{"name":"_search"},children:[{type:"params",children:[{type:"param",attributes:{"name":"startIndex"},children:[{type:"desc",attributes:{"text":"<p>Start index, 0 based</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"txt"},children:[{type:"desc",attributes:{"text":"<p>Text to find</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"caseSens"},children:[{type:"desc",attributes:{"text":"<p>Case sensivity flag.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Searches the given text.  Called from the search dialog.</p>"}}]},{type:"method",attributes:{"name":"_testClosePopup"},children:[{type:"desc",attributes:{"text":"<p>Hide the popup list only when needed.</p>"}}]},{type:"method",attributes:{"name":"_togglePopup"},children:[{type:"desc",attributes:{"text":"<p>Toggle the visibility of the popup list.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_visualizeBlur","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_visualizeFocus","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.InputCheckSymbol","name":"InputCheckSymbol","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isChecked","hasError":"true","type":"boolean","name":"checked"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"54"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"name"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"51"}}]}]},{type:"property",attributes:{"hasError":"true","name":"type"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"53"}}]}]},{type:"property",attributes:{"hasError":"true","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"52"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyApply"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"56"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"getPreferredBoxHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"64"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPreferredBoxWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"60"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.List","name":"List","hasWarning":"true","superClass":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"enableInlineFind"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"64"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"markLeadingItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"65"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"findString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vStartIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"278"}}]}]},{type:"method",attributes:{"hasError":"true","name":"findStringExact"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vStartIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"282"}}]}]},{type:"method",attributes:{"hasError":"true","name":"findValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vStartIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"286"}}]}]},{type:"method",attributes:{"hasError":"true","name":"findValueExact"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vStartIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"290"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getListItemTarget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"83"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"79"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSelectedItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"92"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSelectedItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"96"}}]}]},{type:"method",attributes:{"hasError":"true","name":"sortItemsByString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vReverse"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"309"}}]}]},{type:"method",attributes:{"hasError":"true","name":"sortItemsByValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vReverse"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"328"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_findItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vUserValue"}},{type:"param",attributes:{"name":"vStartIndex"}},{type:"param",attributes:{"name":"vType"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"245"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"135"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondblclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"144"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"162"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyinput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"186"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"177"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"117"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"108"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"126"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_sortItemsCompare"},children:[{type:"params",children:[{type:"param",attributes:{"name":"a"}},{type:"param",attributes:{"name":"b"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"305"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.ListItem","name":"ListItem","hasWarning":"true","superClass":"qx.ui.basic.Atom"},children:[{type:"events",children:[{type:"event",attributes:{"name":"action"},children:[{type:"desc",attributes:{"text":"<p>(Fired by {@link qx.ui.form.List})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vText is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIcon is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vValue is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"45"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"handleStateChange"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"57"}}]}]},{type:"method",attributes:{"hasError":"true","name":"matchesString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"83"}}]}]},{type:"method",attributes:{"hasError":"true","name":"matchesStringExact"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"87"}}]}]},{type:"method",attributes:{"hasError":"true","name":"matchesValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"91"}}]}]},{type:"method",attributes:{"hasError":"true","name":"matchesValueExact"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"95"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyStateStyleFocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStates"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"72"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondblclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"109"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.PasswordField","name":"PasswordField","hasWarning":"true","superClass":"qx.ui.form.TextField"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.RadioButton","name":"RadioButton","hasWarning":"true","superClass":"qx.ui.form.CheckBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vValue"}},{type:"param",attributes:{"name":"vName"}},{type:"param",attributes:{"name":"vChecked"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"true","type":"Object","name":"manager","instance":"qx.manager.selection.RadioManager"},children:[{type:"desc",attributes:{"text":"<p>The assigned qx.manager.selection.RadioManager which handles the switching between registered buttons</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyChecked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"66"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"93"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"106"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.form.CheckBox","overriddenFrom":"qx.ui.form.CheckBox","name":"_onclick","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.form.CheckBox","overriddenFrom":"qx.ui.form.CheckBox","name":"_onkeydown","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"134"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.form.CheckBox","overriddenFrom":"qx.ui.form.CheckBox","name":"_onkeyup","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.form.CheckBox","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.RepeatButton","name":"RepeatButton","hasWarning":"true","superClass":"qx.ui.form.Button"},children:[{type:"events",children:[{type:"event",attributes:{"name":"execute"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vText is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIcon is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIconWidth is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIconHeight is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vFlash is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"500","type":"number","name":"firstInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"46"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"100","type":"number","name":"interval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"45"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"92"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.form.Button","overriddenFrom":"qx.ui.form.Button","name":"_onmousedown","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.form.Button","overriddenFrom":"qx.ui.form.Button","name":"_onmouseup","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.form.Button","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.Spinner","name":"Spinner","hasWarning":"true","superClass":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"events",children:[{type:"event",attributes:{"name":"change"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vMin"}},{type:"param",attributes:{"name":"vValue"}},{type:"param",attributes:{"name":"vMax"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vMin is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vValue is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vMax is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"1.01","type":"number","name":"amountGrowth"},children:[{type:"desc",attributes:{"text":"<p>If minTimer was reached, how much the amount of each interval should growth (in relation to the previous interval).</p>"}}]},{type:"property",attributes:{"defaultValue":"500","type":"number","name":"firstInterval"},children:[{type:"desc",attributes:{"text":"<p>The first interval on event based shrink/growth of the value.</p>"}}]},{type:"property",attributes:{"defaultValue":"1","type":"number","name":"incrementAmount"},children:[{type:"desc",attributes:{"text":"<p>The amount to increment on each event (keypress or mousedown).</p>"}}]},{type:"property",attributes:{"defaultValue":"100","type":"number","name":"interval"},children:[{type:"desc",attributes:{"text":"<p>The current value of the interval (this should be used internally only).</p>"}}]},{type:"property",attributes:{"defaultValue":"20","type":"number","name":"minTimer"},children:[{type:"desc",attributes:{"text":"<p>This configures the minimum value for the timer interval.</p>"}}]},{type:"property",attributes:{"defaultValue":"10","type":"number","name":"pageIncrementAmount"},children:[{type:"desc",attributes:{"text":"<p>The amount to increment on each pageup / pagedown keypress</p>"}}]},{type:"property",attributes:{"defaultValue":"2","type":"number","name":"timerDecrease"},children:[{type:"desc",attributes:{"text":"<p>Decrease of the timer on each interval (for the next interval) until minTimer reached.</p>"}}]},{type:"property",attributes:{"defaultValue":"1","type":"number","name":"wheelIncrementAmount"},children:[{type:"desc",attributes:{"text":"<p>The amount to increment on each event (keypress or mousedown).</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_checkValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"acceptEmpty"}},{type:"param",attributes:{"name":"acceptEdit"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"511"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_computePreferredInnerHeight","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_computePreferredInnerWidth","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_increment"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"604"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onblur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"407"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onchange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"374"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninput"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"370"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_oninterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"467"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"249"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"200"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeyup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"286"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"314"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"339"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousewheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"355"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_pageIncrement"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"608"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_resetIncrements"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"612"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getMax"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"439"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getMin"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"447"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"426"}}]}]},{type:"method",attributes:{"hasError":"true","name":"resetValue"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"431"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setMax"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vMax"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"435"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setMin"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vMin"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"443"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"nValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"422"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.form","fullName":"qx.ui.form.TextArea","name":"TextArea","hasWarning":"true","superClass":"qx.ui.form.TextField"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"boolean","name":"wrap"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"36"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.form.TextField","overriddenFrom":"qx.ui.form.TextField","name":"_computePreferredInnerHeight","hasWarning":"true"}}]}]},{type:"class",attributes:{"name":"TextField","hasWarning":"true","packageName":"qx.ui.form","superClass":"qx.ui.basic.Terminator","childClasses":"qx.ui.form.PasswordField,qx.ui.form.TextArea","fullName":"qx.ui.form.TextField"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"28"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.renderer.font.Font","type":"Object","name":"font"},children:[{type:"desc",attributes:{"text":"<p>The font property describes how to paint the font on the widget.</p>"}}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"maxLength"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"72"}}]}]},{type:"property",attributes:{"hasError":"true","type":"boolean","name":"readOnly"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"73"}}]}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"selectionLength"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"76"}}]}]},{type:"property",attributes:{"hasError":"true","type":"number","name":"selectionStart"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"75"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"selectionText"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"77"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Function","name":"validator"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"79"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"\"\"","type":"string","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"71"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"201"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computePreferredInnerWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"197"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onblur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onfocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"259"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ontabfocus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"255"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Widget","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getComputedValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"151"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isComputedValid"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"180"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isValid"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"174"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"createRegExpValidator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRegExp"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"46","line":"167"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.groupbox","name":"groupbox","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.groupbox","fullName":"qx.ui.groupbox.CheckGroupBox","name":"CheckGroupBox","hasWarning":"true","superClass":"qx.ui.groupbox.GroupBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLegend"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.groupbox.GroupBox","overriddenFrom":"qx.ui.groupbox.GroupBox","name":"_createLegendObject","hasWarning":"true"}}]}]},{type:"class",attributes:{"name":"GroupBox","hasWarning":"true","packageName":"qx.ui.groupbox","superClass":"qx.ui.layout.CanvasLayout","childClasses":"qx.ui.groupbox.CheckGroupBox,qx.ui.groupbox.RadioGroupBox","fullName":"qx.ui.groupbox.GroupBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLegend"}},{type:"param",attributes:{"name":"vIcon"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createFrameObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"73"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createLegendObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"65"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getFrameObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"91"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIcon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"122"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLegend"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"114"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLegendObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"95"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setIcon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIcon"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"118"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setLegend"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLegend"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"110"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.groupbox","fullName":"qx.ui.groupbox.RadioGroupBox","name":"RadioGroupBox","hasWarning":"true","superClass":"qx.ui.groupbox.GroupBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLegend"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.groupbox.GroupBox","overriddenFrom":"qx.ui.groupbox.GroupBox","name":"_createLegendObject","hasWarning":"true"}}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.layout","name":"layout","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"BoxLayout","hasWarning":"true","packageName":"qx.ui.layout","superClass":"qx.ui.core.Parent","childClasses":"qx.ui.basic.Atom,qx.ui.component.DateChooser,qx.ui.core.ScrollBar,qx.ui.layout.HorizontalBoxLayout,qx.ui.layout.VerticalBoxLayout,qx.ui.pageview.AbstractBar,qx.ui.pageview.AbstractPageView,qx.ui.tree.AbstractTreeElement,qx.ui.treefullcontrol.AbstractTreeElement","fullName":"qx.ui.layout.BoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vOrientation"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"STR_REVERSED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"37"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"possibleValues":"\"left\", \"center\", \"right\"","defaultValue":"\"left\"","type":"string","name":"horizontalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The horizontal align of the children. Allowed values are: &#8220;left&#8221;, &#8220;center&#8221; and &#8220;right&#8221;</p>"}}]},{type:"property",attributes:{"possibleValues":"\"horizontal\", \"vertical\"","type":"string","name":"orientation"},children:[{type:"desc",attributes:{"text":"<p>The orientation of the layout control. Allowed values are &#8220;horizontal&#8221; (default) and &#8220;vertical&#8221;.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"reverseChildrenOrder"},children:[{type:"desc",attributes:{"text":"<p>Should the children be layouted in reverse order?</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>The spacing between childrens. Could be any positive integer value.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"stretchChildrenOrthogonalAxis"},children:[{type:"desc",attributes:{"text":"<p>Should the widgets be stretched to the available width (orientationvertical) or height (orientationhorizontal)? This only applies if the child has not configured a own value for this axis.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"useAdvancedFlexAllocation"},children:[{type:"desc",attributes:{"text":"<p>If there are min/max values in combination with flex try to optimize placement. This is more complex and produces more time for the layouter but sometimes this feature is needed.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"top\", \"middle\", \"bottom\"","defaultValue":"\"top\"","type":"string","name":"verticalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The vertical align of the children. Allowed values are: &#8220;top&#8221;, &#8220;middle&#8221; and &#8220;bottom&#8221;</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_computeAccumulatedChildrenOuterHeight"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"51","line":"228"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeAccumulatedChildrenOuterWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"50","line":"217"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateLayoutMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"142"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"187"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyLayoutOrder"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"178"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputeChildrenStretchingX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"251"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_recomputeChildrenStretchingY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"263"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateLayoutMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"133"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"getLayoutMode"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"124"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isHorizontal"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"116"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isVertical"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"120"}}]}]}]}]},{type:"class",attributes:{"name":"CanvasLayout","hasWarning":"true","packageName":"qx.ui.layout","superClass":"qx.ui.core.Parent","childClasses":"qx.ui.basic.Inline,qx.ui.core.ClientDocument,qx.ui.groupbox.GroupBox,qx.ui.menu.Separator,qx.ui.pageview.AbstractPage,qx.ui.pageview.AbstractPane,qx.ui.popup.Popup,qx.ui.resizer.Resizer,qx.ui.splitpane.SplitPane,qx.ui.toolbar.PartHandle,qx.ui.toolbar.Separator","fullName":"qx.ui.layout.CanvasLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.layout","fullName":"qx.ui.layout.DockLayout","name":"DockLayout","hasWarning":"true","superClass":"qx.ui.core.Parent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"possibleValues":"\"vertical\", \"horizontal\", \"ordered\"","defaultValue":"\"vertical\"","type":"string","name":"mode"},children:[{type:"desc",attributes:{"text":"<p>The layout mode (in which order the children should be layouted)</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_addAlignedHorizontal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAlign"}},{type:"param",attributes:{"name":"vArgs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"109"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_addAlignedVertical"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vAlign"}},{type:"param",attributes:{"name":"vArgs"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"100"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addBottom"},children:[{type:"desc",attributes:{"text":"<p>Add multiple childrens and make them bottom aligned</p>"}}]},{type:"method",attributes:{"name":"addLeft"},children:[{type:"desc",attributes:{"text":"<p>Add multiple childrens and make them left aligned</p>"}}]},{type:"method",attributes:{"name":"addRight"},children:[{type:"desc",attributes:{"text":"<p>Add multiple childrens and make them right aligned</p>"}}]},{type:"method",attributes:{"name":"addTop"},children:[{type:"desc",attributes:{"text":"<p>Add multiple childrens and make them top aligned</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.layout","fullName":"qx.ui.layout.FlowLayout","name":"FlowLayout","hasWarning":"true","superClass":"qx.ui.core.Parent"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"possibleValues":"\"left\", \"right\"","defaultValue":"\"left\"","type":"string","name":"horizontalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The horizontal align of the children. Allowed values are: &#8220;left&#8221; and &#8220;right&#8221;</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"horizontalSpacing"},children:[{type:"desc",attributes:{"text":"<p>The spacing between childrens. Could be any positive integer value.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"reverseChildrenOrder"},children:[{type:"desc",attributes:{"text":"<p>Should the children be layouted in reverse order?</p>"}}]},{type:"property",attributes:{"possibleValues":"\"top\", \"bottom\"","defaultValue":"\"top\"","type":"string","name":"verticalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The vertical align of the children. Allowed values are: &#8220;top&#8221; and &#8220;bottom&#8221;</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"verticalSpacing"},children:[{type:"desc",attributes:{"text":"<p>The spacing between childrens. Could be any positive integer value.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_changeInnerWidth","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_modifyLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"100"}}]}]}]}]},{type:"class",attributes:{"name":"GridLayout","hasWarning":"true","packageName":"qx.ui.layout","superClass":"qx.ui.core.Parent","childClasses":"qx.ui.listview.ListViewPane","fullName":"qx.ui.layout.GridLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"number","name":"cellPaddingBottom"},children:[{type:"desc",attributes:{"text":"<p>Cell padding bottom of all cells, if not locally defined</p>"}}]},{type:"property",attributes:{"type":"number","name":"cellPaddingLeft"},children:[{type:"desc",attributes:{"text":"<p>Cell padding left of all cells, if not locally defined</p>"}}]},{type:"property",attributes:{"type":"number","name":"cellPaddingRight"},children:[{type:"desc",attributes:{"text":"<p>Cell padding right of all cells, if not locally defined</p>"}}]},{type:"property",attributes:{"type":"number","name":"cellPaddingTop"},children:[{type:"desc",attributes:{"text":"<p>Cell padding top of all cells, if not locally defined</p>"}}]},{type:"property",attributes:{"possibleValues":"\"left\", \"center\", \"right\"","defaultValue":"\"left\"","type":"string","name":"horizontalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The horizontal align of the children. Allowed values are: &#8220;left&#8221;, &#8220;center&#8221; and &#8220;right&#8221;</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"horizontalSpacing"},children:[{type:"desc",attributes:{"text":"<p>The spacing between childrens. Could be any positive integer value.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"top\", \"middle\", \"bottom\"","defaultValue":"\"top\"","type":"string","name":"verticalChildrenAlign"},children:[{type:"desc",attributes:{"text":"<p>The vertical align of the children. Allowed values are: &#8220;top&#8221;, &#8220;middle&#8221; and &#8220;bottom&#8221;</p>"}}]},{type:"property",attributes:{"defaultValue":"0","type":"number","name":"verticalSpacing"},children:[{type:"desc",attributes:{"text":"<p>The spacing between childrens. Could be any positive integer value.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_changeInnerHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_changeInnerWidth","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_collidesWithSpans"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStartCol"}},{type:"param",attributes:{"name":"vStartRow"}},{type:"param",attributes:{"name":"vEndCol"}},{type:"param",attributes:{"name":"vEndRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"825"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_getColumnProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColumnIndex"}},{type:"param",attributes:{"name":"vProperty"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"276"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_getRowProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRowIndex"}},{type:"param",attributes:{"name":"vProperty"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"323"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateColumnLayout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"301"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateRowLayout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"348"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"139"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_removeColumnProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColumnIndex"}},{type:"param",attributes:{"name":"vProperty"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"295"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_removeRowProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRowIndex"}},{type:"param",attributes:{"name":"vProperty"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"342"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setupColumnProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColumnIndex"}},{type:"param",attributes:{"name":"vProperty"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"289"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_setupRowProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRowIndex"}},{type:"param",attributes:{"name":"vProperty"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"336"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncColumnDataFields"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncDataFields"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vData"}},{type:"param",attributes:{"name":"vOldLength"}},{type:"param",attributes:{"name":"vNewLength"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"157"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncRowDataFields"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"255"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}},{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addColumn"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"194"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addRow"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"240"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getColumnBoxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"443"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnCount"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"190"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnHorizontalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"582"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnInnerWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"539"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"655"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"659"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"651"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"647"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getColumnVerticalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"586"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getComputedCellPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"532"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getComputedCellPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"520"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getComputedCellPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"524"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getComputedCellPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"528"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"getInnerHeightForChild","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"getInnerWidthForChild","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vChild"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowBoxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"480"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowCount"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"236"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowHorizontalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"590"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowInnerHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"543"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"671"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"675"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"667"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"663"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRowVerticalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"594"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSpanEntry"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"769"}}]}]},{type:"method",attributes:{"hasError":"true","name":"hasSpans"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"765"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isFillCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"811"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isSpanCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"797"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isSpanStart"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCol"}},{type:"param",attributes:{"name":"vRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"783"}}]}]},{type:"method",attributes:{"hasError":"true","name":"mergeCells"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vStartCol"}},{type:"param",attributes:{"name":"vStartRow"}},{type:"param",attributes:{"name":"vColLength"}},{type:"param",attributes:{"name":"vRowLength"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"741"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeColumn"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"200"}}]}]},{type:"method",attributes:{"hasError":"true","name":"removeRow"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"246"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnCount"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCount"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"184"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnHorizontalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"41","line":"562"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"619"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"623"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"615"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"611"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnVerticalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"566"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setColumnWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"372"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowCount"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCount"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"230"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"406"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowHorizontalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"570"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowPaddingBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"635"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowPaddingLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"639"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowPaddingRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"631"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowPaddingTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"627"}}]}]},{type:"method",attributes:{"hasError":"true","name":"setRowVerticalAlignment"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vIndex"}},{type:"param",attributes:{"name":"vValue"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"574"}}]}]}]}]},{type:"class",attributes:{"name":"HorizontalBoxLayout","hasWarning":"true","packageName":"qx.ui.layout","superClass":"qx.ui.layout.BoxLayout","childClasses":"api.Viewer,qx.ui.form.ComboBox,qx.ui.form.ComboBoxEx,qx.ui.form.Spinner,qx.ui.listview.Header,qx.ui.menu.Button,qx.ui.table.TablePaneHeader,qx.ui.toolbar.Part,qx.ui.toolbar.ToolBar","fullName":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]}]},{type:"class",attributes:{"name":"VerticalBoxLayout","hasWarning":"true","packageName":"qx.ui.layout","superClass":"qx.ui.layout.BoxLayout","childClasses":"qx.ui.component.ColorSelector,qx.ui.form.List,qx.ui.listview.ListView,qx.ui.menu.Layout,qx.ui.table.Table,qx.ui.table.TablePaneScroller","fullName":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.listview","name":"listview","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ContentCellHtml","name":"ContentCellHtml","hasWarning":"true","superClass":"qx.ui.embed.HtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ContentCellIconHtml","name":"ContentCellIconHtml","hasWarning":"true","superClass":"qx.ui.embed.IconHtmlEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ContentCellImage","name":"ContentCellImage","hasWarning":"true","superClass":"qx.ui.basic.Image"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}},{type:"param",attributes:{"name":"vWidth"}},{type:"param",attributes:{"name":"vHeight"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"setSource"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vSource"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"44"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ContentCellLink","name":"ContentCellLink","hasWarning":"true","superClass":"qx.ui.embed.LinkEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vHtml"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ContentCellText","name":"ContentCellText","hasWarning":"true","superClass":"qx.ui.embed.TextEmbed"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.Header","name":"Header","hasWarning":"true","superClass":"qx.ui.layout.HorizontalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vColumns"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_cleanupResizing"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"253"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousemove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"121"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"246"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"226"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncColumnWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vWidth"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"85"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncResizeLine"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"93"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.HeaderCell","name":"HeaderCell","hasWarning":"true","superClass":"qx.ui.basic.Atom"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vConfig"}},{type:"param",attributes:{"name":"vId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"true","hasError":"true","type":"string","name":"sortOrder","possibleValues":"\"ascending\", \"descending\""},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"85"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"C_SORT_ASCENDING"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"87"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"C_SORT_DESCENDING"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"88"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.basic.Atom","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getNextSortOrder"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"102"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getView"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"98"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateSort"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"116"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onmouseout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"198"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"194"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"202"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.HeaderSeparator","name":"HeaderSeparator","hasWarning":"true","superClass":"qx.ui.basic.Terminator"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ListView","name":"ListView","hasWarning":"true","superClass":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vData"}},{type:"param",attributes:{"name":"vColumns"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"liveResize"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"135"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"resizable"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"134"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"sortBy"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"136"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getColumns"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"151"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getData"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"147"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getFrame"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"159"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getHeader"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"155"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPane"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"163"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getResizeLine"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"175"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScroll"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"167"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getScrollContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","name":"update"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"179"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateContent"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"210"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateLayout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"214"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateScrollBar"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"187"}}]}]},{type:"method",attributes:{"hasError":"true","name":"updateSort"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"218"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_getHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vCellId"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"233"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_handleDisplayableCustom","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vDisplayable"}},{type:"param",attributes:{"name":"vParent"}},{type:"param",attributes:{"name":"vHint"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"288"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onscroll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"284"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.listview","fullName":"qx.ui.listview.ListViewPane","name":"ListViewPane","hasWarning":"true","superClass":"qx.ui.layout.GridLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vData"}},{type:"param",attributes:{"name":"vColumns"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.layout.GridLayout","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getData"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"288"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"293"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"302"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"306"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getItemWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"298"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getListViewTarget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"270"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"266"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getRelativeItemPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"483"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"getScrollLeft","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"getScrollTop","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"getSelectedItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"280"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getSelectedItems"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"284"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getView"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"83"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isItemVisible"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"474"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoView"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vAlignLeftTop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"411"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vAlignLeft"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"417"}}]}]},{type:"method",attributes:{"hasError":"true","name":"scrollItemIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vAlignTop"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"421"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"setScrollLeft","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"setScrollTop","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vScrollTop"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.layout.GridLayout","name":"_changeInnerHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vNew"}},{type:"param",attributes:{"name":"vOld"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"349"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ondblclick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"357"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"376"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"333"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"325"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"341"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousewheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"319"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onscroll"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"231"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateAnchorState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsAnchor"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"31","line":"399"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"491"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vUpdate"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"100"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateLeadState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsLead"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"405"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateRendering"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vForce"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"179"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateRow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vRelativeRow"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"199"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_updateSelectionState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vItem"}},{type:"param",attributes:{"name":"vIsSelected"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"393"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.menu","name":"menu","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Button","hasWarning":"true","packageName":"qx.ui.menu","superClass":"qx.ui.layout.HorizontalBoxLayout","childClasses":"qx.ui.menu.CheckBox","fullName":"qx.ui.menu.Button"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vCommand"}},{type:"param",attributes:{"name":"vMenu"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","type":"string","name":"icon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"89"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"label"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"90"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"menu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"91"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getArrowObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"137"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getIconObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"125"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getLabelObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"129"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getParentMenu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"141"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getShortcutObject"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"133"}}]}]},{type:"method",attributes:{"hasError":"true","name":"hasIcon"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"109"}}]}]},{type:"method",attributes:{"hasError":"true","name":"hasLabel"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"113"}}]}]},{type:"method",attributes:{"hasError":"true","name":"hasMenu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"121"}}]}]},{type:"method",attributes:{"hasError":"true","name":"hasShortcut"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"117"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.layout.BoxLayout","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_modifyCommand"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"242"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_modifyEnabled","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"305"}}]}]}]}]},{type:"class",attributes:{"name":"CheckBox","hasWarning":"true","packageName":"qx.ui.menu","superClass":"qx.ui.menu.Button","childClasses":"qx.ui.menu.RadioButton","fullName":"qx.ui.menu.CheckBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vCommand"}},{type:"param",attributes:{"name":"vChecked"}}]},{type:"desc",attributes:{"text":"<p>A checkbox for the menu system.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vLabel is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vCommand is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vChecked is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"getAlias":"isChecked","hasError":"true","defaultValue":"false","type":"boolean","name":"checked"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"51"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"name"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"49"}}]}]},{type:"property",attributes:{"hasError":"true","type":"string","name":"value"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"50"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"execute","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.menu","fullName":"qx.ui.menu.Layout","name":"Layout","superClass":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A small helper class to create a special layout handler for qx.ui.menu.Menus</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.layout.BoxLayout","name":"_createLayoutImpl"},children:[{type:"desc",attributes:{"text":"<p>This creates an new instance of the layout impl this widget uses</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.menu","fullName":"qx.ui.menu.Menu","name":"Menu","hasWarning":"true","superClass":"qx.ui.popup.Popup"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"250","type":"number","name":"closeInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"93"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"8","type":"number","name":"contentArrowGap"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"82"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"8","type":"number","name":"contentNonArrowPadding"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"84"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"20","type":"number","name":"contentNonIconPadding"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"83"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"false","type":"boolean","name":"fastReopen"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"91"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"hoverItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"86"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"4","type":"number","name":"iconContentGap"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"80"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"indentShortcuts"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"98"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"10","type":"number","name":"labelShortcutGap"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"81"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"opener"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"88"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"250","type":"number","name":"openInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"92"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"openItem"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"87"}}]}]},{type:"property",attributes:{"hasError":"true","type":"Object","name":"parentMenu"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"89"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"-3","type":"number","name":"subMenuHorizontalOffset"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"95"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"-2","type":"number","name":"subMenuVerticalOffset"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"96"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.popup.Popup","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getLayout"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"22","line":"111"}}]}]},{type:"method",attributes:{"hasError":"true","name":"isSubButton"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vButton"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"115"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.popup.Popup","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.popup.Popup","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_computeArrowPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"423"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeIconPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"409"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeLabelPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"413"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxArrowWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"349"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxContentWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"367"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxIconWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"283"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxLabelWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"301"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxLabelWidthIncShortcut"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"45","line":"317"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMaxShortcutWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"333"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeMenuButtonNeededWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"499"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_computeShortcutPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"419"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateLabelPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"475"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateMaxIconWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"442"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateMaxLabelWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"450"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateMaxLabelWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"469"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateMaxShortcutWidth"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"460"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_invalidateShortcutPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"481"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onclosetimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"678"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"desc",attributes:{"text":"<p>Wraps key events to target functions</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter e is not documented.","column":"23","line":"690"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown_enter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"852"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"699"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress_down"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"736"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress_left"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"745"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress_right"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"774"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress_up"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"728"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"651"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"554"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onopentimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"666"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.menu","fullName":"qx.ui.menu.RadioButton","name":"RadioButton","hasWarning":"true","superClass":"qx.ui.menu.CheckBox"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vCommand"}},{type:"param",attributes:{"name":"vChecked"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"true","type":"Object","name":"manager","instance":"qx.manager.selection.RadioManager"},children:[{type:"desc",attributes:{"text":"<p>The assigned qx.manager.selection.RadioManager which handles the switching between registered buttons</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyChecked"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"58"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_modifyName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"93"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.menu.CheckBox","name":"execute","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.menu","fullName":"qx.ui.menu.Separator","name":"Separator","hasWarning":"true","superClass":"qx.ui.layout.CanvasLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"59"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.menubar","name":"menubar","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.menubar","fullName":"qx.ui.menubar.Button","name":"Button","hasWarning":"true","superClass":"qx.ui.toolbar.MenuButton"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vMenu"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.menubar","fullName":"qx.ui.menubar.MenuBar","name":"MenuBar","hasWarning":"true","superClass":"qx.ui.toolbar.ToolBar"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.pageview","name":"pageview","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"AbstractBar","hasWarning":"true","packageName":"qx.ui.pageview","superClass":"qx.ui.layout.BoxLayout","childClasses":"qx.ui.pageview.buttonview.Bar,qx.ui.pageview.tabview.Bar","fullName":"qx.ui.pageview.AbstractBar"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getManager"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"43"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getWheelDelta"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"99"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_onmousewheel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"59"}}]}]}]}]},{type:"class",attributes:{"name":"AbstractButton","hasWarning":"true","packageName":"qx.ui.pageview","superClass":"qx.ui.basic.Atom","childClasses":"qx.ui.pageview.buttonview.Button,qx.ui.pageview.tabview.Button","fullName":"qx.ui.pageview.AbstractButton"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"checked"},children:[{type:"desc",attributes:{"text":"<p>If this tab is the currently selected/active one</p>"}}]},{type:"property",attributes:{"allowNull":"true","type":"Object","name":"manager","instance":"qx.manager.selection.RadioManager"},children:[{type:"desc",attributes:{"text":"<p>The assigned qx.manager.selection.RadioManager which handles the switching between registered buttons</p>"}}]},{type:"property",attributes:{"type":"string","name":"name"},children:[{type:"desc",attributes:{"text":"<p>The name of the radio group. All the radio elements in a group (registered by the same manager) have the same name (and could have a different value).</p>"}}]},{type:"property",attributes:{"type":"Object","name":"page"},children:[{type:"desc",attributes:{"text":"<p>The attached page of this tab</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.basic.Atom","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getView"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"84"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_modifyParent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"propValue"}},{type:"param",attributes:{"name":"propOldValue"}},{type:"param",attributes:{"name":"propData"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"110"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"183"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"184"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"171"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"179"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"175"}}]}]}]}]},{type:"class",attributes:{"name":"AbstractPage","hasWarning":"true","packageName":"qx.ui.pageview","superClass":"qx.ui.layout.CanvasLayout","childClasses":"qx.ui.pageview.buttonview.Page,qx.ui.pageview.tabview.Page","fullName":"qx.ui.pageview.AbstractPage"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vButton"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"type":"Object","name":"button"},children:[{type:"desc",attributes:{"text":"<p>The attached tab of this page.</p>"}}]}]}]},{type:"class",attributes:{"name":"AbstractPageView","hasWarning":"true","packageName":"qx.ui.pageview","superClass":"qx.ui.layout.BoxLayout","childClasses":"qx.ui.pageview.buttonview.ButtonView,qx.ui.pageview.tabview.TabView","fullName":"qx.ui.pageview.AbstractPageView"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vBarClass"}},{type:"param",attributes:{"name":"vPaneClass"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getBar"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"50"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getPane"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"46"}}]}]}]}]},{type:"class",attributes:{"name":"AbstractPane","hasWarning":"true","packageName":"qx.ui.pageview","superClass":"qx.ui.layout.CanvasLayout","childClasses":"qx.ui.pageview.buttonview.Pane,qx.ui.pageview.tabview.Pane","fullName":"qx.ui.pageview.AbstractPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"25"}}]}]}]}]}]},{type:"packages",children:[{type:"package",attributes:{"packageName":"qx.ui.pageview","fullName":"qx.ui.pageview.buttonview","name":"buttonview","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.pageview.buttonview","fullName":"qx.ui.pageview.buttonview.Bar","name":"Bar","hasWarning":"true","superClass":"qx.ui.pageview.AbstractBar"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.pageview.AbstractBar","overriddenFrom":"qx.ui.pageview.AbstractBar","name":"getWheelDelta","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyStateAppearance","hasWarning":"true"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.buttonview","fullName":"qx.ui.pageview.buttonview.Button","name":"Button","hasWarning":"true","superClass":"qx.ui.pageview.AbstractButton"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyStateAppearance","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.pageview.AbstractButton","overriddenFrom":"qx.ui.pageview.AbstractButton","name":"_onkeypress","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.buttonview","fullName":"qx.ui.pageview.buttonview.ButtonView","name":"ButtonView","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPageView"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>One of the widgets which could be used to structurize the interface.</p>\n\n<p>qx.ui.pageview.buttonview.ButtonView creates the typical apple-like tabview-replacements which could also be found in more modern versions of the settings dialog in Mozilla Firefox.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"possibleValues":"\"top\", \"right\", \"bottom\", \"left\"","defaultValue":"\"top\"","hasError":"true","type":"string","name":"barPosition"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"49"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.buttonview","fullName":"qx.ui.pageview.buttonview.Page","name":"Page","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPage"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vButton"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.buttonview","fullName":"qx.ui.pageview.buttonview.Pane","name":"Pane","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyStateAppearance","hasWarning":"true"}}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui.pageview","fullName":"qx.ui.pageview.tabview","name":"tabview","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.pageview.tabview","fullName":"qx.ui.pageview.tabview.Bar","name":"Bar","hasWarning":"true","superClass":"qx.ui.pageview.AbstractBar"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.tabview","fullName":"qx.ui.pageview.tabview.Button","name":"Button","hasWarning":"true","superClass":"qx.ui.pageview.AbstractButton"},children:[{type:"events",children:[{type:"event",attributes:{"name":"closetab"},children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vText"}},{type:"param",attributes:{"name":"vIcon"}},{type:"param",attributes:{"name":"vIconWidth"}},{type:"param",attributes:{"name":"vIconHeight"}},{type:"param",attributes:{"name":"vFlash"}}]},{type:"desc",attributes:{"text":""}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter vText is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIcon is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIconWidth is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vIconHeight is not documented.","column":"1","line":"29"}},{type:"error",attributes:{"msg":"Parameter vFlash is not documented.","column":"1","line":"29"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"\"icon/16/cancel.png\"","type":"string","name":"closeButtonImage"},children:[{type:"desc",attributes:{"text":"<p>Close Tab Icon</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"showCloseButton"},children:[{type:"desc",attributes:{"text":"<p>default Close Tab Button</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_applyStateAppearance","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.pageview.AbstractButton","overriddenFrom":"qx.ui.pageview.AbstractButton","name":"_onkeydown","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.pageview.AbstractButton","overriddenFrom":"qx.ui.pageview.AbstractButton","name":"_onkeypress","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_ontabclose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"114"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.pageview.AbstractButton","name":"dispose"}}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.tabview","fullName":"qx.ui.pageview.tabview.Page","name":"Page","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPage"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vButton"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.tabview","fullName":"qx.ui.pageview.tabview.Pane","name":"Pane","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.pageview.tabview","fullName":"qx.ui.pageview.tabview.TabView","name":"TabView","hasWarning":"true","superClass":"qx.ui.pageview.AbstractPageView"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"alignTabsToLeft"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"42"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"placeBarOnTop"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"43"}}]}]}]}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.popup","name":"popup","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"Popup","hasWarning":"true","packageName":"qx.ui.popup","superClass":"qx.ui.layout.CanvasLayout","childClasses":"qx.ui.component.ColorPopup,qx.ui.menu.Menu,qx.ui.popup.PopupAtom,qx.ui.window.Window","fullName":"qx.ui.popup.Popup"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"autoHide"},children:[{type:"desc",attributes:{"text":"<p>Whether to let the system decide when to hide the popup. Setting this to false gives you better control but it also requires you to handle the closing of the popup.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"centered"},children:[{type:"desc",attributes:{"text":"<p>Center the popup on open</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"restrictToPageOnOpen"},children:[{type:"desc",attributes:{"text":"<p>Whether the popup should be restricted to the visible area of the page when opened.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Parent","name":"_afterAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Parent","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Parent","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_makeActive"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"188"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_makeInactive"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"192"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_sendTo"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"240"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"bringToFront"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"228"}}]}]},{type:"method",attributes:{"hasError":"true","name":"centerToBrowser"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"300"}}]}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getHideTimeStamp"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"269"}}]}]},{type:"method",attributes:{"hasError":"true","name":"getShowTimeStamp"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"265"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"isFocusable","hasWarning":"true"}},{type:"method",attributes:{"name":"positionRelativeTo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"el"},children:[{type:"desc",attributes:{"text":"<p>Reference <span class=\"caps\">DOM</span> element/widget.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"offsetX"},children:[{type:"desc",attributes:{"text":"<p>Offset in pixels in X direction (optional).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"offsetY"},children:[{type:"desc",attributes:{"text":"<p>Offset in pixels in Y direction (optional).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Positions the popup relative to some reference element.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"sendToBack"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"234"}}]}]}]}]},{type:"class",attributes:{"name":"PopupAtom","hasWarning":"true","packageName":"qx.ui.popup","superClass":"qx.ui.popup.Popup","childClasses":"qx.ui.popup.ToolTip","fullName":"qx.ui.popup.PopupAtom"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vIcon"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"26"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.popup.Popup","name":"dispose"}},{type:"method",attributes:{"hasError":"true","name":"getAtom"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"34"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.popup","fullName":"qx.ui.popup.ToolTip","name":"ToolTip","hasWarning":"true","superClass":"qx.ui.popup.PopupAtom"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"}},{type:"param",attributes:{"name":"vIcon"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"1","line":"27"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.ui.core.Widget","hasError":"true","type":"Object","name":"boundToWidget"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"76"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"4000","type":"number","name":"hideInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"74"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"true","type":"boolean","name":"hideOnHover"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"68"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"1","type":"number","name":"mousePointerOffsetX"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"70"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"20","type":"number","name":"mousePointerOffsetY"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"71"}}]}]},{type:"property",attributes:{"hasError":"true","defaultValue":"1000","type":"number","name":"showInterval"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"73"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.popup.Popup","name":"_beforeAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.popup.Popup","name":"_beforeDisappear","hasWarning":"true"}},{type:"method",attributes:{"hasError":"true","name":"_onhidetimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"215"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseover"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"193"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onshowtimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"200"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_startHideTimer"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"160"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_startShowTimer"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"153"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_stopHideTimer"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"174"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_stopShowTimer"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"167"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.popup.PopupAtom","name":"dispose"}}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.resizer","name":"resizer","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.resizer","fullName":"qx.ui.resizer.Resizer","name":"Resizer","hasWarning":"true","superClass":"qx.ui.layout.CanvasLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"hasError":"true","isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"}}]},{type:"desc",attributes:{"text":"<p>This class acts as a wrapper for other child, and allows it to be resized (not moved), normally in the right and/or bottom directions.  Child can be e.g. a qx.ui.form.TextArea, qx.ui.table.Table or qx.ui.form.List.  It is an alternative to splitters.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter child is not documented.","column":"1","line":"32"}}]}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"resizeableEast"},children:[{type:"desc",attributes:{"text":"<p>If the window is resizeable in the right direction.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"resizeableNorth"},children:[{type:"desc",attributes:{"text":"<p>If the window is resizeable in the top direction.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"resizeableSouth"},children:[{type:"desc",attributes:{"text":"<p>If the window is resizeable in the bottom direction.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"resizeableWest"},children:[{type:"desc",attributes:{"text":"<p>If the window is resizeable in the left direction.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"opaque\", \"lazyopaque\", \"frame\", \"translucent\"","defaultValue":"\"frame\"","type":"string","name":"resizeMethod"},children:[{type:"desc",attributes:{"text":"<p>The resize method to use</p>"}}]},{type:"property",attributes:{"possibleValues":"\"opaque\", \"lazyopaque\", \"frame\", \"translucent\"","defaultValue":"\"frame\"","type":"string","name":"resizeMethod"},children:[{type:"desc",attributes:{"text":"<p>The resize method to use</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_near"},children:[{type:"params",children:[{type:"param",attributes:{"name":"p"}},{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"277"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousedown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"112"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmousemove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"281"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_onmouseup"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"209"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_registerResizeEvents"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"106"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.splitpane","name":"splitpane","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"packageName":"qx.ui.splitpane","fullName":"qx.ui.splitpane.HorizontalSplitPane","name":"HorizontalSplitPane","superClass":"qx.ui.splitpane.SplitPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"firstSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the left pane. Allowed values are any by {@see qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"secondSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the right pane. Allowed values are any by {@see qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new instance of a horizontal SplitPane.<br />\n</p>\n\n<p>new qx.ui.splitpane.HorizontalSplitPane()<br />\n new qx.ui.splitpane.HorizontalSplitPane(firstSize, secondSize)</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.splitpane.SplitPane","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Garbage collection</p>"}}]}]}]},{type:"class",attributes:{"name":"SplitPane","hasWarning":"true","packageName":"qx.ui.splitpane","superClass":"qx.ui.layout.CanvasLayout","childClasses":"qx.ui.splitpane.HorizontalSplitPane,qx.ui.splitpane.VerticalSplitPane","fullName":"qx.ui.splitpane.SplitPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"orientation"},children:[{type:"desc",attributes:{"text":"<p>The orientation of the splitpane control. Allowed values are &#8220;horizontal&#8221; (default) and &#8220;vertical&#8221;. This is the same type as used in {@link qx.ui.layout.BoxLayout#orientation}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"firstSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the left (top) pane. Allowed values are any by {@link qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"secondSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the right (bottom) pane. Allowed values are any by {@link qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new instance of a SplitPane. It allows the user to dynamically resize the areas dropping the border between.</p>\n\n<p>new qx.ui.splitpane.SplitPane(orientation) new qx.ui.splitpane.SplitPane(orientation, firstSize, secondSize)</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"firstSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the first (left/top) area.</p>"}}]},{type:"property",attributes:{"getAlias":"isLiveResize","allowNull":"false","defaultValue":"false","type":"boolean","name":"liveResize"},children:[{type:"desc",attributes:{"text":"<p>The layout method for the splitpane. If true, the content will updated immediatly.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"horizontal\", \"vertical\"","type":"string","name":"orientation"},children:[{type:"desc",attributes:{"text":"<p>The orientation of the splitpane control. Allowed values are &#8220;horizontal&#8221; (default) and &#8220;vertical&#8221;.</p>"}}]},{type:"property",attributes:{"name":"secondSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the second (right/bottom) area.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"false","type":"boolean","name":"showKnob"},children:[{type:"desc",attributes:{"text":"<p>Show the knob</p>"}}]},{type:"property",attributes:{"defaultValue":"4","name":"splitterSize"},children:[{type:"desc",attributes:{"text":"<p>Size of the splitter</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"hasError":"true","name":"addBottom"},children:[{type:"desc",attributes:{"text":"<p>adds one or more widget(s) to the bottom pane</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>widget</code>.","column":"22","line":"213"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addLeft"},children:[{type:"desc",attributes:{"text":"<p>adds one or more widget(s) to the left pane</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>widget</code>.","column":"20","line":"183"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addRight"},children:[{type:"desc",attributes:{"text":"<p>adds one or more widget(s) to the right pane</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>widget</code>.","column":"21","line":"203"}}]}]},{type:"method",attributes:{"hasError":"true","name":"addTop"},children:[{type:"desc",attributes:{"text":"<p>adds one or more widget(s) to the top pane</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>widget</code>.","column":"19","line":"193"}}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Parent","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Garbage collection</p>"}}]},{type:"method",attributes:{"name":"getBottomArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the bottom area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]},{type:"method",attributes:{"name":"getFirstArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the first area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]},{type:"method",attributes:{"name":"getKnob"},children:[{type:"desc",attributes:{"text":"<p>Returns the knob.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The knob.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getLeftArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the left area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]},{type:"method",attributes:{"name":"getRightArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the right area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]},{type:"method",attributes:{"name":"getSecondArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the second area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]},{type:"method",attributes:{"name":"getSplitter"},children:[{type:"desc",attributes:{"text":"<p>Returns the splitter.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The splitter.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getTopArea"},children:[{type:"desc",attributes:{"text":"<p>Returns the top area (CanvasLayout)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":""}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.CanvasLayout"}}]}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_applyRuntimeLeftWrapper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"673"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_applyRuntimeTopWrapper"},children:[{type:"params",children:[{type:"param",attributes:{"name":"v"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"682"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_commonMouseDown"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"531"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_commonMouseUp"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"627"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_normalizeX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"665"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_normalizeY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"669"}}]}]},{type:"method",attributes:{"name":"_onSplitterMouseDownX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Initializes drag session in case of a mousedown event on splitter in a horizontal splitpane.</p>"}}]},{type:"method",attributes:{"name":"_onSplitterMouseDownY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Initializes drag session in case of a mousedown event on splitter in a vertical splitpane.</p>"}}]},{type:"method",attributes:{"name":"_onSplitterMouseMoveX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Move the splitter in case of a mousemove event on splitter in a horizontal splitpane.</p>"}}]},{type:"method",attributes:{"name":"_onSplitterMouseMoveY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Move the splitter in case of a mousemove event on splitter in a vertical splitpane.</p>"}}]},{type:"method",attributes:{"name":"_onSplitterMouseUpX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Ends the drag session and computes the new dimensions of panes in case of a mouseup event on splitter in a horizontal splitpane.</p>"}}]},{type:"method",attributes:{"name":"_onSplitterMouseUpY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The event itself.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Ends the drag session and computes the new dimensions of panes in case of a mouseup event on splitter in a vertical splitpane.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_syncCommon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"first"}},{type:"param",attributes:{"name":"second"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"659"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncFirstSize"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"428"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncSecondSize"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"28","line":"442"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncSplitterSize"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"456"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"643"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_syncY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"651"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.splitpane","fullName":"qx.ui.splitpane.VerticalSplitPane","name":"VerticalSplitPane","superClass":"qx.ui.splitpane.SplitPane"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"firstSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the top pane. Allowed values are any by {@see qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"secondSize"},children:[{type:"desc",attributes:{"text":"<p>The size of the bottom pane. Allowed values are any by {@see qx.ui.core.Widget} supported unit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new instance of a vertical SplitPane.<br />\n</p>\n\n<p>new qx.ui.splitpane.VerticalSplitPane()<br />\n new qx.ui.splitpane.VerticalSplitPane(firstSize, secondSize)</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.splitpane.SplitPane","name":"dispose"},children:[{type:"desc",attributes:{"text":"<p>Garbage collection</p>"}}]}]}]}]}]},{type:"package",attributes:{"packageName":"qx.ui","fullName":"qx.ui.table","name":"table","hasWarning":"true"},children:[{type:"classes",children:[{type:"class",attributes:{"name":"AbstractDataCellRenderer","hasWarning":"true","packageName":"qx.ui.table","superClass":"qx.ui.table.DataCellRenderer","childClasses":"qx.ui.table.DefaultDataCellRenderer,qx.ui.table.IconDataCellRenderer","fullName":"qx.ui.table.AbstractDataCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An abstract data cell renderer that does the basic coloring (borders, selected look, ...).</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.DataCellRenderer","overriddenFrom":"qx.ui.table.DataCellRenderer","name":"createDataCellHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.DataCellRenderer","overriddenFrom":"qx.ui.table.DataCellRenderer","name":"createDataCellHtml_array_join","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.DataCellRenderer","overriddenFrom":"qx.ui.table.DataCellRenderer","name":"updateDataCellElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"cellElement"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createCellStyle_array_join"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"104"}}]}]},{type:"method",attributes:{"hasError":"true","name":"_createContentHtml_array_join"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"109"}}]}]},{type:"method",attributes:{"name":"_getCellStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>The information about the cell. See {@link #createDataCellHtml}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the <span class=\"caps\">CSS</span> styles that should be applied to the main div of this cell.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">CSS</span> styles of the main div.</p>"}}]}]},{type:"method",attributes:{"name":"_getContentHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>The information about the cell. See {@link #createDataCellHtml}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the <span class=\"caps\">HTML</span> that should be used inside the main div of this cell.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the inner <span class=\"caps\">HTML</span> of the main div.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"MAIN_DIV_START"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"114"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MAIN_DIV_START_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"115"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MAIN_DIV_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"116"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"MAIN_DIV_STYLE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"117"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_MAIN_DIV_LEFT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"35","line":"120"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_MAIN_DIV_WIDTH"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"36","line":"121"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_MAIN_DIV_HEIGHT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"37","line":"122"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_MAIN_DIV_START_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"40","line":"123"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_MAIN_DIV_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"34","line":"124"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TABLE_TD"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"19","line":"126"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TABLE_TD_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"127"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"AbstractTableModel","packageName":"qx.ui.table","superClass":"qx.ui.table.TableModel","childClasses":"qx.ui.table.RemoteTableModel,qx.ui.table.SimpleTableModel","fullName":"qx.ui.table.AbstractTableModel"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>An abstract table model that performs the column handling, so subclasses only need to care for row handling.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getColumnCount"}},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getColumnId"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getColumnIndexById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnId"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getColumnName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}}]}]},{type:"method",attributes:{"name":"setColumnIds"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIdArr"},children:[{type:"desc",attributes:{"text":"<p>the IDs of the columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the column IDs. These IDs may be used internally to identify a column.</p>\n\n<p>Note: This will clear previously set column names.</p>"}}]},{type:"method",attributes:{"name":"setColumnNamesById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnNameMap"},children:[{type:"desc",attributes:{"text":"<p>a map containing the column IDs as keys and the column name as values.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the column names. These names will be shown to the user.</p>\n\n<p>Note: The column IDs have to be defined before.</p>"}}]},{type:"method",attributes:{"name":"setColumnNamesByIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnNameArr"},children:[{type:"desc",attributes:{"text":"<p>the names of the columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the column names. These names will be shown to the user.</p>\n\n<p>Note: The column IDs have to be defined before.</p>"}}]},{type:"method",attributes:{"name":"setColumns"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnNameArr"},children:[{type:"desc",attributes:{"text":"<p>The column names. These names will be shown to the user.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"columnIdArr"},children:[{type:"desc",attributes:{"text":"<p>The column IDs. These IDs may be used internally to identify a column. If null, the column names are used as IDs.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the columns.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.BooleanDataCellRenderer","name":"BooleanDataCellRenderer","superClass":"qx.ui.table.IconDataCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A data cell renderer for boolean values.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.IconDataCellRenderer","overriddenFrom":"qx.ui.table.IconDataCellRenderer","name":"_identifyImage"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"CellEditorFactory","packageName":"qx.ui.table","superClass":"qx.core.Object","childClasses":"qx.ui.table.CheckBoxCellEditorFactory,qx.ui.table.TextFieldCellEditorFactory","fullName":"qx.ui.table.CellEditorFactory"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A factory creating widgets to use for editing table cells.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"createCellEditor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a cell editor.</p>\n\n<p>The cellInfo map contains the following properties: <ul> <li>value (var): the cell&#8217;s value.</li> <li>row (int): the model index of the row the cell belongs to.</li> <li>col (int): the model index of the column the cell belongs to.</li> <li>xPos (int): the x position of the cell in the table pane.</li> </ul></p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the widget that should be used as cell editor.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getCellEditorValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellEditor"},children:[{type:"desc",attributes:{"text":"<p>The cell editor formally created by {@link #createCellEditor}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the current value of a cell editor.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the current value from the editor.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.CheckBoxCellEditorFactory","name":"CheckBoxCellEditorFactory","superClass":"qx.ui.table.CellEditorFactory"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>For editing boolean data in a checkbox.  It is advisable to use this in conjuntion with BooleanDataCellRenderer.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.CellEditorFactory","overriddenFrom":"qx.ui.table.CellEditorFactory","name":"createCellEditor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.CellEditorFactory","overriddenFrom":"qx.ui.table.CellEditorFactory","name":"getCellEditorValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellEditor"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"DataCellRenderer","hasWarning":"true","packageName":"qx.ui.table","superClass":"qx.core.Object","childClasses":"qx.ui.table.AbstractDataCellRenderer","fullName":"qx.ui.table.DataCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A cell renderer for data cells.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"createDataCellHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the <span class=\"caps\">HTML</span> for a data cell.</p>\n\n<p>The cellInfo map contains the following properties: <ul> <li>value (var): the cell&#8217;s value.</li> <li>rowData (var): contains the row data for the row, the cell belongs to. The kind of this object depends on the table model, see {@link TableModel#getRowData()}</li> <li>row (int): the model index of the row the cell belongs to.</li> <li>col (int): the model index of the column the cell belongs to.</li> <li>table (qx.ui.table.Table): the table the cell belongs to.</li> <li>xPos (int): the x position of the cell in the table pane.</li> <li>selected (boolean): whether the cell is selected.</li> <li>focusedCol (boolean): whether the cell is in the same column as the focused cell.</li> <li>focusedRow (boolean): whether the cell is in the same row as the focused cell.</li> <li>editable (boolean): whether the cell is editable.</li> <li>style (string): The <span class=\"caps\">CSS</span> styles that should be applied to the outer <span class=\"caps\">HTML</span> element.</li> </ul></p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">HTML</span> of the data cell.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"createDataCellHtml_array_join"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"42","line":"78"}}]}]},{type:"method",attributes:{"isAbstract":"true","name":"updateDataCellElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create. This map has the same structure as in {@link #createDataCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"cellElement"},children:[{type:"desc",attributes:{"text":"<p>the <span class=\"caps\">DOM</span> element that renders the data cell. This is the same element formally created by the <span class=\"caps\">HTML</span> from {@link #createDataCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Updates a data cell.</p>"}}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"DataRowRenderer","hasWarning":"true","packageName":"qx.ui.table","superClass":"qx.core.Object","childClasses":"qx.ui.table.DefaultDataRowRenderer","fullName":"qx.ui.table.DataRowRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A cell renderer for data rows.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","hasError":"true","name":"updateDataRowElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the row to update. This map has the same structure as in {@link #createDataCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"rowElement"}}]},{type:"desc",attributes:{"text":"<p>Updates a data row.</p>\n\n<p>The rowInfo map contains the following properties: <ul> <li>rowData (var): contains the row data for the row. The kind of this object depends on the table model, see {@link TableModel#getRowData()}</li> <li>row (int): the model index of the row.</li> <li>selected (boolean): whether a cell in this row is selected.</li> <li>focusedRow (boolean): whether the focused cell is in this row.</li> <li>table (qx.ui.table.Table): the table the row belongs to.</li> </ul></p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Contains information for a non-existing parameter <code>cellElement</code>.","column":"33","line":"52"}},{type:"error",attributes:{"msg":"Parameter rowElement is not documented.","column":"33","line":"52"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.DefaultDataCellRenderer","name":"DefaultDataCellRenderer","hasWarning":"true","superClass":"qx.ui.table.AbstractDataCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The default data cell renderer.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"true","type":"boolean","name":"useAutoAlign"},children:[{type:"desc",attributes:{"text":"<p>Whether the alignment should automatically be set according to the cell value. If true numbers will be right-aligned.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_createCellStyle_array_join","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_createContentHtml_array_join","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]}]},{type:"method",attributes:{"name":"_formatValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create. This map has the same structure as in {@link DataCellRenderer#createDataCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Formats a value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the formatted value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_getCellStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_getContentHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"name":"_getStyleFlags"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>cellInfo of the cell</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Determines the styles to apply to the cell</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the sum of any of the <span class=\"caps\">STYLEFLAGS</span> defined below</p>"}}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.DataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"updateDataCellElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"cellElement"}}]}]}]},{type:"methods-static-pub",children:[{type:"method",attributes:{"isStatic":"true","name":"escapeHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"html"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">HTML</span> to escape.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Escapes special <span class=\"caps\">HTML</span> characters by their entities.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The escaped string showing <span class=\"caps\">HTML</span> code as plain text.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]}]},{type:"methods-static-prot",children:[{type:"method",attributes:{"hasError":"true","isStatic":"true","name":"_escapeHtmlReplacer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"str"}}]},{type:"desc",attributes:{"text":"<p>Helper method for {@link #escapeHtml}.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter str is not documented.","column":"32","line":"172"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"STYLEFLAG_ALIGN_RIGHT"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"32","line":"184"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STYLEFLAG_BOLD"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"185"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"STYLEFLAG_ITALIC"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"186"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.DefaultDataRowRenderer","name":"DefaultDataRowRenderer","hasWarning":"true","superClass":"qx.ui.table.DataRowRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The default data row renderer.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"true","type":"boolean","name":"highlightFocusRow"},children:[{type:"desc",attributes:{"text":"<p>Whether the focused row should be highlighted.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"true","type":"boolean","name":"visualizeFocusedState"},children:[{type:"desc",attributes:{"text":"<p>Whether the focused row and the selection should be grayed out when the table hasn&#8217;t the focus.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.DataRowRenderer","overriddenFrom":"qx.ui.table.DataRowRenderer","name":"updateDataRowElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowInfo"}},{type:"param",attributes:{"name":"rowElem"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"hasError":"true","name":"_createRowStyle_array_join"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"39","line":"68"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"BGCOL_FOCUSED_SELECTED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"33","line":"94"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_FOCUSED_SELECTED_BLUR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"38","line":"95"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_FOCUSED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"96"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_FOCUSED_BLUR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"29","line":"97"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_SELECTED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"98"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_SELECTED_BLUR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"99"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_EVEN"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"100"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"BGCOL_ODD"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"101"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"COL_SELECTED"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"23","line":"102"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"COL_NORMAL"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"21","line":"103"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_BG_COLOR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"30","line":"105"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"ARRAY_JOIN_COLOR"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"27","line":"106"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.DefaultHeaderCellRenderer","name":"DefaultHeaderCellRenderer","childClasses":"qx.ui.table.IconHeaderCellRenderer","superClass":"qx.ui.table.HeaderCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The default header cell renderer.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.HeaderCellRenderer","overriddenFrom":"qx.ui.table.HeaderCellRenderer","name":"createHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.HeaderCellRenderer","overriddenFrom":"qx.ui.table.HeaderCellRenderer","name":"updateHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"cellWidget"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"STATE_SORTED"},children:[{type:"desc",attributes:{"text":"<p>(string) The state which will be set for header cells of sorted columns.</p>"}}]},{type:"constant",attributes:{"name":"STATE_SORTED_ASCENDING"},children:[{type:"desc",attributes:{"text":"<p>(string) The state which will be set when sorting is ascending.</p>"}}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"HeaderCellRenderer","packageName":"qx.ui.table","superClass":"qx.core.Object","childClasses":"qx.ui.table.DefaultHeaderCellRenderer","fullName":"qx.ui.table.HeaderCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A cell renderer for header cells.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"createHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a header cell.</p>\n\n<p>The cellInfo map contains the following properties: <ul> <li>col (int): the model index of the column.</li> <li>xPos (int): the x position of the column in the table pane.</li> <li>name (string): the name of the column.</li> <li>editable (boolean): whether the column is editable.</li> <li>sorted (boolean): whether the column is sorted.</li> <li>sortedAscending (boolean): whether sorting is ascending.</li> </ul></p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the widget that renders the header cell.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"updateHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to create. This map has the same structure as in {@link #createHeaderCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"cellWidget"},children:[{type:"desc",attributes:{"text":"<p>the widget that renders the header cell. This is the same widget formally created by {@link #createHeaderCell}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Updates a header cell.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"16","type":"number","name":"prefferedCellHeight"},children:[{type:"desc",attributes:{"text":"<p>The preferred height of cells created by this header renderer.</p>"}}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"IconDataCellRenderer","hasWarning":"true","packageName":"qx.ui.table","superClass":"qx.ui.table.AbstractDataCellRenderer","childClasses":"qx.ui.table.BooleanDataCellRenderer","fullName":"qx.ui.table.IconDataCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A data cell renderer for boolean values.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_createCellStyle_array_join","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_createContentHtml_array_join","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"htmlArr"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_getCellStyle"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.AbstractDataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"_getContentHtml"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}}]}]},{type:"method",attributes:{"name":"_getImageInfos"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>The information about the cell. See {@link #createDataCellHtml}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Retrieves the image infos.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with an &#8220;url&#8221; attribute (type string) holding the <span class=\"caps\">URL</span> of the image to show and a &#8220;tooltip&#8221; attribute (type string) being the tooltip text (or null if none was specified)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"_identifyImage"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>The information about the cell. See {@link #createDataCellHtml}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Identifies the Image to show.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map having the following attributes: <ul> <li>&#8220;url&#8221;: (type string) must be the <span class=\"caps\">URL</span> of the image to show.</li> <li>&#8220;imageWidth&#8221;: (type int) the width of the image in pixels.</li> <li>&#8220;imageHeight&#8221;: (type int) the height of the image in pixels.</li> <li>&#8220;tooltip&#8221;: (type string) must be the image tooltip text.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.DataCellRenderer","overriddenFrom":"qx.ui.table.AbstractDataCellRenderer","name":"updateDataCellElement"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"cellElement"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"hasError":"true","name":"MAIN_DIV_STYLE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"25","line":"175"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"IMG_START"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"176"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"IMG_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"18","line":"177"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"IMG_TITLE_START"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"178"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TABLE_DIV"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"20","line":"179"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TABLE_DIV_CLOSE"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"26","line":"180"}}]}]},{type:"constant",attributes:{"hasError":"true","name":"TABLE_DIV_END"},children:[{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"181"}}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.IconHeaderCellRenderer","name":"IconHeaderCellRenderer","superClass":"qx.ui.table.DefaultHeaderCellRenderer"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"iconUrl"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">URL</span> to the icon to show</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"defaultValue":"\"\"","name":"tooltip"},children:[{type:"desc",attributes:{"text":"<p>Text of the tooltip to show if the mouse hovers over the icon</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>A header cell renderer which renders an icon (only). The icon cannot be combined with text.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"\"\"","type":"string","name":"iconUrl"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">URL</span> of the icon to show</p>"}}]},{type:"property",attributes:{"allowNull":"true","defaultValue":"null","type":"string","name":"toolTip"},children:[{type:"desc",attributes:{"text":"<p>ToolTip to show if the mouse hovers of the icon</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"docFrom":"qx.ui.table.HeaderCellRenderer","overriddenFrom":"qx.ui.table.DefaultHeaderCellRenderer","name":"updateHeaderCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"}},{type:"param",attributes:{"name":"cellWidget"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","packageName":"qx.ui.table","fullName":"qx.ui.table.RemoteTableModel","name":"RemoteTableModel","superClass":"qx.ui.table.AbstractTableModel"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A table model that loads its data from a backend.</p>\n\n<p>Only those  rows are loaded that are near the area the user is currently viewing. If the user scrolls, the rows he will see soon are loaded asynchroniously in the background. All loaded data is managed in a cache that automatically removes the last resently used rows when it gets full.</p>\n\n<p>This class is abstract: The actual loading of row data must be done by subclasses.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"50","type":"number","name":"blockSize"},children:[{type:"desc",attributes:{"text":"<p>The number of rows that are stored in one cache block.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"false","type":"boolean","name":"clearCacheOnRemove"},children:[{type:"desc",attributes:{"text":"<p>Whether to clear the cache when some rows are removed. If false the rows are removed locally in the cache.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"15","type":"number","name":"maxCachedBlockCount"},children:[{type:"desc",attributes:{"text":"<p>The maximum number of row blocks kept in the cache.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"clearCache"},children:[{type:"desc",attributes:{"text":"<p>Clears the cache.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getRowCount"}},{type:"method",attributes:{"overriddenFrom":"qx.ui.table.TableModel","name":"getRowData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the model index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>See overridden method for details.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map containing a value for each column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getSortColumnIndex"}},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}},{type:"param",attributes:{"name":"rowIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"isColumnSortable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"isSortAscending"}},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"prefetchRows"},children:[{type:"params",children:[{type:"param",attributes:{"name":"firstRowIndex"}},{type:"param",attributes:{"name":"lastRowIndex"}}]}]},{type:"method",attributes:{"name":"reloadData"},children:[{type:"desc",attributes:{"text":"<p>Reloads the model and clears the local cache.</p>"}}]},{type:"method",attributes:{"name":"removeRow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the row to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes a rows from the model.</p>"}}]},{type:"method",attributes:{"name":"setColumnSortable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the column of which to set the sortable state.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"sortable"},children:[{type:"desc",attributes:{"text":"<p>whether the column should be sortable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets whether a column is sortable.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"sortByColumn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}},{type:"param",attributes:{"name":"ascending"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"isAbstract":"true","name":"_loadRowCount"},children:[{type:"desc",attributes:{"text":"<p>Loads the row count from the server.</p>\n\n<p>Implementing classes have to call {@link _onRowDataLoaded()} when the server response arrived. That method has to be called! Even when there was an error.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"_loadRowData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"firstRow"},children:[{type:"desc",attributes:{"text":"<p>The index of the first row to load.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"lastRow"},children:[{type:"desc",attributes:{"text":"<p>The index of the last row to load.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Loads some row data from the server.</p>\n\n<p>Implementing classes have to call {@link _onRowDataLoaded()} when the server response arrived. That method has to be called! Even when there was an error.</p>"}}]},{type:"method",attributes:{"name":"_onRowCountLoaded"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowCount"},children:[{type:"desc",attributes:{"text":"<p>the number of rows in this model or null if loading.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the row count.</p>\n\n<p>Has to be called by {@link _loadRowCount()}.</p>"}}]},{type:"method",attributes:{"name":"_onRowDataLoaded"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowDataArr"},children:[{type:"desc",attributes:{"text":"<p>the loaded row data or null if there was an error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets row data.</p>\n\n<p>Has to be called by {@link _loadRowData()}.</p>"}}]},{type:"method",attributes:{"name":"_setRowBlockData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"block"},children:[{type:"desc",attributes:{"text":"<p>the index of the block.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"rowDataArr"},children:[{type:"desc",attributes:{"text":"<p>the data to set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the data of one block.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.SelectionManager","name":"SelectionManager","superClass":"qx.core.Object"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A selection manager. This is a helper class that handles all selection related events and updates a SelectionModel.</p>\n\n<p>Widgets that support selection should use this manager. This way the only thing the widget has to do is mapping mouse or key events to indexes and call the corresponding handler method.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"instance":"qx.ui.table.SelectionModel","type":"Object","name":"selectionModel"},children:[{type:"desc",attributes:{"text":"<p>The selection model where to set the selection changes.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"handleClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index the mouse is pointing at.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the mouse event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the mouse click event.</p>"}}]},{type:"method",attributes:{"name":"handleMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index the mouse is pointing at.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the mouse event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the mouse down event.</p>"}}]},{type:"method",attributes:{"name":"handleMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index the mouse is pointing at.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the mouse event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the mouse up event.</p>"}}]},{type:"method",attributes:{"name":"handleMoveKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index that is currently focused.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the key event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles a key down event that moved the focus (E.g. up, down, home, end, ...).</p>"}}]},{type:"method",attributes:{"name":"handleSelectKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index that is currently focused.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the key event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the key down event that is used as replacement for mouse clicks (Normally space).</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_handleSelectEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index the event is pointing at.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the mouse event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles a select event.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.SelectionModel","name":"SelectionModel","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"changeSelection"},children:[{type:"desc",attributes:{"text":"<p>Fired when the selection has changed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A selection model.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"NO_SELECTION"},children:[{type:"desc",attributes:{"text":"<p>The selection mode &#8220;none&#8221;. Nothing can ever be selected.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"SINGLE_SELECTION"},children:[{type:"desc",attributes:{"text":"<p>The selection mode &#8220;single&#8221;. This mode only allows one selected item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"SINGLE_INTERVAL_SELECTION"},children:[{type:"desc",attributes:{"text":"<p>(int) The selection mode &#8220;single interval&#8221;. This mode only allows one continuous interval of selected items.</p>"}}]},{type:"constant",attributes:{"name":"MULTIPLE_INTERVAL_SELECTION"},children:[{type:"desc",attributes:{"text":"<p>(int) The selection mode &#8220;multiple interval&#8221;. This mode only allows any selection.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"allowNull":"false","defaultValue":"qx.Class.SINGLE_SELECTION","type":"number","name":"selectionMode","possibleValues":"qx.Class.NO_SELECTION, qx.Class.SINGLE_SELECTION, qx.Class.SINGLE_INTERVAL_SELECTION, qx.Class.MULTIPLE_INTERVAL_SELECTION"},children:[{type:"desc",attributes:{"text":"<p>(int) the selection mode.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_addSelectionInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromIndex"},children:[{type:"desc",attributes:{"text":"<p>the first index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"toIndex"},children:[{type:"desc",attributes:{"text":"<p>the last index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a selection interval to the current selection, but doesn&#8217;t inform the listeners.</p>"}}]},{type:"method",attributes:{"name":"_clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears the selection, but doesn&#8217;t inform the listeners.</p>"}}]},{type:"method",attributes:{"name":"_dumpRanges"},children:[{type:"desc",attributes:{"text":"<p>Logs the current ranges for debug perposes.</p>"}}]},{type:"method",attributes:{"name":"_fireChangeSelection"},children:[{type:"desc",attributes:{"text":"<p>Fires the &#8220;changeSelection&#8221; event to all registered listeners. If the selection model currently is in batch mode, only one event will be thrown when batch mode is ended.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addSelectionInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromIndex"},children:[{type:"desc",attributes:{"text":"<p>the first index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"toIndex"},children:[{type:"desc",attributes:{"text":"<p>the last index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a selection interval to the current selection.</p>"}}]},{type:"method",attributes:{"name":"clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears the selection.</p>"}}]},{type:"method",attributes:{"name":"getAnchorSelectionIndex"},children:[{type:"desc",attributes:{"text":"<p>Returns the first argument of the last call to {@link #setSelectionInterval()}, {@link #addSelectionInterval()} or {@link #removeSelectionInterval()}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the ancor selection index.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getLeadSelectionIndex"},children:[{type:"desc",attributes:{"text":"<p>Returns the second argument of the last call to {@link #setSelectionInterval()}, {@link #addSelectionInterval()} or {@link #removeSelectionInterval()}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the lead selection index.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getSelectedCount"},children:[{type:"desc",attributes:{"text":"<p>Returns the number of selected items.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the number of selected items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getSelectedRanges"},children:[{type:"desc",attributes:{"text":"<p>Returns the selected ranges as an array. Each array element has a <code>minIndex</code> and a <code>maxIndex</code> property.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the selected ranges.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"hasBatchMode"},children:[{type:"desc",attributes:{"text":"<p>Returns whether batch mode is active. See setter for a description of batch mode.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>true if batch mode is active, false otherwise</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isSelectedIndex"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a index is selected.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the index is selected.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isSelectionEmpty"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the selection is empty.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the selection is empty.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"iterateSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"iterator"},children:[{type:"desc",attributes:{"text":"<p>the function to call for each selected index. Gets the current index as parameter.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"object"},children:[{type:"desc",attributes:{"text":"<p>the object to use when calling the handler. (this object will be available via &#8220;this&#8221; in the iterator)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls a iterator function for each selected index.</p>\n\n<p>Usage Example: <pre> var selectedRowData = []; mySelectionModel.iterateSelection(function(index) { selectedRowData.push(myTableModel.getRowData(index)); }); </pre></p>"}}]},{type:"method",attributes:{"name":"removeSelectionInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromIndex"},children:[{type:"desc",attributes:{"text":"<p>the first index of the interval (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"toIndex"},children:[{type:"desc",attributes:{"text":"<p>the last index of the interval (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes a interval from the current selection.</p>"}}]},{type:"method",attributes:{"name":"setBatchMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"batchMode"},children:[{type:"desc",attributes:{"text":"<p>true to activate batch mode, false to deactivate</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Activates / Deactivates batch mode. In batch mode, no change events will be thrown but will be collected instead. When batch mode is turned off again and any events have been collected, one event is thrown to inform the listeners.</p>\n\n<p>This method supports nested calling, i. e. batch mode can be turned more than once. In this case, batch mode will not end until it has been turned off once for each turning on.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>true if batch mode is active, false otherwise</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"setSelectionInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromIndex"},children:[{type:"desc",attributes:{"text":"<p>the first index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"toIndex"},children:[{type:"desc",attributes:{"text":"<p>the last index of the selection (including).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the selected interval. This will clear the former selection.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.SimpleTableModel","name":"SimpleTableModel","superClass":"qx.ui.table.AbstractTableModel"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A simple table model that provides an <span class=\"caps\">API</span> for changing the model data.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"addRows"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowArr"},children:[{type:"desc",attributes:{"text":"<p>An array containing an array for each row. Each row-array contains the values in that row in the order of the columns in this model.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"startIndex"},children:[{type:"desc",attributes:{"text":"<p>The index where to insert the new rows. If null, the rows are appended to the end.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds some rows to the model.</p>\n\n<p>Warning: The given array will be altered!</p>"}}]},{type:"method",attributes:{"name":"addRowsAsMapArray"},children:[{type:"params",children:[{type:"param",attributes:{"name":"mapArr"},children:[{type:"desc",attributes:{"text":"<p>An array containing a map for each row. Each row-map contains the column IDs as key and the cell values as value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"startIndex"},children:[{type:"desc",attributes:{"text":"<p>The index where to insert the new rows. If null, the rows are appended to the end.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds some rows to the model.</p>\n\n<p>Warning: The given array (mapArr) will be altered!</p>"}}]},{type:"method",attributes:{"name":"getData"},children:[{type:"desc",attributes:{"text":"<p>Returns the data of this model.</p>\n\n<p>Warning: Do not alter this array! If you want to change the data use {@link #setData}, {@link #setDataAsMapArray} or {@link #setValue} instead.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An array containing an array for each row. Each row-array contains the values in that row in the order of the columns in this model.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getRowCount"}},{type:"method",attributes:{"overriddenFrom":"qx.ui.table.TableModel","name":"getRowData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the model index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>See overridden method for details.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Array containing a value for each column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"getRowDataAsMap"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the model index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the data of one row as map containing the column IDs as key and the cell values as value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>a Map containing the column values.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getSortColumnIndex"}},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"getValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}},{type:"param",attributes:{"name":"rowIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"isColumnEditable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"isColumnSortable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"isSortAscending"}},{type:"method",attributes:{"name":"removeRows"},children:[{type:"params",children:[{type:"param",attributes:{"name":"startIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the first row to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"howMany"},children:[{type:"desc",attributes:{"text":"<p>the number of rows to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes some rows from the model.</p>"}}]},{type:"method",attributes:{"name":"setColumnEditable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the column of which to set the editable state.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"editable"},children:[{type:"desc",attributes:{"text":"<p>whether the column should be editable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets whether a column is editable.</p>"}}]},{type:"method",attributes:{"name":"setData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowArr"},children:[{type:"desc",attributes:{"text":"<p>An array containing an array for each row. Each row-array contains the values in that row in the order of the columns in this model.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the whole data in a bulk.</p>"}}]},{type:"method",attributes:{"name":"setDataAsMapArray"},children:[{type:"params",children:[{type:"param",attributes:{"name":"mapArr"},children:[{type:"desc",attributes:{"text":"<p>An array containing a map for each row. Each row-map contains the column IDs as key and the cell values as value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the whole data in a bulk.</p>"}}]},{type:"method",attributes:{"name":"setEditable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"editable"},children:[{type:"desc",attributes:{"text":"<p>whether all columns are editable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets all columns editable or not editable.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"setValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}},{type:"param",attributes:{"name":"rowIndex"}},{type:"param",attributes:{"name":"value"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.TableModel","overriddenFrom":"qx.ui.table.TableModel","name":"sortByColumn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"}},{type:"param",attributes:{"name":"ascending"}}]}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_clearSorting"},children:[{type:"desc",attributes:{"text":"<p>Clears the sorting.</p>"}}]},{type:"method",attributes:{"name":"_mapArray2RowArr"},children:[{type:"params",children:[{type:"param",attributes:{"name":"mapArr"},children:[{type:"desc",attributes:{"text":"<p>An array containing a map for each row. Each row-map contains the column IDs as key and the cell values as value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates an array of maps to an array of arrays.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An array containing an array for each row. Each row-array contains the values in that row in the order of the columns in this model.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var","dimensions":"2"}}]}]}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.Table","name":"Table","hasWarning":"true","superClass":"qx.ui.layout.VerticalBoxLayout"},children:[{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"tableModel"},children:[{type:"desc",attributes:{"text":"<p>The table model to read the data from.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.table.TableModel"}}]}]}]},{type:"desc",attributes:{"text":"<p>A table.</p>"}}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"DEFAULT_DATA_ROW_RENDERER"},children:[{type:"desc",attributes:{"text":"<p>The default row renderer to use when {@link #dataRowRenderer} is null.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"alwaysUpdateCells"},children:[{type:"desc",attributes:{"text":"<p>Whether the table cells should be updated when only the selection or the focus changed. This slows down the table update but allows to react on a changed selection or a changed focus in a cell renderer.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"columnVisibilityButtonVisible"},children:[{type:"desc",attributes:{"text":"<p>Whether to show the column visibility button</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"qx.Class.DEFAULT_DATA_ROW_RENDERER","type":"Object","name":"dataRowRenderer","instance":"qx.ui.table.DataRowRenderer"},children:[{type:"desc",attributes:{"text":"<p>The renderer to use for styling the rows.</p>"}}]},{type:"property",attributes:{"defaultValue":"false","type":"boolean","name":"focusCellOnMouseMove"},children:[{type:"desc",attributes:{"text":"<p>Whether the focus should moved when the mouse is moved over a cell. If false the focus is only moved on mouse clicks.</p>"}}]},{type:"property",attributes:{"allowNull":"false","defaultValue":"16","type":"number","name":"headerCellHeight"},children:[{type:"desc",attributes:{"text":"<p>The height of the header cells.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"keepFirstVisibleRowComplete"},children:[{type:"desc",attributes:{"text":"<p>Whether the table should keep the first visible row complete. If set to false, the first row may be rendered partial, depending on the vertical scroll value.</p>"}}]},{type:"property",attributes:{"type":"Object","name":"metaColumnCounts"},children:[{type:"desc",attributes:{"text":"<p>The number of columns per meta column. If the last array entry is -1, this meta column will get the remaining columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int","dimensions":"1"}}]}]},{type:"property",attributes:{"defaultValue":"15","type":"number","name":"rowHeight"},children:[{type:"desc",attributes:{"text":"<p>The height of the table rows.</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.table.SelectionModel","type":"Object","name":"selectionModel"},children:[{type:"desc",attributes:{"text":"<p>The selection model.</p>"}}]},{type:"property",attributes:{"defaultValue":"true","type":"boolean","name":"statusBarVisible"},children:[{type:"desc",attributes:{"text":"<p>Whether to show the status bar</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.table.TableColumnModel","type":"Object","name":"tableColumnModel"},children:[{type:"desc",attributes:{"text":"<p>The table column model.</p>"}}]},{type:"property",attributes:{"instance":"qx.ui.table.TableModel","type":"Object","name":"tableModel"},children:[{type:"desc",attributes:{"text":"<p>The table model.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Parent","name":"_afterAppear","hasWarning":"true"}},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_changeInnerHeight","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"newValue"}},{type:"param",attributes:{"name":"oldValue"}}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Parent","overriddenFrom":"qx.ui.core.Parent","name":"_changeInnerWidth","hasWarning":"true"},children:[{type:"params",children:[{type:"param",attributes:{"name":"newValue"}},{type:"param",attributes:{"name":"oldValue"}}]}]},{type:"method",attributes:{"name":"_cleanupColumnVisibilityMenu"},children:[{type:"desc",attributes:{"text":"<p>Cleans up the column visibility menu.</p>"}}]},{type:"method",attributes:{"name":"_cleanUpMetaColumns"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromMetaColumn"},children:[{type:"desc",attributes:{"text":"<p>the first meta column to clean up. All following meta columns will be cleaned up, too. All previous meta columns will stay unchanged. If 0 all meta columns will be cleaned up.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Cleans up the meta columns.</p>"}}]},{type:"method",attributes:{"name":"_createColumnVisibilityCheckBoxHandler"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of column to create the handler for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a handler for a check box of the column visibility menu.</p>"}}]},{type:"method",attributes:{"name":"_getMetaColumnAtColumnX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"visXPos"},children:[{type:"desc",attributes:{"text":"<p>the visible x position of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the meta column a column is shown in. If the column is not shown at all, -1 is returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the meta column the column is shown in.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"_getMetaColumnAtPageX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"pageX"},children:[{type:"desc",attributes:{"text":"<p>the position in the page to check (in pixels).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the meta column at a certain x position in the page. If there is no meta column at this postion, -1 is returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the index of the meta column or -1.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"_getPaneScrollerArr"},children:[{type:"desc",attributes:{"text":"<p>Returns an array containing all TablePaneScrollers in this table.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>all TablePaneScrollers in this table.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"TablePaneScroller","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"_getSelectionManager"},children:[{type:"desc",attributes:{"text":"<p>Returns the selection manager.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the selection manager.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"SelectionManager"}}]}]}]},{type:"method",attributes:{"name":"_onColOrderChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the column order has changed.</p>"}}]},{type:"method",attributes:{"name":"_onColumnVisibilityBtExecuted"},children:[{type:"desc",attributes:{"text":"<p>Event handler. Called when the column visibiliy button was executed.</p>"}}]},{type:"method",attributes:{"name":"_onColVisibilityChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the visibility of a column has changed.</p>"}}]},{type:"method",attributes:{"name":"_onColWidthChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the width of a column has changed.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_onFocusChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the table gets the focus.</p>"}},{type:"errors",children:[{type:"error",attributes:{"msg":"Parameter evt is not documented.","column":"28","line":"549"}}]}]},{type:"method",attributes:{"name":"_onkeydown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when a key was pressed.</p>"}}]},{type:"method",attributes:{"hasError":"true","name":"_onkeypress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"}}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Documentation is missing.","column":"24","line":"490"}}]}]},{type:"method",attributes:{"name":"_onScrollY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when a TablePaneScroller has been scrolled vertically.</p>"}}]},{type:"method",attributes:{"name":"_onSelectionChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the selection has changed.</p>"}}]},{type:"method",attributes:{"name":"_onTableModelDataChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the table model data has changed.</p>"}}]},{type:"method",attributes:{"name":"_onTableModelMetaDataChanged"},children:[{type:"params",children:[{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called when the table model meta data has changed.</p>"}}]},{type:"method",attributes:{"name":"_toggleColumnVisibilityMenu"},children:[{type:"desc",attributes:{"text":"<p>Toggels the visibility of the menu used to change the visibility of columns.</p>"}}]},{type:"method",attributes:{"name":"_updateScrollBarVisibility"},children:[{type:"desc",attributes:{"text":"<p>Updates the visibility of the scrollbars in the meta columns.</p>"}}]},{type:"method",attributes:{"name":"_updateScrollerWidths"},children:[{type:"desc",attributes:{"text":"<p>Updates the widths of all scrollers.</p>"}}]},{type:"method",attributes:{"name":"_updateStatusBar"},children:[{type:"desc",attributes:{"text":"<p>Updates the text shown in the status bar.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"cancelEditing"},children:[{type:"desc",attributes:{"text":"<p>Stops editing without writing the editor&#8217;s value to the model.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Target","overriddenFrom":"qx.ui.core.Parent","name":"dispose"}},{type:"method",attributes:{"name":"getFocusedColumn"},children:[{type:"desc",attributes:{"text":"<p>Returns the column of the currently focused cell.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the model index of the focused cell&#8217;s column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getFocusedRow"},children:[{type:"desc",attributes:{"text":"<p>Returns the row of the currently focused cell.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the model index of the focused cell&#8217;s column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getPaneScroller"},children:[{type:"params",children:[{type:"param",attributes:{"name":"metaColumn"},children:[{type:"desc",attributes:{"text":"<p>the meta column to get the TablePaneScroller for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a TablePaneScroller of this table.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the TablePaneScroller.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"TablePaneScroller"}}]}]}]},{type:"method",attributes:{"name":"getTablePaneScrollerAtPageX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"pageX"},children:[{type:"desc",attributes:{"text":"<p>the position in the page to check (in pixels).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Gets the TablePaneScroller at a certain x position in the page. If there is no TablePaneScroller at this postion, null is returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the TablePaneScroller or null.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"TablePaneScroller"}}]}]}]},{type:"method",attributes:{"name":"isEditing"},children:[{type:"desc",attributes:{"text":"<p>Returns whether currently a cell is editing.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether currently a cell is editing.</p>"}}]}]},{type:"method",attributes:{"name":"moveFocusedCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"deltaX"},children:[{type:"desc",attributes:{"text":"<p>The delta by which the focus should be moved on the x axis.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"deltaY"},children:[{type:"desc",attributes:{"text":"<p>The delta by which the focus should be moved on the y axis.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Moves the focus.</p>"}}]},{type:"method",attributes:{"name":"scrollCellVisible"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column the cell belongs to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"row"},children:[{type:"desc",attributes:{"text":"<p>the model index of the row the cell belongs to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Scrolls a cell visible.</p>"}}]},{type:"method",attributes:{"name":"setColumnWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>the new width in pixels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the width of a column.</p>"}}]},{type:"method",attributes:{"name":"setFocusedCell"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the focused cell&#8217;s column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"row"},children:[{type:"desc",attributes:{"text":"<p>the model index of the focused cell&#8217;s row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"scrollVisible"},children:[{type:"desc",attributes:{"text":"<p>whether to scroll the new focused cell visible.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the currently focused cell.</p>"}}]},{type:"method",attributes:{"name":"startEditing"},children:[{type:"desc",attributes:{"text":"<p>Starts editing the currently focused cell. Does nothing if already editing or if the column is not editable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether editing was started</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"stopEditing"},children:[{type:"desc",attributes:{"text":"<p>Stops editing and writes the editor&#8217;s value to the model.</p>"}}]}]}]},{type:"class",attributes:{"packageName":"qx.ui.table","fullName":"qx.ui.table.TableColumnModel","name":"TableColumnModel","superClass":"qx.core.Target"},children:[{type:"events",children:[{type:"event",attributes:{"name":"orderChanged"},children:[{type:"desc",attributes:{"text":"<p>Fired when the column order has changed. The data property of the event is a map having the following attributes: <ul> <li>col: The model index of the column that was moved.</li> <li>fromOverXPos: The old overall x position of the column.</li> <li>toOverXPos: The new overall x position of the column.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]},{type:"event",attributes:{"name":"visibilityChanged"},children:[{type:"desc",attributes:{"text":"<p>Fired when the visibility of a column has changed. The data property of the event is a map having the following attributes: <ul> <li>col: The model index of the column the visibility of which has changed.</li> <li>visible: Whether the column is now visible.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]},{type:"event",attributes:{"name":"visibilityChangedPre"},children:[{type:"desc",attributes:{"text":"<p>Fired when the visibility of a column has changed. This event is equal to &#8220;visibilityChanged&#8221;, but is fired right before.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]},{type:"event",attributes:{"name":"widthChanged"},children:[{type:"desc",attributes:{"text":"<p>Fired when the width of a column has changed. The data property of the event is a map having the following attributes: <ul> <li>col: The model index of the column the width of which has changed.</li> <li>newWidth: The new width of the column in pixels.</li> <li>oldWidth: The old width of the column in pixels.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>A model that contains all meta data about columns, such as width, renderers, visibility and order.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"name":"getCellEditorFactory"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the cell editor factory of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the cell editor factory of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"CellEditorFactory"}}]}]}]},{type:"method",attributes:{"name":"getColumnWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the width of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the width of the column in pixels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getDataCellRenderer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the data renderer of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the data renderer of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DataCellRenderer"}}]}]}]},{type:"method",attributes:{"name":"getHeaderCellRenderer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the header renderer of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the header renderer of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"HeaderCellRenderer"}}]}]}]},{type:"method",attributes:{"name":"getOverallColumnAtX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"overXPos"},children:[{type:"desc",attributes:{"text":"<p>the overall x position of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the model index of a column at a certain overall x position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getOverallColumnCount"},children:[{type:"desc",attributes:{"text":"<p>Returns the overall number of columns (including hidden columns).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the overall number of columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getOverallX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the overall x position of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the overall x position of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getVisibleColumnAtX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"visXPos"},children:[{type:"desc",attributes:{"text":"<p>the visible x position of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the model index of a column at a certain visible x position.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getVisibleColumnCount"},children:[{type:"desc",attributes:{"text":"<p>Returns the number of visible columns.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the number of visible columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getVisibleX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the visible x position of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the visible x position of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"init"},children:[{type:"params",children:[{type:"param",attributes:{"name":"colCount"},children:[{type:"desc",attributes:{"text":"<p>the number of columns the model should have.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Initializes the column model.</p>"}}]},{type:"method",attributes:{"name":"isColumnVisible"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a certain column is visible.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the column is visible.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"moveColumn"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fromOverXPos"},children:[{type:"desc",attributes:{"text":"<p>the overall x postion of the column to move.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"toOverXPos"},children:[{type:"desc",attributes:{"text":"<p>the overall x postion of where the column should be moved to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Moves a column.</p>"}}]},{type:"method",attributes:{"name":"setCellEditorFactory"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"factory"},children:[{type:"desc",attributes:{"text":"<p>the new cell editor factory the column should get.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"CellEditorFactory"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the cell editor factory of a column.</p>"}}]},{type:"method",attributes:{"name":"setColumnVisible"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"visible"},children:[{type:"desc",attributes:{"text":"<p>whether the column should be visible.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets whether a certain column is visible.</p>"}}]},{type:"method",attributes:{"name":"setColumnWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>the new width the column should get in pixels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the width of a column.</p>"}}]},{type:"method",attributes:{"name":"setDataCellRenderer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"renderer"},children:[{type:"desc",attributes:{"text":"<p>the new data renderer the column should get.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DataCellRenderer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the data renderer of a column.</p>"}}]},{type:"method",attributes:{"name":"setHeaderCellRenderer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"col"},children:[{type:"desc",attributes:{"text":"<p>the model index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"renderer"},children:[{type:"desc",attributes:{"text":"<p>the new header renderer the column should get.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"HeaderCellRenderer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the header renderer of a column.</p>"}}]}]},{type:"methods-prot",children:[{type:"method",attributes:{"name":"_getColToXPosMap"},children:[{type:"desc",attributes:{"text":"<p>Returns the map that translates model indexes to x positions.</p>\n\n<p>The returned map contains for a model index (int) a map having two properties: overX (the overall x position of the column, int) and visX (the visible x position of the column, int). visX is missing for hidden columns.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the &#8220;column to x postion&#8221; map.</p>"}}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"DEFAULT_WIDTH"},children:[{type:"desc",attributes:{"text":"<p>the default width of a column in pixels.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"constant",attributes:{"name":"DEFAULT_HEADER_RENDERER"},children:[{type:"desc",attributes:{"text":"<p>the default header cell renderer.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DefaultDataCellRenderer"}}]}]},{type:"constant",attributes:{"name":"DEFAULT_DATA_RENDERER"},children:[{type:"desc",attributes:{"text":"<p>the default data cell renderer.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DefaultDataCellRenderer"}}]}]},{type:"constant",attributes:{"name":"DEFAULT_EDITOR_FACTORY"},children:[{type:"desc",attributes:{"text":"<p>the default editor factory.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"TextFieldCellEditorFactory"}}]}]}]}]},{type:"class",attributes:{"isAbstract":"true","name":"TableModel","packageName":"qx.ui.table","superClass":"qx.core.Target","childClasses":"qx.ui.table.AbstractTableModel","fullName":"qx.ui.table.TableModel"},children:[{type:"events",children:[{type:"event",attributes:{"name":"dataChanged"},children:[{type:"desc",attributes:{"text":"<p>Fired when the table data changed (the stuff shown in the table body). The data property of the event may be null or a map having the following attributes: <ul> <li>firstRow: The index of the first row that has changed.</li> <li>lastRow: The index of the last row that has changed.</li> <li>firstColumn: The model index of the first column that has changed.</li> <li>lastColumn: The model index of the last column that has changed.</li> </ul></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.DataEvent"}}]}]},{type:"event",attributes:{"name":"metaDataChanged"},children:[{type:"desc",attributes:{"text":"<p>Fired when the meta data changed (the stuff shown in the table header).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true"},children:[{type:"desc",attributes:{"text":"<p>The data model of a table.</p>"}}]}]},{type:"methods-pub",children:[{type:"method",attributes:{"isAbstract":"true","name":"getColumnCount"},children:[{type:"desc",attributes:{"text":"<p>Returns the number of columns in the model.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the number of columns.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getColumnId"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the ID of column. The ID may be used to identify columns independent from their index in the model. E.g. for being aware of added columns when saving the width of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the ID of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getColumnIndexById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the index of a column.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getColumnName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the name of a column. This name will be shown to the user in the table header.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the name of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getRowCount"},children:[{type:"desc",attributes:{"text":"<p>Returns the number of rows in the model.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the number of rows.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"name":"getRowData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the model index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the data of one row. This function may be overriden by models which hold all data of a row in one object. By using this function, clients have a way of quickly retrieving the entire row data.</p>\n\n<b>Important:</b>Models which do not have their row data accessible in one object may return null."}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the row data as an object or null if the model does not support row data objects. The details on the object returned are determined by the model implementation only.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"getSortColumnIndex"},children:[{type:"desc",attributes:{"text":"<p>Returns the column index the model is sorted by. If the model is not sorted -1 is returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the column index the model is sorted by.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"method",attributes:{"isAbstract":"true","name":"getValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a cell value by column index.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The value of the cell.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getValueById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnId"},children:[{type:"desc",attributes:{"text":"<p>the ID of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a cell value by column ID.</p>\n\n<p>Whenever you have the choice, use {@link #getValue()} instead, because this should be faster.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the value of the cell.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isColumnEditable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the column to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a column is editable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the column is editable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isColumnSortable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>the column to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns whether a column is sortable.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the column is sortable.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"isSortAscending"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the model is sorted ascending.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>whether the model is sorted ascending.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"method",attributes:{"name":"prefetchRows"},children:[{type:"params",children:[{type:"param",attributes:{"name":"firstRowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of first row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"lastRowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of last row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]}]},{type:"desc",attributes:{"text":"<p>Prefetches some rows. This is a hint to the model that the specified rows will be read soon.</p>"}}]},{type:"method",attributes:{"isAbstract":"true","name":"setValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnIndex"},children:[{type:"desc",attributes:{"text":"<p>The index of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>the index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The new value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets a cell value by column index.</p>"}}]},{type:"method",attributes:{"name":"setValueById"},children:[{type:"params",children:[{type:"param",attributes:{"name":"columnId"},children:[{type:"desc",attributes:{"text":"<p>The ID of the column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"string"}}]}]},{type:"param",attributes:{"name":"rowIndex"},children:[{type:"desc",attributes:{"text":"<p>The index of the row.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"int"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The new value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets a cell value by column ID.</p>\n\n<p>Whenever you have the choice, use {@link #setValue()} instead, because this should be faster.</p>"}}]},{type:"method",attributes:{"name":"sortByColumn"},children:[{type:"params",children:[