/* header auto-generated by pidl */

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#ifndef _HEADER_dcerpc
#define _HEADER_dcerpc

#define DCERPC_REQUEST_LENGTH	( 24 )
#define DCERPC_BIND_REASON_ASYNTAX	( 1 )
#define DCERPC_BIND_PROVIDER_REJECT	( 2 )
#define DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED	( 4 )
#define DCERPC_BIND_REASON_INVALID_AUTH_TYPE	( 8 )
#define DCERPC_RESPONSE_LENGTH	( 24 )
#define DCERPC_FAULT_OP_RNG_ERROR	( 0x1c010002 )
#define DCERPC_FAULT_UNK_IF	( 0x1c010003 )
#define DCERPC_FAULT_NDR	( 0x000006f7 )
#define DCERPC_FAULT_INVALID_TAG	( 0x1c000006 )
#define DCERPC_FAULT_CONTEXT_MISMATCH	( 0x1c00001a )
#define DCERPC_FAULT_OTHER	( 0x00000001 )
#define DCERPC_FAULT_ACCESS_DENIED	( 0x00000005 )
#define DCERPC_FAULT_CANT_PERFORM	( 0x000006d8 )
#define DCERPC_FAULT_SEC_PKG_ERROR	( 0x00000721 )
#define DCERPC_FAULT_TODO	( 0x00000042 )
#define DCERPC_AUTH_LEVEL_DEFAULT	( DCERPC_AUTH_LEVEL_CONNECT )
#define DCERPC_AUTH_TRAILER_LENGTH	( 8 )
#define DCERPC_PFC_FLAG_FIRST	( 0x01 )
#define DCERPC_PFC_FLAG_LAST	( 0x02 )
#define DCERPC_PFC_FLAG_PENDING_CANCEL	( 0x04 )
#define DCERPC_PFC_FLAG_SUPPORT_HEADER_SIGN	( DCERPC_PFC_FLAG_PENDING_CANCEL )
#define DCERPC_PFC_FLAG_CONC_MPX	( 0x10 )
#define DCERPC_PFC_FLAG_DID_NOT_EXECUTE	( 0x20 )
#define DCERPC_PFC_FLAG_MAYBE	( 0x40 )
#define DCERPC_PFC_FLAG_OBJECT_UUID	( 0x80 )
#define DCERPC_PFC_OFFSET	( 3 )
#define DCERPC_DREP_OFFSET	( 4 )
#define DCERPC_FRAG_LEN_OFFSET	( 8 )
#define DCERPC_AUTH_LEN_OFFSET	( 10 )
#define DCERPC_DREP_LE	( 0x10 )
struct dcerpc_ctx_list {
	uint16_t context_id;
	uint8_t num_transfer_syntaxes;
	struct ndr_syntax_id abstract_syntax;
	struct ndr_syntax_id *transfer_syntaxes;
};

struct dcerpc_bind {
	uint16_t max_xmit_frag;
	uint16_t max_recv_frag;
	uint32_t assoc_group_id;
	uint8_t num_contexts;
	struct dcerpc_ctx_list *ctx_list;
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_ALIGN4)] */
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

struct dcerpc_empty {
	char _empty_;
};

union dcerpc_object {
	struct dcerpc_empty empty;/* [default] */
	struct GUID object;/* [case(LIBNDR_FLAG_OBJECT_PRESENT)] */
}/* [nodiscriminant] */;

struct dcerpc_request {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint16_t opnum;
	union dcerpc_object object;/* [switch_is(ndr->flags&LIBNDR_FLAG_OBJECT_PRESENT)] */
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_ALIGN8)] */
	DATA_BLOB stub_and_verifier;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

struct dcerpc_ack_ctx {
	uint16_t result;
	uint16_t reason;
	struct ndr_syntax_id syntax;
};

struct dcerpc_bind_ack {
	uint16_t max_xmit_frag;
	uint16_t max_recv_frag;
	uint32_t assoc_group_id;
	uint16_t secondary_address_size;/* [value(strlen(secondary_address)+1)] */
	const char *secondary_address;/* [charset(DOS)] */
	DATA_BLOB _pad1;/* [flag(LIBNDR_FLAG_ALIGN4)] */
	uint8_t num_results;
	struct dcerpc_ack_ctx *ctx_list;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

struct dcerpc_bind_nak_versions {
	uint32_t num_versions;
	uint32_t *versions;
};

union dcerpc_bind_nak_versions_ctr {
	struct dcerpc_bind_nak_versions v;/* [case(DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED)] */
}/* [nodiscriminant] */;

struct dcerpc_bind_nak {
	uint16_t reject_reason;
	union dcerpc_bind_nak_versions_ctr versions;/* [switch_is(reject_reason)] */
};

struct dcerpc_response {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint8_t cancel_count;
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_ALIGN8)] */
	DATA_BLOB stub_and_verifier;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

struct dcerpc_fault {
	uint32_t alloc_hint;
	uint16_t context_id;
	uint8_t cancel_count;
	uint32_t status;
	DATA_BLOB _pad;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum dcerpc_AuthType
#ifndef USE_UINT_ENUMS
 {
	DCERPC_AUTH_TYPE_NONE=(int)(0),
	DCERPC_AUTH_TYPE_KRB5_1=(int)(1),
	DCERPC_AUTH_TYPE_SPNEGO=(int)(9),
	DCERPC_AUTH_TYPE_NTLMSSP=(int)(10),
	DCERPC_AUTH_TYPE_KRB5=(int)(16),
	DCERPC_AUTH_TYPE_DPA=(int)(17),
	DCERPC_AUTH_TYPE_MSN=(int)(18),
	DCERPC_AUTH_TYPE_DIGEST=(int)(21),
	DCERPC_AUTH_TYPE_SCHANNEL=(int)(68),
	DCERPC_AUTH_TYPE_MSMQ=(int)(100)
}
#else
 { __donnot_use_enum_dcerpc_AuthType=0x7FFFFFFF}
#define DCERPC_AUTH_TYPE_NONE ( 0 )
#define DCERPC_AUTH_TYPE_KRB5_1 ( 1 )
#define DCERPC_AUTH_TYPE_SPNEGO ( 9 )
#define DCERPC_AUTH_TYPE_NTLMSSP ( 10 )
#define DCERPC_AUTH_TYPE_KRB5 ( 16 )
#define DCERPC_AUTH_TYPE_DPA ( 17 )
#define DCERPC_AUTH_TYPE_MSN ( 18 )
#define DCERPC_AUTH_TYPE_DIGEST ( 21 )
#define DCERPC_AUTH_TYPE_SCHANNEL ( 68 )
#define DCERPC_AUTH_TYPE_MSMQ ( 100 )
#endif
;

enum dcerpc_AuthLevel
#ifndef USE_UINT_ENUMS
 {
	DCERPC_AUTH_LEVEL_NONE=(int)(1),
	DCERPC_AUTH_LEVEL_CONNECT=(int)(2),
	DCERPC_AUTH_LEVEL_CALL=(int)(3),
	DCERPC_AUTH_LEVEL_PACKET=(int)(4),
	DCERPC_AUTH_LEVEL_INTEGRITY=(int)(5),
	DCERPC_AUTH_LEVEL_PRIVACY=(int)(6)
}
#else
 { __donnot_use_enum_dcerpc_AuthLevel=0x7FFFFFFF}
#define DCERPC_AUTH_LEVEL_NONE ( 1 )
#define DCERPC_AUTH_LEVEL_CONNECT ( 2 )
#define DCERPC_AUTH_LEVEL_CALL ( 3 )
#define DCERPC_AUTH_LEVEL_PACKET ( 4 )
#define DCERPC_AUTH_LEVEL_INTEGRITY ( 5 )
#define DCERPC_AUTH_LEVEL_PRIVACY ( 6 )
#endif
;

struct dcerpc_auth {
	enum dcerpc_AuthType auth_type;
	enum dcerpc_AuthLevel auth_level;
	uint8_t auth_pad_length;
	uint8_t auth_reserved;
	uint32_t auth_context_id;
	DATA_BLOB credentials;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_auth3 {
	uint32_t _pad;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_orphaned {
	uint32_t _pad;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_co_cancel {
	uint32_t _pad;
	DATA_BLOB auth_info;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [public] */;

struct dcerpc_cl_cancel {
	uint32_t version;
	uint32_t id;
}/* [public] */;

struct dcerpc_cancel_ack {
	uint32_t version;
	uint32_t id;
	uint32_t server_is_accepting;
}/* [public] */;

struct dcerpc_fack {
	uint32_t version;
	uint8_t _pad1;
	uint16_t window_size;
	uint32_t max_tdsu;
	uint32_t max_frag_size;
	uint16_t serial_no;
	uint16_t selack_size;
	uint32_t *selack;
}/* [public] */;

struct dcerpc_ack {
	char _empty_;
}/* [public] */;

struct dcerpc_ping {
	char _empty_;
}/* [public] */;

struct dcerpc_shutdown {
	char _empty_;
}/* [public] */;

struct dcerpc_working {
	char _empty_;
}/* [public] */;

enum dcerpc_pkt_type
#ifndef USE_UINT_ENUMS
 {
	DCERPC_PKT_REQUEST=(int)(0),
	DCERPC_PKT_PING=(int)(1),
	DCERPC_PKT_RESPONSE=(int)(2),
	DCERPC_PKT_FAULT=(int)(3),
	DCERPC_PKT_WORKING=(int)(4),
	DCERPC_PKT_NOCALL=(int)(5),
	DCERPC_PKT_REJECT=(int)(6),
	DCERPC_PKT_ACK=(int)(7),
	DCERPC_PKT_CL_CANCEL=(int)(8),
	DCERPC_PKT_FACK=(int)(9),
	DCERPC_PKT_CANCEL_ACK=(int)(10),
	DCERPC_PKT_BIND=(int)(11),
	DCERPC_PKT_BIND_ACK=(int)(12),
	DCERPC_PKT_BIND_NAK=(int)(13),
	DCERPC_PKT_ALTER=(int)(14),
	DCERPC_PKT_ALTER_RESP=(int)(15),
	DCERPC_PKT_AUTH3=(int)(16),
	DCERPC_PKT_SHUTDOWN=(int)(17),
	DCERPC_PKT_CO_CANCEL=(int)(18),
	DCERPC_PKT_ORPHANED=(int)(19)
}
#else
 { __donnot_use_enum_dcerpc_pkt_type=0x7FFFFFFF}
#define DCERPC_PKT_REQUEST ( 0 )
#define DCERPC_PKT_PING ( 1 )
#define DCERPC_PKT_RESPONSE ( 2 )
#define DCERPC_PKT_FAULT ( 3 )
#define DCERPC_PKT_WORKING ( 4 )
#define DCERPC_PKT_NOCALL ( 5 )
#define DCERPC_PKT_REJECT ( 6 )
#define DCERPC_PKT_ACK ( 7 )
#define DCERPC_PKT_CL_CANCEL ( 8 )
#define DCERPC_PKT_FACK ( 9 )
#define DCERPC_PKT_CANCEL_ACK ( 10 )
#define DCERPC_PKT_BIND ( 11 )
#define DCERPC_PKT_BIND_ACK ( 12 )
#define DCERPC_PKT_BIND_NAK ( 13 )
#define DCERPC_PKT_ALTER ( 14 )
#define DCERPC_PKT_ALTER_RESP ( 15 )
#define DCERPC_PKT_AUTH3 ( 16 )
#define DCERPC_PKT_SHUTDOWN ( 17 )
#define DCERPC_PKT_CO_CANCEL ( 18 )
#define DCERPC_PKT_ORPHANED ( 19 )
#endif
;

union dcerpc_payload {
	struct dcerpc_request request;/* [case(DCERPC_PKT_REQUEST)] */
	struct dcerpc_ping ping;/* [case(DCERPC_PKT_PING)] */
	struct dcerpc_response response;/* [case(DCERPC_PKT_RESPONSE)] */
	struct dcerpc_fault fault;/* [case(DCERPC_PKT_FAULT)] */
	struct dcerpc_working working;/* [case(DCERPC_PKT_WORKING)] */
	struct dcerpc_fack nocall;/* [case(DCERPC_PKT_NOCALL)] */
	struct dcerpc_fault reject;/* [case(DCERPC_PKT_REJECT)] */
	struct dcerpc_ack ack;/* [case(DCERPC_PKT_ACK)] */
	struct dcerpc_cl_cancel cl_cancel;/* [case(DCERPC_PKT_CL_CANCEL)] */
	struct dcerpc_fack fack;/* [case(DCERPC_PKT_FACK)] */
	struct dcerpc_cancel_ack cancel_ack;/* [case(DCERPC_PKT_CANCEL_ACK)] */
	struct dcerpc_bind bind;/* [case(DCERPC_PKT_BIND)] */
	struct dcerpc_bind_ack bind_ack;/* [case(DCERPC_PKT_BIND_ACK)] */
	struct dcerpc_bind_nak bind_nak;/* [case(DCERPC_PKT_BIND_NAK)] */
	struct dcerpc_bind alter;/* [case(DCERPC_PKT_ALTER)] */
	struct dcerpc_bind_ack alter_resp;/* [case(DCERPC_PKT_ALTER_RESP)] */
	struct dcerpc_shutdown shutdown;/* [case(DCERPC_PKT_SHUTDOWN)] */
	struct dcerpc_co_cancel co_cancel;/* [case(DCERPC_PKT_CO_CANCEL)] */
	struct dcerpc_orphaned orphaned;/* [case(DCERPC_PKT_ORPHANED)] */
	struct dcerpc_auth3 auth3;/* [case(DCERPC_PKT_AUTH3)] */
}/* [nodiscriminant] */;

struct ncacn_packet {
	uint8_t rpc_vers;
	uint8_t rpc_vers_minor;
	enum dcerpc_pkt_type ptype;
	uint8_t pfc_flags;
	uint8_t drep[4];
	uint16_t frag_length;
	uint16_t auth_length;
	uint32_t call_id;
	union dcerpc_payload u;/* [switch_is(ptype)] */
}/* [public] */;

struct ncadg_packet {
	uint8_t rpc_vers;
	uint8_t ptype;
	uint8_t pfc_flags;
	uint8_t ncadg_flags;
	uint8_t drep[3];
	uint8_t serial_high;
	struct GUID object;
	struct GUID iface;
	struct GUID activity;
	uint32_t server_boot;
	uint32_t iface_version;
	uint32_t seq_num;
	uint16_t opnum;
	uint16_t ihint;
	uint16_t ahint;
	uint16_t len;
	uint16_t fragnum;
	uint8_t auth_proto;
	uint8_t serial_low;
	union dcerpc_payload u;/* [switch_is(ptype)] */
}/* [public] */;

#endif /* _HEADER_dcerpc */
